% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_mofa.R
\name{get_default_model_options}
\alias{get_default_model_options}
\title{Get default model options}
\usage{
get_default_model_options(object)
}
\arguments{
\item{object}{an untrained \code{\link{MOFA}} object}
}
\value{
Returns a list with the default model options.
}
\description{
Function to obtain the default model options.
}
\details{
This function provides a default set of model options that can be modified and passed to the \code{\link{MOFA}} object
in the \code{\link{prepare_mofa}} step (see example), i.e. after creating a \code{\link{MOFA}} object
 (using \code{\link{create_mofa}}) and before starting the training (using \code{\link{run_mofa}})
The model options are the following: \cr
\itemize{
 \item{\strong{likelihoods}:}{ character vector with data likelihoods per view: 
 'gaussian' for continuous data (Default for all views), 'bernoulli' for binary data and 'poisson' for count data.}
 \item{\strong{num_factors}:}{ numeric value indicating the (initial) number of factors. Default is 15.}
 \item{\strong{spikeslab_factors}:}{ logical indicating whether to use spike and slab sparsity on the factors (Default is FALSE)}
 \item{\strong{spikeslab_weights}:}{ logical indicating whether to use spike and slab sparsity on the weights (Default is TRUE)}
 \item{\strong{ard_factors}:}{ logical indicating whether to use ARD sparsity on the factors (Default is TRUE only if using multiple groups)}
 \item{\strong{ard_weights}:}{ logical indicating whether to use ARD sparsity on the weights (Default is TRUE)}
 }
}
\examples{
# Using an existing simulated data with two groups and two views
file <- system.file("extdata", "test_data.RData", package = "MOFA2")

# Load data dt (in data.frame format)
load(file) 

# Create the MOFA object
MOFAmodel <- create_mofa(dt)

# Load default model options
model_opts <- get_default_model_options(MOFAmodel)

# Edit some of the model options
model_opts$num_factors <- 10
model_opts$spikeslab_weights <- FALSE

# Prepare the MOFA object
MOFAmodel <- prepare_mofa(MOFAmodel, model_options = model_opts)
}
