inline StringVect &ModBase::base()
{
    return d_base;
}

inline size_t ModBase::cost() const
{
    return d_cost;
}

    // by loop/use.cc
inline void ModBase::count(size_t round)
{
    ++d_count[round];
}

inline bool ModBase::defined() const
{
    return d_defined;
}

inline size_t ModBase::falsePositive(size_t round) const
{
    return d_falsePositives[round];
}

inline size_t ModBase::truePositive(size_t round) const
{
    return d_truePositives[round];
}

inline size_t ModBase::falseNegative(size_t round) const
{
    return d_falseNegatives[round];
}

inline size_t ModBase::trueNegative(size_t round) const
{
    return d_trueNegatives[round];
}

inline void ModBase::addFalsePositive(size_t round)
{
    ++d_falsePositives[round];
}

inline void ModBase::addTruePositive(size_t round)
{
    ++d_truePositives[round];
}

inline void ModBase::addFalseNegative(size_t round)
{
    ++d_falseNegatives[round];
}

inline void ModBase::addTrueNegative(size_t round)
{
    ++d_trueNegatives[round];
}

inline std::string const &ModBase::id() const
{
    return d_id;
}

inline uint16_t ModBase::value() const
{
    return d_value;
}

inline double ModBase::dose(uint16_t idx) const
{
    return vDose(idx);
}

inline size_t ModBase::operator[](size_t idx) const
{
    return d_count[idx];
}

inline double ModBase::sensitivity(size_t idx) const
{
    return vSensitivity(idx);
}

inline double ModBase::specificity(double age) const
{
    return vSpecificity(age);
}

inline void ModBase::vary(std::ostream &out)
{
    return vVary(out);
}

