"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initialGlyphsFromUnicodeSet = initialGlyphsFromUnicodeSet;
exports.createSubsetRectifier = createSubsetRectifier;
const Trace = require("@ot-builder/trace");
function initialGlyphsFromUnicodeSet(font, unicodeSet, fAddNotDef = true, fAddNull = false) {
    const gOrd = font.glyphs.decideOrder();
    const init = new Set();
    if (fAddNotDef && gOrd.length > 0)
        init.add(gOrd.at(0)); // keep NOTDEF
    if (fAddNull && gOrd.length > 1)
        init.add(gOrd.at(1)); // keep .NULL
    if (font.cmap) {
        for (const [u, glyph] of font.cmap.unicode.entries()) {
            if (unicodeSet.has(u))
                init.add(glyph);
        }
        for (const [u, s, glyph] of font.cmap.vs.entries()) {
            if (unicodeSet.has(u))
                init.add(glyph);
            if (unicodeSet.has(s))
                init.add(glyph);
        }
    }
    return init;
}
function createSubsetRectifier(font, unicodeSet) {
    const init = initialGlyphsFromUnicodeSet(font, unicodeSet);
    const collected = Trace.traceGlyphs(new Set(init), font);
    return {
        glyphs: Array.from(font.glyphs.decideOrder()).filter(x => collected.has(x)),
        rectifier: {
            glyphRef(g) {
                if (collected.has(g))
                    return g;
                else
                    return undefined;
            }
        }
    };
}
//# sourceMappingURL=initial-visible-glyphs.js.map