import { BinaryView } from "@ot-builder/bin-util";
import * as CffInterp from "./ir";
declare abstract class BinaryIrSource implements CffInterp.IrSource {
    protected view: BinaryView;
    private startCursor;
    private endCursor;
    constructor(rawView: BinaryView, size: number);
    protected eof(): boolean;
    abstract next(): CffInterp.IR | null;
}
export declare class CffDictIrSource extends BinaryIrSource {
    protected cffDictNibbles(): CffInterp.Operand;
    next(): CffInterp.Operator | CffInterp.Operand | null;
}
export declare class CharStringIrSource extends BinaryIrSource implements CffInterp.IrFlagPuller {
    next(): CffInterp.Operator | CffInterp.Operand | null;
    private isOperator;
    private parseOperator;
    pullFlags(stemCount: number): number[];
}
export {};
//# sourceMappingURL=ir-source.d.ts.map