//----------------------------------------------------------------------------
// Anti-Grain Geometry - Version 2.4 (Public License)
// Copyright (C) 2002-2005 Maxim Shemanarev (http://www.antigrain.com)
//
// Anti-Grain Geometry - Version 2.4 Release Milano 3 (AggPas 2.4 RM3)
// Pascal Port By: Milan Marusinec alias Milano
//                 milan@marusinec.sk
//                 http://www.aggpas.org
// Copyright (c) 2005-2006
//
// Permission to copy, use, modify, sell and distribute this software
// is granted provided this copyright notice appears in all copies.
// This software is provided "as is" without express or implied
// warranty, and with no claim as to its suitability for any purpose.
//
//----------------------------------------------------------------------------
// Contact: mcseem@antigrain.com
//          mcseemagg@yahoo.com
//          http://www.antigrain.com
//
// [Pascal Port History] -----------------------------------------------------
//
// 13.02.2006-Milano: Unit port establishment
//
{ agg_embedded_raster_fonts.pas }
unit
 agg_embedded_raster_fonts ;

INTERFACE

{$I agg_mode.inc }

uses
 agg_basics ;

{ GLOBAL VARIABLES & CONSTANTS }
const
 gse4x6 : array[0..868 ] of int8u = (
  6, 0, 32, 128-32,

  $00,$00,$07,$00,$0e,$00,$15,$00,$1c,$00,$23,$00,$2a,$00,$31,$00,$38,$00,
  $3f,$00,$46,$00,$4d,$00,$54,$00,$5b,$00,$62,$00,$69,$00,$70,$00,$77,$00,
  $7e,$00,$85,$00,$8c,$00,$93,$00,$9a,$00,$a1,$00,$a8,$00,$af,$00,$b6,$00,
  $bd,$00,$c4,$00,$cb,$00,$d2,$00,$d9,$00,$e0,$00,$e7,$00,$ee,$00,$f5,$00,
  $fc,$00,$03,$01,$0a,$01,$11,$01,$18,$01,$1f,$01,$26,$01,$2d,$01,$34,$01,
  $3b,$01,$42,$01,$49,$01,$50,$01,$57,$01,$5e,$01,$65,$01,$6c,$01,$73,$01,
  $7a,$01,$81,$01,$88,$01,$8f,$01,$96,$01,$9d,$01,$a4,$01,$ab,$01,$b2,$01,
  $b9,$01,$c0,$01,$c7,$01,$ce,$01,$d5,$01,$dc,$01,$e3,$01,$ea,$01,$f1,$01,
  $f8,$01,$ff,$01,$06,$02,$0d,$02,$14,$02,$1b,$02,$22,$02,$29,$02,$30,$02,
  $37,$02,$3e,$02,$45,$02,$4c,$02,$53,$02,$5a,$02,$61,$02,$68,$02,$6f,$02,
  $76,$02,$7d,$02,$84,$02,$8b,$02,$92,$02,$99,$02,

  4, // $20 ' '
  $00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $40,$40,$40,$00,$40,$00,

  4, // $22 '"'
  $a0,$a0,$00,$00,$00,$00,

  4, // $23 '#'
  $60,$f0,$60,$f0,$60,$00,

  4, // $24 '$'
  $40,$60,$c0,$60,$c0,$40,

  4, // $25 '%'
  $a0,$20,$40,$80,$a0,$00,

  4, // $26 '&'
  $e0,$a0,$50,$a0,$d0,$00,

  4, // $27 '''
  $40,$40,$00,$00,$00,$00,

  4, // $28 '('
  $20,$40,$40,$40,$20,$00,

  4, // $29 ')'
  $40,$20,$20,$20,$40,$00,

  4, // $2a '*'
  $a0,$40,$e0,$40,$a0,$00,

  4, // $2b '+'
  $40,$40,$e0,$40,$40,$00,

  4, // $2c ','
  $00,$00,$00,$40,$40,$80,

  4, // $2d '-'
  $00,$00,$e0,$00,$00,$00,

  4, // $2e '.'
  $00,$00,$00,$00,$40,$00,

  4, // $2f '/'
  $10,$20,$20,$40,$40,$80,

  4, // $30 '0'
  $e0,$a0,$a0,$a0,$e0,$00,

  4, // $31 '1'
  $40,$c0,$40,$40,$e0,$00,

  4, // $32 '2'
  $e0,$a0,$20,$40,$e0,$00,

  4, // $33 '3'
  $e0,$20,$40,$20,$e0,$00,

  4, // $34 '4'
  $a0,$a0,$e0,$20,$20,$00,

  4, // $35 '5'
  $e0,$80,$c0,$20,$c0,$00,

  4, // $36 '6'
  $40,$80,$e0,$a0,$e0,$00,

  4, // $37 '7'
  $e0,$a0,$20,$40,$40,$00,

  4, // $38 '8'
  $e0,$a0,$40,$a0,$e0,$00,

  4, // $39 '9'
  $e0,$a0,$e0,$20,$c0,$00,

  4, // $3a ':'
  $00,$40,$00,$40,$00,$00,

  4, // $3b ';'
  $00,$40,$00,$40,$40,$80,

  4, // $3c '<'
  $20,$40,$80,$40,$20,$00,

  4, // $3d '='
  $00,$e0,$00,$e0,$00,$00,

  4, // $3e '>'
  $80,$40,$20,$40,$80,$00,

  4, // $3f '?'
  $c0,$20,$40,$00,$40,$00,

  4, // $40 '@'
  $40,$a0,$e0,$e0,$80,$60,

  4, // $41 'A'
  $40,$a0,$e0,$a0,$a0,$00,

  4, // $42 'B'
  $c0,$a0,$c0,$a0,$c0,$00,

  4, // $43 'C'
  $60,$80,$80,$80,$60,$00,

  4, // $44 'D'
  $c0,$a0,$a0,$a0,$c0,$00,

  4, // $45 'E'
  $e0,$80,$c0,$80,$e0,$00,

  4, // $46 'F'
  $e0,$80,$c0,$80,$80,$00,

  4, // $47 'G'
  $60,$80,$a0,$a0,$40,$00,

  4, // $48 'H'
  $a0,$a0,$e0,$a0,$a0,$00,

  4, // $49 'I'
  $e0,$40,$40,$40,$e0,$00,

  4, // $4a 'J'
  $20,$20,$20,$20,$a0,$40,

  4, // $4b 'K'
  $a0,$a0,$c0,$c0,$a0,$00,

  4, // $4c 'L'
  $80,$80,$80,$80,$e0,$00,

  4, // $4d 'M'
  $a0,$e0,$a0,$a0,$a0,$00,

  4, // $4e 'N'
  $90,$d0,$b0,$90,$90,$00,

  4, // $4f 'O'
  $40,$a0,$a0,$a0,$40,$00,

  4, // $50 'P'
  $c0,$a0,$a0,$c0,$80,$00,

  4, // $51 'Q'
  $40,$a0,$a0,$a0,$60,$00,

  4, // $52 'R'
  $c0,$a0,$a0,$c0,$a0,$00,

  4, // $53 'S'
  $60,$80,$40,$20,$c0,$00,

  4, // $54 'T'
  $e0,$40,$40,$40,$40,$00,

  4, // $55 'U'
  $a0,$a0,$a0,$a0,$e0,$00,

  4, // $56 'V'
  $a0,$a0,$a0,$a0,$40,$00,

  4, // $57 'W'
  $a0,$a0,$a0,$e0,$a0,$00,

  4, // $58 'X'
  $a0,$a0,$40,$a0,$a0,$00,

  4, // $59 'Y'
  $a0,$a0,$40,$40,$40,$00,

  4, // $5a 'Z'
  $e0,$20,$40,$80,$e0,$00,

  4, // $5b '['
  $c0,$80,$80,$80,$c0,$00,

  4, // $5c '\'
  $80,$40,$40,$20,$20,$10,

  4, // $5d ']'
  $c0,$40,$40,$40,$c0,$00,

  4, // $5e '^'
  $40,$a0,$00,$00,$00,$00,

  4, // $5f '_'
  $00,$00,$00,$00,$00,$f0,

  4, // $60 '`'
  $40,$20,$00,$00,$00,$00,

  4, // $61 'a'
  $00,$60,$a0,$a0,$70,$00,

  4, // $62 'b'
  $80,$80,$c0,$a0,$c0,$00,

  4, // $63 'c'
  $00,$60,$80,$80,$60,$00,

  4, // $64 'd'
  $20,$20,$60,$a0,$60,$00,

  4, // $65 'e'
  $00,$40,$e0,$80,$60,$00,

  4, // $66 'f'
  $20,$40,$e0,$40,$40,$00,

  4, // $67 'g'
  $00,$60,$a0,$60,$20,$c0,

  4, // $68 'h'
  $80,$80,$c0,$a0,$a0,$00,

  4, // $69 'i'
  $40,$00,$c0,$40,$e0,$00,

  4, // $6a 'j'
  $40,$00,$c0,$40,$40,$80,

  4, // $6b 'k'
  $80,$80,$a0,$c0,$a0,$00,

  4, // $6c 'l'
  $c0,$40,$40,$40,$e0,$00,

  4, // $6d 'm'
  $00,$a0,$f0,$f0,$90,$00,

  4, // $6e 'n'
  $00,$c0,$a0,$a0,$a0,$00,

  4, // $6f 'o'
  $00,$40,$a0,$a0,$40,$00,

  4, // $70 'p'
  $00,$c0,$a0,$c0,$80,$80,

  4, // $71 'q'
  $00,$60,$a0,$60,$20,$20,

  4, // $72 'r'
  $00,$a0,$50,$40,$40,$00,

  4, // $73 's'
  $00,$60,$c0,$20,$c0,$00,

  4, // $74 't'
  $40,$40,$e0,$40,$60,$00,

  4, // $75 'u'
  $00,$a0,$a0,$a0,$60,$00,

  4, // $76 'v'
  $00,$a0,$a0,$a0,$40,$00,

  4, // $77 'w'
  $00,$a0,$a0,$e0,$a0,$00,

  4, // $78 'x'
  $00,$a0,$40,$a0,$a0,$00,

  4, // $79 'y'
  $00,$a0,$a0,$60,$20,$c0,

  4, // $7a 'z'
  $00,$e0,$40,$80,$e0,$00,

  4, // $7b '{'
  $30,$20,$c0,$20,$30,$00,

  4, // $7c '|'
  $40,$40,$00,$40,$40,$40,

  4, // $7d '}'
  $c0,$40,$30,$40,$c0,$00,

  4, // $7e '~'
  $50,$a0,$00,$00,$00,$00,

  4, // $7f ''
  $00,$60,$90,$f0,$00,$00,
  0 );

 gse4x8 : array[0..1060 ] of int8u = (
  8, 0, 32, 128-32,

  $00,$00,$09,$00,$12,$00,$1b,$00,$24,$00,$2d,$00,$36,$00,$3f,$00,$48,$00,
  $51,$00,$5a,$00,$63,$00,$6c,$00,$75,$00,$7e,$00,$87,$00,$90,$00,$99,$00,
  $a2,$00,$ab,$00,$b4,$00,$bd,$00,$c6,$00,$cf,$00,$d8,$00,$e1,$00,$ea,$00,
  $f3,$00,$fc,$00,$05,$01,$0e,$01,$17,$01,$20,$01,$29,$01,$32,$01,$3b,$01,
  $44,$01,$4d,$01,$56,$01,$5f,$01,$68,$01,$71,$01,$7a,$01,$83,$01,$8c,$01,
  $95,$01,$9e,$01,$a7,$01,$b0,$01,$b9,$01,$c2,$01,$cb,$01,$d4,$01,$dd,$01,
  $e6,$01,$ef,$01,$f8,$01,$01,$02,$0a,$02,$13,$02,$1c,$02,$25,$02,$2e,$02,
  $37,$02,$40,$02,$49,$02,$52,$02,$5b,$02,$64,$02,$6d,$02,$76,$02,$7f,$02,
  $88,$02,$91,$02,$9a,$02,$a3,$02,$ac,$02,$b5,$02,$be,$02,$c7,$02,$d0,$02,
  $d9,$02,$e2,$02,$eb,$02,$f4,$02,$fd,$02,$06,$03,$0f,$03,$18,$03,$21,$03,
  $2a,$03,$33,$03,$3c,$03,$45,$03,$4e,$03,$57,$03,

  4, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $00,$40,$40,$40,$40,$00,$40,$00,

  4, // $22 '"'
  $00,$a0,$a0,$00,$00,$00,$00,$00,

  4, // $23 '#'
  $60,$60,$f0,$60,$60,$f0,$60,$60,

  4, // $24 '$'
  $40,$60,$c0,$c0,$60,$60,$c0,$40,

  4, // $25 '%'
  $00,$a0,$20,$40,$40,$80,$a0,$00,

  4, // $26 '&'
  $00,$40,$a0,$a0,$40,$b0,$a0,$70,

  4, // $27 '''
  $00,$40,$40,$00,$00,$00,$00,$00,

  4, // $28 '('
  $20,$40,$80,$80,$80,$80,$40,$20,

  4, // $29 ')'
  $80,$40,$20,$20,$20,$20,$40,$80,

  4, // $2a '*'
  $00,$a0,$40,$e0,$40,$a0,$00,$00,

  4, // $2b '+'
  $00,$40,$40,$e0,$40,$40,$00,$00,

  4, // $2c ','
  $00,$00,$00,$00,$00,$40,$40,$80,

  4, // $2d '-'
  $00,$00,$00,$e0,$00,$00,$00,$00,

  4, // $2e '.'
  $00,$00,$00,$00,$00,$00,$40,$00,

  4, // $2f '/'
  $10,$10,$20,$20,$40,$40,$80,$80,

  4, // $30 '0'
  $00,$e0,$a0,$a0,$a0,$a0,$e0,$00,

  4, // $31 '1'
  $00,$40,$c0,$40,$40,$40,$e0,$00,

  4, // $32 '2'
  $00,$e0,$a0,$20,$40,$80,$e0,$00,

  4, // $33 '3'
  $00,$e0,$20,$40,$20,$20,$e0,$00,

  4, // $34 '4'
  $00,$60,$a0,$a0,$f0,$20,$20,$00,

  4, // $35 '5'
  $00,$e0,$80,$c0,$20,$20,$c0,$00,

  4, // $36 '6'
  $00,$40,$80,$e0,$a0,$a0,$e0,$00,

  4, // $37 '7'
  $00,$e0,$a0,$20,$40,$40,$40,$00,

  4, // $38 '8'
  $00,$e0,$a0,$40,$a0,$a0,$e0,$00,

  4, // $39 '9'
  $00,$e0,$a0,$e0,$20,$20,$40,$00,

  4, // $3a ':'
  $00,$00,$40,$00,$00,$40,$00,$00,

  4, // $3b ';'
  $00,$00,$40,$00,$00,$40,$40,$80,

  4, // $3c '<'
  $00,$20,$40,$80,$40,$20,$00,$00,

  4, // $3d '='
  $00,$00,$e0,$00,$e0,$00,$00,$00,

  4, // $3e '>'
  $00,$80,$40,$20,$40,$80,$00,$00,

  4, // $3f '?'
  $00,$40,$a0,$20,$40,$00,$40,$00,

  4, // $40 '@'
  $00,$40,$a0,$e0,$e0,$80,$60,$00,

  4, // $41 'A'
  $00,$40,$a0,$a0,$e0,$a0,$a0,$00,

  4, // $42 'B'
  $00,$c0,$a0,$c0,$a0,$a0,$c0,$00,

  4, // $43 'C'
  $00,$40,$a0,$80,$80,$a0,$40,$00,

  4, // $44 'D'
  $00,$c0,$a0,$a0,$a0,$a0,$c0,$00,

  4, // $45 'E'
  $00,$e0,$80,$c0,$80,$80,$e0,$00,

  4, // $46 'F'
  $00,$e0,$80,$c0,$80,$80,$80,$00,

  4, // $47 'G'
  $00,$60,$80,$a0,$a0,$a0,$40,$00,

  4, // $48 'H'
  $00,$a0,$a0,$e0,$a0,$a0,$a0,$00,

  4, // $49 'I'
  $00,$e0,$40,$40,$40,$40,$e0,$00,

  4, // $4a 'J'
  $00,$20,$20,$20,$20,$a0,$40,$00,

  4, // $4b 'K'
  $00,$a0,$a0,$c0,$c0,$a0,$a0,$00,

  4, // $4c 'L'
  $00,$80,$80,$80,$80,$80,$e0,$00,

  4, // $4d 'M'
  $00,$a0,$e0,$a0,$a0,$a0,$a0,$00,

  4, // $4e 'N'
  $00,$90,$90,$d0,$b0,$90,$90,$00,

  4, // $4f 'O'
  $00,$40,$a0,$a0,$a0,$a0,$40,$00,

  4, // $50 'P'
  $00,$c0,$a0,$a0,$c0,$80,$80,$00,

  4, // $51 'Q'
  $00,$40,$a0,$a0,$a0,$a0,$60,$00,

  4, // $52 'R'
  $00,$c0,$a0,$a0,$c0,$c0,$a0,$00,

  4, // $53 'S'
  $00,$60,$80,$40,$20,$20,$c0,$00,

  4, // $54 'T'
  $00,$e0,$40,$40,$40,$40,$40,$00,

  4, // $55 'U'
  $00,$a0,$a0,$a0,$a0,$a0,$40,$00,

  4, // $56 'V'
  $00,$a0,$a0,$a0,$a0,$40,$40,$00,

  4, // $57 'W'
  $00,$a0,$a0,$a0,$a0,$e0,$a0,$00,

  4, // $58 'X'
  $00,$a0,$a0,$40,$a0,$a0,$a0,$00,

  4, // $59 'Y'
  $00,$a0,$a0,$40,$40,$40,$40,$00,

  4, // $5a 'Z'
  $00,$e0,$20,$40,$40,$80,$e0,$00,

  4, // $5b '['
  $c0,$80,$80,$80,$80,$80,$80,$c0,

  4, // $5c '\'
  $80,$80,$40,$40,$20,$20,$10,$10,

  4, // $5d ']'
  $c0,$40,$40,$40,$40,$40,$40,$c0,

  4, // $5e '^'
  $00,$40,$a0,$00,$00,$00,$00,$00,

  4, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$f0,

  4, // $60 '`'
  $00,$40,$20,$00,$00,$00,$00,$00,

  4, // $61 'a'
  $00,$00,$60,$a0,$a0,$a0,$70,$00,

  4, // $62 'b'
  $00,$80,$80,$c0,$a0,$a0,$c0,$00,

  4, // $63 'c'
  $00,$00,$40,$a0,$80,$a0,$40,$00,

  4, // $64 'd'
  $00,$20,$20,$60,$a0,$a0,$60,$00,

  4, // $65 'e'
  $00,$00,$40,$a0,$e0,$80,$60,$00,

  4, // $66 'f'
  $00,$20,$40,$40,$e0,$40,$40,$00,

  4, // $67 'g'
  $00,$00,$60,$a0,$a0,$60,$20,$c0,

  4, // $68 'h'
  $00,$80,$80,$c0,$a0,$a0,$a0,$00,

  4, // $69 'i'
  $00,$40,$00,$c0,$40,$40,$e0,$00,

  4, // $6a 'j'
  $00,$40,$00,$c0,$40,$40,$40,$80,

  4, // $6b 'k'
  $00,$80,$80,$a0,$c0,$c0,$a0,$00,

  4, // $6c 'l'
  $00,$c0,$40,$40,$40,$40,$e0,$00,

  4, // $6d 'm'
  $00,$00,$a0,$f0,$f0,$f0,$90,$00,

  4, // $6e 'n'
  $00,$00,$c0,$a0,$a0,$a0,$a0,$00,

  4, // $6f 'o'
  $00,$00,$40,$a0,$a0,$a0,$40,$00,

  4, // $70 'p'
  $00,$00,$c0,$a0,$a0,$c0,$80,$80,

  4, // $71 'q'
  $00,$00,$60,$a0,$a0,$60,$20,$20,

  4, // $72 'r'
  $00,$00,$a0,$50,$40,$40,$40,$00,

  4, // $73 's'
  $00,$00,$60,$80,$40,$20,$c0,$00,

  4, // $74 't'
  $00,$40,$40,$e0,$40,$40,$20,$00,

  4, // $75 'u'
  $00,$00,$a0,$a0,$a0,$a0,$60,$00,

  4, // $76 'v'
  $00,$00,$a0,$a0,$a0,$40,$40,$00,

  4, // $77 'w'
  $00,$00,$a0,$a0,$a0,$e0,$a0,$00,

  4, // $78 'x'
  $00,$00,$a0,$a0,$40,$a0,$a0,$00,

  4, // $79 'y'
  $00,$00,$a0,$a0,$a0,$60,$20,$c0,

  4, // $7a 'z'
  $00,$00,$e0,$20,$40,$80,$e0,$00,

  4, // $7b '{'
  $10,$20,$20,$c0,$20,$20,$10,$00,

  4, // $7c '|'
  $00,$40,$40,$40,$00,$40,$40,$40,

  4, // $7d '}'
  $80,$40,$40,$30,$40,$40,$80,$00,

  4, // $7e '~'
  $00,$50,$a0,$00,$00,$00,$00,$00,

  4, // $7f ''
  $00,$00,$00,$60,$90,$f0,$00,$00,
  0 );

 gse5x7 : array[0..964 ] of int8u = (
  7, 0, 32, 128-32,

  $00,$00,$08,$00,$10,$00,$18,$00,$20,$00,$28,$00,$30,$00,$38,$00,$40,$00,
  $48,$00,$50,$00,$58,$00,$60,$00,$68,$00,$70,$00,$78,$00,$80,$00,$88,$00,
  $90,$00,$98,$00,$a0,$00,$a8,$00,$b0,$00,$b8,$00,$c0,$00,$c8,$00,$d0,$00,
  $d8,$00,$e0,$00,$e8,$00,$f0,$00,$f8,$00,$00,$01,$08,$01,$10,$01,$18,$01,
  $20,$01,$28,$01,$30,$01,$38,$01,$40,$01,$48,$01,$50,$01,$58,$01,$60,$01,
  $68,$01,$70,$01,$78,$01,$80,$01,$88,$01,$90,$01,$98,$01,$a0,$01,$a8,$01,
  $b0,$01,$b8,$01,$c0,$01,$c8,$01,$d0,$01,$d8,$01,$e0,$01,$e8,$01,$f0,$01,
  $f8,$01,$00,$02,$08,$02,$10,$02,$18,$02,$20,$02,$28,$02,$30,$02,$38,$02,
  $40,$02,$48,$02,$50,$02,$58,$02,$60,$02,$68,$02,$70,$02,$78,$02,$80,$02,
  $88,$02,$90,$02,$98,$02,$a0,$02,$a8,$02,$b0,$02,$b8,$02,$c0,$02,$c8,$02,
  $d0,$02,$d8,$02,$e0,$02,$e8,$02,$f0,$02,$f8,$02,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$20,$20,$20,$00,$20,$00,

  5, // $22 '"'
  $00,$50,$50,$00,$00,$00,$00,

  5, // $23 '#'
  $00,$50,$f8,$50,$f8,$50,$00,

  5, // $24 '$'
  $20,$78,$a0,$70,$28,$f0,$20,

  5, // $25 '%'
  $00,$88,$10,$20,$40,$88,$00,

  5, // $26 '&'
  $00,$40,$a0,$68,$90,$68,$00,

  5, // $27 '''
  $00,$20,$20,$00,$00,$00,$00,

  5, // $28 '('
  $10,$20,$40,$40,$40,$20,$10,

  5, // $29 ')'
  $80,$40,$20,$20,$20,$40,$80,

  5, // $2a '*'
  $00,$20,$a8,$70,$a8,$20,$00,

  5, // $2b '+'
  $00,$20,$20,$f8,$20,$20,$00,

  5, // $2c ','
  $00,$00,$00,$00,$20,$20,$40,

  5, // $2d '-'
  $00,$00,$00,$f0,$00,$00,$00,

  5, // $2e '.'
  $00,$00,$00,$00,$00,$40,$00,

  5, // $2f '/'
  $00,$08,$10,$20,$40,$80,$00,

  5, // $30 '0'
  $00,$60,$90,$90,$90,$60,$00,

  5, // $31 '1'
  $00,$20,$60,$20,$20,$70,$00,

  5, // $32 '2'
  $00,$60,$90,$20,$40,$f0,$00,

  5, // $33 '3'
  $00,$f0,$20,$60,$10,$e0,$00,

  5, // $34 '4'
  $00,$30,$50,$90,$f0,$10,$00,

  5, // $35 '5'
  $00,$f0,$80,$e0,$10,$e0,$00,

  5, // $36 '6'
  $00,$60,$80,$e0,$90,$60,$00,

  5, // $37 '7'
  $00,$f0,$90,$20,$40,$40,$00,

  5, // $38 '8'
  $00,$60,$90,$60,$90,$60,$00,

  5, // $39 '9'
  $00,$60,$90,$70,$10,$60,$00,

  5, // $3a ':'
  $00,$00,$20,$00,$20,$00,$00,

  5, // $3b ';'
  $00,$00,$20,$00,$20,$20,$40,

  5, // $3c '<'
  $00,$10,$20,$40,$20,$10,$00,

  5, // $3d '='
  $00,$00,$f0,$00,$f0,$00,$00,

  5, // $3e '>'
  $00,$80,$40,$20,$40,$80,$00,

  5, // $3f '?'
  $00,$60,$90,$20,$00,$20,$00,

  5, // $40 '@'
  $00,$60,$90,$b0,$80,$70,$00,

  5, // $41 'A'
  $00,$60,$90,$f0,$90,$90,$00,

  5, // $42 'B'
  $00,$e0,$90,$e0,$90,$e0,$00,

  5, // $43 'C'
  $00,$60,$90,$80,$90,$60,$00,

  5, // $44 'D'
  $00,$e0,$90,$90,$90,$e0,$00,

  5, // $45 'E'
  $00,$f0,$80,$e0,$80,$f0,$00,

  5, // $46 'F'
  $00,$f0,$80,$e0,$80,$80,$00,

  5, // $47 'G'
  $00,$70,$80,$b0,$90,$60,$00,

  5, // $48 'H'
  $00,$90,$90,$f0,$90,$90,$00,

  5, // $49 'I'
  $00,$70,$20,$20,$20,$70,$00,

  5, // $4a 'J'
  $00,$70,$20,$20,$a0,$40,$00,

  5, // $4b 'K'
  $00,$90,$a0,$c0,$a0,$90,$00,

  5, // $4c 'L'
  $00,$80,$80,$80,$80,$f0,$00,

  5, // $4d 'M'
  $00,$90,$f0,$90,$90,$90,$00,

  5, // $4e 'N'
  $00,$90,$d0,$b0,$90,$90,$00,

  5, // $4f 'O'
  $00,$60,$90,$90,$90,$60,$00,

  5, // $50 'P'
  $00,$e0,$90,$e0,$80,$80,$00,

  5, // $51 'Q'
  $00,$60,$90,$90,$a0,$50,$00,

  5, // $52 'R'
  $00,$e0,$90,$e0,$a0,$90,$00,

  5, // $53 'S'
  $00,$70,$80,$60,$10,$e0,$00,

  5, // $54 'T'
  $00,$70,$20,$20,$20,$20,$00,

  5, // $55 'U'
  $00,$90,$90,$90,$90,$60,$00,

  5, // $56 'V'
  $00,$50,$50,$50,$20,$20,$00,

  5, // $57 'W'
  $00,$90,$90,$90,$f0,$90,$00,

  5, // $58 'X'
  $00,$90,$90,$60,$90,$90,$00,

  5, // $59 'Y'
  $00,$50,$50,$20,$20,$20,$00,

  5, // $5a 'Z'
  $00,$f0,$10,$20,$40,$f0,$00,

  5, // $5b '['
  $70,$40,$40,$40,$40,$40,$70,

  5, // $5c '\'
  $00,$80,$40,$20,$10,$08,$00,

  5, // $5d ']'
  $e0,$20,$20,$20,$20,$20,$e0,

  5, // $5e '^'
  $00,$20,$50,$00,$00,$00,$00,

  5, // $5f '_'
  $00,$00,$00,$00,$00,$f8,$00,

  5, // $60 '`'
  $00,$40,$20,$00,$00,$00,$00,

  5, // $61 'a'
  $00,$00,$60,$a0,$a0,$50,$00,

  5, // $62 'b'
  $00,$80,$80,$e0,$90,$e0,$00,

  5, // $63 'c'
  $00,$00,$70,$80,$80,$70,$00,

  5, // $64 'd'
  $00,$10,$10,$70,$90,$70,$00,

  5, // $65 'e'
  $00,$00,$60,$f0,$80,$70,$00,

  5, // $66 'f'
  $00,$30,$40,$e0,$40,$40,$00,

  5, // $67 'g'
  $00,$00,$70,$90,$70,$10,$60,

  5, // $68 'h'
  $00,$80,$80,$e0,$90,$90,$00,

  5, // $69 'i'
  $20,$00,$60,$20,$20,$70,$00,

  5, // $6a 'j'
  $20,$00,$60,$20,$20,$a0,$40,

  5, // $6b 'k'
  $80,$80,$90,$a0,$e0,$90,$00,

  5, // $6c 'l'
  $00,$60,$20,$20,$20,$70,$00,

  5, // $6d 'm'
  $00,$00,$a0,$f0,$f0,$90,$00,

  5, // $6e 'n'
  $00,$00,$a0,$d0,$90,$90,$00,

  5, // $6f 'o'
  $00,$00,$60,$90,$90,$60,$00,

  5, // $70 'p'
  $00,$00,$e0,$90,$e0,$80,$80,

  5, // $71 'q'
  $00,$00,$70,$90,$70,$10,$10,

  5, // $72 'r'
  $00,$00,$e0,$90,$80,$80,$00,

  5, // $73 's'
  $00,$00,$70,$e0,$10,$e0,$00,

  5, // $74 't'
  $40,$40,$e0,$40,$40,$70,$00,

  5, // $75 'u'
  $00,$00,$90,$90,$90,$70,$00,

  5, // $76 'v'
  $00,$00,$50,$50,$50,$20,$00,

  5, // $77 'w'
  $00,$00,$90,$90,$f0,$90,$00,

  5, // $78 'x'
  $00,$00,$90,$60,$60,$90,$00,

  5, // $79 'y'
  $00,$00,$90,$90,$70,$10,$60,

  5, // $7a 'z'
  $00,$00,$f0,$20,$40,$f0,$00,

  5, // $7b '{'
  $10,$20,$20,$c0,$20,$20,$10,

  5, // $7c '|'
  $20,$20,$20,$00,$20,$20,$20,

  5, // $7d '}'
  $40,$20,$20,$18,$20,$20,$40,

  5, // $7e '~'
  $00,$40,$a8,$10,$00,$00,$00,

  5, // $7f ''
  $00,$00,$20,$50,$88,$f8,$00,
  0 );

 gse5x9 : array[0..1156 ] of int8u = (
  9, 0, 32, 128-32,

  $00,$00,$0a,$00,$14,$00,$1e,$00,$28,$00,$32,$00,$3c,$00,$46,$00,$50,$00,
  $5a,$00,$64,$00,$6e,$00,$78,$00,$82,$00,$8c,$00,$96,$00,$a0,$00,$aa,$00,
  $b4,$00,$be,$00,$c8,$00,$d2,$00,$dc,$00,$e6,$00,$f0,$00,$fa,$00,$04,$01,
  $0e,$01,$18,$01,$22,$01,$2c,$01,$36,$01,$40,$01,$4a,$01,$54,$01,$5e,$01,
  $68,$01,$72,$01,$7c,$01,$86,$01,$90,$01,$9a,$01,$a4,$01,$ae,$01,$b8,$01,
  $c2,$01,$cc,$01,$d6,$01,$e0,$01,$ea,$01,$f4,$01,$fe,$01,$08,$02,$12,$02,
  $1c,$02,$26,$02,$30,$02,$3a,$02,$44,$02,$4e,$02,$58,$02,$62,$02,$6c,$02,
  $76,$02,$80,$02,$8a,$02,$94,$02,$9e,$02,$a8,$02,$b2,$02,$bc,$02,$c6,$02,
  $d0,$02,$da,$02,$e4,$02,$ee,$02,$f8,$02,$02,$03,$0c,$03,$16,$03,$20,$03,
  $2a,$03,$34,$03,$3e,$03,$48,$03,$52,$03,$5c,$03,$66,$03,$70,$03,$7a,$03,
  $84,$03,$8e,$03,$98,$03,$a2,$03,$ac,$03,$b6,$03,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$20,$20,$20,$20,$20,$00,$20,$00,

  5, // $22 '"'
  $00,$50,$50,$00,$00,$00,$00,$00,$00,

  5, // $23 '#'
  $00,$50,$50,$f8,$50,$f8,$50,$50,$00,

  5, // $24 '$'
  $00,$20,$78,$a0,$70,$28,$f0,$20,$00,

  5, // $25 '%'
  $00,$c8,$c8,$10,$20,$40,$98,$98,$00,

  5, // $26 '&'
  $00,$40,$a0,$a0,$40,$a8,$90,$68,$00,

  5, // $27 '''
  $00,$20,$20,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $10,$20,$40,$40,$40,$40,$40,$20,$10,

  5, // $29 ')'
  $80,$40,$20,$20,$20,$20,$20,$40,$80,

  5, // $2a '*'
  $00,$00,$20,$a8,$70,$a8,$20,$00,$00,

  5, // $2b '+'
  $00,$00,$20,$20,$f8,$20,$20,$00,$00,

  5, // $2c ','
  $00,$00,$00,$00,$00,$00,$20,$20,$40,

  5, // $2d '-'
  $00,$00,$00,$00,$f0,$00,$00,$00,$00,

  5, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$40,$00,

  5, // $2f '/'
  $00,$10,$10,$20,$20,$40,$40,$80,$80,

  5, // $30 '0'
  $00,$60,$90,$b0,$d0,$90,$90,$60,$00,

  5, // $31 '1'
  $00,$20,$60,$20,$20,$20,$20,$70,$00,

  5, // $32 '2'
  $00,$60,$90,$10,$20,$40,$80,$f0,$00,

  5, // $33 '3'
  $00,$f0,$10,$20,$60,$10,$90,$60,$00,

  5, // $34 '4'
  $00,$30,$50,$90,$90,$f8,$10,$10,$00,

  5, // $35 '5'
  $00,$f0,$80,$e0,$10,$10,$10,$e0,$00,

  5, // $36 '6'
  $00,$60,$80,$e0,$90,$90,$90,$60,$00,

  5, // $37 '7'
  $00,$f0,$90,$10,$20,$40,$40,$40,$00,

  5, // $38 '8'
  $00,$60,$90,$90,$60,$90,$90,$60,$00,

  5, // $39 '9'
  $00,$60,$90,$90,$70,$10,$90,$60,$00,

  5, // $3a ':'
  $00,$00,$00,$20,$00,$00,$20,$00,$00,

  5, // $3b ';'
  $00,$00,$00,$20,$00,$00,$20,$20,$40,

  5, // $3c '<'
  $00,$10,$20,$40,$80,$40,$20,$10,$00,

  5, // $3d '='
  $00,$00,$00,$f0,$00,$f0,$00,$00,$00,

  5, // $3e '>'
  $00,$80,$40,$20,$10,$20,$40,$80,$00,

  5, // $3f '?'
  $00,$60,$90,$10,$20,$20,$00,$20,$00,

  5, // $40 '@'
  $00,$60,$90,$b0,$b0,$b0,$80,$70,$00,

  5, // $41 'A'
  $00,$60,$90,$90,$f0,$90,$90,$90,$00,

  5, // $42 'B'
  $00,$e0,$90,$90,$e0,$90,$90,$e0,$00,

  5, // $43 'C'
  $00,$60,$90,$80,$80,$80,$90,$60,$00,

  5, // $44 'D'
  $00,$e0,$90,$90,$90,$90,$90,$e0,$00,

  5, // $45 'E'
  $00,$f0,$80,$80,$e0,$80,$80,$f0,$00,

  5, // $46 'F'
  $00,$f0,$80,$80,$e0,$80,$80,$80,$00,

  5, // $47 'G'
  $00,$60,$90,$80,$b0,$90,$90,$60,$00,

  5, // $48 'H'
  $00,$90,$90,$90,$f0,$90,$90,$90,$00,

  5, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$70,$00,

  5, // $4a 'J'
  $00,$70,$20,$20,$20,$20,$a0,$40,$00,

  5, // $4b 'K'
  $00,$90,$90,$a0,$c0,$a0,$90,$90,$00,

  5, // $4c 'L'
  $00,$80,$80,$80,$80,$80,$80,$f0,$00,

  5, // $4d 'M'
  $00,$90,$f0,$90,$90,$90,$90,$90,$00,

  5, // $4e 'N'
  $00,$90,$90,$d0,$b0,$90,$90,$90,$00,

  5, // $4f 'O'
  $00,$60,$90,$90,$90,$90,$90,$60,$00,

  5, // $50 'P'
  $00,$e0,$90,$90,$e0,$80,$80,$80,$00,

  5, // $51 'Q'
  $00,$60,$90,$90,$90,$90,$a0,$50,$00,

  5, // $52 'R'
  $00,$e0,$90,$90,$e0,$a0,$90,$90,$00,

  5, // $53 'S'
  $00,$60,$90,$80,$60,$10,$90,$60,$00,

  5, // $54 'T'
  $00,$70,$20,$20,$20,$20,$20,$20,$00,

  5, // $55 'U'
  $00,$90,$90,$90,$90,$90,$90,$60,$00,

  5, // $56 'V'
  $00,$50,$50,$50,$50,$50,$20,$20,$00,

  5, // $57 'W'
  $00,$90,$90,$90,$90,$90,$f0,$90,$00,

  5, // $58 'X'
  $00,$90,$90,$60,$60,$90,$90,$90,$00,

  5, // $59 'Y'
  $00,$50,$50,$50,$20,$20,$20,$20,$00,

  5, // $5a 'Z'
  $00,$f0,$10,$10,$20,$40,$80,$f0,$00,

  5, // $5b '['
  $70,$40,$40,$40,$40,$40,$40,$70,$00,

  5, // $5c '\'
  $80,$80,$40,$40,$20,$20,$10,$10,$00,

  5, // $5d ']'
  $e0,$20,$20,$20,$20,$20,$20,$e0,$00,

  5, // $5e '^'
  $00,$20,$50,$88,$00,$00,$00,$00,$00,

  5, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$f8,$00,

  5, // $60 '`'
  $00,$40,$20,$00,$00,$00,$00,$00,$00,

  5, // $61 'a'
  $00,$00,$60,$10,$70,$90,$90,$70,$00,

  5, // $62 'b'
  $00,$80,$80,$e0,$90,$90,$90,$e0,$00,

  5, // $63 'c'
  $00,$00,$60,$90,$80,$80,$90,$60,$00,

  5, // $64 'd'
  $00,$10,$10,$70,$90,$90,$90,$70,$00,

  5, // $65 'e'
  $00,$00,$60,$90,$f0,$80,$80,$70,$00,

  5, // $66 'f'
  $00,$30,$40,$40,$e0,$40,$40,$40,$00,

  5, // $67 'g'
  $00,$00,$70,$90,$90,$70,$10,$90,$60,

  5, // $68 'h'
  $00,$80,$80,$e0,$90,$90,$90,$90,$00,

  5, // $69 'i'
  $00,$20,$00,$60,$20,$20,$20,$70,$00,

  5, // $6a 'j'
  $00,$20,$00,$60,$20,$20,$20,$a0,$40,

  5, // $6b 'k'
  $00,$80,$80,$90,$a0,$c0,$a0,$90,$00,

  5, // $6c 'l'
  $00,$60,$20,$20,$20,$20,$20,$70,$00,

  5, // $6d 'm'
  $00,$00,$a0,$f0,$f0,$f0,$90,$90,$00,

  5, // $6e 'n'
  $00,$00,$a0,$d0,$90,$90,$90,$90,$00,

  5, // $6f 'o'
  $00,$00,$60,$90,$90,$90,$90,$60,$00,

  5, // $70 'p'
  $00,$00,$e0,$90,$90,$90,$e0,$80,$80,

  5, // $71 'q'
  $00,$00,$70,$90,$90,$90,$70,$10,$10,

  5, // $72 'r'
  $00,$00,$e0,$90,$80,$80,$80,$80,$00,

  5, // $73 's'
  $00,$00,$60,$90,$40,$20,$90,$60,$00,

  5, // $74 't'
  $00,$40,$40,$e0,$40,$40,$50,$20,$00,

  5, // $75 'u'
  $00,$00,$90,$90,$90,$90,$90,$70,$00,

  5, // $76 'v'
  $00,$00,$50,$50,$50,$50,$20,$20,$00,

  5, // $77 'w'
  $00,$00,$90,$90,$90,$90,$f0,$90,$00,

  5, // $78 'x'
  $00,$00,$90,$90,$60,$60,$90,$90,$00,

  5, // $79 'y'
  $00,$00,$90,$90,$90,$90,$70,$10,$e0,

  5, // $7a 'z'
  $00,$00,$f0,$10,$20,$40,$80,$f0,$00,

  5, // $7b '{'
  $10,$20,$20,$20,$c0,$20,$20,$20,$10,

  5, // $7c '|'
  $00,$20,$20,$20,$00,$20,$20,$20,$00,

  5, // $7d '}'
  $80,$40,$40,$40,$30,$40,$40,$40,$80,

  5, // $7e '~'
  $00,$40,$a8,$10,$00,$00,$00,$00,$00,

  5, // $7f ''
  $00,$00,$00,$20,$50,$88,$f8,$00,$00,
  0 );

 gse6x12 : array[0..1444 ] of int8u = (
  12, 0, 32, 128-32,

  $00,$00,$0d,$00,$1a,$00,$27,$00,$34,$00,$41,$00,$4e,$00,$5b,$00,$68,$00,
  $75,$00,$82,$00,$8f,$00,$9c,$00,$a9,$00,$b6,$00,$c3,$00,$d0,$00,$dd,$00,
  $ea,$00,$f7,$00,$04,$01,$11,$01,$1e,$01,$2b,$01,$38,$01,$45,$01,$52,$01,
  $5f,$01,$6c,$01,$79,$01,$86,$01,$93,$01,$a0,$01,$ad,$01,$ba,$01,$c7,$01,
  $d4,$01,$e1,$01,$ee,$01,$fb,$01,$08,$02,$15,$02,$22,$02,$2f,$02,$3c,$02,
  $49,$02,$56,$02,$63,$02,$70,$02,$7d,$02,$8a,$02,$97,$02,$a4,$02,$b1,$02,
  $be,$02,$cb,$02,$d8,$02,$e5,$02,$f2,$02,$ff,$02,$0c,$03,$19,$03,$26,$03,
  $33,$03,$40,$03,$4d,$03,$5a,$03,$67,$03,$74,$03,$81,$03,$8e,$03,$9b,$03,
  $a8,$03,$b5,$03,$c2,$03,$cf,$03,$dc,$03,$e9,$03,$f6,$03,$03,$04,$10,$04,
  $1d,$04,$2a,$04,$37,$04,$44,$04,$51,$04,$5e,$04,$6b,$04,$78,$04,$85,$04,
  $92,$04,$9f,$04,$ac,$04,$b9,$04,$c6,$04,$d3,$04,

  6, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$20,$20,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  6, // $22 '"'
  $00,$50,$50,$50,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $23 '#'
  $00,$50,$50,$f8,$50,$50,$50,$f8,$50,$50,$00,$00,

  6, // $24 '$'
  $00,$20,$70,$a8,$a0,$70,$28,$a8,$70,$20,$00,$00,

  6, // $25 '%'
  $00,$c8,$d8,$10,$30,$20,$60,$40,$d8,$98,$00,$00,

  6, // $26 '&'
  $00,$60,$90,$90,$90,$60,$a8,$90,$90,$68,$00,$00,

  6, // $27 '''
  $00,$20,$20,$20,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $28 '('
  $00,$10,$20,$40,$40,$40,$40,$40,$20,$10,$00,$00,

  6, // $29 ')'
  $00,$40,$20,$10,$10,$10,$10,$10,$20,$40,$00,$00,

  6, // $2a '*'
  $00,$00,$00,$50,$20,$f8,$20,$50,$00,$00,$00,$00,

  6, // $2b '+'
  $00,$00,$20,$20,$20,$f8,$20,$20,$20,$00,$00,$00,

  6, // $2c ','
  $00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$40,

  6, // $2d '-'
  $00,$00,$00,$00,$00,$f8,$00,$00,$00,$00,$00,$00,

  6, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$00,$00,

  6, // $2f '/'
  $08,$08,$10,$10,$20,$20,$40,$40,$80,$80,$00,$00,

  6, // $30 '0'
  $00,$70,$88,$88,$98,$a8,$c8,$88,$88,$70,$00,$00,

  6, // $31 '1'
  $00,$20,$20,$60,$20,$20,$20,$20,$20,$70,$00,$00,

  6, // $32 '2'
  $00,$70,$88,$88,$08,$10,$20,$40,$80,$f8,$00,$00,

  6, // $33 '3'
  $00,$f8,$10,$20,$70,$08,$08,$08,$88,$70,$00,$00,

  6, // $34 '4'
  $00,$10,$20,$40,$90,$90,$f8,$10,$10,$10,$00,$00,

  6, // $35 '5'
  $00,$f8,$80,$80,$f0,$08,$08,$08,$88,$70,$00,$00,

  6, // $36 '6'
  $00,$70,$88,$80,$80,$f0,$88,$88,$88,$70,$00,$00,

  6, // $37 '7'
  $00,$f8,$88,$08,$08,$10,$20,$20,$20,$20,$00,$00,

  6, // $38 '8'
  $00,$70,$88,$88,$88,$70,$88,$88,$88,$70,$00,$00,

  6, // $39 '9'
  $00,$70,$88,$88,$88,$78,$08,$08,$88,$70,$00,$00,

  6, // $3a ':'
  $00,$00,$00,$00,$20,$00,$00,$00,$20,$00,$00,$00,

  6, // $3b ';'
  $00,$00,$00,$00,$20,$00,$00,$00,$20,$20,$20,$40,

  6, // $3c '<'
  $00,$08,$10,$20,$40,$80,$40,$20,$10,$08,$00,$00,

  6, // $3d '='
  $00,$00,$00,$00,$f8,$00,$f8,$00,$00,$00,$00,$00,

  6, // $3e '>'
  $00,$80,$40,$20,$10,$08,$10,$20,$40,$80,$00,$00,

  6, // $3f '?'
  $00,$70,$88,$88,$08,$10,$20,$20,$00,$20,$00,$00,

  6, // $40 '@'
  $00,$70,$88,$88,$b8,$b8,$b0,$80,$88,$70,$00,$00,

  6, // $41 'A'
  $00,$20,$50,$88,$88,$88,$f8,$88,$88,$88,$00,$00,

  6, // $42 'B'
  $00,$f0,$88,$88,$88,$f0,$88,$88,$88,$f0,$00,$00,

  6, // $43 'C'
  $00,$70,$88,$88,$80,$80,$80,$88,$88,$70,$00,$00,

  6, // $44 'D'
  $00,$e0,$90,$88,$88,$88,$88,$88,$90,$e0,$00,$00,

  6, // $45 'E'
  $00,$f8,$80,$80,$80,$f0,$80,$80,$80,$f8,$00,$00,

  6, // $46 'F'
  $00,$f8,$80,$80,$80,$f0,$80,$80,$80,$80,$00,$00,

  6, // $47 'G'
  $00,$70,$88,$80,$80,$b8,$88,$88,$88,$70,$00,$00,

  6, // $48 'H'
  $00,$88,$88,$88,$88,$f8,$88,$88,$88,$88,$00,$00,

  6, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,

  6, // $4a 'J'
  $00,$38,$10,$10,$10,$10,$10,$10,$90,$60,$00,$00,

  6, // $4b 'K'
  $00,$88,$88,$90,$a0,$c0,$a0,$90,$88,$88,$00,$00,

  6, // $4c 'L'
  $00,$80,$80,$80,$80,$80,$80,$80,$80,$f8,$00,$00,

  6, // $4d 'M'
  $00,$88,$88,$d8,$a8,$88,$88,$88,$88,$88,$00,$00,

  6, // $4e 'N'
  $00,$88,$88,$c8,$a8,$98,$88,$88,$88,$88,$00,$00,

  6, // $4f 'O'
  $00,$70,$88,$88,$88,$88,$88,$88,$88,$70,$00,$00,

  6, // $50 'P'
  $00,$f0,$88,$88,$88,$f0,$80,$80,$80,$80,$00,$00,

  6, // $51 'Q'
  $00,$70,$88,$88,$88,$88,$88,$a8,$90,$68,$00,$00,

  6, // $52 'R'
  $00,$f0,$88,$88,$88,$88,$f0,$a0,$90,$88,$00,$00,

  6, // $53 'S'
  $00,$70,$88,$80,$80,$70,$08,$08,$88,$70,$00,$00,

  6, // $54 'T'
  $00,$f8,$20,$20,$20,$20,$20,$20,$20,$20,$00,$00,

  6, // $55 'U'
  $00,$88,$88,$88,$88,$88,$88,$88,$88,$70,$00,$00,

  6, // $56 'V'
  $00,$88,$88,$88,$88,$88,$50,$50,$20,$20,$00,$00,

  6, // $57 'W'
  $00,$88,$88,$88,$88,$88,$a8,$a8,$d8,$88,$00,$00,

  6, // $58 'X'
  $00,$88,$88,$88,$50,$20,$50,$88,$88,$88,$00,$00,

  6, // $59 'Y'
  $00,$88,$88,$88,$50,$20,$20,$20,$20,$20,$00,$00,

  6, // $5a 'Z'
  $00,$f8,$08,$08,$10,$20,$40,$80,$80,$f8,$00,$00,

  6, // $5b '['
  $70,$40,$40,$40,$40,$40,$40,$40,$40,$40,$70,$00,

  6, // $5c '\'
  $80,$80,$40,$40,$20,$20,$10,$10,$08,$08,$00,$00,

  6, // $5d ']'
  $70,$10,$10,$10,$10,$10,$10,$10,$10,$10,$70,$00,

  6, // $5e '^'
  $00,$00,$20,$50,$88,$00,$00,$00,$00,$00,$00,$00,

  6, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$f8,$00,$00,

  6, // $60 '`'
  $00,$40,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $61 'a'
  $00,$00,$00,$70,$88,$08,$78,$88,$88,$78,$00,$00,

  6, // $62 'b'
  $00,$80,$80,$80,$f0,$88,$88,$88,$88,$f0,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$70,$88,$80,$80,$80,$88,$70,$00,$00,

  6, // $64 'd'
  $00,$08,$08,$08,$78,$88,$88,$88,$88,$78,$00,$00,

  6, // $65 'e'
  $00,$00,$00,$70,$88,$88,$f8,$80,$80,$78,$00,$00,

  6, // $66 'f'
  $00,$18,$20,$20,$f8,$20,$20,$20,$20,$20,$00,$00,

  6, // $67 'g'
  $00,$00,$00,$78,$88,$88,$88,$88,$78,$08,$08,$f0,

  6, // $68 'h'
  $00,$80,$80,$80,$f0,$88,$88,$88,$88,$88,$00,$00,

  6, // $69 'i'
  $00,$20,$00,$00,$60,$20,$20,$20,$20,$70,$00,$00,

  6, // $6a 'j'
  $00,$10,$00,$00,$30,$10,$10,$10,$10,$10,$90,$60,

  6, // $6b 'k'
  $00,$80,$80,$80,$88,$90,$a0,$d0,$88,$88,$00,$00,

  6, // $6c 'l'
  $00,$60,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,

  6, // $6d 'm'
  $00,$00,$00,$d0,$a8,$a8,$a8,$a8,$a8,$a8,$00,$00,

  6, // $6e 'n'
  $00,$00,$00,$b0,$c8,$88,$88,$88,$88,$88,$00,$00,

  6, // $6f 'o'
  $00,$00,$00,$70,$88,$88,$88,$88,$88,$70,$00,$00,

  6, // $70 'p'
  $00,$00,$00,$f0,$88,$88,$88,$88,$f0,$80,$80,$80,

  6, // $71 'q'
  $00,$00,$00,$78,$88,$88,$88,$88,$78,$08,$08,$08,

  6, // $72 'r'
  $00,$00,$00,$b0,$c8,$88,$80,$80,$80,$80,$00,$00,

  6, // $73 's'
  $00,$00,$00,$70,$88,$80,$70,$08,$88,$70,$00,$00,

  6, // $74 't'
  $00,$40,$40,$40,$e0,$40,$40,$40,$48,$30,$00,$00,

  6, // $75 'u'
  $00,$00,$00,$88,$88,$88,$88,$88,$88,$78,$00,$00,

  6, // $76 'v'
  $00,$00,$00,$88,$88,$88,$50,$50,$20,$20,$00,$00,

  6, // $77 'w'
  $00,$00,$00,$88,$88,$88,$a8,$a8,$d8,$88,$00,$00,

  6, // $78 'x'
  $00,$00,$00,$88,$88,$50,$20,$50,$88,$88,$00,$00,

  6, // $79 'y'
  $00,$00,$00,$88,$88,$88,$88,$88,$78,$08,$10,$e0,

  6, // $7a 'z'
  $00,$00,$00,$f8,$08,$10,$20,$40,$80,$f8,$00,$00,

  6, // $7b '{'
  $18,$20,$20,$20,$20,$c0,$20,$20,$20,$20,$18,$00,

  6, // $7c '|'
  $00,$20,$20,$20,$20,$00,$20,$20,$20,$20,$00,$00,

  6, // $7d '}'
  $c0,$20,$20,$20,$20,$18,$20,$20,$20,$20,$c0,$00,

  6, // $7e '~'
  $00,$00,$40,$a8,$10,$00,$00,$00,$00,$00,$00,$00,

  6, // $7f ''
  $00,$00,$00,$00,$20,$50,$88,$f8,$00,$00,$00,$00,
  0 );

 gse6x9 : array[0..1156 ] of int8u = (
  9, 0, 32, 128-32,

  $00,$00,$0a,$00,$14,$00,$1e,$00,$28,$00,$32,$00,$3c,$00,$46,$00,$50,$00,
  $5a,$00,$64,$00,$6e,$00,$78,$00,$82,$00,$8c,$00,$96,$00,$a0,$00,$aa,$00,
  $b4,$00,$be,$00,$c8,$00,$d2,$00,$dc,$00,$e6,$00,$f0,$00,$fa,$00,$04,$01,
  $0e,$01,$18,$01,$22,$01,$2c,$01,$36,$01,$40,$01,$4a,$01,$54,$01,$5e,$01,
  $68,$01,$72,$01,$7c,$01,$86,$01,$90,$01,$9a,$01,$a4,$01,$ae,$01,$b8,$01,
  $c2,$01,$cc,$01,$d6,$01,$e0,$01,$ea,$01,$f4,$01,$fe,$01,$08,$02,$12,$02,
  $1c,$02,$26,$02,$30,$02,$3a,$02,$44,$02,$4e,$02,$58,$02,$62,$02,$6c,$02,
  $76,$02,$80,$02,$8a,$02,$94,$02,$9e,$02,$a8,$02,$b2,$02,$bc,$02,$c6,$02,
  $d0,$02,$da,$02,$e4,$02,$ee,$02,$f8,$02,$02,$03,$0c,$03,$16,$03,$20,$03,
  $2a,$03,$34,$03,$3e,$03,$48,$03,$52,$03,$5c,$03,$66,$03,$70,$03,$7a,$03,
  $84,$03,$8e,$03,$98,$03,$a2,$03,$ac,$03,$b6,$03,

  6, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$20,$20,$20,$20,$20,$00,$20,$00,

  6, // $22 '"'
  $00,$50,$50,$00,$00,$00,$00,$00,$00,

  6, // $23 '#'
  $00,$50,$50,$f8,$50,$f8,$50,$50,$00,

  6, // $24 '$'
  $00,$70,$a8,$a0,$70,$28,$a8,$70,$00,

  6, // $25 '%'
  $00,$c8,$c8,$10,$20,$40,$98,$98,$00,

  6, // $26 '&'
  $00,$60,$90,$90,$60,$a8,$90,$68,$00,

  6, // $27 '''
  $00,$20,$20,$00,$00,$00,$00,$00,$00,

  6, // $28 '('
  $10,$20,$40,$40,$40,$40,$40,$20,$10,

  6, // $29 ')'
  $40,$20,$10,$10,$10,$10,$10,$20,$40,

  6, // $2a '*'
  $00,$00,$20,$a8,$70,$a8,$20,$00,$00,

  6, // $2b '+'
  $00,$00,$20,$20,$f8,$20,$20,$00,$00,

  6, // $2c ','
  $00,$00,$00,$00,$00,$00,$20,$20,$40,

  6, // $2d '-'
  $00,$00,$00,$00,$f8,$00,$00,$00,$00,

  6, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$40,$00,

  6, // $2f '/'
  $00,$08,$08,$10,$20,$40,$80,$80,$00,

  6, // $30 '0'
  $00,$70,$88,$98,$a8,$c8,$88,$70,$00,

  6, // $31 '1'
  $00,$20,$60,$20,$20,$20,$20,$70,$00,

  6, // $32 '2'
  $00,$70,$88,$08,$10,$20,$40,$f8,$00,

  6, // $33 '3'
  $00,$f8,$10,$20,$70,$08,$88,$70,$00,

  6, // $34 '4'
  $00,$10,$20,$40,$90,$f8,$10,$10,$00,

  6, // $35 '5'
  $00,$f8,$80,$f0,$08,$08,$88,$70,$00,

  6, // $36 '6'
  $00,$70,$88,$80,$f0,$88,$88,$70,$00,

  6, // $37 '7'
  $00,$f8,$08,$08,$10,$20,$40,$40,$00,

  6, // $38 '8'
  $00,$70,$88,$88,$70,$88,$88,$70,$00,

  6, // $39 '9'
  $00,$70,$88,$88,$78,$08,$88,$70,$00,

  6, // $3a ':'
  $00,$00,$00,$20,$00,$00,$20,$00,$00,

  6, // $3b ';'
  $00,$00,$00,$20,$00,$00,$20,$20,$40,

  6, // $3c '<'
  $00,$08,$10,$20,$40,$20,$10,$08,$00,

  6, // $3d '='
  $00,$00,$00,$f8,$00,$f8,$00,$00,$00,

  6, // $3e '>'
  $00,$80,$40,$20,$10,$20,$40,$80,$00,

  6, // $3f '?'
  $00,$70,$88,$08,$10,$20,$00,$20,$00,

  6, // $40 '@'
  $00,$70,$88,$88,$b8,$b8,$80,$70,$00,

  6, // $41 'A'
  $00,$20,$50,$88,$88,$f8,$88,$88,$00,

  6, // $42 'B'
  $00,$f0,$88,$88,$f0,$88,$88,$f0,$00,

  6, // $43 'C'
  $00,$70,$88,$80,$80,$80,$88,$70,$00,

  6, // $44 'D'
  $00,$e0,$90,$88,$88,$88,$90,$e0,$00,

  6, // $45 'E'
  $00,$f8,$80,$80,$f0,$80,$80,$f8,$00,

  6, // $46 'F'
  $00,$f8,$80,$80,$f0,$80,$80,$80,$00,

  6, // $47 'G'
  $00,$70,$88,$80,$b8,$88,$88,$70,$00,

  6, // $48 'H'
  $00,$88,$88,$88,$f8,$88,$88,$88,$00,

  6, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$70,$00,

  6, // $4a 'J'
  $00,$38,$10,$10,$10,$10,$90,$60,$00,

  6, // $4b 'K'
  $00,$88,$90,$a0,$c0,$a0,$90,$88,$00,

  6, // $4c 'L'
  $00,$80,$80,$80,$80,$80,$80,$f8,$00,

  6, // $4d 'M'
  $00,$88,$d8,$a8,$88,$88,$88,$88,$00,

  6, // $4e 'N'
  $00,$88,$88,$c8,$a8,$98,$88,$88,$00,

  6, // $4f 'O'
  $00,$70,$88,$88,$88,$88,$88,$70,$00,

  6, // $50 'P'
  $00,$f0,$88,$88,$f0,$80,$80,$80,$00,

  6, // $51 'Q'
  $00,$70,$88,$88,$88,$a8,$90,$68,$00,

  6, // $52 'R'
  $00,$f0,$88,$88,$88,$f0,$90,$88,$00,

  6, // $53 'S'
  $00,$70,$88,$80,$70,$08,$88,$70,$00,

  6, // $54 'T'
  $00,$f8,$20,$20,$20,$20,$20,$20,$00,

  6, // $55 'U'
  $00,$88,$88,$88,$88,$88,$88,$70,$00,

  6, // $56 'V'
  $00,$88,$88,$88,$50,$50,$20,$20,$00,

  6, // $57 'W'
  $00,$88,$88,$88,$a8,$a8,$d8,$88,$00,

  6, // $58 'X'
  $00,$88,$88,$50,$20,$50,$88,$88,$00,

  6, // $59 'Y'
  $00,$88,$88,$50,$20,$20,$20,$20,$00,

  6, // $5a 'Z'
  $00,$f8,$08,$10,$20,$40,$80,$f8,$00,

  6, // $5b '['
  $70,$40,$40,$40,$40,$40,$40,$40,$70,

  6, // $5c '\'
  $00,$80,$80,$40,$20,$10,$08,$08,$00,

  6, // $5d ']'
  $70,$10,$10,$10,$10,$10,$10,$10,$70,

  6, // $5e '^'
  $00,$00,$20,$50,$88,$00,$00,$00,$00,

  6, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$f8,$00,

  6, // $60 '`'
  $00,$40,$20,$00,$00,$00,$00,$00,$00,

  6, // $61 'a'
  $00,$00,$00,$70,$08,$78,$88,$78,$00,

  6, // $62 'b'
  $00,$80,$80,$f0,$88,$88,$88,$f0,$00,

  6, // $63 'c'
  $00,$00,$00,$70,$88,$80,$88,$70,$00,

  6, // $64 'd'
  $00,$08,$08,$78,$88,$88,$88,$78,$00,

  6, // $65 'e'
  $00,$00,$00,$70,$88,$f8,$80,$78,$00,

  6, // $66 'f'
  $00,$18,$20,$20,$f8,$20,$20,$20,$00,

  6, // $67 'g'
  $00,$00,$00,$78,$88,$88,$78,$08,$70,

  6, // $68 'h'
  $00,$80,$80,$f0,$88,$88,$88,$88,$00,

  6, // $69 'i'
  $00,$20,$00,$60,$20,$20,$20,$70,$00,

  6, // $6a 'j'
  $00,$10,$00,$30,$10,$10,$10,$90,$60,

  6, // $6b 'k'
  $00,$00,$80,$88,$90,$a0,$d0,$88,$00,

  6, // $6c 'l'
  $00,$60,$20,$20,$20,$20,$20,$70,$00,

  6, // $6d 'm'
  $00,$00,$00,$d0,$a8,$a8,$a8,$a8,$00,

  6, // $6e 'n'
  $00,$00,$00,$b0,$c8,$88,$88,$88,$00,

  6, // $6f 'o'
  $00,$00,$00,$70,$88,$88,$88,$70,$00,

  6, // $70 'p'
  $00,$00,$00,$f0,$88,$88,$f0,$80,$80,

  6, // $71 'q'
  $00,$00,$00,$78,$88,$88,$78,$08,$08,

  6, // $72 'r'
  $00,$00,$00,$b8,$c0,$80,$80,$80,$00,

  6, // $73 's'
  $00,$00,$00,$78,$80,$70,$08,$f0,$00,

  6, // $74 't'
  $00,$40,$40,$e0,$40,$40,$48,$30,$00,

  6, // $75 'u'
  $00,$00,$00,$88,$88,$88,$88,$78,$00,

  6, // $76 'v'
  $00,$00,$00,$88,$88,$88,$50,$20,$00,

  6, // $77 'w'
  $00,$00,$00,$88,$88,$a8,$d8,$88,$00,

  6, // $78 'x'
  $00,$00,$00,$88,$50,$20,$50,$88,$00,

  6, // $79 'y'
  $00,$00,$00,$88,$88,$88,$78,$08,$70,

  6, // $7a 'z'
  $00,$00,$00,$f8,$10,$20,$40,$f8,$00,

  6, // $7b '{'
  $18,$20,$20,$20,$c0,$20,$20,$20,$18,

  6, // $7c '|'
  $00,$20,$20,$20,$00,$20,$20,$20,$00,

  6, // $7d '}'
  $c0,$20,$20,$20,$18,$20,$20,$20,$c0,

  6, // $7e '~'
  $00,$40,$a8,$10,$00,$00,$00,$00,$00,

  6, // $7f ''
  $00,$00,$00,$20,$50,$88,$f8,$00,$00,
  0 );

 gse7x11 : array[0..1348 ] of int8u = (
  11, 0, 32, 128-32,

  $00,$00,$0c,$00,$18,$00,$24,$00,$30,$00,$3c,$00,$48,$00,$54,$00,$60,$00,
  $6c,$00,$78,$00,$84,$00,$90,$00,$9c,$00,$a8,$00,$b4,$00,$c0,$00,$cc,$00,
  $d8,$00,$e4,$00,$f0,$00,$fc,$00,$08,$01,$14,$01,$20,$01,$2c,$01,$38,$01,
  $44,$01,$50,$01,$5c,$01,$68,$01,$74,$01,$80,$01,$8c,$01,$98,$01,$a4,$01,
  $b0,$01,$bc,$01,$c8,$01,$d4,$01,$e0,$01,$ec,$01,$f8,$01,$04,$02,$10,$02,
  $1c,$02,$28,$02,$34,$02,$40,$02,$4c,$02,$58,$02,$64,$02,$70,$02,$7c,$02,
  $88,$02,$94,$02,$a0,$02,$ac,$02,$b8,$02,$c4,$02,$d0,$02,$dc,$02,$e8,$02,
  $f4,$02,$00,$03,$0c,$03,$18,$03,$24,$03,$30,$03,$3c,$03,$48,$03,$54,$03,
  $60,$03,$6c,$03,$78,$03,$84,$03,$90,$03,$9c,$03,$a8,$03,$b4,$03,$c0,$03,
  $cc,$03,$d8,$03,$e4,$03,$f0,$03,$fc,$03,$08,$04,$14,$04,$20,$04,$2c,$04,
  $38,$04,$44,$04,$50,$04,$5c,$04,$68,$04,$74,$04,

  7, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $21 '!'
  $00,$10,$38,$38,$38,$10,$10,$00,$10,$00,$00,

  7, // $22 '"'
  $00,$00,$24,$24,$24,$00,$00,$00,$00,$00,$00,

  7, // $23 '#'
  $00,$48,$48,$fc,$48,$48,$fc,$48,$48,$00,$00,

  7, // $24 '$'
  $00,$10,$38,$54,$50,$38,$14,$54,$38,$10,$00,

  7, // $25 '%'
  $00,$00,$42,$a4,$48,$10,$24,$4a,$84,$00,$00,

  7, // $26 '&'
  $00,$30,$48,$48,$30,$60,$94,$98,$6c,$00,$00,

  7, // $27 '''
  $00,$20,$20,$40,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $00,$04,$08,$10,$10,$10,$10,$08,$04,$00,$00,

  7, // $29 ')'
  $00,$40,$20,$10,$10,$10,$10,$20,$40,$00,$00,

  7, // $2a '*'
  $00,$00,$00,$20,$a8,$70,$a8,$20,$00,$00,$00,

  7, // $2b '+'
  $00,$00,$00,$10,$10,$7c,$10,$10,$00,$00,$00,

  7, // $2c ','
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$30,$60,

  7, // $2d '-'
  $00,$00,$00,$00,$00,$fc,$00,$00,$00,$00,$00,

  7, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,

  7, // $2f '/'
  $00,$08,$08,$10,$10,$20,$20,$40,$40,$00,$00,

  7, // $30 '0'
  $00,$38,$44,$4c,$54,$64,$44,$44,$38,$00,$00,

  7, // $31 '1'
  $00,$10,$30,$10,$10,$10,$10,$10,$7c,$00,$00,

  7, // $32 '2'
  $00,$38,$44,$04,$08,$10,$20,$44,$7c,$00,$00,

  7, // $33 '3'
  $00,$7c,$48,$10,$38,$04,$04,$44,$38,$00,$00,

  7, // $34 '4'
  $00,$08,$10,$20,$48,$48,$7c,$08,$1c,$00,$00,

  7, // $35 '5'
  $00,$7c,$40,$40,$78,$04,$04,$44,$38,$00,$00,

  7, // $36 '6'
  $00,$18,$20,$40,$78,$44,$44,$44,$38,$00,$00,

  7, // $37 '7'
  $00,$7c,$44,$04,$08,$10,$10,$10,$10,$00,$00,

  7, // $38 '8'
  $00,$38,$44,$44,$38,$44,$44,$44,$38,$00,$00,

  7, // $39 '9'
  $00,$38,$44,$44,$44,$3c,$04,$08,$30,$00,$00,

  7, // $3a ':'
  $00,$00,$00,$30,$00,$00,$00,$30,$00,$00,$00,

  7, // $3b ';'
  $00,$00,$00,$30,$00,$00,$00,$30,$30,$60,$00,

  7, // $3c '<'
  $00,$00,$04,$08,$10,$20,$10,$08,$04,$00,$00,

  7, // $3d '='
  $00,$00,$00,$00,$fc,$00,$fc,$00,$00,$00,$00,

  7, // $3e '>'
  $00,$00,$40,$20,$10,$08,$10,$20,$40,$00,$00,

  7, // $3f '?'
  $00,$70,$88,$88,$10,$20,$20,$00,$20,$00,$00,

  7, // $40 '@'
  $00,$30,$48,$04,$34,$54,$54,$54,$28,$00,$00,

  7, // $41 'A'
  $00,$10,$28,$44,$44,$7c,$44,$44,$44,$00,$00,

  7, // $42 'B'
  $00,$78,$44,$44,$78,$44,$44,$44,$78,$00,$00,

  7, // $43 'C'
  $00,$38,$44,$40,$40,$40,$40,$44,$38,$00,$00,

  7, // $44 'D'
  $00,$70,$48,$44,$44,$44,$44,$48,$70,$00,$00,

  7, // $45 'E'
  $00,$7c,$40,$40,$70,$40,$40,$40,$7c,$00,$00,

  7, // $46 'F'
  $00,$7c,$40,$40,$70,$40,$40,$40,$40,$00,$00,

  7, // $47 'G'
  $00,$38,$44,$40,$40,$5c,$44,$44,$38,$00,$00,

  7, // $48 'H'
  $00,$44,$44,$44,$7c,$44,$44,$44,$44,$00,$00,

  7, // $49 'I'
  $00,$38,$10,$10,$10,$10,$10,$10,$38,$00,$00,

  7, // $4a 'J'
  $00,$1c,$08,$08,$08,$08,$08,$48,$30,$00,$00,

  7, // $4b 'K'
  $00,$44,$48,$50,$60,$50,$48,$44,$44,$00,$00,

  7, // $4c 'L'
  $00,$40,$40,$40,$40,$40,$40,$40,$7c,$00,$00,

  7, // $4d 'M'
  $00,$44,$6c,$54,$54,$44,$44,$44,$44,$00,$00,

  7, // $4e 'N'
  $00,$44,$44,$64,$54,$4c,$44,$44,$44,$00,$00,

  7, // $4f 'O'
  $00,$38,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $50 'P'
  $00,$78,$44,$44,$44,$78,$40,$40,$40,$00,$00,

  7, // $51 'Q'
  $00,$38,$44,$44,$44,$44,$54,$48,$34,$00,$00,

  7, // $52 'R'
  $00,$78,$44,$44,$44,$78,$50,$48,$44,$00,$00,

  7, // $53 'S'
  $00,$38,$44,$40,$38,$04,$44,$44,$38,$00,$00,

  7, // $54 'T'
  $00,$7c,$54,$10,$10,$10,$10,$10,$10,$00,$00,

  7, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $56 'V'
  $00,$44,$44,$44,$44,$28,$28,$10,$10,$00,$00,

  7, // $57 'W'
  $00,$44,$44,$44,$44,$54,$54,$6c,$44,$00,$00,

  7, // $58 'X'
  $00,$44,$44,$28,$10,$28,$44,$44,$44,$00,$00,

  7, // $59 'Y'
  $00,$44,$44,$44,$28,$10,$10,$10,$38,$00,$00,

  7, // $5a 'Z'
  $00,$7c,$04,$08,$10,$20,$40,$44,$7c,$00,$00,

  7, // $5b '['
  $00,$38,$20,$20,$20,$20,$20,$20,$38,$00,$00,

  7, // $5c '\'
  $00,$40,$40,$20,$20,$10,$10,$08,$08,$00,$00,

  7, // $5d ']'
  $00,$38,$08,$08,$08,$08,$08,$08,$38,$00,$00,

  7, // $5e '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,

  7, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$fc,$00,$00,

  7, // $60 '`'
  $00,$20,$20,$10,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$38,$04,$3c,$44,$44,$3c,$00,$00,

  7, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$44,$78,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$44,$38,$00,$00,

  7, // $64 'd'
  $00,$04,$04,$3c,$44,$44,$44,$44,$3c,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$38,$44,$7c,$40,$44,$38,$00,$00,

  7, // $66 'f'
  $00,$18,$24,$20,$70,$20,$20,$20,$70,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$3c,$44,$44,$44,$3c,$04,$44,$38,

  7, // $68 'h'
  $00,$40,$40,$40,$58,$64,$44,$44,$44,$00,$00,

  7, // $69 'i'
  $00,$10,$00,$30,$10,$10,$10,$10,$38,$00,$00,

  7, // $6a 'j'
  $00,$08,$00,$18,$08,$08,$08,$08,$48,$30,$00,

  7, // $6b 'k'
  $00,$40,$40,$44,$48,$50,$68,$44,$44,$00,$00,

  7, // $6c 'l'
  $00,$30,$10,$10,$10,$10,$10,$10,$38,$00,$00,

  7, // $6d 'm'
  $00,$00,$00,$a8,$54,$54,$54,$54,$54,$00,$00,

  7, // $6e 'n'
  $00,$00,$00,$b8,$44,$44,$44,$44,$44,$00,$00,

  7, // $6f 'o'
  $00,$00,$00,$38,$44,$44,$44,$44,$38,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$44,$78,$40,$40,

  7, // $71 'q'
  $00,$00,$00,$3c,$44,$44,$44,$44,$3c,$04,$04,

  7, // $72 'r'
  $00,$00,$00,$58,$64,$44,$40,$40,$40,$00,$00,

  7, // $73 's'
  $00,$00,$00,$3c,$40,$38,$04,$04,$78,$00,$00,

  7, // $74 't'
  $00,$20,$20,$70,$20,$20,$20,$24,$18,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$44,$44,$44,$44,$44,$3a,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$44,$44,$44,$44,$28,$10,$00,$00,

  7, // $77 'w'
  $00,$00,$00,$44,$44,$54,$54,$6c,$44,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$44,$28,$10,$28,$44,$44,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$44,$44,$44,$3c,$04,$08,$30,$00,

  7, // $7a 'z'
  $00,$00,$00,$7c,$08,$10,$20,$44,$7c,$00,$00,

  7, // $7b '{'
  $00,$0c,$10,$10,$10,$60,$10,$10,$0c,$00,$00,

  7, // $7c '|'
  $00,$20,$20,$20,$00,$20,$20,$20,$20,$00,$00,

  7, // $7d '}'
  $00,$60,$10,$10,$10,$0c,$10,$10,$60,$00,$00,

  7, // $7e '~'
  $00,$00,$64,$98,$00,$00,$00,$00,$00,$00,$00,

  7, // $7f ''
  $00,$00,$00,$10,$28,$44,$44,$7c,$00,$00,$00,
  0 );

 gse7x11_bold : array[0..1348 ] of int8u = (
  11, 0, 32, 128-32,

  $00,$00,$0c,$00,$18,$00,$24,$00,$30,$00,$3c,$00,$48,$00,$54,$00,$60,$00,
  $6c,$00,$78,$00,$84,$00,$90,$00,$9c,$00,$a8,$00,$b4,$00,$c0,$00,$cc,$00,
  $d8,$00,$e4,$00,$f0,$00,$fc,$00,$08,$01,$14,$01,$20,$01,$2c,$01,$38,$01,
  $44,$01,$50,$01,$5c,$01,$68,$01,$74,$01,$80,$01,$8c,$01,$98,$01,$a4,$01,
  $b0,$01,$bc,$01,$c8,$01,$d4,$01,$e0,$01,$ec,$01,$f8,$01,$04,$02,$10,$02,
  $1c,$02,$28,$02,$34,$02,$40,$02,$4c,$02,$58,$02,$64,$02,$70,$02,$7c,$02,
  $88,$02,$94,$02,$a0,$02,$ac,$02,$b8,$02,$c4,$02,$d0,$02,$dc,$02,$e8,$02,
  $f4,$02,$00,$03,$0c,$03,$18,$03,$24,$03,$30,$03,$3c,$03,$48,$03,$54,$03,
  $60,$03,$6c,$03,$78,$03,$84,$03,$90,$03,$9c,$03,$a8,$03,$b4,$03,$c0,$03,
  $cc,$03,$d8,$03,$e4,$03,$f0,$03,$fc,$03,$08,$04,$14,$04,$20,$04,$2c,$04,
  $38,$04,$44,$04,$50,$04,$5c,$04,$68,$04,$74,$04,

  7, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $21 '!'
  $00,$30,$30,$30,$30,$30,$00,$30,$30,$00,$00,

  7, // $22 '"'
  $00,$6c,$6c,$28,$00,$00,$00,$00,$00,$00,$00,

  7, // $23 '#'
  $00,$48,$48,$fc,$48,$48,$fc,$48,$48,$00,$00,

  7, // $24 '$'
  $30,$30,$78,$cc,$c0,$78,$0c,$cc,$78,$30,$30,

  7, // $25 '%'
  $00,$00,$c4,$0c,$18,$30,$60,$c0,$8c,$00,$00,

  7, // $26 '&'
  $00,$30,$58,$58,$30,$74,$dc,$d8,$6c,$00,$00,

  7, // $27 '''
  $00,$30,$30,$60,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $00,$0c,$18,$30,$30,$30,$30,$18,$0c,$00,$00,

  7, // $29 ')'
  $00,$c0,$60,$30,$30,$30,$30,$60,$c0,$00,$00,

  7, // $2a '*'
  $00,$00,$00,$20,$a8,$70,$a8,$20,$00,$00,$00,

  7, // $2b '+'
  $00,$00,$00,$30,$30,$fc,$30,$30,$00,$00,$00,

  7, // $2c ','
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$60,$00,

  7, // $2d '-'
  $00,$00,$00,$00,$00,$fc,$00,$00,$00,$00,$00,

  7, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,

  7, // $2f '/'
  $00,$0c,$0c,$18,$18,$30,$30,$60,$60,$00,$00,

  7, // $30 '0'
  $00,$78,$cc,$cc,$dc,$ec,$cc,$cc,$78,$00,$00,

  7, // $31 '1'
  $00,$30,$70,$f0,$30,$30,$30,$30,$fc,$00,$00,

  7, // $32 '2'
  $00,$78,$cc,$cc,$18,$30,$60,$cc,$fc,$00,$00,

  7, // $33 '3'
  $00,$fc,$98,$30,$78,$0c,$0c,$cc,$78,$00,$00,

  7, // $34 '4'
  $00,$18,$30,$68,$d8,$d8,$fc,$18,$3c,$00,$00,

  7, // $35 '5'
  $00,$fc,$c0,$c0,$f8,$0c,$0c,$cc,$78,$00,$00,

  7, // $36 '6'
  $00,$38,$60,$c0,$f8,$cc,$cc,$cc,$78,$00,$00,

  7, // $37 '7'
  $00,$fc,$8c,$0c,$18,$30,$30,$30,$30,$00,$00,

  7, // $38 '8'
  $00,$78,$cc,$cc,$78,$cc,$cc,$cc,$78,$00,$00,

  7, // $39 '9'
  $00,$78,$cc,$cc,$cc,$7c,$0c,$18,$70,$00,$00,

  7, // $3a ':'
  $00,$00,$30,$30,$00,$00,$30,$30,$00,$00,$00,

  7, // $3b ';'
  $00,$00,$30,$30,$00,$00,$30,$30,$30,$60,$00,

  7, // $3c '<'
  $00,$00,$0c,$18,$30,$60,$30,$18,$0c,$00,$00,

  7, // $3d '='
  $00,$00,$00,$00,$fc,$00,$fc,$00,$00,$00,$00,

  7, // $3e '>'
  $00,$00,$60,$30,$18,$0c,$18,$30,$60,$00,$00,

  7, // $3f '?'
  $00,$78,$cc,$cc,$18,$30,$30,$00,$30,$00,$00,

  7, // $40 '@'
  $00,$70,$88,$04,$74,$b4,$b4,$b4,$68,$00,$00,

  7, // $41 'A'
  $00,$30,$78,$cc,$cc,$fc,$cc,$cc,$cc,$00,$00,

  7, // $42 'B'
  $00,$f8,$cc,$cc,$f8,$cc,$cc,$cc,$f8,$00,$00,

  7, // $43 'C'
  $00,$78,$cc,$c0,$c0,$c0,$c0,$cc,$78,$00,$00,

  7, // $44 'D'
  $00,$f0,$d8,$cc,$cc,$cc,$cc,$d8,$f0,$00,$00,

  7, // $45 'E'
  $00,$fc,$c4,$d0,$f0,$d0,$c0,$c4,$fc,$00,$00,

  7, // $46 'F'
  $00,$fc,$c4,$d0,$f0,$d0,$c0,$c0,$c0,$00,$00,

  7, // $47 'G'
  $00,$78,$cc,$c0,$c0,$dc,$cc,$cc,$78,$00,$00,

  7, // $48 'H'
  $00,$cc,$cc,$cc,$fc,$cc,$cc,$cc,$cc,$00,$00,

  7, // $49 'I'
  $00,$78,$30,$30,$30,$30,$30,$30,$78,$00,$00,

  7, // $4a 'J'
  $00,$3c,$18,$18,$18,$18,$d8,$d8,$70,$00,$00,

  7, // $4b 'K'
  $00,$cc,$cc,$d8,$f0,$d8,$cc,$cc,$cc,$00,$00,

  7, // $4c 'L'
  $00,$c0,$c0,$c0,$c0,$c0,$c0,$c4,$fc,$00,$00,

  7, // $4d 'M'
  $00,$84,$cc,$fc,$b4,$cc,$cc,$cc,$cc,$00,$00,

  7, // $4e 'N'
  $00,$cc,$cc,$ec,$fc,$dc,$cc,$cc,$cc,$00,$00,

  7, // $4f 'O'
  $00,$78,$cc,$cc,$cc,$cc,$cc,$cc,$78,$00,$00,

  7, // $50 'P'
  $00,$f8,$cc,$cc,$cc,$f8,$c0,$c0,$c0,$00,$00,

  7, // $51 'Q'
  $00,$78,$cc,$cc,$cc,$cc,$dc,$78,$18,$0c,$00,

  7, // $52 'R'
  $00,$f8,$cc,$cc,$cc,$f8,$d8,$cc,$cc,$00,$00,

  7, // $53 'S'
  $00,$78,$cc,$e0,$70,$38,$1c,$cc,$78,$00,$00,

  7, // $54 'T'
  $00,$fc,$b4,$30,$30,$30,$30,$30,$30,$00,$00,

  7, // $55 'U'
  $00,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$78,$00,$00,

  7, // $56 'V'
  $00,$cc,$cc,$cc,$cc,$cc,$cc,$78,$30,$00,$00,

  7, // $57 'W'
  $00,$cc,$cc,$cc,$cc,$b4,$fc,$cc,$84,$00,$00,

  7, // $58 'X'
  $00,$cc,$cc,$78,$30,$78,$cc,$cc,$cc,$00,$00,

  7, // $59 'Y'
  $00,$cc,$cc,$cc,$78,$30,$30,$30,$78,$00,$00,

  7, // $5a 'Z'
  $00,$fc,$8c,$18,$30,$60,$c0,$c4,$fc,$00,$00,

  7, // $5b '['
  $00,$78,$60,$60,$60,$60,$60,$60,$78,$00,$00,

  7, // $5c '\'
  $00,$60,$60,$30,$30,$18,$18,$0c,$0c,$00,$00,

  7, // $5d ']'
  $00,$78,$18,$18,$18,$18,$18,$18,$78,$00,$00,

  7, // $5e '^'
  $00,$10,$38,$6c,$00,$00,$00,$00,$00,$00,$00,

  7, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$fc,$00,$00,

  7, // $60 '`'
  $00,$30,$30,$18,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$70,$18,$78,$d8,$d8,$6c,$00,$00,

  7, // $62 'b'
  $00,$60,$60,$60,$78,$6c,$6c,$6c,$78,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$78,$cc,$c0,$c0,$cc,$78,$00,$00,

  7, // $64 'd'
  $00,$18,$18,$18,$78,$d8,$d8,$d8,$6c,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$78,$cc,$fc,$c0,$cc,$78,$00,$00,

  7, // $66 'f'
  $00,$18,$34,$30,$78,$30,$30,$30,$78,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$6c,$d8,$d8,$d8,$78,$18,$d8,$70,

  7, // $68 'h'
  $00,$c0,$c0,$d8,$ec,$cc,$cc,$cc,$cc,$00,$00,

  7, // $69 'i'
  $00,$30,$00,$70,$30,$30,$30,$30,$78,$00,$00,

  7, // $6a 'j'
  $00,$0c,$00,$1c,$0c,$0c,$0c,$0c,$6c,$6c,$38,

  7, // $6b 'k'
  $00,$c0,$c0,$cc,$cc,$d8,$f0,$d8,$cc,$00,$00,

  7, // $6c 'l'
  $00,$70,$30,$30,$30,$30,$30,$30,$78,$00,$00,

  7, // $6d 'm'
  $00,$00,$00,$e8,$fc,$d4,$d4,$c4,$c4,$00,$00,

  7, // $6e 'n'
  $00,$00,$00,$d8,$6c,$6c,$6c,$6c,$6c,$00,$00,

  7, // $6f 'o'
  $00,$00,$00,$78,$cc,$cc,$cc,$cc,$78,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$f8,$cc,$cc,$cc,$f8,$c0,$c0,$c0,

  7, // $71 'q'
  $00,$00,$00,$7c,$cc,$cc,$cc,$7c,$0c,$0c,$0c,

  7, // $72 'r'
  $00,$00,$00,$d8,$ec,$cc,$c0,$c0,$c0,$00,$00,

  7, // $73 's'
  $00,$00,$00,$78,$cc,$60,$18,$cc,$78,$00,$00,

  7, // $74 't'
  $00,$20,$60,$60,$f0,$60,$60,$68,$30,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$d8,$d8,$d8,$d8,$d8,$6c,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$cc,$cc,$cc,$cc,$78,$30,$00,$00,

  7, // $77 'w'
  $00,$00,$00,$cc,$cc,$b4,$fc,$cc,$84,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$cc,$78,$30,$78,$cc,$cc,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$cc,$cc,$cc,$cc,$7c,$0c,$18,$f0,

  7, // $7a 'z'
  $00,$00,$00,$fc,$98,$30,$60,$c4,$fc,$00,$00,

  7, // $7b '{'
  $1c,$30,$30,$30,$e0,$30,$30,$30,$1c,$00,$00,

  7, // $7c '|'
  $30,$30,$30,$30,$00,$30,$30,$30,$30,$00,$00,

  7, // $7d '}'
  $e0,$30,$30,$30,$1c,$30,$30,$30,$e0,$00,$00,

  7, // $7e '~'
  $00,$34,$58,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $7f ''
  $00,$00,$00,$30,$78,$cc,$cc,$fc,$00,$00,$00,
  0 );

 gse7x15 : array[0..1732 ] of int8u = (
  15, 0, 32, 128-32,

  $00,$00,$10,$00,$20,$00,$30,$00,$40,$00,$50,$00,$60,$00,$70,$00,$80,$00,
  $90,$00,$a0,$00,$b0,$00,$c0,$00,$d0,$00,$e0,$00,$f0,$00,$00,$01,$10,$01,
  $20,$01,$30,$01,$40,$01,$50,$01,$60,$01,$70,$01,$80,$01,$90,$01,$a0,$01,
  $b0,$01,$c0,$01,$d0,$01,$e0,$01,$f0,$01,$00,$02,$10,$02,$20,$02,$30,$02,
  $40,$02,$50,$02,$60,$02,$70,$02,$80,$02,$90,$02,$a0,$02,$b0,$02,$c0,$02,
  $d0,$02,$e0,$02,$f0,$02,$00,$03,$10,$03,$20,$03,$30,$03,$40,$03,$50,$03,
  $60,$03,$70,$03,$80,$03,$90,$03,$a0,$03,$b0,$03,$c0,$03,$d0,$03,$e0,$03,
  $f0,$03,$00,$04,$10,$04,$20,$04,$30,$04,$40,$04,$50,$04,$60,$04,$70,$04,
  $80,$04,$90,$04,$a0,$04,$b0,$04,$c0,$04,$d0,$04,$e0,$04,$f0,$04,$00,$05,
  $10,$05,$20,$05,$30,$05,$40,$05,$50,$05,$60,$05,$70,$05,$80,$05,$90,$05,
  $a0,$05,$b0,$05,$c0,$05,$d0,$05,$e0,$05,$f0,$05,

  7, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $21 '!'
  $00,$00,$10,$38,$38,$38,$38,$10,$10,$00,$10,$10,$00,$00,$00,

  7, // $22 '"'
  $00,$00,$24,$24,$24,$24,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $23 '#'
  $00,$00,$48,$48,$48,$fc,$48,$48,$fc,$48,$48,$48,$00,$00,$00,

  7, // $24 '$'
  $00,$00,$10,$38,$54,$50,$38,$14,$54,$54,$38,$10,$00,$00,$00,

  7, // $25 '%'
  $00,$00,$44,$44,$08,$08,$10,$10,$20,$20,$44,$44,$00,$00,$00,

  7, // $26 '&'
  $00,$00,$00,$30,$48,$48,$30,$60,$94,$98,$90,$6c,$00,$00,$00,

  7, // $27 '''
  $00,$00,$20,$20,$20,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $00,$04,$08,$10,$20,$20,$20,$20,$20,$10,$08,$04,$00,$00,$00,

  7, // $29 ')'
  $00,$40,$20,$10,$08,$08,$08,$08,$08,$10,$20,$40,$00,$00,$00,

  7, // $2a '*'
  $00,$00,$00,$00,$00,$20,$a8,$70,$a8,$20,$00,$00,$00,$00,$00,

  7, // $2b '+'
  $00,$00,$00,$00,$10,$10,$10,$7c,$10,$10,$10,$00,$00,$00,$00,

  7, // $2c ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$30,$60,$00,

  7, // $2d '-'
  $00,$00,$00,$00,$00,$00,$00,$fc,$00,$00,$00,$00,$00,$00,$00,

  7, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,$00,

  7, // $2f '/'
  $00,$00,$04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$00,$00,$00,

  7, // $30 '0'
  $00,$00,$38,$44,$44,$4c,$54,$64,$44,$44,$44,$38,$00,$00,$00,

  7, // $31 '1'
  $00,$00,$10,$10,$30,$10,$10,$10,$10,$10,$10,$7c,$00,$00,$00,

  7, // $32 '2'
  $00,$00,$38,$44,$44,$04,$08,$10,$20,$40,$44,$7c,$00,$00,$00,

  7, // $33 '3'
  $00,$00,$7c,$44,$08,$10,$38,$04,$04,$04,$44,$38,$00,$00,$00,

  7, // $34 '4'
  $00,$00,$08,$10,$20,$40,$48,$48,$7c,$08,$08,$1c,$00,$00,$00,

  7, // $35 '5'
  $00,$00,$7c,$40,$40,$40,$78,$04,$04,$04,$44,$38,$00,$00,$00,

  7, // $36 '6'
  $00,$00,$18,$20,$40,$40,$78,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $37 '7'
  $00,$00,$7c,$44,$04,$04,$08,$08,$10,$10,$10,$10,$00,$00,$00,

  7, // $38 '8'
  $00,$00,$38,$44,$44,$44,$38,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $39 '9'
  $00,$00,$38,$44,$44,$44,$44,$3c,$04,$04,$08,$30,$00,$00,$00,

  7, // $3a ':'
  $00,$00,$00,$00,$00,$30,$00,$00,$00,$00,$30,$00,$00,$00,$00,

  7, // $3b ';'
  $00,$00,$00,$00,$00,$30,$00,$00,$00,$00,$30,$30,$60,$00,$00,

  7, // $3c '<'
  $00,$00,$00,$04,$08,$10,$20,$40,$20,$10,$08,$04,$00,$00,$00,

  7, // $3d '='
  $00,$00,$00,$00,$00,$fc,$00,$fc,$00,$00,$00,$00,$00,$00,$00,

  7, // $3e '>'
  $00,$00,$00,$40,$20,$10,$08,$04,$08,$10,$20,$40,$00,$00,$00,

  7, // $3f '?'
  $00,$00,$78,$84,$84,$84,$08,$10,$20,$20,$00,$20,$00,$00,$00,

  7, // $40 '@'
  $00,$00,$00,$30,$48,$04,$34,$54,$54,$54,$54,$28,$00,$00,$00,

  7, // $41 'A'
  $00,$00,$10,$28,$44,$44,$44,$7c,$44,$44,$44,$44,$00,$00,$00,

  7, // $42 'B'
  $00,$00,$78,$44,$44,$44,$78,$44,$44,$44,$44,$78,$00,$00,$00,

  7, // $43 'C'
  $00,$00,$38,$44,$44,$40,$40,$40,$40,$44,$44,$38,$00,$00,$00,

  7, // $44 'D'
  $00,$00,$70,$48,$44,$44,$44,$44,$44,$44,$48,$70,$00,$00,$00,

  7, // $45 'E'
  $00,$00,$7c,$40,$40,$40,$70,$40,$40,$40,$40,$7c,$00,$00,$00,

  7, // $46 'F'
  $00,$00,$7c,$40,$40,$40,$70,$40,$40,$40,$40,$40,$00,$00,$00,

  7, // $47 'G'
  $00,$00,$38,$44,$40,$40,$40,$5c,$44,$44,$44,$38,$00,$00,$00,

  7, // $48 'H'
  $00,$00,$44,$44,$44,$44,$7c,$44,$44,$44,$44,$44,$00,$00,$00,

  7, // $49 'I'
  $00,$00,$38,$10,$10,$10,$10,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $4a 'J'
  $00,$00,$1c,$08,$08,$08,$08,$08,$08,$48,$48,$30,$00,$00,$00,

  7, // $4b 'K'
  $00,$00,$44,$44,$48,$50,$60,$50,$48,$44,$44,$44,$00,$00,$00,

  7, // $4c 'L'
  $00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$7c,$00,$00,$00,

  7, // $4d 'M'
  $00,$00,$44,$6c,$54,$54,$44,$44,$44,$44,$44,$44,$00,$00,$00,

  7, // $4e 'N'
  $00,$00,$44,$44,$44,$64,$54,$4c,$44,$44,$44,$44,$00,$00,$00,

  7, // $4f 'O'
  $00,$00,$38,$44,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $50 'P'
  $00,$00,$78,$44,$44,$44,$44,$78,$40,$40,$40,$40,$00,$00,$00,

  7, // $51 'Q'
  $00,$00,$38,$44,$44,$44,$44,$44,$44,$54,$48,$34,$00,$00,$00,

  7, // $52 'R'
  $00,$00,$78,$44,$44,$44,$44,$78,$50,$48,$44,$44,$00,$00,$00,

  7, // $53 'S'
  $00,$00,$38,$44,$44,$40,$38,$04,$04,$44,$44,$38,$00,$00,$00,

  7, // $54 'T'
  $00,$00,$7c,$54,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,

  7, // $55 'U'
  $00,$00,$44,$44,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $56 'V'
  $00,$00,$44,$44,$44,$44,$44,$44,$28,$28,$10,$10,$00,$00,$00,

  7, // $57 'W'
  $00,$00,$44,$44,$44,$44,$44,$44,$54,$54,$6c,$44,$00,$00,$00,

  7, // $58 'X'
  $00,$00,$44,$44,$44,$28,$10,$28,$44,$44,$44,$44,$00,$00,$00,

  7, // $59 'Y'
  $00,$00,$44,$44,$44,$44,$28,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $5a 'Z'
  $00,$00,$7c,$04,$04,$08,$10,$20,$40,$40,$40,$7c,$00,$00,$00,

  7, // $5b '['
  $00,$38,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$38,$00,$00,

  7, // $5c '\'
  $00,$00,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$00,$00,$00,

  7, // $5d ']'
  $00,$38,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$38,$00,$00,

  7, // $5e '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$fc,$00,$00,$00,

  7, // $60 '`'
  $00,$20,$20,$20,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$00,$38,$44,$04,$3c,$44,$44,$44,$3a,$00,$00,$00,

  7, // $62 'b'
  $00,$00,$40,$40,$40,$78,$44,$44,$44,$44,$44,$78,$00,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$00,$38,$44,$40,$40,$40,$40,$44,$38,$00,$00,$00,

  7, // $64 'd'
  $00,$00,$04,$04,$04,$3c,$44,$44,$44,$44,$44,$3a,$00,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$00,$38,$44,$44,$7c,$40,$40,$44,$38,$00,$00,$00,

  7, // $66 'f'
  $00,$00,$18,$24,$20,$70,$20,$20,$20,$20,$20,$70,$00,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$00,$3a,$44,$44,$44,$44,$44,$3c,$04,$44,$38,$00,

  7, // $68 'h'
  $00,$00,$40,$40,$40,$58,$64,$44,$44,$44,$44,$44,$00,$00,$00,

  7, // $69 'i'
  $00,$00,$10,$10,$00,$30,$10,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $6a 'j'
  $00,$00,$08,$08,$00,$18,$08,$08,$08,$08,$08,$48,$48,$30,$00,

  7, // $6b 'k'
  $00,$00,$40,$40,$44,$44,$48,$50,$60,$50,$48,$44,$00,$00,$00,

  7, // $6c 'l'
  $00,$00,$30,$10,$10,$10,$10,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $6d 'm'
  $00,$00,$00,$00,$a8,$54,$54,$54,$54,$54,$54,$54,$00,$00,$00,

  7, // $6e 'n'
  $00,$00,$00,$00,$b8,$44,$44,$44,$44,$44,$44,$44,$00,$00,$00,

  7, // $6f 'o'
  $00,$00,$00,$00,$38,$44,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$00,$78,$44,$44,$44,$44,$44,$78,$40,$40,$40,$00,

  7, // $71 'q'
  $00,$00,$00,$00,$3c,$44,$44,$44,$44,$44,$3c,$04,$04,$04,$00,

  7, // $72 'r'
  $00,$00,$00,$00,$58,$64,$44,$40,$40,$40,$40,$40,$00,$00,$00,

  7, // $73 's'
  $00,$00,$00,$00,$38,$44,$40,$38,$04,$44,$44,$38,$00,$00,$00,

  7, // $74 't'
  $00,$00,$20,$20,$20,$70,$20,$20,$20,$20,$24,$18,$00,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$00,$44,$44,$44,$44,$44,$44,$44,$3a,$00,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$00,$44,$44,$44,$44,$28,$28,$10,$10,$00,$00,$00,

  7, // $77 'w'
  $00,$00,$00,$00,$44,$44,$44,$44,$54,$54,$6c,$44,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$44,$00,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$00,$44,$44,$44,$44,$44,$44,$3c,$04,$08,$70,$00,

  7, // $7a 'z'
  $00,$00,$00,$00,$7c,$04,$08,$10,$20,$40,$40,$7c,$00,$00,$00,

  7, // $7b '{'
  $00,$0c,$10,$10,$10,$10,$10,$60,$10,$10,$10,$10,$0c,$00,$00,

  7, // $7c '|'
  $00,$20,$20,$20,$20,$20,$00,$00,$20,$20,$20,$20,$20,$00,$00,

  7, // $7d '}'
  $00,$60,$10,$10,$10,$10,$10,$0c,$10,$10,$10,$10,$60,$00,$00,

  7, // $7e '~'
  $00,$00,$64,$98,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $7f ''
  $00,$00,$00,$00,$00,$10,$28,$44,$44,$7c,$00,$00,$00,$00,$00,
  0 );

 gse7x15_bold : array[0..1732 ] of int8u = (
  15, 0, 32, 128-32,

  $00,$00,$10,$00,$20,$00,$30,$00,$40,$00,$50,$00,$60,$00,$70,$00,$80,$00,
  $90,$00,$a0,$00,$b0,$00,$c0,$00,$d0,$00,$e0,$00,$f0,$00,$00,$01,$10,$01,
  $20,$01,$30,$01,$40,$01,$50,$01,$60,$01,$70,$01,$80,$01,$90,$01,$a0,$01,
  $b0,$01,$c0,$01,$d0,$01,$e0,$01,$f0,$01,$00,$02,$10,$02,$20,$02,$30,$02,
  $40,$02,$50,$02,$60,$02,$70,$02,$80,$02,$90,$02,$a0,$02,$b0,$02,$c0,$02,
  $d0,$02,$e0,$02,$f0,$02,$00,$03,$10,$03,$20,$03,$30,$03,$40,$03,$50,$03,
  $60,$03,$70,$03,$80,$03,$90,$03,$a0,$03,$b0,$03,$c0,$03,$d0,$03,$e0,$03,
  $f0,$03,$00,$04,$10,$04,$20,$04,$30,$04,$40,$04,$50,$04,$60,$04,$70,$04,
  $80,$04,$90,$04,$a0,$04,$b0,$04,$c0,$04,$d0,$04,$e0,$04,$f0,$04,$00,$05,
  $10,$05,$20,$05,$30,$05,$40,$05,$50,$05,$60,$05,$70,$05,$80,$05,$90,$05,
  $a0,$05,$b0,$05,$c0,$05,$d0,$05,$e0,$05,$f0,$05,

  7, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $21 '!'
  $00,$00,$00,$30,$78,$78,$78,$30,$30,$00,$30,$30,$00,$00,$00,

  7, // $22 '"'
  $00,$00,$6c,$6c,$6c,$28,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $23 '#'
  $00,$00,$48,$48,$48,$fc,$48,$48,$fc,$48,$48,$48,$00,$00,$00,

  7, // $24 '$'
  $00,$30,$30,$78,$cc,$e0,$70,$38,$1c,$cc,$78,$30,$30,$00,$00,

  7, // $25 '%'
  $00,$00,$00,$64,$6c,$08,$18,$10,$30,$20,$6c,$4c,$00,$00,$00,

  7, // $26 '&'
  $00,$00,$00,$30,$58,$58,$30,$74,$dc,$d8,$d8,$6c,$00,$00,$00,

  7, // $27 '''
  $00,$00,$30,$30,$30,$60,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $00,$0c,$18,$30,$60,$60,$60,$60,$60,$30,$18,$0c,$00,$00,$00,

  7, // $29 ')'
  $00,$c0,$60,$30,$18,$18,$18,$18,$18,$30,$60,$c0,$00,$00,$00,

  7, // $2a '*'
  $00,$00,$00,$00,$00,$20,$a8,$70,$a8,$20,$00,$00,$00,$00,$00,

  7, // $2b '+'
  $00,$00,$00,$00,$00,$30,$30,$fc,$30,$30,$00,$00,$00,$00,$00,

  7, // $2c ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$30,$60,$00,

  7, // $2d '-'
  $00,$00,$00,$00,$00,$00,$00,$fc,$00,$00,$00,$00,$00,$00,$00,

  7, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,$00,

  7, // $2f '/'
  $00,$00,$0c,$0c,$18,$18,$30,$30,$60,$60,$c0,$c0,$00,$00,$00,

  7, // $30 '0'
  $00,$00,$78,$cc,$cc,$cc,$dc,$ec,$cc,$cc,$cc,$78,$00,$00,$00,

  7, // $31 '1'
  $00,$00,$30,$30,$70,$f0,$30,$30,$30,$30,$30,$fc,$00,$00,$00,

  7, // $32 '2'
  $00,$00,$78,$cc,$cc,$0c,$18,$30,$60,$c0,$cc,$fc,$00,$00,$00,

  7, // $33 '3'
  $00,$00,$fc,$8c,$18,$30,$78,$0c,$0c,$0c,$cc,$78,$00,$00,$00,

  7, // $34 '4'
  $00,$00,$18,$30,$60,$c8,$d8,$d8,$fc,$18,$18,$3c,$00,$00,$00,

  7, // $35 '5'
  $00,$00,$fc,$c0,$c0,$c0,$f8,$0c,$0c,$0c,$cc,$78,$00,$00,$00,

  7, // $36 '6'
  $00,$00,$38,$60,$c0,$c0,$f8,$cc,$cc,$cc,$cc,$78,$00,$00,$00,

  7, // $37 '7'
  $00,$00,$fc,$8c,$0c,$0c,$18,$18,$30,$30,$30,$30,$00,$00,$00,

  7, // $38 '8'
  $00,$00,$78,$cc,$cc,$cc,$78,$cc,$cc,$cc,$cc,$78,$00,$00,$00,

  7, // $39 '9'
  $00,$00,$78,$cc,$cc,$cc,$cc,$7c,$0c,$0c,$18,$70,$00,$00,$00,

  7, // $3a ':'
  $00,$00,$00,$00,$30,$30,$00,$00,$00,$30,$30,$00,$00,$00,$00,

  7, // $3b ';'
  $00,$00,$00,$00,$30,$30,$00,$00,$00,$00,$30,$30,$30,$60,$00,

  7, // $3c '<'
  $00,$00,$00,$0c,$18,$30,$60,$c0,$60,$30,$18,$0c,$00,$00,$00,

  7, // $3d '='
  $00,$00,$00,$00,$00,$00,$fc,$00,$fc,$00,$00,$00,$00,$00,$00,

  7, // $3e '>'
  $00,$00,$00,$c0,$60,$30,$18,$0c,$18,$30,$60,$c0,$00,$00,$00,

  7, // $3f '?'
  $00,$00,$78,$cc,$cc,$18,$30,$30,$30,$00,$30,$30,$00,$00,$00,

  7, // $40 '@'
  $00,$00,$00,$70,$88,$04,$74,$b4,$b4,$b4,$b4,$68,$00,$00,$00,

  7, // $41 'A'
  $00,$00,$30,$78,$cc,$cc,$cc,$fc,$cc,$cc,$cc,$cc,$00,$00,$00,

  7, // $42 'B'
  $00,$00,$f8,$cc,$cc,$cc,$f8,$cc,$cc,$cc,$cc,$f8,$00,$00,$00,

  7, // $43 'C'
  $00,$00,$78,$cc,$c4,$c0,$c0,$c0,$c0,$c4,$cc,$78,$00,$00,$00,

  7, // $44 'D'
  $00,$00,$f0,$d8,$cc,$cc,$cc,$cc,$cc,$cc,$d8,$f0,$00,$00,$00,

  7, // $45 'E'
  $00,$00,$fc,$c4,$c0,$d0,$f0,$d0,$c0,$c0,$c4,$fc,$00,$00,$00,

  7, // $46 'F'
  $00,$00,$fc,$c4,$c0,$d0,$f0,$d0,$c0,$c0,$c0,$c0,$00,$00,$00,

  7, // $47 'G'
  $00,$00,$78,$cc,$c0,$c0,$c0,$dc,$cc,$cc,$cc,$78,$00,$00,$00,

  7, // $48 'H'
  $00,$00,$cc,$cc,$cc,$cc,$fc,$cc,$cc,$cc,$cc,$cc,$00,$00,$00,

  7, // $49 'I'
  $00,$00,$78,$30,$30,$30,$30,$30,$30,$30,$30,$78,$00,$00,$00,

  7, // $4a 'J'
  $00,$00,$3c,$18,$18,$18,$18,$18,$18,$d8,$d8,$70,$00,$00,$00,

  7, // $4b 'K'
  $00,$00,$cc,$cc,$d8,$d8,$f0,$d8,$d8,$cc,$cc,$cc,$00,$00,$00,

  7, // $4c 'L'
  $00,$00,$c0,$c0,$c0,$c0,$c0,$c0,$c0,$c0,$c4,$fc,$00,$00,$00,

  7, // $4d 'M'
  $00,$00,$84,$cc,$fc,$b4,$cc,$cc,$cc,$cc,$cc,$cc,$00,$00,$00,

  7, // $4e 'N'
  $00,$00,$cc,$cc,$cc,$ec,$fc,$dc,$cc,$cc,$cc,$cc,$00,$00,$00,

  7, // $4f 'O'
  $00,$00,$78,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$78,$00,$00,$00,

  7, // $50 'P'
  $00,$00,$f8,$cc,$cc,$cc,$cc,$f8,$c0,$c0,$c0,$c0,$00,$00,$00,

  7, // $51 'Q'
  $00,$00,$78,$cc,$cc,$cc,$cc,$cc,$cc,$dc,$78,$18,$0c,$00,$00,

  7, // $52 'R'
  $00,$00,$f8,$cc,$cc,$cc,$cc,$f8,$d8,$cc,$cc,$cc,$00,$00,$00,

  7, // $53 'S'
  $00,$00,$78,$cc,$cc,$e0,$70,$38,$1c,$cc,$cc,$78,$00,$00,$00,

  7, // $54 'T'
  $00,$00,$fc,$b4,$30,$30,$30,$30,$30,$30,$30,$30,$00,$00,$00,

  7, // $55 'U'
  $00,$00,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$78,$00,$00,$00,

  7, // $56 'V'
  $00,$00,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$cc,$78,$30,$00,$00,$00,

  7, // $57 'W'
  $00,$00,$cc,$cc,$cc,$cc,$cc,$cc,$b4,$fc,$cc,$84,$00,$00,$00,

  7, // $58 'X'
  $00,$00,$cc,$cc,$cc,$78,$30,$78,$cc,$cc,$cc,$cc,$00,$00,$00,

  7, // $59 'Y'
  $00,$00,$cc,$cc,$cc,$cc,$78,$30,$30,$30,$30,$78,$00,$00,$00,

  7, // $5a 'Z'
  $00,$00,$fc,$8c,$0c,$18,$30,$60,$c0,$c0,$c4,$fc,$00,$00,$00,

  7, // $5b '['
  $00,$78,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$78,$00,$00,

  7, // $5c '\'
  $00,$00,$c0,$c0,$60,$60,$30,$30,$18,$18,$0c,$0c,$00,$00,$00,

  7, // $5d ']'
  $00,$78,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$78,$00,$00,

  7, // $5e '^'
  $00,$10,$38,$6c,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$fc,$00,$00,$00,

  7, // $60 '`'
  $00,$30,$30,$30,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$00,$70,$d8,$18,$78,$d8,$d8,$d8,$6c,$00,$00,$00,

  7, // $62 'b'
  $00,$00,$60,$60,$60,$78,$6c,$6c,$6c,$6c,$6c,$78,$00,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$00,$78,$cc,$c0,$c0,$c0,$c0,$cc,$78,$00,$00,$00,

  7, // $64 'd'
  $00,$00,$18,$18,$18,$78,$d8,$d8,$d8,$d8,$d8,$6c,$00,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$00,$78,$cc,$cc,$fc,$c0,$c0,$cc,$78,$00,$00,$00,

  7, // $66 'f'
  $00,$00,$30,$68,$60,$60,$f0,$60,$60,$60,$60,$f0,$00,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$00,$6c,$d8,$d8,$d8,$d8,$d8,$78,$18,$d8,$70,$00,

  7, // $68 'h'
  $00,$00,$c0,$c0,$c0,$d8,$ec,$cc,$cc,$cc,$cc,$cc,$00,$00,$00,

  7, // $69 'i'
  $00,$00,$30,$30,$00,$70,$30,$30,$30,$30,$30,$78,$00,$00,$00,

  7, // $6a 'j'
  $00,$00,$18,$18,$00,$38,$18,$18,$18,$18,$18,$d8,$d8,$70,$00,

  7, // $6b 'k'
  $00,$00,$c0,$c0,$cc,$cc,$cc,$d8,$f0,$d8,$cc,$cc,$00,$00,$00,

  7, // $6c 'l'
  $00,$00,$70,$30,$30,$30,$30,$30,$30,$30,$30,$78,$00,$00,$00,

  7, // $6d 'm'
  $00,$00,$00,$00,$e8,$fc,$d4,$d4,$d4,$c4,$c4,$c4,$00,$00,$00,

  7, // $6e 'n'
  $00,$00,$00,$00,$d8,$6c,$6c,$6c,$6c,$6c,$6c,$6c,$00,$00,$00,

  7, // $6f 'o'
  $00,$00,$00,$00,$78,$cc,$cc,$cc,$cc,$cc,$cc,$78,$00,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$00,$f8,$cc,$cc,$cc,$cc,$cc,$f8,$c0,$c0,$c0,$00,

  7, // $71 'q'
  $00,$00,$00,$00,$7c,$cc,$cc,$cc,$cc,$cc,$7c,$0c,$0c,$0c,$00,

  7, // $72 'r'
  $00,$00,$00,$00,$d8,$ec,$cc,$c0,$c0,$c0,$c0,$c0,$00,$00,$00,

  7, // $73 's'
  $00,$00,$00,$00,$78,$cc,$e0,$70,$38,$1c,$cc,$78,$00,$00,$00,

  7, // $74 't'
  $00,$00,$20,$60,$60,$f0,$60,$60,$60,$60,$6c,$38,$00,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$00,$d8,$d8,$d8,$d8,$d8,$d8,$d8,$6c,$00,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$00,$cc,$cc,$cc,$cc,$cc,$cc,$78,$30,$00,$00,$00,

  7, // $77 'w'
  $00,$00,$00,$00,$cc,$cc,$cc,$cc,$b4,$fc,$cc,$84,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$00,$cc,$cc,$78,$30,$78,$cc,$cc,$cc,$00,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$00,$cc,$cc,$cc,$cc,$cc,$cc,$7c,$0c,$18,$f0,$00,

  7, // $7a 'z'
  $00,$00,$00,$00,$fc,$8c,$18,$30,$60,$c0,$c4,$fc,$00,$00,$00,

  7, // $7b '{'
  $00,$1c,$30,$30,$30,$30,$30,$e0,$30,$30,$30,$30,$1c,$00,$00,

  7, // $7c '|'
  $00,$30,$30,$30,$30,$30,$00,$00,$30,$30,$30,$30,$30,$00,$00,

  7, // $7d '}'
  $00,$e0,$30,$30,$30,$30,$30,$1c,$30,$30,$30,$30,$e0,$00,$00,

  7, // $7e '~'
  $00,$00,$34,$58,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $7f ''
  $00,$00,$00,$00,$00,$30,$78,$cc,$cc,$fc,$00,$00,$00,$00,$00,
  0 );

 gse8x16 : array[0..1828 ] of int8u = (
  16, 0, 32, 128-32,

  $00,$00,$11,$00,$22,$00,$33,$00,$44,$00,$55,$00,$66,$00,$77,$00,$88,$00,
  $99,$00,$aa,$00,$bb,$00,$cc,$00,$dd,$00,$ee,$00,$ff,$00,$10,$01,$21,$01,
  $32,$01,$43,$01,$54,$01,$65,$01,$76,$01,$87,$01,$98,$01,$a9,$01,$ba,$01,
  $cb,$01,$dc,$01,$ed,$01,$fe,$01,$0f,$02,$20,$02,$31,$02,$42,$02,$53,$02,
  $64,$02,$75,$02,$86,$02,$97,$02,$a8,$02,$b9,$02,$ca,$02,$db,$02,$ec,$02,
  $fd,$02,$0e,$03,$1f,$03,$30,$03,$41,$03,$52,$03,$63,$03,$74,$03,$85,$03,
  $96,$03,$a7,$03,$b8,$03,$c9,$03,$da,$03,$eb,$03,$fc,$03,$0d,$04,$1e,$04,
  $2f,$04,$40,$04,$51,$04,$62,$04,$73,$04,$84,$04,$95,$04,$a6,$04,$b7,$04,
  $c8,$04,$d9,$04,$ea,$04,$fb,$04,$0c,$05,$1d,$05,$2e,$05,$3f,$05,$50,$05,
  $61,$05,$72,$05,$83,$05,$94,$05,$a5,$05,$b6,$05,$c7,$05,$d8,$05,$e9,$05,
  $fa,$05,$0b,$06,$1c,$06,$2d,$06,$3e,$06,$4f,$06,

  8, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $21 '!'
  $00,$00,$10,$38,$38,$38,$38,$10,$10,$00,$10,$10,$00,$00,$00,$00,

  8, // $22 '"'
  $00,$24,$24,$24,$24,$48,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $23 '#'
  $00,$00,$24,$24,$24,$7e,$24,$24,$7e,$24,$24,$24,$00,$00,$00,$00,

  8, // $24 '$'
  $00,$14,$14,$3e,$55,$54,$54,$3e,$15,$15,$55,$3e,$14,$14,$00,$00,

  8, // $25 '%'
  $00,$00,$32,$56,$6c,$04,$08,$08,$10,$13,$25,$26,$00,$00,$00,$00,

  8, // $26 '&'
  $00,$00,$18,$24,$24,$24,$18,$28,$45,$46,$44,$3b,$00,$00,$00,$00,

  8, // $27 '''
  $00,$00,$08,$08,$08,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $28 '('
  $00,$04,$08,$10,$10,$20,$20,$20,$20,$10,$10,$08,$04,$00,$00,$00,

  8, // $29 ')'
  $00,$10,$08,$04,$04,$02,$02,$02,$02,$04,$04,$08,$10,$00,$00,$00,

  8, // $2a '*'
  $00,$00,$00,$00,$66,$24,$18,$ff,$18,$24,$66,$00,$00,$00,$00,$00,

  8, // $2b '+'
  $00,$00,$00,$00,$08,$08,$08,$7f,$08,$08,$08,$00,$00,$00,$00,$00,

  8, // $2c ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$18,$18,$30,$20,$00,

  8, // $2d '-'
  $00,$00,$00,$00,$00,$00,$00,$7f,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$18,$00,$00,$00,$00,

  8, // $2f '/'
  $00,$02,$02,$04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$00,$00,$00,

  8, // $30 '0'
  $00,$00,$3c,$42,$42,$46,$4a,$52,$62,$42,$42,$3c,$00,$00,$00,$00,

  8, // $31 '1'
  $00,$00,$08,$08,$18,$38,$08,$08,$08,$08,$08,$3e,$00,$00,$00,$00,

  8, // $32 '2'
  $00,$00,$3c,$42,$42,$02,$04,$08,$10,$20,$42,$7e,$00,$00,$00,$00,

  8, // $33 '3'
  $00,$00,$7e,$42,$04,$08,$1c,$02,$02,$02,$42,$3c,$00,$00,$00,$00,

  8, // $34 '4'
  $00,$00,$04,$08,$10,$24,$44,$44,$7e,$04,$04,$0e,$00,$00,$00,$00,

  8, // $35 '5'
  $00,$00,$7e,$42,$40,$40,$7c,$02,$02,$02,$42,$3c,$00,$00,$00,$00,

  8, // $36 '6'
  $00,$00,$1c,$20,$40,$40,$7c,$42,$42,$42,$42,$3c,$00,$00,$00,$00,

  8, // $37 '7'
  $00,$00,$7e,$42,$42,$02,$04,$08,$10,$10,$10,$10,$00,$00,$00,$00,

  8, // $38 '8'
  $00,$00,$3c,$42,$42,$42,$3c,$42,$42,$42,$42,$3c,$00,$00,$00,$00,

  8, // $39 '9'
  $00,$00,$3c,$42,$42,$42,$42,$3e,$02,$02,$04,$38,$00,$00,$00,$00,

  8, // $3a ':'
  $00,$00,$00,$00,$18,$00,$00,$00,$00,$18,$00,$00,$00,$00,$00,$00,

  8, // $3b ';'
  $00,$00,$00,$00,$30,$00,$00,$00,$00,$00,$30,$30,$30,$60,$40,$00,

  8, // $3c '<'
  $00,$00,$00,$02,$04,$08,$10,$20,$10,$08,$04,$02,$00,$00,$00,$00,

  8, // $3d '='
  $00,$00,$00,$00,$00,$00,$7f,$00,$7f,$00,$00,$00,$00,$00,$00,$00,

  8, // $3e '>'
  $00,$00,$00,$20,$10,$08,$04,$02,$04,$08,$10,$20,$00,$00,$00,$00,

  8, // $3f '?'
  $00,$00,$3c,$42,$42,$42,$04,$08,$08,$00,$08,$08,$00,$00,$00,$00,

  8, // $40 '@'
  $00,$00,$3c,$42,$01,$39,$49,$49,$49,$49,$49,$36,$00,$00,$00,$00,

  8, // $41 'A'
  $00,$00,$18,$24,$42,$42,$42,$7e,$42,$42,$42,$42,$00,$00,$00,$00,

  8, // $42 'B'
  $00,$00,$7c,$22,$22,$22,$3c,$22,$22,$22,$22,$7c,$00,$00,$00,$00,

  8, // $43 'C'
  $00,$00,$3c,$42,$42,$40,$40,$40,$40,$42,$42,$3c,$00,$00,$00,$00,

  8, // $44 'D'
  $00,$00,$7c,$22,$22,$22,$22,$22,$22,$22,$22,$7c,$00,$00,$00,$00,

  8, // $45 'E'
  $00,$00,$7e,$22,$20,$28,$38,$28,$20,$20,$22,$7e,$00,$00,$00,$00,

  8, // $46 'F'
  $00,$00,$7e,$22,$20,$28,$38,$28,$20,$20,$20,$70,$00,$00,$00,$00,

  8, // $47 'G'
  $00,$00,$3c,$42,$42,$40,$40,$4e,$42,$42,$42,$3c,$00,$00,$00,$00,

  8, // $48 'H'
  $00,$00,$42,$42,$42,$42,$7e,$42,$42,$42,$42,$42,$00,$00,$00,$00,

  8, // $49 'I'
  $00,$00,$1c,$08,$08,$08,$08,$08,$08,$08,$08,$1c,$00,$00,$00,$00,

  8, // $4a 'J'
  $00,$00,$0e,$04,$04,$04,$04,$04,$04,$44,$44,$38,$00,$00,$00,$00,

  8, // $4b 'K'
  $00,$00,$62,$22,$24,$28,$30,$28,$24,$22,$22,$62,$00,$00,$00,$00,

  8, // $4c 'L'
  $00,$00,$70,$20,$20,$20,$20,$20,$20,$20,$22,$7e,$00,$00,$00,$00,

  8, // $4d 'M'
  $00,$00,$41,$63,$55,$49,$41,$41,$41,$41,$41,$41,$00,$00,$00,$00,

  8, // $4e 'N'
  $00,$00,$42,$42,$62,$52,$4a,$46,$42,$42,$42,$42,$00,$00,$00,$00,

  8, // $4f 'O'
  $00,$00,$3c,$42,$42,$42,$42,$42,$42,$42,$42,$3c,$00,$00,$00,$00,

  8, // $50 'P'
  $00,$00,$7c,$22,$22,$22,$22,$3c,$20,$20,$20,$70,$00,$00,$00,$00,

  8, // $51 'Q'
  $00,$00,$3c,$42,$42,$42,$42,$42,$42,$4a,$44,$3a,$02,$00,$00,$00,

  8, // $52 'R'
  $00,$00,$7c,$22,$22,$22,$22,$3c,$28,$24,$22,$62,$00,$00,$00,$00,

  8, // $53 'S'
  $00,$00,$3c,$42,$42,$40,$30,$0c,$02,$42,$42,$3c,$00,$00,$00,$00,

  8, // $54 'T'
  $00,$00,$7f,$49,$08,$08,$08,$08,$08,$08,$08,$1c,$00,$00,$00,$00,

  8, // $55 'U'
  $00,$00,$42,$42,$42,$42,$42,$42,$42,$42,$42,$3c,$00,$00,$00,$00,

  8, // $56 'V'
  $00,$00,$41,$41,$41,$41,$22,$22,$14,$14,$08,$08,$00,$00,$00,$00,

  8, // $57 'W'
  $00,$00,$41,$41,$41,$41,$41,$49,$49,$55,$63,$41,$00,$00,$00,$00,

  8, // $58 'X'
  $00,$00,$42,$42,$42,$24,$18,$18,$24,$42,$42,$42,$00,$00,$00,$00,

  8, // $59 'Y'
  $00,$00,$22,$22,$22,$22,$14,$08,$08,$08,$08,$1c,$00,$00,$00,$00,

  8, // $5a 'Z'
  $00,$00,$7e,$42,$02,$04,$08,$10,$20,$40,$42,$7e,$00,$00,$00,$00,

  8, // $5b '['
  $00,$1e,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$1e,$00,$00,$00,

  8, // $5c '\'
  $00,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$02,$02,$00,$00,$00,

  8, // $5d ']'
  $00,$3c,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$3c,$00,$00,$00,

  8, // $5e '^'
  $00,$00,$08,$14,$22,$41,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$ff,$00,$00,$00,$00,

  8, // $60 '`'
  $00,$00,$08,$08,$08,$04,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $61 'a'
  $00,$00,$00,$00,$00,$38,$44,$04,$3c,$44,$44,$3e,$00,$00,$00,$00,

  8, // $62 'b'
  $00,$00,$60,$20,$20,$38,$24,$22,$22,$22,$22,$3c,$00,$00,$00,$00,

  8, // $63 'c'
  $00,$00,$00,$00,$00,$3c,$42,$40,$40,$40,$42,$3c,$00,$00,$00,$00,

  8, // $64 'd'
  $00,$00,$0c,$04,$04,$1c,$24,$44,$44,$44,$44,$3e,$00,$00,$00,$00,

  8, // $65 'e'
  $00,$00,$00,$00,$00,$3c,$42,$42,$7e,$40,$42,$3c,$00,$00,$00,$00,

  8, // $66 'f'
  $00,$00,$0c,$12,$10,$10,$38,$10,$10,$10,$10,$38,$00,$00,$00,$00,

  8, // $67 'g'
  $00,$00,$00,$00,$00,$3e,$44,$44,$44,$44,$44,$3c,$04,$44,$38,$00,

  8, // $68 'h'
  $00,$00,$60,$20,$20,$2c,$32,$22,$22,$22,$22,$62,$00,$00,$00,$00,

  8, // $69 'i'
  $00,$00,$08,$08,$00,$18,$08,$08,$08,$08,$08,$1c,$00,$00,$00,$00,

  8, // $6a 'j'
  $00,$00,$04,$04,$00,$0c,$04,$04,$04,$04,$04,$44,$44,$38,$00,$00,

  8, // $6b 'k'
  $00,$00,$60,$20,$20,$22,$24,$28,$38,$24,$22,$62,$00,$00,$00,$00,

  8, // $6c 'l'
  $00,$00,$18,$08,$08,$08,$08,$08,$08,$08,$08,$1c,$00,$00,$00,$00,

  8, // $6d 'm'
  $00,$00,$00,$00,$00,$76,$49,$49,$49,$49,$41,$41,$00,$00,$00,$00,

  8, // $6e 'n'
  $00,$00,$00,$00,$00,$5c,$22,$22,$22,$22,$22,$22,$00,$00,$00,$00,

  8, // $6f 'o'
  $00,$00,$00,$00,$00,$3c,$42,$42,$42,$42,$42,$3c,$00,$00,$00,$00,

  8, // $70 'p'
  $00,$00,$00,$00,$00,$7c,$22,$22,$22,$22,$22,$3c,$20,$20,$70,$00,

  8, // $71 'q'
  $00,$00,$00,$00,$00,$3e,$44,$44,$44,$44,$44,$3c,$04,$04,$0e,$00,

  8, // $72 'r'
  $00,$00,$00,$00,$00,$7c,$22,$22,$20,$20,$20,$70,$00,$00,$00,$00,

  8, // $73 's'
  $00,$00,$00,$00,$00,$3c,$42,$40,$3c,$02,$42,$3c,$00,$00,$00,$00,

  8, // $74 't'
  $00,$00,$10,$10,$10,$7c,$10,$10,$10,$10,$12,$0c,$00,$00,$00,$00,

  8, // $75 'u'
  $00,$00,$00,$00,$00,$44,$44,$44,$44,$44,$44,$3e,$00,$00,$00,$00,

  8, // $76 'v'
  $00,$00,$00,$00,$00,$41,$41,$41,$41,$22,$14,$08,$00,$00,$00,$00,

  8, // $77 'w'
  $00,$00,$00,$00,$00,$41,$41,$41,$49,$49,$55,$22,$00,$00,$00,$00,

  8, // $78 'x'
  $00,$00,$00,$00,$00,$42,$42,$24,$18,$24,$42,$42,$00,$00,$00,$00,

  8, // $79 'y'
  $00,$00,$00,$00,$00,$42,$42,$42,$42,$42,$42,$3e,$02,$04,$78,$00,

  8, // $7a 'z'
  $00,$00,$00,$00,$00,$7e,$44,$08,$10,$20,$42,$7e,$00,$00,$00,$00,

  8, // $7b '{'
  $00,$06,$08,$08,$08,$08,$08,$30,$08,$08,$08,$08,$08,$06,$00,$00,

  8, // $7c '|'
  $00,$00,$08,$08,$08,$08,$08,$00,$08,$08,$08,$08,$08,$00,$00,$00,

  8, // $7d '}'
  $00,$30,$08,$08,$08,$08,$08,$06,$08,$08,$08,$08,$08,$30,$00,$00,

  8, // $7e '~'
  $00,$00,$39,$4e,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $7f ''
  $00,$00,$00,$00,$00,$08,$14,$22,$41,$41,$7f,$00,$00,$00,$00,$00,
  0 );

 gse8x16_bold : array[0..1828 ] of int8u = (
  16, 0, 32, 128-32,

  $00,$00,$11,$00,$22,$00,$33,$00,$44,$00,$55,$00,$66,$00,$77,$00,$88,$00,
  $99,$00,$aa,$00,$bb,$00,$cc,$00,$dd,$00,$ee,$00,$ff,$00,$10,$01,$21,$01,
  $32,$01,$43,$01,$54,$01,$65,$01,$76,$01,$87,$01,$98,$01,$a9,$01,$ba,$01,
  $cb,$01,$dc,$01,$ed,$01,$fe,$01,$0f,$02,$20,$02,$31,$02,$42,$02,$53,$02,
  $64,$02,$75,$02,$86,$02,$97,$02,$a8,$02,$b9,$02,$ca,$02,$db,$02,$ec,$02,
  $fd,$02,$0e,$03,$1f,$03,$30,$03,$41,$03,$52,$03,$63,$03,$74,$03,$85,$03,
  $96,$03,$a7,$03,$b8,$03,$c9,$03,$da,$03,$eb,$03,$fc,$03,$0d,$04,$1e,$04,
  $2f,$04,$40,$04,$51,$04,$62,$04,$73,$04,$84,$04,$95,$04,$a6,$04,$b7,$04,
  $c8,$04,$d9,$04,$ea,$04,$fb,$04,$0c,$05,$1d,$05,$2e,$05,$3f,$05,$50,$05,
  $61,$05,$72,$05,$83,$05,$94,$05,$a5,$05,$b6,$05,$c7,$05,$d8,$05,$e9,$05,
  $fa,$05,$0b,$06,$1c,$06,$2d,$06,$3e,$06,$4f,$06,

  8, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $21 '!'
  $00,$00,$18,$3c,$3c,$3c,$3c,$18,$18,$00,$18,$18,$00,$00,$00,$00,

  8, // $22 '"'
  $00,$66,$66,$66,$66,$24,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $23 '#'
  $00,$00,$66,$66,$66,$ff,$66,$66,$ff,$66,$66,$66,$00,$00,$00,$00,

  8, // $24 '$'
  $00,$08,$08,$3e,$6b,$6b,$68,$3e,$0b,$6b,$6b,$3e,$08,$08,$00,$00,

  8, // $25 '%'
  $00,$00,$66,$be,$cc,$0c,$18,$18,$30,$33,$65,$66,$00,$00,$00,$00,

  8, // $26 '&'
  $00,$00,$1c,$36,$36,$36,$1c,$3b,$6e,$66,$66,$3b,$00,$00,$00,$00,

  8, // $27 '''
  $00,$00,$18,$18,$18,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $28 '('
  $00,$06,$0c,$18,$18,$30,$30,$30,$30,$18,$18,$0c,$06,$00,$00,$00,

  8, // $29 ')'
  $00,$30,$18,$0c,$0c,$06,$06,$06,$06,$0c,$0c,$18,$30,$00,$00,$00,

  8, // $2a '*'
  $00,$00,$00,$00,$66,$24,$18,$ff,$18,$24,$66,$00,$00,$00,$00,$00,

  8, // $2b '+'
  $00,$00,$00,$00,$18,$18,$18,$ff,$18,$18,$18,$00,$00,$00,$00,$00,

  8, // $2c ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$18,$18,$30,$20,$00,

  8, // $2d '-'
  $00,$00,$00,$00,$00,$00,$00,$7f,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $2e '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$18,$00,$00,$00,$00,

  8, // $2f '/'
  $00,$03,$03,$06,$06,$0c,$0c,$18,$18,$30,$30,$60,$60,$00,$00,$00,

  8, // $30 '0'
  $00,$00,$3e,$63,$63,$67,$6b,$73,$63,$63,$63,$3e,$00,$00,$00,$00,

  8, // $31 '1'
  $00,$00,$0c,$0c,$1c,$3c,$0c,$0c,$0c,$0c,$0c,$3f,$00,$00,$00,$00,

  8, // $32 '2'
  $00,$00,$3e,$63,$63,$03,$06,$0c,$18,$30,$61,$7f,$00,$00,$00,$00,

  8, // $33 '3'
  $00,$00,$7f,$43,$06,$0c,$1e,$03,$03,$03,$63,$3e,$00,$00,$00,$00,

  8, // $34 '4'
  $00,$00,$06,$0c,$18,$32,$66,$66,$7f,$06,$06,$0f,$00,$00,$00,$00,

  8, // $35 '5'
  $00,$00,$7f,$61,$60,$60,$7e,$03,$03,$03,$63,$3e,$00,$00,$00,$00,

  8, // $36 '6'
  $00,$00,$1e,$30,$60,$60,$7e,$63,$63,$63,$63,$3e,$00,$00,$00,$00,

  8, // $37 '7'
  $00,$00,$7f,$63,$63,$03,$06,$0c,$18,$18,$18,$18,$00,$00,$00,$00,

  8, // $38 '8'
  $00,$00,$3e,$63,$63,$63,$3e,$63,$63,$63,$63,$3e,$00,$00,$00,$00,

  8, // $39 '9'
  $00,$00,$3e,$63,$63,$63,$63,$3f,$03,$03,$06,$3c,$00,$00,$00,$00,

  8, // $3a ':'
  $00,$00,$00,$00,$18,$18,$00,$00,$00,$18,$18,$00,$00,$00,$00,$00,

  8, // $3b ';'
  $00,$00,$00,$00,$30,$30,$00,$00,$00,$00,$30,$30,$30,$60,$40,$00,

  8, // $3c '<'
  $00,$00,$00,$06,$0c,$18,$30,$60,$30,$18,$0c,$06,$00,$00,$00,$00,

  8, // $3d '='
  $00,$00,$00,$00,$00,$00,$7f,$00,$7f,$00,$00,$00,$00,$00,$00,$00,

  8, // $3e '>'
  $00,$00,$00,$30,$18,$0c,$06,$03,$06,$0c,$18,$30,$00,$00,$00,$00,

  8, // $3f '?'
  $00,$00,$3e,$63,$63,$63,$06,$0c,$0c,$00,$0c,$0c,$00,$00,$00,$00,

  8, // $40 '@'
  $00,$00,$7c,$86,$03,$73,$db,$db,$db,$db,$db,$6e,$00,$00,$00,$00,

  8, // $41 'A'
  $00,$00,$08,$1c,$36,$63,$63,$63,$7f,$63,$63,$63,$00,$00,$00,$00,

  8, // $42 'B'
  $00,$00,$7e,$33,$33,$33,$3e,$33,$33,$33,$33,$7e,$00,$00,$00,$00,

  8, // $43 'C'
  $00,$00,$1e,$33,$61,$60,$60,$60,$60,$61,$33,$1e,$00,$00,$00,$00,

  8, // $44 'D'
  $00,$00,$7c,$36,$33,$33,$33,$33,$33,$33,$36,$7c,$00,$00,$00,$00,

  8, // $45 'E'
  $00,$00,$7f,$33,$31,$34,$3c,$34,$30,$31,$33,$7f,$00,$00,$00,$00,

  8, // $46 'F'
  $00,$00,$7f,$33,$31,$34,$3c,$34,$30,$30,$30,$78,$00,$00,$00,$00,

  8, // $47 'G'
  $00,$00,$1f,$33,$61,$60,$60,$6f,$63,$63,$33,$1e,$00,$00,$00,$00,

  8, // $48 'H'
  $00,$00,$63,$63,$63,$63,$7f,$63,$63,$63,$63,$63,$00,$00,$00,$00,

  8, // $49 'I'
  $00,$00,$1e,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$1e,$00,$00,$00,$00,

  8, // $4a 'J'
  $00,$00,$0f,$06,$06,$06,$06,$06,$06,$66,$66,$3c,$00,$00,$00,$00,

  8, // $4b 'K'
  $00,$00,$73,$33,$36,$36,$3c,$36,$36,$33,$33,$73,$00,$00,$00,$00,

  8, // $4c 'L'
  $00,$00,$78,$30,$30,$30,$30,$30,$30,$31,$33,$7f,$00,$00,$00,$00,

  8, // $4d 'M'
  $00,$00,$63,$63,$77,$77,$7f,$6b,$6b,$63,$63,$63,$00,$00,$00,$00,

  8, // $4e 'N'
  $00,$00,$63,$63,$73,$7b,$6f,$67,$63,$63,$63,$63,$00,$00,$00,$00,

  8, // $4f 'O'
  $00,$00,$1c,$36,$63,$63,$63,$63,$63,$63,$36,$1c,$00,$00,$00,$00,

  8, // $50 'P'
  $00,$00,$7e,$33,$33,$33,$33,$3e,$30,$30,$30,$78,$00,$00,$00,$00,

  8, // $51 'Q'
  $00,$00,$1c,$36,$63,$63,$63,$63,$63,$6f,$36,$1e,$03,$00,$00,$00,

  8, // $52 'R'
  $00,$00,$7e,$33,$33,$33,$33,$3e,$36,$33,$33,$73,$00,$00,$00,$00,

  8, // $53 'S'
  $00,$00,$3e,$63,$63,$30,$18,$0c,$06,$63,$63,$3e,$00,$00,$00,$00,

  8, // $54 'T'
  $00,$00,$3f,$3f,$2d,$0c,$0c,$0c,$0c,$0c,$0c,$1e,$00,$00,$00,$00,

  8, // $55 'U'
  $00,$00,$63,$63,$63,$63,$63,$63,$63,$63,$63,$3e,$00,$00,$00,$00,

  8, // $56 'V'
  $00,$00,$63,$63,$63,$63,$63,$63,$63,$36,$1c,$08,$00,$00,$00,$00,

  8, // $57 'W'
  $00,$00,$63,$63,$63,$6b,$6b,$7f,$77,$77,$63,$63,$00,$00,$00,$00,

  8, // $58 'X'
  $00,$00,$63,$63,$63,$36,$1c,$1c,$36,$63,$63,$63,$00,$00,$00,$00,

  8, // $59 'Y'
  $00,$00,$33,$33,$33,$33,$1e,$0c,$0c,$0c,$0c,$1e,$00,$00,$00,$00,

  8, // $5a 'Z'
  $00,$00,$7f,$63,$43,$06,$0c,$18,$30,$61,$63,$7f,$00,$00,$00,$00,

  8, // $5b '['
  $00,$1f,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$1f,$00,$00,$00,

  8, // $5c '\'
  $00,$60,$60,$30,$30,$18,$18,$0c,$0c,$06,$06,$03,$03,$00,$00,$00,

  8, // $5d ']'
  $00,$7c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$7c,$00,$00,$00,

  8, // $5e '^'
  $00,$00,$08,$1c,$36,$63,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $5f '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$ff,$00,$00,$00,$00,

  8, // $60 '`'
  $00,$00,$18,$18,$18,$0c,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $61 'a'
  $00,$00,$00,$00,$00,$3c,$66,$06,$3e,$66,$66,$3b,$00,$00,$00,$00,

  8, // $62 'b'
  $00,$00,$70,$30,$30,$3c,$36,$33,$33,$33,$33,$3e,$00,$00,$00,$00,

  8, // $63 'c'
  $00,$00,$00,$00,$00,$3e,$63,$63,$60,$60,$63,$3e,$00,$00,$00,$00,

  8, // $64 'd'
  $00,$00,$0e,$06,$06,$1e,$36,$66,$66,$66,$66,$3b,$00,$00,$00,$00,

  8, // $65 'e'
  $00,$00,$00,$00,$00,$3e,$63,$63,$7f,$60,$63,$3e,$00,$00,$00,$00,

  8, // $66 'f'
  $00,$00,$0e,$1b,$1b,$18,$3c,$18,$18,$18,$18,$3c,$00,$00,$00,$00,

  8, // $67 'g'
  $00,$00,$00,$00,$00,$3b,$66,$66,$66,$66,$66,$3e,$06,$66,$3c,$00,

  8, // $68 'h'
  $00,$00,$70,$30,$30,$36,$3b,$33,$33,$33,$33,$73,$00,$00,$00,$00,

  8, // $69 'i'
  $00,$00,$0c,$0c,$00,$1c,$0c,$0c,$0c,$0c,$0c,$1e,$00,$00,$00,$00,

  8, // $6a 'j'
  $00,$00,$06,$06,$00,$0e,$06,$06,$06,$06,$06,$66,$66,$3c,$00,$00,

  8, // $6b 'k'
  $00,$00,$70,$30,$30,$33,$33,$36,$3c,$36,$33,$73,$00,$00,$00,$00,

  8, // $6c 'l'
  $00,$00,$1c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$1e,$00,$00,$00,$00,

  8, // $6d 'm'
  $00,$00,$00,$00,$00,$76,$7f,$6b,$6b,$6b,$63,$63,$00,$00,$00,$00,

  8, // $6e 'n'
  $00,$00,$00,$00,$00,$6e,$33,$33,$33,$33,$33,$33,$00,$00,$00,$00,

  8, // $6f 'o'
  $00,$00,$00,$00,$00,$3e,$63,$63,$63,$63,$63,$3e,$00,$00,$00,$00,

  8, // $70 'p'
  $00,$00,$00,$00,$00,$6e,$33,$33,$33,$33,$33,$3e,$30,$30,$78,$00,

  8, // $71 'q'
  $00,$00,$00,$00,$00,$3b,$66,$66,$66,$66,$66,$3e,$06,$06,$0f,$00,

  8, // $72 'r'
  $00,$00,$00,$00,$00,$6e,$3b,$33,$30,$30,$30,$78,$00,$00,$00,$00,

  8, // $73 's'
  $00,$00,$00,$00,$00,$3e,$63,$60,$3e,$03,$63,$3e,$00,$00,$00,$00,

  8, // $74 't'
  $00,$00,$08,$18,$18,$7e,$18,$18,$18,$18,$1b,$0e,$00,$00,$00,$00,

  8, // $75 'u'
  $00,$00,$00,$00,$00,$66,$66,$66,$66,$66,$66,$3b,$00,$00,$00,$00,

  8, // $76 'v'
  $00,$00,$00,$00,$00,$63,$63,$63,$63,$36,$1c,$08,$00,$00,$00,$00,

  8, // $77 'w'
  $00,$00,$00,$00,$00,$63,$63,$6b,$6b,$7f,$36,$36,$00,$00,$00,$00,

  8, // $78 'x'
  $00,$00,$00,$00,$00,$63,$63,$36,$1c,$36,$63,$63,$00,$00,$00,$00,

  8, // $79 'y'
  $00,$00,$00,$00,$00,$63,$63,$63,$63,$63,$63,$3f,$03,$06,$7c,$00,

  8, // $7a 'z'
  $00,$00,$00,$00,$00,$7f,$63,$06,$0c,$18,$31,$7f,$00,$00,$00,$00,

  8, // $7b '{'
  $00,$03,$04,$0c,$0c,$0c,$08,$30,$08,$0c,$0c,$0c,$04,$03,$00,$00,

  8, // $7c '|'
  $00,$00,$0c,$0c,$0c,$0c,$0c,$00,$0c,$0c,$0c,$0c,$0c,$00,$00,$00,

  8, // $7d '}'
  $00,$60,$10,$18,$18,$18,$08,$06,$08,$18,$18,$18,$10,$60,$00,$00,

  8, // $7e '~'
  $00,$00,$3b,$6e,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $7f ''
  $00,$00,$00,$00,$00,$08,$1c,$36,$63,$63,$7f,$00,$00,$00,$00,$00,
  0 );

 mcs11_prop : array[0..1348 ] of int8u = (
  11, 2, 32, 128-32,
  $00,$00,$0C,$00,$18,$00,$24,$00,$30,$00,$3C,$00,$48,$00,$54,$00,$60,$00,
  $6C,$00,$78,$00,$84,$00,$90,$00,$9C,$00,$A8,$00,$B4,$00,$C0,$00,$CC,$00,
  $D8,$00,$E4,$00,$F0,$00,$FC,$00,$08,$01,$14,$01,$20,$01,$2C,$01,$38,$01,
  $44,$01,$50,$01,$5C,$01,$68,$01,$74,$01,$80,$01,$8C,$01,$98,$01,$A4,$01,
  $B0,$01,$BC,$01,$C8,$01,$D4,$01,$E0,$01,$EC,$01,$F8,$01,$04,$02,$10,$02,
  $1C,$02,$28,$02,$34,$02,$40,$02,$4C,$02,$58,$02,$64,$02,$70,$02,$7C,$02,
  $88,$02,$94,$02,$A0,$02,$AC,$02,$B8,$02,$C4,$02,$D0,$02,$DC,$02,$E8,$02,
  $F4,$02,$00,$03,$0C,$03,$18,$03,$24,$03,$30,$03,$3C,$03,$48,$03,$54,$03,
  $60,$03,$6C,$03,$78,$03,$84,$03,$90,$03,$9C,$03,$A8,$03,$B4,$03,$C0,$03,
  $CC,$03,$D8,$03,$E4,$03,$F0,$03,$FC,$03,$08,$04,$14,$04,$20,$04,$2C,$04,
  $38,$04,$44,$04,$50,$04,$5C,$04,$68,$04,$74,$04,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $00,$20,$20,$20,$20,$20,$20,$20,$00,$20,$00,

  4, // $22 '"'
  $50,$50,$A0,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $23 '#'
  $00,$28,$28,$7C,$28,$28,$28,$7C,$28,$28,$00,

  6, // $24 '$'
  $10,$10,$38,$54,$50,$38,$14,$54,$38,$10,$10,

  6, // $25 '%'
  $00,$00,$68,$A8,$D0,$10,$20,$2C,$54,$58,$00,

  6, // $26 '&'
  $00,$20,$50,$50,$50,$20,$54,$54,$48,$34,$00,

  3, // $27 '''
  $40,$40,$80,$00,$00,$00,$00,$00,$00,$00,$00,

  4, // $28 '('
  $10,$20,$20,$40,$40,$40,$40,$40,$20,$20,$10,

  5, // $29 ')'
  $40,$20,$20,$10,$10,$10,$10,$10,$20,$20,$40,

  6, // $2A '*'
  $00,$00,$28,$7C,$38,$7C,$28,$00,$00,$00,$00,

  6, // $2B '+'
  $00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$C0,

  6, // $2D '-'
  $00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$00,

  7, // $2F '/'
  $00,$04,$04,$08,$08,$10,$10,$20,$20,$40,$40,

  6, // $30 '0'
  $00,$38,$44,$44,$54,$54,$54,$44,$44,$38,$00,

  4, // $31 '1'
  $00,$20,$60,$20,$20,$20,$20,$20,$20,$20,$00,

  6, // $32 '2'
  $00,$38,$44,$44,$04,$08,$10,$20,$40,$7C,$00,

  6, // $33 '3'
  $00,$38,$44,$04,$04,$38,$04,$04,$44,$38,$00,

  6, // $34 '4'
  $00,$08,$18,$18,$28,$28,$48,$7C,$08,$08,$00,

  6, // $35 '5'
  $00,$7C,$40,$40,$78,$44,$04,$04,$44,$38,$00,

  6, // $36 '6'
  $00,$38,$44,$40,$40,$78,$44,$44,$44,$38,$00,

  6, // $37 '7'
  $00,$7C,$04,$08,$08,$10,$10,$20,$20,$20,$00,

  6, // $38 '8'
  $00,$38,$44,$44,$44,$38,$44,$44,$44,$38,$00,

  6, // $39 '9'
  $00,$38,$44,$44,$44,$3C,$04,$04,$44,$38,$00,

  4, // $3A ':'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$00,

  4, // $3B ';'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$C0,

  6, // $3C '<'
  $00,$04,$08,$10,$20,$40,$20,$10,$08,$04,$00,

  6, // $3D '='
  $00,$00,$00,$00,$7C,$00,$00,$7C,$00,$00,$00,

  6, // $3E '>'
  $00,$40,$20,$10,$08,$04,$08,$10,$20,$40,$00,

  6, // $3F '?'
  $00,$38,$44,$04,$04,$08,$10,$10,$00,$10,$00,

  6, // $40 '@'
  $00,$38,$44,$44,$5C,$54,$54,$4C,$40,$38,$00,

  6, // $41 'A'
  $00,$38,$44,$44,$44,$44,$7C,$44,$44,$44,$00,

  6, // $42 'B'
  $00,$78,$44,$44,$44,$78,$44,$44,$44,$78,$00,

  6, // $43 'C'
  $00,$38,$44,$40,$40,$40,$40,$40,$44,$38,$00,

  6, // $44 'D'
  $00,$70,$48,$44,$44,$44,$44,$44,$48,$70,$00,

  6, // $45 'E'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$7C,$00,

  6, // $46 'F'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$40,$00,

  6, // $47 'G'
  $00,$38,$44,$40,$40,$5C,$44,$44,$4C,$34,$00,

  6, // $48 'H'
  $00,$44,$44,$44,$44,$7C,$44,$44,$44,$44,$00,

  4, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$20,$20,$70,$00,

  6, // $4A 'J'
  $00,$1C,$08,$08,$08,$08,$08,$08,$48,$30,$00,

  6, // $4B 'K'
  $00,$44,$48,$50,$60,$60,$50,$48,$44,$44,$00,

  6, // $4C 'L'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$7C,$00,

  8, // $4D 'M'
  $00,$41,$63,$55,$49,$49,$41,$41,$41,$41,$00,

  7, // $4E 'N'
  $00,$42,$42,$62,$52,$4A,$46,$42,$42,$42,$00,

  6, // $4F 'O'
  $00,$38,$44,$44,$44,$44,$44,$44,$44,$38,$00,

  6, // $50 'P'
  $00,$78,$44,$44,$44,$78,$40,$40,$40,$40,$00,

  6, // $51 'Q'
  $00,$38,$44,$44,$44,$44,$44,$54,$48,$34,$00,

  6, // $52 'R'
  $00,$78,$44,$44,$44,$78,$44,$44,$44,$44,$00,

  6, // $53 'S'
  $00,$38,$44,$40,$40,$38,$04,$04,$44,$38,$00,

  6, // $54 'T'
  $00,$7C,$10,$10,$10,$10,$10,$10,$10,$10,$00,

  6, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$44,$44,$38,$00,

  6, // $56 'V'
  $00,$44,$44,$44,$44,$28,$28,$28,$10,$10,$00,

  8, // $57 'W'
  $00,$41,$41,$41,$41,$49,$49,$49,$55,$22,$00,

  6, // $58 'X'
  $00,$44,$44,$44,$28,$10,$28,$44,$44,$44,$00,

  6, // $59 'Y'
  $00,$44,$44,$44,$28,$10,$10,$10,$10,$10,$00,

  6, // $5A 'Z'
  $00,$7C,$04,$04,$08,$10,$20,$40,$40,$7C,$00,

  5, // $5B '['
  $30,$20,$20,$20,$20,$20,$20,$20,$20,$20,$30,

  7, // $5C '\'
  $40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$00,

  4, // $5D ']'
  $60,$20,$20,$20,$20,$20,$20,$20,$20,$20,$60,

  6, // $5E '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,

  6, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,

  4, // $60 '`'
  $00,$40,$40,$20,$00,$00,$00,$00,$00,$00,$00,

  6, // $61 'a'
  $00,$00,$00,$38,$04,$3C,$44,$44,$44,$3C,$00,

  6, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$78,$00,

  6, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$40,$44,$38,$00,

  6, // $64 'd'
  $00,$04,$04,$3C,$44,$44,$44,$44,$44,$3C,$00,

  6, // $65 'e'
  $00,$00,$00,$38,$44,$44,$7C,$40,$44,$38,$00,

  4, // $66 'f'
  $00,$10,$20,$70,$20,$20,$20,$20,$20,$20,$00,

  6, // $67 'g'
  $00,$00,$00,$3C,$44,$44,$44,$3C,$04,$44,$38,

  6, // $68 'h'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$44,$00,

  2, // $69 'i'
  $00,$40,$00,$40,$40,$40,$40,$40,$40,$40,$00,

  3, // $6A 'j'
  $00,$20,$00,$20,$20,$20,$20,$20,$20,$A0,$40,

  5, // $6B 'k'
  $00,$40,$40,$48,$50,$60,$60,$50,$48,$48,$00,

  2, // $6C 'l'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,

  8, // $6D 'm'
  $00,$00,$00,$76,$49,$49,$49,$49,$41,$41,$00,

  6, // $6E 'n'
  $00,$00,$00,$78,$44,$44,$44,$44,$44,$44,$00,

  6, // $6F 'o'
  $00,$00,$00,$38,$44,$44,$44,$44,$44,$38,$00,

  6, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$44,$78,$40,$40,

  6, // $71 'q'
  $00,$00,$00,$3C,$44,$44,$44,$44,$3C,$04,$04,

  6, // $72 'r'
  $00,$00,$00,$58,$24,$20,$20,$20,$20,$20,$00,

  6, // $73 's'
  $00,$00,$00,$38,$44,$40,$38,$04,$44,$38,$00,

  5, // $74 't'
  $00,$20,$20,$70,$20,$20,$20,$20,$28,$10,$00,

  6, // $75 'u'
  $00,$00,$00,$44,$44,$44,$44,$44,$4C,$34,$00,

  6, // $76 'v'
  $00,$00,$00,$44,$44,$44,$28,$28,$10,$10,$00,

  8, // $77 'w'
  $00,$00,$00,$41,$41,$41,$41,$49,$49,$36,$00,

  6, // $78 'x'
  $00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$00,

  6, // $79 'y'
  $00,$00,$00,$44,$44,$44,$44,$3C,$04,$08,$70,

  6, // $7A 'z'
  $00,$00,$00,$7C,$04,$08,$10,$20,$40,$7C,$00,

  5, // $7B '{'
  $18,$20,$20,$20,$20,$C0,$20,$20,$20,$20,$18,

  3, // $7C '|'
  $00,$40,$40,$40,$40,$00,$40,$40,$40,$40,$00,

  5, // $7D '}'
  $C0,$20,$20,$20,$20,$18,$20,$20,$20,$20,$C0,

  6, // $7E '~'
  $00,$24,$54,$48,$00,$00,$00,$00,$00,$00,$00,

  6, // $7F ''
  $00,$10,$38,$6C,$44,$44,$7C,$00,$00,$00,$00,

  0 );

 mcs11_prop_condensed : array[0..1348 ] of int8u = (
  11, 2, 32, 128-32,
  $00,$00,$0C,$00,$18,$00,$24,$00,$30,$00,$3C,$00,$48,$00,$54,$00,$60,$00,
  $6C,$00,$78,$00,$84,$00,$90,$00,$9C,$00,$A8,$00,$B4,$00,$C0,$00,$CC,$00,
  $D8,$00,$E4,$00,$F0,$00,$FC,$00,$08,$01,$14,$01,$20,$01,$2C,$01,$38,$01,
  $44,$01,$50,$01,$5C,$01,$68,$01,$74,$01,$80,$01,$8C,$01,$98,$01,$A4,$01,
  $B0,$01,$BC,$01,$C8,$01,$D4,$01,$E0,$01,$EC,$01,$F8,$01,$04,$02,$10,$02,
  $1C,$02,$28,$02,$34,$02,$40,$02,$4C,$02,$58,$02,$64,$02,$70,$02,$7C,$02,
  $88,$02,$94,$02,$A0,$02,$AC,$02,$B8,$02,$C4,$02,$D0,$02,$DC,$02,$E8,$02,
  $F4,$02,$00,$03,$0C,$03,$18,$03,$24,$03,$30,$03,$3C,$03,$48,$03,$54,$03,
  $60,$03,$6C,$03,$78,$03,$84,$03,$90,$03,$9C,$03,$A8,$03,$B4,$03,$C0,$03,
  $CC,$03,$D8,$03,$E4,$03,$F0,$03,$FC,$03,$08,$04,$14,$04,$20,$04,$2C,$04,
  $38,$04,$44,$04,$50,$04,$5C,$04,$68,$04,$74,$04,

  3, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  3, // $21 '!'
  $00,$40,$40,$40,$40,$40,$40,$40,$00,$40,$00,

  4, // $22 '"'
  $50,$50,$A0,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $23 '#'
  $00,$50,$50,$F8,$50,$50,$50,$F8,$50,$50,$00,

  5, // $24 '$'
  $00,$40,$60,$90,$80,$60,$10,$90,$60,$20,$00,

  5, // $25 '%'
  $00,$00,$90,$90,$20,$20,$40,$40,$90,$90,$00,

  5, // $26 '&'
  $00,$40,$A0,$A0,$A0,$40,$A8,$90,$90,$68,$00,

  5, // $27 '''
  $00,$00,$20,$40,$00,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $10,$20,$20,$40,$40,$40,$40,$40,$20,$20,$10,

  4, // $29 ')'
  $80,$40,$40,$20,$20,$20,$20,$20,$40,$40,$80,

  5, // $2A '*'
  $00,$00,$90,$60,$F0,$60,$90,$00,$00,$00,$00,

  5, // $2B '+'
  $00,$00,$00,$20,$20,$F8,$20,$20,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$C0,

  5, // $2D '-'
  $00,$00,$00,$00,$00,$F0,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$C0,$C0,$00,

  6, // $2F '/'
  $08,$08,$10,$10,$20,$20,$40,$40,$80,$80,$00,

  5, // $30 '0'
  $00,$70,$90,$90,$90,$90,$90,$90,$90,$E0,$00,

  3, // $31 '1'
  $00,$40,$C0,$40,$40,$40,$40,$40,$40,$40,$00,

  5, // $32 '2'
  $00,$60,$90,$90,$10,$10,$20,$40,$80,$F0,$00,

  5, // $33 '3'
  $00,$60,$90,$10,$10,$60,$10,$10,$90,$60,$00,

  5, // $34 '4'
  $00,$10,$30,$30,$50,$50,$90,$F0,$10,$10,$00,

  5, // $35 '5'
  $00,$F0,$80,$80,$E0,$90,$10,$10,$90,$60,$00,

  5, // $36 '6'
  $00,$60,$90,$80,$80,$E0,$90,$90,$90,$60,$00,

  5, // $37 '7'
  $00,$F0,$10,$10,$10,$20,$20,$40,$40,$40,$00,

  5, // $38 '8'
  $00,$60,$90,$90,$90,$60,$90,$90,$90,$60,$00,

  5, // $39 '9'
  $00,$60,$90,$90,$90,$70,$10,$10,$90,$60,$00,

  4, // $3A ':'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$00,

  4, // $3B ';'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$C0,

  6, // $3C '<'
  $00,$08,$10,$20,$40,$80,$40,$20,$10,$08,$00,

  5, // $3D '='
  $00,$00,$00,$00,$F0,$00,$00,$F0,$00,$00,$00,

  6, // $3E '>'
  $00,$80,$40,$20,$10,$08,$10,$20,$40,$80,$00,

  5, // $3F '?'
  $00,$60,$90,$10,$10,$20,$40,$00,$40,$00,$00,

  5, // $40 '@'
  $00,$60,$90,$90,$B0,$B0,$B0,$80,$80,$70,$00,

  5, // $41 'A'
  $00,$60,$90,$90,$90,$F0,$90,$90,$90,$90,$00,

  5, // $42 'B'
  $00,$E0,$90,$90,$90,$E0,$90,$90,$90,$E0,$00,

  5, // $43 'C'
  $00,$60,$90,$80,$80,$80,$80,$80,$90,$60,$00,

  5, // $44 'D'
  $00,$E0,$90,$90,$90,$90,$90,$90,$90,$E0,$00,

  5, // $45 'E'
  $00,$F0,$80,$80,$80,$F0,$80,$80,$80,$F0,$00,

  5, // $46 'F'
  $00,$F0,$80,$80,$80,$F0,$80,$80,$80,$80,$00,

  5, // $47 'G'
  $00,$70,$80,$80,$80,$B0,$90,$90,$90,$60,$00,

  5, // $48 'H'
  $00,$90,$90,$90,$90,$F0,$90,$90,$90,$90,$00,

  4, // $49 'I'
  $00,$E0,$40,$40,$40,$40,$40,$40,$40,$E0,$00,

  5, // $4A 'J'
  $00,$70,$20,$20,$20,$20,$20,$A0,$A0,$40,$00,

  5, // $4B 'K'
  $00,$90,$90,$A0,$A0,$C0,$A0,$A0,$90,$90,$00,

  5, // $4C 'L'
  $00,$80,$80,$80,$80,$80,$80,$80,$80,$F0,$00,

  6, // $4D 'M'
  $00,$88,$D8,$A8,$A8,$A8,$88,$88,$88,$88,$00,

  5, // $4E 'N'
  $00,$90,$90,$D0,$D0,$B0,$B0,$90,$90,$90,$00,

  5, // $4F 'O'
  $00,$60,$90,$90,$90,$90,$90,$90,$90,$60,$00,

  5, // $50 'P'
  $00,$E0,$90,$90,$90,$90,$E0,$80,$80,$80,$00,

  5, // $51 'Q'
  $00,$60,$90,$90,$90,$90,$90,$90,$90,$60,$30,

  5, // $52 'R'
  $00,$E0,$90,$90,$90,$90,$E0,$A0,$90,$90,$00,

  5, // $53 'S'
  $00,$60,$90,$80,$80,$60,$10,$10,$90,$60,$00,

  6, // $54 'T'
  $00,$F8,$20,$20,$20,$20,$20,$20,$20,$20,$00,

  5, // $55 'U'
  $00,$90,$90,$90,$90,$90,$90,$90,$90,$60,$00,

  6, // $56 'V'
  $00,$88,$88,$88,$88,$50,$50,$50,$20,$20,$00,

  6, // $57 'W'
  $00,$88,$88,$88,$A8,$A8,$A8,$A8,$A8,$50,$00,

  5, // $58 'X'
  $00,$90,$90,$90,$60,$60,$90,$90,$90,$90,$00,

  6, // $59 'Y'
  $00,$88,$88,$88,$50,$20,$20,$20,$20,$20,$00,

  5, // $5A 'Z'
  $00,$F0,$10,$20,$20,$40,$40,$80,$80,$F0,$00,

  4, // $5B '['
  $60,$40,$40,$40,$40,$40,$40,$40,$40,$60,$00,

  6, // $5C '\'
  $80,$80,$40,$40,$20,$20,$10,$10,$08,$08,$00,

  4, // $5D ']'
  $60,$20,$20,$20,$20,$20,$20,$20,$20,$60,$00,

  5, // $5E '^'
  $00,$20,$50,$88,$00,$00,$00,$00,$00,$00,$00,

  5, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$F0,$00,

  5, // $60 '`'
  $00,$40,$20,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $61 'a'
  $00,$00,$00,$60,$90,$10,$70,$90,$90,$70,$00,

  5, // $62 'b'
  $00,$80,$80,$80,$E0,$90,$90,$90,$90,$E0,$00,

  5, // $63 'c'
  $00,$00,$00,$60,$90,$80,$80,$80,$90,$60,$00,

  5, // $64 'd'
  $00,$10,$10,$10,$70,$90,$90,$90,$90,$70,$00,

  5, // $65 'e'
  $00,$00,$00,$60,$90,$90,$F0,$80,$90,$60,$00,

  4, // $66 'f'
  $00,$20,$40,$40,$E0,$40,$40,$40,$40,$40,$00,

  5, // $67 'g'
  $00,$00,$00,$70,$90,$90,$90,$70,$10,$90,$60,

  5, // $68 'h'
  $00,$80,$80,$80,$E0,$90,$90,$90,$90,$90,$00,

  2, // $69 'i'
  $00,$80,$00,$80,$80,$80,$80,$80,$80,$80,$00,

  4, // $6A 'j'
  $00,$20,$00,$20,$20,$20,$20,$20,$20,$A0,$40,

  5, // $6B 'k'
  $00,$80,$80,$90,$90,$A0,$C0,$A0,$90,$90,$00,

  2, // $6C 'l'
  $00,$80,$80,$80,$80,$80,$80,$80,$80,$80,$00,

  6, // $6D 'm'
  $00,$00,$00,$D0,$A8,$A8,$A8,$88,$88,$88,$00,

  5, // $6E 'n'
  $00,$00,$00,$A0,$D0,$90,$90,$90,$90,$90,$00,

  5, // $6F 'o'
  $00,$00,$00,$60,$90,$90,$90,$90,$90,$60,$00,

  5, // $70 'p'
  $00,$00,$00,$E0,$90,$90,$90,$90,$E0,$80,$80,

  5, // $71 'q'
  $00,$00,$00,$70,$90,$90,$90,$90,$70,$10,$10,

  6, // $72 'r'
  $00,$00,$00,$B8,$48,$40,$40,$40,$40,$40,$00,

  5, // $73 's'
  $00,$00,$00,$60,$90,$40,$20,$10,$90,$60,$00,

  4, // $74 't'
  $00,$40,$40,$E0,$40,$40,$40,$40,$40,$20,$00,

  5, // $75 'u'
  $00,$00,$00,$90,$90,$90,$90,$90,$90,$70,$00,

  6, // $76 'v'
  $00,$00,$00,$88,$88,$88,$50,$50,$20,$20,$00,

  6, // $77 'w'
  $00,$00,$00,$88,$88,$88,$A8,$A8,$A8,$50,$00,

  5, // $78 'x'
  $00,$00,$00,$90,$90,$60,$60,$90,$90,$90,$00,

  5, // $79 'y'
  $00,$00,$00,$90,$90,$90,$90,$70,$10,$20,$C0,

  5, // $7A 'z'
  $00,$00,$00,$F0,$10,$20,$40,$80,$80,$F0,$00,

  5, // $7B '{'
  $30,$40,$40,$40,$40,$80,$40,$40,$40,$40,$30,

  3, // $7C '|'
  $00,$40,$40,$40,$40,$00,$40,$40,$40,$40,$00,

  5, // $7D '}'
  $C0,$20,$20,$20,$20,$10,$20,$20,$20,$20,$C0,

  5, // $7E '~'
  $00,$40,$A8,$10,$00,$00,$00,$00,$00,$00,$00,

  5, // $7F ''
  $00,$20,$70,$D8,$88,$88,$F8,$00,$00,$00,$00,

  0 );

 mcs12_prop : array[0..1492 ] of int8u = (
  12, 3, 32, 128-32,
  $00,$00,$0D,$00,$1A,$00,$27,$00,$34,$00,$41,$00,$4E,$00,$5B,$00,$68,$00,
  $75,$00,$82,$00,$8F,$00,$9C,$00,$A9,$00,$B6,$00,$C3,$00,$D0,$00,$DD,$00,
  $EA,$00,$F7,$00,$04,$01,$11,$01,$1E,$01,$2B,$01,$38,$01,$45,$01,$52,$01,
  $5F,$01,$6C,$01,$79,$01,$86,$01,$93,$01,$A0,$01,$AD,$01,$BA,$01,$C7,$01,
  $D4,$01,$E1,$01,$EE,$01,$FB,$01,$08,$02,$15,$02,$22,$02,$2F,$02,$3C,$02,
  $49,$02,$62,$02,$6F,$02,$7C,$02,$89,$02,$96,$02,$A3,$02,$B0,$02,$BD,$02,
  $CA,$02,$D7,$02,$F0,$02,$FD,$02,$0A,$03,$17,$03,$24,$03,$31,$03,$3E,$03,
  $4B,$03,$58,$03,$65,$03,$72,$03,$7F,$03,$8C,$03,$99,$03,$A6,$03,$B3,$03,
  $C0,$03,$CD,$03,$DA,$03,$E7,$03,$F4,$03,$01,$04,$1A,$04,$27,$04,$34,$04,
  $41,$04,$4E,$04,$5B,$04,$68,$04,$75,$04,$82,$04,$8F,$04,$A8,$04,$B5,$04,
  $C2,$04,$CF,$04,$DC,$04,$E9,$04,$F6,$04,$03,$05,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $00,$20,$20,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  4, // $22 '"'
  $50,$50,$A0,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $23 '#'
  $28,$28,$28,$7C,$28,$28,$28,$7C,$28,$28,$28,$00,

  6, // $24 '$'
  $10,$10,$38,$54,$50,$38,$14,$54,$38,$10,$10,$00,

  7, // $25 '%'
  $32,$54,$64,$08,$08,$10,$10,$26,$2A,$4C,$00,$00,

  7, // $26 '&'
  $00,$30,$48,$48,$48,$30,$4A,$4A,$44,$3A,$00,$00,

  3, // $27 '''
  $40,$40,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $10,$20,$20,$40,$40,$40,$40,$40,$20,$20,$10,$00,

  5, // $29 ')'
  $40,$20,$20,$10,$10,$10,$10,$10,$20,$20,$40,$00,

  6, // $2A '*'
  $00,$00,$10,$54,$38,$7C,$38,$54,$10,$00,$00,$00,

  6, // $2B '+'
  $00,$00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$40,$80,

  6, // $2D '-'
  $00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$00,$00,

  7, // $2F '/'
  $00,$04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$00,

  7, // $30 '0'
  $00,$38,$44,$44,$54,$54,$54,$44,$44,$38,$00,$00,

  4, // $31 '1'
  $00,$20,$60,$20,$20,$20,$20,$20,$20,$20,$00,$00,

  7, // $32 '2'
  $00,$38,$44,$04,$04,$08,$10,$20,$40,$7C,$00,$00,

  7, // $33 '3'
  $00,$38,$44,$04,$04,$38,$04,$04,$44,$38,$00,$00,

  6, // $34 '4'
  $00,$08,$18,$28,$28,$48,$48,$7C,$08,$08,$00,$00,

  7, // $35 '5'
  $00,$7C,$40,$40,$78,$44,$04,$04,$44,$38,$00,$00,

  7, // $36 '6'
  $00,$38,$44,$40,$78,$44,$44,$44,$44,$38,$00,$00,

  6, // $37 '7'
  $00,$7C,$04,$08,$08,$10,$10,$20,$20,$20,$00,$00,

  7, // $38 '8'
  $00,$38,$44,$44,$44,$38,$44,$44,$44,$38,$00,$00,

  7, // $39 '9'
  $00,$38,$44,$44,$44,$3C,$04,$04,$44,$38,$00,$00,

  4, // $3A ':'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$00,$00,

  4, // $3B ';'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$40,$80,

  6, // $3C '<'
  $00,$00,$04,$08,$10,$20,$40,$20,$10,$08,$04,$00,

  6, // $3D '='
  $00,$00,$00,$00,$7C,$00,$00,$7C,$00,$00,$00,$00,

  6, // $3E '>'
  $00,$00,$40,$20,$10,$08,$04,$08,$10,$20,$40,$00,

  6, // $3F '?'
  $00,$38,$44,$04,$04,$08,$10,$10,$00,$10,$00,$00,

  7, // $40 '@'
  $00,$38,$44,$44,$5C,$54,$54,$4C,$40,$38,$00,$00,

  7, // $41 'A'
  $00,$38,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,

  7, // $42 'B'
  $00,$78,$44,$44,$44,$78,$44,$44,$44,$78,$00,$00,

  6, // $43 'C'
  $00,$38,$44,$40,$40,$40,$40,$40,$44,$38,$00,$00,

  7, // $44 'D'
  $00,$70,$48,$44,$44,$44,$44,$44,$48,$70,$00,$00,

  6, // $45 'E'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$7C,$00,$00,

  6, // $46 'F'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$40,$00,$00,

  7, // $47 'G'
  $00,$38,$44,$40,$40,$5C,$44,$44,$4C,$34,$00,$00,

  7, // $48 'H'
  $00,$44,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,

  5, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,

  6, // $4A 'J'
  $00,$1C,$08,$08,$08,$08,$08,$48,$48,$30,$00,$00,

  6, // $4B 'K'
  $00,$44,$48,$50,$60,$60,$50,$48,$44,$44,$00,$00,

  6, // $4C 'L'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$7C,$00,$00,

  9, // $4D 'M'
  $00,$00,$41,$00,$63,$00,$55,$00,$49,$00,$49,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,

  7, // $4E 'N'
  $00,$44,$64,$64,$54,$54,$4C,$4C,$44,$44,$00,$00,

  7, // $4F 'O'
  $00,$38,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $50 'P'
  $00,$78,$44,$44,$44,$44,$78,$40,$40,$40,$00,$00,

  7, // $51 'Q'
  $00,$38,$44,$44,$44,$44,$44,$54,$48,$34,$00,$00,

  7, // $52 'R'
  $00,$78,$44,$44,$44,$44,$78,$48,$44,$44,$00,$00,

  7, // $53 'S'
  $00,$38,$44,$40,$40,$38,$04,$04,$44,$38,$00,$00,

  6, // $54 'T'
  $00,$7C,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,

  7, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  6, // $56 'V'
  $00,$44,$44,$44,$44,$28,$28,$28,$10,$10,$00,$00,

  9, // $57 'W'
  $00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$49,$00,$49,$00,$55,$00,$22,$00,$00,$00,$00,$00,

  7, // $58 'X'
  $00,$44,$44,$44,$28,$10,$28,$44,$44,$44,$00,$00,

  7, // $59 'Y'
  $00,$44,$44,$44,$44,$28,$10,$10,$10,$10,$00,$00,

  6, // $5A 'Z'
  $00,$7C,$04,$04,$08,$10,$20,$40,$40,$7C,$00,$00,

  4, // $5B '['
  $70,$40,$40,$40,$40,$40,$40,$40,$40,$40,$70,$00,

  7, // $5C '\'
  $00,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$00,

  4, // $5D ']'
  $E0,$20,$20,$20,$20,$20,$20,$20,$20,$20,$E0,$00,

  6, // $5E '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,

  4, // $60 '`'
  $00,$40,$40,$20,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$38,$04,$3C,$44,$44,$44,$3C,$00,$00,

  7, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$78,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$40,$44,$38,$00,$00,

  7, // $64 'd'
  $00,$04,$04,$3C,$44,$44,$44,$44,$44,$3C,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$38,$44,$44,$7C,$40,$44,$38,$00,$00,

  4, // $66 'f'
  $00,$30,$40,$E0,$40,$40,$40,$40,$40,$40,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$3C,$44,$44,$44,$44,$44,$3C,$04,$78,

  7, // $68 'h'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$44,$00,$00,

  3, // $69 'i'
  $00,$40,$00,$40,$40,$40,$40,$40,$40,$40,$00,$00,

  5, // $6A 'j'
  $00,$10,$00,$10,$10,$10,$10,$10,$10,$10,$90,$60,

  6, // $6B 'k'
  $00,$40,$40,$44,$48,$50,$60,$50,$48,$44,$00,$00,

  3, // $6C 'l'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,

  9, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$76,$00,$49,$00,$49,$00,$49,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,

  7, // $6E 'n'
  $00,$00,$00,$58,$64,$44,$44,$44,$44,$44,$00,$00,

  7, // $6F 'o'
  $00,$00,$00,$38,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$44,$44,$78,$40,$40,

  7, // $71 'q'
  $00,$00,$00,$3C,$44,$44,$44,$44,$44,$3C,$04,$04,

  6, // $72 'r'
  $00,$00,$00,$58,$24,$20,$20,$20,$20,$70,$00,$00,

  7, // $73 's'
  $00,$00,$00,$38,$44,$40,$38,$04,$44,$38,$00,$00,

  5, // $74 't'
  $00,$20,$20,$70,$20,$20,$20,$20,$20,$18,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$44,$44,$44,$44,$44,$4C,$34,$00,$00,

  6, // $76 'v'
  $00,$00,$00,$44,$44,$44,$28,$28,$10,$10,$00,$00,

  9, // $77 'w'
  $00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$49,$00,$49,$00,$49,$00,$36,$00,$00,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$44,$44,$44,$44,$44,$44,$3C,$08,$70,

  6, // $7A 'z'
  $00,$00,$00,$7C,$04,$08,$10,$20,$40,$7C,$00,$00,

  5, // $7B '{'
  $18,$20,$20,$20,$20,$C0,$20,$20,$20,$20,$18,$00,

  3, // $7C '|'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,

  5, // $7D '}'
  $C0,$20,$20,$20,$20,$18,$20,$20,$20,$20,$C0,$00,

  7, // $7E '~'
  $00,$60,$92,$92,$0C,$00,$00,$00,$00,$00,$00,$00,

  7, // $7F ''
  $00,$10,$38,$6C,$44,$44,$7C,$00,$00,$00,$00,$00,

  0 );

 mcs13_prop : array[0..1592 ] of int8u = (
  13, 4, 32, 128-32,
  $00,$00,$0E,$00,$1C,$00,$2A,$00,$38,$00,$46,$00,$54,$00,$62,$00,$70,$00,
  $7E,$00,$8C,$00,$9A,$00,$A8,$00,$B6,$00,$C4,$00,$D2,$00,$E0,$00,$EE,$00,
  $FC,$00,$0A,$01,$18,$01,$26,$01,$34,$01,$42,$01,$50,$01,$5E,$01,$6C,$01,
  $7A,$01,$88,$01,$96,$01,$A4,$01,$B2,$01,$C0,$01,$CE,$01,$DC,$01,$EA,$01,
  $F8,$01,$06,$02,$14,$02,$22,$02,$30,$02,$3E,$02,$4C,$02,$5A,$02,$68,$02,
  $76,$02,$91,$02,$9F,$02,$AD,$02,$BB,$02,$C9,$02,$D7,$02,$E5,$02,$F3,$02,
  $01,$03,$0F,$03,$2A,$03,$38,$03,$46,$03,$54,$03,$62,$03,$70,$03,$7E,$03,
  $8C,$03,$9A,$03,$A8,$03,$B6,$03,$C4,$03,$D2,$03,$E0,$03,$EE,$03,$FC,$03,
  $0A,$04,$18,$04,$26,$04,$34,$04,$42,$04,$50,$04,$6B,$04,$79,$04,$87,$04,
  $95,$04,$A3,$04,$B1,$04,$BF,$04,$CD,$04,$DB,$04,$E9,$04,$04,$05,$12,$05,
  $20,$05,$2E,$05,$3C,$05,$4A,$05,$58,$05,$66,$05,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $00,$20,$20,$20,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  4, // $22 '"'
  $00,$50,$50,$A0,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $23 '#'
  $00,$28,$28,$28,$7C,$28,$28,$28,$7C,$28,$28,$28,$00,

  6, // $24 '$'
  $00,$10,$10,$38,$54,$50,$38,$14,$54,$38,$10,$10,$00,

  7, // $25 '%'
  $00,$32,$54,$64,$08,$08,$10,$10,$26,$2A,$4C,$00,$00,

  7, // $26 '&'
  $00,$30,$48,$48,$48,$30,$4A,$4A,$44,$3A,$00,$00,$00,

  3, // $27 '''
  $00,$40,$40,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $10,$20,$20,$40,$40,$40,$40,$40,$20,$20,$10,$00,$00,

  5, // $29 ')'
  $40,$20,$20,$10,$10,$10,$10,$10,$20,$20,$40,$00,$00,

  6, // $2A '*'
  $00,$00,$10,$54,$38,$7C,$38,$54,$10,$00,$00,$00,$00,

  6, // $2B '+'
  $00,$00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$20,$40,$80,

  6, // $2D '-'
  $00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$00,$00,$00,

  7, // $2F '/'
  $00,$04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$00,$00,

  7, // $30 '0'
  $00,$38,$44,$44,$54,$54,$54,$44,$44,$38,$00,$00,$00,

  4, // $31 '1'
  $00,$20,$60,$20,$20,$20,$20,$20,$20,$20,$00,$00,$00,

  7, // $32 '2'
  $00,$38,$44,$04,$04,$08,$10,$20,$40,$7C,$00,$00,$00,

  7, // $33 '3'
  $00,$38,$44,$04,$04,$38,$04,$04,$44,$38,$00,$00,$00,

  6, // $34 '4'
  $00,$08,$18,$28,$28,$48,$48,$7C,$08,$08,$00,$00,$00,

  7, // $35 '5'
  $00,$7C,$40,$40,$78,$44,$04,$04,$44,$38,$00,$00,$00,

  7, // $36 '6'
  $00,$38,$44,$40,$78,$44,$44,$44,$44,$38,$00,$00,$00,

  6, // $37 '7'
  $00,$7C,$04,$08,$08,$10,$10,$20,$20,$20,$00,$00,$00,

  7, // $38 '8'
  $00,$38,$44,$44,$44,$38,$44,$44,$44,$38,$00,$00,$00,

  7, // $39 '9'
  $00,$38,$44,$44,$44,$3C,$04,$04,$44,$38,$00,$00,$00,

  4, // $3A ':'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$00,$00,$00,

  4, // $3B ';'
  $00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$20,$40,$80,

  6, // $3C '<'
  $00,$00,$04,$08,$10,$20,$40,$20,$10,$08,$04,$00,$00,

  6, // $3D '='
  $00,$00,$00,$00,$7C,$00,$00,$7C,$00,$00,$00,$00,$00,

  6, // $3E '>'
  $00,$00,$40,$20,$10,$08,$04,$08,$10,$20,$40,$00,$00,

  6, // $3F '?'
  $00,$38,$44,$04,$04,$08,$10,$10,$00,$10,$00,$00,$00,

  7, // $40 '@'
  $00,$38,$44,$44,$5C,$54,$54,$4C,$40,$38,$00,$00,$00,

  7, // $41 'A'
  $00,$38,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,$00,

  7, // $42 'B'
  $00,$78,$44,$44,$44,$78,$44,$44,$44,$78,$00,$00,$00,

  6, // $43 'C'
  $00,$38,$44,$40,$40,$40,$40,$40,$44,$38,$00,$00,$00,

  7, // $44 'D'
  $00,$70,$48,$44,$44,$44,$44,$44,$48,$70,$00,$00,$00,

  6, // $45 'E'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$7C,$00,$00,$00,

  6, // $46 'F'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$40,$00,$00,$00,

  7, // $47 'G'
  $00,$38,$44,$40,$40,$5C,$44,$44,$4C,$34,$00,$00,$00,

  7, // $48 'H'
  $00,$44,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,$00,

  5, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,$00,

  6, // $4A 'J'
  $00,$1C,$08,$08,$08,$08,$08,$48,$48,$30,$00,$00,$00,

  6, // $4B 'K'
  $00,$44,$48,$50,$60,$60,$50,$48,$44,$44,$00,$00,$00,

  6, // $4C 'L'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$7C,$00,$00,$00,

  9, // $4D 'M'
  $00,$00,$41,$00,$63,$00,$55,$00,$49,$00,$49,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  7, // $4E 'N'
  $00,$44,$64,$64,$54,$54,$4C,$4C,$44,$44,$00,$00,$00,

  7, // $4F 'O'
  $00,$38,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $50 'P'
  $00,$78,$44,$44,$44,$44,$78,$40,$40,$40,$00,$00,$00,

  7, // $51 'Q'
  $00,$38,$44,$44,$44,$44,$44,$54,$48,$34,$00,$00,$00,

  7, // $52 'R'
  $00,$78,$44,$44,$44,$44,$78,$48,$44,$44,$00,$00,$00,

  7, // $53 'S'
  $00,$38,$44,$40,$40,$38,$04,$04,$44,$38,$00,$00,$00,

  6, // $54 'T'
  $00,$7C,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,

  7, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  6, // $56 'V'
  $00,$44,$44,$44,$44,$28,$28,$28,$10,$10,$00,$00,$00,

  9, // $57 'W'
  $00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$49,$00,$49,$00,$55,$00,$22,$00,$00,$00,$00,$00,$00,$00,

  7, // $58 'X'
  $00,$44,$44,$44,$28,$10,$28,$44,$44,$44,$00,$00,$00,

  7, // $59 'Y'
  $00,$44,$44,$44,$44,$28,$10,$10,$10,$10,$00,$00,$00,

  6, // $5A 'Z'
  $00,$7C,$04,$04,$08,$10,$20,$40,$40,$7C,$00,$00,$00,

  4, // $5B '['
  $70,$40,$40,$40,$40,$40,$40,$40,$40,$40,$70,$00,$00,

  7, // $5C '\'
  $00,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$00,$00,

  4, // $5D ']'
  $E0,$20,$20,$20,$20,$20,$20,$20,$20,$20,$E0,$00,$00,

  6, // $5E '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,

  4, // $60 '`'
  $00,$40,$40,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$38,$04,$3C,$44,$44,$44,$3C,$00,$00,$00,

  7, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$78,$00,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$40,$44,$38,$00,$00,$00,

  7, // $64 'd'
  $00,$04,$04,$3C,$44,$44,$44,$44,$44,$3C,$00,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$38,$44,$44,$7C,$40,$44,$38,$00,$00,$00,

  4, // $66 'f'
  $00,$30,$40,$E0,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$3C,$44,$44,$44,$44,$44,$3C,$04,$44,$38,

  7, // $68 'h'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$44,$00,$00,$00,

  3, // $69 'i'
  $00,$40,$00,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  5, // $6A 'j'
  $00,$10,$00,$10,$10,$10,$10,$10,$10,$10,$90,$60,$00,

  6, // $6B 'k'
  $00,$40,$40,$44,$48,$50,$60,$50,$48,$44,$00,$00,$00,

  3, // $6C 'l'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  9, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$76,$00,$49,$00,$49,$00,$49,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  7, // $6E 'n'
  $00,$00,$00,$58,$64,$44,$44,$44,$44,$44,$00,$00,$00,

  7, // $6F 'o'
  $00,$00,$00,$38,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$44,$44,$78,$40,$40,$40,

  7, // $71 'q'
  $00,$00,$00,$3C,$44,$44,$44,$44,$44,$3C,$04,$04,$04,

  6, // $72 'r'
  $00,$00,$00,$58,$24,$20,$20,$20,$20,$70,$00,$00,$00,

  7, // $73 's'
  $00,$00,$00,$38,$44,$40,$38,$04,$44,$38,$00,$00,$00,

  5, // $74 't'
  $00,$20,$20,$70,$20,$20,$20,$20,$20,$18,$00,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$44,$44,$44,$44,$44,$4C,$34,$00,$00,$00,

  6, // $76 'v'
  $00,$00,$00,$44,$44,$44,$28,$28,$10,$10,$00,$00,$00,

  9, // $77 'w'
  $00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$49,$00,$49,$00,$49,$00,$36,$00,$00,$00,$00,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$00,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$44,$44,$44,$44,$44,$44,$3C,$04,$08,$70,

  6, // $7A 'z'
  $00,$00,$00,$7C,$04,$08,$10,$20,$40,$7C,$00,$00,$00,

  5, // $7B '{'
  $18,$20,$20,$20,$20,$C0,$20,$20,$20,$20,$18,$00,$00,

  3, // $7C '|'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,

  5, // $7D '}'
  $C0,$20,$20,$20,$20,$18,$20,$20,$20,$20,$C0,$00,$00,

  7, // $7E '~'
  $00,$60,$92,$92,$0C,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $7F ''
  $00,$10,$38,$6C,$44,$44,$7C,$00,$00,$00,$00,$00,$00,

  0 );

 mcs5x10_mono : array[0..1252 ] of int8u = (
  10, 2, 32, 128-32,
  $00,$00,$0B,$00,$16,$00,$21,$00,$2C,$00,$37,$00,$42,$00,$4D,$00,$58,$00,
  $63,$00,$6E,$00,$79,$00,$84,$00,$8F,$00,$9A,$00,$A5,$00,$B0,$00,$BB,$00,
  $C6,$00,$D1,$00,$DC,$00,$E7,$00,$F2,$00,$FD,$00,$08,$01,$13,$01,$1E,$01,
  $29,$01,$34,$01,$3F,$01,$4A,$01,$55,$01,$60,$01,$6B,$01,$76,$01,$81,$01,
  $8C,$01,$97,$01,$A2,$01,$AD,$01,$B8,$01,$C3,$01,$CE,$01,$D9,$01,$E4,$01,
  $EF,$01,$FA,$01,$05,$02,$10,$02,$1B,$02,$26,$02,$31,$02,$3C,$02,$47,$02,
  $52,$02,$5D,$02,$68,$02,$73,$02,$7E,$02,$89,$02,$94,$02,$9F,$02,$AA,$02,
  $B5,$02,$C0,$02,$CB,$02,$D6,$02,$E1,$02,$EC,$02,$F7,$02,$02,$03,$0D,$03,
  $18,$03,$23,$03,$2E,$03,$39,$03,$44,$03,$4F,$03,$5A,$03,$65,$03,$70,$03,
  $7B,$03,$86,$03,$91,$03,$9C,$03,$A7,$03,$B2,$03,$BD,$03,$C8,$03,$D3,$03,
  $DE,$03,$E9,$03,$F4,$03,$FF,$03,$0A,$04,$15,$04,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$20,$20,$20,$20,$20,$20,$00,$20,$00,

  5, // $22 '"'
  $00,$50,$50,$A0,$00,$00,$00,$00,$00,$00,

  5, // $23 '#'
  $00,$50,$50,$F8,$50,$50,$50,$F8,$50,$50,

  5, // $24 '$'
  $00,$40,$60,$90,$80,$60,$10,$90,$60,$20,

  5, // $25 '%'
  $00,$00,$90,$90,$20,$20,$40,$40,$90,$90,

  5, // $26 '&'
  $00,$40,$A0,$A0,$A0,$40,$A8,$90,$90,$68,

  5, // $27 '''
  $00,$20,$20,$40,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $10,$20,$20,$40,$40,$40,$40,$20,$20,$10,

  5, // $29 ')'
  $40,$20,$20,$10,$10,$10,$10,$20,$20,$40,

  5, // $2A '*'
  $00,$00,$90,$60,$F0,$60,$90,$00,$00,$00,

  5, // $2B '+'
  $00,$00,$00,$20,$20,$F8,$20,$20,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$60,$60,$C0,

  5, // $2D '-'
  $00,$00,$00,$00,$00,$F0,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$60,$60,$00,

  5, // $2F '/'
  $00,$08,$10,$10,$20,$20,$40,$40,$80,$00,

  5, // $30 '0'
  $00,$70,$90,$90,$90,$90,$90,$90,$E0,$00,

  5, // $31 '1'
  $00,$20,$60,$20,$20,$20,$20,$20,$70,$00,

  5, // $32 '2'
  $00,$60,$90,$90,$10,$20,$40,$80,$F0,$00,

  5, // $33 '3'
  $00,$60,$90,$10,$60,$10,$10,$90,$60,$00,

  5, // $34 '4'
  $00,$10,$30,$50,$50,$90,$F0,$10,$10,$00,

  5, // $35 '5'
  $00,$F0,$80,$80,$E0,$10,$10,$90,$60,$00,

  5, // $36 '6'
  $00,$60,$80,$80,$E0,$90,$90,$90,$60,$00,

  5, // $37 '7'
  $00,$F0,$10,$10,$20,$20,$40,$40,$40,$00,

  5, // $38 '8'
  $00,$60,$90,$90,$60,$90,$90,$90,$60,$00,

  5, // $39 '9'
  $00,$60,$90,$90,$90,$70,$10,$10,$60,$00,

  5, // $3A ':'
  $00,$00,$00,$60,$60,$00,$00,$60,$60,$00,

  5, // $3B ';'
  $00,$00,$00,$60,$60,$00,$00,$60,$60,$C0,

  5, // $3C '<'
  $00,$08,$10,$20,$40,$80,$40,$20,$10,$08,

  5, // $3D '='
  $00,$00,$00,$00,$F0,$00,$F0,$00,$00,$00,

  5, // $3E '>'
  $00,$80,$40,$20,$10,$08,$10,$20,$40,$80,

  5, // $3F '?'
  $00,$60,$90,$10,$10,$20,$40,$00,$40,$00,

  5, // $40 '@'
  $00,$60,$90,$90,$B0,$B0,$80,$80,$70,$00,

  5, // $41 'A'
  $00,$60,$90,$90,$90,$F0,$90,$90,$90,$00,

  5, // $42 'B'
  $00,$E0,$90,$90,$E0,$90,$90,$90,$E0,$00,

  5, // $43 'C'
  $00,$60,$90,$80,$80,$80,$80,$90,$60,$00,

  5, // $44 'D'
  $00,$E0,$90,$90,$90,$90,$90,$90,$E0,$00,

  5, // $45 'E'
  $00,$F0,$80,$80,$F0,$80,$80,$80,$F0,$00,

  5, // $46 'F'
  $00,$F0,$80,$80,$F0,$80,$80,$80,$80,$00,

  5, // $47 'G'
  $00,$60,$90,$80,$80,$B0,$90,$90,$60,$00,

  5, // $48 'H'
  $00,$90,$90,$90,$90,$F0,$90,$90,$90,$00,

  5, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$20,$70,$00,

  5, // $4A 'J'
  $00,$70,$20,$20,$20,$20,$20,$A0,$40,$00,

  5, // $4B 'K'
  $00,$90,$A0,$A0,$C0,$C0,$A0,$A0,$90,$00,

  5, // $4C 'L'
  $00,$80,$80,$80,$80,$80,$80,$80,$F0,$00,

  5, // $4D 'M'
  $00,$90,$90,$F0,$F0,$90,$90,$90,$90,$00,

  5, // $4E 'N'
  $00,$90,$90,$D0,$D0,$B0,$B0,$90,$90,$00,

  5, // $4F 'O'
  $00,$60,$90,$90,$90,$90,$90,$90,$60,$00,

  5, // $50 'P'
  $00,$E0,$90,$90,$90,$E0,$80,$80,$80,$00,

  5, // $51 'Q'
  $00,$60,$90,$90,$90,$90,$90,$90,$60,$30,

  5, // $52 'R'
  $00,$E0,$90,$90,$90,$E0,$A0,$90,$90,$00,

  5, // $53 'S'
  $00,$60,$90,$80,$60,$10,$90,$90,$60,$00,

  5, // $54 'T'
  $00,$F8,$20,$20,$20,$20,$20,$20,$20,$00,

  5, // $55 'U'
  $00,$90,$90,$90,$90,$90,$90,$90,$60,$00,

  5, // $56 'V'
  $00,$90,$90,$90,$50,$50,$50,$20,$20,$00,

  5, // $57 'W'
  $00,$90,$90,$90,$90,$90,$F0,$F0,$90,$00,

  5, // $58 'X'
  $00,$90,$90,$90,$60,$60,$90,$90,$90,$00,

  5, // $59 'Y'
  $00,$88,$88,$88,$50,$20,$20,$20,$20,$00,

  5, // $5A 'Z'
  $00,$F0,$10,$20,$20,$40,$40,$80,$F0,$00,

  5, // $5B '['
  $60,$40,$40,$40,$40,$40,$40,$40,$40,$60,

  5, // $5C '\'
  $80,$80,$40,$40,$20,$20,$10,$10,$08,$08,

  5, // $5D ']'
  $60,$20,$20,$20,$20,$20,$20,$20,$20,$60,

  5, // $5E '^'
  $00,$20,$50,$00,$00,$00,$00,$00,$00,$00,

  5, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$F0,$00,

  5, // $60 '`'
  $00,$40,$20,$00,$00,$00,$00,$00,$00,$00,

  5, // $61 'a'
  $00,$00,$00,$60,$10,$70,$90,$90,$70,$00,

  5, // $62 'b'
  $00,$80,$80,$E0,$90,$90,$90,$90,$E0,$00,

  5, // $63 'c'
  $00,$00,$00,$60,$90,$80,$80,$90,$60,$00,

  5, // $64 'd'
  $00,$10,$10,$70,$90,$90,$90,$90,$70,$00,

  5, // $65 'e'
  $00,$00,$00,$60,$90,$90,$F0,$80,$70,$00,

  5, // $66 'f'
  $00,$30,$40,$E0,$40,$40,$40,$40,$40,$00,

  5, // $67 'g'
  $00,$00,$00,$70,$90,$90,$90,$70,$10,$E0,

  5, // $68 'h'
  $00,$80,$80,$E0,$90,$90,$90,$90,$90,$00,

  5, // $69 'i'
  $00,$20,$00,$60,$20,$20,$20,$20,$70,$00,

  5, // $6A 'j'
  $00,$20,$00,$60,$20,$20,$20,$20,$20,$C0,

  5, // $6B 'k'
  $00,$80,$80,$90,$A0,$C0,$A0,$90,$90,$00,

  5, // $6C 'l'
  $00,$60,$20,$20,$20,$20,$20,$20,$70,$00,

  5, // $6D 'm'
  $00,$00,$00,$90,$F0,$90,$90,$90,$90,$00,

  5, // $6E 'n'
  $00,$00,$00,$E0,$90,$90,$90,$90,$90,$00,

  5, // $6F 'o'
  $00,$00,$00,$60,$90,$90,$90,$90,$60,$00,

  5, // $70 'p'
  $00,$00,$00,$E0,$90,$90,$90,$E0,$80,$80,

  5, // $71 'q'
  $00,$00,$00,$70,$90,$90,$90,$70,$10,$10,

  5, // $72 'r'
  $00,$00,$00,$B0,$50,$40,$40,$40,$E0,$00,

  5, // $73 's'
  $00,$00,$00,$60,$90,$40,$20,$90,$60,$00,

  5, // $74 't'
  $00,$40,$40,$E0,$40,$40,$40,$50,$20,$00,

  5, // $75 'u'
  $00,$00,$00,$90,$90,$90,$90,$90,$70,$00,

  5, // $76 'v'
  $00,$00,$00,$90,$90,$50,$50,$20,$20,$00,

  5, // $77 'w'
  $00,$00,$00,$90,$90,$90,$90,$F0,$90,$00,

  5, // $78 'x'
  $00,$00,$00,$90,$90,$60,$60,$90,$90,$00,

  5, // $79 'y'
  $00,$00,$00,$90,$90,$90,$90,$70,$10,$E0,

  5, // $7A 'z'
  $00,$00,$00,$F0,$10,$20,$40,$80,$F0,$00,

  5, // $7B '{'
  $30,$40,$40,$40,$80,$40,$40,$40,$40,$30,

  5, // $7C '|'
  $00,$20,$20,$20,$20,$20,$20,$20,$20,$20,

  5, // $7D '}'
  $C0,$20,$20,$20,$10,$20,$20,$20,$20,$C0,

  5, // $7E '~'
  $00,$40,$A8,$10,$00,$00,$00,$00,$00,$00,

  5, // $7F ''
  $00,$20,$70,$D8,$88,$88,$F8,$00,$00,$00,

  0 );

 mcs5x11_mono : array[0..1348 ] of int8u = (
  11, 3, 32, 128-32,
  $00,$00,$0C,$00,$18,$00,$24,$00,$30,$00,$3C,$00,$48,$00,$54,$00,$60,$00,
  $6C,$00,$78,$00,$84,$00,$90,$00,$9C,$00,$A8,$00,$B4,$00,$C0,$00,$CC,$00,
  $D8,$00,$E4,$00,$F0,$00,$FC,$00,$08,$01,$14,$01,$20,$01,$2C,$01,$38,$01,
  $44,$01,$50,$01,$5C,$01,$68,$01,$74,$01,$80,$01,$8C,$01,$98,$01,$A4,$01,
  $B0,$01,$BC,$01,$C8,$01,$D4,$01,$E0,$01,$EC,$01,$F8,$01,$04,$02,$10,$02,
  $1C,$02,$28,$02,$34,$02,$40,$02,$4C,$02,$58,$02,$64,$02,$70,$02,$7C,$02,
  $88,$02,$94,$02,$A0,$02,$AC,$02,$B8,$02,$C4,$02,$D0,$02,$DC,$02,$E8,$02,
  $F4,$02,$00,$03,$0C,$03,$18,$03,$24,$03,$30,$03,$3C,$03,$48,$03,$54,$03,
  $60,$03,$6C,$03,$78,$03,$84,$03,$90,$03,$9C,$03,$A8,$03,$B4,$03,$C0,$03,
  $CC,$03,$D8,$03,$E4,$03,$F0,$03,$FC,$03,$08,$04,$14,$04,$20,$04,$2C,$04,
  $38,$04,$44,$04,$50,$04,$5C,$04,$68,$04,$74,$04,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$20,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  5, // $22 '"'
  $00,$50,$50,$A0,$00,$00,$00,$00,$00,$00,$00,

  5, // $23 '#'
  $00,$50,$50,$F8,$50,$50,$50,$F8,$50,$50,$00,

  5, // $24 '$'
  $00,$40,$60,$90,$80,$60,$10,$90,$60,$20,$00,

  5, // $25 '%'
  $00,$00,$90,$90,$20,$20,$40,$40,$90,$90,$00,

  5, // $26 '&'
  $00,$40,$A0,$A0,$40,$A8,$90,$90,$68,$00,$00,

  5, // $27 '''
  $00,$20,$20,$40,$00,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $00,$10,$20,$20,$40,$40,$40,$40,$20,$20,$10,

  5, // $29 ')'
  $00,$40,$20,$20,$10,$10,$10,$10,$20,$20,$40,

  5, // $2A '*'
  $00,$00,$90,$60,$F0,$60,$90,$00,$00,$00,$00,

  5, // $2B '+'
  $00,$00,$00,$20,$20,$F8,$20,$20,$00,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$60,$60,$40,$80,

  5, // $2D '-'
  $00,$00,$00,$00,$00,$F0,$00,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$60,$60,$00,$00,

  5, // $2F '/'
  $08,$08,$10,$10,$20,$20,$40,$40,$80,$80,$00,

  5, // $30 '0'
  $00,$70,$90,$90,$90,$90,$90,$90,$E0,$00,$00,

  5, // $31 '1'
  $00,$20,$60,$20,$20,$20,$20,$20,$70,$00,$00,

  5, // $32 '2'
  $00,$60,$90,$90,$10,$20,$40,$80,$F0,$00,$00,

  5, // $33 '3'
  $00,$60,$90,$10,$60,$10,$10,$90,$60,$00,$00,

  5, // $34 '4'
  $00,$10,$30,$50,$50,$90,$F8,$10,$10,$00,$00,

  5, // $35 '5'
  $00,$F0,$80,$E0,$90,$10,$10,$90,$60,$00,$00,

  5, // $36 '6'
  $00,$60,$90,$80,$E0,$90,$90,$90,$60,$00,$00,

  5, // $37 '7'
  $00,$F0,$10,$10,$20,$20,$40,$40,$40,$00,$00,

  5, // $38 '8'
  $00,$60,$90,$90,$60,$90,$90,$90,$60,$00,$00,

  5, // $39 '9'
  $00,$60,$90,$90,$90,$70,$10,$90,$60,$00,$00,

  5, // $3A ':'
  $00,$00,$00,$60,$60,$00,$00,$60,$60,$00,$00,

  5, // $3B ';'
  $00,$00,$00,$60,$60,$00,$00,$60,$60,$40,$80,

  5, // $3C '<'
  $00,$08,$10,$20,$40,$80,$40,$20,$10,$08,$00,

  5, // $3D '='
  $00,$00,$00,$00,$F0,$00,$00,$F0,$00,$00,$00,

  5, // $3E '>'
  $00,$80,$40,$20,$10,$08,$10,$20,$40,$80,$00,

  5, // $3F '?'
  $00,$60,$90,$10,$10,$20,$40,$00,$40,$00,$00,

  5, // $40 '@'
  $00,$60,$90,$90,$B0,$B0,$80,$80,$70,$00,$00,

  5, // $41 'A'
  $00,$60,$90,$90,$90,$F0,$90,$90,$90,$00,$00,

  5, // $42 'B'
  $00,$E0,$90,$90,$E0,$90,$90,$90,$E0,$00,$00,

  5, // $43 'C'
  $00,$60,$90,$80,$80,$80,$80,$90,$60,$00,$00,

  5, // $44 'D'
  $00,$E0,$90,$90,$90,$90,$90,$90,$E0,$00,$00,

  5, // $45 'E'
  $00,$F0,$80,$80,$E0,$80,$80,$80,$F0,$00,$00,

  5, // $46 'F'
  $00,$F0,$80,$80,$E0,$80,$80,$80,$80,$00,$00,

  5, // $47 'G'
  $00,$60,$90,$80,$80,$B0,$90,$90,$60,$00,$00,

  5, // $48 'H'
  $00,$90,$90,$90,$F0,$90,$90,$90,$90,$00,$00,

  5, // $49 'I'
  $00,$70,$20,$20,$20,$20,$20,$20,$70,$00,$00,

  5, // $4A 'J'
  $00,$70,$20,$20,$20,$20,$A0,$A0,$40,$00,$00,

  5, // $4B 'K'
  $00,$90,$A0,$A0,$C0,$A0,$A0,$90,$90,$00,$00,

  5, // $4C 'L'
  $00,$80,$80,$80,$80,$80,$80,$80,$F0,$00,$00,

  5, // $4D 'M'
  $00,$90,$F0,$F0,$90,$90,$90,$90,$90,$00,$00,

  5, // $4E 'N'
  $00,$90,$90,$D0,$D0,$B0,$B0,$90,$90,$00,$00,

  5, // $4F 'O'
  $00,$60,$90,$90,$90,$90,$90,$90,$60,$00,$00,

  5, // $50 'P'
  $00,$E0,$90,$90,$90,$E0,$80,$80,$80,$00,$00,

  5, // $51 'Q'
  $00,$60,$90,$90,$90,$90,$90,$90,$60,$30,$00,

  5, // $52 'R'
  $00,$E0,$90,$90,$90,$E0,$A0,$90,$90,$00,$00,

  5, // $53 'S'
  $00,$60,$90,$80,$60,$10,$90,$90,$60,$00,$00,

  5, // $54 'T'
  $00,$F8,$20,$20,$20,$20,$20,$20,$20,$00,$00,

  5, // $55 'U'
  $00,$90,$90,$90,$90,$90,$90,$90,$60,$00,$00,

  5, // $56 'V'
  $00,$90,$90,$90,$50,$50,$50,$20,$20,$00,$00,

  5, // $57 'W'
  $00,$90,$90,$90,$90,$90,$F0,$F0,$90,$00,$00,

  5, // $58 'X'
  $00,$90,$90,$90,$60,$60,$90,$90,$90,$00,$00,

  5, // $59 'Y'
  $00,$88,$88,$88,$50,$20,$20,$20,$20,$00,$00,

  5, // $5A 'Z'
  $00,$F0,$10,$20,$20,$40,$40,$80,$F0,$00,$00,

  5, // $5B '['
  $00,$60,$40,$40,$40,$40,$40,$40,$40,$40,$60,

  5, // $5C '\'
  $80,$80,$40,$40,$20,$20,$10,$10,$08,$08,$00,

  5, // $5D ']'
  $00,$60,$20,$20,$20,$20,$20,$20,$20,$20,$60,

  5, // $5E '^'
  $00,$20,$50,$88,$00,$00,$00,$00,$00,$00,$00,

  5, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$F0,$00,$00,

  5, // $60 '`'
  $00,$40,$40,$20,$00,$00,$00,$00,$00,$00,$00,

  5, // $61 'a'
  $00,$00,$00,$60,$10,$70,$90,$90,$70,$00,$00,

  5, // $62 'b'
  $00,$80,$80,$E0,$90,$90,$90,$90,$E0,$00,$00,

  5, // $63 'c'
  $00,$00,$00,$60,$90,$80,$80,$90,$60,$00,$00,

  5, // $64 'd'
  $00,$10,$10,$70,$90,$90,$90,$90,$70,$00,$00,

  5, // $65 'e'
  $00,$00,$00,$60,$90,$90,$F0,$80,$70,$00,$00,

  5, // $66 'f'
  $00,$30,$40,$E0,$40,$40,$40,$40,$40,$00,$00,

  5, // $67 'g'
  $00,$00,$00,$70,$90,$90,$90,$90,$70,$10,$E0,

  5, // $68 'h'
  $00,$80,$80,$E0,$90,$90,$90,$90,$90,$00,$00,

  5, // $69 'i'
  $00,$20,$00,$60,$20,$20,$20,$20,$70,$00,$00,

  5, // $6A 'j'
  $00,$20,$00,$60,$20,$20,$20,$20,$20,$A0,$40,

  5, // $6B 'k'
  $00,$80,$80,$90,$A0,$C0,$A0,$90,$90,$00,$00,

  5, // $6C 'l'
  $00,$60,$20,$20,$20,$20,$20,$20,$70,$00,$00,

  5, // $6D 'm'
  $00,$00,$00,$90,$F0,$90,$90,$90,$90,$00,$00,

  5, // $6E 'n'
  $00,$00,$00,$E0,$90,$90,$90,$90,$90,$00,$00,

  5, // $6F 'o'
  $00,$00,$00,$60,$90,$90,$90,$90,$60,$00,$00,

  5, // $70 'p'
  $00,$00,$00,$E0,$90,$90,$90,$90,$E0,$80,$80,

  5, // $71 'q'
  $00,$00,$00,$70,$90,$90,$90,$90,$70,$10,$10,

  5, // $72 'r'
  $00,$00,$00,$A0,$50,$40,$40,$40,$E0,$00,$00,

  5, // $73 's'
  $00,$00,$00,$60,$90,$40,$20,$90,$60,$00,$00,

  5, // $74 't'
  $00,$40,$40,$E0,$40,$40,$40,$40,$30,$00,$00,

  5, // $75 'u'
  $00,$00,$00,$90,$90,$90,$90,$90,$70,$00,$00,

  5, // $76 'v'
  $00,$00,$00,$90,$90,$50,$50,$20,$20,$00,$00,

  5, // $77 'w'
  $00,$00,$00,$90,$90,$90,$90,$F0,$90,$00,$00,

  5, // $78 'x'
  $00,$00,$00,$90,$90,$60,$60,$90,$90,$00,$00,

  5, // $79 'y'
  $00,$00,$00,$90,$90,$90,$90,$90,$70,$10,$E0,

  5, // $7A 'z'
  $00,$00,$00,$F0,$10,$20,$40,$80,$F0,$00,$00,

  5, // $7B '{'
  $30,$40,$40,$40,$40,$80,$40,$40,$40,$40,$30,

  5, // $7C '|'
  $00,$20,$20,$20,$20,$00,$20,$20,$20,$20,$00,

  5, // $7D '}'
  $C0,$20,$20,$20,$20,$10,$20,$20,$20,$20,$C0,

  5, // $7E '~'
  $00,$40,$A8,$10,$00,$00,$00,$00,$00,$00,$00,

  5, // $7F ''
  $00,$20,$70,$D8,$88,$88,$F8,$00,$00,$00,$00,

  0 );

 mcs6x10_mono : array[0..1252 ] of int8u = (
  10, 3, 32, 128-32,
  $00,$00,$0B,$00,$16,$00,$21,$00,$2C,$00,$37,$00,$42,$00,$4D,$00,$58,$00,
  $63,$00,$6E,$00,$79,$00,$84,$00,$8F,$00,$9A,$00,$A5,$00,$B0,$00,$BB,$00,
  $C6,$00,$D1,$00,$DC,$00,$E7,$00,$F2,$00,$FD,$00,$08,$01,$13,$01,$1E,$01,
  $29,$01,$34,$01,$3F,$01,$4A,$01,$55,$01,$60,$01,$6B,$01,$76,$01,$81,$01,
  $8C,$01,$97,$01,$A2,$01,$AD,$01,$B8,$01,$C3,$01,$CE,$01,$D9,$01,$E4,$01,
  $EF,$01,$FA,$01,$05,$02,$10,$02,$1B,$02,$26,$02,$31,$02,$3C,$02,$47,$02,
  $52,$02,$5D,$02,$68,$02,$73,$02,$7E,$02,$89,$02,$94,$02,$9F,$02,$AA,$02,
  $B5,$02,$C0,$02,$CB,$02,$D6,$02,$E1,$02,$EC,$02,$F7,$02,$02,$03,$0D,$03,
  $18,$03,$23,$03,$2E,$03,$39,$03,$44,$03,$4F,$03,$5A,$03,$65,$03,$70,$03,
  $7B,$03,$86,$03,$91,$03,$9C,$03,$A7,$03,$B2,$03,$BD,$03,$C8,$03,$D3,$03,
  $DE,$03,$E9,$03,$F4,$03,$FF,$03,$0A,$04,$15,$04,

  6, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$10,$10,$10,$10,$10,$00,$10,$00,$00,

  6, // $22 '"'
  $00,$28,$28,$50,$00,$00,$00,$00,$00,$00,

  6, // $23 '#'
  $00,$28,$28,$7C,$28,$28,$7C,$28,$28,$00,

  6, // $24 '$'
  $10,$38,$54,$50,$38,$14,$54,$38,$10,$00,

  6, // $25 '%'
  $00,$08,$C8,$D0,$10,$20,$2C,$4C,$40,$00,

  6, // $26 '&'
  $00,$20,$50,$50,$24,$54,$48,$34,$00,$00,

  6, // $27 '''
  $00,$10,$10,$20,$00,$00,$00,$00,$00,$00,

  6, // $28 '('
  $08,$10,$10,$20,$20,$20,$10,$10,$08,$00,

  6, // $29 ')'
  $20,$10,$10,$08,$08,$08,$10,$10,$20,$00,

  6, // $2A '*'
  $00,$00,$28,$7C,$38,$7C,$28,$00,$00,$00,

  6, // $2B '+'
  $00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,

  6, // $2C ','
  $00,$00,$00,$00,$00,$00,$30,$30,$20,$40,

  6, // $2D '-'
  $00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,

  6, // $2E '.'
  $00,$00,$00,$00,$00,$00,$30,$30,$00,$00,

  6, // $2F '/'
  $00,$08,$08,$10,$10,$20,$20,$40,$40,$00,

  6, // $30 '0'
  $00,$38,$44,$4C,$54,$64,$44,$38,$00,$00,

  6, // $31 '1'
  $00,$10,$30,$10,$10,$10,$10,$38,$00,$00,

  6, // $32 '2'
  $00,$38,$44,$04,$18,$20,$40,$7C,$00,$00,

  6, // $33 '3'
  $00,$38,$44,$04,$38,$04,$44,$38,$00,$00,

  6, // $34 '4'
  $00,$08,$18,$28,$48,$7C,$08,$08,$00,$00,

  6, // $35 '5'
  $00,$7C,$40,$40,$78,$04,$44,$38,$00,$00,

  6, // $36 '6'
  $00,$38,$40,$40,$78,$44,$44,$38,$00,$00,

  6, // $37 '7'
  $00,$7C,$04,$08,$10,$20,$20,$20,$00,$00,

  6, // $38 '8'
  $00,$38,$44,$44,$38,$44,$44,$38,$00,$00,

  6, // $39 '9'
  $00,$38,$44,$44,$3C,$04,$04,$38,$00,$00,

  6, // $3A ':'
  $00,$00,$30,$30,$00,$00,$30,$30,$00,$00,

  6, // $3B ';'
  $00,$00,$30,$30,$00,$00,$30,$30,$20,$40,

  6, // $3C '<'
  $04,$08,$10,$20,$40,$20,$10,$08,$04,$00,

  6, // $3D '='
  $00,$00,$00,$7C,$00,$00,$7C,$00,$00,$00,

  6, // $3E '>'
  $40,$20,$10,$08,$04,$08,$10,$20,$40,$00,

  6, // $3F '?'
  $00,$38,$44,$04,$18,$10,$00,$10,$00,$00,

  6, // $40 '@'
  $00,$38,$44,$5C,$54,$5C,$40,$38,$00,$00,

  6, // $41 'A'
  $00,$38,$44,$44,$44,$7C,$44,$44,$00,$00,

  6, // $42 'B'
  $00,$78,$44,$44,$78,$44,$44,$78,$00,$00,

  6, // $43 'C'
  $00,$38,$44,$40,$40,$40,$44,$38,$00,$00,

  6, // $44 'D'
  $00,$78,$44,$44,$44,$44,$44,$78,$00,$00,

  6, // $45 'E'
  $00,$7C,$40,$40,$78,$40,$40,$7C,$00,$00,

  6, // $46 'F'
  $00,$7C,$40,$40,$78,$40,$40,$40,$00,$00,

  6, // $47 'G'
  $00,$38,$44,$40,$4C,$44,$44,$3C,$00,$00,

  6, // $48 'H'
  $00,$44,$44,$44,$7C,$44,$44,$44,$00,$00,

  6, // $49 'I'
  $00,$38,$10,$10,$10,$10,$10,$38,$00,$00,

  6, // $4A 'J'
  $00,$1C,$08,$08,$08,$48,$48,$30,$00,$00,

  6, // $4B 'K'
  $00,$44,$48,$50,$60,$50,$48,$44,$00,$00,

  6, // $4C 'L'
  $00,$40,$40,$40,$40,$40,$40,$7C,$00,$00,

  6, // $4D 'M'
  $00,$44,$6C,$54,$54,$44,$44,$44,$00,$00,

  6, // $4E 'N'
  $00,$44,$44,$64,$54,$4C,$44,$44,$00,$00,

  6, // $4F 'O'
  $00,$38,$44,$44,$44,$44,$44,$38,$00,$00,

  6, // $50 'P'
  $00,$78,$44,$44,$78,$40,$40,$40,$00,$00,

  6, // $51 'Q'
  $00,$38,$44,$44,$44,$54,$48,$34,$00,$00,

  6, // $52 'R'
  $00,$78,$44,$44,$78,$48,$44,$44,$00,$00,

  6, // $53 'S'
  $00,$38,$44,$40,$38,$04,$44,$38,$00,$00,

  6, // $54 'T'
  $00,$7C,$10,$10,$10,$10,$10,$10,$00,$00,

  6, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  6, // $56 'V'
  $00,$44,$44,$44,$44,$28,$28,$10,$00,$00,

  6, // $57 'W'
  $00,$44,$44,$54,$54,$54,$54,$28,$00,$00,

  6, // $58 'X'
  $00,$44,$44,$28,$10,$28,$44,$44,$00,$00,

  6, // $59 'Y'
  $00,$44,$44,$44,$28,$10,$10,$10,$00,$00,

  6, // $5A 'Z'
  $00,$78,$08,$10,$20,$40,$40,$78,$00,$00,

  6, // $5B '['
  $38,$20,$20,$20,$20,$20,$20,$20,$38,$00,

  6, // $5C '\'
  $00,$40,$40,$20,$20,$10,$10,$08,$08,$00,

  6, // $5D ']'
  $38,$08,$08,$08,$08,$08,$08,$08,$38,$00,

  6, // $5E '^'
  $10,$28,$44,$00,$00,$00,$00,$00,$00,$00,

  6, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,

  6, // $60 '`'
  $00,$10,$10,$20,$00,$00,$00,$00,$00,$00,

  6, // $61 'a'
  $00,$00,$00,$38,$04,$3C,$44,$3C,$00,$00,

  6, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$78,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$3C,$00,$00,

  6, // $64 'd'
  $00,$04,$04,$3C,$44,$44,$44,$3C,$00,$00,

  6, // $65 'e'
  $00,$00,$00,$38,$44,$78,$40,$3C,$00,$00,

  6, // $66 'f'
  $00,$0C,$10,$10,$38,$10,$10,$10,$00,$00,

  6, // $67 'g'
  $00,$00,$00,$3C,$44,$44,$44,$3C,$04,$38,

  6, // $68 'h'
  $00,$40,$40,$78,$44,$44,$44,$44,$00,$00,

  6, // $69 'i'
  $00,$10,$00,$30,$10,$10,$10,$38,$00,$00,

  6, // $6A 'j'
  $00,$08,$00,$18,$08,$08,$08,$08,$48,$30,

  6, // $6B 'k'
  $00,$40,$40,$48,$50,$60,$50,$48,$00,$00,

  6, // $6C 'l'
  $00,$30,$10,$10,$10,$10,$10,$38,$00,$00,

  6, // $6D 'm'
  $00,$00,$00,$68,$54,$54,$44,$44,$00,$00,

  6, // $6E 'n'
  $00,$00,$00,$58,$64,$44,$44,$44,$00,$00,

  6, // $6F 'o'
  $00,$00,$00,$38,$44,$44,$44,$38,$00,$00,

  6, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$78,$40,$40,

  6, // $71 'q'
  $00,$00,$00,$3C,$44,$44,$44,$3C,$04,$04,

  6, // $72 'r'
  $00,$00,$00,$58,$24,$20,$20,$70,$00,$00,

  6, // $73 's'
  $00,$00,$00,$38,$40,$38,$04,$78,$00,$00,

  6, // $74 't'
  $00,$10,$10,$38,$10,$10,$14,$08,$00,$00,

  6, // $75 'u'
  $00,$00,$00,$44,$44,$44,$4C,$34,$00,$00,

  6, // $76 'v'
  $00,$00,$00,$44,$44,$44,$28,$10,$00,$00,

  6, // $77 'w'
  $00,$00,$00,$44,$44,$54,$7C,$28,$00,$00,

  6, // $78 'x'
  $00,$00,$00,$48,$48,$30,$48,$48,$00,$00,

  6, // $79 'y'
  $00,$00,$00,$44,$44,$44,$44,$3C,$04,$38,

  6, // $7A 'z'
  $00,$00,$00,$78,$08,$30,$40,$78,$00,$00,

  6, // $7B '{'
  $18,$20,$20,$20,$C0,$20,$20,$20,$18,$00,

  6, // $7C '|'
  $10,$10,$10,$10,$00,$10,$10,$10,$10,$00,

  6, // $7D '}'
  $60,$10,$10,$10,$0C,$10,$10,$10,$60,$00,

  6, // $7E '~'
  $00,$48,$A8,$90,$00,$00,$00,$00,$00,$00,

  6, // $7F ''
  $00,$10,$38,$6C,$44,$44,$7C,$00,$00,$00,

  0 );

 mcs6x11_mono : array[0..1348 ] of int8u = (
  11, 3, 32, 128-32,
  $00,$00,$0C,$00,$18,$00,$24,$00,$30,$00,$3C,$00,$48,$00,$54,$00,$60,$00,
  $6C,$00,$78,$00,$84,$00,$90,$00,$9C,$00,$A8,$00,$B4,$00,$C0,$00,$CC,$00,
  $D8,$00,$E4,$00,$F0,$00,$FC,$00,$08,$01,$14,$01,$20,$01,$2C,$01,$38,$01,
  $44,$01,$50,$01,$5C,$01,$68,$01,$74,$01,$80,$01,$8C,$01,$98,$01,$A4,$01,
  $B0,$01,$BC,$01,$C8,$01,$D4,$01,$E0,$01,$EC,$01,$F8,$01,$04,$02,$10,$02,
  $1C,$02,$28,$02,$34,$02,$40,$02,$4C,$02,$58,$02,$64,$02,$70,$02,$7C,$02,
  $88,$02,$94,$02,$A0,$02,$AC,$02,$B8,$02,$C4,$02,$D0,$02,$DC,$02,$E8,$02,
  $F4,$02,$00,$03,$0C,$03,$18,$03,$24,$03,$30,$03,$3C,$03,$48,$03,$54,$03,
  $60,$03,$6C,$03,$78,$03,$84,$03,$90,$03,$9C,$03,$A8,$03,$B4,$03,$C0,$03,
  $CC,$03,$D8,$03,$E4,$03,$F0,$03,$FC,$03,$08,$04,$14,$04,$20,$04,$2C,$04,
  $38,$04,$44,$04,$50,$04,$5C,$04,$68,$04,$74,$04,

  6, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$20,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  6, // $22 '"'
  $00,$28,$28,$50,$00,$00,$00,$00,$00,$00,$00,

  6, // $23 '#'
  $00,$28,$28,$7C,$28,$28,$7C,$28,$28,$00,$00,

  6, // $24 '$'
  $00,$10,$38,$54,$50,$38,$14,$54,$38,$10,$00,

  6, // $25 '%'
  $00,$68,$A8,$D0,$10,$20,$2C,$54,$58,$00,$00,

  6, // $26 '&'
  $00,$20,$50,$50,$20,$54,$54,$48,$34,$00,$00,

  6, // $27 '''
  $00,$10,$10,$20,$00,$00,$00,$00,$00,$00,$00,

  6, // $28 '('
  $08,$10,$10,$20,$20,$20,$20,$10,$10,$08,$00,

  6, // $29 ')'
  $20,$10,$10,$08,$08,$08,$08,$10,$10,$20,$00,

  6, // $2A '*'
  $00,$00,$28,$7C,$38,$7C,$28,$00,$00,$00,$00,

  6, // $2B '+'
  $00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,

  6, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$20,$40,

  6, // $2D '-'
  $00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,

  6, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,

  6, // $2F '/'
  $04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$00,

  6, // $30 '0'
  $00,$38,$44,$44,$54,$54,$44,$44,$38,$00,$00,

  6, // $31 '1'
  $00,$10,$30,$10,$10,$10,$10,$10,$38,$00,$00,

  6, // $32 '2'
  $00,$38,$44,$44,$08,$10,$20,$40,$7C,$00,$00,

  6, // $33 '3'
  $00,$38,$44,$04,$38,$04,$04,$44,$38,$00,$00,

  6, // $34 '4'
  $00,$08,$18,$28,$28,$48,$7C,$08,$08,$00,$00,

  6, // $35 '5'
  $00,$7C,$40,$78,$44,$04,$04,$44,$38,$00,$00,

  6, // $36 '6'
  $00,$38,$44,$40,$78,$44,$44,$44,$38,$00,$00,

  6, // $37 '7'
  $00,$7C,$04,$08,$08,$10,$10,$20,$20,$00,$00,

  6, // $38 '8'
  $00,$38,$44,$44,$38,$44,$44,$44,$38,$00,$00,

  6, // $39 '9'
  $00,$38,$44,$44,$3C,$04,$04,$44,$38,$00,$00,

  6, // $3A ':'
  $00,$00,$00,$30,$30,$00,$00,$30,$30,$00,$00,

  6, // $3B ';'
  $00,$00,$00,$30,$30,$00,$00,$30,$30,$20,$40,

  6, // $3C '<'
  $00,$04,$08,$10,$20,$40,$20,$10,$08,$04,$00,

  6, // $3D '='
  $00,$00,$00,$00,$7C,$00,$00,$7C,$00,$00,$00,

  6, // $3E '>'
  $00,$40,$20,$10,$08,$04,$08,$10,$20,$40,$00,

  6, // $3F '?'
  $00,$38,$44,$04,$08,$10,$10,$00,$10,$00,$00,

  6, // $40 '@'
  $00,$38,$44,$5C,$54,$54,$4C,$40,$38,$00,$00,

  6, // $41 'A'
  $00,$38,$44,$44,$44,$7C,$44,$44,$44,$00,$00,

  6, // $42 'B'
  $00,$78,$44,$44,$78,$44,$44,$44,$78,$00,$00,

  6, // $43 'C'
  $00,$38,$44,$40,$40,$40,$40,$44,$38,$00,$00,

  6, // $44 'D'
  $00,$70,$48,$44,$44,$44,$44,$48,$70,$00,$00,

  6, // $45 'E'
  $00,$7C,$40,$40,$78,$40,$40,$40,$7C,$00,$00,

  6, // $46 'F'
  $00,$7C,$40,$40,$78,$40,$40,$40,$40,$00,$00,

  6, // $47 'G'
  $00,$38,$44,$40,$40,$5C,$44,$4C,$34,$00,$00,

  6, // $48 'H'
  $00,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,

  6, // $49 'I'
  $00,$38,$10,$10,$10,$10,$10,$10,$38,$00,$00,

  6, // $4A 'J'
  $00,$1C,$08,$08,$08,$08,$48,$48,$30,$00,$00,

  6, // $4B 'K'
  $00,$44,$48,$50,$60,$50,$48,$44,$44,$00,$00,

  6, // $4C 'L'
  $00,$40,$40,$40,$40,$40,$40,$40,$7C,$00,$00,

  6, // $4D 'M'
  $00,$44,$6C,$54,$54,$54,$44,$44,$44,$00,$00,

  6, // $4E 'N'
  $00,$44,$64,$64,$54,$54,$4C,$4C,$44,$00,$00,

  6, // $4F 'O'
  $00,$38,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  6, // $50 'P'
  $00,$78,$44,$44,$44,$78,$40,$40,$40,$00,$00,

  6, // $51 'Q'
  $00,$38,$44,$44,$44,$44,$54,$48,$34,$00,$00,

  6, // $52 'R'
  $00,$78,$44,$44,$44,$78,$48,$44,$44,$00,$00,

  6, // $53 'S'
  $00,$38,$44,$40,$38,$04,$04,$44,$38,$00,$00,

  6, // $54 'T'
  $00,$7C,$10,$10,$10,$10,$10,$10,$10,$00,$00,

  6, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  6, // $56 'V'
  $00,$44,$44,$44,$28,$28,$28,$10,$10,$00,$00,

  6, // $57 'W'
  $00,$44,$44,$54,$54,$54,$54,$54,$28,$00,$00,

  6, // $58 'X'
  $00,$44,$44,$28,$10,$28,$44,$44,$44,$00,$00,

  6, // $59 'Y'
  $00,$44,$44,$44,$28,$10,$10,$10,$10,$00,$00,

  6, // $5A 'Z'
  $00,$7C,$04,$08,$10,$20,$40,$40,$7C,$00,$00,

  6, // $5B '['
  $38,$20,$20,$20,$20,$20,$20,$20,$20,$38,$00,

  6, // $5C '\'
  $80,$80,$40,$40,$20,$20,$10,$10,$08,$08,$00,

  6, // $5D ']'
  $38,$08,$08,$08,$08,$08,$08,$08,$08,$38,$00,

  6, // $5E '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,

  6, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,

  6, // $60 '`'
  $00,$20,$20,$10,$00,$00,$00,$00,$00,$00,$00,

  6, // $61 'a'
  $00,$00,$00,$38,$04,$3C,$44,$44,$3C,$00,$00,

  6, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$44,$78,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$44,$38,$00,$00,

  6, // $64 'd'
  $00,$04,$04,$3C,$44,$44,$44,$44,$3C,$00,$00,

  6, // $65 'e'
  $00,$00,$00,$38,$44,$7C,$40,$44,$38,$00,$00,

  6, // $66 'f'
  $00,$0C,$10,$38,$10,$10,$10,$10,$10,$00,$00,

  6, // $67 'g'
  $00,$00,$00,$3C,$44,$44,$44,$44,$3C,$04,$78,

  6, // $68 'h'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$00,$00,

  6, // $69 'i'
  $00,$10,$00,$30,$10,$10,$10,$10,$38,$00,$00,

  6, // $6A 'j'
  $00,$10,$00,$30,$10,$10,$10,$10,$10,$50,$20,

  6, // $6B 'k'
  $00,$40,$40,$4C,$50,$60,$50,$48,$44,$00,$00,

  6, // $6C 'l'
  $00,$30,$10,$10,$10,$10,$10,$10,$38,$00,$00,

  6, // $6D 'm'
  $00,$00,$00,$68,$54,$54,$54,$44,$44,$00,$00,

  6, // $6E 'n'
  $00,$00,$00,$78,$44,$44,$44,$44,$44,$00,$00,

  6, // $6F 'o'
  $00,$00,$00,$38,$44,$44,$44,$44,$38,$00,$00,

  6, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$44,$78,$40,$40,

  6, // $71 'q'
  $00,$00,$00,$3C,$44,$44,$44,$44,$3C,$04,$04,

  6, // $72 'r'
  $00,$00,$00,$58,$24,$20,$20,$20,$70,$00,$00,

  6, // $73 's'
  $00,$00,$00,$38,$44,$30,$08,$44,$38,$00,$00,

  6, // $74 't'
  $00,$20,$20,$70,$20,$20,$20,$20,$18,$00,$00,

  6, // $75 'u'
  $00,$00,$00,$44,$44,$44,$44,$4C,$34,$00,$00,

  6, // $76 'v'
  $00,$00,$00,$44,$44,$28,$28,$10,$10,$00,$00,

  6, // $77 'w'
  $00,$00,$00,$44,$44,$44,$54,$7C,$28,$00,$00,

  6, // $78 'x'
  $00,$00,$00,$44,$28,$10,$28,$44,$44,$00,$00,

  6, // $79 'y'
  $00,$00,$00,$44,$44,$44,$44,$44,$3C,$08,$70,

  6, // $7A 'z'
  $00,$00,$00,$7C,$08,$10,$20,$40,$7C,$00,$00,

  6, // $7B '{'
  $18,$20,$20,$20,$C0,$C0,$20,$20,$20,$18,$00,

  6, // $7C '|'
  $00,$10,$10,$10,$10,$00,$10,$10,$10,$10,$00,

  6, // $7D '}'
  $60,$10,$10,$10,$0C,$0C,$10,$10,$10,$60,$00,

  6, // $7E '~'
  $00,$24,$54,$48,$00,$00,$00,$00,$00,$00,$00,

  6, // $7F ''
  $00,$10,$38,$6C,$44,$44,$7C,$00,$00,$00,$00,

  0 );

 mcs7x12_mono_high : array[0..1444 ] of int8u = (
  12, 3, 32, 128-32,
  $00,$00,$0D,$00,$1A,$00,$27,$00,$34,$00,$41,$00,$4E,$00,$5B,$00,$68,$00,
  $75,$00,$82,$00,$8F,$00,$9C,$00,$A9,$00,$B6,$00,$C3,$00,$D0,$00,$DD,$00,
  $EA,$00,$F7,$00,$04,$01,$11,$01,$1E,$01,$2B,$01,$38,$01,$45,$01,$52,$01,
  $5F,$01,$6C,$01,$79,$01,$86,$01,$93,$01,$A0,$01,$AD,$01,$BA,$01,$C7,$01,
  $D4,$01,$E1,$01,$EE,$01,$FB,$01,$08,$02,$15,$02,$22,$02,$2F,$02,$3C,$02,
  $49,$02,$56,$02,$63,$02,$70,$02,$7D,$02,$8A,$02,$97,$02,$A4,$02,$B1,$02,
  $BE,$02,$CB,$02,$D8,$02,$E5,$02,$F2,$02,$FF,$02,$0C,$03,$19,$03,$26,$03,
  $33,$03,$40,$03,$4D,$03,$5A,$03,$67,$03,$74,$03,$81,$03,$8E,$03,$9B,$03,
  $A8,$03,$B5,$03,$C2,$03,$CF,$03,$DC,$03,$E9,$03,$F6,$03,$03,$04,$10,$04,
  $1D,$04,$2A,$04,$37,$04,$44,$04,$51,$04,$5E,$04,$6B,$04,$78,$04,$85,$04,
  $92,$04,$9F,$04,$AC,$04,$B9,$04,$C6,$04,$D3,$04,

  7, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $21 '!'
  $10,$10,$10,$10,$10,$10,$10,$10,$00,$10,$00,$00,

  7, // $22 '"'
  $28,$28,$50,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $23 '#'
  $24,$24,$24,$7E,$24,$24,$24,$7E,$24,$24,$24,$00,

  7, // $24 '$'
  $10,$10,$38,$54,$50,$38,$14,$54,$38,$10,$10,$00,

  7, // $25 '%'
  $32,$54,$64,$08,$08,$10,$10,$26,$2A,$4C,$00,$00,

  7, // $26 '&'
  $00,$20,$50,$50,$50,$20,$54,$54,$48,$34,$00,$00,

  7, // $27 '''
  $10,$10,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $08,$10,$10,$20,$20,$20,$20,$20,$10,$10,$08,$00,

  7, // $29 ')'
  $20,$10,$10,$08,$08,$08,$08,$08,$10,$10,$20,$00,

  7, // $2A '*'
  $00,$00,$10,$54,$38,$7C,$38,$54,$10,$00,$00,$00,

  7, // $2B '+'
  $00,$00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,

  7, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$20,$40,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,

  7, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,

  7, // $2F '/'
  $04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$00,$00,

  7, // $30 '0'
  $00,$38,$44,$44,$54,$54,$54,$44,$44,$38,$00,$00,

  7, // $31 '1'
  $00,$10,$30,$10,$10,$10,$10,$10,$10,$38,$00,$00,

  7, // $32 '2'
  $00,$38,$44,$04,$04,$08,$10,$20,$40,$7C,$00,$00,

  7, // $33 '3'
  $00,$38,$44,$04,$04,$38,$04,$04,$44,$38,$00,$00,

  7, // $34 '4'
  $00,$08,$18,$28,$28,$48,$48,$7C,$08,$08,$00,$00,

  7, // $35 '5'
  $00,$7C,$40,$40,$78,$44,$04,$04,$44,$38,$00,$00,

  7, // $36 '6'
  $00,$38,$44,$40,$78,$44,$44,$44,$44,$38,$00,$00,

  7, // $37 '7'
  $00,$7C,$04,$08,$08,$10,$10,$20,$20,$20,$00,$00,

  7, // $38 '8'
  $00,$38,$44,$44,$44,$38,$44,$44,$44,$38,$00,$00,

  7, // $39 '9'
  $00,$38,$44,$44,$44,$3C,$04,$04,$44,$38,$00,$00,

  7, // $3A ':'
  $00,$00,$00,$30,$30,$00,$00,$00,$30,$30,$00,$00,

  7, // $3B ';'
  $00,$00,$00,$30,$30,$00,$00,$00,$30,$30,$20,$40,

  7, // $3C '<'
  $00,$04,$08,$10,$20,$40,$20,$10,$08,$04,$00,$00,

  7, // $3D '='
  $00,$00,$00,$00,$7C,$00,$00,$7C,$00,$00,$00,$00,

  7, // $3E '>'
  $00,$40,$20,$10,$08,$04,$08,$10,$20,$40,$00,$00,

  7, // $3F '?'
  $00,$38,$44,$04,$04,$08,$10,$10,$00,$10,$00,$00,

  7, // $40 '@'
  $00,$38,$44,$44,$5C,$54,$54,$4C,$40,$38,$00,$00,

  7, // $41 'A'
  $00,$38,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,

  7, // $42 'B'
  $00,$78,$44,$44,$44,$78,$44,$44,$44,$78,$00,$00,

  7, // $43 'C'
  $00,$38,$44,$40,$40,$40,$40,$40,$44,$38,$00,$00,

  7, // $44 'D'
  $00,$70,$48,$44,$44,$44,$44,$44,$48,$70,$00,$00,

  7, // $45 'E'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$7C,$00,$00,

  7, // $46 'F'
  $00,$7C,$40,$40,$40,$78,$40,$40,$40,$40,$00,$00,

  7, // $47 'G'
  $00,$38,$44,$40,$40,$5C,$44,$44,$4C,$34,$00,$00,

  7, // $48 'H'
  $00,$44,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,

  7, // $49 'I'
  $00,$38,$10,$10,$10,$10,$10,$10,$10,$38,$00,$00,

  7, // $4A 'J'
  $00,$1C,$08,$08,$08,$08,$08,$48,$48,$30,$00,$00,

  7, // $4B 'K'
  $00,$44,$48,$50,$60,$60,$50,$48,$44,$44,$00,$00,

  7, // $4C 'L'
  $00,$40,$40,$40,$40,$40,$40,$40,$40,$7C,$00,$00,

  7, // $4D 'M'
  $00,$44,$6C,$6C,$54,$54,$44,$44,$44,$44,$00,$00,

  7, // $4E 'N'
  $00,$44,$64,$64,$54,$54,$4C,$4C,$44,$44,$00,$00,

  7, // $4F 'O'
  $00,$38,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $50 'P'
  $00,$78,$44,$44,$44,$44,$78,$40,$40,$40,$00,$00,

  7, // $51 'Q'
  $00,$38,$44,$44,$44,$44,$44,$54,$48,$34,$00,$00,

  7, // $52 'R'
  $00,$78,$44,$44,$44,$44,$78,$48,$44,$44,$00,$00,

  7, // $53 'S'
  $00,$38,$44,$40,$40,$38,$04,$04,$44,$38,$00,$00,

  7, // $54 'T'
  $00,$7C,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,

  7, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $56 'V'
  $00,$44,$44,$44,$44,$28,$28,$28,$10,$10,$00,$00,

  7, // $57 'W'
  $00,$44,$44,$44,$44,$44,$44,$54,$54,$28,$00,$00,

  7, // $58 'X'
  $00,$44,$44,$44,$28,$10,$28,$44,$44,$44,$00,$00,

  7, // $59 'Y'
  $00,$44,$44,$44,$44,$28,$10,$10,$10,$10,$00,$00,

  7, // $5A 'Z'
  $00,$7C,$04,$04,$08,$10,$20,$40,$40,$7C,$00,$00,

  7, // $5B '['
  $38,$20,$20,$20,$20,$20,$20,$20,$20,$20,$38,$00,

  7, // $5C '\'
  $00,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$00,

  7, // $5D ']'
  $38,$08,$08,$08,$08,$08,$08,$08,$08,$08,$38,$00,

  7, // $5E '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,

  7, // $60 '`'
  $00,$20,$20,$10,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$38,$04,$3C,$44,$44,$44,$3C,$00,$00,

  7, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$78,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$40,$44,$38,$00,$00,

  7, // $64 'd'
  $00,$04,$04,$3C,$44,$44,$44,$44,$44,$3C,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$38,$44,$44,$7C,$40,$44,$38,$00,$00,

  7, // $66 'f'
  $00,$0C,$10,$38,$10,$10,$10,$10,$10,$10,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$3C,$44,$44,$44,$44,$44,$3C,$04,$78,

  7, // $68 'h'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$44,$00,$00,

  7, // $69 'i'
  $00,$10,$00,$30,$10,$10,$10,$10,$10,$38,$00,$00,

  7, // $6A 'j'
  $00,$08,$00,$18,$08,$08,$08,$08,$08,$08,$48,$30,

  7, // $6B 'k'
  $00,$40,$40,$44,$48,$50,$60,$50,$48,$44,$00,$00,

  7, // $6C 'l'
  $00,$30,$10,$10,$10,$10,$10,$10,$10,$38,$00,$00,

  7, // $6D 'm'
  $00,$00,$00,$68,$54,$54,$44,$44,$44,$44,$00,$00,

  7, // $6E 'n'
  $00,$00,$00,$58,$64,$44,$44,$44,$44,$44,$00,$00,

  7, // $6F 'o'
  $00,$00,$00,$38,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$44,$44,$78,$40,$40,

  7, // $71 'q'
  $00,$00,$00,$3C,$44,$44,$44,$44,$44,$3C,$04,$04,

  7, // $72 'r'
  $00,$00,$00,$58,$24,$20,$20,$20,$20,$70,$00,$00,

  7, // $73 's'
  $00,$00,$00,$38,$44,$40,$38,$04,$44,$38,$00,$00,

  7, // $74 't'
  $00,$20,$20,$70,$20,$20,$20,$20,$24,$18,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$44,$44,$44,$44,$44,$4C,$34,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$44,$44,$44,$28,$28,$10,$10,$00,$00,

  7, // $77 'w'
  $00,$00,$00,$44,$44,$44,$44,$54,$54,$28,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$44,$44,$44,$44,$44,$44,$3C,$08,$70,

  7, // $7A 'z'
  $00,$00,$00,$7C,$04,$08,$10,$20,$40,$7C,$00,$00,

  7, // $7B '{'
  $18,$20,$20,$20,$20,$C0,$20,$20,$20,$20,$18,$00,

  7, // $7C '|'
  $00,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,

  7, // $7D '}'
  $60,$10,$10,$10,$10,$0C,$10,$10,$10,$10,$60,$00,

  7, // $7E '~'
  $00,$60,$92,$92,$0C,$00,$00,$00,$00,$00,$00,$00,

  7, // $7F ''
  $00,$10,$38,$6C,$44,$44,$7C,$00,$00,$00,$00,$00,

  0 );

 mcs7x12_mono_low : array[0..1444 ] of int8u = (
  12, 4, 32, 128-32,
  $00,$00,$0D,$00,$1A,$00,$27,$00,$34,$00,$41,$00,$4E,$00,$5B,$00,$68,$00,
  $75,$00,$82,$00,$8F,$00,$9C,$00,$A9,$00,$B6,$00,$C3,$00,$D0,$00,$DD,$00,
  $EA,$00,$F7,$00,$04,$01,$11,$01,$1E,$01,$2B,$01,$38,$01,$45,$01,$52,$01,
  $5F,$01,$6C,$01,$79,$01,$86,$01,$93,$01,$A0,$01,$AD,$01,$BA,$01,$C7,$01,
  $D4,$01,$E1,$01,$EE,$01,$FB,$01,$08,$02,$15,$02,$22,$02,$2F,$02,$3C,$02,
  $49,$02,$56,$02,$63,$02,$70,$02,$7D,$02,$8A,$02,$97,$02,$A4,$02,$B1,$02,
  $BE,$02,$CB,$02,$D8,$02,$E5,$02,$F2,$02,$FF,$02,$0C,$03,$19,$03,$26,$03,
  $33,$03,$40,$03,$4D,$03,$5A,$03,$67,$03,$74,$03,$81,$03,$8E,$03,$9B,$03,
  $A8,$03,$B5,$03,$C2,$03,$CF,$03,$DC,$03,$E9,$03,$F6,$03,$03,$04,$10,$04,
  $1D,$04,$2A,$04,$37,$04,$44,$04,$51,$04,$5E,$04,$6B,$04,$78,$04,$85,$04,
  $92,$04,$9F,$04,$AC,$04,$B9,$04,$C6,$04,$D3,$04,

  7, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $21 '!'
  $00,$10,$10,$10,$10,$10,$10,$10,$00,$10,$00,$00,

  7, // $22 '"'
  $28,$28,$50,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $23 '#'
  $00,$28,$28,$7C,$28,$28,$28,$7C,$28,$28,$00,$00,

  7, // $24 '$'
  $00,$10,$38,$54,$50,$38,$14,$54,$38,$10,$00,$00,

  7, // $25 '%'
  $34,$54,$68,$08,$10,$10,$20,$2C,$54,$58,$00,$00,

  7, // $26 '&'
  $00,$20,$50,$50,$20,$54,$54,$48,$34,$00,$00,$00,

  7, // $27 '''
  $00,$10,$10,$20,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $08,$10,$10,$20,$20,$20,$20,$20,$10,$10,$08,$00,

  7, // $29 ')'
  $20,$10,$10,$08,$08,$08,$08,$08,$10,$10,$20,$00,

  7, // $2A '*'
  $00,$00,$10,$54,$38,$7C,$38,$54,$10,$00,$00,$00,

  7, // $2B '+'
  $00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,$00,

  7, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$20,$40,$00,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,

  7, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,$00,

  7, // $2F '/'
  $04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$00,$00,

  7, // $30 '0'
  $00,$38,$44,$44,$54,$54,$44,$44,$38,$00,$00,$00,

  7, // $31 '1'
  $00,$10,$30,$10,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $32 '2'
  $00,$38,$44,$44,$08,$10,$20,$40,$7C,$00,$00,$00,

  7, // $33 '3'
  $00,$38,$44,$04,$38,$04,$04,$44,$38,$00,$00,$00,

  7, // $34 '4'
  $00,$08,$18,$28,$28,$48,$7C,$08,$08,$00,$00,$00,

  7, // $35 '5'
  $00,$7C,$40,$78,$44,$04,$04,$44,$38,$00,$00,$00,

  7, // $36 '6'
  $00,$38,$44,$40,$78,$44,$44,$44,$38,$00,$00,$00,

  7, // $37 '7'
  $00,$7C,$04,$08,$08,$10,$10,$20,$20,$00,$00,$00,

  7, // $38 '8'
  $00,$38,$44,$44,$38,$44,$44,$44,$38,$00,$00,$00,

  7, // $39 '9'
  $00,$38,$44,$44,$44,$3C,$04,$44,$38,$00,$00,$00,

  7, // $3A ':'
  $00,$00,$00,$30,$30,$00,$00,$30,$30,$00,$00,$00,

  7, // $3B ';'
  $00,$00,$00,$30,$30,$00,$00,$30,$30,$20,$40,$00,

  7, // $3C '<'
  $00,$04,$08,$10,$20,$40,$20,$10,$08,$04,$00,$00,

  7, // $3D '='
  $00,$00,$00,$00,$7C,$00,$00,$7C,$00,$00,$00,$00,

  7, // $3E '>'
  $00,$40,$20,$10,$08,$04,$08,$10,$20,$40,$00,$00,

  7, // $3F '?'
  $00,$38,$44,$04,$04,$08,$10,$10,$00,$10,$00,$00,

  7, // $40 '@'
  $00,$38,$44,$44,$5C,$54,$4C,$40,$38,$00,$00,$00,

  7, // $41 'A'
  $00,$38,$44,$44,$44,$7C,$44,$44,$44,$00,$00,$00,

  7, // $42 'B'
  $00,$78,$44,$44,$78,$44,$44,$44,$78,$00,$00,$00,

  7, // $43 'C'
  $00,$38,$44,$40,$40,$40,$40,$44,$38,$00,$00,$00,

  7, // $44 'D'
  $00,$70,$48,$44,$44,$44,$44,$48,$70,$00,$00,$00,

  7, // $45 'E'
  $00,$7C,$40,$40,$78,$40,$40,$40,$7C,$00,$00,$00,

  7, // $46 'F'
  $00,$7C,$40,$40,$78,$40,$40,$40,$40,$00,$00,$00,

  7, // $47 'G'
  $00,$38,$44,$40,$40,$4C,$44,$4C,$34,$00,$00,$00,

  7, // $48 'H'
  $00,$44,$44,$44,$7C,$44,$44,$44,$44,$00,$00,$00,

  7, // $49 'I'
  $00,$38,$10,$10,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $4A 'J'
  $00,$1C,$08,$08,$08,$08,$48,$48,$30,$00,$00,$00,

  7, // $4B 'K'
  $00,$44,$48,$50,$60,$60,$50,$48,$44,$00,$00,$00,

  7, // $4C 'L'
  $00,$40,$40,$40,$40,$40,$40,$40,$7C,$00,$00,$00,

  7, // $4D 'M'
  $00,$44,$6C,$54,$54,$44,$44,$44,$44,$00,$00,$00,

  7, // $4E 'N'
  $00,$44,$64,$64,$54,$54,$4C,$4C,$44,$00,$00,$00,

  7, // $4F 'O'
  $00,$38,$44,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $50 'P'
  $00,$78,$44,$44,$44,$78,$40,$40,$40,$00,$00,$00,

  7, // $51 'Q'
  $00,$38,$44,$44,$44,$44,$54,$48,$34,$00,$00,$00,

  7, // $52 'R'
  $00,$78,$44,$44,$44,$78,$48,$44,$44,$00,$00,$00,

  7, // $53 'S'
  $00,$38,$44,$40,$38,$04,$44,$44,$38,$00,$00,$00,

  7, // $54 'T'
  $00,$7C,$10,$10,$10,$10,$10,$10,$10,$00,$00,$00,

  7, // $55 'U'
  $00,$44,$44,$44,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $56 'V'
  $00,$44,$44,$44,$28,$28,$28,$10,$10,$00,$00,$00,

  7, // $57 'W'
  $00,$44,$44,$44,$44,$44,$54,$54,$28,$00,$00,$00,

  7, // $58 'X'
  $00,$44,$44,$28,$10,$28,$44,$44,$44,$00,$00,$00,

  7, // $59 'Y'
  $00,$44,$44,$44,$28,$10,$10,$10,$10,$00,$00,$00,

  7, // $5A 'Z'
  $00,$7C,$04,$08,$10,$20,$40,$40,$7C,$00,$00,$00,

  7, // $5B '['
  $38,$20,$20,$20,$20,$20,$20,$20,$20,$20,$38,$00,

  7, // $5C '\'
  $00,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$00,

  7, // $5D ']'
  $38,$08,$08,$08,$08,$08,$08,$08,$08,$08,$38,$00,

  7, // $5E '^'
  $00,$10,$28,$44,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,

  7, // $60 '`'
  $00,$20,$20,$10,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$38,$04,$3C,$44,$44,$3C,$00,$00,$00,

  7, // $62 'b'
  $00,$40,$40,$78,$44,$44,$44,$44,$78,$00,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$38,$44,$40,$40,$44,$38,$00,$00,$00,

  7, // $64 'd'
  $00,$04,$04,$3C,$44,$44,$44,$44,$3C,$00,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$38,$44,$7C,$40,$44,$38,$00,$00,$00,

  7, // $66 'f'
  $00,$0C,$10,$38,$10,$10,$10,$10,$10,$00,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$3C,$44,$44,$44,$44,$3C,$04,$44,$38,

  7, // $68 'h'
  $00,$40,$40,$78,$44,$44,$44,$44,$44,$00,$00,$00,

  7, // $69 'i'
  $00,$10,$00,$30,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $6A 'j'
  $00,$08,$00,$18,$08,$08,$08,$08,$08,$48,$48,$30,

  7, // $6B 'k'
  $00,$40,$40,$4C,$50,$60,$50,$48,$44,$00,$00,$00,

  7, // $6C 'l'
  $00,$30,$10,$10,$10,$10,$10,$10,$38,$00,$00,$00,

  7, // $6D 'm'
  $00,$00,$00,$68,$54,$54,$44,$44,$44,$00,$00,$00,

  7, // $6E 'n'
  $00,$00,$00,$58,$64,$44,$44,$44,$44,$00,$00,$00,

  7, // $6F 'o'
  $00,$00,$00,$38,$44,$44,$44,$44,$38,$00,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$78,$44,$44,$44,$44,$78,$40,$40,$40,

  7, // $71 'q'
  $00,$00,$00,$3C,$44,$44,$44,$44,$3C,$04,$04,$04,

  7, // $72 'r'
  $00,$00,$00,$58,$24,$20,$20,$20,$70,$00,$00,$00,

  7, // $73 's'
  $00,$00,$00,$38,$44,$30,$08,$44,$38,$00,$00,$00,

  7, // $74 't'
  $00,$20,$20,$70,$20,$20,$20,$24,$18,$00,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$44,$44,$44,$44,$4C,$34,$00,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$44,$44,$28,$28,$10,$10,$00,$00,$00,

  7, // $77 'w'
  $00,$00,$00,$44,$44,$44,$54,$54,$28,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$44,$28,$10,$28,$44,$44,$00,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$44,$44,$44,$44,$44,$3C,$04,$08,$70,

  7, // $7A 'z'
  $00,$00,$00,$7C,$08,$10,$20,$40,$7C,$00,$00,$00,

  7, // $7B '{'
  $18,$20,$20,$20,$20,$C0,$20,$20,$20,$20,$18,$00,

  7, // $7C '|'
  $00,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,

  7, // $7D '}'
  $60,$10,$10,$10,$10,$0C,$10,$10,$10,$10,$60,$00,

  7, // $7E '~'
  $00,$24,$54,$48,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $7F ''
  $00,$10,$38,$6C,$44,$44,$7C,$00,$00,$00,$00,$00,

  0 );

 verdana12 : array[0..1540 ] of int8u = (
  12, 3, 32, 128-32,
  $00,$00,$0D,$00,$1A,$00,$27,$00,$34,$00,$41,$00,$5A,$00,$67,$00,$74,$00,
  $81,$00,$8E,$00,$9B,$00,$A8,$00,$B5,$00,$C2,$00,$CF,$00,$DC,$00,$E9,$00,
  $F6,$00,$03,$01,$10,$01,$1D,$01,$2A,$01,$37,$01,$44,$01,$51,$01,$5E,$01,
  $6B,$01,$78,$01,$85,$01,$92,$01,$9F,$01,$AC,$01,$C5,$01,$D2,$01,$DF,$01,
  $EC,$01,$F9,$01,$06,$02,$13,$02,$20,$02,$2D,$02,$3A,$02,$47,$02,$54,$02,
  $61,$02,$7A,$02,$87,$02,$A0,$02,$AD,$02,$C6,$02,$D3,$02,$E0,$02,$ED,$02,
  $FA,$02,$07,$03,$20,$03,$2D,$03,$3A,$03,$47,$03,$54,$03,$61,$03,$6E,$03,
  $7B,$03,$88,$03,$95,$03,$A2,$03,$AF,$03,$BC,$03,$C9,$03,$D6,$03,$E3,$03,
  $F0,$03,$FD,$03,$0A,$04,$17,$04,$24,$04,$31,$04,$4A,$04,$57,$04,$64,$04,
  $71,$04,$7E,$04,$8B,$04,$98,$04,$A5,$04,$B2,$04,$BF,$04,$CC,$04,$D9,$04,
  $E6,$04,$F3,$04,$00,$05,$0D,$05,$1A,$05,$27,$05,

  3, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$00,$00,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  5, // $22 '"'
  $00,$00,$50,$50,$50,$00,$00,$00,$00,$00,$00,$00,

  7, // $23 '#'
  $00,$00,$00,$00,$28,$7C,$28,$7C,$28,$00,$00,$00,

  7, // $24 '$'
  $00,$00,$10,$10,$3C,$50,$30,$18,$14,$78,$10,$10,

  11, // $25 '%'
  $00,$00,$00,$00,$00,$00,$31,$00,$4A,$00,$4A,$00,$35,$80,$0A,$40,$0A,$40,$11,$80,$00,$00,$00,$00,

  7, // $26 '&'
  $00,$00,$00,$30,$48,$48,$32,$4A,$44,$3A,$00,$00,

  3, // $27 '''
  $00,$00,$40,$40,$40,$00,$00,$00,$00,$00,$00,$00,

  4, // $28 '('
  $00,$00,$10,$20,$40,$40,$40,$40,$40,$40,$20,$10,

  4, // $29 ')'
  $00,$00,$80,$40,$20,$20,$20,$20,$20,$20,$40,$80,

  7, // $2A '*'
  $00,$10,$54,$38,$54,$10,$00,$00,$00,$00,$00,$00,

  7, // $2B '+'
  $00,$00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,

  3, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$40,$80,$00,

  5, // $2D '-'
  $00,$00,$00,$00,$00,$00,$70,$00,$00,$00,$00,$00,

  3, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$40,$00,$00,

  4, // $2F '/'
  $00,$00,$10,$10,$20,$20,$40,$40,$40,$80,$80,$00,

  7, // $30 '0'
  $00,$00,$00,$38,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $31 '1'
  $00,$00,$00,$10,$30,$10,$10,$10,$10,$38,$00,$00,

  7, // $32 '2'
  $00,$00,$00,$38,$44,$04,$08,$10,$20,$7C,$00,$00,

  7, // $33 '3'
  $00,$00,$00,$38,$44,$04,$18,$04,$44,$38,$00,$00,

  7, // $34 '4'
  $00,$00,$00,$08,$18,$28,$48,$7C,$08,$08,$00,$00,

  7, // $35 '5'
  $00,$00,$00,$7C,$40,$78,$04,$04,$44,$38,$00,$00,

  7, // $36 '6'
  $00,$00,$00,$18,$20,$40,$78,$44,$44,$38,$00,$00,

  7, // $37 '7'
  $00,$00,$00,$7C,$04,$08,$08,$10,$10,$10,$00,$00,

  7, // $38 '8'
  $00,$00,$00,$38,$44,$44,$38,$44,$44,$38,$00,$00,

  7, // $39 '9'
  $00,$00,$00,$38,$44,$44,$3C,$04,$08,$30,$00,$00,

  4, // $3A ':'
  $00,$00,$00,$00,$00,$40,$40,$00,$40,$40,$00,$00,

  4, // $3B ';'
  $00,$00,$00,$00,$00,$40,$40,$00,$40,$40,$80,$00,

  7, // $3C '<'
  $00,$00,$00,$00,$04,$18,$60,$18,$04,$00,$00,$00,

  7, // $3D '='
  $00,$00,$00,$00,$00,$7C,$00,$7C,$00,$00,$00,$00,

  7, // $3E '>'
  $00,$00,$00,$00,$40,$30,$0C,$30,$40,$00,$00,$00,

  6, // $3F '?'
  $00,$00,$00,$70,$08,$08,$10,$20,$00,$20,$00,$00,

  10, // $40 '@'
  $00,$00,$00,$00,$00,$00,$1F,$00,$20,$80,$4E,$80,$52,$80,$52,$80,$4D,$00,$20,$00,$1F,$00,$00,$00,

  8, // $41 'A'
  $00,$00,$00,$18,$18,$24,$24,$7E,$42,$42,$00,$00,

  7, // $42 'B'
  $00,$00,$00,$70,$48,$48,$78,$44,$44,$78,$00,$00,

  8, // $43 'C'
  $00,$00,$00,$1C,$22,$40,$40,$40,$22,$1C,$00,$00,

  8, // $44 'D'
  $00,$00,$00,$78,$44,$42,$42,$42,$44,$78,$00,$00,

  7, // $45 'E'
  $00,$00,$00,$7C,$40,$40,$78,$40,$40,$7C,$00,$00,

  6, // $46 'F'
  $00,$00,$00,$7C,$40,$40,$78,$40,$40,$40,$00,$00,

  8, // $47 'G'
  $00,$00,$00,$1C,$22,$40,$4E,$42,$22,$1C,$00,$00,

  8, // $48 'H'
  $00,$00,$00,$42,$42,$42,$7E,$42,$42,$42,$00,$00,

  5, // $49 'I'
  $00,$00,$00,$70,$20,$20,$20,$20,$20,$70,$00,$00,

  5, // $4A 'J'
  $00,$00,$00,$30,$10,$10,$10,$10,$10,$E0,$00,$00,

  7, // $4B 'K'
  $00,$00,$00,$44,$48,$50,$60,$50,$48,$44,$00,$00,

  6, // $4C 'L'
  $00,$00,$00,$40,$40,$40,$40,$40,$40,$7C,$00,$00,

  9, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$55,$00,$55,$00,$49,$00,$49,$00,$41,$00,$00,$00,$00,$00,

  8, // $4E 'N'
  $00,$00,$00,$42,$62,$52,$4A,$46,$42,$42,$00,$00,

  9, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$00,$00,$00,$00,

  7, // $50 'P'
  $00,$00,$00,$78,$44,$44,$44,$78,$40,$40,$00,$00,

  9, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$04,$00,$03,$00,

  7, // $52 'R'
  $00,$00,$00,$78,$44,$44,$78,$50,$48,$44,$00,$00,

  7, // $53 'S'
  $00,$00,$00,$38,$44,$40,$38,$04,$44,$38,$00,$00,

  7, // $54 'T'
  $00,$00,$00,$FE,$10,$10,$10,$10,$10,$10,$00,$00,

  8, // $55 'U'
  $00,$00,$00,$42,$42,$42,$42,$42,$42,$3C,$00,$00,

  8, // $56 'V'
  $00,$00,$00,$42,$42,$42,$24,$24,$18,$18,$00,$00,

  9, // $57 'W'
  $00,$00,$00,$00,$00,$00,$41,$00,$49,$00,$49,$00,$55,$00,$55,$00,$22,$00,$22,$00,$00,$00,$00,$00,

  7, // $58 'X'
  $00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$00,$00,

  7, // $59 'Y'
  $00,$00,$00,$44,$44,$28,$28,$10,$10,$10,$00,$00,

  7, // $5A 'Z'
  $00,$00,$00,$7C,$04,$08,$10,$20,$40,$7C,$00,$00,

  4, // $5B '['
  $00,$00,$60,$40,$40,$40,$40,$40,$40,$40,$40,$60,

  4, // $5C '\'
  $00,$00,$80,$80,$40,$40,$40,$20,$20,$10,$10,$00,

  4, // $5D ']'
  $00,$00,$60,$20,$20,$20,$20,$20,$20,$20,$20,$60,

  7, // $5E '^'
  $00,$00,$00,$10,$28,$44,$00,$00,$00,$00,$00,$00,

  6, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FC,

  6, // $60 '`'
  $00,$00,$20,$10,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $61 'a'
  $00,$00,$00,$00,$00,$30,$08,$38,$48,$38,$00,$00,

  6, // $62 'b'
  $00,$00,$40,$40,$40,$70,$48,$48,$48,$70,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$00,$00,$38,$40,$40,$40,$38,$00,$00,

  6, // $64 'd'
  $00,$00,$08,$08,$08,$38,$48,$48,$48,$38,$00,$00,

  6, // $65 'e'
  $00,$00,$00,$00,$00,$30,$48,$78,$40,$38,$00,$00,

  4, // $66 'f'
  $00,$00,$30,$40,$40,$E0,$40,$40,$40,$40,$00,$00,

  6, // $67 'g'
  $00,$00,$00,$00,$00,$38,$48,$48,$48,$38,$08,$30,

  6, // $68 'h'
  $00,$00,$40,$40,$40,$70,$48,$48,$48,$48,$00,$00,

  3, // $69 'i'
  $00,$00,$00,$40,$00,$40,$40,$40,$40,$40,$00,$00,

  3, // $6A 'j'
  $00,$00,$00,$40,$00,$C0,$40,$40,$40,$40,$40,$80,

  6, // $6B 'k'
  $00,$00,$40,$40,$40,$48,$50,$60,$50,$48,$00,$00,

  3, // $6C 'l'
  $00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,

  9, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$76,$00,$49,$00,$49,$00,$49,$00,$49,$00,$00,$00,$00,$00,

  6, // $6E 'n'
  $00,$00,$00,$00,$00,$70,$48,$48,$48,$48,$00,$00,

  6, // $6F 'o'
  $00,$00,$00,$00,$00,$30,$48,$48,$48,$30,$00,$00,

  6, // $70 'p'
  $00,$00,$00,$00,$00,$70,$48,$48,$48,$70,$40,$40,

  6, // $71 'q'
  $00,$00,$00,$00,$00,$38,$48,$48,$48,$38,$08,$08,

  4, // $72 'r'
  $00,$00,$00,$00,$00,$50,$60,$40,$40,$40,$00,$00,

  6, // $73 's'
  $00,$00,$00,$00,$00,$38,$40,$30,$08,$70,$00,$00,

  4, // $74 't'
  $00,$00,$00,$00,$40,$F0,$40,$40,$40,$30,$00,$00,

  6, // $75 'u'
  $00,$00,$00,$00,$00,$48,$48,$48,$48,$38,$00,$00,

  6, // $76 'v'
  $00,$00,$00,$00,$00,$48,$48,$48,$30,$30,$00,$00,

  7, // $77 'w'
  $00,$00,$00,$00,$00,$44,$54,$54,$28,$28,$00,$00,

  6, // $78 'x'
  $00,$00,$00,$00,$00,$48,$48,$30,$48,$48,$00,$00,

  6, // $79 'y'
  $00,$00,$00,$00,$00,$48,$48,$48,$30,$10,$20,$20,

  5, // $7A 'z'
  $00,$00,$00,$00,$00,$70,$10,$20,$40,$70,$00,$00,

  6, // $7B '{'
  $00,$00,$18,$20,$20,$20,$20,$C0,$20,$20,$20,$18,

  5, // $7C '|'
  $00,$00,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,

  6, // $7D '}'
  $00,$00,$60,$10,$10,$10,$10,$0C,$10,$10,$10,$60,

  7, // $7E '~'
  $00,$00,$00,$00,$00,$00,$34,$58,$00,$00,$00,$00,

  9, // $7F ''
  $00,$00,$00,$00,$00,$00,$7F,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$7F,$00,$00,$00,$00,$00,

  0 );

 verdana12_bold : array[0..1516 ] of int8u = (
  12, 3, 32, 128-32,
  $00,$00,$0D,$00,$1A,$00,$27,$00,$34,$00,$41,$00,$5A,$00,$67,$00,$74,$00,
  $81,$00,$8E,$00,$9B,$00,$A8,$00,$B5,$00,$C2,$00,$CF,$00,$DC,$00,$E9,$00,
  $F6,$00,$03,$01,$10,$01,$1D,$01,$2A,$01,$37,$01,$44,$01,$51,$01,$5E,$01,
  $6B,$01,$78,$01,$85,$01,$92,$01,$9F,$01,$AC,$01,$C5,$01,$D2,$01,$DF,$01,
  $EC,$01,$F9,$01,$06,$02,$13,$02,$20,$02,$2D,$02,$3A,$02,$47,$02,$54,$02,
  $61,$02,$6E,$02,$7B,$02,$88,$02,$95,$02,$A2,$02,$AF,$02,$BC,$02,$C9,$02,
  $D6,$02,$E3,$02,$FC,$02,$09,$03,$16,$03,$23,$03,$30,$03,$3D,$03,$4A,$03,
  $57,$03,$64,$03,$71,$03,$7E,$03,$8B,$03,$98,$03,$A5,$03,$B2,$03,$BF,$03,
  $CC,$03,$D9,$03,$E6,$03,$F3,$03,$00,$04,$0D,$04,$26,$04,$33,$04,$40,$04,
  $4D,$04,$5A,$04,$67,$04,$74,$04,$81,$04,$8E,$04,$9B,$04,$B4,$04,$C1,$04,
  $CE,$04,$DB,$04,$E8,$04,$F5,$04,$02,$05,$0F,$05,

  3, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $00,$00,$00,$60,$60,$60,$60,$60,$00,$60,$00,$00,

  5, // $22 '"'
  $00,$00,$D8,$D8,$D8,$00,$00,$00,$00,$00,$00,$00,

  8, // $23 '#'
  $00,$00,$00,$14,$14,$7E,$28,$FC,$50,$50,$00,$00,

  6, // $24 '$'
  $00,$00,$20,$20,$70,$E8,$E0,$38,$B8,$70,$20,$20,

  11, // $25 '%'
  $00,$00,$00,$00,$00,$00,$62,$00,$94,$00,$94,$00,$69,$80,$0A,$40,$0A,$40,$11,$80,$00,$00,$00,$00,

  8, // $26 '&'
  $00,$00,$00,$70,$D8,$D8,$76,$DC,$CC,$76,$00,$00,

  3, // $27 '''
  $00,$00,$C0,$C0,$C0,$00,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $00,$00,$30,$60,$C0,$C0,$C0,$C0,$C0,$C0,$60,$30,

  5, // $29 ')'
  $00,$00,$C0,$60,$30,$30,$30,$30,$30,$30,$60,$C0,

  6, // $2A '*'
  $00,$00,$20,$A8,$70,$A8,$20,$00,$00,$00,$00,$00,

  8, // $2B '+'
  $00,$00,$00,$00,$10,$10,$7C,$10,$10,$00,$00,$00,

  3, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$C0,$C0,$80,$00,

  4, // $2D '-'
  $00,$00,$00,$00,$00,$00,$E0,$00,$00,$00,$00,$00,

  3, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$C0,$C0,$00,$00,

  6, // $2F '/'
  $00,$00,$08,$08,$10,$10,$20,$40,$40,$80,$80,$00,

  6, // $30 '0'
  $00,$00,$00,$70,$D8,$D8,$D8,$D8,$D8,$70,$00,$00,

  6, // $31 '1'
  $00,$00,$00,$30,$70,$30,$30,$30,$30,$78,$00,$00,

  6, // $32 '2'
  $00,$00,$00,$70,$98,$18,$30,$60,$C0,$F8,$00,$00,

  6, // $33 '3'
  $00,$00,$00,$70,$98,$18,$70,$18,$98,$70,$00,$00,

  6, // $34 '4'
  $00,$00,$00,$18,$38,$58,$98,$FC,$18,$18,$00,$00,

  6, // $35 '5'
  $00,$00,$00,$F8,$C0,$F0,$18,$18,$98,$70,$00,$00,

  6, // $36 '6'
  $00,$00,$00,$70,$C0,$F0,$D8,$D8,$D8,$70,$00,$00,

  6, // $37 '7'
  $00,$00,$00,$F8,$18,$30,$30,$60,$60,$C0,$00,$00,

  6, // $38 '8'
  $00,$00,$00,$70,$D8,$D8,$70,$D8,$D8,$70,$00,$00,

  6, // $39 '9'
  $00,$00,$00,$70,$D8,$D8,$D8,$78,$18,$70,$00,$00,

  4, // $3A ':'
  $00,$00,$00,$00,$00,$60,$60,$00,$60,$60,$00,$00,

  4, // $3B ';'
  $00,$00,$00,$00,$00,$60,$60,$00,$60,$60,$40,$00,

  8, // $3C '<'
  $00,$00,$00,$00,$04,$18,$60,$60,$18,$04,$00,$00,

  8, // $3D '='
  $00,$00,$00,$00,$00,$7C,$00,$7C,$00,$00,$00,$00,

  8, // $3E '>'
  $00,$00,$00,$00,$40,$30,$0C,$0C,$30,$40,$00,$00,

  6, // $3F '?'
  $00,$00,$00,$F0,$18,$18,$30,$60,$00,$60,$00,$00,

  9, // $40 '@'
  $00,$00,$00,$00,$00,$00,$3C,$00,$42,$00,$9D,$00,$A5,$00,$A5,$00,$9E,$00,$40,$00,$3C,$00,$00,$00,

  8, // $41 'A'
  $00,$00,$00,$38,$38,$6C,$6C,$7C,$C6,$C6,$00,$00,

  7, // $42 'B'
  $00,$00,$00,$F8,$CC,$CC,$F8,$CC,$CC,$F8,$00,$00,

  6, // $43 'C'
  $00,$00,$00,$70,$C8,$C0,$C0,$C0,$C8,$70,$00,$00,

  7, // $44 'D'
  $00,$00,$00,$F8,$CC,$CC,$CC,$CC,$CC,$F8,$00,$00,

  6, // $45 'E'
  $00,$00,$00,$F8,$C0,$C0,$F8,$C0,$C0,$F8,$00,$00,

  6, // $46 'F'
  $00,$00,$00,$F8,$C0,$C0,$F8,$C0,$C0,$C0,$00,$00,

  7, // $47 'G'
  $00,$00,$00,$78,$C4,$C0,$C0,$DC,$CC,$7C,$00,$00,

  7, // $48 'H'
  $00,$00,$00,$CC,$CC,$CC,$FC,$CC,$CC,$CC,$00,$00,

  5, // $49 'I'
  $00,$00,$00,$F0,$60,$60,$60,$60,$60,$F0,$00,$00,

  5, // $4A 'J'
  $00,$00,$00,$70,$30,$30,$30,$30,$30,$E0,$00,$00,

  7, // $4B 'K'
  $00,$00,$00,$CC,$D8,$F0,$E0,$F0,$D8,$CC,$00,$00,

  6, // $4C 'L'
  $00,$00,$00,$C0,$C0,$C0,$C0,$C0,$C0,$F8,$00,$00,

  8, // $4D 'M'
  $00,$00,$00,$82,$C6,$EE,$B6,$B6,$86,$86,$00,$00,

  7, // $4E 'N'
  $00,$00,$00,$84,$C4,$E4,$B4,$9C,$8C,$84,$00,$00,

  8, // $4F 'O'
  $00,$00,$00,$7C,$C6,$C6,$C6,$C6,$C6,$7C,$00,$00,

  7, // $50 'P'
  $00,$00,$00,$F8,$CC,$CC,$CC,$F8,$C0,$C0,$00,$00,

  8, // $51 'Q'
  $00,$00,$00,$7C,$C6,$C6,$C6,$C6,$C6,$7C,$18,$0E,

  7, // $52 'R'
  $00,$00,$00,$F8,$CC,$CC,$F8,$D8,$CC,$C6,$00,$00,

  6, // $53 'S'
  $00,$00,$00,$70,$C8,$C0,$70,$18,$98,$70,$00,$00,

  6, // $54 'T'
  $00,$00,$00,$FC,$30,$30,$30,$30,$30,$30,$00,$00,

  7, // $55 'U'
  $00,$00,$00,$CC,$CC,$CC,$CC,$CC,$CC,$78,$00,$00,

  7, // $56 'V'
  $00,$00,$00,$CC,$CC,$78,$78,$78,$30,$30,$00,$00,

  11, // $57 'W'
  $00,$00,$00,$00,$00,$00,$CC,$C0,$CC,$C0,$6D,$80,$6D,$80,$73,$80,$33,$00,$33,$00,$00,$00,$00,$00,

  7, // $58 'X'
  $00,$00,$00,$CC,$CC,$78,$30,$78,$CC,$CC,$00,$00,

  7, // $59 'Y'
  $00,$00,$00,$CC,$CC,$78,$30,$30,$30,$30,$00,$00,

  6, // $5A 'Z'
  $00,$00,$00,$F8,$18,$30,$60,$C0,$C0,$F8,$00,$00,

  5, // $5B '['
  $00,$00,$70,$60,$60,$60,$60,$60,$60,$60,$60,$70,

  6, // $5C '\'
  $00,$00,$80,$80,$40,$40,$20,$10,$10,$08,$08,$00,

  5, // $5D ']'
  $00,$00,$70,$30,$30,$30,$30,$30,$30,$30,$30,$70,

  8, // $5E '^'
  $00,$00,$00,$18,$3C,$66,$00,$00,$00,$00,$00,$00,

  6, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FC,

  6, // $60 '`'
  $00,$00,$30,$18,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $61 'a'
  $00,$00,$00,$00,$00,$70,$18,$78,$D8,$78,$00,$00,

  6, // $62 'b'
  $00,$00,$C0,$C0,$C0,$F0,$D8,$D8,$D8,$F0,$00,$00,

  5, // $63 'c'
  $00,$00,$00,$00,$00,$70,$C0,$C0,$C0,$70,$00,$00,

  6, // $64 'd'
  $00,$00,$18,$18,$18,$78,$D8,$D8,$D8,$78,$00,$00,

  6, // $65 'e'
  $00,$00,$00,$00,$00,$70,$D8,$F8,$C0,$78,$00,$00,

  5, // $66 'f'
  $00,$00,$38,$60,$60,$F8,$60,$60,$60,$60,$00,$00,

  6, // $67 'g'
  $00,$00,$00,$00,$00,$78,$D8,$D8,$D8,$78,$18,$70,

  6, // $68 'h'
  $00,$00,$C0,$C0,$C0,$F0,$D8,$D8,$D8,$D8,$00,$00,

  3, // $69 'i'
  $00,$00,$00,$C0,$00,$C0,$C0,$C0,$C0,$C0,$00,$00,

  4, // $6A 'j'
  $00,$00,$00,$60,$00,$E0,$60,$60,$60,$60,$60,$C0,

  6, // $6B 'k'
  $00,$00,$C0,$C0,$C0,$D8,$D8,$F0,$D8,$D8,$00,$00,

  3, // $6C 'l'
  $00,$00,$C0,$C0,$C0,$C0,$C0,$C0,$C0,$C0,$00,$00,

  9, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$F6,$00,$DB,$00,$DB,$00,$DB,$00,$DB,$00,$00,$00,$00,$00,

  6, // $6E 'n'
  $00,$00,$00,$00,$00,$F0,$D8,$D8,$D8,$D8,$00,$00,

  6, // $6F 'o'
  $00,$00,$00,$00,$00,$70,$D8,$D8,$D8,$70,$00,$00,

  6, // $70 'p'
  $00,$00,$00,$00,$00,$F0,$D8,$D8,$D8,$F0,$C0,$C0,

  6, // $71 'q'
  $00,$00,$00,$00,$00,$78,$D8,$D8,$D8,$78,$18,$18,

  4, // $72 'r'
  $00,$00,$00,$00,$00,$D0,$E0,$C0,$C0,$C0,$00,$00,

  5, // $73 's'
  $00,$00,$00,$00,$00,$70,$C0,$F0,$30,$E0,$00,$00,

  5, // $74 't'
  $00,$00,$00,$60,$60,$F8,$60,$60,$60,$38,$00,$00,

  6, // $75 'u'
  $00,$00,$00,$00,$00,$D8,$D8,$D8,$D8,$78,$00,$00,

  6, // $76 'v'
  $00,$00,$00,$00,$00,$D8,$D8,$D8,$70,$70,$00,$00,

  9, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$DB,$00,$DB,$00,$DB,$00,$66,$00,$66,$00,$00,$00,$00,$00,

  6, // $78 'x'
  $00,$00,$00,$00,$00,$D8,$D8,$70,$D8,$D8,$00,$00,

  6, // $79 'y'
  $00,$00,$00,$00,$00,$D8,$D8,$D8,$70,$70,$30,$60,

  5, // $7A 'z'
  $00,$00,$00,$00,$00,$F0,$30,$60,$C0,$F0,$00,$00,

  6, // $7B '{'
  $00,$00,$18,$30,$30,$30,$E0,$30,$30,$30,$30,$18,

  5, // $7C '|'
  $00,$00,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,

  6, // $7D '}'
  $00,$00,$C0,$60,$60,$60,$38,$60,$60,$60,$60,$C0,

  8, // $7E '~'
  $00,$00,$00,$00,$00,$00,$62,$92,$8C,$00,$00,$00,

  9, // $7F ''
  $00,$00,$00,$00,$00,$00,$7F,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$7F,$00,$00,$00,$00,$00,

  0 );

 verdana13 : array[0..1787 ] of int8u = (
  13, 3, 32, 128-32,
  $00,$00,$0E,$00,$1C,$00,$2A,$00,$45,$00,$53,$00,$6E,$00,$7C,$00,$8A,$00,
  $98,$00,$A6,$00,$B4,$00,$CF,$00,$DD,$00,$EB,$00,$F9,$00,$07,$01,$15,$01,
  $23,$01,$31,$01,$3F,$01,$4D,$01,$5B,$01,$69,$01,$77,$01,$85,$01,$93,$01,
  $A1,$01,$AF,$01,$CA,$01,$E5,$01,$00,$02,$0E,$02,$29,$02,$37,$02,$45,$02,
  $60,$02,$7B,$02,$89,$02,$97,$02,$B2,$02,$C0,$02,$CE,$02,$DC,$02,$EA,$02,
  $F8,$02,$13,$03,$21,$03,$3C,$03,$4A,$03,$65,$03,$73,$03,$81,$03,$8F,$03,
  $9D,$03,$AB,$03,$C6,$03,$D4,$03,$E2,$03,$F0,$03,$FE,$03,$0C,$04,$1A,$04,
  $35,$04,$43,$04,$51,$04,$5F,$04,$6D,$04,$7B,$04,$89,$04,$97,$04,$A5,$04,
  $B3,$04,$C1,$04,$CF,$04,$DD,$04,$EB,$04,$F9,$04,$14,$05,$22,$05,$30,$05,
  $3E,$05,$4C,$05,$5A,$05,$68,$05,$76,$05,$84,$05,$92,$05,$AD,$05,$BB,$05,
  $C9,$05,$D7,$05,$E5,$05,$F3,$05,$01,$06,$1C,$06,

  4, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $00,$00,$00,$20,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  5, // $22 '"'
  $00,$00,$50,$50,$50,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $23 '#'
  $00,$00,$00,$00,$00,$00,$0A,$00,$0A,$00,$3F,$00,$14,$00,$14,$00,$7E,$00,$28,$00,$28,$00,$00,$00,$00,$00,

  7, // $24 '$'
  $00,$00,$10,$10,$3C,$50,$50,$38,$14,$14,$78,$10,$10,

  12, // $25 '%'
  $00,$00,$00,$00,$00,$00,$31,$00,$49,$00,$4A,$00,$32,$00,$04,$C0,$05,$20,$09,$20,$08,$C0,$00,$00,$00,$00,

  8, // $26 '&'
  $00,$00,$00,$30,$48,$48,$32,$4A,$44,$46,$39,$00,$00,

  3, // $27 '''
  $00,$00,$40,$40,$40,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $00,$00,$10,$20,$20,$40,$40,$40,$40,$40,$20,$20,$10,

  5, // $29 ')'
  $00,$00,$40,$20,$20,$10,$10,$10,$10,$10,$20,$20,$40,

  7, // $2A '*'
  $00,$00,$10,$54,$38,$54,$10,$00,$00,$00,$00,$00,$00,

  9, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$08,$00,$7F,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$40,

  5, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$70,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$00,$00,

  5, // $2F '/'
  $00,$00,$08,$08,$10,$10,$20,$20,$40,$40,$80,$80,$00,

  7, // $30 '0'
  $00,$00,$00,$38,$44,$44,$44,$44,$44,$44,$38,$00,$00,

  7, // $31 '1'
  $00,$00,$00,$10,$70,$10,$10,$10,$10,$10,$7C,$00,$00,

  7, // $32 '2'
  $00,$00,$00,$38,$44,$04,$08,$10,$20,$40,$7C,$00,$00,

  7, // $33 '3'
  $00,$00,$00,$38,$44,$04,$18,$04,$04,$44,$38,$00,$00,

  7, // $34 '4'
  $00,$00,$00,$08,$18,$28,$48,$88,$FC,$08,$08,$00,$00,

  7, // $35 '5'
  $00,$00,$00,$7C,$40,$40,$78,$04,$04,$44,$38,$00,$00,

  7, // $36 '6'
  $00,$00,$00,$18,$20,$40,$78,$44,$44,$44,$38,$00,$00,

  7, // $37 '7'
  $00,$00,$00,$7C,$04,$08,$08,$10,$10,$20,$20,$00,$00,

  7, // $38 '8'
  $00,$00,$00,$38,$44,$44,$38,$44,$44,$44,$38,$00,$00,

  7, // $39 '9'
  $00,$00,$00,$38,$44,$44,$44,$3C,$04,$08,$30,$00,$00,

  5, // $3A ':'
  $00,$00,$00,$00,$00,$20,$20,$00,$00,$20,$20,$00,$00,

  5, // $3B ';'
  $00,$00,$00,$00,$00,$20,$20,$00,$00,$20,$20,$20,$40,

  9, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$06,$00,$18,$00,$60,$00,$18,$00,$06,$00,$00,$00,$00,$00,$00,$00,

  9, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$00,$0C,$00,$03,$00,$0C,$00,$30,$00,$00,$00,$00,$00,$00,$00,

  6, // $3F '?'
  $00,$00,$00,$70,$08,$08,$10,$20,$20,$00,$20,$00,$00,

  10, // $40 '@'
  $00,$00,$00,$00,$00,$00,$1F,$00,$20,$80,$4E,$80,$52,$80,$52,$80,$52,$80,$4D,$00,$20,$00,$1E,$00,$00,$00,

  8, // $41 'A'
  $00,$00,$00,$18,$18,$24,$24,$24,$7E,$42,$42,$00,$00,

  8, // $42 'B'
  $00,$00,$00,$78,$44,$44,$7C,$42,$42,$42,$7C,$00,$00,

  9, // $43 'C'
  $00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$00,$40,$00,$40,$00,$40,$00,$21,$00,$1E,$00,$00,$00,$00,$00,

  9, // $44 'D'
  $00,$00,$00,$00,$00,$00,$7C,$00,$42,$00,$41,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$00,$00,$00,$00,

  7, // $45 'E'
  $00,$00,$00,$7C,$40,$40,$7C,$40,$40,$40,$7C,$00,$00,

  6, // $46 'F'
  $00,$00,$00,$7C,$40,$40,$78,$40,$40,$40,$40,$00,$00,

  9, // $47 'G'
  $00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$00,$40,$00,$47,$00,$41,$00,$21,$00,$1E,$00,$00,$00,$00,$00,

  8, // $48 'H'
  $00,$00,$00,$42,$42,$42,$7E,$42,$42,$42,$42,$00,$00,

  5, // $49 'I'
  $00,$00,$00,$70,$20,$20,$20,$20,$20,$20,$70,$00,$00,

  5, // $4A 'J'
  $00,$00,$00,$70,$10,$10,$10,$10,$10,$10,$E0,$00,$00,

  8, // $4B 'K'
  $00,$00,$00,$42,$44,$48,$50,$70,$48,$44,$42,$00,$00,

  6, // $4C 'L'
  $00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$7C,$00,$00,

  9, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$55,$00,$55,$00,$49,$00,$49,$00,$41,$00,$41,$00,$00,$00,$00,$00,

  8, // $4E 'N'
  $00,$00,$00,$62,$62,$52,$52,$4A,$4A,$46,$46,$00,$00,

  9, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$00,$00,$00,$00,

  7, // $50 'P'
  $00,$00,$00,$78,$44,$44,$44,$78,$40,$40,$40,$00,$00,

  9, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$04,$00,$03,$00,

  8, // $52 'R'
  $00,$00,$00,$78,$44,$44,$44,$78,$48,$44,$42,$00,$00,

  8, // $53 'S'
  $00,$00,$00,$3C,$42,$40,$30,$0C,$02,$42,$3C,$00,$00,

  7, // $54 'T'
  $00,$00,$00,$FE,$10,$10,$10,$10,$10,$10,$10,$00,$00,

  8, // $55 'U'
  $00,$00,$00,$42,$42,$42,$42,$42,$42,$42,$3C,$00,$00,

  8, // $56 'V'
  $00,$00,$00,$42,$42,$42,$24,$24,$24,$18,$18,$00,$00,

  11, // $57 'W'
  $00,$00,$00,$00,$00,$00,$44,$40,$44,$40,$2A,$80,$2A,$80,$2A,$80,$2A,$80,$11,$00,$11,$00,$00,$00,$00,$00,

  8, // $58 'X'
  $00,$00,$00,$42,$42,$24,$18,$18,$24,$42,$42,$00,$00,

  7, // $59 'Y'
  $00,$00,$00,$82,$44,$28,$10,$10,$10,$10,$10,$00,$00,

  8, // $5A 'Z'
  $00,$00,$00,$7E,$02,$04,$08,$10,$20,$40,$7E,$00,$00,

  5, // $5B '['
  $00,$00,$70,$40,$40,$40,$40,$40,$40,$40,$40,$40,$70,

  5, // $5C '\'
  $00,$00,$80,$80,$40,$40,$20,$20,$10,$10,$08,$08,$00,

  5, // $5D ']'
  $00,$00,$70,$10,$10,$10,$10,$10,$10,$10,$10,$10,$70,

  9, // $5E '^'
  $00,$00,$00,$00,$00,$00,$08,$00,$14,$00,$22,$00,$41,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FE,

  7, // $60 '`'
  $00,$00,$20,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $61 'a'
  $00,$00,$00,$00,$00,$38,$04,$3C,$44,$44,$3C,$00,$00,

  7, // $62 'b'
  $00,$00,$40,$40,$40,$78,$44,$44,$44,$44,$78,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$00,$00,$38,$44,$40,$40,$44,$38,$00,$00,

  7, // $64 'd'
  $00,$00,$04,$04,$04,$3C,$44,$44,$44,$44,$3C,$00,$00,

  7, // $65 'e'
  $00,$00,$00,$00,$00,$38,$44,$7C,$40,$44,$38,$00,$00,

  4, // $66 'f'
  $00,$00,$30,$40,$40,$F0,$40,$40,$40,$40,$40,$00,$00,

  7, // $67 'g'
  $00,$00,$00,$00,$00,$3C,$44,$44,$44,$44,$3C,$04,$38,

  7, // $68 'h'
  $00,$00,$40,$40,$40,$78,$44,$44,$44,$44,$44,$00,$00,

  3, // $69 'i'
  $00,$00,$40,$00,$00,$40,$40,$40,$40,$40,$40,$00,$00,

  4, // $6A 'j'
  $00,$00,$20,$00,$00,$60,$20,$20,$20,$20,$20,$20,$C0,

  7, // $6B 'k'
  $00,$00,$40,$40,$40,$44,$48,$50,$70,$48,$44,$00,$00,

  3, // $6C 'l'
  $00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,

  11, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7B,$80,$44,$40,$44,$40,$44,$40,$44,$40,$44,$40,$00,$00,$00,$00,

  7, // $6E 'n'
  $00,$00,$00,$00,$00,$78,$44,$44,$44,$44,$44,$00,$00,

  7, // $6F 'o'
  $00,$00,$00,$00,$00,$38,$44,$44,$44,$44,$38,$00,$00,

  7, // $70 'p'
  $00,$00,$00,$00,$00,$78,$44,$44,$44,$44,$78,$40,$40,

  7, // $71 'q'
  $00,$00,$00,$00,$00,$3C,$44,$44,$44,$44,$3C,$04,$04,

  5, // $72 'r'
  $00,$00,$00,$00,$00,$58,$60,$40,$40,$40,$40,$00,$00,

  6, // $73 's'
  $00,$00,$00,$00,$00,$38,$40,$60,$18,$08,$70,$00,$00,

  4, // $74 't'
  $00,$00,$00,$40,$40,$F0,$40,$40,$40,$40,$30,$00,$00,

  7, // $75 'u'
  $00,$00,$00,$00,$00,$44,$44,$44,$44,$44,$3C,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$00,$00,$44,$44,$28,$28,$10,$10,$00,$00,

  9, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$49,$00,$49,$00,$55,$00,$55,$00,$22,$00,$22,$00,$00,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$00,$00,$44,$28,$10,$10,$28,$44,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$00,$00,$44,$28,$28,$28,$10,$10,$10,$20,

  6, // $7A 'z'
  $00,$00,$00,$00,$00,$78,$08,$10,$20,$40,$78,$00,$00,

  7, // $7B '{'
  $00,$00,$0C,$10,$10,$10,$10,$60,$10,$10,$10,$10,$0C,

  5, // $7C '|'
  $00,$00,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,

  7, // $7D '}'
  $00,$00,$60,$10,$10,$10,$10,$0C,$10,$10,$10,$10,$60,

  9, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$31,$00,$49,$00,$46,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $7F ''
  $00,$00,$00,$00,$00,$00,$7F,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$7F,$80,$00,$00,$00,$00,

  0 );

 verdana13_bold : array[0..1839 ] of int8u = (
  13, 3, 32, 128-32,
  $00,$00,$0E,$00,$1C,$00,$2A,$00,$45,$00,$53,$00,$6E,$00,$89,$00,$97,$00,
  $A5,$00,$B3,$00,$C1,$00,$DC,$00,$EA,$00,$F8,$00,$06,$01,$14,$01,$22,$01,
  $30,$01,$3E,$01,$4C,$01,$5A,$01,$68,$01,$76,$01,$84,$01,$92,$01,$A0,$01,
  $AE,$01,$BC,$01,$D7,$01,$F2,$01,$0D,$02,$1B,$02,$36,$02,$51,$02,$5F,$02,
  $6D,$02,$88,$02,$96,$02,$A4,$02,$BF,$02,$DA,$02,$E8,$02,$F6,$02,$04,$03,
  $12,$03,$2D,$03,$48,$03,$63,$03,$71,$03,$8C,$03,$9A,$03,$A8,$03,$B6,$03,
  $D1,$03,$DF,$03,$FA,$03,$08,$04,$16,$04,$24,$04,$32,$04,$40,$04,$4E,$04,
  $69,$04,$77,$04,$85,$04,$93,$04,$A1,$04,$AF,$04,$BD,$04,$CB,$04,$D9,$04,
  $E7,$04,$F5,$04,$03,$05,$11,$05,$1F,$05,$2D,$05,$48,$05,$56,$05,$64,$05,
  $72,$05,$80,$05,$8E,$05,$9C,$05,$AA,$05,$B8,$05,$C6,$05,$E1,$05,$EF,$05,
  $FD,$05,$0B,$06,$19,$06,$27,$06,$35,$06,$50,$06,

  4, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  4, // $21 '!'
  $00,$00,$00,$60,$60,$60,$60,$60,$60,$00,$60,$00,$00,

  7, // $22 '"'
  $00,$00,$6C,$6C,$6C,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $23 '#'
  $00,$00,$00,$00,$00,$00,$0A,$00,$0A,$00,$3F,$00,$14,$00,$14,$00,$7E,$00,$28,$00,$28,$00,$00,$00,$00,$00,

  8, // $24 '$'
  $00,$00,$08,$08,$3C,$6A,$68,$3C,$16,$56,$3C,$10,$10,

  14, // $25 '%'
  $00,$00,$00,$00,$00,$00,$38,$80,$6C,$80,$6D,$00,$6D,$70,$3A,$D8,$02,$D8,$04,$D8,$04,$70,$00,$00,$00,$00,

  10, // $26 '&'
  $00,$00,$00,$00,$00,$00,$38,$00,$6C,$00,$6C,$00,$39,$80,$6D,$00,$66,$00,$63,$00,$3D,$80,$00,$00,$00,$00,

  4, // $27 '''
  $00,$00,$60,$60,$60,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $28 '('
  $00,$00,$18,$30,$30,$60,$60,$60,$60,$60,$30,$30,$18,

  6, // $29 ')'
  $00,$00,$60,$30,$30,$18,$18,$18,$18,$18,$30,$30,$60,

  8, // $2A '*'
  $00,$00,$10,$54,$38,$54,$10,$00,$00,$00,$00,$00,$00,

  9, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$08,$00,$7F,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$60,$40,

  6, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$78,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$00,$00,

  8, // $2F '/'
  $00,$00,$06,$06,$0C,$0C,$18,$18,$18,$30,$30,$60,$60,

  8, // $30 '0'
  $00,$00,$00,$3C,$66,$66,$66,$66,$66,$66,$3C,$00,$00,

  8, // $31 '1'
  $00,$00,$00,$18,$38,$18,$18,$18,$18,$18,$3C,$00,$00,

  8, // $32 '2'
  $00,$00,$00,$3C,$66,$06,$0C,$18,$30,$60,$7E,$00,$00,

  8, // $33 '3'
  $00,$00,$00,$3C,$66,$06,$1C,$06,$06,$66,$3C,$00,$00,

  8, // $34 '4'
  $00,$00,$00,$04,$0C,$1C,$2C,$4C,$7E,$0C,$0C,$00,$00,

  8, // $35 '5'
  $00,$00,$00,$3E,$30,$30,$3C,$06,$06,$66,$3C,$00,$00,

  8, // $36 '6'
  $00,$00,$00,$1C,$30,$60,$7C,$66,$66,$66,$3C,$00,$00,

  8, // $37 '7'
  $00,$00,$00,$7E,$06,$0C,$0C,$18,$18,$30,$30,$00,$00,

  8, // $38 '8'
  $00,$00,$00,$3C,$66,$66,$3C,$66,$66,$66,$3C,$00,$00,

  8, // $39 '9'
  $00,$00,$00,$3C,$66,$66,$66,$3E,$06,$0C,$38,$00,$00,

  4, // $3A ':'
  $00,$00,$00,$00,$00,$60,$60,$00,$00,$60,$60,$00,$00,

  4, // $3B ';'
  $00,$00,$00,$00,$00,$60,$60,$00,$00,$60,$60,$60,$40,

  9, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$03,$00,$0C,$00,$30,$00,$40,$00,$30,$00,$0C,$00,$03,$00,$00,$00,$00,$00,

  9, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$00,$18,$00,$06,$00,$01,$00,$06,$00,$18,$00,$60,$00,$00,$00,$00,$00,

  7, // $3F '?'
  $00,$00,$00,$38,$4C,$0C,$18,$30,$30,$00,$30,$00,$00,

  11, // $40 '@'
  $00,$00,$00,$00,$00,$00,$1F,$80,$20,$40,$4F,$40,$5B,$40,$5B,$40,$5B,$40,$4F,$80,$20,$00,$1F,$00,$00,$00,

  9, // $41 'A'
  $00,$00,$00,$00,$00,$00,$1C,$00,$1C,$00,$36,$00,$36,$00,$36,$00,$7F,$00,$63,$00,$63,$00,$00,$00,$00,$00,

  8, // $42 'B'
  $00,$00,$00,$7C,$66,$66,$7C,$66,$66,$66,$7C,$00,$00,

  8, // $43 'C'
  $00,$00,$00,$3C,$62,$60,$60,$60,$60,$62,$3C,$00,$00,

  9, // $44 'D'
  $00,$00,$00,$00,$00,$00,$7C,$00,$66,$00,$63,$00,$63,$00,$63,$00,$63,$00,$66,$00,$7C,$00,$00,$00,$00,$00,

  8, // $45 'E'
  $00,$00,$00,$7E,$60,$60,$7E,$60,$60,$60,$7E,$00,$00,

  8, // $46 'F'
  $00,$00,$00,$7E,$60,$60,$7E,$60,$60,$60,$60,$00,$00,

  9, // $47 'G'
  $00,$00,$00,$00,$00,$00,$3E,$00,$61,$00,$60,$00,$60,$00,$67,$00,$63,$00,$63,$00,$3F,$00,$00,$00,$00,$00,

  9, // $48 'H'
  $00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$7F,$00,$63,$00,$63,$00,$63,$00,$63,$00,$00,$00,$00,$00,

  6, // $49 'I'
  $00,$00,$00,$78,$30,$30,$30,$30,$30,$30,$78,$00,$00,

  6, // $4A 'J'
  $00,$00,$00,$78,$18,$18,$18,$18,$18,$18,$F0,$00,$00,

  8, // $4B 'K'
  $00,$00,$00,$66,$6C,$78,$70,$70,$78,$6C,$66,$00,$00,

  7, // $4C 'L'
  $00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$7E,$00,$00,

  10, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$60,$80,$71,$80,$7B,$80,$5D,$80,$49,$80,$41,$80,$41,$80,$41,$80,$00,$00,$00,$00,

  9, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$41,$00,$61,$00,$71,$00,$59,$00,$4D,$00,$47,$00,$43,$00,$41,$00,$00,$00,$00,$00,

  9, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,

  8, // $50 'P'
  $00,$00,$00,$7C,$66,$66,$66,$7C,$60,$60,$60,$00,$00,

  9, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$0C,$00,$07,$00,

  8, // $52 'R'
  $00,$00,$00,$7C,$66,$66,$66,$7C,$6C,$66,$63,$00,$00,

  8, // $53 'S'
  $00,$00,$00,$3C,$62,$60,$7C,$3E,$06,$46,$3C,$00,$00,

  8, // $54 'T'
  $00,$00,$00,$FF,$18,$18,$18,$18,$18,$18,$18,$00,$00,

  9, // $55 'U'
  $00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,

  8, // $56 'V'
  $00,$00,$00,$66,$66,$66,$3C,$3C,$3C,$18,$18,$00,$00,

  12, // $57 'W'
  $00,$00,$00,$00,$00,$00,$66,$60,$66,$60,$66,$60,$36,$C0,$3F,$C0,$39,$C0,$19,$80,$19,$80,$00,$00,$00,$00,

  8, // $58 'X'
  $00,$00,$00,$66,$66,$3C,$18,$18,$3C,$66,$66,$00,$00,

  8, // $59 'Y'
  $00,$00,$00,$66,$66,$3C,$3C,$18,$18,$18,$18,$00,$00,

  8, // $5A 'Z'
  $00,$00,$00,$7E,$06,$0E,$1C,$38,$70,$60,$7E,$00,$00,

  6, // $5B '['
  $00,$00,$78,$60,$60,$60,$60,$60,$60,$60,$60,$60,$78,

  8, // $5C '\'
  $00,$00,$60,$60,$30,$30,$18,$18,$18,$0C,$0C,$06,$06,

  6, // $5D ']'
  $00,$00,$78,$18,$18,$18,$18,$18,$18,$18,$18,$18,$78,

  10, // $5E '^'
  $00,$00,$00,$00,$00,$00,$0C,$00,$1E,$00,$33,$00,$61,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,

  8, // $60 '`'
  $00,$00,$30,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $61 'a'
  $00,$00,$00,$00,$00,$3C,$06,$3E,$66,$66,$3E,$00,$00,

  8, // $62 'b'
  $00,$00,$60,$60,$60,$7C,$66,$66,$66,$66,$7C,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$00,$00,$3C,$60,$60,$60,$60,$3C,$00,$00,

  8, // $64 'd'
  $00,$00,$06,$06,$06,$3E,$66,$66,$66,$66,$3E,$00,$00,

  8, // $65 'e'
  $00,$00,$00,$00,$00,$3C,$66,$7E,$60,$62,$3C,$00,$00,

  5, // $66 'f'
  $00,$00,$38,$60,$60,$F8,$60,$60,$60,$60,$60,$00,$00,

  8, // $67 'g'
  $00,$00,$00,$00,$00,$3E,$66,$66,$66,$66,$3E,$06,$3C,

  8, // $68 'h'
  $00,$00,$60,$60,$60,$7C,$66,$66,$66,$66,$66,$00,$00,

  4, // $69 'i'
  $00,$00,$00,$60,$00,$60,$60,$60,$60,$60,$60,$00,$00,

  5, // $6A 'j'
  $00,$00,$00,$30,$00,$70,$30,$30,$30,$30,$30,$30,$E0,

  8, // $6B 'k'
  $00,$00,$60,$60,$60,$66,$6C,$78,$78,$6C,$66,$00,$00,

  4, // $6C 'l'
  $00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,

  12, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7D,$C0,$66,$60,$66,$60,$66,$60,$66,$60,$66,$60,$00,$00,$00,$00,

  8, // $6E 'n'
  $00,$00,$00,$00,$00,$7C,$66,$66,$66,$66,$66,$00,$00,

  8, // $6F 'o'
  $00,$00,$00,$00,$00,$3C,$66,$66,$66,$66,$3C,$00,$00,

  8, // $70 'p'
  $00,$00,$00,$00,$00,$7C,$66,$66,$66,$66,$7C,$60,$60,

  8, // $71 'q'
  $00,$00,$00,$00,$00,$3E,$66,$66,$66,$66,$3E,$06,$06,

  6, // $72 'r'
  $00,$00,$00,$00,$00,$6C,$7C,$60,$60,$60,$60,$00,$00,

  7, // $73 's'
  $00,$00,$00,$00,$00,$3C,$60,$78,$3C,$0C,$78,$00,$00,

  5, // $74 't'
  $00,$00,$00,$60,$60,$F8,$60,$60,$60,$60,$38,$00,$00,

  8, // $75 'u'
  $00,$00,$00,$00,$00,$66,$66,$66,$66,$66,$3E,$00,$00,

  8, // $76 'v'
  $00,$00,$00,$00,$00,$66,$66,$66,$3C,$3C,$18,$00,$00,

  10, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6D,$80,$6D,$80,$6D,$80,$6D,$80,$33,$00,$33,$00,$00,$00,$00,$00,

  8, // $78 'x'
  $00,$00,$00,$00,$00,$66,$66,$3C,$3C,$66,$66,$00,$00,

  8, // $79 'y'
  $00,$00,$00,$00,$00,$66,$66,$3C,$3C,$18,$18,$30,$30,

  7, // $7A 'z'
  $00,$00,$00,$00,$00,$7C,$0C,$18,$30,$60,$7C,$00,$00,

  8, // $7B '{'
  $00,$00,$0E,$18,$18,$18,$18,$70,$18,$18,$18,$18,$0E,

  6, // $7C '|'
  $00,$00,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,

  8, // $7D '}'
  $00,$00,$70,$18,$18,$18,$18,$0E,$18,$18,$18,$18,$70,

  9, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$31,$00,$49,$00,$49,$00,$46,$00,$00,$00,$00,$00,$00,$00,

  11, // $7F ''
  $00,$00,$00,$00,$00,$00,$7F,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$7F,$80,$00,$00,$00,$00,

  0 );

 verdana14 : array[0..1958 ] of int8u = (
  14, 3, 32, 128-32,
  $00,$00,$0F,$00,$1E,$00,$2D,$00,$4A,$00,$59,$00,$76,$00,$93,$00,$A2,$00,
  $B1,$00,$C0,$00,$CF,$00,$EC,$00,$FB,$00,$0A,$01,$19,$01,$28,$01,$37,$01,
  $46,$01,$55,$01,$64,$01,$73,$01,$82,$01,$91,$01,$A0,$01,$AF,$01,$BE,$01,
  $CD,$01,$DC,$01,$F9,$01,$16,$02,$33,$02,$42,$02,$5F,$02,$6E,$02,$7D,$02,
  $9A,$02,$B7,$02,$C6,$02,$D5,$02,$F2,$02,$0F,$03,$1E,$03,$2D,$03,$3C,$03,
  $4B,$03,$68,$03,$85,$03,$A2,$03,$B1,$03,$CE,$03,$DD,$03,$EC,$03,$FB,$03,
  $18,$04,$27,$04,$44,$04,$53,$04,$62,$04,$71,$04,$80,$04,$8F,$04,$9E,$04,
  $BB,$04,$CA,$04,$D9,$04,$E8,$04,$F7,$04,$06,$05,$15,$05,$24,$05,$33,$05,
  $42,$05,$51,$05,$60,$05,$6F,$05,$7E,$05,$8D,$05,$AA,$05,$B9,$05,$C8,$05,
  $D7,$05,$E6,$05,$F5,$05,$04,$06,$13,$06,$22,$06,$31,$06,$4E,$06,$5D,$06,
  $6C,$06,$7B,$06,$8A,$06,$99,$06,$A8,$06,$C5,$06,

  4, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$00,$00,$20,$20,$20,$20,$20,$20,$20,$00,$20,$00,$00,

  6, // $22 '"'
  $00,$00,$48,$48,$48,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $23 '#'
  $00,$00,$00,$00,$00,$00,$09,$00,$09,$00,$12,$00,$3F,$80,$12,$00,$12,$00,$7F,$00,$24,$00,$24,$00,$00,$00,$00,$00,

  8, // $24 '$'
  $00,$00,$10,$10,$3E,$50,$50,$30,$1C,$12,$12,$7C,$10,$10,

  13, // $25 '%'
  $00,$00,$00,$00,$00,$00,$30,$80,$49,$00,$49,$00,$4A,$00,$32,$60,$02,$90,$04,$90,$04,$90,$08,$60,$00,$00,$00,$00,

  10, // $26 '&'
  $00,$00,$00,$00,$00,$00,$38,$00,$44,$00,$44,$00,$44,$00,$39,$00,$45,$00,$42,$00,$43,$00,$3C,$80,$00,$00,$00,$00,

  3, // $27 '''
  $00,$00,$40,$40,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $28 '('
  $00,$00,$10,$20,$20,$40,$40,$40,$40,$40,$40,$20,$20,$10,

  5, // $29 ')'
  $00,$00,$40,$20,$20,$10,$10,$10,$10,$10,$10,$20,$20,$40,

  8, // $2A '*'
  $00,$00,$10,$54,$38,$54,$10,$00,$00,$00,$00,$00,$00,$00,

  9, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$08,$00,$7F,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$40,

  5, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$00,$78,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$00,$00,

  5, // $2F '/'
  $00,$00,$08,$08,$10,$10,$10,$20,$20,$20,$40,$40,$40,$80,

  8, // $30 '0'
  $00,$00,$00,$3C,$42,$42,$42,$42,$42,$42,$42,$3C,$00,$00,

  8, // $31 '1'
  $00,$00,$00,$08,$38,$08,$08,$08,$08,$08,$08,$3E,$00,$00,

  8, // $32 '2'
  $00,$00,$00,$3C,$42,$42,$02,$04,$18,$20,$40,$7E,$00,$00,

  8, // $33 '3'
  $00,$00,$00,$3C,$42,$02,$02,$1C,$02,$02,$42,$3C,$00,$00,

  8, // $34 '4'
  $00,$00,$00,$04,$0C,$14,$24,$44,$7F,$04,$04,$04,$00,$00,

  8, // $35 '5'
  $00,$00,$00,$7E,$40,$40,$7C,$02,$02,$02,$42,$3C,$00,$00,

  8, // $36 '6'
  $00,$00,$00,$1C,$20,$40,$7C,$42,$42,$42,$42,$3C,$00,$00,

  8, // $37 '7'
  $00,$00,$00,$7E,$02,$04,$04,$08,$08,$10,$10,$20,$00,$00,

  8, // $38 '8'
  $00,$00,$00,$3C,$42,$42,$42,$3C,$42,$42,$42,$3C,$00,$00,

  8, // $39 '9'
  $00,$00,$00,$3C,$42,$42,$42,$42,$3E,$02,$04,$38,$00,$00,

  5, // $3A ':'
  $00,$00,$00,$00,$00,$20,$20,$00,$00,$00,$20,$20,$00,$00,

  5, // $3B ';'
  $00,$00,$00,$00,$00,$20,$20,$00,$00,$00,$20,$20,$20,$40,

  9, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$03,$00,$0C,$00,$30,$00,$40,$00,$30,$00,$0C,$00,$03,$00,$00,$00,$00,$00,

  9, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$60,$00,$18,$00,$06,$00,$01,$00,$06,$00,$18,$00,$60,$00,$00,$00,$00,$00,

  7, // $3F '?'
  $00,$00,$00,$38,$44,$04,$04,$08,$10,$10,$00,$10,$00,$00,

  12, // $40 '@'
  $00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$27,$40,$49,$20,$49,$20,$49,$20,$49,$20,$27,$C0,$30,$00,$0F,$00,$00,$00,

  8, // $41 'A'
  $00,$00,$00,$18,$18,$24,$24,$42,$42,$7E,$81,$81,$00,$00,

  8, // $42 'B'
  $00,$00,$00,$78,$44,$44,$44,$7C,$42,$42,$42,$7C,$00,$00,

  9, // $43 'C'
  $00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$00,$40,$00,$40,$00,$40,$00,$40,$00,$21,$00,$1E,$00,$00,$00,$00,$00,

  9, // $44 'D'
  $00,$00,$00,$00,$00,$00,$7C,$00,$42,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$00,$00,$00,$00,

  8, // $45 'E'
  $00,$00,$00,$7E,$40,$40,$40,$7E,$40,$40,$40,$7E,$00,$00,

  7, // $46 'F'
  $00,$00,$00,$7E,$40,$40,$40,$7C,$40,$40,$40,$40,$00,$00,

  9, // $47 'G'
  $00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$00,$40,$00,$47,$00,$41,$00,$41,$00,$21,$00,$1E,$00,$00,$00,$00,$00,

  9, // $48 'H'
  $00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$7F,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,

  5, // $49 'I'
  $00,$00,$00,$70,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,

  5, // $4A 'J'
  $00,$00,$00,$70,$10,$10,$10,$10,$10,$10,$10,$E0,$00,$00,

  8, // $4B 'K'
  $00,$00,$00,$42,$44,$48,$50,$60,$50,$48,$44,$42,$00,$00,

  7, // $4C 'L'
  $00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$7E,$00,$00,

  10, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$52,$80,$52,$80,$52,$80,$4C,$80,$4C,$80,$40,$80,$40,$80,$00,$00,$00,$00,

  9, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$61,$00,$61,$00,$51,$00,$51,$00,$49,$00,$45,$00,$45,$00,$43,$00,$43,$00,$00,$00,$00,$00,

  10, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,

  8, // $50 'P'
  $00,$00,$00,$7C,$42,$42,$42,$42,$7C,$40,$40,$40,$00,$00,

  10, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$02,$00,$01,$80,

  8, // $52 'R'
  $00,$00,$00,$7C,$42,$42,$42,$7C,$48,$44,$42,$41,$00,$00,

  8, // $53 'S'
  $00,$00,$00,$3C,$42,$40,$40,$3C,$02,$02,$42,$3C,$00,$00,

  7, // $54 'T'
  $00,$00,$00,$FE,$10,$10,$10,$10,$10,$10,$10,$10,$00,$00,

  9, // $55 'U'
  $00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$00,$00,$00,$00,

  8, // $56 'V'
  $00,$00,$00,$81,$81,$42,$42,$42,$24,$24,$18,$18,$00,$00,

  13, // $57 'W'
  $00,$00,$00,$00,$00,$00,$42,$10,$42,$10,$45,$10,$45,$10,$25,$20,$28,$A0,$28,$A0,$10,$40,$10,$40,$00,$00,$00,$00,

  8, // $58 'X'
  $00,$00,$00,$42,$42,$24,$18,$18,$18,$24,$42,$42,$00,$00,

  7, // $59 'Y'
  $00,$00,$00,$82,$44,$44,$28,$10,$10,$10,$10,$10,$00,$00,

  8, // $5A 'Z'
  $00,$00,$00,$7E,$02,$04,$08,$10,$10,$20,$40,$7E,$00,$00,

  5, // $5B '['
  $00,$00,$70,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$70,

  5, // $5C '\'
  $00,$00,$80,$80,$40,$40,$40,$20,$20,$10,$10,$10,$08,$08,

  5, // $5D ']'
  $00,$00,$70,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$70,

  10, // $5E '^'
  $00,$00,$00,$00,$00,$00,$0C,$00,$12,$00,$21,$00,$40,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,

  8, // $60 '`'
  $00,$00,$20,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $61 'a'
  $00,$00,$00,$00,$00,$3C,$02,$02,$3E,$42,$42,$3E,$00,$00,

  8, // $62 'b'
  $00,$00,$40,$40,$40,$5C,$62,$42,$42,$42,$42,$7C,$00,$00,

  6, // $63 'c'
  $00,$00,$00,$00,$00,$38,$44,$40,$40,$40,$44,$38,$00,$00,

  8, // $64 'd'
  $00,$00,$02,$02,$02,$3E,$42,$42,$42,$42,$46,$3A,$00,$00,

  8, // $65 'e'
  $00,$00,$00,$00,$00,$3C,$42,$42,$7E,$40,$42,$3C,$00,$00,

  4, // $66 'f'
  $00,$00,$30,$40,$40,$F0,$40,$40,$40,$40,$40,$40,$00,$00,

  8, // $67 'g'
  $00,$00,$00,$00,$00,$3E,$42,$42,$42,$42,$46,$3A,$02,$3C,

  8, // $68 'h'
  $00,$00,$40,$40,$40,$5C,$62,$42,$42,$42,$42,$42,$00,$00,

  3, // $69 'i'
  $00,$00,$40,$00,$00,$40,$40,$40,$40,$40,$40,$40,$00,$00,

  4, // $6A 'j'
  $00,$00,$20,$00,$00,$60,$20,$20,$20,$20,$20,$20,$20,$C0,

  7, // $6B 'k'
  $00,$00,$40,$40,$40,$44,$48,$50,$60,$50,$48,$44,$00,$00,

  3, // $6C 'l'
  $00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,

  11, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7B,$80,$44,$40,$44,$40,$44,$40,$44,$40,$44,$40,$44,$40,$00,$00,$00,$00,

  8, // $6E 'n'
  $00,$00,$00,$00,$00,$5C,$62,$42,$42,$42,$42,$42,$00,$00,

  8, // $6F 'o'
  $00,$00,$00,$00,$00,$3C,$42,$42,$42,$42,$42,$3C,$00,$00,

  8, // $70 'p'
  $00,$00,$00,$00,$00,$5C,$62,$42,$42,$42,$42,$7C,$40,$40,

  8, // $71 'q'
  $00,$00,$00,$00,$00,$3E,$42,$42,$42,$42,$46,$3A,$02,$02,

  5, // $72 'r'
  $00,$00,$00,$00,$00,$58,$60,$40,$40,$40,$40,$40,$00,$00,

  7, // $73 's'
  $00,$00,$00,$00,$00,$3C,$40,$40,$38,$04,$04,$78,$00,$00,

  5, // $74 't'
  $00,$00,$00,$40,$40,$F8,$40,$40,$40,$40,$40,$38,$00,$00,

  8, // $75 'u'
  $00,$00,$00,$00,$00,$42,$42,$42,$42,$42,$46,$3A,$00,$00,

  7, // $76 'v'
  $00,$00,$00,$00,$00,$44,$44,$28,$28,$28,$10,$10,$00,$00,

  11, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$44,$40,$44,$40,$2A,$80,$2A,$80,$2A,$80,$11,$00,$11,$00,$00,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$00,$00,

  7, // $79 'y'
  $00,$00,$00,$00,$00,$44,$44,$28,$28,$28,$10,$10,$10,$20,

  7, // $7A 'z'
  $00,$00,$00,$00,$00,$7C,$04,$08,$10,$20,$40,$7C,$00,$00,

  8, // $7B '{'
  $00,$00,$0C,$10,$10,$10,$10,$60,$10,$10,$10,$10,$10,$0C,

  5, // $7C '|'
  $00,$00,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,

  8, // $7D '}'
  $00,$00,$30,$08,$08,$08,$08,$06,$08,$08,$08,$08,$08,$30,

  10, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$80,$4C,$80,$43,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $7F ''
  $00,$00,$00,$00,$00,$00,$3F,$E0,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$3F,$E0,$00,$00,$00,$00,

  0 );

 verdana14_bold : array[0..2308 ] of int8u = (
  14, 3, 32, 128-32,
  $00,$00,$0F,$00,$1E,$00,$2D,$00,$4A,$00,$67,$00,$84,$00,$A1,$00,$B0,$00,
  $BF,$00,$CE,$00,$EB,$00,$08,$01,$17,$01,$26,$01,$35,$01,$44,$01,$61,$01,
  $7E,$01,$9B,$01,$B8,$01,$D5,$01,$F2,$01,$0F,$02,$2C,$02,$49,$02,$66,$02,
  $75,$02,$84,$02,$A1,$02,$BE,$02,$DB,$02,$EA,$02,$07,$03,$24,$03,$41,$03,
  $5E,$03,$7B,$03,$8A,$03,$99,$03,$B6,$03,$D3,$03,$E2,$03,$F1,$03,$0E,$04,
  $1D,$04,$3A,$04,$57,$04,$74,$04,$91,$04,$AE,$04,$CB,$04,$E8,$04,$F7,$04,
  $14,$05,$31,$05,$4E,$05,$6B,$05,$88,$05,$97,$05,$A6,$05,$B5,$05,$C4,$05,
  $E1,$05,$FE,$05,$1B,$06,$2A,$06,$39,$06,$48,$06,$57,$06,$66,$06,$75,$06,
  $84,$06,$93,$06,$A2,$06,$B1,$06,$C0,$06,$CF,$06,$EC,$06,$FB,$06,$0A,$07,
  $19,$07,$28,$07,$37,$07,$46,$07,$55,$07,$64,$07,$73,$07,$90,$07,$9F,$07,
  $AE,$07,$BD,$07,$DA,$07,$E9,$07,$06,$08,$23,$08,

  4, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$00,$00,$60,$60,$60,$60,$60,$60,$00,$60,$60,$00,$00,

  7, // $22 '"'
  $00,$00,$6C,$6C,$6C,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $23 '#'
  $00,$00,$00,$00,$00,$00,$09,$00,$09,$00,$3F,$80,$3F,$80,$12,$00,$7F,$00,$7F,$00,$24,$00,$24,$00,$00,$00,$00,$00,

  9, // $24 '$'
  $00,$00,$00,$00,$08,$00,$08,$00,$3E,$00,$69,$00,$68,$00,$7E,$00,$3F,$00,$0B,$00,$4B,$00,$3E,$00,$08,$00,$08,$00,

  15, // $25 '%'
  $00,$00,$00,$00,$00,$00,$38,$40,$6C,$40,$6C,$80,$6C,$B8,$6D,$6C,$3A,$6C,$02,$6C,$04,$6C,$04,$38,$00,$00,$00,$00,

  10, // $26 '&'
  $00,$00,$00,$00,$00,$00,$38,$00,$6C,$00,$6C,$00,$6C,$00,$39,$80,$6D,$00,$66,$00,$63,$00,$3D,$80,$00,$00,$00,$00,

  4, // $27 '''
  $00,$00,$60,$60,$60,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $00,$00,$18,$30,$30,$60,$60,$60,$60,$60,$60,$30,$30,$18,

  7, // $29 ')'
  $00,$00,$30,$18,$18,$0C,$0C,$0C,$0C,$0C,$0C,$18,$18,$30,

  9, // $2A '*'
  $00,$00,$00,$00,$08,$00,$2A,$00,$1C,$00,$1C,$00,$2A,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$08,$00,$7F,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  4, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$60,$40,

  6, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$78,$00,$00,$00,$00,$00,$00,

  4, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$00,$00,

  8, // $2F '/'
  $00,$00,$06,$06,$0C,$0C,$0C,$18,$18,$30,$30,$30,$60,$60,

  9, // $30 '0'
  $00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,

  9, // $31 '1'
  $00,$00,$00,$00,$00,$00,$0C,$00,$3C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$3F,$00,$00,$00,$00,$00,

  9, // $32 '2'
  $00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$03,$00,$03,$00,$06,$00,$0C,$00,$18,$00,$30,$00,$7F,$00,$00,$00,$00,$00,

  9, // $33 '3'
  $00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$03,$00,$03,$00,$1E,$00,$03,$00,$03,$00,$63,$00,$3E,$00,$00,$00,$00,$00,

  9, // $34 '4'
  $00,$00,$00,$00,$00,$00,$06,$00,$0E,$00,$16,$00,$16,$00,$26,$00,$46,$00,$7F,$00,$06,$00,$06,$00,$00,$00,$00,$00,

  9, // $35 '5'
  $00,$00,$00,$00,$00,$00,$3F,$00,$30,$00,$30,$00,$3E,$00,$03,$00,$03,$00,$03,$00,$63,$00,$3E,$00,$00,$00,$00,$00,

  9, // $36 '6'
  $00,$00,$00,$00,$00,$00,$1E,$00,$30,$00,$60,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,

  9, // $37 '7'
  $00,$00,$00,$00,$00,$00,$7F,$00,$03,$00,$06,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$18,$00,$30,$00,$00,$00,$00,$00,

  9, // $38 '8'
  $00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,

  9, // $39 '9'
  $00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3F,$00,$03,$00,$06,$00,$3C,$00,$00,$00,$00,$00,

  5, // $3A ':'
  $00,$00,$00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$00,$00,

  5, // $3B ';'
  $00,$00,$00,$00,$00,$60,$60,$00,$00,$00,$60,$60,$60,$40,

  10, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$01,$00,$06,$00,$18,$00,$60,$00,$60,$00,$18,$00,$06,$00,$01,$00,$00,$00,$00,$00,

  10, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$00,$30,$00,$0C,$00,$03,$00,$03,$00,$0C,$00,$30,$00,$40,$00,$00,$00,$00,$00,

  7, // $3F '?'
  $00,$00,$00,$38,$4C,$0C,$18,$30,$30,$00,$30,$30,$00,$00,

  12, // $40 '@'
  $00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$2F,$40,$5B,$20,$5B,$20,$5B,$20,$5B,$20,$2F,$C0,$30,$00,$0F,$00,$00,$00,

  9, // $41 'A'
  $00,$00,$00,$00,$00,$00,$1C,$00,$1C,$00,$36,$00,$36,$00,$36,$00,$36,$00,$7F,$00,$63,$00,$63,$00,$00,$00,$00,$00,

  9, // $42 'B'
  $00,$00,$00,$00,$00,$00,$7C,$00,$66,$00,$66,$00,$66,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$7E,$00,$00,$00,$00,$00,

  9, // $43 'C'
  $00,$00,$00,$00,$00,$00,$1E,$00,$31,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$31,$00,$1E,$00,$00,$00,$00,$00,

  10, // $44 'D'
  $00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$63,$00,$7E,$00,$00,$00,$00,$00,

  8, // $45 'E'
  $00,$00,$00,$7E,$60,$60,$60,$7E,$60,$60,$60,$7E,$00,$00,

  8, // $46 'F'
  $00,$00,$00,$7E,$60,$60,$60,$7E,$60,$60,$60,$60,$00,$00,

  10, // $47 'G'
  $00,$00,$00,$00,$00,$00,$1F,$00,$30,$80,$60,$00,$60,$00,$60,$00,$67,$80,$61,$80,$31,$80,$1F,$80,$00,$00,$00,$00,

  10, // $48 'H'
  $00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$61,$80,$61,$80,$7F,$80,$61,$80,$61,$80,$61,$80,$61,$80,$00,$00,$00,$00,

  6, // $49 'I'
  $00,$00,$00,$78,$30,$30,$30,$30,$30,$30,$30,$78,$00,$00,

  7, // $4A 'J'
  $00,$00,$00,$7C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$F8,$00,$00,

  9, // $4B 'K'
  $00,$00,$00,$00,$00,$00,$63,$00,$66,$00,$6C,$00,$78,$00,$70,$00,$78,$00,$6C,$00,$66,$00,$63,$00,$00,$00,$00,$00,

  8, // $4C 'L'
  $00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$7F,$00,$00,

  11, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$60,$C0,$71,$C0,$71,$C0,$5A,$C0,$5A,$C0,$4C,$C0,$4C,$C0,$40,$C0,$40,$C0,$00,$00,$00,$00,

  10, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$60,$80,$70,$80,$58,$80,$58,$80,$4C,$80,$46,$80,$46,$80,$43,$80,$41,$80,$00,$00,$00,$00,

  11, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$31,$80,$1F,$00,$00,$00,$00,$00,

  9, // $50 'P'
  $00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$7E,$00,$60,$00,$60,$00,$60,$00,$00,$00,$00,$00,

  11, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$31,$80,$1F,$00,$06,$00,$03,$C0,

  9, // $52 'R'
  $00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$7E,$00,$6C,$00,$66,$00,$63,$00,$61,$80,$00,$00,$00,$00,

  9, // $53 'S'
  $00,$00,$00,$00,$00,$00,$3E,$00,$61,$00,$60,$00,$70,$00,$3E,$00,$07,$00,$03,$00,$43,$00,$3E,$00,$00,$00,$00,$00,

  8, // $54 'T'
  $00,$00,$00,$FF,$18,$18,$18,$18,$18,$18,$18,$18,$00,$00,

  10, // $55 'U'
  $00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$3F,$00,$00,$00,$00,$00,

  9, // $56 'V'
  $00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$36,$00,$36,$00,$36,$00,$1C,$00,$1C,$00,$1C,$00,$00,$00,$00,$00,

  14, // $57 'W'
  $00,$00,$00,$00,$00,$00,$63,$18,$63,$18,$63,$18,$33,$30,$37,$B0,$34,$B0,$1C,$E0,$18,$60,$18,$60,$00,$00,$00,$00,

  9, // $58 'X'
  $00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$36,$00,$1C,$00,$1C,$00,$1C,$00,$36,$00,$63,$00,$63,$00,$00,$00,$00,$00,

  10, // $59 'Y'
  $00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$33,$00,$1E,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,

  8, // $5A 'Z'
  $00,$00,$00,$7E,$0C,$0C,$18,$18,$30,$30,$60,$7E,$00,$00,

  6, // $5B '['
  $00,$00,$78,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$78,

  8, // $5C '\'
  $00,$00,$60,$60,$30,$30,$30,$18,$18,$0C,$0C,$0C,$06,$06,

  6, // $5D ']'
  $00,$00,$78,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$78,

  10, // $5E '^'
  $00,$00,$00,$00,$00,$00,$0C,$00,$1E,$00,$33,$00,$61,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$80,

  9, // $60 '`'
  $00,$00,$00,$00,$30,$00,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $61 'a'
  $00,$00,$00,$00,$00,$3C,$06,$3E,$66,$66,$66,$3E,$00,$00,

  8, // $62 'b'
  $00,$00,$60,$60,$60,$7C,$66,$66,$66,$66,$66,$7C,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$00,$00,$3C,$62,$60,$60,$60,$62,$3C,$00,$00,

  8, // $64 'd'
  $00,$00,$06,$06,$06,$3E,$66,$66,$66,$66,$66,$3E,$00,$00,

  8, // $65 'e'
  $00,$00,$00,$00,$00,$3C,$66,$66,$7E,$60,$62,$3C,$00,$00,

  5, // $66 'f'
  $00,$00,$38,$60,$60,$F8,$60,$60,$60,$60,$60,$60,$00,$00,

  8, // $67 'g'
  $00,$00,$00,$00,$00,$3E,$66,$66,$66,$66,$66,$3E,$06,$3C,

  8, // $68 'h'
  $00,$00,$60,$60,$60,$7C,$66,$66,$66,$66,$66,$66,$00,$00,

  4, // $69 'i'
  $00,$00,$60,$60,$00,$60,$60,$60,$60,$60,$60,$60,$00,$00,

  5, // $6A 'j'
  $00,$00,$30,$30,$00,$70,$30,$30,$30,$30,$30,$30,$30,$E0,

  8, // $6B 'k'
  $00,$00,$60,$60,$60,$66,$6C,$78,$78,$6C,$66,$63,$00,$00,

  4, // $6C 'l'
  $00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,

  12, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6C,$C0,$77,$60,$66,$60,$66,$60,$66,$60,$66,$60,$66,$60,$00,$00,$00,$00,

  8, // $6E 'n'
  $00,$00,$00,$00,$00,$7C,$66,$66,$66,$66,$66,$66,$00,$00,

  8, // $6F 'o'
  $00,$00,$00,$00,$00,$3C,$66,$66,$66,$66,$66,$3C,$00,$00,

  8, // $70 'p'
  $00,$00,$00,$00,$00,$7C,$66,$66,$66,$66,$66,$7C,$60,$60,

  8, // $71 'q'
  $00,$00,$00,$00,$00,$3E,$66,$66,$66,$66,$66,$3E,$06,$06,

  6, // $72 'r'
  $00,$00,$00,$00,$00,$6C,$7C,$60,$60,$60,$60,$60,$00,$00,

  7, // $73 's'
  $00,$00,$00,$00,$00,$3C,$60,$60,$38,$0C,$0C,$78,$00,$00,

  5, // $74 't'
  $00,$00,$00,$60,$60,$F8,$60,$60,$60,$60,$60,$38,$00,$00,

  8, // $75 'u'
  $00,$00,$00,$00,$00,$66,$66,$66,$66,$66,$66,$3E,$00,$00,

  8, // $76 'v'
  $00,$00,$00,$00,$00,$66,$66,$66,$3C,$3C,$3C,$18,$00,$00,

  12, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$66,$60,$66,$60,$66,$60,$69,$60,$39,$C0,$30,$C0,$30,$C0,$00,$00,$00,$00,

  8, // $78 'x'
  $00,$00,$00,$00,$00,$66,$66,$3C,$18,$3C,$66,$66,$00,$00,

  8, // $79 'y'
  $00,$00,$00,$00,$00,$66,$66,$66,$3C,$3C,$3C,$18,$18,$30,

  7, // $7A 'z'
  $00,$00,$00,$00,$00,$7C,$0C,$18,$38,$30,$60,$7C,$00,$00,

  9, // $7B '{'
  $00,$00,$00,$00,$0E,$00,$18,$00,$18,$00,$18,$00,$18,$00,$70,$00,$18,$00,$18,$00,$18,$00,$18,$00,$18,$00,$0E,$00,

  6, // $7C '|'
  $00,$00,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,

  9, // $7D '}'
  $00,$00,$00,$00,$38,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$07,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$38,$00,

  10, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$80,$48,$80,$44,$80,$43,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $7F ''
  $00,$00,$00,$00,$00,$00,$3F,$E0,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$3F,$E0,$00,$00,$00,$00,

  0 );

 verdana16 : array[0..2340 ] of int8u = (
  16, 4, 32, 128-32,
  $00,$00,$11,$00,$22,$00,$33,$00,$54,$00,$65,$00,$86,$00,$A7,$00,$B8,$00,
  $C9,$00,$DA,$00,$FB,$00,$1C,$01,$2D,$01,$3E,$01,$4F,$01,$60,$01,$71,$01,
  $82,$01,$93,$01,$A4,$01,$B5,$01,$C6,$01,$D7,$01,$E8,$01,$F9,$01,$0A,$02,
  $1B,$02,$2C,$02,$4D,$02,$6E,$02,$8F,$02,$A0,$02,$C1,$02,$E2,$02,$F3,$02,
  $14,$03,$35,$03,$46,$03,$57,$03,$78,$03,$99,$03,$AA,$03,$BB,$03,$CC,$03,
  $DD,$03,$FE,$03,$1F,$04,$40,$04,$51,$04,$72,$04,$93,$04,$B4,$04,$D5,$04,
  $F6,$04,$17,$05,$38,$05,$59,$05,$7A,$05,$9B,$05,$AC,$05,$BD,$05,$CE,$05,
  $EF,$05,$00,$06,$11,$06,$22,$06,$33,$06,$44,$06,$55,$06,$66,$06,$77,$06,
  $88,$06,$99,$06,$AA,$06,$BB,$06,$CC,$06,$DD,$06,$FE,$06,$0F,$07,$20,$07,
  $31,$07,$42,$07,$53,$07,$64,$07,$75,$07,$86,$07,$97,$07,$B8,$07,$C9,$07,
  $DA,$07,$EB,$07,$FC,$07,$0D,$08,$1E,$08,$3F,$08,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $21 '!'
  $00,$00,$00,$00,$20,$20,$20,$20,$20,$20,$00,$20,$20,$00,$00,$00,

  5, // $22 '"'
  $00,$00,$00,$50,$50,$50,$50,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $23 '#'
  $00,$00,$00,$00,$00,$00,$00,$00,$09,$00,$09,$00,$3F,$80,$12,$00,$12,$00,$7F,$00,$24,$00,$24,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $24 '$'
  $00,$00,$00,$10,$10,$3E,$50,$50,$30,$1C,$12,$12,$7C,$10,$10,$00,

  13, // $25 '%'
  $00,$00,$00,$00,$00,$00,$00,$00,$38,$40,$44,$80,$45,$00,$45,$00,$3A,$E0,$05,$10,$05,$10,$09,$10,$10,$E0,$00,$00,$00,$00,$00,$00,

  10, // $26 '&'
  $00,$00,$00,$00,$00,$00,$00,$00,$38,$00,$44,$00,$44,$00,$44,$00,$38,$80,$45,$00,$42,$00,$46,$00,$39,$80,$00,$00,$00,$00,$00,$00,

  3, // $27 '''
  $00,$00,$00,$40,$40,$40,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $28 '('
  $00,$00,$00,$08,$10,$20,$20,$40,$40,$40,$40,$40,$20,$20,$10,$08,

  6, // $29 ')'
  $00,$00,$00,$40,$20,$10,$10,$08,$08,$08,$08,$08,$10,$10,$20,$40,

  9, // $2A '*'
  $00,$00,$00,$00,$00,$00,$08,$00,$2A,$00,$1C,$00,$2A,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$08,$00,$7F,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$40,$00,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,

  6, // $2F '/'
  $00,$00,$00,$04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$80,$80,$00,

  8, // $30 '0'
  $00,$00,$00,$00,$3C,$42,$42,$42,$42,$42,$42,$42,$3C,$00,$00,$00,

  8, // $31 '1'
  $00,$00,$00,$00,$08,$38,$08,$08,$08,$08,$08,$08,$3E,$00,$00,$00,

  8, // $32 '2'
  $00,$00,$00,$00,$3C,$42,$42,$02,$04,$18,$20,$40,$7E,$00,$00,$00,

  8, // $33 '3'
  $00,$00,$00,$00,$3C,$42,$02,$02,$1C,$02,$02,$42,$3C,$00,$00,$00,

  8, // $34 '4'
  $00,$00,$00,$00,$04,$0C,$14,$24,$44,$7F,$04,$04,$04,$00,$00,$00,

  8, // $35 '5'
  $00,$00,$00,$00,$3E,$20,$20,$20,$3C,$02,$02,$42,$3C,$00,$00,$00,

  8, // $36 '6'
  $00,$00,$00,$00,$1C,$20,$40,$7C,$42,$42,$42,$42,$3C,$00,$00,$00,

  8, // $37 '7'
  $00,$00,$00,$00,$7E,$02,$04,$04,$08,$08,$10,$10,$10,$00,$00,$00,

  8, // $38 '8'
  $00,$00,$00,$00,$3C,$42,$42,$42,$3C,$42,$42,$42,$3C,$00,$00,$00,

  8, // $39 '9'
  $00,$00,$00,$00,$3C,$42,$42,$42,$42,$3E,$02,$04,$38,$00,$00,$00,

  6, // $3A ':'
  $00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,$20,$20,$00,$00,$00,

  6, // $3B ';'
  $00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,$20,$20,$20,$40,$00,

  9, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$03,$00,$0C,$00,$30,$00,$40,$00,$30,$00,$0C,$00,$03,$00,$00,$00,$00,$00,$00,$00,

  9, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$60,$00,$18,$00,$06,$00,$01,$00,$06,$00,$18,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  7, // $3F '?'
  $00,$00,$00,$00,$38,$44,$04,$08,$10,$10,$00,$10,$10,$00,$00,$00,

  13, // $40 '@'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$10,$40,$27,$A0,$48,$90,$48,$90,$48,$90,$48,$90,$48,$90,$27,$E0,$10,$00,$0F,$80,$00,$00,

  9, // $41 'A'
  $00,$00,$00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$14,$00,$14,$00,$22,$00,$22,$00,$3E,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  8, // $42 'B'
  $00,$00,$00,$00,$78,$44,$44,$44,$7C,$42,$42,$42,$7C,$00,$00,$00,

  9, // $43 'C'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$00,$40,$00,$40,$00,$40,$00,$40,$00,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  9, // $44 'D'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$42,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$00,$00,$00,$00,$00,$00,

  8, // $45 'E'
  $00,$00,$00,$00,$7E,$40,$40,$40,$7E,$40,$40,$40,$7E,$00,$00,$00,

  8, // $46 'F'
  $00,$00,$00,$00,$7E,$40,$40,$40,$7C,$40,$40,$40,$40,$00,$00,$00,

  9, // $47 'G'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$00,$40,$00,$40,$00,$47,$00,$41,$00,$21,$00,$1F,$00,$00,$00,$00,$00,$00,$00,

  9, // $48 'H'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$7F,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  5, // $49 'I'
  $00,$00,$00,$00,$70,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,$00,

  6, // $4A 'J'
  $00,$00,$00,$00,$38,$08,$08,$08,$08,$08,$08,$08,$F0,$00,$00,$00,

  8, // $4B 'K'
  $00,$00,$00,$00,$42,$44,$48,$50,$60,$50,$48,$44,$42,$00,$00,$00,

  7, // $4C 'L'
  $00,$00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$7E,$00,$00,$00,

  11, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$60,$C0,$51,$40,$51,$40,$4A,$40,$4A,$40,$44,$40,$44,$40,$40,$40,$00,$00,$00,$00,$00,$00,

  9, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$00,$00,$61,$00,$61,$00,$51,$00,$51,$00,$49,$00,$45,$00,$45,$00,$43,$00,$43,$00,$00,$00,$00,$00,$00,$00,

  10, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  8, // $50 'P'
  $00,$00,$00,$00,$7C,$42,$42,$42,$42,$7C,$40,$40,$40,$00,$00,$00,

  10, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$02,$00,$01,$80,$00,$00,

  9, // $52 'R'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$42,$00,$42,$00,$42,$00,$44,$00,$78,$00,$44,$00,$42,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  9, // $53 'S'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$41,$00,$40,$00,$40,$00,$3E,$00,$01,$00,$01,$00,$41,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $54 'T'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  9, // $55 'U'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$00,$00,$00,$00,$00,$00,

  9, // $56 'V'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$22,$00,$22,$00,$14,$00,$14,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  13, // $57 'W'
  $00,$00,$00,$00,$00,$00,$00,$00,$42,$10,$42,$10,$45,$10,$45,$10,$25,$20,$28,$A0,$28,$A0,$10,$40,$10,$40,$00,$00,$00,$00,$00,$00,

  9, // $58 'X'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$22,$00,$14,$00,$08,$00,$14,$00,$22,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  9, // $59 'Y'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$22,$00,$22,$00,$14,$00,$14,$00,$08,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  9, // $5A 'Z'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$01,$00,$02,$00,$04,$00,$08,$00,$10,$00,$20,$00,$40,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  6, // $5B '['
  $00,$00,$00,$38,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$38,$00,

  6, // $5C '\'
  $00,$00,$00,$80,$80,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$00,

  6, // $5D ']'
  $00,$00,$00,$70,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$70,$00,

  11, // $5E '^'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$0A,$00,$11,$00,$20,$80,$40,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$00,

  8, // $60 '`'
  $00,$00,$00,$10,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $61 'a'
  $00,$00,$00,$00,$00,$00,$3C,$02,$02,$3E,$42,$42,$3E,$00,$00,$00,

  8, // $62 'b'
  $00,$00,$00,$40,$40,$40,$5C,$62,$42,$42,$42,$42,$7C,$00,$00,$00,

  8, // $63 'c'
  $00,$00,$00,$00,$00,$00,$3C,$42,$40,$40,$40,$42,$3C,$00,$00,$00,

  8, // $64 'd'
  $00,$00,$00,$02,$02,$02,$3E,$42,$42,$42,$42,$46,$3A,$00,$00,$00,

  8, // $65 'e'
  $00,$00,$00,$00,$00,$00,$3C,$42,$42,$7E,$40,$42,$3C,$00,$00,$00,

  6, // $66 'f'
  $00,$00,$00,$1C,$20,$20,$78,$20,$20,$20,$20,$20,$20,$00,$00,$00,

  8, // $67 'g'
  $00,$00,$00,$00,$00,$00,$3E,$42,$42,$42,$42,$46,$3A,$02,$02,$3C,

  8, // $68 'h'
  $00,$00,$00,$40,$40,$40,$5C,$62,$42,$42,$42,$42,$42,$00,$00,$00,

  3, // $69 'i'
  $00,$00,$00,$40,$00,$00,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  4, // $6A 'j'
  $00,$00,$00,$20,$00,$00,$60,$20,$20,$20,$20,$20,$20,$20,$20,$C0,

  7, // $6B 'k'
  $00,$00,$00,$40,$40,$40,$44,$48,$50,$60,$50,$48,$44,$00,$00,$00,

  3, // $6C 'l'
  $00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  11, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$59,$80,$66,$40,$44,$40,$44,$40,$44,$40,$44,$40,$44,$40,$00,$00,$00,$00,$00,$00,

  8, // $6E 'n'
  $00,$00,$00,$00,$00,$00,$5C,$62,$42,$42,$42,$42,$42,$00,$00,$00,

  8, // $6F 'o'
  $00,$00,$00,$00,$00,$00,$3C,$42,$42,$42,$42,$42,$3C,$00,$00,$00,

  8, // $70 'p'
  $00,$00,$00,$00,$00,$00,$5C,$62,$42,$42,$42,$42,$7C,$40,$40,$40,

  8, // $71 'q'
  $00,$00,$00,$00,$00,$00,$3E,$42,$42,$42,$42,$46,$3A,$02,$02,$02,

  5, // $72 'r'
  $00,$00,$00,$00,$00,$00,$58,$60,$40,$40,$40,$40,$40,$00,$00,$00,

  7, // $73 's'
  $00,$00,$00,$00,$00,$00,$3C,$40,$40,$38,$04,$04,$78,$00,$00,$00,

  6, // $74 't'
  $00,$00,$00,$00,$20,$20,$78,$20,$20,$20,$20,$20,$18,$00,$00,$00,

  8, // $75 'u'
  $00,$00,$00,$00,$00,$00,$42,$42,$42,$42,$42,$46,$3A,$00,$00,$00,

  8, // $76 'v'
  $00,$00,$00,$00,$00,$00,$42,$42,$24,$24,$24,$18,$18,$00,$00,$00,

  11, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$44,$40,$44,$40,$2A,$80,$2A,$80,$2A,$80,$11,$00,$11,$00,$00,$00,$00,$00,$00,$00,

  7, // $78 'x'
  $00,$00,$00,$00,$00,$00,$44,$44,$28,$10,$28,$44,$44,$00,$00,$00,

  8, // $79 'y'
  $00,$00,$00,$00,$00,$00,$42,$42,$24,$24,$24,$18,$18,$10,$10,$20,

  7, // $7A 'z'
  $00,$00,$00,$00,$00,$00,$7C,$04,$08,$10,$20,$40,$7C,$00,$00,$00,

  8, // $7B '{'
  $00,$00,$00,$0C,$10,$10,$10,$10,$60,$10,$10,$10,$10,$10,$0C,$00,

  7, // $7C '|'
  $00,$00,$00,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$00,

  8, // $7D '}'
  $00,$00,$00,$30,$08,$08,$08,$08,$06,$08,$08,$08,$08,$08,$30,$00,

  11, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$80,$4C,$80,$43,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  13, // $7F ''
  $00,$00,$00,$00,$00,$00,$3F,$F0,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$3F,$F0,$00,$00,$00,$00,$00,$00,

  0 );

 verdana16_bold : array[0..2916 ] of int8u = (
  16, 4, 32, 128-32,
  $00,$00,$11,$00,$22,$00,$33,$00,$54,$00,$75,$00,$A6,$00,$C7,$00,$D8,$00,
  $E9,$00,$FA,$00,$1B,$01,$3C,$01,$4D,$01,$5E,$01,$6F,$01,$90,$01,$B1,$01,
  $D2,$01,$F3,$01,$14,$02,$35,$02,$56,$02,$77,$02,$98,$02,$B9,$02,$DA,$02,
  $EB,$02,$FC,$02,$1D,$03,$3E,$03,$5F,$03,$70,$03,$91,$03,$B2,$03,$D3,$03,
  $F4,$03,$15,$04,$36,$04,$57,$04,$78,$04,$99,$04,$AA,$04,$BB,$04,$DC,$04,
  $ED,$04,$0E,$05,$2F,$05,$50,$05,$71,$05,$92,$05,$B3,$05,$D4,$05,$E5,$05,
  $06,$06,$27,$06,$48,$06,$69,$06,$8A,$06,$AB,$06,$BC,$06,$DD,$06,$EE,$06,
  $0F,$07,$30,$07,$51,$07,$72,$07,$93,$07,$A4,$07,$C5,$07,$E6,$07,$F7,$07,
  $18,$08,$39,$08,$4A,$08,$5B,$08,$6C,$08,$7D,$08,$9E,$08,$BF,$08,$E0,$08,
  $01,$09,$22,$09,$33,$09,$44,$09,$55,$09,$76,$09,$97,$09,$B8,$09,$D9,$09,
  $FA,$09,$0B,$0A,$2C,$0A,$3D,$0A,$5E,$0A,$7F,$0A,

  4, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$00,$00,$00,$30,$30,$30,$30,$30,$30,$00,$30,$30,$00,$00,$00,

  7, // $22 '"'
  $00,$00,$00,$6C,$6C,$6C,$6C,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $23 '#'
  $00,$00,$00,$00,$00,$00,$00,$00,$09,$00,$09,$00,$3F,$80,$3F,$80,$12,$00,$7F,$00,$7F,$00,$24,$00,$24,$00,$00,$00,$00,$00,$00,$00,

  9, // $24 '$'
  $00,$00,$00,$00,$08,$00,$08,$00,$3E,$00,$69,$00,$68,$00,$78,$00,$3E,$00,$0F,$00,$0B,$00,$4B,$00,$3E,$00,$08,$00,$08,$00,$00,$00,

  17, // $25 '%'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3C,$20,$00,$66,$20,$00,$66,$40,$00,$66,$5E,$00,$66,$B3,$00,$3D,$33,$00,$01,$33,$00,$02,$33,$00,$02,$1E,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $26 '&'
  $00,$00,$00,$00,$00,$00,$00,$00,$3C,$00,$66,$00,$66,$00,$66,$C0,$3C,$C0,$66,$80,$63,$00,$63,$80,$3C,$C0,$00,$00,$00,$00,$00,$00,

  4, // $27 '''
  $00,$00,$00,$60,$60,$60,$60,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $00,$00,$00,$0C,$18,$30,$30,$60,$60,$60,$60,$60,$30,$30,$18,$0C,

  7, // $29 ')'
  $00,$00,$00,$60,$30,$18,$18,$0C,$0C,$0C,$0C,$0C,$18,$18,$30,$60,

  9, // $2A '*'
  $00,$00,$00,$00,$00,$00,$08,$00,$49,$00,$2A,$00,$1C,$00,$2A,$00,$49,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$04,$00,$04,$00,$3F,$80,$04,$00,$04,$00,$04,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$70,$60,$60,$C0,$C0,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$00,$00,$00,

  9, // $2F '/'
  $00,$00,$00,$00,$00,$00,$03,$00,$03,$00,$06,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$18,$00,$30,$00,$30,$00,$60,$00,$60,$00,$00,$00,

  9, // $30 '0'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $31 '1'
  $00,$00,$00,$00,$00,$00,$00,$00,$0C,$00,$3C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$3F,$00,$00,$00,$00,$00,$00,$00,

  9, // $32 '2'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$03,$00,$06,$00,$0C,$00,$18,$00,$30,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  9, // $33 '3'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$03,$00,$0E,$00,$03,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $34 '4'
  $00,$00,$00,$00,$00,$00,$00,$00,$06,$00,$0E,$00,$16,$00,$26,$00,$46,$00,$7F,$80,$06,$00,$06,$00,$06,$00,$00,$00,$00,$00,$00,$00,

  9, // $35 '5'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$30,$00,$30,$00,$3E,$00,$03,$00,$03,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $36 '6'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$30,$00,$60,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $37 '7'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$03,$00,$03,$00,$06,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$18,$00,$00,$00,$00,$00,$00,$00,

  9, // $38 '8'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $39 '9'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3F,$00,$03,$00,$06,$00,$3C,$00,$00,$00,$00,$00,$00,$00,

  5, // $3A ':'
  $00,$00,$00,$00,$00,$00,$30,$30,$00,$00,$00,$30,$30,$00,$00,$00,

  5, // $3B ';'
  $00,$00,$00,$00,$00,$00,$30,$30,$00,$00,$00,$38,$30,$30,$60,$60,

  11, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$80,$03,$00,$0C,$00,$30,$00,$40,$00,$30,$00,$0C,$00,$03,$00,$00,$80,$00,$00,$00,$00,$00,$00,

  11, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$80,$00,$00,$00,$00,$3F,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$20,$00,$18,$00,$06,$00,$01,$80,$00,$40,$01,$80,$06,$00,$18,$00,$20,$00,$00,$00,$00,$00,$00,$00,

  8, // $3F '?'
  $00,$00,$00,$00,$3C,$66,$06,$0C,$18,$18,$00,$18,$18,$00,$00,$00,

  13, // $40 '@'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$30,$60,$27,$A0,$4D,$90,$4D,$90,$4D,$90,$4D,$90,$27,$E0,$30,$00,$0F,$80,$00,$00,$00,$00,

  10, // $41 'A'
  $00,$00,$00,$00,$00,$00,$00,$00,$0C,$00,$0C,$00,$1E,$00,$1E,$00,$33,$00,$33,$00,$7F,$80,$61,$80,$61,$80,$00,$00,$00,$00,$00,$00,

  10, // $42 'B'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$7F,$00,$61,$80,$61,$80,$61,$80,$7F,$00,$00,$00,$00,$00,$00,$00,

  10, // $43 'C'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$61,$80,$60,$00,$60,$00,$60,$00,$61,$80,$31,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  10, // $44 'D'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$63,$00,$7E,$00,$00,$00,$00,$00,$00,$00,

  9, // $45 'E'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$60,$00,$60,$00,$60,$00,$7F,$00,$60,$00,$60,$00,$60,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  9, // $46 'F'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$60,$00,$60,$00,$60,$00,$7F,$00,$60,$00,$60,$00,$60,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  10, // $47 'G'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$61,$80,$60,$00,$60,$00,$63,$80,$61,$80,$31,$80,$1F,$80,$00,$00,$00,$00,$00,$00,

  11, // $48 'H'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$7F,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$00,$00,$00,$00,$00,$00,

  6, // $49 'I'
  $00,$00,$00,$00,$78,$30,$30,$30,$30,$30,$30,$30,$78,$00,$00,$00,

  7, // $4A 'J'
  $00,$00,$00,$00,$7C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$F8,$00,$00,$00,

  9, // $4B 'K'
  $00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$66,$00,$6C,$00,$78,$00,$78,$00,$6C,$00,$66,$00,$63,$00,$61,$80,$00,$00,$00,$00,$00,$00,

  8, // $4C 'L'
  $00,$00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$7F,$00,$00,$00,

  12, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$00,$00,$70,$E0,$70,$E0,$59,$60,$59,$60,$4E,$60,$4E,$60,$44,$60,$44,$60,$40,$60,$00,$00,$00,$00,$00,$00,

  10, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$00,$00,$70,$80,$70,$80,$58,$80,$58,$80,$4C,$80,$46,$80,$46,$80,$43,$80,$43,$80,$00,$00,$00,$00,$00,$00,

  11, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$31,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  9, // $50 'P'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$7E,$00,$60,$00,$60,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  11, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$31,$80,$1F,$00,$03,$00,$01,$C0,$00,$00,

  9, // $52 'R'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$63,$00,$63,$00,$7E,$00,$6C,$00,$66,$00,$63,$00,$61,$80,$00,$00,$00,$00,$00,$00,

  9, // $53 'S'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$70,$00,$3E,$00,$07,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  8, // $54 'T'
  $00,$00,$00,$00,$FF,$18,$18,$18,$18,$18,$18,$18,$18,$00,$00,$00,

  10, // $55 'U'
  $00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$3F,$00,$00,$00,$00,$00,$00,$00,

  10, // $56 'V'
  $00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$61,$80,$33,$00,$33,$00,$1E,$00,$1E,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  14, // $57 'W'
  $00,$00,$00,$00,$00,$00,$00,$00,$63,$18,$63,$18,$63,$18,$33,$30,$37,$B0,$34,$B0,$1C,$E0,$18,$60,$18,$60,$00,$00,$00,$00,$00,$00,

  10, // $58 'X'
  $00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$33,$00,$33,$00,$1E,$00,$0C,$00,$1E,$00,$33,$00,$33,$00,$61,$80,$00,$00,$00,$00,$00,$00,

  10, // $59 'Y'
  $00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$33,$00,$1E,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  9, // $5A 'Z'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$18,$00,$30,$00,$30,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  6, // $5B '['
  $00,$00,$00,$78,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$78,$00,

  9, // $5C '\'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$30,$00,$30,$00,$18,$00,$18,$00,$0C,$00,$0C,$00,$06,$00,$06,$00,$03,$00,$03,$00,$00,$00,

  6, // $5D ']'
  $00,$00,$00,$78,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$78,$00,

  10, // $5E '^'
  $00,$00,$00,$00,$00,$00,$00,$00,$0C,$00,$1E,$00,$33,$00,$61,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$80,$00,$00,

  9, // $60 '`'
  $00,$00,$00,$00,$00,$00,$30,$00,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $61 'a'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$03,$00,$3F,$00,$63,$00,$63,$00,$63,$00,$3F,$00,$00,$00,$00,$00,$00,$00,

  9, // $62 'b'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$6E,$00,$73,$00,$63,$00,$63,$00,$63,$00,$63,$00,$7E,$00,$00,$00,$00,$00,$00,$00,

  8, // $63 'c'
  $00,$00,$00,$00,$00,$00,$3E,$63,$60,$60,$60,$63,$3E,$00,$00,$00,

  9, // $64 'd'
  $00,$00,$00,$00,$00,$00,$03,$00,$03,$00,$03,$00,$3F,$00,$63,$00,$63,$00,$63,$00,$63,$00,$67,$00,$3B,$00,$00,$00,$00,$00,$00,$00,

  9, // $65 'e'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$7F,$00,$60,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  5, // $66 'f'
  $00,$00,$00,$38,$60,$60,$F8,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  9, // $67 'g'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$63,$00,$63,$00,$63,$00,$63,$00,$67,$00,$3B,$00,$03,$00,$03,$00,$3E,$00,

  9, // $68 'h'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$6E,$00,$73,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$00,$00,$00,$00,$00,$00,

  4, // $69 'i'
  $00,$00,$00,$60,$60,$00,$60,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  5, // $6A 'j'
  $00,$00,$00,$30,$30,$00,$70,$30,$30,$30,$30,$30,$30,$30,$30,$E0,

  8, // $6B 'k'
  $00,$00,$00,$60,$60,$60,$66,$6C,$78,$78,$6C,$66,$63,$00,$00,$00,

  4, // $6C 'l'
  $00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  14, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6E,$70,$73,$98,$63,$18,$63,$18,$63,$18,$63,$18,$63,$18,$00,$00,$00,$00,$00,$00,

  9, // $6E 'n'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6E,$00,$73,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$00,$00,$00,$00,$00,$00,

  9, // $6F 'o'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $70 'p'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6E,$00,$73,$00,$63,$00,$63,$00,$63,$00,$63,$00,$7E,$00,$60,$00,$60,$00,$60,$00,

  9, // $71 'q'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$63,$00,$63,$00,$63,$00,$63,$00,$67,$00,$3B,$00,$03,$00,$03,$00,$03,$00,

  6, // $72 'r'
  $00,$00,$00,$00,$00,$00,$6C,$7C,$60,$60,$60,$60,$60,$00,$00,$00,

  8, // $73 's'
  $00,$00,$00,$00,$00,$00,$3E,$60,$70,$3C,$0E,$06,$7C,$00,$00,$00,

  6, // $74 't'
  $00,$00,$00,$00,$60,$60,$F8,$60,$60,$60,$60,$60,$38,$00,$00,$00,

  9, // $75 'u'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$63,$00,$63,$00,$67,$00,$3B,$00,$00,$00,$00,$00,$00,$00,

  9, // $76 'v'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$36,$00,$36,$00,$1C,$00,$1C,$00,$00,$00,$00,$00,$00,$00,

  12, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$66,$60,$66,$60,$66,$60,$69,$60,$39,$C0,$30,$C0,$30,$C0,$00,$00,$00,$00,$00,$00,

  9, // $78 'x'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$36,$00,$1C,$00,$36,$00,$63,$00,$63,$00,$00,$00,$00,$00,$00,$00,

  9, // $79 'y'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$36,$00,$36,$00,$1C,$00,$1C,$00,$0C,$00,$18,$00,$18,$00,

  8, // $7A 'z'
  $00,$00,$00,$00,$00,$00,$7E,$06,$0C,$18,$30,$60,$7E,$00,$00,$00,

  9, // $7B '{'
  $00,$00,$00,$00,$00,$00,$07,$00,$0C,$00,$0C,$00,$0C,$00,$18,$00,$70,$00,$18,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$07,$00,$00,$00,

  8, // $7C '|'
  $00,$00,$00,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$00,

  9, // $7D '}'
  $00,$00,$00,$00,$00,$00,$70,$00,$18,$00,$18,$00,$18,$00,$0C,$00,$07,$00,$0C,$00,$18,$00,$18,$00,$18,$00,$18,$00,$70,$00,$00,$00,

  11, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$38,$40,$44,$40,$44,$40,$43,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  13, // $7F ''
  $00,$00,$00,$00,$00,$00,$3F,$F0,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$20,$10,$3F,$F0,$00,$00,$00,$00,$00,$00,

  0 );

 verdana17 : array[0..2944 ] of int8u = (
  17, 4, 32, 128-32,
  $00,$00,$12,$00,$24,$00,$36,$00,$59,$00,$7C,$00,$9F,$00,$C2,$00,$D4,$00,
  $E6,$00,$F8,$00,$1B,$01,$3E,$01,$50,$01,$62,$01,$74,$01,$86,$01,$A9,$01,
  $CC,$01,$EF,$01,$12,$02,$35,$02,$58,$02,$7B,$02,$9E,$02,$C1,$02,$E4,$02,
  $F6,$02,$08,$03,$2B,$03,$4E,$03,$71,$03,$83,$03,$A6,$03,$C9,$03,$EC,$03,
  $0F,$04,$32,$04,$55,$04,$67,$04,$8A,$04,$AD,$04,$BF,$04,$D1,$04,$F4,$04,
  $06,$05,$29,$05,$4C,$05,$6F,$05,$81,$05,$A4,$05,$C7,$05,$EA,$05,$0D,$06,
  $30,$06,$53,$06,$76,$06,$99,$06,$BC,$06,$DF,$06,$F1,$06,$03,$07,$15,$07,
  $38,$07,$5B,$07,$7E,$07,$90,$07,$B3,$07,$C5,$07,$E8,$07,$FA,$07,$0C,$08,
  $2F,$08,$52,$08,$64,$08,$76,$08,$88,$08,$9A,$08,$BD,$08,$E0,$08,$03,$09,
  $26,$09,$49,$09,$5B,$09,$6D,$09,$7F,$09,$A2,$09,$B4,$09,$D7,$09,$FA,$09,
  $0C,$0A,$1E,$0A,$41,$0A,$53,$0A,$76,$0A,$99,$0A,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$00,$00,$00,$20,$20,$20,$20,$20,$20,$20,$00,$20,$20,$00,$00,$00,

  6, // $22 '"'
  $00,$00,$00,$48,$48,$48,$48,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $23 '#'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$80,$04,$80,$09,$00,$3F,$C0,$09,$00,$12,$00,$7F,$80,$12,$00,$24,$00,$24,$00,$00,$00,$00,$00,$00,$00,

  9, // $24 '$'
  $00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$3E,$00,$49,$00,$48,$00,$48,$00,$3E,$00,$09,$00,$09,$00,$49,$00,$3E,$00,$08,$00,$08,$00,$00,$00,

  15, // $25 '%'
  $00,$00,$00,$00,$00,$00,$00,$00,$38,$20,$44,$40,$44,$80,$44,$80,$45,$38,$39,$44,$02,$44,$04,$44,$04,$44,$08,$38,$00,$00,$00,$00,$00,$00,

  11, // $26 '&'
  $00,$00,$00,$00,$00,$00,$00,$00,$3C,$00,$42,$00,$42,$00,$44,$00,$38,$80,$44,$80,$42,$80,$41,$00,$22,$80,$1C,$40,$00,$00,$00,$00,$00,$00,

  4, // $27 '''
  $00,$00,$00,$40,$40,$40,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $28 '('
  $00,$00,$00,$08,$10,$20,$20,$40,$40,$40,$40,$40,$40,$20,$20,$10,$08,

  6, // $29 ')'
  $00,$00,$00,$40,$20,$10,$10,$08,$08,$08,$08,$08,$08,$10,$10,$20,$40,

  9, // $2A '*'
  $00,$00,$00,$00,$00,$00,$08,$00,$49,$00,$2A,$00,$1C,$00,$2A,$00,$49,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$04,$00,$04,$00,$04,$00,$7F,$C0,$04,$00,$04,$00,$04,$00,$04,$00,$00,$00,$00,$00,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$40,$00,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,

  6, // $2F '/'
  $00,$00,$00,$04,$08,$08,$08,$10,$10,$20,$20,$20,$40,$40,$80,$80,$00,

  9, // $30 '0'
  $00,$00,$00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$00,$00,$00,$00,$00,$00,

  9, // $31 '1'
  $00,$00,$00,$00,$00,$00,$00,$00,$08,$00,$38,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $32 '2'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$41,$00,$01,$00,$01,$00,$02,$00,$0C,$00,$10,$00,$20,$00,$40,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  9, // $33 '3'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$41,$00,$01,$00,$02,$00,$1C,$00,$02,$00,$01,$00,$01,$00,$42,$00,$3C,$00,$00,$00,$00,$00,$00,$00,

  9, // $34 '4'
  $00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$06,$00,$0A,$00,$12,$00,$22,$00,$42,$00,$7F,$80,$02,$00,$02,$00,$02,$00,$00,$00,$00,$00,$00,$00,

  9, // $35 '5'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$40,$00,$40,$00,$40,$00,$7C,$00,$02,$00,$01,$00,$01,$00,$42,$00,$3C,$00,$00,$00,$00,$00,$00,$00,

  9, // $36 '6'
  $00,$00,$00,$00,$00,$00,$00,$00,$0E,$00,$30,$00,$20,$00,$40,$00,$7C,$00,$42,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$00,$00,$00,$00,$00,$00,

  9, // $37 '7'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$01,$00,$02,$00,$02,$00,$04,$00,$04,$00,$08,$00,$10,$00,$10,$00,$20,$00,$00,$00,$00,$00,$00,$00,

  9, // $38 '8'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$41,$00,$41,$00,$41,$00,$3E,$00,$41,$00,$41,$00,$41,$00,$41,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  9, // $39 '9'
  $00,$00,$00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$41,$00,$21,$00,$1F,$00,$01,$00,$02,$00,$06,$00,$38,$00,$00,$00,$00,$00,$00,$00,

  6, // $3A ':'
  $00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,$00,$20,$20,$00,$00,$00,

  6, // $3B ';'
  $00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,$00,$20,$20,$20,$40,$00,

  11, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$80,$06,$00,$18,$00,$60,$00,$60,$00,$18,$00,$06,$00,$01,$80,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$C0,$00,$00,$00,$00,$3F,$C0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$00,$0C,$00,$03,$00,$00,$C0,$00,$C0,$03,$00,$0C,$00,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $3F '?'
  $00,$00,$00,$00,$3C,$42,$02,$02,$0C,$10,$10,$00,$10,$10,$00,$00,$00,

  14, // $40 '@'
  $00,$00,$00,$00,$00,$00,$00,$00,$07,$C0,$18,$20,$20,$10,$27,$C8,$48,$48,$48,$48,$48,$48,$48,$48,$27,$F0,$20,$00,$18,$00,$07,$C0,$00,$00,

  10, // $41 'A'
  $00,$00,$00,$00,$00,$00,$00,$00,$0C,$00,$12,$00,$12,$00,$21,$00,$21,$00,$21,$00,$7F,$80,$40,$80,$80,$40,$80,$40,$00,$00,$00,$00,$00,$00,

  10, // $42 'B'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$41,$00,$41,$00,$41,$00,$7E,$00,$41,$00,$40,$80,$40,$80,$41,$00,$7E,$00,$00,$00,$00,$00,$00,$00,

  10, // $43 'C'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$30,$80,$20,$00,$40,$00,$40,$00,$40,$00,$40,$00,$20,$00,$30,$80,$0F,$00,$00,$00,$00,$00,$00,$00,

  11, // $44 'D'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$41,$80,$40,$80,$40,$40,$40,$40,$40,$40,$40,$40,$40,$80,$41,$80,$7E,$00,$00,$00,$00,$00,$00,$00,

  9, // $45 'E'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$40,$00,$40,$00,$40,$00,$7F,$00,$40,$00,$40,$00,$40,$00,$40,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  8, // $46 'F'
  $00,$00,$00,$00,$7F,$40,$40,$40,$7E,$40,$40,$40,$40,$40,$00,$00,$00,

  11, // $47 'G'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$20,$40,$40,$00,$40,$00,$43,$C0,$40,$40,$20,$40,$30,$40,$0F,$80,$00,$00,$00,$00,$00,$00,

  10, // $48 'H'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$80,$40,$80,$40,$80,$40,$80,$7F,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$00,$00,$00,$00,$00,$00,

  5, // $49 'I'
  $00,$00,$00,$00,$70,$20,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,$00,

  6, // $4A 'J'
  $00,$00,$00,$00,$38,$08,$08,$08,$08,$08,$08,$08,$08,$F0,$00,$00,$00,

  10, // $4B 'K'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$42,$00,$44,$00,$48,$00,$50,$00,$68,$00,$44,$00,$42,$00,$41,$00,$40,$80,$00,$00,$00,$00,$00,$00,

  8, // $4C 'L'
  $00,$00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$7F,$00,$00,$00,

  11, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$60,$C0,$51,$40,$51,$40,$4A,$40,$4A,$40,$44,$40,$44,$40,$40,$40,$40,$40,$00,$00,$00,$00,$00,$00,

  10, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$80,$60,$80,$50,$80,$48,$80,$48,$80,$44,$80,$44,$80,$42,$80,$41,$80,$41,$80,$00,$00,$00,$00,$00,$00,

  11, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$00,$00,$0E,$00,$31,$80,$20,$80,$40,$40,$40,$40,$40,$40,$40,$40,$20,$80,$31,$80,$0E,$00,$00,$00,$00,$00,$00,$00,

  8, // $50 'P'
  $00,$00,$00,$00,$7C,$42,$41,$41,$42,$7C,$40,$40,$40,$40,$00,$00,$00,

  11, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$00,$00,$0E,$00,$31,$80,$20,$80,$40,$40,$40,$40,$40,$40,$40,$40,$20,$80,$31,$80,$0E,$00,$02,$00,$02,$00,$01,$C0,

  10, // $52 'R'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$42,$00,$42,$00,$42,$00,$44,$00,$78,$00,$44,$00,$42,$00,$41,$00,$40,$80,$00,$00,$00,$00,$00,$00,

  10, // $53 'S'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$20,$80,$40,$00,$40,$00,$38,$00,$07,$00,$00,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  9, // $54 'T'
  $00,$00,$00,$00,$00,$00,$00,$00,$FF,$80,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  10, // $55 'U'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $56 'V'
  $00,$00,$00,$00,$00,$00,$00,$00,$80,$40,$80,$40,$40,$80,$40,$80,$21,$00,$21,$00,$21,$00,$12,$00,$12,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  15, // $57 'W'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$04,$41,$04,$22,$88,$22,$88,$22,$88,$14,$50,$14,$50,$14,$50,$08,$20,$08,$20,$00,$00,$00,$00,$00,$00,

  10, // $58 'X'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$80,$21,$00,$12,$00,$12,$00,$0C,$00,$0C,$00,$12,$00,$12,$00,$21,$00,$40,$80,$00,$00,$00,$00,$00,$00,

  9, // $59 'Y'
  $00,$00,$00,$00,$00,$00,$00,$00,$80,$80,$41,$00,$22,$00,$22,$00,$14,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  10, // $5A 'Z'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$00,$80,$01,$00,$02,$00,$04,$00,$08,$00,$10,$00,$20,$00,$40,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  6, // $5B '['
  $00,$00,$00,$3C,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$3C,

  6, // $5C '\'
  $00,$00,$00,$80,$40,$40,$40,$20,$20,$10,$10,$10,$08,$08,$08,$04,$00,

  6, // $5D ']'
  $00,$00,$00,$78,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$78,

  11, // $5E '^'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$0A,$00,$11,$00,$20,$80,$40,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$80,$00,$00,

  9, // $60 '`'
  $00,$00,$00,$00,$00,$00,$10,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $61 'a'
  $00,$00,$00,$00,$00,$00,$1C,$22,$02,$3E,$42,$42,$46,$3A,$00,$00,$00,

  9, // $62 'b'
  $00,$00,$00,$00,$00,$00,$40,$00,$40,$00,$40,$00,$5C,$00,$62,$00,$41,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$00,$00,$00,$00,$00,$00,

  7, // $63 'c'
  $00,$00,$00,$00,$00,$00,$1C,$22,$40,$40,$40,$40,$22,$1C,$00,$00,$00,

  9, // $64 'd'
  $00,$00,$00,$00,$00,$00,$01,$00,$01,$00,$01,$00,$1F,$00,$21,$00,$41,$00,$41,$00,$41,$00,$41,$00,$23,$00,$1D,$00,$00,$00,$00,$00,$00,$00,

  8, // $65 'e'
  $00,$00,$00,$00,$00,$00,$18,$24,$42,$7E,$40,$40,$22,$1C,$00,$00,$00,

  6, // $66 'f'
  $00,$00,$00,$1C,$20,$20,$7C,$20,$20,$20,$20,$20,$20,$20,$00,$00,$00,

  9, // $67 'g'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$21,$00,$41,$00,$41,$00,$41,$00,$41,$00,$23,$00,$1D,$00,$01,$00,$22,$00,$1C,$00,

  9, // $68 'h'
  $00,$00,$00,$00,$00,$00,$40,$00,$40,$00,$40,$00,$5E,$00,$61,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  3, // $69 'i'
  $00,$00,$00,$00,$40,$00,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  5, // $6A 'j'
  $00,$00,$00,$00,$10,$00,$70,$10,$10,$10,$10,$10,$10,$10,$10,$10,$E0,

  8, // $6B 'k'
  $00,$00,$00,$40,$40,$40,$42,$44,$48,$50,$70,$48,$44,$42,$00,$00,$00,

  3, // $6C 'l'
  $00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  13, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$5C,$E0,$63,$10,$42,$10,$42,$10,$42,$10,$42,$10,$42,$10,$42,$10,$00,$00,$00,$00,$00,$00,

  9, // $6E 'n'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$5E,$00,$61,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  9, // $6F 'o'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$41,$00,$41,$00,$41,$00,$22,$00,$1C,$00,$00,$00,$00,$00,$00,$00,

  9, // $70 'p'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$5C,$00,$62,$00,$41,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$40,$00,$40,$00,$40,$00,

  9, // $71 'q'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$21,$00,$41,$00,$41,$00,$41,$00,$41,$00,$23,$00,$1D,$00,$01,$00,$01,$00,$01,$00,

  6, // $72 'r'
  $00,$00,$00,$00,$00,$00,$5C,$60,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  8, // $73 's'
  $00,$00,$00,$00,$00,$00,$3C,$42,$40,$30,$0C,$02,$42,$3C,$00,$00,$00,

  6, // $74 't'
  $00,$00,$00,$00,$20,$20,$7C,$20,$20,$20,$20,$20,$20,$1C,$00,$00,$00,

  9, // $75 'u'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$43,$00,$3D,$00,$00,$00,$00,$00,$00,$00,

  8, // $76 'v'
  $00,$00,$00,$00,$00,$00,$42,$42,$24,$24,$24,$18,$18,$18,$00,$00,$00,

  11, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$44,$40,$44,$40,$2A,$80,$2A,$80,$2A,$80,$2A,$80,$11,$00,$11,$00,$00,$00,$00,$00,$00,$00,

  9, // $78 'x'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$22,$00,$14,$00,$08,$00,$08,$00,$14,$00,$22,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  8, // $79 'y'
  $00,$00,$00,$00,$00,$00,$42,$42,$24,$24,$24,$18,$18,$18,$10,$10,$20,

  8, // $7A 'z'
  $00,$00,$00,$00,$00,$00,$7E,$02,$04,$08,$10,$20,$40,$7E,$00,$00,$00,

  9, // $7B '{'
  $00,$00,$00,$00,$00,$00,$07,$00,$08,$00,$08,$00,$08,$00,$08,$00,$10,$00,$60,$00,$10,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$07,$00,

  6, // $7C '|'
  $00,$00,$00,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,

  9, // $7D '}'
  $00,$00,$00,$00,$00,$00,$70,$00,$08,$00,$08,$00,$08,$00,$08,$00,$04,$00,$03,$00,$04,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$70,$00,

  11, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$38,$40,$44,$40,$44,$40,$43,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  14, // $7F ''
  $00,$00,$00,$00,$00,$00,$3F,$F8,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$3F,$F8,$00,$00,$00,$00,$00,$00,

  0 );

 verdana17_bold : array[0..3148 ] of int8u = (
  17, 4, 32, 128-32,
  $00,$00,$12,$00,$24,$00,$36,$00,$59,$00,$7C,$00,$B0,$00,$D3,$00,$E5,$00,
  $F7,$00,$09,$01,$2C,$01,$4F,$01,$61,$01,$73,$01,$85,$01,$A8,$01,$CB,$01,
  $EE,$01,$11,$02,$34,$02,$57,$02,$7A,$02,$9D,$02,$C0,$02,$E3,$02,$06,$03,
  $18,$03,$2A,$03,$4D,$03,$70,$03,$93,$03,$B6,$03,$D9,$03,$FC,$03,$1F,$04,
  $42,$04,$65,$04,$88,$04,$AB,$04,$CE,$04,$F1,$04,$03,$05,$15,$05,$38,$05,
  $5B,$05,$7E,$05,$A1,$05,$C4,$05,$E7,$05,$0A,$06,$2D,$06,$50,$06,$73,$06,
  $96,$06,$B9,$06,$DC,$06,$FF,$06,$22,$07,$45,$07,$57,$07,$7A,$07,$8C,$07,
  $AF,$07,$D2,$07,$F5,$07,$18,$08,$3B,$08,$4D,$08,$70,$08,$93,$08,$A5,$08,
  $C8,$08,$EB,$08,$FD,$08,$0F,$09,$32,$09,$44,$09,$67,$09,$8A,$09,$AD,$09,
  $D0,$09,$F3,$09,$05,$0A,$17,$0A,$29,$0A,$4C,$0A,$6F,$0A,$92,$0A,$B5,$0A,
  $D8,$0A,$EA,$0A,$0D,$0B,$1F,$0B,$42,$0B,$65,$0B,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$00,$00,$00,$30,$30,$30,$30,$30,$30,$30,$00,$30,$30,$00,$00,$00,

  8, // $22 '"'
  $00,$00,$00,$66,$66,$66,$66,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $23 '#'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$40,$04,$40,$3F,$E0,$3F,$E0,$08,$80,$11,$00,$7F,$C0,$7F,$C0,$22,$00,$22,$00,$00,$00,$00,$00,$00,$00,

  10, // $24 '$'
  $00,$00,$00,$00,$04,$00,$04,$00,$1F,$00,$34,$80,$64,$00,$74,$00,$3C,$00,$0F,$00,$0B,$80,$09,$80,$4B,$00,$3E,$00,$08,$00,$08,$00,$00,$00,

  18, // $25 '%'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3C,$08,$00,$66,$10,$00,$66,$20,$00,$66,$2F,$00,$66,$59,$80,$66,$99,$80,$3D,$19,$80,$01,$19,$80,$02,$19,$80,$04,$0F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $26 '&'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$33,$00,$36,$00,$1C,$60,$36,$60,$63,$60,$61,$C0,$31,$C0,$1F,$60,$00,$00,$00,$00,$00,$00,

  5, // $27 '''
  $00,$00,$00,$60,$60,$60,$60,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $28 '('
  $00,$00,$00,$0C,$18,$30,$30,$60,$60,$60,$60,$60,$60,$30,$30,$18,$0C,

  8, // $29 ')'
  $00,$00,$00,$30,$18,$0C,$0C,$06,$06,$06,$06,$06,$06,$0C,$0C,$18,$30,

  10, // $2A '*'
  $00,$00,$00,$00,$00,$00,$08,$00,$49,$00,$2A,$00,$1C,$00,$2A,$00,$49,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$04,$00,$04,$00,$04,$00,$7F,$C0,$04,$00,$04,$00,$04,$00,$04,$00,$00,$00,$00,$00,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$70,$60,$60,$C0,$C0,$00,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$30,$00,$00,$00,

  10, // $2F '/'
  $00,$00,$00,$00,$00,$00,$01,$80,$01,$80,$03,$00,$03,$00,$06,$00,$06,$00,$0C,$00,$18,$00,$18,$00,$30,$00,$30,$00,$60,$00,$60,$00,$00,$00,

  10, // $30 '0'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$33,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $31 '1'
  $00,$00,$00,$00,$00,$00,$00,$00,$0C,$00,$3C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$3F,$00,$00,$00,$00,$00,$00,$00,

  10, // $32 '2'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$61,$80,$61,$80,$01,$80,$03,$00,$06,$00,$0C,$00,$18,$00,$30,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  10, // $33 '3'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$61,$80,$61,$80,$01,$80,$0F,$00,$03,$00,$01,$80,$61,$80,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  10, // $34 '4'
  $00,$00,$00,$00,$00,$00,$00,$00,$03,$00,$07,$00,$0B,$00,$13,$00,$23,$00,$43,$00,$7F,$C0,$03,$00,$03,$00,$03,$00,$00,$00,$00,$00,$00,$00,

  10, // $35 '5'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$80,$30,$00,$30,$00,$3E,$00,$03,$00,$01,$80,$01,$80,$61,$80,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  10, // $36 '6'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$38,$00,$30,$00,$6E,$00,$73,$00,$61,$80,$61,$80,$61,$80,$33,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $37 '7'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$01,$80,$03,$00,$03,$00,$06,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$18,$00,$00,$00,$00,$00,$00,$00,

  10, // $38 '8'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$61,$80,$61,$80,$61,$80,$3F,$00,$61,$80,$61,$80,$61,$80,$61,$80,$3F,$00,$00,$00,$00,$00,$00,$00,

  10, // $39 '9'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$61,$80,$61,$80,$61,$80,$33,$80,$1D,$80,$03,$00,$07,$00,$3C,$00,$00,$00,$00,$00,$00,$00,

  6, // $3A ':'
  $00,$00,$00,$00,$00,$00,$30,$30,$30,$00,$00,$30,$30,$30,$00,$00,$00,

  6, // $3B ';'
  $00,$00,$00,$00,$00,$00,$30,$30,$30,$00,$00,$38,$30,$30,$60,$60,$00,

  12, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$C0,$03,$00,$0C,$00,$30,$00,$40,$00,$30,$00,$0C,$00,$03,$00,$00,$C0,$00,$00,$00,$00,$00,$00,

  12, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$C0,$00,$00,$00,$00,$00,$00,$7F,$C0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$60,$00,$18,$00,$06,$00,$01,$80,$00,$40,$01,$80,$06,$00,$18,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  9, // $3F '?'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$03,$00,$06,$00,$0C,$00,$18,$00,$18,$00,$00,$00,$18,$00,$18,$00,$00,$00,$00,$00,$00,$00,

  14, // $40 '@'
  $00,$00,$00,$00,$00,$00,$00,$00,$07,$C0,$18,$20,$20,$10,$27,$C8,$4C,$C8,$4C,$C8,$4C,$C8,$4C,$C8,$27,$F0,$20,$00,$18,$00,$07,$C0,$00,$00,

  11, // $41 'A'
  $00,$00,$00,$00,$00,$00,$00,$00,$0E,$00,$0E,$00,$0E,$00,$1B,$00,$1B,$00,$31,$80,$3F,$80,$31,$80,$60,$C0,$60,$C0,$00,$00,$00,$00,$00,$00,

  11, // $42 'B'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$61,$80,$61,$80,$61,$80,$7F,$00,$61,$80,$60,$C0,$60,$C0,$61,$80,$7F,$00,$00,$00,$00,$00,$00,$00,

  11, // $43 'C'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$30,$C0,$30,$C0,$60,$00,$60,$00,$60,$00,$60,$00,$30,$C0,$30,$C0,$0F,$80,$00,$00,$00,$00,$00,$00,

  11, // $44 'D'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$61,$80,$61,$80,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$61,$80,$61,$80,$7E,$00,$00,$00,$00,$00,$00,$00,

  10, // $45 'E'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$60,$00,$60,$00,$60,$00,$7F,$80,$60,$00,$60,$00,$60,$00,$60,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  9, // $46 'F'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$60,$00,$60,$00,$60,$00,$7F,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  11, // $47 'G'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$30,$C0,$30,$C0,$60,$00,$60,$00,$63,$C0,$60,$C0,$30,$C0,$30,$C0,$0F,$80,$00,$00,$00,$00,$00,$00,

  11, // $48 'H'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$7F,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$00,$00,$00,$00,$00,$00,

  8, // $49 'I'
  $00,$00,$00,$00,$7E,$18,$18,$18,$18,$18,$18,$18,$18,$7E,$00,$00,$00,

  8, // $4A 'J'
  $00,$00,$00,$00,$3E,$06,$06,$06,$06,$06,$06,$06,$0C,$F8,$00,$00,$00,

  11, // $4B 'K'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$61,$80,$63,$00,$66,$00,$6C,$00,$7C,$00,$76,$00,$63,$00,$61,$80,$60,$C0,$00,$00,$00,$00,$00,$00,

  9, // $4C 'L'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  13, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$70,$70,$70,$70,$F0,$58,$B0,$59,$B0,$4D,$30,$4F,$30,$46,$30,$46,$30,$40,$30,$00,$00,$00,$00,$00,$00,

  11, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$40,$70,$40,$58,$40,$4C,$40,$4C,$40,$46,$40,$43,$40,$43,$40,$41,$C0,$40,$C0,$00,$00,$00,$00,$00,$00,

  12, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$30,$C0,$60,$60,$60,$60,$60,$60,$60,$60,$30,$C0,$30,$C0,$0F,$00,$00,$00,$00,$00,$00,$00,

  10, // $50 'P'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$63,$00,$61,$80,$61,$80,$61,$80,$63,$00,$7E,$00,$60,$00,$60,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  12, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$30,$C0,$60,$60,$60,$60,$60,$60,$60,$60,$30,$C0,$30,$C0,$0F,$80,$03,$00,$03,$00,$01,$E0,

  11, // $52 'R'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$61,$80,$60,$C0,$60,$C0,$61,$80,$7F,$00,$63,$00,$61,$80,$60,$C0,$60,$60,$00,$00,$00,$00,$00,$00,

  10, // $53 'S'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$61,$80,$60,$00,$3E,$00,$1F,$00,$01,$80,$61,$80,$63,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  10, // $54 'T'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  11, // $55 'U'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$31,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  11, // $56 'V'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$60,$C0,$60,$C0,$31,$80,$31,$80,$31,$80,$1B,$00,$1B,$00,$0E,$00,$0E,$00,$00,$00,$00,$00,$00,$00,

  16, // $57 'W'
  $00,$00,$00,$00,$00,$00,$00,$00,$61,$86,$61,$86,$63,$C6,$32,$4C,$36,$6C,$36,$6C,$34,$2C,$1C,$38,$18,$18,$18,$18,$00,$00,$00,$00,$00,$00,

  11, // $58 'X'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$31,$80,$31,$80,$1B,$00,$0E,$00,$0E,$00,$1B,$00,$31,$80,$31,$80,$60,$C0,$00,$00,$00,$00,$00,$00,

  10, // $59 'Y'
  $00,$00,$00,$00,$00,$00,$00,$00,$C0,$C0,$61,$80,$61,$80,$33,$00,$1E,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  10, // $5A 'Z'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$01,$80,$03,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$30,$00,$60,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  8, // $5B '['
  $00,$00,$00,$3E,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$3E,

  10, // $5C '\'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$30,$00,$30,$00,$18,$00,$18,$00,$0C,$00,$06,$00,$06,$00,$03,$00,$03,$00,$01,$80,$01,$80,$00,$00,

  8, // $5D ']'
  $00,$00,$00,$7C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$7C,

  12, // $5E '^'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$0E,$00,$1B,$00,$31,$80,$60,$C0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$C0,$00,$00,

  10, // $60 '`'
  $00,$00,$00,$00,$00,$00,$18,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $61 'a'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$03,$00,$03,$00,$3F,$00,$63,$00,$63,$00,$63,$00,$3F,$00,$00,$00,$00,$00,$00,$00,

  10, // $62 'b'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$6E,$00,$73,$00,$61,$80,$61,$80,$61,$80,$61,$80,$63,$00,$7E,$00,$00,$00,$00,$00,$00,$00,

  8, // $63 'c'
  $00,$00,$00,$00,$00,$00,$1E,$33,$60,$60,$60,$60,$33,$1E,$00,$00,$00,

  10, // $64 'd'
  $00,$00,$00,$00,$00,$00,$01,$80,$01,$80,$01,$80,$1F,$80,$31,$80,$61,$80,$61,$80,$61,$80,$61,$80,$33,$80,$1D,$80,$00,$00,$00,$00,$00,$00,

  9, // $65 'e'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$63,$00,$7F,$00,$60,$00,$60,$00,$33,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  6, // $66 'f'
  $00,$00,$00,$1C,$30,$30,$7C,$30,$30,$30,$30,$30,$30,$30,$00,$00,$00,

  10, // $67 'g'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$80,$31,$80,$61,$80,$61,$80,$61,$80,$61,$80,$33,$80,$1D,$80,$01,$80,$03,$00,$3E,$00,

  10, // $68 'h'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$6F,$00,$71,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$00,$00,$00,$00,$00,$00,

  4, // $69 'i'
  $00,$00,$00,$60,$60,$00,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  6, // $6A 'j'
  $00,$00,$00,$18,$18,$00,$38,$18,$18,$18,$18,$18,$18,$18,$18,$18,$F0,

  9, // $6B 'k'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$63,$00,$66,$00,$6C,$00,$78,$00,$7C,$00,$66,$00,$63,$00,$61,$80,$00,$00,$00,$00,$00,$00,

  4, // $6C 'l'
  $00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  14, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6E,$70,$73,$98,$63,$18,$63,$18,$63,$18,$63,$18,$63,$18,$63,$18,$00,$00,$00,$00,$00,$00,

  10, // $6E 'n'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6F,$00,$71,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$00,$00,$00,$00,$00,$00,

  10, // $6F 'o'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$61,$80,$61,$80,$61,$80,$61,$80,$33,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $70 'p'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6E,$00,$73,$00,$61,$80,$61,$80,$61,$80,$61,$80,$63,$00,$7E,$00,$60,$00,$60,$00,$60,$00,

  10, // $71 'q'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$80,$31,$80,$61,$80,$61,$80,$61,$80,$61,$80,$33,$80,$1D,$80,$01,$80,$01,$80,$01,$80,

  7, // $72 'r'
  $00,$00,$00,$00,$00,$00,$6E,$7E,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  8, // $73 's'
  $00,$00,$00,$00,$00,$00,$3C,$62,$60,$7C,$3E,$06,$46,$3C,$00,$00,$00,

  6, // $74 't'
  $00,$00,$00,$00,$60,$60,$FC,$60,$60,$60,$60,$60,$60,$3C,$00,$00,$00,

  10, // $75 'u'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$63,$80,$3D,$80,$00,$00,$00,$00,$00,$00,

  9, // $76 'v'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$36,$00,$36,$00,$36,$00,$1C,$00,$1C,$00,$00,$00,$00,$00,$00,$00,

  14, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$18,$63,$18,$33,$30,$37,$B0,$34,$B0,$1C,$E0,$1C,$E0,$0C,$C0,$00,$00,$00,$00,$00,$00,

  9, // $78 'x'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$36,$00,$1C,$00,$1C,$00,$36,$00,$63,$00,$63,$00,$00,$00,$00,$00,$00,$00,

  9, // $79 'y'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$00,$63,$00,$63,$00,$36,$00,$36,$00,$36,$00,$1C,$00,$1C,$00,$0C,$00,$18,$00,$18,$00,

  8, // $7A 'z'
  $00,$00,$00,$00,$00,$00,$7E,$06,$0C,$18,$18,$30,$60,$7E,$00,$00,$00,

  10, // $7B '{'
  $00,$00,$00,$00,$00,$00,$07,$80,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$18,$00,$70,$00,$18,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$07,$80,

  8, // $7C '|'
  $00,$00,$00,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,

  10, // $7D '}'
  $00,$00,$00,$00,$00,$00,$78,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$06,$00,$03,$80,$06,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$78,$00,

  12, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$20,$24,$20,$46,$20,$42,$40,$41,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  14, // $7F ''
  $00,$00,$00,$00,$00,$00,$3F,$F8,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$3F,$F8,$00,$00,$00,$00,$00,$00,

  0 );

 verdana18 : array[0..3244 ] of int8u = (
  18, 4, 32, 128-32,
  $00,$00,$13,$00,$26,$00,$39,$00,$5E,$00,$83,$00,$A8,$00,$CD,$00,$E0,$00,
  $F3,$00,$06,$01,$2B,$01,$50,$01,$63,$01,$76,$01,$89,$01,$9C,$01,$C1,$01,
  $E6,$01,$0B,$02,$30,$02,$55,$02,$7A,$02,$9F,$02,$C4,$02,$E9,$02,$0E,$03,
  $21,$03,$34,$03,$59,$03,$7E,$03,$A3,$03,$B6,$03,$DB,$03,$00,$04,$25,$04,
  $4A,$04,$6F,$04,$94,$04,$B9,$04,$DE,$04,$03,$05,$16,$05,$29,$05,$4E,$05,
  $61,$05,$86,$05,$AB,$05,$D0,$05,$F5,$05,$1A,$06,$3F,$06,$64,$06,$89,$06,
  $AE,$06,$D3,$06,$F8,$06,$1D,$07,$42,$07,$67,$07,$7A,$07,$8D,$07,$A0,$07,
  $C5,$07,$EA,$07,$0F,$08,$34,$08,$59,$08,$6C,$08,$91,$08,$B6,$08,$C9,$08,
  $EE,$08,$13,$09,$26,$09,$39,$09,$5E,$09,$71,$09,$96,$09,$BB,$09,$E0,$09,
  $05,$0A,$2A,$0A,$3D,$0A,$50,$0A,$63,$0A,$88,$0A,$AD,$0A,$D2,$0A,$F7,$0A,
  $1C,$0B,$41,$0B,$66,$0B,$79,$0B,$9E,$0B,$C3,$0B,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$00,$00,$00,$20,$20,$20,$20,$20,$20,$20,$20,$00,$20,$20,$00,$00,$00,

  7, // $22 '"'
  $00,$00,$00,$48,$48,$48,$48,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $23 '#'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$80,$04,$80,$09,$00,$3F,$C0,$09,$00,$11,$00,$12,$00,$7F,$80,$12,$00,$24,$00,$24,$00,$00,$00,$00,$00,$00,$00,

  10, // $24 '$'
  $00,$00,$00,$00,$00,$00,$08,$00,$08,$00,$3E,$00,$49,$00,$48,$00,$48,$00,$38,$00,$0E,$00,$09,$00,$09,$00,$49,$00,$3E,$00,$08,$00,$08,$00,$08,$00,

  16, // $25 '%'
  $00,$00,$00,$00,$00,$00,$00,$00,$38,$20,$44,$40,$44,$40,$44,$80,$44,$80,$38,$9C,$01,$22,$01,$22,$02,$22,$02,$22,$04,$1C,$00,$00,$00,$00,$00,$00,

  12, // $26 '&'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$21,$00,$21,$00,$1E,$40,$24,$40,$42,$40,$41,$40,$40,$80,$21,$40,$1E,$20,$00,$00,$00,$00,$00,$00,

  4, // $27 '''
  $00,$00,$00,$40,$40,$40,$40,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  7, // $28 '('
  $00,$00,$00,$08,$10,$20,$20,$40,$40,$40,$40,$40,$40,$40,$20,$20,$10,$08,

  7, // $29 ')'
  $00,$00,$00,$20,$10,$08,$08,$04,$04,$04,$04,$04,$04,$04,$08,$08,$10,$20,

  10, // $2A '*'
  $00,$00,$00,$00,$00,$00,$08,$00,$49,$00,$2A,$00,$1C,$00,$2A,$00,$49,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$02,$00,$02,$00,$02,$00,$3F,$E0,$02,$00,$02,$00,$02,$00,$02,$00,$00,$00,$00,$00,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$20,$40,$40,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$20,$00,$00,$00,

  7, // $2F '/'
  $00,$00,$00,$02,$04,$04,$04,$08,$08,$10,$10,$20,$20,$40,$40,$40,$80,$00,

  10, // $30 '0'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $31 '1'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$00,$04,$00,$1C,$00,$04,$00,$04,$00,$04,$00,$04,$00,$04,$00,$04,$00,$04,$00,$1F,$00,$00,$00,$00,$00,$00,$00,

  10, // $32 '2'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$41,$00,$00,$80,$00,$80,$00,$80,$01,$00,$02,$00,$0C,$00,$30,$00,$40,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  10, // $33 '3'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$40,$80,$00,$80,$01,$00,$0E,$00,$01,$00,$00,$80,$00,$80,$00,$80,$41,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  10, // $34 '4'
  $00,$00,$00,$00,$00,$00,$00,$00,$01,$00,$03,$00,$05,$00,$09,$00,$11,$00,$21,$00,$41,$00,$7F,$C0,$01,$00,$01,$00,$01,$00,$00,$00,$00,$00,$00,$00,

  10, // $35 '5'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$80,$20,$00,$20,$00,$20,$00,$3E,$00,$01,$00,$00,$80,$00,$80,$00,$80,$41,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  10, // $36 '6'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$10,$00,$20,$00,$40,$00,$5E,$00,$61,$00,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $37 '7'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$01,$00,$02,$00,$02,$00,$04,$00,$04,$00,$08,$00,$08,$00,$10,$00,$10,$00,$20,$00,$00,$00,$00,$00,$00,$00,

  10, // $38 '8'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$21,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $39 '9'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$40,$80,$20,$80,$1F,$80,$00,$80,$01,$00,$02,$00,$3C,$00,$00,$00,$00,$00,$00,$00,

  7, // $3A ':'
  $00,$00,$00,$00,$00,$00,$00,$10,$10,$00,$00,$00,$00,$10,$10,$00,$00,$00,

  7, // $3B ';'
  $00,$00,$00,$00,$00,$00,$00,$10,$10,$00,$00,$00,$00,$10,$10,$10,$20,$20,

  12, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$C0,$03,$00,$0C,$00,$30,$00,$30,$00,$0C,$00,$03,$00,$00,$C0,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$E0,$00,$00,$00,$00,$3F,$E0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  12, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$00,$0C,$00,$03,$00,$00,$C0,$00,$C0,$03,$00,$0C,$00,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $3F '?'
  $00,$00,$00,$00,$3C,$42,$02,$02,$04,$08,$10,$10,$00,$10,$10,$00,$00,$00,

  15, // $40 '@'
  $00,$00,$00,$00,$00,$00,$00,$00,$07,$80,$18,$60,$20,$10,$23,$D0,$44,$48,$48,$48,$48,$48,$48,$48,$44,$48,$23,$F0,$20,$00,$18,$00,$07,$C0,$00,$00,

  10, // $41 'A'
  $00,$00,$00,$00,$00,$00,$00,$00,$0C,$00,$12,$00,$12,$00,$12,$00,$21,$00,$21,$00,$40,$80,$7F,$80,$40,$80,$80,$40,$80,$40,$00,$00,$00,$00,$00,$00,

  10, // $42 'B'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$41,$00,$41,$00,$41,$00,$7E,$00,$41,$00,$40,$80,$40,$80,$40,$80,$41,$00,$7E,$00,$00,$00,$00,$00,$00,$00,

  11, // $43 'C'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$20,$40,$40,$00,$40,$00,$40,$00,$40,$00,$40,$00,$20,$40,$30,$C0,$0F,$00,$00,$00,$00,$00,$00,$00,

  11, // $44 'D'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$41,$80,$40,$80,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$80,$41,$80,$7E,$00,$00,$00,$00,$00,$00,$00,

  9, // $45 'E'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$40,$00,$40,$00,$40,$00,$7F,$00,$40,$00,$40,$00,$40,$00,$40,$00,$40,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  9, // $46 'F'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$40,$00,$40,$00,$40,$00,$7F,$00,$40,$00,$40,$00,$40,$00,$40,$00,$40,$00,$40,$00,$00,$00,$00,$00,$00,$00,

  12, // $47 'G'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$30,$60,$20,$20,$40,$00,$40,$00,$41,$E0,$40,$20,$40,$20,$20,$20,$30,$20,$0F,$C0,$00,$00,$00,$00,$00,$00,

  11, // $48 'H'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$7F,$C0,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,$00,$00,$00,

  5, // $49 'I'
  $00,$00,$00,$00,$70,$20,$20,$20,$20,$20,$20,$20,$20,$20,$70,$00,$00,$00,

  7, // $4A 'J'
  $00,$00,$00,$00,$3C,$04,$04,$04,$04,$04,$04,$04,$04,$08,$F0,$00,$00,$00,

  10, // $4B 'K'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$80,$41,$00,$42,$00,$44,$00,$48,$00,$50,$00,$68,$00,$44,$00,$42,$00,$41,$00,$40,$80,$00,$00,$00,$00,$00,$00,

  8, // $4C 'L'
  $00,$00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$7F,$00,$00,$00,

  13, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$30,$50,$50,$50,$50,$48,$90,$48,$90,$45,$10,$45,$10,$42,$10,$42,$10,$40,$10,$40,$10,$00,$00,$00,$00,$00,$00,

  11, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$40,$60,$40,$50,$40,$48,$40,$48,$40,$44,$40,$42,$40,$42,$40,$41,$40,$40,$C0,$40,$40,$00,$00,$00,$00,$00,$00,

  12, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$20,$40,$40,$20,$40,$20,$40,$20,$40,$20,$40,$20,$20,$40,$30,$C0,$0F,$00,$00,$00,$00,$00,$00,$00,

  9, // $50 'P'
  $00,$00,$00,$00,$00,$00,$00,$00,$7E,$00,$41,$00,$40,$80,$40,$80,$40,$80,$41,$00,$7E,$00,$40,$00,$40,$00,$40,$00,$40,$00,$00,$00,$00,$00,$00,$00,

  12, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$00,$30,$C0,$20,$40,$40,$20,$40,$20,$40,$20,$40,$20,$40,$20,$20,$40,$30,$C0,$0F,$00,$01,$00,$01,$00,$00,$E0,

  10, // $52 'R'
  $00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$42,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$42,$00,$41,$00,$40,$80,$40,$40,$00,$00,$00,$00,$00,$00,

  10, // $53 'S'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$20,$80,$40,$00,$40,$00,$20,$00,$1E,$00,$01,$00,$00,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  9, // $54 'T'
  $00,$00,$00,$00,$00,$00,$00,$00,$FF,$80,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  11, // $55 'U'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$20,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  10, // $56 'V'
  $00,$00,$00,$00,$00,$00,$00,$00,$80,$40,$80,$40,$40,$80,$40,$80,$40,$80,$21,$00,$21,$00,$12,$00,$12,$00,$12,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  15, // $57 'W'
  $00,$00,$00,$00,$00,$00,$00,$00,$41,$04,$41,$04,$22,$88,$22,$88,$22,$88,$12,$90,$14,$50,$14,$50,$14,$50,$08,$20,$08,$20,$00,$00,$00,$00,$00,$00,

  10, // $58 'X'
  $00,$00,$00,$00,$00,$00,$00,$00,$40,$80,$21,$00,$21,$00,$12,$00,$0C,$00,$0C,$00,$0C,$00,$12,$00,$21,$00,$21,$00,$40,$80,$00,$00,$00,$00,$00,$00,

  9, // $59 'Y'
  $00,$00,$00,$00,$00,$00,$00,$00,$80,$80,$41,$00,$22,$00,$22,$00,$14,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  10, // $5A 'Z'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$00,$80,$01,$00,$02,$00,$04,$00,$08,$00,$08,$00,$10,$00,$20,$00,$40,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  7, // $5B '['
  $00,$00,$00,$3C,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$3C,

  7, // $5C '\'
  $00,$00,$00,$80,$40,$40,$40,$20,$20,$10,$10,$08,$08,$04,$04,$04,$02,$00,

  7, // $5D ']'
  $00,$00,$00,$78,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$78,

  12, // $5E '^'
  $00,$00,$00,$00,$00,$00,$00,$00,$06,$00,$09,$00,$10,$80,$20,$40,$40,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$C0,$00,$00,

  10, // $60 '`'
  $00,$00,$00,$00,$00,$00,$10,$00,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  9, // $61 'a'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$01,$00,$3F,$00,$41,$00,$41,$00,$43,$00,$3D,$00,$00,$00,$00,$00,$00,$00,

  9, // $62 'b'
  $00,$00,$00,$00,$00,$00,$40,$00,$40,$00,$40,$00,$40,$00,$5C,$00,$62,$00,$41,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$00,$00,$00,$00,$00,$00,

  8, // $63 'c'
  $00,$00,$00,$00,$00,$00,$00,$1E,$21,$40,$40,$40,$40,$21,$1E,$00,$00,$00,

  9, // $64 'd'
  $00,$00,$00,$00,$00,$00,$01,$00,$01,$00,$01,$00,$01,$00,$1F,$00,$21,$00,$41,$00,$41,$00,$41,$00,$41,$00,$23,$00,$1D,$00,$00,$00,$00,$00,$00,$00,

  9, // $65 'e'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1C,$00,$22,$00,$41,$00,$7F,$00,$40,$00,$40,$00,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  6, // $66 'f'
  $00,$00,$00,$1C,$20,$20,$20,$7C,$20,$20,$20,$20,$20,$20,$20,$00,$00,$00,

  9, // $67 'g'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$21,$00,$41,$00,$41,$00,$41,$00,$41,$00,$23,$00,$1D,$00,$01,$00,$22,$00,$1C,$00,

  9, // $68 'h'
  $00,$00,$00,$00,$00,$00,$40,$00,$40,$00,$40,$00,$40,$00,$5E,$00,$61,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  3, // $69 'i'
  $00,$00,$00,$00,$40,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  5, // $6A 'j'
  $00,$00,$00,$00,$10,$00,$00,$70,$10,$10,$10,$10,$10,$10,$10,$10,$10,$E0,

  9, // $6B 'k'
  $00,$00,$00,$00,$00,$00,$40,$00,$40,$00,$40,$00,$40,$00,$42,$00,$44,$00,$48,$00,$50,$00,$68,$00,$44,$00,$42,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  3, // $6C 'l'
  $00,$00,$00,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  15, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$2E,$70,$31,$88,$21,$08,$21,$08,$21,$08,$21,$08,$21,$08,$21,$08,$00,$00,$00,$00,$00,$00,

  9, // $6E 'n'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$5E,$00,$61,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  10, // $6F 'o'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$21,$00,$40,$80,$40,$80,$40,$80,$40,$80,$21,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  9, // $70 'p'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$5C,$00,$62,$00,$41,$00,$41,$00,$41,$00,$41,$00,$42,$00,$7C,$00,$40,$00,$40,$00,$40,$00,

  9, // $71 'q'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$21,$00,$41,$00,$41,$00,$41,$00,$41,$00,$23,$00,$1D,$00,$01,$00,$01,$00,$01,$00,

  6, // $72 'r'
  $00,$00,$00,$00,$00,$00,$00,$5C,$60,$40,$40,$40,$40,$40,$40,$00,$00,$00,

  8, // $73 's'
  $00,$00,$00,$00,$00,$00,$00,$3C,$42,$40,$30,$0C,$02,$42,$3C,$00,$00,$00,

  6, // $74 't'
  $00,$00,$00,$00,$00,$20,$20,$7C,$20,$20,$20,$20,$20,$20,$1C,$00,$00,$00,

  9, // $75 'u'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$41,$00,$43,$00,$3D,$00,$00,$00,$00,$00,$00,$00,

  9, // $76 'v'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$22,$00,$22,$00,$22,$00,$14,$00,$14,$00,$08,$00,$00,$00,$00,$00,$00,$00,

  13, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$42,$10,$42,$10,$25,$20,$25,$20,$28,$A0,$28,$A0,$10,$40,$10,$40,$00,$00,$00,$00,$00,$00,

  9, // $78 'x'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$22,$00,$14,$00,$08,$00,$08,$00,$14,$00,$22,$00,$41,$00,$00,$00,$00,$00,$00,$00,

  9, // $79 'y'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$41,$00,$41,$00,$22,$00,$22,$00,$22,$00,$14,$00,$14,$00,$08,$00,$08,$00,$10,$00,$10,$00,

  9, // $7A 'z'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$02,$00,$04,$00,$08,$00,$10,$00,$20,$00,$40,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  10, // $7B '{'
  $00,$00,$00,$00,$00,$00,$07,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$10,$00,$60,$00,$10,$00,$08,$00,$08,$00,$08,$00,$08,$00,$08,$00,$07,$00,

  7, // $7C '|'
  $00,$00,$00,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,$10,

  10, // $7D '}'
  $00,$00,$00,$00,$00,$00,$38,$00,$04,$00,$04,$00,$04,$00,$04,$00,$04,$00,$02,$00,$01,$80,$02,$00,$04,$00,$04,$00,$04,$00,$04,$00,$04,$00,$38,$00,

  12, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$20,$24,$20,$42,$40,$41,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  15, // $7F ''
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$F8,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$3F,$F8,$00,$00,$00,$00,$00,$00,

  0 );

 verdana18_bold : array[0..3370 ] of int8u = (
  18, 4, 32, 128-32,
  $00,$00,$13,$00,$26,$00,$4B,$00,$70,$00,$95,$00,$CC,$00,$F1,$00,$04,$01,
  $17,$01,$2A,$01,$4F,$01,$74,$01,$87,$01,$9A,$01,$AD,$01,$D2,$01,$F7,$01,
  $1C,$02,$41,$02,$66,$02,$8B,$02,$B0,$02,$D5,$02,$FA,$02,$1F,$03,$44,$03,
  $57,$03,$6A,$03,$8F,$03,$B4,$03,$D9,$03,$FE,$03,$23,$04,$48,$04,$6D,$04,
  $92,$04,$B7,$04,$DC,$04,$01,$05,$26,$05,$4B,$05,$5E,$05,$71,$05,$96,$05,
  $BB,$05,$E0,$05,$05,$06,$2A,$06,$4F,$06,$74,$06,$99,$06,$BE,$06,$E3,$06,
  $08,$07,$2D,$07,$52,$07,$77,$07,$9C,$07,$C1,$07,$D4,$07,$F9,$07,$0C,$08,
  $31,$08,$56,$08,$7B,$08,$A0,$08,$C5,$08,$D8,$08,$FD,$08,$22,$09,$35,$09,
  $5A,$09,$7F,$09,$92,$09,$A5,$09,$CA,$09,$DD,$09,$02,$0A,$27,$0A,$4C,$0A,
  $71,$0A,$96,$0A,$A9,$0A,$CE,$0A,$E1,$0A,$06,$0B,$2B,$0B,$50,$0B,$75,$0B,
  $9A,$0B,$BF,$0B,$E4,$0B,$F7,$0B,$1C,$0C,$41,$0C,

  5, // $20 ' '
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  6, // $21 '!'
  $00,$00,$00,$00,$30,$30,$30,$30,$30,$30,$30,$30,$00,$30,$30,$00,$00,$00,

  9, // $22 '"'
  $00,$00,$00,$00,$00,$00,$36,$00,$36,$00,$36,$00,$36,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  13, // $23 '#'
  $00,$00,$00,$00,$00,$00,$00,$00,$04,$20,$04,$20,$08,$40,$3F,$F0,$3F,$F0,$08,$40,$10,$80,$7F,$E0,$7F,$E0,$21,$00,$21,$00,$00,$00,$00,$00,$00,$00,

  11, // $24 '$'
  $00,$00,$00,$00,$00,$00,$04,$00,$04,$00,$1F,$80,$34,$C0,$64,$C0,$64,$00,$3C,$00,$07,$80,$04,$C0,$64,$C0,$65,$80,$3F,$00,$04,$00,$04,$00,$00,$00,

  19, // $25 '%'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$08,$00,$63,$10,$00,$63,$10,$00,$63,$20,$00,$63,$2F,$80,$63,$58,$C0,$3E,$98,$C0,$00,$98,$C0,$01,$18,$C0,$01,$18,$C0,$02,$0F,$80,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  13, // $26 '&'
  $00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$33,$00,$33,$00,$1E,$60,$36,$60,$63,$60,$61,$C0,$60,$C0,$30,$E0,$1F,$30,$00,$00,$00,$00,$00,$00,

  5, // $27 '''
  $00,$00,$00,$60,$60,$60,$60,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  8, // $28 '('
  $00,$00,$00,$06,$0C,$18,$30,$30,$60,$60,$60,$60,$60,$30,$30,$18,$0C,$06,

  8, // $29 ')'
  $00,$00,$00,$60,$30,$18,$0C,$0C,$06,$06,$06,$06,$06,$0C,$0C,$18,$30,$60,

  11, // $2A '*'
  $00,$00,$00,$00,$00,$00,$04,$00,$24,$80,$15,$00,$0E,$00,$15,$00,$24,$80,$04,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  13, // $2B '+'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$02,$00,$02,$00,$02,$00,$3F,$E0,$02,$00,$02,$00,$02,$00,$02,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $2C ','
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$70,$60,$60,$60,$C0,$C0,

  7, // $2D '-'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,$00,$00,$00,$00,$00,$00,$00,$00,

  5, // $2E '.'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$30,$30,$30,$00,$00,$00,

  10, // $2F '/'
  $00,$00,$00,$00,$00,$00,$01,$80,$01,$80,$03,$00,$03,$00,$06,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$18,$00,$30,$00,$30,$00,$60,$00,$60,$00,$00,$00,

  11, // $30 '0'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$60,$C0,$31,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  11, // $31 '1'
  $00,$00,$00,$00,$00,$00,$00,$00,$06,$00,$1E,$00,$06,$00,$06,$00,$06,$00,$06,$00,$06,$00,$06,$00,$06,$00,$06,$00,$1F,$80,$00,$00,$00,$00,$00,$00,

  11, // $32 '2'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$61,$80,$60,$C0,$00,$C0,$01,$80,$03,$00,$06,$00,$0C,$00,$18,$00,$30,$00,$7F,$C0,$00,$00,$00,$00,$00,$00,

  11, // $33 '3'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$61,$80,$60,$C0,$00,$C0,$01,$80,$0F,$00,$01,$80,$00,$C0,$60,$C0,$61,$80,$3F,$00,$00,$00,$00,$00,$00,$00,

  11, // $34 '4'
  $00,$00,$00,$00,$00,$00,$00,$00,$01,$80,$03,$80,$05,$80,$09,$80,$11,$80,$21,$80,$41,$80,$7F,$E0,$01,$80,$01,$80,$01,$80,$00,$00,$00,$00,$00,$00,

  11, // $35 '5'
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$C0,$30,$00,$30,$00,$30,$00,$3F,$00,$01,$80,$00,$C0,$00,$C0,$60,$C0,$61,$80,$3F,$00,$00,$00,$00,$00,$00,$00,

  11, // $36 '6'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$18,$00,$30,$00,$60,$00,$6F,$00,$71,$80,$60,$C0,$60,$C0,$60,$C0,$31,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  11, // $37 '7'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$C0,$00,$C0,$01,$80,$01,$80,$03,$00,$03,$00,$06,$00,$06,$00,$0C,$00,$0C,$00,$18,$00,$00,$00,$00,$00,$00,$00,

  11, // $38 '8'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$60,$C0,$60,$C0,$31,$80,$1F,$00,$31,$80,$60,$C0,$60,$C0,$31,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  11, // $39 '9'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$00,$31,$80,$60,$C0,$60,$C0,$60,$C0,$31,$C0,$1E,$C0,$00,$C0,$01,$80,$03,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  6, // $3A ':'
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$30,$00,$00,$30,$30,$30,$00,$00,$00,

  6, // $3B ';'
  $00,$00,$00,$00,$00,$00,$00,$30,$30,$30,$00,$00,$38,$30,$30,$30,$60,$60,

  13, // $3C '<'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$00,$C0,$03,$00,$0C,$00,$30,$00,$30,$00,$0C,$00,$03,$00,$00,$C0,$00,$20,$00,$00,$00,$00,$00,$00,

  13, // $3D '='
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$E0,$00,$00,$00,$00,$00,$00,$3F,$E0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  13, // $3E '>'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$00,$18,$00,$06,$00,$01,$80,$00,$60,$00,$60,$01,$80,$06,$00,$18,$00,$20,$00,$00,$00,$00,$00,$00,$00,

  9, // $3F '?'
  $00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$63,$00,$03,$00,$03,$00,$06,$00,$0C,$00,$18,$00,$18,$00,$00,$00,$18,$00,$18,$00,$00,$00,$00,$00,$00,$00,

  14, // $40 '@'
  $00,$00,$00,$00,$00,$00,$00,$00,$07,$80,$18,$60,$20,$10,$27,$D0,$4C,$C8,$4C,$C8,$4C,$C8,$4C,$C8,$4C,$C8,$27,$F0,$20,$00,$18,$00,$07,$C0,$00,$00,

  12, // $41 'A'
  $00,$00,$00,$00,$00,$00,$00,$00,$06,$00,$06,$00,$0F,$00,$0F,$00,$19,$80,$19,$80,$30,$C0,$3F,$C0,$30,$C0,$60,$60,$60,$60,$00,$00,$00,$00,$00,$00,

  11, // $42 'B'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$61,$80,$61,$80,$61,$80,$63,$00,$7F,$00,$61,$80,$60,$C0,$60,$C0,$61,$80,$7F,$00,$00,$00,$00,$00,$00,$00,

  11, // $43 'C'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$38,$C0,$30,$C0,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$30,$C0,$38,$C0,$0F,$80,$00,$00,$00,$00,$00,$00,

  12, // $44 'D'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$61,$C0,$60,$C0,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$C0,$61,$C0,$7F,$00,$00,$00,$00,$00,$00,$00,

  10, // $45 'E'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$60,$00,$60,$00,$60,$00,$60,$00,$7F,$80,$60,$00,$60,$00,$60,$00,$60,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  10, // $46 'F'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$60,$00,$60,$00,$60,$00,$60,$00,$7F,$80,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  12, // $47 'G'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$C0,$38,$60,$30,$60,$60,$00,$60,$00,$63,$E0,$60,$60,$60,$60,$30,$60,$38,$60,$0F,$C0,$00,$00,$00,$00,$00,$00,

  12, // $48 'H'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$7F,$E0,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,$00,$00,$00,$00,

  8, // $49 'I'
  $00,$00,$00,$00,$7E,$18,$18,$18,$18,$18,$18,$18,$18,$18,$7E,$00,$00,$00,

  8, // $4A 'J'
  $00,$00,$00,$00,$3E,$06,$06,$06,$06,$06,$06,$06,$06,$0C,$F8,$00,$00,$00,

  12, // $4B 'K'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$60,$C0,$61,$80,$63,$00,$66,$00,$6C,$00,$7E,$00,$73,$00,$61,$80,$60,$C0,$60,$60,$00,$00,$00,$00,$00,$00,

  10, // $4C 'L'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$60,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  14, // $4D 'M'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$38,$70,$38,$70,$78,$58,$58,$58,$D8,$4C,$98,$4D,$98,$47,$18,$47,$18,$42,$18,$40,$18,$00,$00,$00,$00,$00,$00,

  12, // $4E 'N'
  $00,$00,$00,$00,$00,$00,$00,$00,$70,$20,$70,$20,$58,$20,$4C,$20,$4C,$20,$46,$20,$43,$20,$43,$20,$41,$A0,$40,$E0,$40,$E0,$00,$00,$00,$00,$00,$00,

  13, // $4F 'O'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$38,$E0,$30,$60,$60,$30,$60,$30,$60,$30,$60,$30,$60,$30,$30,$60,$38,$E0,$0F,$80,$00,$00,$00,$00,$00,$00,

  11, // $50 'P'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$61,$80,$60,$C0,$60,$C0,$60,$C0,$61,$80,$7F,$00,$60,$00,$60,$00,$60,$00,$60,$00,$00,$00,$00,$00,$00,$00,

  13, // $51 'Q'
  $00,$00,$00,$00,$00,$00,$00,$00,$0F,$80,$38,$E0,$30,$60,$60,$30,$60,$30,$60,$30,$60,$30,$60,$30,$30,$60,$38,$E0,$0F,$80,$03,$00,$03,$80,$01,$F0,

  12, // $52 'R'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$61,$80,$60,$C0,$60,$C0,$60,$C0,$61,$80,$7F,$00,$61,$80,$60,$C0,$60,$60,$60,$30,$00,$00,$00,$00,$00,$00,

  11, // $53 'S'
  $00,$00,$00,$00,$00,$00,$00,$00,$1F,$80,$30,$C0,$60,$C0,$60,$00,$7C,$00,$3F,$80,$03,$C0,$00,$C0,$60,$C0,$61,$80,$3F,$00,$00,$00,$00,$00,$00,$00,

  10, // $54 'T'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  12, // $55 'U'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$30,$C0,$1F,$80,$00,$00,$00,$00,$00,$00,

  11, // $56 'V'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$60,$C0,$60,$C0,$31,$80,$31,$80,$31,$80,$1B,$00,$1B,$00,$1B,$00,$0E,$00,$0E,$00,$00,$00,$00,$00,$00,$00,

  16, // $57 'W'
  $00,$00,$00,$00,$00,$00,$00,$00,$61,$86,$61,$86,$63,$C6,$33,$CC,$32,$4C,$32,$4C,$1E,$78,$1C,$38,$1C,$38,$0C,$30,$0C,$30,$00,$00,$00,$00,$00,$00,

  11, // $58 'X'
  $00,$00,$00,$00,$00,$00,$00,$00,$60,$C0,$31,$80,$31,$80,$1B,$00,$0E,$00,$0E,$00,$0E,$00,$1B,$00,$31,$80,$31,$80,$60,$C0,$00,$00,$00,$00,$00,$00,

  11, // $59 'Y'
  $00,$00,$00,$00,$00,$00,$00,$00,$C0,$C0,$61,$80,$61,$80,$33,$00,$1E,$00,$1E,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  10, // $5A 'Z'
  $00,$00,$00,$00,$00,$00,$00,$00,$7F,$80,$01,$80,$03,$00,$06,$00,$06,$00,$0C,$00,$18,$00,$18,$00,$30,$00,$60,$00,$7F,$80,$00,$00,$00,$00,$00,$00,

  8, // $5B '['
  $00,$00,$00,$3E,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$3E,

  10, // $5C '\'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$30,$00,$30,$00,$18,$00,$18,$00,$0C,$00,$0C,$00,$06,$00,$06,$00,$03,$00,$03,$00,$01,$80,$01,$80,$00,$00,

  8, // $5D ']'
  $00,$00,$00,$7C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$7C,

  13, // $5E '^'
  $00,$00,$00,$00,$00,$00,$00,$00,$06,$00,$0F,$00,$19,$80,$30,$C0,$60,$60,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  11, // $5F '_'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$E0,$00,$00,

  11, // $60 '`'
  $00,$00,$00,$00,$00,$00,$00,$00,$18,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  10, // $61 'a'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$00,$01,$80,$01,$80,$3F,$80,$61,$80,$61,$80,$63,$80,$3D,$80,$00,$00,$00,$00,$00,$00,

  10, // $62 'b'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$60,$00,$6E,$00,$73,$00,$61,$80,$61,$80,$61,$80,$61,$80,$63,$00,$7E,$00,$00,$00,$00,$00,$00,$00,

  8, // $63 'c'
  $00,$00,$00,$00,$00,$00,$00,$1E,$33,$60,$60,$60,$60,$33,$1E,$00,$00,$00,

  10, // $64 'd'
  $00,$00,$00,$00,$00,$00,$01,$80,$01,$80,$01,$80,$01,$80,$1F,$80,$31,$80,$61,$80,$61,$80,$61,$80,$61,$80,$33,$80,$1D,$80,$00,$00,$00,$00,$00,$00,

  10, // $65 'e'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$61,$80,$7F,$80,$60,$00,$60,$00,$31,$80,$1F,$00,$00,$00,$00,$00,$00,$00,

  6, // $66 'f'
  $00,$00,$00,$1C,$30,$30,$30,$7C,$30,$30,$30,$30,$30,$30,$30,$00,$00,$00,

  10, // $67 'g'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$80,$31,$80,$61,$80,$61,$80,$61,$80,$61,$80,$33,$80,$1D,$80,$01,$80,$03,$00,$3E,$00,

  10, // $68 'h'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$60,$00,$6F,$00,$71,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$00,$00,$00,$00,$00,$00,

  4, // $69 'i'
  $00,$00,$00,$60,$60,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  6, // $6A 'j'
  $00,$00,$00,$18,$18,$00,$00,$78,$18,$18,$18,$18,$18,$18,$18,$18,$18,$F0,

  10, // $6B 'k'
  $00,$00,$00,$00,$00,$00,$60,$00,$60,$00,$60,$00,$60,$00,$61,$80,$63,$00,$66,$00,$6C,$00,$7E,$00,$73,$00,$61,$80,$60,$C0,$00,$00,$00,$00,$00,$00,

  4, // $6C 'l'
  $00,$00,$00,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  16, // $6D 'm'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6F,$3C,$71,$C6,$61,$86,$61,$86,$61,$86,$61,$86,$61,$86,$61,$86,$00,$00,$00,$00,$00,$00,

  10, // $6E 'n'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6F,$00,$71,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$00,$00,$00,$00,$00,$00,

  10, // $6F 'o'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$00,$33,$00,$61,$80,$61,$80,$61,$80,$61,$80,$33,$00,$1E,$00,$00,$00,$00,$00,$00,$00,

  10, // $70 'p'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$6E,$00,$73,$00,$61,$80,$61,$80,$61,$80,$61,$80,$63,$00,$7E,$00,$60,$00,$60,$00,$60,$00,

  10, // $71 'q'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$80,$31,$80,$61,$80,$61,$80,$61,$80,$61,$80,$33,$80,$1D,$80,$01,$80,$01,$80,$01,$80,

  7, // $72 'r'
  $00,$00,$00,$00,$00,$00,$00,$6E,$7E,$60,$60,$60,$60,$60,$60,$00,$00,$00,

  9, // $73 's'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$00,$61,$00,$60,$00,$7E,$00,$3F,$00,$03,$00,$43,$00,$3E,$00,$00,$00,$00,$00,$00,$00,

  7, // $74 't'
  $00,$00,$00,$00,$00,$30,$30,$7E,$30,$30,$30,$30,$30,$30,$1E,$00,$00,$00,

  10, // $75 'u'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$61,$80,$63,$80,$3D,$80,$00,$00,$00,$00,$00,$00,

  10, // $76 'v'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$33,$00,$33,$00,$33,$00,$1E,$00,$1E,$00,$0C,$00,$00,$00,$00,$00,$00,$00,

  14, // $77 'w'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$63,$18,$63,$18,$63,$18,$37,$B0,$34,$B0,$3C,$F0,$18,$60,$18,$60,$00,$00,$00,$00,$00,$00,

  10, // $78 'x'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$33,$00,$33,$00,$1E,$00,$1E,$00,$33,$00,$33,$00,$61,$80,$00,$00,$00,$00,$00,$00,

  10, // $79 'y'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$61,$80,$61,$80,$33,$00,$33,$00,$33,$00,$1E,$00,$1E,$00,$0C,$00,$0C,$00,$18,$00,$18,$00,

  9, // $7A 'z'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7F,$00,$03,$00,$06,$00,$0C,$00,$18,$00,$30,$00,$60,$00,$7F,$00,$00,$00,$00,$00,$00,$00,

  11, // $7B '{'
  $00,$00,$00,$00,$00,$00,$07,$80,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$18,$00,$70,$00,$18,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$0C,$00,$07,$80,

  8, // $7C '|'
  $00,$00,$00,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,$18,

  11, // $7D '}'
  $00,$00,$00,$00,$00,$00,$3C,$00,$06,$00,$06,$00,$06,$00,$06,$00,$06,$00,$03,$00,$01,$C0,$03,$00,$06,$00,$06,$00,$06,$00,$06,$00,$06,$00,$3C,$00,

  13, // $7E '~'
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$18,$10,$24,$10,$42,$10,$41,$20,$40,$C0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

  15, // $7F ''
  $00,$00,$00,$00,$00,$00,$00,$00,$3F,$F8,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$20,$08,$3F,$F8,$00,$00,$00,$00,$00,$00,

  0 );

{ GLOBAL PROCEDURES }


IMPLEMENTATION
{ LOCAL VARIABLES & CONSTANTS }
{ UNIT IMPLEMENTATION }

END.

