
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_BezierCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_BezierCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_BezierCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>

// module includes
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Line2d.hxx>
#include <Adaptor2d_OffsetCurve.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Adaptor2d(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Adaptor2d"));
py::object klass;

//Python trampoline classes

// classes

    // Class Adaptor2d_Curve2d from ./opencascade/Adaptor2d_Curve2d.hxx
    klass = m.attr("Adaptor2d_Curve2d");

    // default constructor
    register_default_constructor<Adaptor2d_Curve2d ,opencascade::handle<Adaptor2d_Curve2d>>(m,"Adaptor2d_Curve2d");

    // nested enums

    static_cast<py::class_<Adaptor2d_Curve2d ,opencascade::handle<Adaptor2d_Curve2d>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ShallowCopy",
             (handle<Adaptor2d_Curve2d> (Adaptor2d_Curve2d::*)() const) static_cast<handle<Adaptor2d_Curve2d> (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("FirstParameter",
             (Standard_Real (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Real (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::FirstParameter),
             R"#()#" 
          )
        .def("LastParameter",
             (Standard_Real (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Real (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::LastParameter),
             R"#()#" 
          )
        .def("Continuity",
             (GeomAbs_Shape (Adaptor2d_Curve2d::*)() const) static_cast<GeomAbs_Shape (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Continuity),
             R"#()#" 
          )
        .def("NbIntervals",
             (Standard_Integer (Adaptor2d_Curve2d::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor2d_Curve2d::*)(  const GeomAbs_Shape  ) const>(&Adaptor2d_Curve2d::NbIntervals),
             R"#(If necessary, breaks the curve in intervals of continuity <S>. And returns the number of intervals.)#"  , py::arg("S")
          )
        .def("Intervals",
             (void (Adaptor2d_Curve2d::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor2d_Curve2d::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor2d_Curve2d::Intervals),
             R"#(Stores in <T> the parameters bounding the intervals of continuity <S>.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("Trim",
             (handle<Adaptor2d_Curve2d> (Adaptor2d_Curve2d::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor2d_Curve2d> (Adaptor2d_Curve2d::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor2d_Curve2d::Trim),
             R"#(Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsClosed",
             (Standard_Boolean (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Boolean (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::IsClosed),
             R"#()#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Boolean (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::IsPeriodic),
             R"#()#" 
          )
        .def("Period",
             (Standard_Real (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Real (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Period),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt2d (Adaptor2d_Curve2d::*)(  const Standard_Real  ) const) static_cast<gp_Pnt2d (Adaptor2d_Curve2d::*)(  const Standard_Real  ) const>(&Adaptor2d_Curve2d::Value),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U")
          )
        .def("D0",
             (void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d &  ) const) static_cast<void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d &  ) const>(&Adaptor2d_Curve2d::D0),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("D1",
             (void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_Curve2d::D1),
             R"#(Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V")
          )
        .def("D2",
             (void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_Curve2d::D2),
             R"#(Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def("D3",
             (void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_Curve2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_Curve2d::D3),
             R"#(Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def("DN",
             (gp_Vec2d (Adaptor2d_Curve2d::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec2d (Adaptor2d_Curve2d::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Adaptor2d_Curve2d::DN),
             R"#(The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.)#"  , py::arg("U"),  py::arg("N")
          )
        .def("Resolution",
             (Standard_Real (Adaptor2d_Curve2d::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor2d_Curve2d::*)(  const Standard_Real  ) const>(&Adaptor2d_Curve2d::Resolution),
             R"#(Returns the parametric resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_CurveType (Adaptor2d_Curve2d::*)() const) static_cast<GeomAbs_CurveType (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::GetType),
             R"#(Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.)#" 
          )
        .def("Line",
             (gp_Lin2d (Adaptor2d_Curve2d::*)() const) static_cast<gp_Lin2d (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Line),
             R"#()#" 
          )
        .def("Circle",
             (gp_Circ2d (Adaptor2d_Curve2d::*)() const) static_cast<gp_Circ2d (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Circle),
             R"#()#" 
          )
        .def("Ellipse",
             (gp_Elips2d (Adaptor2d_Curve2d::*)() const) static_cast<gp_Elips2d (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Ellipse),
             R"#()#" 
          )
        .def("Hyperbola",
             (gp_Hypr2d (Adaptor2d_Curve2d::*)() const) static_cast<gp_Hypr2d (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Hyperbola),
             R"#()#" 
          )
        .def("Parabola",
             (gp_Parab2d (Adaptor2d_Curve2d::*)() const) static_cast<gp_Parab2d (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Parabola),
             R"#()#" 
          )
        .def("Degree",
             (Standard_Integer (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Integer (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Degree),
             R"#()#" 
          )
        .def("IsRational",
             (Standard_Boolean (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Boolean (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::IsRational),
             R"#()#" 
          )
        .def("NbPoles",
             (Standard_Integer (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Integer (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::NbPoles),
             R"#()#" 
          )
        .def("NbKnots",
             (Standard_Integer (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Integer (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::NbKnots),
             R"#()#" 
          )
        .def("NbSamples",
             (Standard_Integer (Adaptor2d_Curve2d::*)() const) static_cast<Standard_Integer (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::NbSamples),
             R"#()#" 
          )
        .def("Bezier",
             (handle<Geom2d_BezierCurve> (Adaptor2d_Curve2d::*)() const) static_cast<handle<Geom2d_BezierCurve> (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::Bezier),
             R"#()#" 
          )
        .def("BSpline",
             (handle<Geom2d_BSplineCurve> (Adaptor2d_Curve2d::*)() const) static_cast<handle<Geom2d_BSplineCurve> (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::BSpline),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor2d_Curve2d::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor2d_Curve2d::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor2d_Curve2d::*)() const) static_cast< const handle<Standard_Type> & (Adaptor2d_Curve2d::*)() const>(&Adaptor2d_Curve2d::DynamicType),
             R"#()#"
             
         )
;

    // Class Adaptor2d_Line2d from ./opencascade/Adaptor2d_Line2d.hxx
    klass = m.attr("Adaptor2d_Line2d");


    // nested enums

    static_cast<py::class_<Adaptor2d_Line2d ,opencascade::handle<Adaptor2d_Line2d>  , Adaptor2d_Curve2d >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const gp_Pnt2d &, const gp_Dir2d &, const Standard_Real, const Standard_Real >()  , py::arg("P"),  py::arg("D"),  py::arg("UFirst"),  py::arg("ULast") )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (handle<Adaptor2d_Curve2d> (Adaptor2d_Line2d::*)() const) static_cast<handle<Adaptor2d_Curve2d> (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Load",
             (void (Adaptor2d_Line2d::*)(  const gp_Lin2d &  ) ) static_cast<void (Adaptor2d_Line2d::*)(  const gp_Lin2d &  ) >(&Adaptor2d_Line2d::Load),
             R"#()#"  , py::arg("L")
          )
        .def("Load",
             (void (Adaptor2d_Line2d::*)(  const gp_Lin2d & ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (Adaptor2d_Line2d::*)(  const gp_Lin2d & ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor2d_Line2d::Load),
             R"#()#"  , py::arg("L"),  py::arg("UFirst"),  py::arg("ULast")
          )
        .def("FirstParameter",
             (Standard_Real (Adaptor2d_Line2d::*)() const) static_cast<Standard_Real (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::FirstParameter),
             R"#()#" 
          )
        .def("LastParameter",
             (Standard_Real (Adaptor2d_Line2d::*)() const) static_cast<Standard_Real (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::LastParameter),
             R"#()#" 
          )
        .def("Continuity",
             (GeomAbs_Shape (Adaptor2d_Line2d::*)() const) static_cast<GeomAbs_Shape (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Continuity),
             R"#()#" 
          )
        .def("NbIntervals",
             (Standard_Integer (Adaptor2d_Line2d::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor2d_Line2d::*)(  const GeomAbs_Shape  ) const>(&Adaptor2d_Line2d::NbIntervals),
             R"#(If necessary, breaks the curve in intervals of continuity <S>. And returns the number of intervals.)#"  , py::arg("S")
          )
        .def("Intervals",
             (void (Adaptor2d_Line2d::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor2d_Line2d::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor2d_Line2d::Intervals),
             R"#(Stores in <T> the parameters bounding the intervals of continuity <S>.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("Trim",
             (handle<Adaptor2d_Curve2d> (Adaptor2d_Line2d::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor2d_Curve2d> (Adaptor2d_Line2d::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor2d_Line2d::Trim),
             R"#(Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsClosed",
             (Standard_Boolean (Adaptor2d_Line2d::*)() const) static_cast<Standard_Boolean (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::IsClosed),
             R"#()#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (Adaptor2d_Line2d::*)() const) static_cast<Standard_Boolean (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::IsPeriodic),
             R"#()#" 
          )
        .def("Period",
             (Standard_Real (Adaptor2d_Line2d::*)() const) static_cast<Standard_Real (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Period),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt2d (Adaptor2d_Line2d::*)(  const Standard_Real  ) const) static_cast<gp_Pnt2d (Adaptor2d_Line2d::*)(  const Standard_Real  ) const>(&Adaptor2d_Line2d::Value),
             R"#()#"  , py::arg("X")
          )
        .def("D0",
             (void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d &  ) const) static_cast<void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d &  ) const>(&Adaptor2d_Line2d::D0),
             R"#()#"  , py::arg("X"),  py::arg("P")
          )
        .def("D1",
             (void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_Line2d::D1),
             R"#()#"  , py::arg("X"),  py::arg("P"),  py::arg("V")
          )
        .def("D2",
             (void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_Line2d::D2),
             R"#()#"  , py::arg("X"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def("D3",
             (void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_Line2d::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_Line2d::D3),
             R"#()#"  , py::arg("X"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def("DN",
             (gp_Vec2d (Adaptor2d_Line2d::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec2d (Adaptor2d_Line2d::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Adaptor2d_Line2d::DN),
             R"#()#"  , py::arg("U"),  py::arg("N")
          )
        .def("Resolution",
             (Standard_Real (Adaptor2d_Line2d::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor2d_Line2d::*)(  const Standard_Real  ) const>(&Adaptor2d_Line2d::Resolution),
             R"#()#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_CurveType (Adaptor2d_Line2d::*)() const) static_cast<GeomAbs_CurveType (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::GetType),
             R"#()#" 
          )
        .def("Line",
             (gp_Lin2d (Adaptor2d_Line2d::*)() const) static_cast<gp_Lin2d (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Line),
             R"#()#" 
          )
        .def("Circle",
             (gp_Circ2d (Adaptor2d_Line2d::*)() const) static_cast<gp_Circ2d (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Circle),
             R"#()#" 
          )
        .def("Ellipse",
             (gp_Elips2d (Adaptor2d_Line2d::*)() const) static_cast<gp_Elips2d (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Ellipse),
             R"#()#" 
          )
        .def("Hyperbola",
             (gp_Hypr2d (Adaptor2d_Line2d::*)() const) static_cast<gp_Hypr2d (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Hyperbola),
             R"#()#" 
          )
        .def("Parabola",
             (gp_Parab2d (Adaptor2d_Line2d::*)() const) static_cast<gp_Parab2d (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Parabola),
             R"#()#" 
          )
        .def("Degree",
             (Standard_Integer (Adaptor2d_Line2d::*)() const) static_cast<Standard_Integer (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Degree),
             R"#()#" 
          )
        .def("IsRational",
             (Standard_Boolean (Adaptor2d_Line2d::*)() const) static_cast<Standard_Boolean (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::IsRational),
             R"#()#" 
          )
        .def("NbPoles",
             (Standard_Integer (Adaptor2d_Line2d::*)() const) static_cast<Standard_Integer (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::NbPoles),
             R"#()#" 
          )
        .def("NbKnots",
             (Standard_Integer (Adaptor2d_Line2d::*)() const) static_cast<Standard_Integer (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::NbKnots),
             R"#()#" 
          )
        .def("Bezier",
             (handle<Geom2d_BezierCurve> (Adaptor2d_Line2d::*)() const) static_cast<handle<Geom2d_BezierCurve> (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::Bezier),
             R"#()#" 
          )
        .def("BSpline",
             (handle<Geom2d_BSplineCurve> (Adaptor2d_Line2d::*)() const) static_cast<handle<Geom2d_BSplineCurve> (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::BSpline),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor2d_Line2d::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor2d_Line2d::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor2d_Line2d::*)() const) static_cast< const handle<Standard_Type> & (Adaptor2d_Line2d::*)() const>(&Adaptor2d_Line2d::DynamicType),
             R"#()#"
             
         )
;

    // Class Adaptor2d_OffsetCurve from ./opencascade/Adaptor2d_OffsetCurve.hxx
    klass = m.attr("Adaptor2d_OffsetCurve");


    // nested enums

    static_cast<py::class_<Adaptor2d_OffsetCurve ,opencascade::handle<Adaptor2d_OffsetCurve>  , Adaptor2d_Curve2d >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<Adaptor2d_Curve2d> & >()  , py::arg("C") )
        .def(py::init<  const handle<Adaptor2d_Curve2d> &, const Standard_Real >()  , py::arg("C"),  py::arg("Offset") )
        .def(py::init<  const handle<Adaptor2d_Curve2d> &, const Standard_Real, const Standard_Real, const Standard_Real >()  , py::arg("C"),  py::arg("Offset"),  py::arg("WFirst"),  py::arg("WLast") )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (handle<Adaptor2d_Curve2d> (Adaptor2d_OffsetCurve::*)() const) static_cast<handle<Adaptor2d_Curve2d> (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Load",
             (void (Adaptor2d_OffsetCurve::*)(  const handle<Adaptor2d_Curve2d> &  ) ) static_cast<void (Adaptor2d_OffsetCurve::*)(  const handle<Adaptor2d_Curve2d> &  ) >(&Adaptor2d_OffsetCurve::Load),
             R"#(Changes the curve. The Offset is reset to 0.)#"  , py::arg("S")
          )
        .def("Load",
             (void (Adaptor2d_OffsetCurve::*)(  const Standard_Real  ) ) static_cast<void (Adaptor2d_OffsetCurve::*)(  const Standard_Real  ) >(&Adaptor2d_OffsetCurve::Load),
             R"#(Changes the Offset on the current Curve.)#"  , py::arg("Offset")
          )
        .def("Load",
             (void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor2d_OffsetCurve::Load),
             R"#(Changes the Offset Curve on the current Curve.)#"  , py::arg("Offset"),  py::arg("WFirst"),  py::arg("WLast")
          )
        .def("Offset",
             (Standard_Real (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Real (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Offset),
             R"#()#" 
          )
        .def("FirstParameter",
             (Standard_Real (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Real (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::FirstParameter),
             R"#()#" 
          )
        .def("LastParameter",
             (Standard_Real (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Real (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::LastParameter),
             R"#()#" 
          )
        .def("Continuity",
             (GeomAbs_Shape (Adaptor2d_OffsetCurve::*)() const) static_cast<GeomAbs_Shape (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Continuity),
             R"#()#" 
          )
        .def("NbIntervals",
             (Standard_Integer (Adaptor2d_OffsetCurve::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor2d_OffsetCurve::*)(  const GeomAbs_Shape  ) const>(&Adaptor2d_OffsetCurve::NbIntervals),
             R"#(If necessary, breaks the curve in intervals of continuity <S>. And returns the number of intervals.)#"  , py::arg("S")
          )
        .def("Intervals",
             (void (Adaptor2d_OffsetCurve::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor2d_OffsetCurve::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor2d_OffsetCurve::Intervals),
             R"#(Stores in <T> the parameters bounding the intervals of continuity <S>.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("Trim",
             (handle<Adaptor2d_Curve2d> (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor2d_Curve2d> (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor2d_OffsetCurve::Trim),
             R"#(Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsClosed",
             (Standard_Boolean (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Boolean (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::IsClosed),
             R"#()#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Boolean (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::IsPeriodic),
             R"#()#" 
          )
        .def("Period",
             (Standard_Real (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Real (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Period),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt2d (Adaptor2d_OffsetCurve::*)(  const Standard_Real  ) const) static_cast<gp_Pnt2d (Adaptor2d_OffsetCurve::*)(  const Standard_Real  ) const>(&Adaptor2d_OffsetCurve::Value),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U")
          )
        .def("D0",
             (void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d &  ) const) static_cast<void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d &  ) const>(&Adaptor2d_OffsetCurve::D0),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("D1",
             (void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_OffsetCurve::D1),
             R"#(Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V")
          )
        .def("D2",
             (void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_OffsetCurve::D2),
             R"#(Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def("D3",
             (void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const) static_cast<void (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,  gp_Pnt2d & ,  gp_Vec2d & ,  gp_Vec2d & ,  gp_Vec2d &  ) const>(&Adaptor2d_OffsetCurve::D3),
             R"#(Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def("DN",
             (gp_Vec2d (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec2d (Adaptor2d_OffsetCurve::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Adaptor2d_OffsetCurve::DN),
             R"#(The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.)#"  , py::arg("U"),  py::arg("N")
          )
        .def("Resolution",
             (Standard_Real (Adaptor2d_OffsetCurve::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor2d_OffsetCurve::*)(  const Standard_Real  ) const>(&Adaptor2d_OffsetCurve::Resolution),
             R"#(Returns the parametric resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_CurveType (Adaptor2d_OffsetCurve::*)() const) static_cast<GeomAbs_CurveType (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::GetType),
             R"#(Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.)#" 
          )
        .def("Line",
             (gp_Lin2d (Adaptor2d_OffsetCurve::*)() const) static_cast<gp_Lin2d (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Line),
             R"#()#" 
          )
        .def("Circle",
             (gp_Circ2d (Adaptor2d_OffsetCurve::*)() const) static_cast<gp_Circ2d (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Circle),
             R"#()#" 
          )
        .def("Ellipse",
             (gp_Elips2d (Adaptor2d_OffsetCurve::*)() const) static_cast<gp_Elips2d (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Ellipse),
             R"#()#" 
          )
        .def("Hyperbola",
             (gp_Hypr2d (Adaptor2d_OffsetCurve::*)() const) static_cast<gp_Hypr2d (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Hyperbola),
             R"#()#" 
          )
        .def("Parabola",
             (gp_Parab2d (Adaptor2d_OffsetCurve::*)() const) static_cast<gp_Parab2d (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Parabola),
             R"#()#" 
          )
        .def("Degree",
             (Standard_Integer (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Integer (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Degree),
             R"#()#" 
          )
        .def("IsRational",
             (Standard_Boolean (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Boolean (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::IsRational),
             R"#()#" 
          )
        .def("NbPoles",
             (Standard_Integer (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Integer (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::NbPoles),
             R"#()#" 
          )
        .def("NbKnots",
             (Standard_Integer (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Integer (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::NbKnots),
             R"#()#" 
          )
        .def("Bezier",
             (handle<Geom2d_BezierCurve> (Adaptor2d_OffsetCurve::*)() const) static_cast<handle<Geom2d_BezierCurve> (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Bezier),
             R"#()#" 
          )
        .def("BSpline",
             (handle<Geom2d_BSplineCurve> (Adaptor2d_OffsetCurve::*)() const) static_cast<handle<Geom2d_BSplineCurve> (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::BSpline),
             R"#()#" 
          )
        .def("NbSamples",
             (Standard_Integer (Adaptor2d_OffsetCurve::*)() const) static_cast<Standard_Integer (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::NbSamples),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor2d_OffsetCurve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor2d_OffsetCurve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor2d_OffsetCurve::*)() const) static_cast< const handle<Standard_Type> & (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::DynamicType),
             R"#()#"
             
         )
       .def("Curve",
             ( const handle<Adaptor2d_Curve2d> & (Adaptor2d_OffsetCurve::*)() const) static_cast< const handle<Adaptor2d_Curve2d> & (Adaptor2d_OffsetCurve::*)() const>(&Adaptor2d_OffsetCurve::Curve),
             R"#()#"
             
         )
;

// functions

// ./opencascade/Adaptor2d_Curve2d.hxx
// ./opencascade/Adaptor2d_Line2d.hxx
// ./opencascade/Adaptor2d_OffsetCurve.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
