
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_BezierCurve.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Geom_OffsetCurve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Geom_BezierSurface.hxx>
#include <Geom_BSplineSurface.hxx>

// module includes
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_CurveOnSurface.hxx>
#include <Adaptor3d_HSurfaceTool.hxx>
#include <Adaptor3d_HVertex.hxx>
#include <Adaptor3d_InterFunc.hxx>
#include <Adaptor3d_IsoCurve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_TopolTool.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Adaptor3d(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Adaptor3d"));
py::object klass;

//Python trampoline classes

// classes

    // Class Adaptor3d_Curve from ./opencascade/Adaptor3d_Curve.hxx
    klass = m.attr("Adaptor3d_Curve");

    // default constructor
    register_default_constructor<Adaptor3d_Curve ,opencascade::handle<Adaptor3d_Curve>>(m,"Adaptor3d_Curve");

    // nested enums

    static_cast<py::class_<Adaptor3d_Curve ,opencascade::handle<Adaptor3d_Curve>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ShallowCopy",
             (handle<Adaptor3d_Curve> (Adaptor3d_Curve::*)() const) static_cast<handle<Adaptor3d_Curve> (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("FirstParameter",
             (Standard_Real (Adaptor3d_Curve::*)() const) static_cast<Standard_Real (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::FirstParameter),
             R"#()#" 
          )
        .def("LastParameter",
             (Standard_Real (Adaptor3d_Curve::*)() const) static_cast<Standard_Real (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::LastParameter),
             R"#()#" 
          )
        .def("Continuity",
             (GeomAbs_Shape (Adaptor3d_Curve::*)() const) static_cast<GeomAbs_Shape (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Continuity),
             R"#()#" 
          )
        .def("NbIntervals",
             (Standard_Integer (Adaptor3d_Curve::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor3d_Curve::*)(  const GeomAbs_Shape  ) const>(&Adaptor3d_Curve::NbIntervals),
             R"#(Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("Intervals",
             (void (Adaptor3d_Curve::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor3d_Curve::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor3d_Curve::Intervals),
             R"#(Stores in <T> the parameters bounding the intervals of continuity <S>.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("Trim",
             (handle<Adaptor3d_Curve> (Adaptor3d_Curve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor3d_Curve> (Adaptor3d_Curve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor3d_Curve::Trim),
             R"#(Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsClosed",
             (Standard_Boolean (Adaptor3d_Curve::*)() const) static_cast<Standard_Boolean (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::IsClosed),
             R"#()#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (Adaptor3d_Curve::*)() const) static_cast<Standard_Boolean (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::IsPeriodic),
             R"#()#" 
          )
        .def("Period",
             (Standard_Real (Adaptor3d_Curve::*)() const) static_cast<Standard_Real (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Period),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt (Adaptor3d_Curve::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (Adaptor3d_Curve::*)(  const Standard_Real  ) const>(&Adaptor3d_Curve::Value),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U")
          )
        .def("D0",
             (void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt &  ) const>(&Adaptor3d_Curve::D0),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("D1",
             (void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const>(&Adaptor3d_Curve::D1),
             R"#(Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V")
          )
        .def("D2",
             (void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_Curve::D2),
             R"#(Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def("D3",
             (void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_Curve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_Curve::D3),
             R"#(Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def("DN",
             (gp_Vec (Adaptor3d_Curve::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec (Adaptor3d_Curve::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Adaptor3d_Curve::DN),
             R"#(The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.)#"  , py::arg("U"),  py::arg("N")
          )
        .def("Resolution",
             (Standard_Real (Adaptor3d_Curve::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor3d_Curve::*)(  const Standard_Real  ) const>(&Adaptor3d_Curve::Resolution),
             R"#(Returns the parametric resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_CurveType (Adaptor3d_Curve::*)() const) static_cast<GeomAbs_CurveType (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::GetType),
             R"#(Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.)#" 
          )
        .def("Line",
             (gp_Lin (Adaptor3d_Curve::*)() const) static_cast<gp_Lin (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Line),
             R"#()#" 
          )
        .def("Circle",
             (gp_Circ (Adaptor3d_Curve::*)() const) static_cast<gp_Circ (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Circle),
             R"#()#" 
          )
        .def("Ellipse",
             (gp_Elips (Adaptor3d_Curve::*)() const) static_cast<gp_Elips (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Ellipse),
             R"#()#" 
          )
        .def("Hyperbola",
             (gp_Hypr (Adaptor3d_Curve::*)() const) static_cast<gp_Hypr (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Hyperbola),
             R"#()#" 
          )
        .def("Parabola",
             (gp_Parab (Adaptor3d_Curve::*)() const) static_cast<gp_Parab (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Parabola),
             R"#()#" 
          )
        .def("Degree",
             (Standard_Integer (Adaptor3d_Curve::*)() const) static_cast<Standard_Integer (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Degree),
             R"#()#" 
          )
        .def("IsRational",
             (Standard_Boolean (Adaptor3d_Curve::*)() const) static_cast<Standard_Boolean (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::IsRational),
             R"#()#" 
          )
        .def("NbPoles",
             (Standard_Integer (Adaptor3d_Curve::*)() const) static_cast<Standard_Integer (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::NbPoles),
             R"#()#" 
          )
        .def("NbKnots",
             (Standard_Integer (Adaptor3d_Curve::*)() const) static_cast<Standard_Integer (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::NbKnots),
             R"#()#" 
          )
        .def("Bezier",
             (handle<Geom_BezierCurve> (Adaptor3d_Curve::*)() const) static_cast<handle<Geom_BezierCurve> (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::Bezier),
             R"#()#" 
          )
        .def("BSpline",
             (handle<Geom_BSplineCurve> (Adaptor3d_Curve::*)() const) static_cast<handle<Geom_BSplineCurve> (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::BSpline),
             R"#()#" 
          )
        .def("OffsetCurve",
             (handle<Geom_OffsetCurve> (Adaptor3d_Curve::*)() const) static_cast<handle<Geom_OffsetCurve> (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::OffsetCurve),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor3d_Curve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor3d_Curve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor3d_Curve::*)() const) static_cast< const handle<Standard_Type> & (Adaptor3d_Curve::*)() const>(&Adaptor3d_Curve::DynamicType),
             R"#()#"
             
         )
;

    // Class Adaptor3d_HSurfaceTool from ./opencascade/Adaptor3d_HSurfaceTool.hxx
    klass = m.attr("Adaptor3d_HSurfaceTool");

    // default constructor
    register_default_constructor<Adaptor3d_HSurfaceTool , shared_ptr<Adaptor3d_HSurfaceTool>>(m,"Adaptor3d_HSurfaceTool");

    // nested enums

    static_cast<py::class_<Adaptor3d_HSurfaceTool , shared_ptr<Adaptor3d_HSurfaceTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("FirstUParameter_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::FirstUParameter),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("FirstVParameter_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::FirstVParameter),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("LastUParameter_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::LastUParameter),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("LastVParameter_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::LastVParameter),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("NbUIntervals_s",
                    (Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const GeomAbs_Shape  ) ) static_cast<Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const GeomAbs_Shape  ) >(&Adaptor3d_HSurfaceTool::NbUIntervals),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theSh")
          )
        .def_static("NbVIntervals_s",
                    (Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const GeomAbs_Shape  ) ) static_cast<Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const GeomAbs_Shape  ) >(&Adaptor3d_HSurfaceTool::NbVIntervals),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theSh")
          )
        .def_static("UIntervals_s",
                    (void (*)(  const handle<Adaptor3d_Surface> & ,  TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) ) static_cast<void (*)(  const handle<Adaptor3d_Surface> & ,  TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) >(&Adaptor3d_HSurfaceTool::UIntervals),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theTab"),  py::arg("theSh")
          )
        .def_static("VIntervals_s",
                    (void (*)(  const handle<Adaptor3d_Surface> & ,  TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) ) static_cast<void (*)(  const handle<Adaptor3d_Surface> & ,  TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) >(&Adaptor3d_HSurfaceTool::VIntervals),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theTab"),  py::arg("theSh")
          )
        .def_static("UTrim_s",
                    (handle<Adaptor3d_Surface> (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<handle<Adaptor3d_Surface> (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::UTrim),
                    R"#(If <First> >= <Last>)#"  , py::arg("theSurf"),  py::arg("theFirst"),  py::arg("theLast"),  py::arg("theTol")
          )
        .def_static("VTrim_s",
                    (handle<Adaptor3d_Surface> (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<handle<Adaptor3d_Surface> (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::VTrim),
                    R"#(If <First> >= <Last>)#"  , py::arg("theSurf"),  py::arg("theFirst"),  py::arg("theLast"),  py::arg("theTol")
          )
        .def_static("IsUClosed_s",
                    (Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::IsUClosed),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("IsVClosed_s",
                    (Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::IsVClosed),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("IsUPeriodic_s",
                    (Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::IsUPeriodic),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("UPeriod_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::UPeriod),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("IsVPeriodic_s",
                    (Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Boolean (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::IsVPeriodic),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("VPeriod_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::VPeriod),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Value_s",
                    (gp_Pnt (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<gp_Pnt (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::Value),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theU"),  py::arg("theV")
          )
        .def_static("D0_s",
                    (void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt &  ) ) static_cast<void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt &  ) >(&Adaptor3d_HSurfaceTool::D0),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theU"),  py::arg("theV"),  py::arg("thePnt")
          )
        .def_static("D1_s",
                    (void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) >(&Adaptor3d_HSurfaceTool::D1),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theU"),  py::arg("theV"),  py::arg("thePnt"),  py::arg("theD1U"),  py::arg("theD1V")
          )
        .def_static("D2_s",
                    (void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) >(&Adaptor3d_HSurfaceTool::D2),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theU"),  py::arg("theV"),  py::arg("thePnt"),  py::arg("theD1U"),  py::arg("theD1V"),  py::arg("theD2U"),  py::arg("theD2V"),  py::arg("theD2UV")
          )
        .def_static("D3_s",
                    (void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) ) static_cast<void (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) >(&Adaptor3d_HSurfaceTool::D3),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theU"),  py::arg("theV"),  py::arg("thePnt"),  py::arg("theD1U"),  py::arg("theD1V"),  py::arg("theD2U"),  py::arg("theD2V"),  py::arg("theD2UV"),  py::arg("theD3U"),  py::arg("theD3V"),  py::arg("theD3UUV"),  py::arg("theD3UVV")
          )
        .def_static("DN_s",
                    (gp_Vec (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<gp_Vec (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) >(&Adaptor3d_HSurfaceTool::DN),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theU"),  py::arg("theV"),  py::arg("theNU"),  py::arg("theNV")
          )
        .def_static("UResolution_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::UResolution),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theR3d")
          )
        .def_static("VResolution_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::VResolution),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theR3d")
          )
        .def_static("GetType_s",
                    (GeomAbs_SurfaceType (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<GeomAbs_SurfaceType (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::GetType),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Plane_s",
                    (gp_Pln (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<gp_Pln (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::Plane),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Cylinder_s",
                    (gp_Cylinder (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<gp_Cylinder (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::Cylinder),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Cone_s",
                    (gp_Cone (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<gp_Cone (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::Cone),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Torus_s",
                    (gp_Torus (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<gp_Torus (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::Torus),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Sphere_s",
                    (gp_Sphere (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<gp_Sphere (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::Sphere),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Bezier_s",
                    (handle<Geom_BezierSurface> (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<handle<Geom_BezierSurface> (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::Bezier),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("BSpline_s",
                    (handle<Geom_BSplineSurface> (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<handle<Geom_BSplineSurface> (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::BSpline),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("AxeOfRevolution_s",
                    (gp_Ax1 (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<gp_Ax1 (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::AxeOfRevolution),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("Direction_s",
                    (gp_Dir (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<gp_Dir (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::Direction),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("BasisCurve_s",
                    (handle<Adaptor3d_Curve> (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<handle<Adaptor3d_Curve> (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::BasisCurve),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("BasisSurface_s",
                    (handle<Adaptor3d_Surface> (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<handle<Adaptor3d_Surface> (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::BasisSurface),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("OffsetValue_s",
                    (Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Real (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::OffsetValue),
                    R"#()#"  , py::arg("theSurf")
          )
        .def_static("IsSurfG1_s",
                    (Standard_Boolean (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Boolean ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Boolean ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::IsSurfG1),
                    R"#()#"  , py::arg("theSurf"),  py::arg("theAlongU"),  py::arg("theAngTol")=static_cast< const Standard_Real>(Precision :: Angular ( ))
          )
        .def_static("NbSamplesU_s",
                    (Standard_Integer (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Integer (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::NbSamplesU),
                    R"#()#"  , py::arg("S")
          )
        .def_static("NbSamplesV_s",
                    (Standard_Integer (*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<Standard_Integer (*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_HSurfaceTool::NbSamplesV),
                    R"#()#"  , py::arg("S")
          )
        .def_static("NbSamplesU_s",
                    (Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::NbSamplesU),
                    R"#()#"  , py::arg("S"),  py::arg("u1"),  py::arg("u2")
          )
        .def_static("NbSamplesV_s",
                    (Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<Standard_Integer (*)(  const handle<Adaptor3d_Surface> & ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor3d_HSurfaceTool::NbSamplesV),
                    R"#()#"  , py::arg("arg0"),  py::arg("v1"),  py::arg("v2")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Adaptor3d_HVertex from ./opencascade/Adaptor3d_HVertex.hxx
    klass = m.attr("Adaptor3d_HVertex");


    // nested enums

    static_cast<py::class_<Adaptor3d_HVertex ,opencascade::handle<Adaptor3d_HVertex>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const gp_Pnt2d &, const TopAbs_Orientation, const Standard_Real >()  , py::arg("P"),  py::arg("Ori"),  py::arg("Resolution") )
    // custom constructors
    // methods
        .def("Value",
             (gp_Pnt2d (Adaptor3d_HVertex::*)() ) static_cast<gp_Pnt2d (Adaptor3d_HVertex::*)() >(&Adaptor3d_HVertex::Value),
             R"#()#" 
          )
        .def("Parameter",
             (Standard_Real (Adaptor3d_HVertex::*)(  const handle<Adaptor2d_Curve2d> &  ) ) static_cast<Standard_Real (Adaptor3d_HVertex::*)(  const handle<Adaptor2d_Curve2d> &  ) >(&Adaptor3d_HVertex::Parameter),
             R"#()#"  , py::arg("C")
          )
        .def("Resolution",
             (Standard_Real (Adaptor3d_HVertex::*)(  const handle<Adaptor2d_Curve2d> &  ) ) static_cast<Standard_Real (Adaptor3d_HVertex::*)(  const handle<Adaptor2d_Curve2d> &  ) >(&Adaptor3d_HVertex::Resolution),
             R"#(Parametric resolution (2d).)#"  , py::arg("C")
          )
        .def("Orientation",
             (TopAbs_Orientation (Adaptor3d_HVertex::*)() ) static_cast<TopAbs_Orientation (Adaptor3d_HVertex::*)() >(&Adaptor3d_HVertex::Orientation),
             R"#()#" 
          )
        .def("IsSame",
             (Standard_Boolean (Adaptor3d_HVertex::*)(  const handle<Adaptor3d_HVertex> &  ) ) static_cast<Standard_Boolean (Adaptor3d_HVertex::*)(  const handle<Adaptor3d_HVertex> &  ) >(&Adaptor3d_HVertex::IsSame),
             R"#()#"  , py::arg("Other")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor3d_HVertex::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor3d_HVertex::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor3d_HVertex::*)() const) static_cast< const handle<Standard_Type> & (Adaptor3d_HVertex::*)() const>(&Adaptor3d_HVertex::DynamicType),
             R"#()#"
             
         )
;

    // Class Adaptor3d_InterFunc from ./opencascade/Adaptor3d_InterFunc.hxx
    klass = m.attr("Adaptor3d_InterFunc");


    // nested enums

    static_cast<py::class_<Adaptor3d_InterFunc , shared_ptr<Adaptor3d_InterFunc>  , math_FunctionWithDerivative >>(klass)
    // constructors
        .def(py::init<  const handle<Adaptor2d_Curve2d> &, const Standard_Real, const Standard_Integer >()  , py::arg("C"),  py::arg("FixVal"),  py::arg("Fix") )
    // custom constructors
    // methods
        .def("Value",
             (Standard_Boolean (Adaptor3d_InterFunc::*)(  const Standard_Real ,  Standard_Real &  ) ) static_cast<Standard_Boolean (Adaptor3d_InterFunc::*)(  const Standard_Real ,  Standard_Real &  ) >(&Adaptor3d_InterFunc::Value),
             R"#(computes the value <F>of the function for the variable <X>. Returns True if the calculation were successfully done, False otherwise.)#"  , py::arg("X"),  py::arg("F")
          )
        .def("Derivative",
             (Standard_Boolean (Adaptor3d_InterFunc::*)(  const Standard_Real ,  Standard_Real &  ) ) static_cast<Standard_Boolean (Adaptor3d_InterFunc::*)(  const Standard_Real ,  Standard_Real &  ) >(&Adaptor3d_InterFunc::Derivative),
             R"#(computes the derivative <D> of the function for the variable <X>. Returns True if the calculation were successfully done, False otherwise.)#"  , py::arg("X"),  py::arg("D")
          )
        .def("Values",
             (Standard_Boolean (Adaptor3d_InterFunc::*)(  const Standard_Real ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (Adaptor3d_InterFunc::*)(  const Standard_Real ,  Standard_Real & ,  Standard_Real &  ) >(&Adaptor3d_InterFunc::Values),
             R"#(computes the value <F> and the derivative <D> of the function for the variable <X>. Returns True if the calculation were successfully done, False otherwise.)#"  , py::arg("X"),  py::arg("F"),  py::arg("D")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Adaptor3d_Surface from ./opencascade/Adaptor3d_Surface.hxx
    klass = m.attr("Adaptor3d_Surface");

    // default constructor
    register_default_constructor<Adaptor3d_Surface ,opencascade::handle<Adaptor3d_Surface>>(m,"Adaptor3d_Surface");

    // nested enums

    static_cast<py::class_<Adaptor3d_Surface ,opencascade::handle<Adaptor3d_Surface>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ShallowCopy",
             (handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)() const) static_cast<handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("FirstUParameter",
             (Standard_Real (Adaptor3d_Surface::*)() const) static_cast<Standard_Real (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::FirstUParameter),
             R"#()#" 
          )
        .def("LastUParameter",
             (Standard_Real (Adaptor3d_Surface::*)() const) static_cast<Standard_Real (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::LastUParameter),
             R"#()#" 
          )
        .def("FirstVParameter",
             (Standard_Real (Adaptor3d_Surface::*)() const) static_cast<Standard_Real (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::FirstVParameter),
             R"#()#" 
          )
        .def("LastVParameter",
             (Standard_Real (Adaptor3d_Surface::*)() const) static_cast<Standard_Real (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::LastVParameter),
             R"#()#" 
          )
        .def("UContinuity",
             (GeomAbs_Shape (Adaptor3d_Surface::*)() const) static_cast<GeomAbs_Shape (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::UContinuity),
             R"#()#" 
          )
        .def("VContinuity",
             (GeomAbs_Shape (Adaptor3d_Surface::*)() const) static_cast<GeomAbs_Shape (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::VContinuity),
             R"#()#" 
          )
        .def("NbUIntervals",
             (Standard_Integer (Adaptor3d_Surface::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor3d_Surface::*)(  const GeomAbs_Shape  ) const>(&Adaptor3d_Surface::NbUIntervals),
             R"#(Returns the number of U intervals for continuity <S>. May be one if UContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("NbVIntervals",
             (Standard_Integer (Adaptor3d_Surface::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor3d_Surface::*)(  const GeomAbs_Shape  ) const>(&Adaptor3d_Surface::NbVIntervals),
             R"#(Returns the number of V intervals for continuity <S>. May be one if VContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("UIntervals",
             (void (Adaptor3d_Surface::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor3d_Surface::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor3d_Surface::UIntervals),
             R"#(Returns the intervals with the requested continuity in the U direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("VIntervals",
             (void (Adaptor3d_Surface::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor3d_Surface::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor3d_Surface::VIntervals),
             R"#(Returns the intervals with the requested continuity in the V direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("UTrim",
             (handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor3d_Surface::UTrim),
             R"#(Returns a surface trimmed in the U direction equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("VTrim",
             (handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor3d_Surface::VTrim),
             R"#(Returns a surface trimmed in the V direction between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsUClosed",
             (Standard_Boolean (Adaptor3d_Surface::*)() const) static_cast<Standard_Boolean (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::IsUClosed),
             R"#()#" 
          )
        .def("IsVClosed",
             (Standard_Boolean (Adaptor3d_Surface::*)() const) static_cast<Standard_Boolean (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::IsVClosed),
             R"#()#" 
          )
        .def("IsUPeriodic",
             (Standard_Boolean (Adaptor3d_Surface::*)() const) static_cast<Standard_Boolean (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::IsUPeriodic),
             R"#()#" 
          )
        .def("UPeriod",
             (Standard_Real (Adaptor3d_Surface::*)() const) static_cast<Standard_Real (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::UPeriod),
             R"#()#" 
          )
        .def("IsVPeriodic",
             (Standard_Boolean (Adaptor3d_Surface::*)() const) static_cast<Standard_Boolean (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::IsVPeriodic),
             R"#()#" 
          )
        .def("VPeriod",
             (Standard_Real (Adaptor3d_Surface::*)() const) static_cast<Standard_Real (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::VPeriod),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real  ) const) static_cast<gp_Pnt (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real  ) const>(&Adaptor3d_Surface::Value),
             R"#(Computes the point of parameters U,V on the surface. Tip: use GeomLib::NormEstim() to calculate surface normal at specified (U, V) point.)#"  , py::arg("U"),  py::arg("V")
          )
        .def("D0",
             (void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt &  ) const>(&Adaptor3d_Surface::D0),
             R"#(Computes the point of parameters U,V on the surface.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P")
          )
        .def("D1",
             (void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_Surface::D1),
             R"#(Computes the point and the first derivatives on the surface. Raised if the continuity of the current intervals is not C1.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P"),  py::arg("D1U"),  py::arg("D1V")
          )
        .def("D2",
             (void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_Surface::D2),
             R"#(Computes the point, the first and second derivatives on the surface. Raised if the continuity of the current intervals is not C2.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P"),  py::arg("D1U"),  py::arg("D1V"),  py::arg("D2U"),  py::arg("D2V"),  py::arg("D2UV")
          )
        .def("D3",
             (void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_Surface::D3),
             R"#(Computes the point, the first, second and third derivatives on the surface. Raised if the continuity of the current intervals is not C3.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P"),  py::arg("D1U"),  py::arg("D1V"),  py::arg("D2U"),  py::arg("D2V"),  py::arg("D2UV"),  py::arg("D3U"),  py::arg("D3V"),  py::arg("D3UUV"),  py::arg("D3UVV")
          )
        .def("DN",
             (gp_Vec (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) const) static_cast<gp_Vec (Adaptor3d_Surface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) const>(&Adaptor3d_Surface::DN),
             R"#(Computes the derivative of order Nu in the direction U and Nv in the direction V at the point P(U, V). Raised if the current U interval is not not CNu and the current V interval is not CNv. Raised if Nu + Nv < 1 or Nu < 0 or Nv < 0.)#"  , py::arg("U"),  py::arg("V"),  py::arg("Nu"),  py::arg("Nv")
          )
        .def("UResolution",
             (Standard_Real (Adaptor3d_Surface::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor3d_Surface::*)(  const Standard_Real  ) const>(&Adaptor3d_Surface::UResolution),
             R"#(Returns the parametric U resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("VResolution",
             (Standard_Real (Adaptor3d_Surface::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor3d_Surface::*)(  const Standard_Real  ) const>(&Adaptor3d_Surface::VResolution),
             R"#(Returns the parametric V resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_SurfaceType (Adaptor3d_Surface::*)() const) static_cast<GeomAbs_SurfaceType (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::GetType),
             R"#(Returns the type of the surface : Plane, Cylinder, Cone, Sphere, Torus, BezierSurface, BSplineSurface, SurfaceOfRevolution, SurfaceOfExtrusion, OtherSurface)#" 
          )
        .def("Plane",
             (gp_Pln (Adaptor3d_Surface::*)() const) static_cast<gp_Pln (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::Plane),
             R"#()#" 
          )
        .def("Cylinder",
             (gp_Cylinder (Adaptor3d_Surface::*)() const) static_cast<gp_Cylinder (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::Cylinder),
             R"#()#" 
          )
        .def("Cone",
             (gp_Cone (Adaptor3d_Surface::*)() const) static_cast<gp_Cone (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::Cone),
             R"#()#" 
          )
        .def("Sphere",
             (gp_Sphere (Adaptor3d_Surface::*)() const) static_cast<gp_Sphere (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::Sphere),
             R"#()#" 
          )
        .def("Torus",
             (gp_Torus (Adaptor3d_Surface::*)() const) static_cast<gp_Torus (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::Torus),
             R"#()#" 
          )
        .def("UDegree",
             (Standard_Integer (Adaptor3d_Surface::*)() const) static_cast<Standard_Integer (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::UDegree),
             R"#()#" 
          )
        .def("NbUPoles",
             (Standard_Integer (Adaptor3d_Surface::*)() const) static_cast<Standard_Integer (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::NbUPoles),
             R"#()#" 
          )
        .def("VDegree",
             (Standard_Integer (Adaptor3d_Surface::*)() const) static_cast<Standard_Integer (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::VDegree),
             R"#()#" 
          )
        .def("NbVPoles",
             (Standard_Integer (Adaptor3d_Surface::*)() const) static_cast<Standard_Integer (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::NbVPoles),
             R"#()#" 
          )
        .def("NbUKnots",
             (Standard_Integer (Adaptor3d_Surface::*)() const) static_cast<Standard_Integer (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::NbUKnots),
             R"#()#" 
          )
        .def("NbVKnots",
             (Standard_Integer (Adaptor3d_Surface::*)() const) static_cast<Standard_Integer (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::NbVKnots),
             R"#()#" 
          )
        .def("IsURational",
             (Standard_Boolean (Adaptor3d_Surface::*)() const) static_cast<Standard_Boolean (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::IsURational),
             R"#()#" 
          )
        .def("IsVRational",
             (Standard_Boolean (Adaptor3d_Surface::*)() const) static_cast<Standard_Boolean (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::IsVRational),
             R"#()#" 
          )
        .def("Bezier",
             (handle<Geom_BezierSurface> (Adaptor3d_Surface::*)() const) static_cast<handle<Geom_BezierSurface> (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::Bezier),
             R"#()#" 
          )
        .def("BSpline",
             (handle<Geom_BSplineSurface> (Adaptor3d_Surface::*)() const) static_cast<handle<Geom_BSplineSurface> (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::BSpline),
             R"#()#" 
          )
        .def("AxeOfRevolution",
             (gp_Ax1 (Adaptor3d_Surface::*)() const) static_cast<gp_Ax1 (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::AxeOfRevolution),
             R"#()#" 
          )
        .def("Direction",
             (gp_Dir (Adaptor3d_Surface::*)() const) static_cast<gp_Dir (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::Direction),
             R"#()#" 
          )
        .def("BasisCurve",
             (handle<Adaptor3d_Curve> (Adaptor3d_Surface::*)() const) static_cast<handle<Adaptor3d_Curve> (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::BasisCurve),
             R"#()#" 
          )
        .def("BasisSurface",
             (handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)() const) static_cast<handle<Adaptor3d_Surface> (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::BasisSurface),
             R"#()#" 
          )
        .def("OffsetValue",
             (Standard_Real (Adaptor3d_Surface::*)() const) static_cast<Standard_Real (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::OffsetValue),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor3d_Surface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor3d_Surface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor3d_Surface::*)() const) static_cast< const handle<Standard_Type> & (Adaptor3d_Surface::*)() const>(&Adaptor3d_Surface::DynamicType),
             R"#()#"
             
         )
;

    // Class Adaptor3d_TopolTool from ./opencascade/Adaptor3d_TopolTool.hxx
    klass = m.attr("Adaptor3d_TopolTool");


    // nested enums

    static_cast<py::class_<Adaptor3d_TopolTool ,opencascade::handle<Adaptor3d_TopolTool>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<Adaptor3d_Surface> & >()  , py::arg("Surface") )
    // custom constructors
    // methods
        .def("Initialize",
             (void (Adaptor3d_TopolTool::*)() ) static_cast<void (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::Initialize),
             R"#()#" 
          )
        .def("Initialize",
             (void (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<void (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_TopolTool::Initialize),
             R"#()#"  , py::arg("S")
          )
        .def("Initialize",
             (void (Adaptor3d_TopolTool::*)(  const handle<Adaptor2d_Curve2d> &  ) ) static_cast<void (Adaptor3d_TopolTool::*)(  const handle<Adaptor2d_Curve2d> &  ) >(&Adaptor3d_TopolTool::Initialize),
             R"#()#"  , py::arg("Curve")
          )
        .def("Init",
             (void (Adaptor3d_TopolTool::*)() ) static_cast<void (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::Init),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (Adaptor3d_TopolTool::*)() ) static_cast<Standard_Boolean (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::More),
             R"#()#" 
          )
        .def("Value",
             (handle<Adaptor2d_Curve2d> (Adaptor3d_TopolTool::*)() ) static_cast<handle<Adaptor2d_Curve2d> (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::Value),
             R"#()#" 
          )
        .def("Next",
             (void (Adaptor3d_TopolTool::*)() ) static_cast<void (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::Next),
             R"#()#" 
          )
        .def("InitVertexIterator",
             (void (Adaptor3d_TopolTool::*)() ) static_cast<void (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::InitVertexIterator),
             R"#()#" 
          )
        .def("MoreVertex",
             (Standard_Boolean (Adaptor3d_TopolTool::*)() ) static_cast<Standard_Boolean (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::MoreVertex),
             R"#()#" 
          )
        .def("Vertex",
             (handle<Adaptor3d_HVertex> (Adaptor3d_TopolTool::*)() ) static_cast<handle<Adaptor3d_HVertex> (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::Vertex),
             R"#()#" 
          )
        .def("NextVertex",
             (void (Adaptor3d_TopolTool::*)() ) static_cast<void (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::NextVertex),
             R"#()#" 
          )
        .def("Classify",
             (TopAbs_State (Adaptor3d_TopolTool::*)(  const gp_Pnt2d & ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<TopAbs_State (Adaptor3d_TopolTool::*)(  const gp_Pnt2d & ,   const Standard_Real ,   const Standard_Boolean  ) >(&Adaptor3d_TopolTool::Classify),
             R"#()#"  , py::arg("P"),  py::arg("Tol"),  py::arg("ReacdreOnPeriodic")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("IsThePointOn",
             (Standard_Boolean (Adaptor3d_TopolTool::*)(  const gp_Pnt2d & ,   const Standard_Real ,   const Standard_Boolean  ) ) static_cast<Standard_Boolean (Adaptor3d_TopolTool::*)(  const gp_Pnt2d & ,   const Standard_Real ,   const Standard_Boolean  ) >(&Adaptor3d_TopolTool::IsThePointOn),
             R"#()#"  , py::arg("P"),  py::arg("Tol"),  py::arg("ReacdreOnPeriodic")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("Orientation",
             (TopAbs_Orientation (Adaptor3d_TopolTool::*)(  const handle<Adaptor2d_Curve2d> &  ) ) static_cast<TopAbs_Orientation (Adaptor3d_TopolTool::*)(  const handle<Adaptor2d_Curve2d> &  ) >(&Adaptor3d_TopolTool::Orientation),
             R"#(If the function returns the orientation of the arc. If the orientation is FORWARD or REVERSED, the arc is a "real" limit of the surface. If the orientation is INTERNAL or EXTERNAL, the arc is considered as an arc on the surface.)#"  , py::arg("C")
          )
        .def("Orientation",
             (TopAbs_Orientation (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> &  ) ) static_cast<TopAbs_Orientation (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> &  ) >(&Adaptor3d_TopolTool::Orientation),
             R"#(Returns the orientation of the vertex V. The vertex has been found with an exploration on a given arc. The orientation is the orientation of the vertex on this arc.)#"  , py::arg("V")
          )
        .def("Identical",
             (Standard_Boolean (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> & ,   const handle<Adaptor3d_HVertex> &  ) ) static_cast<Standard_Boolean (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> & ,   const handle<Adaptor3d_HVertex> &  ) >(&Adaptor3d_TopolTool::Identical),
             R"#(Returns True if the vertices V1 and V2 are identical. This method does not take the orientation of the vertices in account.)#"  , py::arg("V1"),  py::arg("V2")
          )
        .def("Has3d",
             (Standard_Boolean (Adaptor3d_TopolTool::*)() const) static_cast<Standard_Boolean (Adaptor3d_TopolTool::*)() const>(&Adaptor3d_TopolTool::Has3d),
             R"#(answers if arcs and vertices may have 3d representations, so that we could use Tol3d and Pnt methods.)#" 
          )
        .def("Tol3d",
             (Standard_Real (Adaptor3d_TopolTool::*)(  const handle<Adaptor2d_Curve2d> &  ) const) static_cast<Standard_Real (Adaptor3d_TopolTool::*)(  const handle<Adaptor2d_Curve2d> &  ) const>(&Adaptor3d_TopolTool::Tol3d),
             R"#(returns 3d tolerance of the arc C)#"  , py::arg("C")
          )
        .def("Tol3d",
             (Standard_Real (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> &  ) const) static_cast<Standard_Real (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> &  ) const>(&Adaptor3d_TopolTool::Tol3d),
             R"#(returns 3d tolerance of the vertex V)#"  , py::arg("V")
          )
        .def("Pnt",
             (gp_Pnt (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> &  ) const) static_cast<gp_Pnt (Adaptor3d_TopolTool::*)(  const handle<Adaptor3d_HVertex> &  ) const>(&Adaptor3d_TopolTool::Pnt),
             R"#(returns 3d point of the vertex V)#"  , py::arg("V")
          )
        .def("ComputeSamplePoints",
             (void (Adaptor3d_TopolTool::*)() ) static_cast<void (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::ComputeSamplePoints),
             R"#()#" 
          )
        .def("NbSamplesU",
             (Standard_Integer (Adaptor3d_TopolTool::*)() ) static_cast<Standard_Integer (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::NbSamplesU),
             R"#(compute the sample-points for the intersections algorithms)#" 
          )
        .def("NbSamplesV",
             (Standard_Integer (Adaptor3d_TopolTool::*)() ) static_cast<Standard_Integer (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::NbSamplesV),
             R"#(compute the sample-points for the intersections algorithms)#" 
          )
        .def("NbSamples",
             (Standard_Integer (Adaptor3d_TopolTool::*)() ) static_cast<Standard_Integer (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::NbSamples),
             R"#(compute the sample-points for the intersections algorithms)#" 
          )
        .def("UParameters",
             (void (Adaptor3d_TopolTool::*)( TColStd_Array1OfReal &  ) const) static_cast<void (Adaptor3d_TopolTool::*)( TColStd_Array1OfReal &  ) const>(&Adaptor3d_TopolTool::UParameters),
             R"#(return the set of U parameters on the surface obtained by the method SamplePnts)#"  , py::arg("theArray")
          )
        .def("VParameters",
             (void (Adaptor3d_TopolTool::*)( TColStd_Array1OfReal &  ) const) static_cast<void (Adaptor3d_TopolTool::*)( TColStd_Array1OfReal &  ) const>(&Adaptor3d_TopolTool::VParameters),
             R"#(return the set of V parameters on the surface obtained by the method SamplePnts)#"  , py::arg("theArray")
          )
        .def("SamplePoint",
             (void (Adaptor3d_TopolTool::*)(  const Standard_Integer ,  gp_Pnt2d & ,  gp_Pnt &  ) ) static_cast<void (Adaptor3d_TopolTool::*)(  const Standard_Integer ,  gp_Pnt2d & ,  gp_Pnt &  ) >(&Adaptor3d_TopolTool::SamplePoint),
             R"#()#"  , py::arg("Index"),  py::arg("P2d"),  py::arg("P3d")
          )
        .def("DomainIsInfinite",
             (Standard_Boolean (Adaptor3d_TopolTool::*)() ) static_cast<Standard_Boolean (Adaptor3d_TopolTool::*)() >(&Adaptor3d_TopolTool::DomainIsInfinite),
             R"#()#" 
          )
        .def("Edge",
             (Standard_Address (Adaptor3d_TopolTool::*)() const) static_cast<Standard_Address (Adaptor3d_TopolTool::*)() const>(&Adaptor3d_TopolTool::Edge),
             R"#()#" 
          )
        .def("SamplePnts",
             (void (Adaptor3d_TopolTool::*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (Adaptor3d_TopolTool::*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) >(&Adaptor3d_TopolTool::SamplePnts),
             R"#(Compute the sample-points for the intersections algorithms by adaptive algorithm for BSpline surfaces. For other surfaces algorithm is the same as in method ComputeSamplePoints(), but only fill arrays of U and V sample parameters;)#"  , py::arg("theDefl"),  py::arg("theNUmin"),  py::arg("theNVmin")
          )
        .def("BSplSamplePnts",
             (void (Adaptor3d_TopolTool::*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (Adaptor3d_TopolTool::*)(  const Standard_Real ,   const Standard_Integer ,   const Standard_Integer  ) >(&Adaptor3d_TopolTool::BSplSamplePnts),
             R"#(Compute the sample-points for the intersections algorithms by adaptive algorithm for BSpline surfaces - is used in SamplePnts)#"  , py::arg("theDefl"),  py::arg("theNUmin"),  py::arg("theNVmin")
          )
        .def("IsUniformSampling",
             (Standard_Boolean (Adaptor3d_TopolTool::*)() const) static_cast<Standard_Boolean (Adaptor3d_TopolTool::*)() const>(&Adaptor3d_TopolTool::IsUniformSampling),
             R"#(Returns true if provide uniform sampling of points.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor3d_TopolTool::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor3d_TopolTool::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
        .def_static("GetConeApexParam_s",
            []( const gp_Cone & theC ){
                Standard_Real  theU;
                Standard_Real  theV;

                Adaptor3d_TopolTool::GetConeApexParam(theC,theU,theV);
                
return std::make_tuple(theU,theV); },
            R"#(Computes the cone's apex parameters.)#"  , py::arg("theC")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor3d_TopolTool::*)() const) static_cast< const handle<Standard_Type> & (Adaptor3d_TopolTool::*)() const>(&Adaptor3d_TopolTool::DynamicType),
             R"#()#"
             
         )
;

    // Class Adaptor3d_CurveOnSurface from ./opencascade/Adaptor3d_CurveOnSurface.hxx
    klass = m.attr("Adaptor3d_CurveOnSurface");


    // nested enums

    static_cast<py::class_<Adaptor3d_CurveOnSurface ,opencascade::handle<Adaptor3d_CurveOnSurface>  , Adaptor3d_Curve >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<Adaptor3d_Surface> & >()  , py::arg("S") )
        .def(py::init<  const handle<Adaptor2d_Curve2d> &, const handle<Adaptor3d_Surface> & >()  , py::arg("C"),  py::arg("S") )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (handle<Adaptor3d_Curve> (Adaptor3d_CurveOnSurface::*)() const) static_cast<handle<Adaptor3d_Curve> (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Load",
             (void (Adaptor3d_CurveOnSurface::*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<void (Adaptor3d_CurveOnSurface::*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_CurveOnSurface::Load),
             R"#(Changes the surface.)#"  , py::arg("S")
          )
        .def("Load",
             (void (Adaptor3d_CurveOnSurface::*)(  const handle<Adaptor2d_Curve2d> &  ) ) static_cast<void (Adaptor3d_CurveOnSurface::*)(  const handle<Adaptor2d_Curve2d> &  ) >(&Adaptor3d_CurveOnSurface::Load),
             R"#(Changes the 2d curve.)#"  , py::arg("C")
          )
        .def("Load",
             (void (Adaptor3d_CurveOnSurface::*)(  const handle<Adaptor2d_Curve2d> & ,   const handle<Adaptor3d_Surface> &  ) ) static_cast<void (Adaptor3d_CurveOnSurface::*)(  const handle<Adaptor2d_Curve2d> & ,   const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_CurveOnSurface::Load),
             R"#(Load both curve and surface.)#"  , py::arg("C"),  py::arg("S")
          )
        .def("FirstParameter",
             (Standard_Real (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Real (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::FirstParameter),
             R"#()#" 
          )
        .def("LastParameter",
             (Standard_Real (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Real (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::LastParameter),
             R"#()#" 
          )
        .def("Continuity",
             (GeomAbs_Shape (Adaptor3d_CurveOnSurface::*)() const) static_cast<GeomAbs_Shape (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Continuity),
             R"#()#" 
          )
        .def("NbIntervals",
             (Standard_Integer (Adaptor3d_CurveOnSurface::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor3d_CurveOnSurface::*)(  const GeomAbs_Shape  ) const>(&Adaptor3d_CurveOnSurface::NbIntervals),
             R"#(Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("Intervals",
             (void (Adaptor3d_CurveOnSurface::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor3d_CurveOnSurface::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor3d_CurveOnSurface::Intervals),
             R"#(Stores in <T> the parameters bounding the intervals of continuity <S>.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("Trim",
             (handle<Adaptor3d_Curve> (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor3d_Curve> (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor3d_CurveOnSurface::Trim),
             R"#(Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsClosed",
             (Standard_Boolean (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Boolean (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::IsClosed),
             R"#()#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Boolean (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::IsPeriodic),
             R"#()#" 
          )
        .def("Period",
             (Standard_Real (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Real (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Period),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt (Adaptor3d_CurveOnSurface::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (Adaptor3d_CurveOnSurface::*)(  const Standard_Real  ) const>(&Adaptor3d_CurveOnSurface::Value),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U")
          )
        .def("D0",
             (void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt &  ) const>(&Adaptor3d_CurveOnSurface::D0),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("D1",
             (void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const>(&Adaptor3d_CurveOnSurface::D1),
             R"#(Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V")
          )
        .def("D2",
             (void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_CurveOnSurface::D2),
             R"#(Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def("D3",
             (void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_CurveOnSurface::D3),
             R"#(Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def("DN",
             (gp_Vec (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec (Adaptor3d_CurveOnSurface::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Adaptor3d_CurveOnSurface::DN),
             R"#(The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.)#"  , py::arg("U"),  py::arg("N")
          )
        .def("Resolution",
             (Standard_Real (Adaptor3d_CurveOnSurface::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor3d_CurveOnSurface::*)(  const Standard_Real  ) const>(&Adaptor3d_CurveOnSurface::Resolution),
             R"#(Returns the parametric resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_CurveType (Adaptor3d_CurveOnSurface::*)() const) static_cast<GeomAbs_CurveType (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::GetType),
             R"#(Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.)#" 
          )
        .def("Line",
             (gp_Lin (Adaptor3d_CurveOnSurface::*)() const) static_cast<gp_Lin (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Line),
             R"#()#" 
          )
        .def("Circle",
             (gp_Circ (Adaptor3d_CurveOnSurface::*)() const) static_cast<gp_Circ (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Circle),
             R"#()#" 
          )
        .def("Ellipse",
             (gp_Elips (Adaptor3d_CurveOnSurface::*)() const) static_cast<gp_Elips (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Ellipse),
             R"#()#" 
          )
        .def("Hyperbola",
             (gp_Hypr (Adaptor3d_CurveOnSurface::*)() const) static_cast<gp_Hypr (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Hyperbola),
             R"#()#" 
          )
        .def("Parabola",
             (gp_Parab (Adaptor3d_CurveOnSurface::*)() const) static_cast<gp_Parab (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Parabola),
             R"#()#" 
          )
        .def("Degree",
             (Standard_Integer (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Integer (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Degree),
             R"#()#" 
          )
        .def("IsRational",
             (Standard_Boolean (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Boolean (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::IsRational),
             R"#()#" 
          )
        .def("NbPoles",
             (Standard_Integer (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Integer (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::NbPoles),
             R"#()#" 
          )
        .def("NbKnots",
             (Standard_Integer (Adaptor3d_CurveOnSurface::*)() const) static_cast<Standard_Integer (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::NbKnots),
             R"#()#" 
          )
        .def("Bezier",
             (handle<Geom_BezierCurve> (Adaptor3d_CurveOnSurface::*)() const) static_cast<handle<Geom_BezierCurve> (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::Bezier),
             R"#()#" 
          )
        .def("BSpline",
             (handle<Geom_BSplineCurve> (Adaptor3d_CurveOnSurface::*)() const) static_cast<handle<Geom_BSplineCurve> (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::BSpline),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor3d_CurveOnSurface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor3d_CurveOnSurface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor3d_CurveOnSurface::*)() const) static_cast< const handle<Standard_Type> & (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::DynamicType),
             R"#()#"
             
         )
       .def("GetCurve",
             ( const handle<Adaptor2d_Curve2d> & (Adaptor3d_CurveOnSurface::*)() const) static_cast< const handle<Adaptor2d_Curve2d> & (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::GetCurve),
             R"#()#"
             
         )
       .def("GetSurface",
             ( const handle<Adaptor3d_Surface> & (Adaptor3d_CurveOnSurface::*)() const) static_cast< const handle<Adaptor3d_Surface> & (Adaptor3d_CurveOnSurface::*)() const>(&Adaptor3d_CurveOnSurface::GetSurface),
             R"#()#"
             
         )
       .def("ChangeCurve",
             (handle<Adaptor2d_Curve2d> & (Adaptor3d_CurveOnSurface::*)() ) static_cast<handle<Adaptor2d_Curve2d> & (Adaptor3d_CurveOnSurface::*)() >(&Adaptor3d_CurveOnSurface::ChangeCurve),
             R"#()#"
             
         )
       .def("ChangeSurface",
             (handle<Adaptor3d_Surface> & (Adaptor3d_CurveOnSurface::*)() ) static_cast<handle<Adaptor3d_Surface> & (Adaptor3d_CurveOnSurface::*)() >(&Adaptor3d_CurveOnSurface::ChangeSurface),
             R"#()#"
             
         )
;

    // Class Adaptor3d_IsoCurve from ./opencascade/Adaptor3d_IsoCurve.hxx
    klass = m.attr("Adaptor3d_IsoCurve");


    // nested enums

    static_cast<py::class_<Adaptor3d_IsoCurve ,opencascade::handle<Adaptor3d_IsoCurve>  , Adaptor3d_Curve >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<Adaptor3d_Surface> & >()  , py::arg("S") )
        .def(py::init<  const handle<Adaptor3d_Surface> &, const GeomAbs_IsoType, const Standard_Real >()  , py::arg("S"),  py::arg("Iso"),  py::arg("Param") )
        .def(py::init<  const handle<Adaptor3d_Surface> &, const GeomAbs_IsoType, const Standard_Real, const Standard_Real, const Standard_Real >()  , py::arg("S"),  py::arg("Iso"),  py::arg("Param"),  py::arg("WFirst"),  py::arg("WLast") )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (handle<Adaptor3d_Curve> (Adaptor3d_IsoCurve::*)() const) static_cast<handle<Adaptor3d_Curve> (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Load",
             (void (Adaptor3d_IsoCurve::*)(  const handle<Adaptor3d_Surface> &  ) ) static_cast<void (Adaptor3d_IsoCurve::*)(  const handle<Adaptor3d_Surface> &  ) >(&Adaptor3d_IsoCurve::Load),
             R"#(Changes the surface. The iso is reset to NoneIso.)#"  , py::arg("S")
          )
        .def("Load",
             (void (Adaptor3d_IsoCurve::*)(  const GeomAbs_IsoType ,   const Standard_Real  ) ) static_cast<void (Adaptor3d_IsoCurve::*)(  const GeomAbs_IsoType ,   const Standard_Real  ) >(&Adaptor3d_IsoCurve::Load),
             R"#(Changes the iso on the current surface.)#"  , py::arg("Iso"),  py::arg("Param")
          )
        .def("Load",
             (void (Adaptor3d_IsoCurve::*)(  const GeomAbs_IsoType ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (Adaptor3d_IsoCurve::*)(  const GeomAbs_IsoType ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&Adaptor3d_IsoCurve::Load),
             R"#(Changes the iso on the current surface.)#"  , py::arg("Iso"),  py::arg("Param"),  py::arg("WFirst"),  py::arg("WLast")
          )
        .def("Iso",
             (GeomAbs_IsoType (Adaptor3d_IsoCurve::*)() const) static_cast<GeomAbs_IsoType (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Iso),
             R"#()#" 
          )
        .def("Parameter",
             (Standard_Real (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Real (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Parameter),
             R"#()#" 
          )
        .def("FirstParameter",
             (Standard_Real (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Real (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::FirstParameter),
             R"#()#" 
          )
        .def("LastParameter",
             (Standard_Real (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Real (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::LastParameter),
             R"#()#" 
          )
        .def("Continuity",
             (GeomAbs_Shape (Adaptor3d_IsoCurve::*)() const) static_cast<GeomAbs_Shape (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Continuity),
             R"#()#" 
          )
        .def("NbIntervals",
             (Standard_Integer (Adaptor3d_IsoCurve::*)(  const GeomAbs_Shape  ) const) static_cast<Standard_Integer (Adaptor3d_IsoCurve::*)(  const GeomAbs_Shape  ) const>(&Adaptor3d_IsoCurve::NbIntervals),
             R"#(Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("Intervals",
             (void (Adaptor3d_IsoCurve::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const) static_cast<void (Adaptor3d_IsoCurve::*)( TColStd_Array1OfReal & ,   const GeomAbs_Shape  ) const>(&Adaptor3d_IsoCurve::Intervals),
             R"#(Stores in <T> the parameters bounding the intervals of continuity <S>.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("Trim",
             (handle<Adaptor3d_Curve> (Adaptor3d_IsoCurve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Adaptor3d_Curve> (Adaptor3d_IsoCurve::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&Adaptor3d_IsoCurve::Trim),
             R"#(Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsClosed",
             (Standard_Boolean (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Boolean (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::IsClosed),
             R"#()#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Boolean (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::IsPeriodic),
             R"#()#" 
          )
        .def("Period",
             (Standard_Real (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Real (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Period),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt (Adaptor3d_IsoCurve::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (Adaptor3d_IsoCurve::*)(  const Standard_Real  ) const>(&Adaptor3d_IsoCurve::Value),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U")
          )
        .def("D0",
             (void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt &  ) const>(&Adaptor3d_IsoCurve::D0),
             R"#(Computes the point of parameter U on the curve.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("D1",
             (void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const>(&Adaptor3d_IsoCurve::D1),
             R"#(Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V")
          )
        .def("D2",
             (void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_IsoCurve::D2),
             R"#(Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def("D3",
             (void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (Adaptor3d_IsoCurve::*)(  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&Adaptor3d_IsoCurve::D3),
             R"#(Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def("DN",
             (gp_Vec (Adaptor3d_IsoCurve::*)(  const Standard_Real ,   const Standard_Integer  ) const) static_cast<gp_Vec (Adaptor3d_IsoCurve::*)(  const Standard_Real ,   const Standard_Integer  ) const>(&Adaptor3d_IsoCurve::DN),
             R"#(The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.)#"  , py::arg("U"),  py::arg("N")
          )
        .def("Resolution",
             (Standard_Real (Adaptor3d_IsoCurve::*)(  const Standard_Real  ) const) static_cast<Standard_Real (Adaptor3d_IsoCurve::*)(  const Standard_Real  ) const>(&Adaptor3d_IsoCurve::Resolution),
             R"#(Returns the parametric resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_CurveType (Adaptor3d_IsoCurve::*)() const) static_cast<GeomAbs_CurveType (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::GetType),
             R"#(Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.)#" 
          )
        .def("Line",
             (gp_Lin (Adaptor3d_IsoCurve::*)() const) static_cast<gp_Lin (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Line),
             R"#()#" 
          )
        .def("Circle",
             (gp_Circ (Adaptor3d_IsoCurve::*)() const) static_cast<gp_Circ (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Circle),
             R"#()#" 
          )
        .def("Ellipse",
             (gp_Elips (Adaptor3d_IsoCurve::*)() const) static_cast<gp_Elips (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Ellipse),
             R"#()#" 
          )
        .def("Hyperbola",
             (gp_Hypr (Adaptor3d_IsoCurve::*)() const) static_cast<gp_Hypr (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Hyperbola),
             R"#()#" 
          )
        .def("Parabola",
             (gp_Parab (Adaptor3d_IsoCurve::*)() const) static_cast<gp_Parab (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Parabola),
             R"#()#" 
          )
        .def("Degree",
             (Standard_Integer (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Integer (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Degree),
             R"#()#" 
          )
        .def("IsRational",
             (Standard_Boolean (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Boolean (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::IsRational),
             R"#()#" 
          )
        .def("NbPoles",
             (Standard_Integer (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Integer (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::NbPoles),
             R"#()#" 
          )
        .def("NbKnots",
             (Standard_Integer (Adaptor3d_IsoCurve::*)() const) static_cast<Standard_Integer (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::NbKnots),
             R"#()#" 
          )
        .def("Bezier",
             (handle<Geom_BezierCurve> (Adaptor3d_IsoCurve::*)() const) static_cast<handle<Geom_BezierCurve> (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Bezier),
             R"#()#" 
          )
        .def("BSpline",
             (handle<Geom_BSplineCurve> (Adaptor3d_IsoCurve::*)() const) static_cast<handle<Geom_BSplineCurve> (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::BSpline),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&Adaptor3d_IsoCurve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&Adaptor3d_IsoCurve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (Adaptor3d_IsoCurve::*)() const) static_cast< const handle<Standard_Type> & (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::DynamicType),
             R"#()#"
             
         )
       .def("Surface",
             ( const handle<Adaptor3d_Surface> & (Adaptor3d_IsoCurve::*)() const) static_cast< const handle<Adaptor3d_Surface> & (Adaptor3d_IsoCurve::*)() const>(&Adaptor3d_IsoCurve::Surface),
             R"#()#"
             
         )
;

// functions

// ./opencascade/Adaptor3d_Curve.hxx
// ./opencascade/Adaptor3d_CurveOnSurface.hxx
// ./opencascade/Adaptor3d_HSurfaceTool.hxx
// ./opencascade/Adaptor3d_HVertex.hxx
// ./opencascade/Adaptor3d_InterFunc.hxx
// ./opencascade/Adaptor3d_IsoCurve.hxx
// ./opencascade/Adaptor3d_Surface.hxx
// ./opencascade/Adaptor3d_TopolTool.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
