
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <AdvApprox_Cutting.hxx>
#include <AdvApp2Var_Criterion.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <AdvApp2Var_Patch.hxx>
#include <AdvApp2Var_Context.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <AdvApp2Var_Context.hxx>
#include <AdvApp2Var_Node.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <AdvApp2Var_Context.hxx>
#include <AdvApp2Var_Framework.hxx>
#include <AdvApp2Var_Criterion.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <AdvApp2Var_ApproxAFunc2Var.hxx>
#include <AdvApp2Var_ApproxF2var.hxx>
#include <AdvApp2Var_Context.hxx>
#include <AdvApp2Var_Criterion.hxx>
#include <AdvApp2Var_CriterionRepartition.hxx>
#include <AdvApp2Var_CriterionType.hxx>
#include <AdvApp2Var_Data.hxx>
#include <AdvApp2Var_Data_f2c.hxx>
#include <AdvApp2Var_EvaluatorFunc2Var.hxx>
#include <AdvApp2Var_Framework.hxx>
#include <AdvApp2Var_Iso.hxx>
#include <AdvApp2Var_MathBase.hxx>
#include <AdvApp2Var_Network.hxx>
#include <AdvApp2Var_Node.hxx>
#include <AdvApp2Var_Patch.hxx>
#include <AdvApp2Var_SequenceOfNode.hxx>
#include <AdvApp2Var_SequenceOfPatch.hxx>
#include <AdvApp2Var_SequenceOfStrip.hxx>
#include <AdvApp2Var_Strip.hxx>
#include <AdvApp2Var_SysBase.hxx>

// template related includes

// ./opencascade/AdvApp2Var_SequenceOfNode.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/AdvApp2Var_SequenceOfPatch.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/AdvApp2Var_SequenceOfStrip.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/AdvApp2Var_Strip.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_AdvApp2Var(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("AdvApp2Var"));
py::object klass;

//Python trampoline classes
    class Py_AdvApp2Var_Criterion : public AdvApp2Var_Criterion{
    public:
        using AdvApp2Var_Criterion::AdvApp2Var_Criterion;


        // public pure virtual
        void Value(AdvApp2Var_Patch & P, const AdvApp2Var_Context & C) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AdvApp2Var_Criterion,Value,P,C) };
        Standard_Boolean IsSatisfied( const AdvApp2Var_Patch & P) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,AdvApp2Var_Criterion,IsSatisfied,P) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_AdvApp2Var_EvaluatorFunc2Var : public AdvApp2Var_EvaluatorFunc2Var{
    public:
        using AdvApp2Var_EvaluatorFunc2Var::AdvApp2Var_EvaluatorFunc2Var;


        // public pure virtual
        void Evaluate(Standard_Integer * theDimension,Standard_Real * theUStartEnd,Standard_Real * theVStartEnd,Standard_Integer * theFavorIso,Standard_Real * theConstParam,Standard_Integer * theNbParams,Standard_Real * theParameters,Standard_Integer * theUOrder,Standard_Integer * theVOrder,Standard_Real * theResult,Standard_Integer * theErrorCode) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AdvApp2Var_EvaluatorFunc2Var,Evaluate,theDimension,theUStartEnd,theVStartEnd,theFavorIso,theConstParam,theNbParams,theParameters,theUOrder,theVOrder,theResult,theErrorCode) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class AdvApp2Var_ApproxAFunc2Var from ./opencascade/AdvApp2Var_ApproxAFunc2Var.hxx
    klass = m.attr("AdvApp2Var_ApproxAFunc2Var");


    // nested enums

    static_cast<py::class_<AdvApp2Var_ApproxAFunc2Var , shared_ptr<AdvApp2Var_ApproxAFunc2Var>  >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer, const Standard_Integer, const Standard_Integer, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray2OfReal> &, const handle<TColStd_HArray2OfReal> &, const handle<TColStd_HArray2OfReal> &, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Real, const GeomAbs_IsoType, const GeomAbs_Shape, const GeomAbs_Shape, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const AdvApp2Var_EvaluatorFunc2Var &,AdvApprox_Cutting &,AdvApprox_Cutting & >()  , py::arg("Num1DSS"),  py::arg("Num2DSS"),  py::arg("Num3DSS"),  py::arg("OneDTol"),  py::arg("TwoDTol"),  py::arg("ThreeDTol"),  py::arg("OneDTolFr"),  py::arg("TwoDTolFr"),  py::arg("ThreeDTolFr"),  py::arg("FirstInU"),  py::arg("LastInU"),  py::arg("FirstInV"),  py::arg("LastInV"),  py::arg("FavorIso"),  py::arg("ContInU"),  py::arg("ContInV"),  py::arg("PrecisCode"),  py::arg("MaxDegInU"),  py::arg("MaxDegInV"),  py::arg("MaxPatch"),  py::arg("Func"),  py::arg("UChoice"),  py::arg("VChoice") )
        .def(py::init<  const Standard_Integer, const Standard_Integer, const Standard_Integer, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray2OfReal> &, const handle<TColStd_HArray2OfReal> &, const handle<TColStd_HArray2OfReal> &, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Real, const GeomAbs_IsoType, const GeomAbs_Shape, const GeomAbs_Shape, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const AdvApp2Var_EvaluatorFunc2Var &, const AdvApp2Var_Criterion &,AdvApprox_Cutting &,AdvApprox_Cutting & >()  , py::arg("Num1DSS"),  py::arg("Num2DSS"),  py::arg("Num3DSS"),  py::arg("OneDTol"),  py::arg("TwoDTol"),  py::arg("ThreeDTol"),  py::arg("OneDTolFr"),  py::arg("TwoDTolFr"),  py::arg("ThreeDTolFr"),  py::arg("FirstInU"),  py::arg("LastInU"),  py::arg("FirstInV"),  py::arg("LastInV"),  py::arg("FavorIso"),  py::arg("ContInU"),  py::arg("ContInV"),  py::arg("PrecisCode"),  py::arg("MaxDegInU"),  py::arg("MaxDegInV"),  py::arg("MaxPatch"),  py::arg("Func"),  py::arg("Crit"),  py::arg("UChoice"),  py::arg("VChoice") )
    // custom constructors
    // methods
        .def("IsDone",
             (Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::IsDone),
             R"#(True if the approximation succeeded within the imposed tolerances and the wished continuities)#" 
          )
        .def("HasResult",
             (Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::HasResult),
             R"#(True if the approximation did come out with a result that is not NECESSARELY within the required tolerance or a result that is not recognized with the wished continuities)#" 
          )
        .def("Surface",
             (handle<Geom_BSplineSurface> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<handle<Geom_BSplineSurface> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::Surface),
             R"#(returns the BSplineSurface of range Index)#"  , py::arg("Index")
          )
        .def("UDegree",
             (Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::UDegree),
             R"#()#" 
          )
        .def("VDegree",
             (Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::VDegree),
             R"#()#" 
          )
        .def("NumSubSpaces",
             (Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::NumSubSpaces),
             R"#()#"  , py::arg("Dimension")
          )
        .def("MaxError",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::MaxError),
             R"#(returns the errors max)#"  , py::arg("Dimension")
          )
        .def("AverageError",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::AverageError),
             R"#(returns the average errors)#"  , py::arg("Dimension")
          )
        .def("UFrontError",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::UFrontError),
             R"#(returns the errors max on UFrontiers Warning: Dimension must be equal to 3.)#"  , py::arg("Dimension")
          )
        .def("VFrontError",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::VFrontError),
             R"#(returns the errors max on VFrontiers Warning: Dimension must be equal to 3.)#"  , py::arg("Dimension")
          )
        .def("MaxError",
             (Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::MaxError),
             R"#(returns the error max of the BSplineSurface of range Index)#"  , py::arg("Dimension"),  py::arg("Index")
          )
        .def("AverageError",
             (Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::AverageError),
             R"#(returns the average error of the BSplineSurface of range Index)#"  , py::arg("Dimension"),  py::arg("Index")
          )
        .def("UFrontError",
             (Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::UFrontError),
             R"#(returns the error max of the BSplineSurface of range Index on a UFrontier)#"  , py::arg("Dimension"),  py::arg("Index")
          )
        .def("VFrontError",
             (Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::VFrontError),
             R"#(returns the error max of the BSplineSurface of range Index on a VFrontier)#"  , py::arg("Dimension"),  py::arg("Index")
          )
        .def("CritError",
             (Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::CritError),
             R"#()#"  , py::arg("Dimension"),  py::arg("Index")
          )
        .def("Dump",
             (void (AdvApp2Var_ApproxAFunc2Var::*)( Standard_OStream &  ) const) static_cast<void (AdvApp2Var_ApproxAFunc2Var::*)( Standard_OStream &  ) const>(&AdvApp2Var_ApproxAFunc2Var::Dump),
             R"#(Prints on the stream 'o' information on the current state of the object.)#"  , py::arg("o")
          )
        .def("IsDone",
             (Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::IsDone),
             R"#(True if the approximation succeeded within the imposed tolerances and the wished continuities)#" 
          )
        .def("HasResult",
             (Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Boolean (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::HasResult),
             R"#(True if the approximation did come out with a result that is not NECESSARELY within the required tolerance or a result that is not recognized with the wished continuities)#" 
          )
        .def("Surface",
             (handle<Geom_BSplineSurface> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<handle<Geom_BSplineSurface> (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::Surface),
             R"#(returns the BSplineSurface of range Index)#"  , py::arg("SSPIndex")
          )
        .def("UDegree",
             (Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::UDegree),
             R"#()#" 
          )
        .def("VDegree",
             (Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const) static_cast<Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)() const>(&AdvApp2Var_ApproxAFunc2Var::VDegree),
             R"#()#" 
          )
        .def("NumSubSpaces",
             (Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (AdvApp2Var_ApproxAFunc2Var::*)(  const Standard_Integer  ) const>(&AdvApp2Var_ApproxAFunc2Var::NumSubSpaces),
             R"#()#"  , py::arg("Dimension")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_ApproxF2var from ./opencascade/AdvApp2Var_ApproxF2var.hxx
    klass = m.attr("AdvApp2Var_ApproxF2var");

    // default constructor
    register_default_constructor<AdvApp2Var_ApproxF2var , shared_ptr<AdvApp2Var_ApproxF2var>>(m,"AdvApp2Var_ApproxF2var");

    // nested enums

    static_cast<py::class_<AdvApp2Var_ApproxF2var , shared_ptr<AdvApp2Var_ApproxF2var>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("mma2fnc__s",
                    (int (*)( integer * ,  integer * ,  integer * ,  doublereal * ,   const AdvApp2Var_EvaluatorFunc2Var & ,  doublereal * ,  integer * ,  integer * ,  doublereal * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  doublereal * ,  integer * ,  doublereal * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) ) static_cast<int (*)( integer * ,  integer * ,  integer * ,  doublereal * ,   const AdvApp2Var_EvaluatorFunc2Var & ,  doublereal * ,  integer * ,  integer * ,  doublereal * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  doublereal * ,  integer * ,  doublereal * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mma2fnc_),
                    R"#()#"  , py::arg("ndimen"),  py::arg("nbsesp"),  py::arg("ndimse"),  py::arg("uvfonc"),  py::arg("foncnp"),  py::arg("tconst"),  py::arg("isofav"),  py::arg("nbroot"),  py::arg("rootlg"),  py::arg("iordre"),  py::arg("ideriv"),  py::arg("ndgjac"),  py::arg("nbcrmx"),  py::arg("ncflim"),  py::arg("epsapr"),  py::arg("ncoeff"),  py::arg("courbe"),  py::arg("nbcrbe"),  py::arg("somtab"),  py::arg("diftab"),  py::arg("contr1"),  py::arg("contr2"),  py::arg("tabdec"),  py::arg("errmax"),  py::arg("errmoy"),  py::arg("iercod")
          )
        .def_static("mma2roo__s",
                    (int (*)( integer * ,  integer * ,  doublereal * ,  doublereal *  ) ) static_cast<int (*)( integer * ,  integer * ,  doublereal * ,  doublereal *  ) >(&AdvApp2Var_ApproxF2var::mma2roo_),
                    R"#()#"  , py::arg("nbpntu"),  py::arg("nbpntv"),  py::arg("urootl"),  py::arg("vrootl")
          )
        .def_static("mma2jmx__s",
                    (int (*)( integer * ,  integer * ,  doublereal *  ) ) static_cast<int (*)( integer * ,  integer * ,  doublereal *  ) >(&AdvApp2Var_ApproxF2var::mma2jmx_),
                    R"#()#"  , py::arg("ndgjac"),  py::arg("iordre"),  py::arg("xjacmx")
          )
        .def_static("mmapptt__s",
                    (int (*)(  const integer * ,   const integer * ,   const integer * ,  doublereal * ,  integer *  ) ) static_cast<int (*)(  const integer * ,   const integer * ,   const integer * ,  doublereal * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mmapptt_),
                    R"#()#"  , py::arg("arg0"),  py::arg("arg1"),  py::arg("arg2"),  py::arg("arg3"),  py::arg("arg4")
          )
        .def_static("mma2cdi__s",
                    (int (*)( integer * ,  integer * ,  doublereal * ,  integer * ,  doublereal * ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) ) static_cast<int (*)( integer * ,  integer * ,  doublereal * ,  integer * ,  doublereal * ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mma2cdi_),
                    R"#()#"  , py::arg("ndimen"),  py::arg("nbpntu"),  py::arg("urootl"),  py::arg("nbpntv"),  py::arg("vrootl"),  py::arg("iordru"),  py::arg("iordrv"),  py::arg("contr1"),  py::arg("contr2"),  py::arg("contr3"),  py::arg("contr4"),  py::arg("sotbu1"),  py::arg("sotbu2"),  py::arg("ditbu1"),  py::arg("ditbu2"),  py::arg("sotbv1"),  py::arg("sotbv2"),  py::arg("ditbv1"),  py::arg("ditbv2"),  py::arg("sosotb"),  py::arg("soditb"),  py::arg("disotb"),  py::arg("diditb"),  py::arg("iercod")
          )
        .def_static("mma2ds1__s",
                    (int (*)( integer * ,  doublereal * ,  doublereal * ,   const AdvApp2Var_EvaluatorFunc2Var & ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) ) static_cast<int (*)( integer * ,  doublereal * ,  doublereal * ,   const AdvApp2Var_EvaluatorFunc2Var & ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mma2ds1_),
                    R"#()#"  , py::arg("ndimen"),  py::arg("uintfn"),  py::arg("vintfn"),  py::arg("foncnp"),  py::arg("nbpntu"),  py::arg("nbpntv"),  py::arg("urootb"),  py::arg("vrootb"),  py::arg("isofav"),  py::arg("sosotb"),  py::arg("disotb"),  py::arg("soditb"),  py::arg("diditb"),  py::arg("fpntab"),  py::arg("ttable"),  py::arg("iercod")
          )
        .def_static("mma2ce1__s",
                    (int (*)( integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer * ,  integer * ,  integer * ,  integer *  ) ) static_cast<int (*)( integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer * ,  integer * ,  integer * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mma2ce1_),
                    R"#()#"  , py::arg("numdec"),  py::arg("ndimen"),  py::arg("nbsesp"),  py::arg("ndimse"),  py::arg("ndminu"),  py::arg("ndminv"),  py::arg("ndguli"),  py::arg("ndgvli"),  py::arg("ndjacu"),  py::arg("ndjacv"),  py::arg("iordru"),  py::arg("iordrv"),  py::arg("nbpntu"),  py::arg("nbpntv"),  py::arg("epsapr"),  py::arg("sosotb"),  py::arg("disotb"),  py::arg("soditb"),  py::arg("diditb"),  py::arg("patjac"),  py::arg("errmax"),  py::arg("errmoy"),  py::arg("ndegpu"),  py::arg("ndegpv"),  py::arg("itydec"),  py::arg("iercod")
          )
        .def_static("mma2can__s",
                    (int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) ) static_cast<int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,  doublereal * ,  doublereal * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mma2can_),
                    R"#()#"  , py::arg("arg0"),  py::arg("arg1"),  py::arg("arg2"),  py::arg("arg3"),  py::arg("arg4"),  py::arg("arg5"),  py::arg("arg6"),  py::arg("arg7"),  py::arg("arg8"),  py::arg("arg9"),  py::arg("arg10")
          )
        .def_static("mma1her__s",
                    (int (*)(  const integer * ,  doublereal * ,  integer *  ) ) static_cast<int (*)(  const integer * ,  doublereal * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mma1her_),
                    R"#()#"  , py::arg("arg0"),  py::arg("arg1"),  py::arg("arg2")
          )
        .def_static("mma2ac2__s",
                    (int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,   const integer * ,   const doublereal * ,   const doublereal * ,  doublereal *  ) ) static_cast<int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,   const integer * ,   const doublereal * ,   const doublereal * ,  doublereal *  ) >(&AdvApp2Var_ApproxF2var::mma2ac2_),
                    R"#()#"  , py::arg("arg0"),  py::arg("arg1"),  py::arg("arg2"),  py::arg("arg3"),  py::arg("arg4"),  py::arg("arg5"),  py::arg("arg6"),  py::arg("arg7"),  py::arg("arg8"),  py::arg("arg9"),  py::arg("arg10")
          )
        .def_static("mma2ac3__s",
                    (int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,   const integer * ,   const doublereal * ,   const doublereal * ,  doublereal *  ) ) static_cast<int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,   const integer * ,   const doublereal * ,   const doublereal * ,  doublereal *  ) >(&AdvApp2Var_ApproxF2var::mma2ac3_),
                    R"#()#"  , py::arg("arg0"),  py::arg("arg1"),  py::arg("arg2"),  py::arg("arg3"),  py::arg("arg4"),  py::arg("arg5"),  py::arg("arg6"),  py::arg("arg7"),  py::arg("arg8"),  py::arg("arg9"),  py::arg("arg10")
          )
        .def_static("mma2ac1__s",
                    (int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,  doublereal *  ) ) static_cast<int (*)(  const integer * ,   const integer * ,   const integer * ,   const integer * ,   const integer * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,   const doublereal * ,  doublereal *  ) >(&AdvApp2Var_ApproxF2var::mma2ac1_),
                    R"#()#"  , py::arg("arg0"),  py::arg("arg1"),  py::arg("arg2"),  py::arg("arg3"),  py::arg("arg4"),  py::arg("arg5"),  py::arg("arg6"),  py::arg("arg7"),  py::arg("arg8"),  py::arg("arg9"),  py::arg("arg10"),  py::arg("arg11")
          )
        .def_static("mma2fx6__s",
                    (int (*)( integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer * ,  integer *  ) ) static_cast<int (*)( integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  integer * ,  doublereal * ,  doublereal * ,  doublereal * ,  doublereal * ,  integer * ,  integer *  ) >(&AdvApp2Var_ApproxF2var::mma2fx6_),
                    R"#()#"  , py::arg("ncfmxu"),  py::arg("ncfmxv"),  py::arg("ndimen"),  py::arg("nbsesp"),  py::arg("ndimse"),  py::arg("nbupat"),  py::arg("nbvpat"),  py::arg("iordru"),  py::arg("iordrv"),  py::arg("epsapr"),  py::arg("epsfro"),  py::arg("patcan"),  py::arg("errmax"),  py::arg("ncoefu"),  py::arg("ncoefv")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_Context from ./opencascade/AdvApp2Var_Context.hxx
    klass = m.attr("AdvApp2Var_Context");


    // nested enums

    static_cast<py::class_<AdvApp2Var_Context , shared_ptr<AdvApp2Var_Context>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const Standard_Integer, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray1OfReal> &, const handle<TColStd_HArray2OfReal> &, const handle<TColStd_HArray2OfReal> &, const handle<TColStd_HArray2OfReal> & >()  , py::arg("ifav"),  py::arg("iu"),  py::arg("iv"),  py::arg("nlimu"),  py::arg("nlimv"),  py::arg("iprecis"),  py::arg("nb1Dss"),  py::arg("nb2Dss"),  py::arg("nb3Dss"),  py::arg("tol1D"),  py::arg("tol2D"),  py::arg("tol3D"),  py::arg("tof1D"),  py::arg("tof2D"),  py::arg("tof3D") )
    // custom constructors
    // methods
        .def("TotalDimension",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::TotalDimension),
             R"#()#" 
          )
        .def("TotalNumberSSP",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::TotalNumberSSP),
             R"#()#" 
          )
        .def("FavorIso",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::FavorIso),
             R"#()#" 
          )
        .def("UOrder",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::UOrder),
             R"#()#" 
          )
        .def("VOrder",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::VOrder),
             R"#()#" 
          )
        .def("ULimit",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::ULimit),
             R"#()#" 
          )
        .def("VLimit",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::VLimit),
             R"#()#" 
          )
        .def("UJacDeg",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::UJacDeg),
             R"#()#" 
          )
        .def("VJacDeg",
             (Standard_Integer (AdvApp2Var_Context::*)() const) static_cast<Standard_Integer (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::VJacDeg),
             R"#()#" 
          )
        .def("UJacMax",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::UJacMax),
             R"#()#" 
          )
        .def("VJacMax",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::VJacMax),
             R"#()#" 
          )
        .def("URoots",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::URoots),
             R"#()#" 
          )
        .def("VRoots",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::VRoots),
             R"#()#" 
          )
        .def("UGauss",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::UGauss),
             R"#()#" 
          )
        .def("VGauss",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::VGauss),
             R"#()#" 
          )
        .def("IToler",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::IToler),
             R"#()#" 
          )
        .def("FToler",
             (handle<TColStd_HArray2OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray2OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::FToler),
             R"#()#" 
          )
        .def("CToler",
             (handle<TColStd_HArray2OfReal> (AdvApp2Var_Context::*)() const) static_cast<handle<TColStd_HArray2OfReal> (AdvApp2Var_Context::*)() const>(&AdvApp2Var_Context::CToler),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_Criterion from ./opencascade/AdvApp2Var_Criterion.hxx
    klass = m.attr("AdvApp2Var_Criterion");


    // nested enums

    static_cast<py::class_<AdvApp2Var_Criterion , shared_ptr<AdvApp2Var_Criterion> ,Py_AdvApp2Var_Criterion >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Value",
             (void (AdvApp2Var_Criterion::*)( AdvApp2Var_Patch & ,   const AdvApp2Var_Context &  ) const) static_cast<void (AdvApp2Var_Criterion::*)( AdvApp2Var_Patch & ,   const AdvApp2Var_Context &  ) const>(&AdvApp2Var_Criterion::Value),
             R"#()#"  , py::arg("P"),  py::arg("C")
          )
        .def("IsSatisfied",
             (Standard_Boolean (AdvApp2Var_Criterion::*)(  const AdvApp2Var_Patch &  ) const) static_cast<Standard_Boolean (AdvApp2Var_Criterion::*)(  const AdvApp2Var_Patch &  ) const>(&AdvApp2Var_Criterion::IsSatisfied),
             R"#()#"  , py::arg("P")
          )
        .def("MaxValue",
             (Standard_Real (AdvApp2Var_Criterion::*)() const) static_cast<Standard_Real (AdvApp2Var_Criterion::*)() const>(&AdvApp2Var_Criterion::MaxValue),
             R"#()#" 
          )
        .def("Type",
             (AdvApp2Var_CriterionType (AdvApp2Var_Criterion::*)() const) static_cast<AdvApp2Var_CriterionType (AdvApp2Var_Criterion::*)() const>(&AdvApp2Var_Criterion::Type),
             R"#()#" 
          )
        .def("Repartition",
             (AdvApp2Var_CriterionRepartition (AdvApp2Var_Criterion::*)() const) static_cast<AdvApp2Var_CriterionRepartition (AdvApp2Var_Criterion::*)() const>(&AdvApp2Var_Criterion::Repartition),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_Data from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("AdvApp2Var_Data");

    // default constructor
    register_default_constructor<AdvApp2Var_Data , shared_ptr<AdvApp2Var_Data>>(m,"AdvApp2Var_Data");

    // nested enums

    static_cast<py::class_<AdvApp2Var_Data , shared_ptr<AdvApp2Var_Data>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Getmdnombr_s",
                    (mdnombr_1_ & (*)() ) static_cast<mdnombr_1_ & (*)() >(&AdvApp2Var_Data::Getmdnombr),
                    R"#()#" 
          )
        .def_static("Getminombr_s",
                    (minombr_1_ & (*)() ) static_cast<minombr_1_ & (*)() >(&AdvApp2Var_Data::Getminombr),
                    R"#()#" 
          )
        .def_static("Getmaovpar_s",
                    (maovpar_1_ & (*)() ) static_cast<maovpar_1_ & (*)() >(&AdvApp2Var_Data::Getmaovpar),
                    R"#()#" 
          )
        .def_static("Getmaovpch_s",
                    (maovpch_1_ & (*)() ) static_cast<maovpch_1_ & (*)() >(&AdvApp2Var_Data::Getmaovpch),
                    R"#()#" 
          )
        .def_static("Getmlgdrtl_s",
                    (mlgdrtl_1_ & (*)() ) static_cast<mlgdrtl_1_ & (*)() >(&AdvApp2Var_Data::Getmlgdrtl),
                    R"#()#" 
          )
        .def_static("Getmmjcobi_s",
                    (mmjcobi_1_ & (*)() ) static_cast<mmjcobi_1_ & (*)() >(&AdvApp2Var_Data::Getmmjcobi),
                    R"#()#" 
          )
        .def_static("Getmmcmcnp_s",
                    (mmcmcnp_1_ & (*)() ) static_cast<mmcmcnp_1_ & (*)() >(&AdvApp2Var_Data::Getmmcmcnp),
                    R"#()#" 
          )
        .def_static("Getmmapgss_s",
                    (mmapgss_1_ & (*)() ) static_cast<mmapgss_1_ & (*)() >(&AdvApp2Var_Data::Getmmapgss),
                    R"#()#" 
          )
        .def_static("Getmmapgs0_s",
                    (mmapgs0_1_ & (*)() ) static_cast<mmapgs0_1_ & (*)() >(&AdvApp2Var_Data::Getmmapgs0),
                    R"#()#" 
          )
        .def_static("Getmmapgs1_s",
                    (mmapgs1_1_ & (*)() ) static_cast<mmapgs1_1_ & (*)() >(&AdvApp2Var_Data::Getmmapgs1),
                    R"#()#" 
          )
        .def_static("Getmmapgs2_s",
                    (mmapgs2_1_ & (*)() ) static_cast<mmapgs2_1_ & (*)() >(&AdvApp2Var_Data::Getmmapgs2),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_EvaluatorFunc2Var from ./opencascade/AdvApp2Var_EvaluatorFunc2Var.hxx
    klass = m.attr("AdvApp2Var_EvaluatorFunc2Var");


    // nested enums

    static_cast<py::class_<AdvApp2Var_EvaluatorFunc2Var , shared_ptr<AdvApp2Var_EvaluatorFunc2Var> ,Py_AdvApp2Var_EvaluatorFunc2Var >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Evaluate",
             (void (AdvApp2Var_EvaluatorFunc2Var::*)( Standard_Integer * ,  Standard_Real * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer *  ) const) static_cast<void (AdvApp2Var_EvaluatorFunc2Var::*)( Standard_Integer * ,  Standard_Real * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer *  ) const>(&AdvApp2Var_EvaluatorFunc2Var::Evaluate),
             R"#(Function evaluation method to be defined by descendant)#"  , py::arg("theDimension"),  py::arg("theUStartEnd"),  py::arg("theVStartEnd"),  py::arg("theFavorIso"),  py::arg("theConstParam"),  py::arg("theNbParams"),  py::arg("theParameters"),  py::arg("theUOrder"),  py::arg("theVOrder"),  py::arg("theResult"),  py::arg("theErrorCode")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
        .def("__call__",
             (void (AdvApp2Var_EvaluatorFunc2Var::*)( Standard_Integer * ,  Standard_Real * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer *  ) const) static_cast<void (AdvApp2Var_EvaluatorFunc2Var::*)( Standard_Integer * ,  Standard_Real * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer * ,  Standard_Integer * ,  Standard_Real * ,  Standard_Integer *  ) const>(&AdvApp2Var_EvaluatorFunc2Var::operator()),
             py::is_operator(),
             R"#(Shortcut for function-call style usage)#"  , py::arg("theDimension"),  py::arg("theUStartEnd"),  py::arg("theVStartEnd"),  py::arg("theFavorIso"),  py::arg("theConstParam"),  py::arg("theNbParams"),  py::arg("theParameters"),  py::arg("theUOrder"),  py::arg("theVOrder"),  py::arg("theResult"),  py::arg("theErrorCode")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_Framework from ./opencascade/AdvApp2Var_Framework.hxx
    klass = m.attr("AdvApp2Var_Framework");


    // nested enums

    static_cast<py::class_<AdvApp2Var_Framework , shared_ptr<AdvApp2Var_Framework>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const AdvApp2Var_SequenceOfNode &, const AdvApp2Var_SequenceOfStrip &, const AdvApp2Var_SequenceOfStrip & >()  , py::arg("Frame"),  py::arg("UFrontier"),  py::arg("VFrontier") )
    // custom constructors
    // methods
        .def("FirstNotApprox",
             (handle<AdvApp2Var_Iso> (AdvApp2Var_Framework::*)( Standard_Integer & ,  Standard_Integer &  ) const) static_cast<handle<AdvApp2Var_Iso> (AdvApp2Var_Framework::*)( Standard_Integer & ,  Standard_Integer &  ) const>(&AdvApp2Var_Framework::FirstNotApprox),
             R"#(search the Index of the first Iso not approximated, if all Isos are approximated NULL is returned.)#"  , py::arg("IndexIso"),  py::arg("IndexStrip")
          )
        .def("FirstNode",
             (Standard_Integer (AdvApp2Var_Framework::*)(  const GeomAbs_IsoType ,   const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Integer (AdvApp2Var_Framework::*)(  const GeomAbs_IsoType ,   const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Framework::FirstNode),
             R"#()#"  , py::arg("Type"),  py::arg("IndexIso"),  py::arg("IndexStrip")
          )
        .def("LastNode",
             (Standard_Integer (AdvApp2Var_Framework::*)(  const GeomAbs_IsoType ,   const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Integer (AdvApp2Var_Framework::*)(  const GeomAbs_IsoType ,   const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Framework::LastNode),
             R"#()#"  , py::arg("Type"),  py::arg("IndexIso"),  py::arg("IndexStrip")
          )
        .def("ChangeIso",
             (void (AdvApp2Var_Framework::*)(  const Standard_Integer ,   const Standard_Integer ,   const handle<AdvApp2Var_Iso> &  ) ) static_cast<void (AdvApp2Var_Framework::*)(  const Standard_Integer ,   const Standard_Integer ,   const handle<AdvApp2Var_Iso> &  ) >(&AdvApp2Var_Framework::ChangeIso),
             R"#()#"  , py::arg("IndexIso"),  py::arg("IndexStrip"),  py::arg("anIso")
          )
        .def("Node",
             ( const handle<AdvApp2Var_Node> & (AdvApp2Var_Framework::*)(  const Standard_Integer  ) const) static_cast< const handle<AdvApp2Var_Node> & (AdvApp2Var_Framework::*)(  const Standard_Integer  ) const>(&AdvApp2Var_Framework::Node),
             R"#()#"  , py::arg("IndexNode")
          )
        .def("Node",
             ( const handle<AdvApp2Var_Node> & (AdvApp2Var_Framework::*)(  const Standard_Real ,   const Standard_Real  ) const) static_cast< const handle<AdvApp2Var_Node> & (AdvApp2Var_Framework::*)(  const Standard_Real ,   const Standard_Real  ) const>(&AdvApp2Var_Framework::Node),
             R"#()#"  , py::arg("U"),  py::arg("V")
          )
        .def("IsoU",
             ( const AdvApp2Var_Iso & (AdvApp2Var_Framework::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast< const AdvApp2Var_Iso & (AdvApp2Var_Framework::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&AdvApp2Var_Framework::IsoU),
             R"#()#"  , py::arg("U"),  py::arg("V0"),  py::arg("V1")
          )
        .def("IsoV",
             ( const AdvApp2Var_Iso & (AdvApp2Var_Framework::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const) static_cast< const AdvApp2Var_Iso & (AdvApp2Var_Framework::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) const>(&AdvApp2Var_Framework::IsoV),
             R"#()#"  , py::arg("U0"),  py::arg("U1"),  py::arg("V")
          )
        .def("UpdateInU",
             (void (AdvApp2Var_Framework::*)(  const Standard_Real  ) ) static_cast<void (AdvApp2Var_Framework::*)(  const Standard_Real  ) >(&AdvApp2Var_Framework::UpdateInU),
             R"#()#"  , py::arg("CuttingValue")
          )
        .def("UpdateInV",
             (void (AdvApp2Var_Framework::*)(  const Standard_Real  ) ) static_cast<void (AdvApp2Var_Framework::*)(  const Standard_Real  ) >(&AdvApp2Var_Framework::UpdateInV),
             R"#()#"  , py::arg("CuttingValue")
          )
        .def("UEquation",
             ( const handle<TColStd_HArray1OfReal> & (AdvApp2Var_Framework::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast< const handle<TColStd_HArray1OfReal> & (AdvApp2Var_Framework::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Framework::UEquation),
             R"#()#"  , py::arg("IndexIso"),  py::arg("IndexStrip")
          )
        .def("VEquation",
             ( const handle<TColStd_HArray1OfReal> & (AdvApp2Var_Framework::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast< const handle<TColStd_HArray1OfReal> & (AdvApp2Var_Framework::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Framework::VEquation),
             R"#()#"  , py::arg("IndexIso"),  py::arg("IndexStrip")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_Iso from ./opencascade/AdvApp2Var_Iso.hxx
    klass = m.attr("AdvApp2Var_Iso");


    // nested enums

    static_cast<py::class_<AdvApp2Var_Iso ,opencascade::handle<AdvApp2Var_Iso>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const GeomAbs_IsoType, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Integer, const Standard_Integer, const Standard_Integer >()  , py::arg("type"),  py::arg("cte"),  py::arg("Ufirst"),  py::arg("Ulast"),  py::arg("Vfirst"),  py::arg("Vlast"),  py::arg("pos"),  py::arg("iu"),  py::arg("iv") )
    // custom constructors
    // methods
        .def("IsApproximated",
             (Standard_Boolean (AdvApp2Var_Iso::*)() const) static_cast<Standard_Boolean (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::IsApproximated),
             R"#()#" 
          )
        .def("HasResult",
             (Standard_Boolean (AdvApp2Var_Iso::*)() const) static_cast<Standard_Boolean (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::HasResult),
             R"#()#" 
          )
        .def("MakeApprox",
             (void (AdvApp2Var_Iso::*)(  const AdvApp2Var_Context & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const AdvApp2Var_EvaluatorFunc2Var & ,  AdvApp2Var_Node & ,  AdvApp2Var_Node &  ) ) static_cast<void (AdvApp2Var_Iso::*)(  const AdvApp2Var_Context & ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const AdvApp2Var_EvaluatorFunc2Var & ,  AdvApp2Var_Node & ,  AdvApp2Var_Node &  ) >(&AdvApp2Var_Iso::MakeApprox),
             R"#()#"  , py::arg("Conditions"),  py::arg("a"),  py::arg("b"),  py::arg("c"),  py::arg("d"),  py::arg("func"),  py::arg("NodeBegin"),  py::arg("NodeEnd")
          )
        .def("ChangeDomain",
             (void (AdvApp2Var_Iso::*)(  const Standard_Real ,   const Standard_Real  ) ) static_cast<void (AdvApp2Var_Iso::*)(  const Standard_Real ,   const Standard_Real  ) >(&AdvApp2Var_Iso::ChangeDomain),
             R"#()#"  , py::arg("a"),  py::arg("b")
          )
        .def("ChangeDomain",
             (void (AdvApp2Var_Iso::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (AdvApp2Var_Iso::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&AdvApp2Var_Iso::ChangeDomain),
             R"#()#"  , py::arg("a"),  py::arg("b"),  py::arg("c"),  py::arg("d")
          )
        .def("SetConstante",
             (void (AdvApp2Var_Iso::*)(  const Standard_Real  ) ) static_cast<void (AdvApp2Var_Iso::*)(  const Standard_Real  ) >(&AdvApp2Var_Iso::SetConstante),
             R"#()#"  , py::arg("newcte")
          )
        .def("SetPosition",
             (void (AdvApp2Var_Iso::*)(  const Standard_Integer  ) ) static_cast<void (AdvApp2Var_Iso::*)(  const Standard_Integer  ) >(&AdvApp2Var_Iso::SetPosition),
             R"#()#"  , py::arg("newpos")
          )
        .def("ResetApprox",
             (void (AdvApp2Var_Iso::*)() ) static_cast<void (AdvApp2Var_Iso::*)() >(&AdvApp2Var_Iso::ResetApprox),
             R"#()#" 
          )
        .def("OverwriteApprox",
             (void (AdvApp2Var_Iso::*)() ) static_cast<void (AdvApp2Var_Iso::*)() >(&AdvApp2Var_Iso::OverwriteApprox),
             R"#()#" 
          )
        .def("Type",
             (GeomAbs_IsoType (AdvApp2Var_Iso::*)() const) static_cast<GeomAbs_IsoType (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::Type),
             R"#()#" 
          )
        .def("Constante",
             (Standard_Real (AdvApp2Var_Iso::*)() const) static_cast<Standard_Real (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::Constante),
             R"#()#" 
          )
        .def("T0",
             (Standard_Real (AdvApp2Var_Iso::*)() const) static_cast<Standard_Real (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::T0),
             R"#()#" 
          )
        .def("T1",
             (Standard_Real (AdvApp2Var_Iso::*)() const) static_cast<Standard_Real (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::T1),
             R"#()#" 
          )
        .def("U0",
             (Standard_Real (AdvApp2Var_Iso::*)() const) static_cast<Standard_Real (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::U0),
             R"#()#" 
          )
        .def("U1",
             (Standard_Real (AdvApp2Var_Iso::*)() const) static_cast<Standard_Real (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::U1),
             R"#()#" 
          )
        .def("V0",
             (Standard_Real (AdvApp2Var_Iso::*)() const) static_cast<Standard_Real (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::V0),
             R"#()#" 
          )
        .def("V1",
             (Standard_Real (AdvApp2Var_Iso::*)() const) static_cast<Standard_Real (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::V1),
             R"#()#" 
          )
        .def("UOrder",
             (Standard_Integer (AdvApp2Var_Iso::*)() const) static_cast<Standard_Integer (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::UOrder),
             R"#()#" 
          )
        .def("VOrder",
             (Standard_Integer (AdvApp2Var_Iso::*)() const) static_cast<Standard_Integer (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::VOrder),
             R"#()#" 
          )
        .def("Position",
             (Standard_Integer (AdvApp2Var_Iso::*)() const) static_cast<Standard_Integer (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::Position),
             R"#()#" 
          )
        .def("NbCoeff",
             (Standard_Integer (AdvApp2Var_Iso::*)() const) static_cast<Standard_Integer (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::NbCoeff),
             R"#()#" 
          )
        .def("SomTab",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Iso::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::SomTab),
             R"#()#" 
          )
        .def("DifTab",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Iso::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::DifTab),
             R"#()#" 
          )
        .def("MaxErrors",
             (handle<TColStd_HArray2OfReal> (AdvApp2Var_Iso::*)() const) static_cast<handle<TColStd_HArray2OfReal> (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::MaxErrors),
             R"#()#" 
          )
        .def("MoyErrors",
             (handle<TColStd_HArray2OfReal> (AdvApp2Var_Iso::*)() const) static_cast<handle<TColStd_HArray2OfReal> (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::MoyErrors),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&AdvApp2Var_Iso::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&AdvApp2Var_Iso::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (AdvApp2Var_Iso::*)() const) static_cast< const handle<Standard_Type> & (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::DynamicType),
             R"#()#"
             
         )
       .def("Polynom",
             ( const handle<TColStd_HArray1OfReal> & (AdvApp2Var_Iso::*)() const) static_cast< const handle<TColStd_HArray1OfReal> & (AdvApp2Var_Iso::*)() const>(&AdvApp2Var_Iso::Polynom),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class AdvApp2Var_Network from ./opencascade/AdvApp2Var_Network.hxx
    klass = m.attr("AdvApp2Var_Network");


    // nested enums

    static_cast<py::class_<AdvApp2Var_Network , shared_ptr<AdvApp2Var_Network>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const AdvApp2Var_SequenceOfPatch &, const TColStd_SequenceOfReal &, const TColStd_SequenceOfReal & >()  , py::arg("Net"),  py::arg("TheU"),  py::arg("TheV") )
    // custom constructors
    // methods
        .def("FirstNotApprox",
             (Standard_Boolean (AdvApp2Var_Network::*)( Standard_Integer &  ) const) static_cast<Standard_Boolean (AdvApp2Var_Network::*)( Standard_Integer &  ) const>(&AdvApp2Var_Network::FirstNotApprox),
             R"#(search the Index of the first Patch not approximated, if all Patches are approximated Standard_False is returned)#"  , py::arg("Index")
          )
        .def("ChangePatch",
             (AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer  ) ) static_cast<AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer  ) >(&AdvApp2Var_Network::ChangePatch),
             R"#()#"  , py::arg("Index")
          )
        .def("UpdateInU",
             (void (AdvApp2Var_Network::*)(  const Standard_Real  ) ) static_cast<void (AdvApp2Var_Network::*)(  const Standard_Real  ) >(&AdvApp2Var_Network::UpdateInU),
             R"#()#"  , py::arg("CuttingValue")
          )
        .def("UpdateInV",
             (void (AdvApp2Var_Network::*)(  const Standard_Real  ) ) static_cast<void (AdvApp2Var_Network::*)(  const Standard_Real  ) >(&AdvApp2Var_Network::UpdateInV),
             R"#()#"  , py::arg("CuttingValue")
          )
        .def("NbPatch",
             (Standard_Integer (AdvApp2Var_Network::*)() const) static_cast<Standard_Integer (AdvApp2Var_Network::*)() const>(&AdvApp2Var_Network::NbPatch),
             R"#()#" 
          )
        .def("NbPatchInU",
             (Standard_Integer (AdvApp2Var_Network::*)() const) static_cast<Standard_Integer (AdvApp2Var_Network::*)() const>(&AdvApp2Var_Network::NbPatchInU),
             R"#()#" 
          )
        .def("NbPatchInV",
             (Standard_Integer (AdvApp2Var_Network::*)() const) static_cast<Standard_Integer (AdvApp2Var_Network::*)() const>(&AdvApp2Var_Network::NbPatchInV),
             R"#()#" 
          )
        .def("UParameter",
             (Standard_Real (AdvApp2Var_Network::*)(  const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_Network::*)(  const Standard_Integer  ) const>(&AdvApp2Var_Network::UParameter),
             R"#()#"  , py::arg("Index")
          )
        .def("VParameter",
             (Standard_Real (AdvApp2Var_Network::*)(  const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_Network::*)(  const Standard_Integer  ) const>(&AdvApp2Var_Network::VParameter),
             R"#()#"  , py::arg("Index")
          )
        .def("Patch",
             ( const AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast< const AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Network::Patch),
             R"#()#"  , py::arg("UIndex"),  py::arg("VIndex")
          )
    // methods using call by reference i.s.o. return
        .def("SameDegree",
             []( AdvApp2Var_Network &self ,  const Standard_Integer iu, const Standard_Integer iv ){
                 Standard_Integer  ncfu;
                Standard_Integer  ncfv;

                 self.SameDegree(iu,iv,ncfu,ncfv);
                 
                 return std::make_tuple(ncfu,ncfv); },
             R"#()#"  , py::arg("iu"),  py::arg("iv")
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
        .def("__call__",
             (AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer  ) ) static_cast<AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer  ) >(&AdvApp2Var_Network::operator()),
             py::is_operator(),
             R"#()#"  , py::arg("Index")
          )
        .def("__call__",
             ( const AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast< const AdvApp2Var_Patch & (AdvApp2Var_Network::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Network::operator()),
             py::is_operator(),
             R"#()#"  , py::arg("UIndex"),  py::arg("VIndex")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class AdvApp2Var_Node from ./opencascade/AdvApp2Var_Node.hxx
    klass = m.attr("AdvApp2Var_Node");


    // nested enums

    static_cast<py::class_<AdvApp2Var_Node ,opencascade::handle<AdvApp2Var_Node>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Integer, const Standard_Integer >()  , py::arg("iu"),  py::arg("iv") )
        .def(py::init<  const gp_XY &, const Standard_Integer, const Standard_Integer >()  , py::arg("UV"),  py::arg("iu"),  py::arg("iv") )
    // custom constructors
    // methods
        .def("SetCoord",
             (void (AdvApp2Var_Node::*)(  const Standard_Real ,   const Standard_Real  ) ) static_cast<void (AdvApp2Var_Node::*)(  const Standard_Real ,   const Standard_Real  ) >(&AdvApp2Var_Node::SetCoord),
             R"#(changes the coordinates (U,V) to (x1,x2))#"  , py::arg("x1"),  py::arg("x2")
          )
        .def("UOrder",
             (Standard_Integer (AdvApp2Var_Node::*)() const) static_cast<Standard_Integer (AdvApp2Var_Node::*)() const>(&AdvApp2Var_Node::UOrder),
             R"#(returns the continuity order in U of the node)#" 
          )
        .def("VOrder",
             (Standard_Integer (AdvApp2Var_Node::*)() const) static_cast<Standard_Integer (AdvApp2Var_Node::*)() const>(&AdvApp2Var_Node::VOrder),
             R"#(returns the continuity order in V of the node)#" 
          )
        .def("SetPoint",
             (void (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer ,   const gp_Pnt &  ) ) static_cast<void (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer ,   const gp_Pnt &  ) >(&AdvApp2Var_Node::SetPoint),
             R"#(affects the value F(U,V) or its derivates on the node (U,V))#"  , py::arg("iu"),  py::arg("iv"),  py::arg("Pt")
          )
        .def("Point",
             ( const gp_Pnt & (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast< const gp_Pnt & (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Node::Point),
             R"#(returns the value F(U,V) or its derivates on the node (U,V))#"  , py::arg("iu"),  py::arg("iv")
          )
        .def("SetError",
             (void (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Real  ) ) static_cast<void (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Real  ) >(&AdvApp2Var_Node::SetError),
             R"#(affects the error between F(U,V) and its approximation)#"  , py::arg("iu"),  py::arg("iv"),  py::arg("error")
          )
        .def("Error",
             (Standard_Real (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Real (AdvApp2Var_Node::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&AdvApp2Var_Node::Error),
             R"#(returns the error between F(U,V) and its approximation)#"  , py::arg("iu"),  py::arg("iv")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&AdvApp2Var_Node::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&AdvApp2Var_Node::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (AdvApp2Var_Node::*)() const) static_cast< const handle<Standard_Type> & (AdvApp2Var_Node::*)() const>(&AdvApp2Var_Node::DynamicType),
             R"#()#"
             
         )
       .def("Coord",
             ( const gp_XY & (AdvApp2Var_Node::*)() const) static_cast< const gp_XY & (AdvApp2Var_Node::*)() const>(&AdvApp2Var_Node::Coord),
             R"#(Returns the coordinates (U,V) of the node)#"
             
         )
;

    // Class AdvApp2Var_Patch from ./opencascade/AdvApp2Var_Patch.hxx
    klass = m.attr("AdvApp2Var_Patch");


    // nested enums

    static_cast<py::class_<AdvApp2Var_Patch ,opencascade::handle<AdvApp2Var_Patch>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Real, const Standard_Integer, const Standard_Integer >()  , py::arg("U0"),  py::arg("U1"),  py::arg("V0"),  py::arg("V1"),  py::arg("iu"),  py::arg("iv") )
    // custom constructors
    // methods
        .def("IsDiscretised",
             (Standard_Boolean (AdvApp2Var_Patch::*)() const) static_cast<Standard_Boolean (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::IsDiscretised),
             R"#()#" 
          )
        .def("Discretise",
             (void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Context & ,   const AdvApp2Var_Framework & ,   const AdvApp2Var_EvaluatorFunc2Var &  ) ) static_cast<void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Context & ,   const AdvApp2Var_Framework & ,   const AdvApp2Var_EvaluatorFunc2Var &  ) >(&AdvApp2Var_Patch::Discretise),
             R"#()#"  , py::arg("Conditions"),  py::arg("Constraints"),  py::arg("func")
          )
        .def("IsApproximated",
             (Standard_Boolean (AdvApp2Var_Patch::*)() const) static_cast<Standard_Boolean (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::IsApproximated),
             R"#()#" 
          )
        .def("HasResult",
             (Standard_Boolean (AdvApp2Var_Patch::*)() const) static_cast<Standard_Boolean (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::HasResult),
             R"#()#" 
          )
        .def("MakeApprox",
             (void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Context & ,   const AdvApp2Var_Framework & ,   const Standard_Integer  ) ) static_cast<void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Context & ,   const AdvApp2Var_Framework & ,   const Standard_Integer  ) >(&AdvApp2Var_Patch::MakeApprox),
             R"#()#"  , py::arg("Conditions"),  py::arg("Constraints"),  py::arg("NumDec")
          )
        .def("AddConstraints",
             (void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Context & ,   const AdvApp2Var_Framework &  ) ) static_cast<void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Context & ,   const AdvApp2Var_Framework &  ) >(&AdvApp2Var_Patch::AddConstraints),
             R"#()#"  , py::arg("Conditions"),  py::arg("Constraints")
          )
        .def("AddErrors",
             (void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Framework &  ) ) static_cast<void (AdvApp2Var_Patch::*)(  const AdvApp2Var_Framework &  ) >(&AdvApp2Var_Patch::AddErrors),
             R"#()#"  , py::arg("Constraints")
          )
        .def("ChangeDomain",
             (void (AdvApp2Var_Patch::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (AdvApp2Var_Patch::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&AdvApp2Var_Patch::ChangeDomain),
             R"#()#"  , py::arg("a"),  py::arg("b"),  py::arg("c"),  py::arg("d")
          )
        .def("ResetApprox",
             (void (AdvApp2Var_Patch::*)() ) static_cast<void (AdvApp2Var_Patch::*)() >(&AdvApp2Var_Patch::ResetApprox),
             R"#()#" 
          )
        .def("OverwriteApprox",
             (void (AdvApp2Var_Patch::*)() ) static_cast<void (AdvApp2Var_Patch::*)() >(&AdvApp2Var_Patch::OverwriteApprox),
             R"#()#" 
          )
        .def("U0",
             (Standard_Real (AdvApp2Var_Patch::*)() const) static_cast<Standard_Real (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::U0),
             R"#()#" 
          )
        .def("U1",
             (Standard_Real (AdvApp2Var_Patch::*)() const) static_cast<Standard_Real (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::U1),
             R"#()#" 
          )
        .def("V0",
             (Standard_Real (AdvApp2Var_Patch::*)() const) static_cast<Standard_Real (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::V0),
             R"#()#" 
          )
        .def("V1",
             (Standard_Real (AdvApp2Var_Patch::*)() const) static_cast<Standard_Real (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::V1),
             R"#()#" 
          )
        .def("UOrder",
             (Standard_Integer (AdvApp2Var_Patch::*)() const) static_cast<Standard_Integer (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::UOrder),
             R"#()#" 
          )
        .def("VOrder",
             (Standard_Integer (AdvApp2Var_Patch::*)() const) static_cast<Standard_Integer (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::VOrder),
             R"#()#" 
          )
        .def("CutSense",
             (Standard_Integer (AdvApp2Var_Patch::*)() const) static_cast<Standard_Integer (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::CutSense),
             R"#()#" 
          )
        .def("CutSense",
             (Standard_Integer (AdvApp2Var_Patch::*)(  const AdvApp2Var_Criterion & ,   const Standard_Integer  ) const) static_cast<Standard_Integer (AdvApp2Var_Patch::*)(  const AdvApp2Var_Criterion & ,   const Standard_Integer  ) const>(&AdvApp2Var_Patch::CutSense),
             R"#()#"  , py::arg("Crit"),  py::arg("NumDec")
          )
        .def("NbCoeffInU",
             (Standard_Integer (AdvApp2Var_Patch::*)() const) static_cast<Standard_Integer (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::NbCoeffInU),
             R"#()#" 
          )
        .def("NbCoeffInV",
             (Standard_Integer (AdvApp2Var_Patch::*)() const) static_cast<Standard_Integer (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::NbCoeffInV),
             R"#()#" 
          )
        .def("ChangeNbCoeff",
             (void (AdvApp2Var_Patch::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (AdvApp2Var_Patch::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&AdvApp2Var_Patch::ChangeNbCoeff),
             R"#()#"  , py::arg("NbCoeffU"),  py::arg("NbCoeffV")
          )
        .def("Poles",
             (handle<TColgp_HArray2OfPnt> (AdvApp2Var_Patch::*)(  const Standard_Integer ,   const AdvApp2Var_Context &  ) const) static_cast<handle<TColgp_HArray2OfPnt> (AdvApp2Var_Patch::*)(  const Standard_Integer ,   const AdvApp2Var_Context &  ) const>(&AdvApp2Var_Patch::Poles),
             R"#()#"  , py::arg("SSPIndex"),  py::arg("Conditions")
          )
        .def("Coefficients",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Patch::*)(  const Standard_Integer ,   const AdvApp2Var_Context &  ) const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Patch::*)(  const Standard_Integer ,   const AdvApp2Var_Context &  ) const>(&AdvApp2Var_Patch::Coefficients),
             R"#()#"  , py::arg("SSPIndex"),  py::arg("Conditions")
          )
        .def("MaxErrors",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Patch::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::MaxErrors),
             R"#()#" 
          )
        .def("AverageErrors",
             (handle<TColStd_HArray1OfReal> (AdvApp2Var_Patch::*)() const) static_cast<handle<TColStd_HArray1OfReal> (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::AverageErrors),
             R"#()#" 
          )
        .def("IsoErrors",
             (handle<TColStd_HArray2OfReal> (AdvApp2Var_Patch::*)() const) static_cast<handle<TColStd_HArray2OfReal> (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::IsoErrors),
             R"#()#" 
          )
        .def("CritValue",
             (Standard_Real (AdvApp2Var_Patch::*)() const) static_cast<Standard_Real (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::CritValue),
             R"#()#" 
          )
        .def("SetCritValue",
             (void (AdvApp2Var_Patch::*)(  const Standard_Real  ) ) static_cast<void (AdvApp2Var_Patch::*)(  const Standard_Real  ) >(&AdvApp2Var_Patch::SetCritValue),
             R"#()#"  , py::arg("dist")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&AdvApp2Var_Patch::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&AdvApp2Var_Patch::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (AdvApp2Var_Patch::*)() const) static_cast< const handle<Standard_Type> & (AdvApp2Var_Patch::*)() const>(&AdvApp2Var_Patch::DynamicType),
             R"#()#"
             
         )
;

    // Class AdvApp2Var_SysBase from ./opencascade/AdvApp2Var_SysBase.hxx
    klass = m.attr("AdvApp2Var_SysBase");


    // nested enums

    static_cast<py::class_<AdvApp2Var_SysBase , shared_ptr<AdvApp2Var_SysBase>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("mainial_",
             (int (AdvApp2Var_SysBase::*)() ) static_cast<int (AdvApp2Var_SysBase::*)() >(&AdvApp2Var_SysBase::mainial_),
             R"#()#" 
          )
        .def("mcrdelt_",
             (int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  void * ,  intptr_t * ,  integer *  ) ) static_cast<int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  void * ,  intptr_t * ,  integer *  ) >(&AdvApp2Var_SysBase::mcrdelt_),
             R"#()#"  , py::arg("iunit"),  py::arg("isize"),  py::arg("t"),  py::arg("iofset"),  py::arg("iercod")
          )
        .def("mcrrqst_",
             (int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  void * ,  intptr_t * ,  integer *  ) ) static_cast<int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  void * ,  intptr_t * ,  integer *  ) >(&AdvApp2Var_SysBase::mcrrqst_),
             R"#()#"  , py::arg("iunit"),  py::arg("isize"),  py::arg("t"),  py::arg("iofset"),  py::arg("iercod")
          )
        .def("macrai4_",
             (int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  integer * ,  intptr_t * ,  integer *  ) ) static_cast<int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  integer * ,  intptr_t * ,  integer *  ) >(&AdvApp2Var_SysBase::macrai4_),
             R"#()#"  , py::arg("nbelem"),  py::arg("maxelm"),  py::arg("itablo"),  py::arg("iofset"),  py::arg("iercod")
          )
        .def("macrar8_",
             (int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  doublereal * ,  intptr_t * ,  integer *  ) ) static_cast<int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  doublereal * ,  intptr_t * ,  integer *  ) >(&AdvApp2Var_SysBase::macrar8_),
             R"#()#"  , py::arg("nbelem"),  py::arg("maxelm"),  py::arg("xtablo"),  py::arg("iofset"),  py::arg("iercod")
          )
        .def("macrdi4_",
             (int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  integer * ,  intptr_t * ,  integer *  ) ) static_cast<int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  integer * ,  intptr_t * ,  integer *  ) >(&AdvApp2Var_SysBase::macrdi4_),
             R"#()#"  , py::arg("nbelem"),  py::arg("maxelm"),  py::arg("itablo"),  py::arg("iofset"),  py::arg("iercod")
          )
        .def("macrdr8_",
             (int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  doublereal * ,  intptr_t * ,  integer *  ) ) static_cast<int (AdvApp2Var_SysBase::*)( integer * ,  integer * ,  doublereal * ,  intptr_t * ,  integer *  ) >(&AdvApp2Var_SysBase::macrdr8_),
             R"#()#"  , py::arg("nbelem"),  py::arg("maxelm"),  py::arg("xtablo"),  py::arg("iofset"),  py::arg("iercod")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("macinit__s",
                    (int (*)( int * ,  int *  ) ) static_cast<int (*)( int * ,  int *  ) >(&AdvApp2Var_SysBase::macinit_),
                    R"#()#"  , py::arg("arg0"),  py::arg("arg1")
          )
        .def_static("mcrfill__s",
                    (int (*)( integer * ,  void * ,  void *  ) ) static_cast<int (*)( integer * ,  void * ,  void *  ) >(&AdvApp2Var_SysBase::mcrfill_),
                    R"#()#"  , py::arg("size"),  py::arg("tin"),  py::arg("tout")
          )
        .def_static("mnfndeb__s",
                    (integer (*)() ) static_cast<integer (*)() >(&AdvApp2Var_SysBase::mnfndeb_),
                    R"#()#" 
          )
        .def_static("do__fio_s",
                    (int (*)() ) static_cast<int (*)() >(&AdvApp2Var_SysBase::do__fio),
                    R"#()#" 
          )
        .def_static("do__lio_s",
                    (int (*)() ) static_cast<int (*)() >(&AdvApp2Var_SysBase::do__lio),
                    R"#()#" 
          )
        .def_static("maermsg__s",
                    (int (*)(  const char * ,  integer * ,  ftnlen  ) ) static_cast<int (*)(  const char * ,  integer * ,  ftnlen  ) >(&AdvApp2Var_SysBase::maermsg_),
                    R"#()#"  , py::arg("cnompg"),  py::arg("icoder"),  py::arg("cnompg_len")
          )
        .def_static("maitbr8__s",
                    (int (*)( integer * ,  doublereal * ,  doublereal *  ) ) static_cast<int (*)( integer * ,  doublereal * ,  doublereal *  ) >(&AdvApp2Var_SysBase::maitbr8_),
                    R"#()#"  , py::arg("itaill"),  py::arg("xtab"),  py::arg("xval")
          )
        .def_static("maovsr8__s",
                    (int (*)( integer *  ) ) static_cast<int (*)( integer *  ) >(&AdvApp2Var_SysBase::maovsr8_),
                    R"#()#"  , py::arg("ivalcs")
          )
        .def_static("mgenmsg__s",
                    (int (*)(  const char * ,  ftnlen  ) ) static_cast<int (*)(  const char * ,  ftnlen  ) >(&AdvApp2Var_SysBase::mgenmsg_),
                    R"#()#"  , py::arg("nomprg"),  py::arg("nomprg_len")
          )
        .def_static("mgsomsg__s",
                    (int (*)(  const char * ,  ftnlen  ) ) static_cast<int (*)(  const char * ,  ftnlen  ) >(&AdvApp2Var_SysBase::mgsomsg_),
                    R"#()#"  , py::arg("nomprg"),  py::arg("nomprg_len")
          )
        .def_static("miraz__s",
                    (void (*)( integer * ,  void *  ) ) static_cast<void (*)( integer * ,  void *  ) >(&AdvApp2Var_SysBase::miraz_),
                    R"#()#"  , py::arg("taille"),  py::arg("adt")
          )
        .def_static("msifill__s",
                    (int (*)( integer * ,  integer * ,  integer *  ) ) static_cast<int (*)( integer * ,  integer * ,  integer *  ) >(&AdvApp2Var_SysBase::msifill_),
                    R"#()#"  , py::arg("nbintg"),  py::arg("ivecin"),  py::arg("ivecou")
          )
        .def_static("msrfill__s",
                    (int (*)( integer * ,  doublereal * ,  doublereal *  ) ) static_cast<int (*)( integer * ,  doublereal * ,  doublereal *  ) >(&AdvApp2Var_SysBase::msrfill_),
                    R"#()#"  , py::arg("nbreel"),  py::arg("vecent"),  py::arg("vecsor")
          )
        .def_static("mswrdbg__s",
                    (int (*)(  const char * ,  ftnlen  ) ) static_cast<int (*)(  const char * ,  ftnlen  ) >(&AdvApp2Var_SysBase::mswrdbg_),
                    R"#()#"  , py::arg("ctexte"),  py::arg("ctexte_len")
          )
        .def_static("mvriraz__s",
                    (void (*)( integer * ,  void *  ) ) static_cast<void (*)( integer * ,  void *  ) >(&AdvApp2Var_SysBase::mvriraz_),
                    R"#()#"  , py::arg("taille"),  py::arg("adt")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Namelist from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("Namelist");

    // default constructor
    register_default_constructor<Namelist , shared_ptr<Namelist>>(m,"Namelist");

    // nested enums

    static_cast<py::class_<Namelist , shared_ptr<Namelist>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Vardesc from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("Vardesc");

    // default constructor
    register_default_constructor<Vardesc , shared_ptr<Vardesc>>(m,"Vardesc");

    // nested enums

    static_cast<py::class_<Vardesc , shared_ptr<Vardesc>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class alist from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("alist");

    // default constructor
    register_default_constructor<alist , shared_ptr<alist>>(m,"alist");

    // nested enums

    static_cast<py::class_<alist , shared_ptr<alist>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("aerr", &alist::aerr)
        .def_readwrite("aunit", &alist::aunit)
    // methods returning by ref wrapped as properties
;

    // Class cilist from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("cilist");

    // default constructor
    register_default_constructor<cilist , shared_ptr<cilist>>(m,"cilist");

    // nested enums

    static_cast<py::class_<cilist , shared_ptr<cilist>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("cierr", &cilist::cierr)
        .def_readwrite("ciunit", &cilist::ciunit)
        .def_readwrite("ciend", &cilist::ciend)
        .def_readwrite("cirec", &cilist::cirec)
    // methods returning by ref wrapped as properties
;

    // Class cllist from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("cllist");

    // default constructor
    register_default_constructor<cllist , shared_ptr<cllist>>(m,"cllist");

    // nested enums

    static_cast<py::class_<cllist , shared_ptr<cllist>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("cerr", &cllist::cerr)
        .def_readwrite("cunit", &cllist::cunit)
    // methods returning by ref wrapped as properties
;

    // Class complex from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("complex");

    // default constructor
    register_default_constructor<complex , shared_ptr<complex>>(m,"complex");

    // nested enums

    static_cast<py::class_<complex , shared_ptr<complex>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("r", &complex::r)
        .def_readwrite("i", &complex::i)
    // methods returning by ref wrapped as properties
;

    // Class doublecomplex from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("doublecomplex");

    // default constructor
    register_default_constructor<doublecomplex , shared_ptr<doublecomplex>>(m,"doublecomplex");

    // nested enums

    static_cast<py::class_<doublecomplex , shared_ptr<doublecomplex>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("r", &doublecomplex::r)
        .def_readwrite("i", &doublecomplex::i)
    // methods returning by ref wrapped as properties
;

    // Class icilist from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("icilist");

    // default constructor
    register_default_constructor<icilist , shared_ptr<icilist>>(m,"icilist");

    // nested enums

    static_cast<py::class_<icilist , shared_ptr<icilist>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("icierr", &icilist::icierr)
        .def_readwrite("iciend", &icilist::iciend)
        .def_readwrite("icirlen", &icilist::icirlen)
        .def_readwrite("icirnum", &icilist::icirnum)
    // methods returning by ref wrapped as properties
;

    // Class inlist from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("inlist");

    // default constructor
    register_default_constructor<inlist , shared_ptr<inlist>>(m,"inlist");

    // nested enums

    static_cast<py::class_<inlist , shared_ptr<inlist>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("inerr", &inlist::inerr)
        .def_readwrite("inunit", &inlist::inunit)
        .def_readwrite("infilen", &inlist::infilen)
        .def_readwrite("innamlen", &inlist::innamlen)
        .def_readwrite("inacclen", &inlist::inacclen)
        .def_readwrite("inseqlen", &inlist::inseqlen)
        .def_readwrite("indirlen", &inlist::indirlen)
        .def_readwrite("infmtlen", &inlist::infmtlen)
        .def_readwrite("informlen", &inlist::informlen)
        .def_readwrite("inunflen", &inlist::inunflen)
        .def_readwrite("inblanklen", &inlist::inblanklen)
    // methods returning by ref wrapped as properties
;

    // Class maovpar_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("maovpar_1_");

    // default constructor
    register_default_constructor<maovpar_1_ , shared_ptr<maovpar_1_>>(m,"maovpar_1_");

    // nested enums

    static_cast<py::class_<maovpar_1_ , shared_ptr<maovpar_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("r8und", &maovpar_1_::r8und)
        .def_readwrite("r8ovr", &maovpar_1_::r8ovr)
        .def_readwrite("x4und", &maovpar_1_::x4und)
        .def_readwrite("x4ovr", &maovpar_1_::x4ovr)
        .def_readwrite("r4und", &maovpar_1_::r4und)
        .def_readwrite("r4ovr", &maovpar_1_::r4ovr)
        .def_readwrite("r4nbe", &maovpar_1_::r4nbe)
        .def_readwrite("r8nbm", &maovpar_1_::r8nbm)
        .def_readwrite("r8nbe", &maovpar_1_::r8nbe)
        .def_readwrite("i4ovr", &maovpar_1_::i4ovr)
        .def_readwrite("i4ovn", &maovpar_1_::i4ovn)
        .def_readwrite("r4exp", &maovpar_1_::r4exp)
        .def_readwrite("r8exp", &maovpar_1_::r8exp)
        .def_readwrite("r4exn", &maovpar_1_::r4exn)
        .def_readwrite("r8exn", &maovpar_1_::r8exn)
        .def_readwrite("r4ncs", &maovpar_1_::r4ncs)
        .def_readwrite("r8ncs", &maovpar_1_::r8ncs)
        .def_readwrite("r4nbm", &maovpar_1_::r4nbm)
        .def_readwrite("i2ovr", &maovpar_1_::i2ovr)
        .def_readwrite("i2ovn", &maovpar_1_::i2ovn)
    // methods returning by ref wrapped as properties
;

    // Class maovpch_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("maovpch_1_");

    // default constructor
    register_default_constructor<maovpch_1_ , shared_ptr<maovpch_1_>>(m,"maovpch_1_");

    // nested enums

    static_cast<py::class_<maovpch_1_ , shared_ptr<maovpch_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mdnombr_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mdnombr_1_");

    // default constructor
    register_default_constructor<mdnombr_1_ , shared_ptr<mdnombr_1_>>(m,"mdnombr_1_");

    // nested enums

    static_cast<py::class_<mdnombr_1_ , shared_ptr<mdnombr_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("pi", &mdnombr_1_::pi)
        .def_readwrite("deuxpi", &mdnombr_1_::deuxpi)
        .def_readwrite("pisur2", &mdnombr_1_::pisur2)
        .def_readwrite("pis180", &mdnombr_1_::pis180)
        .def_readwrite("c180pi", &mdnombr_1_::c180pi)
        .def_readwrite("zero", &mdnombr_1_::zero)
        .def_readwrite("one", &mdnombr_1_::one)
        .def_readwrite("a180", &mdnombr_1_::a180)
        .def_readwrite("a360", &mdnombr_1_::a360)
        .def_readwrite("a90", &mdnombr_1_::a90)
    // methods returning by ref wrapped as properties
;

    // Class minombr_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("minombr_1_");

    // default constructor
    register_default_constructor<minombr_1_ , shared_ptr<minombr_1_>>(m,"minombr_1_");

    // nested enums

    static_cast<py::class_<minombr_1_ , shared_ptr<minombr_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mlgdrtl_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mlgdrtl_1_");

    // default constructor
    register_default_constructor<mlgdrtl_1_ , shared_ptr<mlgdrtl_1_>>(m,"mlgdrtl_1_");

    // nested enums

    static_cast<py::class_<mlgdrtl_1_ , shared_ptr<mlgdrtl_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mmapgs0_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mmapgs0_1_");

    // default constructor
    register_default_constructor<mmapgs0_1_ , shared_ptr<mmapgs0_1_>>(m,"mmapgs0_1_");

    // nested enums

    static_cast<py::class_<mmapgs0_1_ , shared_ptr<mmapgs0_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mmapgs1_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mmapgs1_1_");

    // default constructor
    register_default_constructor<mmapgs1_1_ , shared_ptr<mmapgs1_1_>>(m,"mmapgs1_1_");

    // nested enums

    static_cast<py::class_<mmapgs1_1_ , shared_ptr<mmapgs1_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mmapgs2_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mmapgs2_1_");

    // default constructor
    register_default_constructor<mmapgs2_1_ , shared_ptr<mmapgs2_1_>>(m,"mmapgs2_1_");

    // nested enums

    static_cast<py::class_<mmapgs2_1_ , shared_ptr<mmapgs2_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mmapgss_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mmapgss_1_");

    // default constructor
    register_default_constructor<mmapgss_1_ , shared_ptr<mmapgss_1_>>(m,"mmapgss_1_");

    // nested enums

    static_cast<py::class_<mmapgss_1_ , shared_ptr<mmapgss_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mmcmcnp_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mmcmcnp_1_");

    // default constructor
    register_default_constructor<mmcmcnp_1_ , shared_ptr<mmcmcnp_1_>>(m,"mmcmcnp_1_");

    // nested enums

    static_cast<py::class_<mmcmcnp_1_ , shared_ptr<mmcmcnp_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class mmjcobi_1_ from ./opencascade/AdvApp2Var_Data.hxx
    klass = m.attr("mmjcobi_1_");

    // default constructor
    register_default_constructor<mmjcobi_1_ , shared_ptr<mmjcobi_1_>>(m,"mmjcobi_1_");

    // nested enums

    static_cast<py::class_<mmjcobi_1_ , shared_ptr<mmjcobi_1_>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class olist from ./opencascade/AdvApp2Var_Data_f2c.hxx
    klass = m.attr("olist");

    // default constructor
    register_default_constructor<olist , shared_ptr<olist>>(m,"olist");

    // nested enums

    static_cast<py::class_<olist , shared_ptr<olist>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("oerr", &olist::oerr)
        .def_readwrite("ounit", &olist::ounit)
        .def_readwrite("ofnmlen", &olist::ofnmlen)
        .def_readwrite("orl", &olist::orl)
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/AdvApp2Var_ApproxAFunc2Var.hxx
// ./opencascade/AdvApp2Var_ApproxF2var.hxx
// ./opencascade/AdvApp2Var_Context.hxx
// ./opencascade/AdvApp2Var_Criterion.hxx
// ./opencascade/AdvApp2Var_CriterionRepartition.hxx
// ./opencascade/AdvApp2Var_CriterionType.hxx
// ./opencascade/AdvApp2Var_Data.hxx
// ./opencascade/AdvApp2Var_Data_f2c.hxx
// ./opencascade/AdvApp2Var_EvaluatorFunc2Var.hxx
// ./opencascade/AdvApp2Var_Framework.hxx
// ./opencascade/AdvApp2Var_Iso.hxx
// ./opencascade/AdvApp2Var_MathBase.hxx
// ./opencascade/AdvApp2Var_Network.hxx
// ./opencascade/AdvApp2Var_Node.hxx
// ./opencascade/AdvApp2Var_Patch.hxx
// ./opencascade/AdvApp2Var_SequenceOfNode.hxx
// ./opencascade/AdvApp2Var_SequenceOfPatch.hxx
// ./opencascade/AdvApp2Var_SequenceOfStrip.hxx
// ./opencascade/AdvApp2Var_Strip.hxx
// ./opencascade/AdvApp2Var_SysBase.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_Sequence<opencascade::handle<AdvApp2Var_Node>>(m,"AdvApp2Var_SequenceOfNode");
    register_template_NCollection_Sequence<opencascade::handle<AdvApp2Var_Patch>>(m,"AdvApp2Var_SequenceOfPatch");
    register_template_NCollection_Sequence<AdvApp2Var_Strip>(m,"AdvApp2Var_SequenceOfStrip");
    register_template_NCollection_Sequence<opencascade::handle<AdvApp2Var_Iso>>(m,"AdvApp2Var_Strip");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
