
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Wire.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor3d_Curve.hxx>

// module includes
#include <BRepAlgo.hxx>
#include <BRepAlgo_AsDes.hxx>
#include <BRepAlgo_FaceRestrictor.hxx>
#include <BRepAlgo_Image.hxx>
#include <BRepAlgo_Loop.hxx>
#include <BRepAlgo_NormalProjection.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BRepAlgo_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BRepAlgo", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BRepAlgo , shared_ptr<BRepAlgo>  >(m,"BRepAlgo",R"#(The BRepAlgo class provides the following tools for: - Checking validity of the shape; - Concatenation of the edges of the wire.)#");
    py::class_<BRepAlgo_FaceRestrictor , shared_ptr<BRepAlgo_FaceRestrictor>  >(m,"BRepAlgo_FaceRestrictor",R"#(Builds all the faces limited with a set of non jointing and planars wires. if <ControlOrientation> is false The Wires must have correct orientations. Sinon orientation des wires de telle sorte que les faces ne soient pas infinies et qu'elles soient disjointes.)#");
    py::class_<BRepAlgo_Image , shared_ptr<BRepAlgo_Image>  >(m,"BRepAlgo_Image",R"#(Stores link between a shape <S> and a shape <NewS> obtained from <S>. <NewS> is an image of <S>.)#");
    py::class_<BRepAlgo_Loop , shared_ptr<BRepAlgo_Loop>  >(m,"BRepAlgo_Loop",R"#(Builds the loops from a set of edges on a face.)#");
    py::class_<BRepAlgo_NormalProjection , shared_ptr<BRepAlgo_NormalProjection>  >(m,"BRepAlgo_NormalProjection",R"#(This class makes the projection of a wire on a shape.)#");
    py::class_<BRepAlgo_AsDes ,opencascade::handle<BRepAlgo_AsDes>  , Standard_Transient >(m,"BRepAlgo_AsDes",R"#(SD to store descendants and ascendants of Shapes.SD to store descendants and ascendants of Shapes.SD to store descendants and ascendants of Shapes.)#");

};

// user-defined post-inclusion per module

// user-defined post
