
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BinDrivers.hxx>
#include <BinDrivers_DocumentRetrievalDriver.hxx>
#include <BinDrivers_DocumentStorageDriver.hxx>
#include <BinDrivers_Marker.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinDrivers_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BinDrivers", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<BinDrivers_Marker>(m, "BinDrivers_Marker",R"#()#")
        .value("BinDrivers_ENDATTRLIST",BinDrivers_Marker::BinDrivers_ENDATTRLIST)
        .value("BinDrivers_ENDLABEL",BinDrivers_Marker::BinDrivers_ENDLABEL).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BinDrivers , shared_ptr<BinDrivers>  >(m,"BinDrivers",R"#()#");
    py::class_<BinDrivers_DocumentRetrievalDriver ,opencascade::handle<BinDrivers_DocumentRetrievalDriver>  , BinLDrivers_DocumentRetrievalDriver >(m,"BinDrivers_DocumentRetrievalDriver",R"#()#");
    py::class_<BinDrivers_DocumentStorageDriver ,opencascade::handle<BinDrivers_DocumentStorageDriver>  , BinLDrivers_DocumentStorageDriver >(m,"BinDrivers_DocumentStorageDriver",R"#(persistent implementation of storage a document in a binary filepersistent implementation of storage a document in a binary filepersistent implementation of storage a document in a binary file)#");

};

// user-defined post-inclusion per module

// user-defined post
