
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>

// module includes
#include <BinMDataXtd.hxx>
#include <BinMDataXtd_ConstraintDriver.hxx>
#include <BinMDataXtd_GeometryDriver.hxx>
#include <BinMDataXtd_PatternStdDriver.hxx>
#include <BinMDataXtd_PositionDriver.hxx>
#include <BinMDataXtd_PresentationDriver.hxx>
#include <BinMDataXtd_TriangulationDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinMDataXtd_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BinMDataXtd", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BinMDataXtd , shared_ptr<BinMDataXtd>  >(m,"BinMDataXtd",R"#(Storage and Retrieval drivers for modelling attributes.)#");
    py::class_<BinMDataXtd_ConstraintDriver ,opencascade::handle<BinMDataXtd_ConstraintDriver>  , BinMDF_ADriver >(m,"BinMDataXtd_ConstraintDriver",R"#(Attribute Driver.Attribute Driver.Attribute Driver.)#");
    py::class_<BinMDataXtd_GeometryDriver ,opencascade::handle<BinMDataXtd_GeometryDriver>  , BinMDF_ADriver >(m,"BinMDataXtd_GeometryDriver",R"#(Attribute Driver.Attribute Driver.Attribute Driver.)#");
    py::class_<BinMDataXtd_PatternStdDriver ,opencascade::handle<BinMDataXtd_PatternStdDriver>  , BinMDF_ADriver >(m,"BinMDataXtd_PatternStdDriver",R"#(Attribute Driver.Attribute Driver.Attribute Driver.)#");
    py::class_<BinMDataXtd_PositionDriver ,opencascade::handle<BinMDataXtd_PositionDriver>  , BinMDF_ADriver >(m,"BinMDataXtd_PositionDriver",R"#(Position Attribute Driver.Position Attribute Driver.Position Attribute Driver.)#");
    py::class_<BinMDataXtd_PresentationDriver ,opencascade::handle<BinMDataXtd_PresentationDriver>  , BinMDF_ADriver >(m,"BinMDataXtd_PresentationDriver",R"#(Presentation Attribute Driver.Presentation Attribute Driver.Presentation Attribute Driver.)#");
    py::class_<BinMDataXtd_TriangulationDriver ,opencascade::handle<BinMDataXtd_TriangulationDriver>  , BinMDF_ADriver >(m,"BinMDataXtd_TriangulationDriver",R"#(TDataXtd_Triangulation attribute bin Driver.TDataXtd_Triangulation attribute bin Driver.)#");

};

// user-defined post-inclusion per module

// user-defined post
