
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>

// module includes
#include <BinMNaming.hxx>
#include <BinMNaming_NamedShapeDriver.hxx>
#include <BinMNaming_NamingDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinMNaming(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinMNaming"));
py::object klass;

//Python trampoline classes

// classes

    // Class BinMNaming from ./opencascade/BinMNaming.hxx
    klass = m.attr("BinMNaming");

    // default constructor
    register_default_constructor<BinMNaming , shared_ptr<BinMNaming>>(m,"BinMNaming");

    // nested enums

    static_cast<py::class_<BinMNaming , shared_ptr<BinMNaming>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&BinMNaming::AddDrivers),
                    R"#(Adds the attribute drivers to <theDriverTable>.)#"  , py::arg("theDriverTable"),  py::arg("aMsgDrv")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinMNaming_NamedShapeDriver from ./opencascade/BinMNaming_NamedShapeDriver.hxx
    klass = m.attr("BinMNaming_NamedShapeDriver");


    // nested enums

    static_cast<py::class_<BinMNaming_NamedShapeDriver ,opencascade::handle<BinMNaming_NamedShapeDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinMNaming_NamedShapeDriver::*)() const) static_cast<handle<TDF_Attribute> (BinMNaming_NamedShapeDriver::*)() const>(&BinMNaming_NamedShapeDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMNaming_NamedShapeDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMNaming_NamedShapeDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMNaming_NamedShapeDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMNaming_NamedShapeDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinMNaming_NamedShapeDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinMNaming_NamedShapeDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("ReadShapeSection",
             (void (BinMNaming_NamedShapeDriver::*)( Standard_IStream & ,   const Message_ProgressRange &  ) ) static_cast<void (BinMNaming_NamedShapeDriver::*)( Standard_IStream & ,   const Message_ProgressRange &  ) >(&BinMNaming_NamedShapeDriver::ReadShapeSection),
             R"#(Input the shapes from Bin Document file)#"  , py::arg("theIS"),  py::arg("therange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("WriteShapeSection",
             (void (BinMNaming_NamedShapeDriver::*)( Standard_OStream & ,   const Standard_Integer ,   const Message_ProgressRange &  ) ) static_cast<void (BinMNaming_NamedShapeDriver::*)( Standard_OStream & ,   const Standard_Integer ,   const Message_ProgressRange &  ) >(&BinMNaming_NamedShapeDriver::WriteShapeSection),
             R"#(Output the shapes into Bin Document file)#"  , py::arg("theOS"),  py::arg("theDocVer"),  py::arg("therange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Clear",
             (void (BinMNaming_NamedShapeDriver::*)() ) static_cast<void (BinMNaming_NamedShapeDriver::*)() >(&BinMNaming_NamedShapeDriver::Clear),
             R"#(Clear myShapeSet)#" 
          )
        .def("IsWithTriangles",
             (Standard_Boolean (BinMNaming_NamedShapeDriver::*)() const) static_cast<Standard_Boolean (BinMNaming_NamedShapeDriver::*)() const>(&BinMNaming_NamedShapeDriver::IsWithTriangles),
             R"#(Return true if shape should be stored with triangles.)#" 
          )
        .def("IsWithNormals",
             (Standard_Boolean (BinMNaming_NamedShapeDriver::*)() const) static_cast<Standard_Boolean (BinMNaming_NamedShapeDriver::*)() const>(&BinMNaming_NamedShapeDriver::IsWithNormals),
             R"#(Return true if shape should be stored with triangulation normals.)#" 
          )
        .def("SetWithTriangles",
             (void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) ) static_cast<void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) >(&BinMNaming_NamedShapeDriver::SetWithTriangles),
             R"#(set whether to store triangulation)#"  , py::arg("isWithTriangles")
          )
        .def("SetWithNormals",
             (void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) ) static_cast<void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) >(&BinMNaming_NamedShapeDriver::SetWithNormals),
             R"#(set whether to store triangulation with normals)#"  , py::arg("isWithNormals")
          )
        .def("EnableQuickPart",
             (void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) ) static_cast<void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) >(&BinMNaming_NamedShapeDriver::EnableQuickPart),
             R"#(Sets the flag for quick part of the document access: shapes are stored in the attribute.)#"  , py::arg("theValue")
          )
        .def("IsQuickPart",
             (Standard_Boolean (BinMNaming_NamedShapeDriver::*)() ) static_cast<Standard_Boolean (BinMNaming_NamedShapeDriver::*)() >(&BinMNaming_NamedShapeDriver::IsQuickPart),
             R"#(Returns true if quick part of the document access is enabled: shapes are stored in the attribute.)#" 
          )
        .def("ShapeSet",
             (BinTools_ShapeSetBase * (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) ) static_cast<BinTools_ShapeSetBase * (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) >(&BinMNaming_NamedShapeDriver::ShapeSet),
             R"#(Returns shape-set of the needed type)#"  , py::arg("theReading")
          )
        .def("SetWithTriangles",
             (void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) ) static_cast<void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) >(&BinMNaming_NamedShapeDriver::SetWithTriangles),
             R"#(set whether to store triangulation)#"  , py::arg("isWithTriangles")
          )
        .def("SetWithNormals",
             (void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) ) static_cast<void (BinMNaming_NamedShapeDriver::*)(  const Standard_Boolean  ) >(&BinMNaming_NamedShapeDriver::SetWithNormals),
             R"#(set whether to store triangulation with normals)#"  , py::arg("isWithNormals")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMNaming_NamedShapeDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMNaming_NamedShapeDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetShapesLocations",
             (BinTools_LocationSet & (BinMNaming_NamedShapeDriver::*)() const) static_cast<BinTools_LocationSet & (BinMNaming_NamedShapeDriver::*)() const>(&BinMNaming_NamedShapeDriver::GetShapesLocations),
             R"#(get the shapes locations)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMNaming_NamedShapeDriver::*)() const) static_cast< const handle<Standard_Type> & (BinMNaming_NamedShapeDriver::*)() const>(&BinMNaming_NamedShapeDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinMNaming_NamingDriver from ./opencascade/BinMNaming_NamingDriver.hxx
    klass = m.attr("BinMNaming_NamingDriver");


    // nested enums

    static_cast<py::class_<BinMNaming_NamingDriver ,opencascade::handle<BinMNaming_NamingDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinMNaming_NamingDriver::*)() const) static_cast<handle<TDF_Attribute> (BinMNaming_NamingDriver::*)() const>(&BinMNaming_NamingDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMNaming_NamingDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMNaming_NamingDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMNaming_NamingDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMNaming_NamingDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinMNaming_NamingDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinMNaming_NamingDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMNaming_NamingDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMNaming_NamingDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMNaming_NamingDriver::*)() const) static_cast< const handle<Standard_Type> & (BinMNaming_NamingDriver::*)() const>(&BinMNaming_NamingDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/BinMNaming.hxx
// ./opencascade/BinMNaming_NamedShapeDriver.hxx
// ./opencascade/BinMNaming_NamingDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
