
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>

// module includes
#include <BinXCAFDrivers.hxx>
#include <BinXCAFDrivers_DocumentRetrievalDriver.hxx>
#include <BinXCAFDrivers_DocumentStorageDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinXCAFDrivers(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinXCAFDrivers"));
py::object klass;

//Python trampoline classes

// classes

    // Class BinXCAFDrivers from ./opencascade/BinXCAFDrivers.hxx
    klass = m.attr("BinXCAFDrivers");

    // default constructor
    register_default_constructor<BinXCAFDrivers , shared_ptr<BinXCAFDrivers>>(m,"BinXCAFDrivers");

    // nested enums

    static_cast<py::class_<BinXCAFDrivers , shared_ptr<BinXCAFDrivers>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Factory_s",
                    ( const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) ) static_cast< const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) >(&BinXCAFDrivers::Factory),
                    R"#()#"  , py::arg("theGUID")
          )
        .def_static("DefineFormat_s",
                    (void (*)(  const handle<TDocStd_Application> &  ) ) static_cast<void (*)(  const handle<TDocStd_Application> &  ) >(&BinXCAFDrivers::DefineFormat),
                    R"#(Defines format "BinXCAF" and registers its read and write drivers in the specified application)#"  , py::arg("theApp")
          )
        .def_static("AttributeDrivers_s",
                    (handle<BinMDF_ADriverTable> (*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (*)(  const handle<Message_Messenger> &  ) >(&BinXCAFDrivers::AttributeDrivers),
                    R"#(Creates the table of drivers of types supported)#"  , py::arg("MsgDrv")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinXCAFDrivers_DocumentRetrievalDriver from ./opencascade/BinXCAFDrivers_DocumentRetrievalDriver.hxx
    klass = m.attr("BinXCAFDrivers_DocumentRetrievalDriver");


    // nested enums

    static_cast<py::class_<BinXCAFDrivers_DocumentRetrievalDriver ,opencascade::handle<BinXCAFDrivers_DocumentRetrievalDriver>  , BinDrivers_DocumentRetrievalDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<BinMDF_ADriverTable> (BinXCAFDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (BinXCAFDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) >(&BinXCAFDrivers_DocumentRetrievalDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinXCAFDrivers_DocumentRetrievalDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinXCAFDrivers_DocumentRetrievalDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinXCAFDrivers_DocumentRetrievalDriver::*)() const) static_cast< const handle<Standard_Type> & (BinXCAFDrivers_DocumentRetrievalDriver::*)() const>(&BinXCAFDrivers_DocumentRetrievalDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinXCAFDrivers_DocumentStorageDriver from ./opencascade/BinXCAFDrivers_DocumentStorageDriver.hxx
    klass = m.attr("BinXCAFDrivers_DocumentStorageDriver");


    // nested enums

    static_cast<py::class_<BinXCAFDrivers_DocumentStorageDriver ,opencascade::handle<BinXCAFDrivers_DocumentStorageDriver>  , BinDrivers_DocumentStorageDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<BinMDF_ADriverTable> (BinXCAFDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (BinXCAFDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) >(&BinXCAFDrivers_DocumentStorageDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinXCAFDrivers_DocumentStorageDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinXCAFDrivers_DocumentStorageDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinXCAFDrivers_DocumentStorageDriver::*)() const) static_cast< const handle<Standard_Type> & (BinXCAFDrivers_DocumentStorageDriver::*)() const>(&BinXCAFDrivers_DocumentStorageDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/BinXCAFDrivers.hxx
// ./opencascade/BinXCAFDrivers_DocumentRetrievalDriver.hxx
// ./opencascade/BinXCAFDrivers_DocumentStorageDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
