
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>

// module includes
#include <BinXCAFDrivers.hxx>
#include <BinXCAFDrivers_DocumentRetrievalDriver.hxx>
#include <BinXCAFDrivers_DocumentStorageDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinXCAFDrivers_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BinXCAFDrivers", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BinXCAFDrivers , shared_ptr<BinXCAFDrivers>  >(m,"BinXCAFDrivers",R"#()#");
    py::class_<BinXCAFDrivers_DocumentRetrievalDriver ,opencascade::handle<BinXCAFDrivers_DocumentRetrievalDriver>  , BinDrivers_DocumentRetrievalDriver >(m,"BinXCAFDrivers_DocumentRetrievalDriver",R"#()#");
    py::class_<BinXCAFDrivers_DocumentStorageDriver ,opencascade::handle<BinXCAFDrivers_DocumentStorageDriver>  , BinDrivers_DocumentStorageDriver >(m,"BinXCAFDrivers_DocumentStorageDriver",R"#()#");

};

// user-defined post-inclusion per module

// user-defined post
