
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <CDM_Document.hxx>
#include <PCDM_Reader.hxx>
#include <CDM_MetaData.hxx>
#include <PCDM_RetrievalDriver.hxx>
#include <PCDM_StorageDriver.hxx>
#include <CDF_Directory.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDF_Directory.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_MetaData.hxx>
#include <CDM_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_MetaData.hxx>
#include <TCollection_ExtendedString.hxx>
#include <CDM_Document.hxx>
#include <PCDM_ReferenceIterator.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDF_MetaDataDriver.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDF_StoreList.hxx>
#include <CDM_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_MetaData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <CDF_Application.hxx>
#include <CDF_Directory.hxx>
#include <CDF_DirectoryIterator.hxx>
#include <CDF_FWOSDriver.hxx>
#include <CDF_MetaDataDriver.hxx>
#include <CDF_MetaDataDriverFactory.hxx>
#include <CDF_Store.hxx>
#include <CDF_StoreList.hxx>
#include <CDF_StoreSetNameStatus.hxx>
#include <CDF_SubComponentStatus.hxx>
#include <CDF_TryStoreStatus.hxx>
#include <CDF_TypeOfActivation.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <Resource_Manager.hxx>
#include <PCDM_ReaderFilter.hxx>
#include <Message_ProgressRange.hxx>

// Module definiiton
void register_CDF(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("CDF"));
py::object klass;

//Python trampoline classes
    class Py_CDF_Application : public CDF_Application{
    public:
        using CDF_Application::CDF_Application;


        // public pure virtual

        handle<Resource_Manager> Resources() override { using return_type = handle<Resource_Manager>;
    PYBIND11_OVERLOAD_PURE(return_type,CDM_Application,Resources,) };

        // protected pure virtual


        // private pure virtual

        handle<CDM_Document> Retrieve( const handle<CDM_MetaData> & aMetaData, const Standard_Boolean UseStorageConfiguration, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theRange) override { using return_type = handle<CDM_Document>;
    PYBIND11_OVERLOAD_PURE(return_type,CDM_Application,Retrieve,aMetaData,UseStorageConfiguration,theFilter,theRange) };
        Standard_Integer DocumentVersion( const handle<CDM_MetaData> & aMetaData) override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,CDM_Application,DocumentVersion,aMetaData) };
    };
    class Py_CDF_MetaDataDriver : public CDF_MetaDataDriver{
    public:
        using CDF_MetaDataDriver::CDF_MetaDataDriver;


        // public pure virtual
        TCollection_ExtendedString BuildFileName( const handle<CDM_Document> & aDocument) override { using return_type = TCollection_ExtendedString;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriver,BuildFileName,aDocument) };
        Standard_Boolean Find( const TCollection_ExtendedString & aFolder, const TCollection_ExtendedString & aName, const TCollection_ExtendedString & aVersion) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriver,Find,aFolder,aName,aVersion) };
        Standard_Boolean HasReadPermission( const TCollection_ExtendedString & aFolder, const TCollection_ExtendedString & aName, const TCollection_ExtendedString & aVersion) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriver,HasReadPermission,aFolder,aName,aVersion) };
        handle<CDM_MetaData> MetaData( const TCollection_ExtendedString & aFolder, const TCollection_ExtendedString & aName, const TCollection_ExtendedString & aVersion) override { using return_type = handle<CDM_MetaData>;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriver,MetaData,aFolder,aName,aVersion) };
        handle<CDM_MetaData> CreateMetaData( const handle<CDM_Document> & aDocument, const TCollection_ExtendedString & aFileName) override { using return_type = handle<CDM_MetaData>;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriver,CreateMetaData,aDocument,aFileName) };
        Standard_Boolean FindFolder( const TCollection_ExtendedString & aFolder) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriver,FindFolder,aFolder) };
        TCollection_ExtendedString DefaultFolder() override { using return_type = TCollection_ExtendedString;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriver,DefaultFolder,) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_CDF_MetaDataDriverFactory : public CDF_MetaDataDriverFactory{
    public:
        using CDF_MetaDataDriverFactory::CDF_MetaDataDriverFactory;


        // public pure virtual
        handle<CDF_MetaDataDriver> Build() const  override { using return_type = handle<CDF_MetaDataDriver>;
    PYBIND11_OVERLOAD_PURE(return_type,CDF_MetaDataDriverFactory,Build,) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class CDF_Application from ./opencascade/CDF_Application.hxx
    klass = m.attr("CDF_Application");


    // nested enums

    static_cast<py::class_<CDF_Application ,opencascade::handle<CDF_Application> ,Py_CDF_Application , CDM_Application >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("InitDocument",
             (void (CDF_Application::*)(  const handle<CDM_Document> &  ) const) static_cast<void (CDF_Application::*)(  const handle<CDM_Document> &  ) const>(&CDF_Application::InitDocument),
             R"#(Initialize a document for the applicative session. This virtual function is called by NewDocument and should be redefined for each specific application.)#"  , py::arg("theDoc")
          )
        .def("Open",
             (void (CDF_Application::*)(  const handle<CDM_Document> &  ) ) static_cast<void (CDF_Application::*)(  const handle<CDM_Document> &  ) >(&CDF_Application::Open),
             R"#(puts the document in the current session directory and calls the virtual method Activate on it.)#"  , py::arg("aDocument")
          )
        .def("CanClose",
             (CDM_CanCloseStatus (CDF_Application::*)(  const handle<CDM_Document> &  ) ) static_cast<CDM_CanCloseStatus (CDF_Application::*)(  const handle<CDM_Document> &  ) >(&CDF_Application::CanClose),
             R"#()#"  , py::arg("aDocument")
          )
        .def("Close",
             (void (CDF_Application::*)(  const handle<CDM_Document> &  ) ) static_cast<void (CDF_Application::*)(  const handle<CDM_Document> &  ) >(&CDF_Application::Close),
             R"#(removes the document of the current session directory and closes the document;)#"  , py::arg("aDocument")
          )
        .def("Retrieve",
             (handle<CDM_Document> (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const Standard_Boolean ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) ) static_cast<handle<CDM_Document> (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const Standard_Boolean ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) >(&CDF_Application::Retrieve),
             R"#(This method retrieves a document from the database. If the Document references other documents which have been updated, the latest version of these documents will be used if {UseStorageConfiguration} is Standard_True. The content of {aFolder}, {aName} and {aVersion} depends on the Database Manager system. If the DBMS is only based on the OS, {aFolder} is a directory and {aName} is the name of a file. In this case the use of the syntax with {aVersion} has no sense. For example:)#"  , py::arg("aFolder"),  py::arg("aName"),  py::arg("UseStorageConfiguration")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("theFilter")=static_cast< const handle<PCDM_ReaderFilter> &>(Handle ( PCDM_ReaderFilter ) ( )),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Retrieve",
             (handle<CDM_Document> (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const Standard_Boolean ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) ) static_cast<handle<CDM_Document> (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const Standard_Boolean ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) >(&CDF_Application::Retrieve),
             R"#(This method retrieves a document from the database. If the Document references other documents which have been updated, the latest version of these documents will be used if {UseStorageConfiguration} is Standard_True. -- If the DBMS is only based on the OS, this syntax should not be used.)#"  , py::arg("aFolder"),  py::arg("aName"),  py::arg("aVersion"),  py::arg("UseStorageConfiguration")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("theFilter")=static_cast< const handle<PCDM_ReaderFilter> &>(Handle ( PCDM_ReaderFilter ) ( )),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("CanRetrieve",
             (PCDM_ReaderStatus (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const bool  ) ) static_cast<PCDM_ReaderStatus (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const bool  ) >(&CDF_Application::CanRetrieve),
             R"#()#"  , py::arg("theFolder"),  py::arg("theName"),  py::arg("theAppendMode")
          )
        .def("CanRetrieve",
             (PCDM_ReaderStatus (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const bool  ) ) static_cast<PCDM_ReaderStatus (CDF_Application::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const bool  ) >(&CDF_Application::CanRetrieve),
             R"#()#"  , py::arg("theFolder"),  py::arg("theName"),  py::arg("theVersion"),  py::arg("theAppendMode")
          )
        .def("GetRetrieveStatus",
             (PCDM_ReaderStatus (CDF_Application::*)() const) static_cast<PCDM_ReaderStatus (CDF_Application::*)() const>(&CDF_Application::GetRetrieveStatus),
             R"#(Checks status after Retrieve)#" 
          )
        .def("ReaderFromFormat",
             (handle<PCDM_Reader> (CDF_Application::*)(  const TCollection_ExtendedString &  ) ) static_cast<handle<PCDM_Reader> (CDF_Application::*)(  const TCollection_ExtendedString &  ) >(&CDF_Application::ReaderFromFormat),
             R"#(Returns instance of read driver for specified format.)#"  , py::arg("aFormat")
          )
        .def("WriterFromFormat",
             (handle<PCDM_StorageDriver> (CDF_Application::*)(  const TCollection_ExtendedString &  ) ) static_cast<handle<PCDM_StorageDriver> (CDF_Application::*)(  const TCollection_ExtendedString &  ) >(&CDF_Application::WriterFromFormat),
             R"#(Returns instance of storage driver for specified format.)#"  , py::arg("aFormat")
          )
        .def("Format",
             (Standard_Boolean (CDF_Application::*)(  const TCollection_ExtendedString & ,  TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_Application::*)(  const TCollection_ExtendedString & ,  TCollection_ExtendedString &  ) >(&CDF_Application::Format),
             R"#(try to retrieve a Format directly in the file or in application resource by using extension. returns True if found;)#"  , py::arg("aFileName"),  py::arg("theFormat")
          )
        .def("DefaultFolder",
             (Standard_ExtString (CDF_Application::*)() ) static_cast<Standard_ExtString (CDF_Application::*)() >(&CDF_Application::DefaultFolder),
             R"#()#" 
          )
        .def("SetDefaultFolder",
             (Standard_Boolean (CDF_Application::*)(  const Standard_ExtString  ) ) static_cast<Standard_Boolean (CDF_Application::*)(  const Standard_ExtString  ) >(&CDF_Application::SetDefaultFolder),
             R"#()#"  , py::arg("aFolder")
          )
        .def("MetaDataDriver",
             (handle<CDF_MetaDataDriver> (CDF_Application::*)() const) static_cast<handle<CDF_MetaDataDriver> (CDF_Application::*)() const>(&CDF_Application::MetaDataDriver),
             R"#(returns MetaDatdDriver of this application)#" 
          )
    // methods using call by reference i.s.o. return
        .def("NewDocument",
             []( CDF_Application &self ,  const TCollection_ExtendedString & theFormat,CDM_Document& theDoc ){
                 handle<CDM_Document>  theDoc_ptr; theDoc_ptr = &theDoc;

                 self.NewDocument(theFormat,theDoc_ptr);
                 if ( theDoc_ptr.get() != &theDoc ) copy_if_copy_constructible(theDoc, *theDoc_ptr);

                 return std::make_tuple(); },
             R"#(Constructs an new empty document. This document will have the specified format. If InitDocument() is redefined for a specific application, the new document is handled by the applicative session.)#"  , py::arg("theFormat"),  py::arg("theDoc")
          )
        .def("Read",
             []( CDF_Application &self , Standard_IStream & theIStream,CDM_Document& theDocument, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theRange ){
                 handle<CDM_Document>  theDocument_ptr; theDocument_ptr = &theDocument;

                 self.Read(theIStream,theDocument_ptr,theFilter,theRange);
                 if ( theDocument_ptr.get() != &theDocument ) copy_if_copy_constructible(theDocument, *theDocument_ptr);

                 return std::make_tuple(); },
             R"#(Reads theDocument from standard SEEKABLE stream theIStream, the stream should support SEEK functionality)#"  , py::arg("theIStream"),  py::arg("theDocument"),  py::arg("theFilter")=static_cast< const handle<PCDM_ReaderFilter> &>(Handle ( PCDM_ReaderFilter ) ( )),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // static methods
        .def_static("Load_s",
                    (handle<CDF_Application> (*)(  const Standard_GUID &  ) ) static_cast<handle<CDF_Application> (*)(  const Standard_GUID &  ) >(&CDF_Application::Load),
                    R"#(plugs an application.)#"  , py::arg("aGUID")
          )
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&CDF_Application::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&CDF_Application::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (CDF_Application::*)() const) static_cast< const handle<Standard_Type> & (CDF_Application::*)() const>(&CDF_Application::DynamicType),
             R"#()#"
             
         )
;

    // Class CDF_Directory from ./opencascade/CDF_Directory.hxx
    klass = m.attr("CDF_Directory");


    // nested enums

    static_cast<py::class_<CDF_Directory ,opencascade::handle<CDF_Directory>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Add",
             (void (CDF_Directory::*)(  const handle<CDM_Document> &  ) ) static_cast<void (CDF_Directory::*)(  const handle<CDM_Document> &  ) >(&CDF_Directory::Add),
             R"#(adds a document into the directory.)#"  , py::arg("aDocument")
          )
        .def("Remove",
             (void (CDF_Directory::*)(  const handle<CDM_Document> &  ) ) static_cast<void (CDF_Directory::*)(  const handle<CDM_Document> &  ) >(&CDF_Directory::Remove),
             R"#(removes the document.)#"  , py::arg("aDocument")
          )
        .def("Contains",
             (Standard_Boolean (CDF_Directory::*)(  const handle<CDM_Document> &  ) const) static_cast<Standard_Boolean (CDF_Directory::*)(  const handle<CDM_Document> &  ) const>(&CDF_Directory::Contains),
             R"#(Returns true if the document aDocument is in the directory)#"  , py::arg("aDocument")
          )
        .def("Last",
             (handle<CDM_Document> (CDF_Directory::*)() ) static_cast<handle<CDM_Document> (CDF_Directory::*)() >(&CDF_Directory::Last),
             R"#(returns the last document (if any) which has been added in the directory.)#" 
          )
        .def("Length",
             (Standard_Integer (CDF_Directory::*)() const) static_cast<Standard_Integer (CDF_Directory::*)() const>(&CDF_Directory::Length),
             R"#(returns the number of documents of the directory.)#" 
          )
        .def("IsEmpty",
             (Standard_Boolean (CDF_Directory::*)() const) static_cast<Standard_Boolean (CDF_Directory::*)() const>(&CDF_Directory::IsEmpty),
             R"#(returns true if the directory is empty.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&CDF_Directory::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&CDF_Directory::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (CDF_Directory::*)() const) static_cast< const handle<Standard_Type> & (CDF_Directory::*)() const>(&CDF_Directory::DynamicType),
             R"#()#"
             
         )
;

    // Class CDF_DirectoryIterator from ./opencascade/CDF_DirectoryIterator.hxx
    klass = m.attr("CDF_DirectoryIterator");


    // nested enums

    static_cast<py::class_<CDF_DirectoryIterator , shared_ptr<CDF_DirectoryIterator>  >>(klass)
    // constructors
        .def(py::init<  const handle<CDF_Directory> & >()  , py::arg("aDirectory") )
    // custom constructors
    // methods
        .def("MoreDocument",
             (Standard_Boolean (CDF_DirectoryIterator::*)() ) static_cast<Standard_Boolean (CDF_DirectoryIterator::*)() >(&CDF_DirectoryIterator::MoreDocument),
             R"#(Returns True if there are more entries to return)#" 
          )
        .def("NextDocument",
             (void (CDF_DirectoryIterator::*)() ) static_cast<void (CDF_DirectoryIterator::*)() >(&CDF_DirectoryIterator::NextDocument),
             R"#(Go to the next entry (if there is not, Value will raise an exception))#" 
          )
        .def("Document",
             (handle<CDM_Document> (CDF_DirectoryIterator::*)() ) static_cast<handle<CDM_Document> (CDF_DirectoryIterator::*)() >(&CDF_DirectoryIterator::Document),
             R"#(Returns item value of current entry)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class CDF_MetaDataDriver from ./opencascade/CDF_MetaDataDriver.hxx
    klass = m.attr("CDF_MetaDataDriver");


    // nested enums

    static_cast<py::class_<CDF_MetaDataDriver ,opencascade::handle<CDF_MetaDataDriver> ,Py_CDF_MetaDataDriver , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("HasVersionCapability",
             (Standard_Boolean (CDF_MetaDataDriver::*)() ) static_cast<Standard_Boolean (CDF_MetaDataDriver::*)() >(&CDF_MetaDataDriver::HasVersionCapability),
             R"#(returns true if the MetaDataDriver can manage different versions of a Data. By default, returns Standard_False.)#" 
          )
        .def("CreateDependsOn",
             (void (CDF_MetaDataDriver::*)(  const handle<CDM_MetaData> & ,   const handle<CDM_MetaData> &  ) ) static_cast<void (CDF_MetaDataDriver::*)(  const handle<CDM_MetaData> & ,   const handle<CDM_MetaData> &  ) >(&CDF_MetaDataDriver::CreateDependsOn),
             R"#(Creates a "Depends On" relation between two Datas. By default does nothing)#"  , py::arg("aFirstData"),  py::arg("aSecondData")
          )
        .def("CreateReference",
             (void (CDF_MetaDataDriver::*)(  const handle<CDM_MetaData> & ,   const handle<CDM_MetaData> & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (CDF_MetaDataDriver::*)(  const handle<CDM_MetaData> & ,   const handle<CDM_MetaData> & ,   const Standard_Integer ,   const Standard_Integer  ) >(&CDF_MetaDataDriver::CreateReference),
             R"#()#"  , py::arg("aFrom"),  py::arg("aTo"),  py::arg("aReferenceIdentifier"),  py::arg("aToDocumentVersion")
          )
        .def("HasVersion",
             (Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::HasVersion),
             R"#(by default return Standard_True.)#"  , py::arg("aFolder"),  py::arg("aName")
          )
        .def("BuildFileName",
             (TCollection_ExtendedString (CDF_MetaDataDriver::*)(  const handle<CDM_Document> &  ) ) static_cast<TCollection_ExtendedString (CDF_MetaDataDriver::*)(  const handle<CDM_Document> &  ) >(&CDF_MetaDataDriver::BuildFileName),
             R"#()#"  , py::arg("aDocument")
          )
        .def("SetName",
             (TCollection_ExtendedString (CDF_MetaDataDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) ) static_cast<TCollection_ExtendedString (CDF_MetaDataDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::SetName),
             R"#(this method is useful if the name of an object -- depends on the metadatadriver. For example a Driver -- based on the operating system can choose to add the extension of file to create to the object.)#"  , py::arg("aDocument"),  py::arg("aName")
          )
        .def("Find",
             (Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::Find),
             R"#(should indicate whether meta-data exist in the DBMS corresponding to the Data. aVersion may be NULL;)#"  , py::arg("aFolder"),  py::arg("aName"),  py::arg("aVersion")
          )
        .def("HasReadPermission",
             (Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::HasReadPermission),
             R"#()#"  , py::arg("aFolder"),  py::arg("aName"),  py::arg("aVersion")
          )
        .def("MetaData",
             (handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::MetaData),
             R"#(should return the MetaData stored in the DBMS with the meta-data corresponding to the Data. If the MetaDataDriver has version management capabilities the version has to be set in the returned MetaData. aVersion may be NULL MetaData is called by GetMetaData If the version is set to NULL, MetaData should return the last version of the metadata)#"  , py::arg("aFolder"),  py::arg("aName"),  py::arg("aVersion")
          )
        .def("LastVersion",
             (handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const handle<CDM_MetaData> &  ) ) static_cast<handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const handle<CDM_MetaData> &  ) >(&CDF_MetaDataDriver::LastVersion),
             R"#(by default returns aMetaDATA should return the MetaData stored in the DBMS with the meta-data corresponding to the path. If the MetaDataDriver has version management capabilities the version has to be set in the returned MetaData. MetaData is called by GetMetaData If the version is not included in the path , MetaData should return the last version of the metadata is deferred;)#"  , py::arg("aMetaData")
          )
        .def("CreateMetaData",
             (handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) ) static_cast<handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::CreateMetaData),
             R"#(should create meta-data corresponding to aData and maintaining a meta-link between these meta-data and aFileName CreateMetaData is called by CreateData If the metadata-driver has version capabilities, version must be set in the returned Data.)#"  , py::arg("aDocument"),  py::arg("aFileName")
          )
        .def("FindFolder",
             (Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::FindFolder),
             R"#()#"  , py::arg("aFolder")
          )
        .def("DefaultFolder",
             (TCollection_ExtendedString (CDF_MetaDataDriver::*)() ) static_cast<TCollection_ExtendedString (CDF_MetaDataDriver::*)() >(&CDF_MetaDataDriver::DefaultFolder),
             R"#()#" 
          )
        .def("ReferenceIterator",
             (handle<PCDM_ReferenceIterator> (CDF_MetaDataDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<PCDM_ReferenceIterator> (CDF_MetaDataDriver::*)(  const handle<Message_Messenger> &  ) >(&CDF_MetaDataDriver::ReferenceIterator),
             R"#()#"  , py::arg("theMessageDriver")
          )
        .def("Find",
             (Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::Find),
             R"#(calls Find with an empty version)#"  , py::arg("aFolder"),  py::arg("aName")
          )
        .def("MetaData",
             (handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<handle<CDM_MetaData> (CDF_MetaDataDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_MetaDataDriver::MetaData),
             R"#(calls MetaData with an empty version)#"  , py::arg("aFolder"),  py::arg("aName")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&CDF_MetaDataDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&CDF_MetaDataDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (CDF_MetaDataDriver::*)() const) static_cast< const handle<Standard_Type> & (CDF_MetaDataDriver::*)() const>(&CDF_MetaDataDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class CDF_MetaDataDriverFactory from ./opencascade/CDF_MetaDataDriverFactory.hxx
    klass = m.attr("CDF_MetaDataDriverFactory");


    // nested enums

    static_cast<py::class_<CDF_MetaDataDriverFactory ,opencascade::handle<CDF_MetaDataDriverFactory> ,Py_CDF_MetaDataDriverFactory , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Build",
             (handle<CDF_MetaDataDriver> (CDF_MetaDataDriverFactory::*)() const) static_cast<handle<CDF_MetaDataDriver> (CDF_MetaDataDriverFactory::*)() const>(&CDF_MetaDataDriverFactory::Build),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&CDF_MetaDataDriverFactory::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&CDF_MetaDataDriverFactory::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (CDF_MetaDataDriverFactory::*)() const) static_cast< const handle<Standard_Type> & (CDF_MetaDataDriverFactory::*)() const>(&CDF_MetaDataDriverFactory::DynamicType),
             R"#()#"
             
         )
;

    // Class CDF_Store from ./opencascade/CDF_Store.hxx
    klass = m.attr("CDF_Store");


    // nested enums

    static_cast<py::class_<CDF_Store , shared_ptr<CDF_Store>  >>(klass)
    // constructors
        .def(py::init<  const handle<CDM_Document> & >()  , py::arg("aDocument") )
    // custom constructors
    // methods
        .def("Folder",
             (handle<TCollection_HExtendedString> (CDF_Store::*)() const) static_cast<handle<TCollection_HExtendedString> (CDF_Store::*)() const>(&CDF_Store::Folder),
             R"#(returns the folder in which the current document will be stored.)#" 
          )
        .def("Name",
             (handle<TCollection_HExtendedString> (CDF_Store::*)() const) static_cast<handle<TCollection_HExtendedString> (CDF_Store::*)() const>(&CDF_Store::Name),
             R"#(returns the name under which the current document will be stored)#" 
          )
        .def("IsStored",
             (Standard_Boolean (CDF_Store::*)() const) static_cast<Standard_Boolean (CDF_Store::*)() const>(&CDF_Store::IsStored),
             R"#(returns true if the current document is already stored)#" 
          )
        .def("IsModified",
             (Standard_Boolean (CDF_Store::*)() const) static_cast<Standard_Boolean (CDF_Store::*)() const>(&CDF_Store::IsModified),
             R"#()#" 
          )
        .def("CurrentIsConsistent",
             (Standard_Boolean (CDF_Store::*)() const) static_cast<Standard_Boolean (CDF_Store::*)() const>(&CDF_Store::CurrentIsConsistent),
             R"#()#" 
          )
        .def("IsConsistent",
             (Standard_Boolean (CDF_Store::*)() const) static_cast<Standard_Boolean (CDF_Store::*)() const>(&CDF_Store::IsConsistent),
             R"#()#" 
          )
        .def("HasAPreviousVersion",
             (Standard_Boolean (CDF_Store::*)() const) static_cast<Standard_Boolean (CDF_Store::*)() const>(&CDF_Store::HasAPreviousVersion),
             R"#()#" 
          )
        .def("PreviousVersion",
             (handle<TCollection_HExtendedString> (CDF_Store::*)() const) static_cast<handle<TCollection_HExtendedString> (CDF_Store::*)() const>(&CDF_Store::PreviousVersion),
             R"#()#" 
          )
        .def("IsMainDocument",
             (Standard_Boolean (CDF_Store::*)() const) static_cast<Standard_Boolean (CDF_Store::*)() const>(&CDF_Store::IsMainDocument),
             R"#(returns true if the currentdocument is the main one, ie the document of the current selection.)#" 
          )
        .def("SetFolder",
             (Standard_Boolean (CDF_Store::*)(  const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_Store::*)(  const TCollection_ExtendedString &  ) >(&CDF_Store::SetFolder),
             R"#(defines the folder in which the document should be stored. returns Standard_True if the Folder exists, Standard_False otherwise.)#"  , py::arg("aFolder")
          )
        .def("SetName",
             (CDF_StoreSetNameStatus (CDF_Store::*)(  const Standard_ExtString  ) ) static_cast<CDF_StoreSetNameStatus (CDF_Store::*)(  const Standard_ExtString  ) >(&CDF_Store::SetName),
             R"#(defines the name under which the document should be stored.)#"  , py::arg("aName")
          )
        .def("SetComment",
             (void (CDF_Store::*)(  const Standard_ExtString  ) ) static_cast<void (CDF_Store::*)(  const Standard_ExtString  ) >(&CDF_Store::SetComment),
             R"#()#"  , py::arg("aComment")
          )
        .def("Comment",
             (handle<TCollection_HExtendedString> (CDF_Store::*)() const) static_cast<handle<TCollection_HExtendedString> (CDF_Store::*)() const>(&CDF_Store::Comment),
             R"#()#" 
          )
        .def("RecheckName",
             (CDF_StoreSetNameStatus (CDF_Store::*)() ) static_cast<CDF_StoreSetNameStatus (CDF_Store::*)() >(&CDF_Store::RecheckName),
             R"#(defines the name under which the document should be stored. uses for example after modification of the folder.)#" 
          )
        .def("SetPreviousVersion",
             (Standard_Boolean (CDF_Store::*)(  const Standard_ExtString  ) ) static_cast<Standard_Boolean (CDF_Store::*)(  const Standard_ExtString  ) >(&CDF_Store::SetPreviousVersion),
             R"#()#"  , py::arg("aPreviousVersion")
          )
        .def("Realize",
             (void (CDF_Store::*)(  const Message_ProgressRange &  ) ) static_cast<void (CDF_Store::*)(  const Message_ProgressRange &  ) >(&CDF_Store::Realize),
             R"#()#"  , py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Path",
             (Standard_ExtString (CDF_Store::*)() const) static_cast<Standard_ExtString (CDF_Store::*)() const>(&CDF_Store::Path),
             R"#(returns the complete path of the created meta-data.)#" 
          )
        .def("MetaDataPath",
             (handle<TCollection_HExtendedString> (CDF_Store::*)() const) static_cast<handle<TCollection_HExtendedString> (CDF_Store::*)() const>(&CDF_Store::MetaDataPath),
             R"#(returns the path of the previous store is the object is already stored, otherwise an empty string;)#" 
          )
        .def("Description",
             (handle<TCollection_HExtendedString> (CDF_Store::*)() const) static_cast<handle<TCollection_HExtendedString> (CDF_Store::*)() const>(&CDF_Store::Description),
             R"#(returns the description of the format of the main object.)#" 
          )
        .def("SetCurrent",
             (void (CDF_Store::*)(  const Standard_ExtString  ) ) static_cast<void (CDF_Store::*)(  const Standard_ExtString  ) >(&CDF_Store::SetCurrent),
             R"#()#"  , py::arg("aPresentation")
          )
        .def("SetMain",
             (void (CDF_Store::*)() ) static_cast<void (CDF_Store::*)() >(&CDF_Store::SetMain),
             R"#(the two following methods can be used just after Realize or Import -- method to know if thes methods worked correctly, and if not why.)#" 
          )
        .def("StoreStatus",
             (PCDM_StoreStatus (CDF_Store::*)() const) static_cast<PCDM_StoreStatus (CDF_Store::*)() const>(&CDF_Store::StoreStatus),
             R"#()#" 
          )
        .def("AssociatedStatusText",
             (Standard_ExtString (CDF_Store::*)() const) static_cast<Standard_ExtString (CDF_Store::*)() const>(&CDF_Store::AssociatedStatusText),
             R"#()#" 
          )
        .def("SetName",
             (CDF_StoreSetNameStatus (CDF_Store::*)(  const TCollection_ExtendedString &  ) ) static_cast<CDF_StoreSetNameStatus (CDF_Store::*)(  const TCollection_ExtendedString &  ) >(&CDF_Store::SetName),
             R"#(defines the name under which the document should be stored.)#"  , py::arg("aName")
          )
        .def("SetFolder",
             (Standard_Boolean (CDF_Store::*)(  const Standard_ExtString  ) ) static_cast<Standard_Boolean (CDF_Store::*)(  const Standard_ExtString  ) >(&CDF_Store::SetFolder),
             R"#(defines the folder in which the document should be stored. returns Standard_True if the Folder exists, Standard_False otherwise.)#"  , py::arg("aFolder")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class CDF_StoreList from ./opencascade/CDF_StoreList.hxx
    klass = m.attr("CDF_StoreList");


    // nested enums

    static_cast<py::class_<CDF_StoreList ,opencascade::handle<CDF_StoreList>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const handle<CDM_Document> & >()  , py::arg("aDocument") )
    // custom constructors
    // methods
        .def("IsConsistent",
             (Standard_Boolean (CDF_StoreList::*)() const) static_cast<Standard_Boolean (CDF_StoreList::*)() const>(&CDF_StoreList::IsConsistent),
             R"#()#" 
          )
        .def("Store",
             (PCDM_StoreStatus (CDF_StoreList::*)( handle<CDM_MetaData> & ,  TCollection_ExtendedString & ,   const Message_ProgressRange &  ) ) static_cast<PCDM_StoreStatus (CDF_StoreList::*)( handle<CDM_MetaData> & ,  TCollection_ExtendedString & ,   const Message_ProgressRange &  ) >(&CDF_StoreList::Store),
             R"#(stores each object of the storelist in the reverse order of which they had been added.)#"  , py::arg("aMetaData"),  py::arg("aStatusAssociatedText"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             (void (CDF_StoreList::*)() ) static_cast<void (CDF_StoreList::*)() >(&CDF_StoreList::Init),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (CDF_StoreList::*)() const) static_cast<Standard_Boolean (CDF_StoreList::*)() const>(&CDF_StoreList::More),
             R"#()#" 
          )
        .def("Next",
             (void (CDF_StoreList::*)() ) static_cast<void (CDF_StoreList::*)() >(&CDF_StoreList::Next),
             R"#()#" 
          )
        .def("Value",
             (handle<CDM_Document> (CDF_StoreList::*)() const) static_cast<handle<CDM_Document> (CDF_StoreList::*)() const>(&CDF_StoreList::Value),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&CDF_StoreList::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&CDF_StoreList::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (CDF_StoreList::*)() const) static_cast< const handle<Standard_Type> & (CDF_StoreList::*)() const>(&CDF_StoreList::DynamicType),
             R"#()#"
             
         )
;

    // Class CDF_FWOSDriver from ./opencascade/CDF_FWOSDriver.hxx
    klass = m.attr("CDF_FWOSDriver");


    // nested enums

    static_cast<py::class_<CDF_FWOSDriver ,opencascade::handle<CDF_FWOSDriver>  , CDF_MetaDataDriver >>(klass)
    // constructors
        .def(py::init< CDM_MetaDataLookUpTable & >()  , py::arg("theLookUpTable") )
    // custom constructors
    // methods
        .def("Find",
             (Standard_Boolean (CDF_FWOSDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_FWOSDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_FWOSDriver::Find),
             R"#(indicate whether a file exists corresponding to the folder and the name)#"  , py::arg("aFolder"),  py::arg("aName"),  py::arg("aVersion")
          )
        .def("HasReadPermission",
             (Standard_Boolean (CDF_FWOSDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_FWOSDriver::*)(  const TCollection_ExtendedString & ,   const TCollection_ExtendedString & ,   const TCollection_ExtendedString &  ) >(&CDF_FWOSDriver::HasReadPermission),
             R"#()#"  , py::arg("aFolder"),  py::arg("aName"),  py::arg("aVersion")
          )
        .def("FindFolder",
             (Standard_Boolean (CDF_FWOSDriver::*)(  const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (CDF_FWOSDriver::*)(  const TCollection_ExtendedString &  ) >(&CDF_FWOSDriver::FindFolder),
             R"#()#"  , py::arg("aFolder")
          )
        .def("DefaultFolder",
             (TCollection_ExtendedString (CDF_FWOSDriver::*)() ) static_cast<TCollection_ExtendedString (CDF_FWOSDriver::*)() >(&CDF_FWOSDriver::DefaultFolder),
             R"#()#" 
          )
        .def("BuildFileName",
             (TCollection_ExtendedString (CDF_FWOSDriver::*)(  const handle<CDM_Document> &  ) ) static_cast<TCollection_ExtendedString (CDF_FWOSDriver::*)(  const handle<CDM_Document> &  ) >(&CDF_FWOSDriver::BuildFileName),
             R"#()#"  , py::arg("aDocument")
          )
        .def("SetName",
             (TCollection_ExtendedString (CDF_FWOSDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) ) static_cast<TCollection_ExtendedString (CDF_FWOSDriver::*)(  const handle<CDM_Document> & ,   const TCollection_ExtendedString &  ) >(&CDF_FWOSDriver::SetName),
             R"#()#"  , py::arg("aDocument"),  py::arg("aName")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&CDF_FWOSDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&CDF_FWOSDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (CDF_FWOSDriver::*)() const) static_cast< const handle<Standard_Type> & (CDF_FWOSDriver::*)() const>(&CDF_FWOSDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/CDF_Application.hxx
// ./opencascade/CDF_Directory.hxx
// ./opencascade/CDF_DirectoryIterator.hxx
// ./opencascade/CDF_FWOSDriver.hxx
// ./opencascade/CDF_MetaDataDriver.hxx
// ./opencascade/CDF_MetaDataDriverFactory.hxx
// ./opencascade/CDF_Store.hxx
// ./opencascade/CDF_StoreList.hxx
// ./opencascade/CDF_StoreSetNameStatus.hxx
// ./opencascade/CDF_SubComponentStatus.hxx
// ./opencascade/CDF_TryStoreStatus.hxx
// ./opencascade/CDF_TypeOfActivation.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
