
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_BezierCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>

// module includes
#include <Geom2dAdaptor.hxx>
#include <Geom2dAdaptor_Curve.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Geom2dAdaptor_enums(py::module &main_module) {


py::module m = main_module.def_submodule("Geom2dAdaptor", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<Geom2dAdaptor , shared_ptr<Geom2dAdaptor>  >(m,"Geom2dAdaptor",R"#(this package contains the geometric definition of 2d curves compatible with the Adaptor package templates.)#");
    py::class_<Geom2dAdaptor_Curve ,opencascade::handle<Geom2dAdaptor_Curve>  , Adaptor2d_Curve2d >(m,"Geom2dAdaptor_Curve",R"#(An interface between the services provided by any curve from the package Geom2d and those required of the curve by algorithms which use it.An interface between the services provided by any curve from the package Geom2d and those required of the curve by algorithms which use it.)#");

};

// user-defined post-inclusion per module

// user-defined post
