
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TopoDS_Wire.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshData_Shape.hxx>
#include <IMeshData_Face.hxx>
#include <IMeshData_Wire.hxx>
#include <IMeshData_Edge.hxx>
#include <IMeshData_Curve.hxx>
#include <IMeshData_PCurve.hxx>
#include <IMeshData_Model.hxx>
#include <BRepMesh_VertexInspector.hxx>
#include <BRepMesh_CircleInspector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IMeshData_Curve.hxx>
#include <IMeshData_Edge.hxx>
#include <IMeshData_Face.hxx>
#include <IMeshData_Model.hxx>
#include <IMeshData_ParametersList.hxx>
#include <IMeshData_ParametersListArrayAdaptor.hxx>
#include <IMeshData_PCurve.hxx>
#include <IMeshData_Shape.hxx>
#include <IMeshData_Status.hxx>
#include <IMeshData_StatusOwner.hxx>
#include <IMeshData_TessellatedShape.hxx>
#include <IMeshData_Types.hxx>
#include <IMeshData_Wire.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IMeshData(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IMeshData"));
py::object klass;

//Python trampoline classes
    class Py_IMeshData_ParametersList : public IMeshData_ParametersList{
    public:
        using IMeshData_ParametersList::IMeshData_ParametersList;


        // public pure virtual
        Standard_Real & GetParameter( const Standard_Integer theIndex) override { using return_type = Standard_Real &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,GetParameter,theIndex) };
        Standard_Integer ParametersNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,ParametersNb,) };
        void Clear( const Standard_Boolean isKeepEndPoints) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,Clear,isKeepEndPoints) };


        // protected pure virtual
        void removeParameter( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,removeParameter,theIndex) };


        // private pure virtual

    };
    class Py_IMeshData_Curve : public IMeshData_Curve{
    public:
        using IMeshData_Curve::IMeshData_Curve;


        // public pure virtual
        void InsertPoint( const Standard_Integer thePosition, const gp_Pnt & thePoint, const Standard_Real theParamOnPCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,InsertPoint,thePosition,thePoint,theParamOnPCurve) };
        void AddPoint( const gp_Pnt & thePoint, const Standard_Real theParamOnCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,AddPoint,thePoint,theParamOnCurve) };
        gp_Pnt & GetPoint( const Standard_Integer theIndex) override { using return_type = gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,GetPoint,theIndex) };
        void RemovePoint( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,RemovePoint,theIndex) };

        Standard_Real & GetParameter( const Standard_Integer theIndex) override { using return_type = Standard_Real &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,GetParameter,theIndex) };
        Standard_Integer ParametersNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,ParametersNb,) };
        void Clear( const Standard_Boolean isKeepEndPoints) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,Clear,isKeepEndPoints) };

        // protected pure virtual

        void removeParameter( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,removeParameter,theIndex) };

        // private pure virtual

    };
    class Py_IMeshData_Model : public IMeshData_Model{
    public:
        using IMeshData_Model::IMeshData_Model;


        // public pure virtual
        Standard_Real GetMaxSize() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,GetMaxSize,) };
        Standard_Integer FacesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,FacesNb,) };
         const typename IMeshData::IFaceHandle & AddFace( const TopoDS_Face & theFace) override { using return_type =  const typename IMeshData::IFaceHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,AddFace,theFace) };
         const typename IMeshData::IFaceHandle & GetFace( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IFaceHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,GetFace,theIndex) };
        Standard_Integer EdgesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,EdgesNb,) };
         const typename IMeshData::IEdgeHandle & AddEdge( const TopoDS_Edge & theEdge) override { using return_type =  const typename IMeshData::IEdgeHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,AddEdge,theEdge) };
         const typename IMeshData::IEdgeHandle & GetEdge( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IEdgeHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,GetEdge,theIndex) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshData_PCurve : public IMeshData_PCurve{
    public:
        using IMeshData_PCurve::IMeshData_PCurve;


        // public pure virtual
        void InsertPoint( const Standard_Integer thePosition, const gp_Pnt2d & thePoint, const Standard_Real theParamOnPCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,InsertPoint,thePosition,thePoint,theParamOnPCurve) };
        void AddPoint( const gp_Pnt2d & thePoint, const Standard_Real theParamOnPCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,AddPoint,thePoint,theParamOnPCurve) };
        gp_Pnt2d & GetPoint( const Standard_Integer theIndex) override { using return_type = gp_Pnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,GetPoint,theIndex) };
        Standard_Integer & GetIndex( const Standard_Integer theIndex) override { using return_type = Standard_Integer &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,GetIndex,theIndex) };
        void RemovePoint( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,RemovePoint,theIndex) };

        Standard_Real & GetParameter( const Standard_Integer theIndex) override { using return_type = Standard_Real &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,GetParameter,theIndex) };
        Standard_Integer ParametersNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,ParametersNb,) };
        void Clear( const Standard_Boolean isKeepEndPoints) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,Clear,isKeepEndPoints) };

        // protected pure virtual

        void removeParameter( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,removeParameter,theIndex) };

        // private pure virtual

    };
    class Py_IMeshData_Edge : public IMeshData_Edge{
    public:
        using IMeshData_Edge::IMeshData_Edge;


        // public pure virtual
        Standard_Integer PCurvesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,PCurvesNb,) };
         const typename IMeshData::IPCurveHandle & AddPCurve( const IMeshData::IFacePtr & theDFace, const TopAbs_Orientation theOrientation) override { using return_type =  const typename IMeshData::IPCurveHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,AddPCurve,theDFace,theOrientation) };
         const typename IMeshData::IPCurveHandle & GetPCurve( const IMeshData::IFacePtr & theDFace, const TopAbs_Orientation theOrientation) const  override { using return_type =  const typename IMeshData::IPCurveHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,GetPCurve,theDFace,theOrientation) };
         const typename IMeshData::IPCurveHandle & GetPCurve( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IPCurveHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,GetPCurve,theIndex) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshData_Face : public IMeshData_Face{
    public:
        using IMeshData_Face::IMeshData_Face;


        // public pure virtual
        Standard_Integer WiresNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Face,WiresNb,) };
         const typename IMeshData::IWireHandle & AddWire( const TopoDS_Wire & theWire, const Standard_Integer theEdgeNb) override { using return_type =  const typename IMeshData::IWireHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Face,AddWire,theWire,theEdgeNb) };
         const typename IMeshData::IWireHandle & GetWire( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IWireHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Face,GetWire,theIndex) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshData_Wire : public IMeshData_Wire{
    public:
        using IMeshData_Wire::IMeshData_Wire;


        // public pure virtual
        Standard_Integer EdgesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,EdgesNb,) };
        Standard_Integer AddEdge( const IMeshData::IEdgePtr & theDEdge, const TopAbs_Orientation theOrientation) override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,AddEdge,theDEdge,theOrientation) };
         const IMeshData::IEdgePtr & GetEdge( const Standard_Integer theIndex) const  override { using return_type =  const IMeshData::IEdgePtr &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,GetEdge,theIndex) };
        TopAbs_Orientation GetEdgeOrientation( const Standard_Integer theIndex) const  override { using return_type = TopAbs_Orientation;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,GetEdgeOrientation,theIndex) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class IMeshData_ParametersList from ./opencascade/IMeshData_ParametersList.hxx
    klass = m.attr("IMeshData_ParametersList");


    // nested enums

    static_cast<py::class_<IMeshData_ParametersList ,opencascade::handle<IMeshData_ParametersList> ,Py_IMeshData_ParametersList , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GetParameter",
             (Standard_Real & (IMeshData_ParametersList::*)(  const Standard_Integer  ) ) static_cast<Standard_Real & (IMeshData_ParametersList::*)(  const Standard_Integer  ) >(&IMeshData_ParametersList::GetParameter),
             R"#(Returns parameter with the given index.)#"  , py::arg("theIndex")
          )
        .def("ParametersNb",
             (Standard_Integer (IMeshData_ParametersList::*)() const) static_cast<Standard_Integer (IMeshData_ParametersList::*)() const>(&IMeshData_ParametersList::ParametersNb),
             R"#(Returns number of parameters.)#" 
          )
        .def("Clear",
             (void (IMeshData_ParametersList::*)(  const Standard_Boolean  ) ) static_cast<void (IMeshData_ParametersList::*)(  const Standard_Boolean  ) >(&IMeshData_ParametersList::Clear),
             R"#(Clears parameters list.)#"  , py::arg("isKeepEndPoints")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_ParametersList::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_ParametersList::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_ParametersList::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_ParametersList::*)() const>(&IMeshData_ParametersList::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_Shape from ./opencascade/IMeshData_Shape.hxx
    klass = m.attr("IMeshData_Shape");


    // nested enums

    static_cast<py::class_<IMeshData_Shape ,opencascade::handle<IMeshData_Shape>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("SetShape",
             (void (IMeshData_Shape::*)(  const TopoDS_Shape &  ) ) static_cast<void (IMeshData_Shape::*)(  const TopoDS_Shape &  ) >(&IMeshData_Shape::SetShape),
             R"#(Assigns shape to discrete shape.)#"  , py::arg("theShape")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_Shape::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_Shape::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetShape",
             ( const TopoDS_Shape & (IMeshData_Shape::*)() const) static_cast< const TopoDS_Shape & (IMeshData_Shape::*)() const>(&IMeshData_Shape::GetShape),
             R"#(Returns shape assigned to discrete shape.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_Shape::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_Shape::*)() const>(&IMeshData_Shape::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_StatusOwner from ./opencascade/IMeshData_StatusOwner.hxx
    klass = m.attr("IMeshData_StatusOwner");


    // nested enums

    static_cast<py::class_<IMeshData_StatusOwner , shared_ptr<IMeshData_StatusOwner>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsEqual",
             (Standard_Boolean (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) const) static_cast<Standard_Boolean (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) const>(&IMeshData_StatusOwner::IsEqual),
             R"#(Returns true in case if status is strictly equal to the given value.)#"  , py::arg("theValue")
          )
        .def("IsSet",
             (Standard_Boolean (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) const) static_cast<Standard_Boolean (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) const>(&IMeshData_StatusOwner::IsSet),
             R"#(Returns true in case if status is set.)#"  , py::arg("theValue")
          )
        .def("SetStatus",
             (void (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) ) static_cast<void (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) >(&IMeshData_StatusOwner::SetStatus),
             R"#(Adds status to status flags of a face.)#"  , py::arg("theValue")
          )
        .def("UnsetStatus",
             (void (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) ) static_cast<void (IMeshData_StatusOwner::*)(  const IMeshData_Status  ) >(&IMeshData_StatusOwner::UnsetStatus),
             R"#(Adds status to status flags of a face.)#"  , py::arg("theValue")
          )
        .def("GetStatusMask",
             (Standard_Integer (IMeshData_StatusOwner::*)() const) static_cast<Standard_Integer (IMeshData_StatusOwner::*)() const>(&IMeshData_StatusOwner::GetStatusMask),
             R"#(Returns complete status mask.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IMeshData_Curve from ./opencascade/IMeshData_Curve.hxx
    klass = m.attr("IMeshData_Curve");


    // nested enums

    static_cast<py::class_<IMeshData_Curve ,opencascade::handle<IMeshData_Curve> ,Py_IMeshData_Curve , IMeshData_ParametersList >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("InsertPoint",
             (void (IMeshData_Curve::*)(  const Standard_Integer ,   const gp_Pnt & ,   const Standard_Real  ) ) static_cast<void (IMeshData_Curve::*)(  const Standard_Integer ,   const gp_Pnt & ,   const Standard_Real  ) >(&IMeshData_Curve::InsertPoint),
             R"#(Inserts new discretization point at the given position.)#"  , py::arg("thePosition"),  py::arg("thePoint"),  py::arg("theParamOnPCurve")
          )
        .def("AddPoint",
             (void (IMeshData_Curve::*)(  const gp_Pnt & ,   const Standard_Real  ) ) static_cast<void (IMeshData_Curve::*)(  const gp_Pnt & ,   const Standard_Real  ) >(&IMeshData_Curve::AddPoint),
             R"#(Adds new discretization point to curve.)#"  , py::arg("thePoint"),  py::arg("theParamOnCurve")
          )
        .def("GetPoint",
             (gp_Pnt & (IMeshData_Curve::*)(  const Standard_Integer  ) ) static_cast<gp_Pnt & (IMeshData_Curve::*)(  const Standard_Integer  ) >(&IMeshData_Curve::GetPoint),
             R"#(Returns discretization point with the given index.)#"  , py::arg("theIndex")
          )
        .def("RemovePoint",
             (void (IMeshData_Curve::*)(  const Standard_Integer  ) ) static_cast<void (IMeshData_Curve::*)(  const Standard_Integer  ) >(&IMeshData_Curve::RemovePoint),
             R"#(Removes point with the given index.)#"  , py::arg("theIndex")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_Curve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_Curve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_Curve::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_Curve::*)() const>(&IMeshData_Curve::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_Model from ./opencascade/IMeshData_Model.hxx
    klass = m.attr("IMeshData_Model");


    // nested enums

    static_cast<py::class_<IMeshData_Model ,opencascade::handle<IMeshData_Model> ,Py_IMeshData_Model , IMeshData_Shape >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GetMaxSize",
             (Standard_Real (IMeshData_Model::*)() const) static_cast<Standard_Real (IMeshData_Model::*)() const>(&IMeshData_Model::GetMaxSize),
             R"#(Returns maximum size of shape model.)#" 
          )
        .def("FacesNb",
             (Standard_Integer (IMeshData_Model::*)() const) static_cast<Standard_Integer (IMeshData_Model::*)() const>(&IMeshData_Model::FacesNb),
             R"#(Returns number of faces in discrete model.)#" 
          )
        .def("AddFace",
             ( const typename IMeshData::IFaceHandle & (IMeshData_Model::*)(  const TopoDS_Face &  ) ) static_cast< const typename IMeshData::IFaceHandle & (IMeshData_Model::*)(  const TopoDS_Face &  ) >(&IMeshData_Model::AddFace),
             R"#(Adds new face to shape model.)#"  , py::arg("theFace")
          )
        .def("GetFace",
             ( const typename IMeshData::IFaceHandle & (IMeshData_Model::*)(  const Standard_Integer  ) const) static_cast< const typename IMeshData::IFaceHandle & (IMeshData_Model::*)(  const Standard_Integer  ) const>(&IMeshData_Model::GetFace),
             R"#(Gets model's face with the given index.)#"  , py::arg("theIndex")
          )
        .def("EdgesNb",
             (Standard_Integer (IMeshData_Model::*)() const) static_cast<Standard_Integer (IMeshData_Model::*)() const>(&IMeshData_Model::EdgesNb),
             R"#(Returns number of edges in discrete model.)#" 
          )
        .def("AddEdge",
             ( const typename IMeshData::IEdgeHandle & (IMeshData_Model::*)(  const TopoDS_Edge &  ) ) static_cast< const typename IMeshData::IEdgeHandle & (IMeshData_Model::*)(  const TopoDS_Edge &  ) >(&IMeshData_Model::AddEdge),
             R"#(Adds new edge to shape model.)#"  , py::arg("theEdge")
          )
        .def("GetEdge",
             ( const typename IMeshData::IEdgeHandle & (IMeshData_Model::*)(  const Standard_Integer  ) const) static_cast< const typename IMeshData::IEdgeHandle & (IMeshData_Model::*)(  const Standard_Integer  ) const>(&IMeshData_Model::GetEdge),
             R"#(Gets model's edge with the given index.)#"  , py::arg("theIndex")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_Model::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_Model::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_Model::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_Model::*)() const>(&IMeshData_Model::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_PCurve from ./opencascade/IMeshData_PCurve.hxx
    klass = m.attr("IMeshData_PCurve");


    // nested enums

    static_cast<py::class_<IMeshData_PCurve ,opencascade::handle<IMeshData_PCurve> ,Py_IMeshData_PCurve , IMeshData_ParametersList >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("InsertPoint",
             (void (IMeshData_PCurve::*)(  const Standard_Integer ,   const gp_Pnt2d & ,   const Standard_Real  ) ) static_cast<void (IMeshData_PCurve::*)(  const Standard_Integer ,   const gp_Pnt2d & ,   const Standard_Real  ) >(&IMeshData_PCurve::InsertPoint),
             R"#(Inserts new discretization point at the given position.)#"  , py::arg("thePosition"),  py::arg("thePoint"),  py::arg("theParamOnPCurve")
          )
        .def("AddPoint",
             (void (IMeshData_PCurve::*)(  const gp_Pnt2d & ,   const Standard_Real  ) ) static_cast<void (IMeshData_PCurve::*)(  const gp_Pnt2d & ,   const Standard_Real  ) >(&IMeshData_PCurve::AddPoint),
             R"#(Adds new discretization point to pcurve.)#"  , py::arg("thePoint"),  py::arg("theParamOnPCurve")
          )
        .def("GetPoint",
             (gp_Pnt2d & (IMeshData_PCurve::*)(  const Standard_Integer  ) ) static_cast<gp_Pnt2d & (IMeshData_PCurve::*)(  const Standard_Integer  ) >(&IMeshData_PCurve::GetPoint),
             R"#(Returns discretization point with the given index.)#"  , py::arg("theIndex")
          )
        .def("GetIndex",
             (Standard_Integer & (IMeshData_PCurve::*)(  const Standard_Integer  ) ) static_cast<Standard_Integer & (IMeshData_PCurve::*)(  const Standard_Integer  ) >(&IMeshData_PCurve::GetIndex),
             R"#(Returns index in mesh corresponded to discretization point with the given index.)#"  , py::arg("theIndex")
          )
        .def("RemovePoint",
             (void (IMeshData_PCurve::*)(  const Standard_Integer  ) ) static_cast<void (IMeshData_PCurve::*)(  const Standard_Integer  ) >(&IMeshData_PCurve::RemovePoint),
             R"#(Removes point with the given index.)#"  , py::arg("theIndex")
          )
        .def("IsForward",
             (Standard_Boolean (IMeshData_PCurve::*)() const) static_cast<Standard_Boolean (IMeshData_PCurve::*)() const>(&IMeshData_PCurve::IsForward),
             R"#(Returns forward flag of this pcurve.)#" 
          )
        .def("IsInternal",
             (Standard_Boolean (IMeshData_PCurve::*)() const) static_cast<Standard_Boolean (IMeshData_PCurve::*)() const>(&IMeshData_PCurve::IsInternal),
             R"#(Returns internal flag of this pcurve.)#" 
          )
        .def("GetOrientation",
             (TopAbs_Orientation (IMeshData_PCurve::*)() const) static_cast<TopAbs_Orientation (IMeshData_PCurve::*)() const>(&IMeshData_PCurve::GetOrientation),
             R"#(Returns orientation of the edge associated with current pcurve.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_PCurve::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_PCurve::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetFace",
             ( const IMeshData::IFacePtr & (IMeshData_PCurve::*)() const) static_cast< const IMeshData::IFacePtr & (IMeshData_PCurve::*)() const>(&IMeshData_PCurve::GetFace),
             R"#(Returns discrete face pcurve is associated to.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_PCurve::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_PCurve::*)() const>(&IMeshData_PCurve::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_TessellatedShape from ./opencascade/IMeshData_TessellatedShape.hxx
    klass = m.attr("IMeshData_TessellatedShape");


    // nested enums

    static_cast<py::class_<IMeshData_TessellatedShape ,opencascade::handle<IMeshData_TessellatedShape>  , IMeshData_Shape >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GetDeflection",
             (Standard_Real (IMeshData_TessellatedShape::*)() const) static_cast<Standard_Real (IMeshData_TessellatedShape::*)() const>(&IMeshData_TessellatedShape::GetDeflection),
             R"#(Gets deflection value for the discrete model.)#" 
          )
        .def("SetDeflection",
             (void (IMeshData_TessellatedShape::*)(  const Standard_Real  ) ) static_cast<void (IMeshData_TessellatedShape::*)(  const Standard_Real  ) >(&IMeshData_TessellatedShape::SetDeflection),
             R"#(Sets deflection value for the discrete model.)#"  , py::arg("theValue")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_TessellatedShape::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_TessellatedShape::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_TessellatedShape::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_TessellatedShape::*)() const>(&IMeshData_TessellatedShape::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_Edge from ./opencascade/IMeshData_Edge.hxx
    klass = m.attr("IMeshData_Edge");


    // nested enums

    static_cast<py::class_<IMeshData_Edge ,opencascade::handle<IMeshData_Edge> ,Py_IMeshData_Edge , IMeshData_TessellatedShape , IMeshData_StatusOwner >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("PCurvesNb",
             (Standard_Integer (IMeshData_Edge::*)() const) static_cast<Standard_Integer (IMeshData_Edge::*)() const>(&IMeshData_Edge::PCurvesNb),
             R"#(Returns number of pcurves assigned to current edge.)#" 
          )
        .def("GetPCurve",
             ( const typename IMeshData::IPCurveHandle & (IMeshData_Edge::*)(  const Standard_Integer  ) const) static_cast< const typename IMeshData::IPCurveHandle & (IMeshData_Edge::*)(  const Standard_Integer  ) const>(&IMeshData_Edge::GetPCurve),
             R"#(Returns pcurve with the given index.)#"  , py::arg("theIndex")
          )
        .def("Clear",
             (void (IMeshData_Edge::*)(  const Standard_Boolean  ) ) static_cast<void (IMeshData_Edge::*)(  const Standard_Boolean  ) >(&IMeshData_Edge::Clear),
             R"#(Clears curve and all pcurves assigned to the edge from discretization.)#"  , py::arg("isKeepEndPoints")
          )
        .def("IsFree",
             (Standard_Boolean (IMeshData_Edge::*)() const) static_cast<Standard_Boolean (IMeshData_Edge::*)() const>(&IMeshData_Edge::IsFree),
             R"#(Returns true in case if the edge is free one, i.e. it does not have pcurves.)#" 
          )
        .def("SetCurve",
             (void (IMeshData_Edge::*)(  const typename IMeshData::ICurveHandle &  ) ) static_cast<void (IMeshData_Edge::*)(  const typename IMeshData::ICurveHandle &  ) >(&IMeshData_Edge::SetCurve),
             R"#(Sets 3d curve associated with current edge.)#"  , py::arg("theCurve")
          )
        .def("GetAngularDeflection",
             (Standard_Real (IMeshData_Edge::*)() const) static_cast<Standard_Real (IMeshData_Edge::*)() const>(&IMeshData_Edge::GetAngularDeflection),
             R"#(Gets value of angular deflection for the discrete model.)#" 
          )
        .def("SetAngularDeflection",
             (void (IMeshData_Edge::*)(  const Standard_Real  ) ) static_cast<void (IMeshData_Edge::*)(  const Standard_Real  ) >(&IMeshData_Edge::SetAngularDeflection),
             R"#(Sets value of angular deflection for the discrete model.)#"  , py::arg("theValue")
          )
        .def("GetSameParam",
             (Standard_Boolean (IMeshData_Edge::*)() const) static_cast<Standard_Boolean (IMeshData_Edge::*)() const>(&IMeshData_Edge::GetSameParam),
             R"#(Returns same param flag. By default equals to flag stored in topological shape.)#" 
          )
        .def("SetSameParam",
             (void (IMeshData_Edge::*)(  const Standard_Boolean  ) ) static_cast<void (IMeshData_Edge::*)(  const Standard_Boolean  ) >(&IMeshData_Edge::SetSameParam),
             R"#(Updates same param flag.)#"  , py::arg("theValue")
          )
        .def("GetSameRange",
             (Standard_Boolean (IMeshData_Edge::*)() const) static_cast<Standard_Boolean (IMeshData_Edge::*)() const>(&IMeshData_Edge::GetSameRange),
             R"#(Returns same range flag. By default equals to flag stored in topological shape.)#" 
          )
        .def("SetSameRange",
             (void (IMeshData_Edge::*)(  const Standard_Boolean  ) ) static_cast<void (IMeshData_Edge::*)(  const Standard_Boolean  ) >(&IMeshData_Edge::SetSameRange),
             R"#(Updates same range flag.)#"  , py::arg("theValue")
          )
        .def("GetDegenerated",
             (Standard_Boolean (IMeshData_Edge::*)() const) static_cast<Standard_Boolean (IMeshData_Edge::*)() const>(&IMeshData_Edge::GetDegenerated),
             R"#(Returns degenerative flag. By default equals to flag stored in topological shape.)#" 
          )
        .def("SetDegenerated",
             (void (IMeshData_Edge::*)(  const Standard_Boolean  ) ) static_cast<void (IMeshData_Edge::*)(  const Standard_Boolean  ) >(&IMeshData_Edge::SetDegenerated),
             R"#(Updates degenerative flag.)#"  , py::arg("theValue")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_Edge::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_Edge::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetEdge",
             ( const TopoDS_Edge & (IMeshData_Edge::*)() const) static_cast< const TopoDS_Edge & (IMeshData_Edge::*)() const>(&IMeshData_Edge::GetEdge),
             R"#(Returns TopoDS_Edge attached to model.)#"
             
         )
       .def("GetCurve",
             ( const typename IMeshData::ICurveHandle & (IMeshData_Edge::*)() const) static_cast< const typename IMeshData::ICurveHandle & (IMeshData_Edge::*)() const>(&IMeshData_Edge::GetCurve),
             R"#(Returns 3d curve associated with current edge.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_Edge::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_Edge::*)() const>(&IMeshData_Edge::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_Face from ./opencascade/IMeshData_Face.hxx
    klass = m.attr("IMeshData_Face");


    // nested enums

    static_cast<py::class_<IMeshData_Face ,opencascade::handle<IMeshData_Face> ,Py_IMeshData_Face , IMeshData_TessellatedShape , IMeshData_StatusOwner >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("WiresNb",
             (Standard_Integer (IMeshData_Face::*)() const) static_cast<Standard_Integer (IMeshData_Face::*)() const>(&IMeshData_Face::WiresNb),
             R"#(Returns number of wires.)#" 
          )
        .def("AddWire",
             ( const typename IMeshData::IWireHandle & (IMeshData_Face::*)(  const TopoDS_Wire & ,   const Standard_Integer  ) ) static_cast< const typename IMeshData::IWireHandle & (IMeshData_Face::*)(  const TopoDS_Wire & ,   const Standard_Integer  ) >(&IMeshData_Face::AddWire),
             R"#(Adds wire to discrete model of face.)#"  , py::arg("theWire"),  py::arg("theEdgeNb")=static_cast< const Standard_Integer>(0)
          )
        .def("GetWire",
             ( const typename IMeshData::IWireHandle & (IMeshData_Face::*)(  const Standard_Integer  ) const) static_cast< const typename IMeshData::IWireHandle & (IMeshData_Face::*)(  const Standard_Integer  ) const>(&IMeshData_Face::GetWire),
             R"#(Returns discrete edge with the given index.)#"  , py::arg("theIndex")
          )
        .def("IsValid",
             (Standard_Boolean (IMeshData_Face::*)() const) static_cast<Standard_Boolean (IMeshData_Face::*)() const>(&IMeshData_Face::IsValid),
             R"#(Returns whether the face discrete model is valid.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_Face::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_Face::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetSurface",
             ( const handle<BRepAdaptor_Surface> & (IMeshData_Face::*)() const) static_cast< const handle<BRepAdaptor_Surface> & (IMeshData_Face::*)() const>(&IMeshData_Face::GetSurface),
             R"#(Returns face's surface.)#"
             
         )
       .def("GetFace",
             ( const TopoDS_Face & (IMeshData_Face::*)() const) static_cast< const TopoDS_Face & (IMeshData_Face::*)() const>(&IMeshData_Face::GetFace),
             R"#(Returns TopoDS_Face attached to model.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_Face::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_Face::*)() const>(&IMeshData_Face::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshData_Wire from ./opencascade/IMeshData_Wire.hxx
    klass = m.attr("IMeshData_Wire");


    // nested enums

    static_cast<py::class_<IMeshData_Wire ,opencascade::handle<IMeshData_Wire> ,Py_IMeshData_Wire , IMeshData_TessellatedShape , IMeshData_StatusOwner >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("EdgesNb",
             (Standard_Integer (IMeshData_Wire::*)() const) static_cast<Standard_Integer (IMeshData_Wire::*)() const>(&IMeshData_Wire::EdgesNb),
             R"#(Returns number of edges.)#" 
          )
        .def("GetEdge",
             ( const IMeshData::IEdgePtr & (IMeshData_Wire::*)(  const Standard_Integer  ) const) static_cast< const IMeshData::IEdgePtr & (IMeshData_Wire::*)(  const Standard_Integer  ) const>(&IMeshData_Wire::GetEdge),
             R"#(Returns discrete edge with the given index.)#"  , py::arg("theIndex")
          )
        .def("GetEdgeOrientation",
             (TopAbs_Orientation (IMeshData_Wire::*)(  const Standard_Integer  ) const) static_cast<TopAbs_Orientation (IMeshData_Wire::*)(  const Standard_Integer  ) const>(&IMeshData_Wire::GetEdgeOrientation),
             R"#(Returns True if orientation of discrete edge with the given index is forward.)#"  , py::arg("theIndex")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshData_Wire::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshData_Wire::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetWire",
             ( const TopoDS_Wire & (IMeshData_Wire::*)() const) static_cast< const TopoDS_Wire & (IMeshData_Wire::*)() const>(&IMeshData_Wire::GetWire),
             R"#(Returns TopoDS_Face attached to model.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshData_Wire::*)() const) static_cast< const handle<Standard_Type> & (IMeshData_Wire::*)() const>(&IMeshData_Wire::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/IMeshData_Curve.hxx
// ./opencascade/IMeshData_Edge.hxx
// ./opencascade/IMeshData_Face.hxx
// ./opencascade/IMeshData_Model.hxx
// ./opencascade/IMeshData_PCurve.hxx
// ./opencascade/IMeshData_ParametersList.hxx
// ./opencascade/IMeshData_ParametersListArrayAdaptor.hxx
// ./opencascade/IMeshData_Shape.hxx
// ./opencascade/IMeshData_Status.hxx
// ./opencascade/IMeshData_StatusOwner.hxx
// ./opencascade/IMeshData_TessellatedShape.hxx
// ./opencascade/IMeshData_Types.hxx
// ./opencascade/IMeshData_Wire.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
