
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshData_Model.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>

// module includes
#include <IMeshTools_Context.hxx>
#include <IMeshTools_CurveTessellator.hxx>
#include <IMeshTools_MeshAlgo.hxx>
#include <IMeshTools_MeshAlgoFactory.hxx>
#include <IMeshTools_MeshAlgoType.hxx>
#include <IMeshTools_MeshBuilder.hxx>
#include <IMeshTools_ModelAlgo.hxx>
#include <IMeshTools_ModelBuilder.hxx>
#include <IMeshTools_Parameters.hxx>
#include <IMeshTools_ShapeExplorer.hxx>
#include <IMeshTools_ShapeVisitor.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <IMeshData_Face.hxx>

// Module definiiton
void register_IMeshTools(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IMeshTools"));
py::object klass;

//Python trampoline classes
    class Py_IMeshTools_CurveTessellator : public IMeshTools_CurveTessellator{
    public:
        using IMeshTools_CurveTessellator::IMeshTools_CurveTessellator;


        // public pure virtual
        Standard_Integer PointsNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_CurveTessellator,PointsNb,) };
        Standard_Boolean Value( const Standard_Integer theIndex,gp_Pnt & thePoint,Standard_Real & theParameter) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_CurveTessellator,Value,theIndex,thePoint,theParameter) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshTools_MeshAlgo : public IMeshTools_MeshAlgo{
    public:
        using IMeshTools_MeshAlgo::IMeshTools_MeshAlgo;


        // public pure virtual
        void Perform( const typename IMeshData::IFaceHandle & theDFace, const IMeshTools_Parameters & theParameters, const Message_ProgressRange & theRange) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_MeshAlgo,Perform,theDFace,theParameters,theRange) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshTools_MeshAlgoFactory : public IMeshTools_MeshAlgoFactory{
    public:
        using IMeshTools_MeshAlgoFactory::IMeshTools_MeshAlgoFactory;


        // public pure virtual
        handle<IMeshTools_MeshAlgo> GetAlgo( const GeomAbs_SurfaceType theSurfaceType, const IMeshTools_Parameters & theParameters) const  override { using return_type = handle<IMeshTools_MeshAlgo>;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_MeshAlgoFactory,GetAlgo,theSurfaceType,theParameters) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshTools_ModelAlgo : public IMeshTools_ModelAlgo{
    public:
        using IMeshTools_ModelAlgo::IMeshTools_ModelAlgo;


        // public pure virtual


        // protected pure virtual
        Standard_Boolean performInternal( const handle<IMeshData_Model> & theModel, const IMeshTools_Parameters & theParameters, const Message_ProgressRange & theRange) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ModelAlgo,performInternal,theModel,theParameters,theRange) };


        // private pure virtual

    };
    class Py_IMeshTools_ModelBuilder : public IMeshTools_ModelBuilder{
    public:
        using IMeshTools_ModelBuilder::IMeshTools_ModelBuilder;


        // public pure virtual


        // protected pure virtual
        handle<IMeshData_Model> performInternal( const TopoDS_Shape & theShape, const IMeshTools_Parameters & theParameters) override { using return_type = handle<IMeshData_Model>;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ModelBuilder,performInternal,theShape,theParameters) };


        // private pure virtual

    };
    class Py_IMeshTools_ShapeVisitor : public IMeshTools_ShapeVisitor{
    public:
        using IMeshTools_ShapeVisitor::IMeshTools_ShapeVisitor;


        // public pure virtual
        void Visit( const TopoDS_Face & theFace) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ShapeVisitor,Visit,theFace) };
        void Visit( const TopoDS_Edge & theEdge) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ShapeVisitor,Visit,theEdge) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class IMeshTools_Context from ./opencascade/IMeshTools_Context.hxx
    klass = m.attr("IMeshTools_Context");


    // nested enums

    static_cast<py::class_<IMeshTools_Context ,opencascade::handle<IMeshTools_Context>  , IMeshData_Shape >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BuildModel",
             (Standard_Boolean (IMeshTools_Context::*)() ) static_cast<Standard_Boolean (IMeshTools_Context::*)() >(&IMeshTools_Context::BuildModel),
             R"#(Builds model using assigned model builder.)#" 
          )
        .def("DiscretizeEdges",
             (Standard_Boolean (IMeshTools_Context::*)() ) static_cast<Standard_Boolean (IMeshTools_Context::*)() >(&IMeshTools_Context::DiscretizeEdges),
             R"#(Performs discretization of model edges using assigned edge discret algorithm.)#" 
          )
        .def("HealModel",
             (Standard_Boolean (IMeshTools_Context::*)() ) static_cast<Standard_Boolean (IMeshTools_Context::*)() >(&IMeshTools_Context::HealModel),
             R"#(Performs healing of discrete model built by DiscretizeEdges() method using assigned healing algorithm.)#" 
          )
        .def("PreProcessModel",
             (Standard_Boolean (IMeshTools_Context::*)() ) static_cast<Standard_Boolean (IMeshTools_Context::*)() >(&IMeshTools_Context::PreProcessModel),
             R"#(Performs pre-processing of discrete model using assigned algorithm. Performs auxiliary actions such as cleaning shape from old triangulation.)#" 
          )
        .def("DiscretizeFaces",
             (Standard_Boolean (IMeshTools_Context::*)(  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IMeshTools_Context::*)(  const Message_ProgressRange &  ) >(&IMeshTools_Context::DiscretizeFaces),
             R"#(Performs meshing of faces of discrete model using assigned meshing algorithm.)#"  , py::arg("theRange")
          )
        .def("PostProcessModel",
             (Standard_Boolean (IMeshTools_Context::*)() ) static_cast<Standard_Boolean (IMeshTools_Context::*)() >(&IMeshTools_Context::PostProcessModel),
             R"#(Performs post-processing of discrete model using assigned algorithm.)#" 
          )
        .def("Clean",
             (void (IMeshTools_Context::*)() ) static_cast<void (IMeshTools_Context::*)() >(&IMeshTools_Context::Clean),
             R"#(Cleans temporary context data.)#" 
          )
        .def("SetModelBuilder",
             (void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelBuilder> &  ) ) static_cast<void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelBuilder> &  ) >(&IMeshTools_Context::SetModelBuilder),
             R"#(Sets instance of a tool to be used to build discrete model.)#"  , py::arg("theBuilder")
          )
        .def("SetEdgeDiscret",
             (void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) ) static_cast<void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) >(&IMeshTools_Context::SetEdgeDiscret),
             R"#(Sets instance of a tool to be used to discretize edges of a model.)#"  , py::arg("theEdgeDiscret")
          )
        .def("SetModelHealer",
             (void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) ) static_cast<void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) >(&IMeshTools_Context::SetModelHealer),
             R"#(Sets instance of a tool to be used to heal discrete model.)#"  , py::arg("theModelHealer")
          )
        .def("SetPreProcessor",
             (void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) ) static_cast<void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) >(&IMeshTools_Context::SetPreProcessor),
             R"#(Sets instance of pre-processing algorithm.)#"  , py::arg("thePreProcessor")
          )
        .def("SetFaceDiscret",
             (void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) ) static_cast<void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) >(&IMeshTools_Context::SetFaceDiscret),
             R"#(Sets instance of meshing algorithm.)#"  , py::arg("theFaceDiscret")
          )
        .def("SetPostProcessor",
             (void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) ) static_cast<void (IMeshTools_Context::*)(  const handle<IMeshTools_ModelAlgo> &  ) >(&IMeshTools_Context::SetPostProcessor),
             R"#(Sets instance of post-processing algorithm.)#"  , py::arg("thePostProcessor")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_Context::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_Context::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetModelBuilder",
             ( const handle<IMeshTools_ModelBuilder> & (IMeshTools_Context::*)() const) static_cast< const handle<IMeshTools_ModelBuilder> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetModelBuilder),
             R"#(Gets instance of a tool to be used to build discrete model.)#"
             
         )
       .def("GetEdgeDiscret",
             ( const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const) static_cast< const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetEdgeDiscret),
             R"#(Gets instance of a tool to be used to discretize edges of a model.)#"
             
         )
       .def("GetModelHealer",
             ( const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const) static_cast< const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetModelHealer),
             R"#(Gets instance of a tool to be used to heal discrete model.)#"
             
         )
       .def("GetPreProcessor",
             ( const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const) static_cast< const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetPreProcessor),
             R"#(Gets instance of pre-processing algorithm.)#"
             
         )
       .def("GetFaceDiscret",
             ( const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const) static_cast< const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetFaceDiscret),
             R"#(Gets instance of meshing algorithm.)#"
             
         )
       .def("GetPostProcessor",
             ( const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const) static_cast< const handle<IMeshTools_ModelAlgo> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetPostProcessor),
             R"#(Gets instance of post-processing algorithm.)#"
             
         )
       .def("GetParameters",
             ( const IMeshTools_Parameters & (IMeshTools_Context::*)() const) static_cast< const IMeshTools_Parameters & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetParameters),
             R"#(Gets parameters to be used for meshing.)#"
             
         )
       .def("ChangeParameters",
             (IMeshTools_Parameters & (IMeshTools_Context::*)() ) static_cast<IMeshTools_Parameters & (IMeshTools_Context::*)() >(&IMeshTools_Context::ChangeParameters),
             R"#(Gets reference to parameters to be used for meshing.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("GetModel",
             ( const handle<IMeshData_Model> & (IMeshTools_Context::*)() const) static_cast< const handle<IMeshData_Model> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::GetModel),
             R"#(Returns discrete model of a shape.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_Context::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_Context::*)() const>(&IMeshTools_Context::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_CurveTessellator from ./opencascade/IMeshTools_CurveTessellator.hxx
    klass = m.attr("IMeshTools_CurveTessellator");


    // nested enums

    static_cast<py::class_<IMeshTools_CurveTessellator ,opencascade::handle<IMeshTools_CurveTessellator> ,Py_IMeshTools_CurveTessellator , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("PointsNb",
             (Standard_Integer (IMeshTools_CurveTessellator::*)() const) static_cast<Standard_Integer (IMeshTools_CurveTessellator::*)() const>(&IMeshTools_CurveTessellator::PointsNb),
             R"#(Returns number of tessellation points.)#" 
          )
        .def("Value",
             (Standard_Boolean (IMeshTools_CurveTessellator::*)(  const Standard_Integer ,  gp_Pnt & ,  Standard_Real &  ) const) static_cast<Standard_Boolean (IMeshTools_CurveTessellator::*)(  const Standard_Integer ,  gp_Pnt & ,  Standard_Real &  ) const>(&IMeshTools_CurveTessellator::Value),
             R"#(Returns parameters of solution with the given index.)#"  , py::arg("theIndex"),  py::arg("thePoint"),  py::arg("theParameter")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_CurveTessellator::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_CurveTessellator::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_CurveTessellator::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_CurveTessellator::*)() const>(&IMeshTools_CurveTessellator::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_MeshAlgo from ./opencascade/IMeshTools_MeshAlgo.hxx
    klass = m.attr("IMeshTools_MeshAlgo");


    // nested enums

    static_cast<py::class_<IMeshTools_MeshAlgo ,opencascade::handle<IMeshTools_MeshAlgo> ,Py_IMeshTools_MeshAlgo , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Perform",
             (void (IMeshTools_MeshAlgo::*)(  const typename IMeshData::IFaceHandle & ,   const IMeshTools_Parameters & ,   const Message_ProgressRange &  ) ) static_cast<void (IMeshTools_MeshAlgo::*)(  const typename IMeshData::IFaceHandle & ,   const IMeshTools_Parameters & ,   const Message_ProgressRange &  ) >(&IMeshTools_MeshAlgo::Perform),
             R"#(Performs processing of the given face.)#"  , py::arg("theDFace"),  py::arg("theParameters"),  py::arg("theRange")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_MeshAlgo::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_MeshAlgo::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_MeshAlgo::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_MeshAlgo::*)() const>(&IMeshTools_MeshAlgo::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_MeshAlgoFactory from ./opencascade/IMeshTools_MeshAlgoFactory.hxx
    klass = m.attr("IMeshTools_MeshAlgoFactory");


    // nested enums

    static_cast<py::class_<IMeshTools_MeshAlgoFactory ,opencascade::handle<IMeshTools_MeshAlgoFactory> ,Py_IMeshTools_MeshAlgoFactory , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GetAlgo",
             (handle<IMeshTools_MeshAlgo> (IMeshTools_MeshAlgoFactory::*)(  const GeomAbs_SurfaceType ,   const IMeshTools_Parameters &  ) const) static_cast<handle<IMeshTools_MeshAlgo> (IMeshTools_MeshAlgoFactory::*)(  const GeomAbs_SurfaceType ,   const IMeshTools_Parameters &  ) const>(&IMeshTools_MeshAlgoFactory::GetAlgo),
             R"#(Creates instance of meshing algorithm for the given type of surface.)#"  , py::arg("theSurfaceType"),  py::arg("theParameters")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_MeshAlgoFactory::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_MeshAlgoFactory::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_MeshAlgoFactory::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_MeshAlgoFactory::*)() const>(&IMeshTools_MeshAlgoFactory::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_MeshBuilder from ./opencascade/IMeshTools_MeshBuilder.hxx
    klass = m.attr("IMeshTools_MeshBuilder");


    // nested enums

    static_cast<py::class_<IMeshTools_MeshBuilder ,opencascade::handle<IMeshTools_MeshBuilder>  , Message_Algorithm >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<IMeshTools_Context> & >()  , py::arg("theContext") )
    // custom constructors
    // methods
        .def("SetContext",
             (void (IMeshTools_MeshBuilder::*)(  const handle<IMeshTools_Context> &  ) ) static_cast<void (IMeshTools_MeshBuilder::*)(  const handle<IMeshTools_Context> &  ) >(&IMeshTools_MeshBuilder::SetContext),
             R"#(Sets context for algorithm.)#"  , py::arg("theContext")
          )
        .def("Perform",
             (void (IMeshTools_MeshBuilder::*)(  const Message_ProgressRange &  ) ) static_cast<void (IMeshTools_MeshBuilder::*)(  const Message_ProgressRange &  ) >(&IMeshTools_MeshBuilder::Perform),
             R"#(Performs meshing to the shape using current context.)#"  , py::arg("theRange")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_MeshBuilder::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_MeshBuilder::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetContext",
             ( const handle<IMeshTools_Context> & (IMeshTools_MeshBuilder::*)() const) static_cast< const handle<IMeshTools_Context> & (IMeshTools_MeshBuilder::*)() const>(&IMeshTools_MeshBuilder::GetContext),
             R"#(Gets context of algorithm.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_MeshBuilder::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_MeshBuilder::*)() const>(&IMeshTools_MeshBuilder::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_ModelAlgo from ./opencascade/IMeshTools_ModelAlgo.hxx
    klass = m.attr("IMeshTools_ModelAlgo");


    // nested enums

    static_cast<py::class_<IMeshTools_ModelAlgo ,opencascade::handle<IMeshTools_ModelAlgo> ,Py_IMeshTools_ModelAlgo , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Perform",
             (Standard_Boolean (IMeshTools_ModelAlgo::*)(  const handle<IMeshData_Model> & ,   const IMeshTools_Parameters & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IMeshTools_ModelAlgo::*)(  const handle<IMeshData_Model> & ,   const IMeshTools_Parameters & ,   const Message_ProgressRange &  ) >(&IMeshTools_ModelAlgo::Perform),
             R"#(Exceptions protected processing of the given model.)#"  , py::arg("theModel"),  py::arg("theParameters"),  py::arg("theRange")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_ModelAlgo::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_ModelAlgo::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_ModelAlgo::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_ModelAlgo::*)() const>(&IMeshTools_ModelAlgo::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_ModelBuilder from ./opencascade/IMeshTools_ModelBuilder.hxx
    klass = m.attr("IMeshTools_ModelBuilder");


    // nested enums

    static_cast<py::class_<IMeshTools_ModelBuilder ,opencascade::handle<IMeshTools_ModelBuilder> ,Py_IMeshTools_ModelBuilder , Message_Algorithm >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Perform",
             (handle<IMeshData_Model> (IMeshTools_ModelBuilder::*)(  const TopoDS_Shape & ,   const IMeshTools_Parameters &  ) ) static_cast<handle<IMeshData_Model> (IMeshTools_ModelBuilder::*)(  const TopoDS_Shape & ,   const IMeshTools_Parameters &  ) >(&IMeshTools_ModelBuilder::Perform),
             R"#(Exceptions protected method to create discrete model for the given shape. Returns nullptr in case of failure.)#"  , py::arg("theShape"),  py::arg("theParameters")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_ModelBuilder::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_ModelBuilder::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_ModelBuilder::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_ModelBuilder::*)() const>(&IMeshTools_ModelBuilder::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_Parameters from ./opencascade/IMeshTools_Parameters.hxx
    klass = m.attr("IMeshTools_Parameters");


    // nested enums

    static_cast<py::class_<IMeshTools_Parameters , shared_ptr<IMeshTools_Parameters>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("RelMinSize_s",
                    (Standard_Real (*)() ) static_cast<Standard_Real (*)() >(&IMeshTools_Parameters::RelMinSize),
                    R"#(Returns factor used to compute default value of MinSize (minimum mesh edge length) from deflection)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("MeshAlgo", &IMeshTools_Parameters::MeshAlgo)
        .def_readwrite("Angle", &IMeshTools_Parameters::Angle)
        .def_readwrite("Deflection", &IMeshTools_Parameters::Deflection)
        .def_readwrite("AngleInterior", &IMeshTools_Parameters::AngleInterior)
        .def_readwrite("DeflectionInterior", &IMeshTools_Parameters::DeflectionInterior)
        .def_readwrite("MinSize", &IMeshTools_Parameters::MinSize)
        .def_readwrite("InParallel", &IMeshTools_Parameters::InParallel)
        .def_readwrite("Relative", &IMeshTools_Parameters::Relative)
        .def_readwrite("InternalVerticesMode", &IMeshTools_Parameters::InternalVerticesMode)
        .def_readwrite("ControlSurfaceDeflection", &IMeshTools_Parameters::ControlSurfaceDeflection)
        .def_readwrite("EnableControlSurfaceDeflectionAllSurfaces", &IMeshTools_Parameters::EnableControlSurfaceDeflectionAllSurfaces)
        .def_readwrite("CleanModel", &IMeshTools_Parameters::CleanModel)
        .def_readwrite("AdjustMinSize", &IMeshTools_Parameters::AdjustMinSize)
        .def_readwrite("ForceFaceDeflection", &IMeshTools_Parameters::ForceFaceDeflection)
        .def_readwrite("AllowQualityDecrease", &IMeshTools_Parameters::AllowQualityDecrease)
    // methods returning by ref wrapped as properties
;

    // Class IMeshTools_ShapeExplorer from ./opencascade/IMeshTools_ShapeExplorer.hxx
    klass = m.attr("IMeshTools_ShapeExplorer");


    // nested enums

    static_cast<py::class_<IMeshTools_ShapeExplorer ,opencascade::handle<IMeshTools_ShapeExplorer>  , IMeshData_Shape >>(klass)
    // constructors
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("theShape") )
    // custom constructors
    // methods
        .def("Accept",
             (void (IMeshTools_ShapeExplorer::*)(  const handle<IMeshTools_ShapeVisitor> &  ) ) static_cast<void (IMeshTools_ShapeExplorer::*)(  const handle<IMeshTools_ShapeVisitor> &  ) >(&IMeshTools_ShapeExplorer::Accept),
             R"#(Starts exploring of a shape.)#"  , py::arg("theVisitor")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_ShapeExplorer::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_ShapeExplorer::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_ShapeExplorer::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_ShapeExplorer::*)() const>(&IMeshTools_ShapeExplorer::DynamicType),
             R"#()#"
             
         )
;

    // Class IMeshTools_ShapeVisitor from ./opencascade/IMeshTools_ShapeVisitor.hxx
    klass = m.attr("IMeshTools_ShapeVisitor");


    // nested enums

    static_cast<py::class_<IMeshTools_ShapeVisitor ,opencascade::handle<IMeshTools_ShapeVisitor> ,Py_IMeshTools_ShapeVisitor , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Visit",
             (void (IMeshTools_ShapeVisitor::*)(  const TopoDS_Face &  ) ) static_cast<void (IMeshTools_ShapeVisitor::*)(  const TopoDS_Face &  ) >(&IMeshTools_ShapeVisitor::Visit),
             R"#(Handles TopoDS_Face object.)#"  , py::arg("theFace")
          )
        .def("Visit",
             (void (IMeshTools_ShapeVisitor::*)(  const TopoDS_Edge &  ) ) static_cast<void (IMeshTools_ShapeVisitor::*)(  const TopoDS_Edge &  ) >(&IMeshTools_ShapeVisitor::Visit),
             R"#(Handles TopoDS_Edge object.)#"  , py::arg("theEdge")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IMeshTools_ShapeVisitor::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IMeshTools_ShapeVisitor::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IMeshTools_ShapeVisitor::*)() const) static_cast< const handle<Standard_Type> & (IMeshTools_ShapeVisitor::*)() const>(&IMeshTools_ShapeVisitor::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/IMeshTools_Context.hxx
// ./opencascade/IMeshTools_CurveTessellator.hxx
// ./opencascade/IMeshTools_MeshAlgo.hxx
// ./opencascade/IMeshTools_MeshAlgoFactory.hxx
// ./opencascade/IMeshTools_MeshAlgoType.hxx
// ./opencascade/IMeshTools_MeshBuilder.hxx
// ./opencascade/IMeshTools_ModelAlgo.hxx
// ./opencascade/IMeshTools_ModelBuilder.hxx
// ./opencascade/IMeshTools_Parameters.hxx
// ./opencascade/IMeshTools_ShapeExplorer.hxx
// ./opencascade/IMeshTools_ShapeVisitor.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
