
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtk_Interface.hxx>
#include <IVtk_IShape.hxx>
#include <IVtk_IShapeData.hxx>
#include <IVtk_IShapeMesher.hxx>
#include <IVtk_IView.hxx>
#include <IVtk_Types.hxx>

// template related includes

// ./opencascade/IVtk_IShape.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/IVtk_Types.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/IVtk_Types.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/IVtk_Types.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/IVtk_Types.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/IVtk_Types.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IVtk(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IVtk"));
py::object klass;

//Python trampoline classes
    class Py_IVtk_IShape : public IVtk_IShape{
    public:
        using IVtk_IShape::IVtk_IShape;


        // public pure virtual
        IVtk_ShapeIdList GetSubIds( const IVtk_IdType theId) const  override { using return_type = IVtk_ShapeIdList;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IShape,GetSubIds,theId) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IVtk_IShapeData : public IVtk_IShapeData{
    public:
        using IVtk_IShapeData::IVtk_IShapeData;


        // public pure virtual
        IVtk_PointId InsertPoint( const gp_Pnt & thePnt, const NCollection_Vec3<float> & theNorm) override { using return_type = IVtk_PointId;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IShapeData,InsertPoint,thePnt,theNorm) };
        void InsertVertex( const IVtk_IdType theShapeID, const IVtk_PointId thePointId, const IVtk_MeshType theMeshType) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IShapeData,InsertVertex,theShapeID,thePointId,theMeshType) };
        void InsertLine( const IVtk_IdType theShapeID, const IVtk_PointId thePointId1, const IVtk_PointId thePointId2, const IVtk_MeshType theMeshType) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IShapeData,InsertLine,theShapeID,thePointId1,thePointId2,theMeshType) };
        void InsertLine( const IVtk_IdType theShapeID, const IVtk_PointIdList * thePointIds, const IVtk_MeshType theMeshType) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IShapeData,InsertLine,theShapeID,thePointIds,theMeshType) };
        void InsertTriangle( const IVtk_IdType theShapeID, const IVtk_PointId thePointId1, const IVtk_PointId thePointId2, const IVtk_PointId thePointId3, const IVtk_MeshType theMeshType) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IShapeData,InsertTriangle,theShapeID,thePointId1,thePointId2,thePointId3,theMeshType) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IVtk_IShapeMesher : public IVtk_IShapeMesher{
    public:
        using IVtk_IShapeMesher::IVtk_IShapeMesher;


        // public pure virtual


        // protected pure virtual
        void internalBuild() override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IShapeMesher,internalBuild,) };


        // private pure virtual

    };
    class Py_IVtk_IView : public IVtk_IView{
    public:
        using IVtk_IView::IVtk_IView;


        // public pure virtual
        bool IsPerspective() const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,IsPerspective,) };
        double GetDistance() const  override { using return_type = double;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetDistance,) };
        void GetEyePosition(double & theX,double & theY,double & theZ) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetEyePosition,theX,theY,theZ) };
        void GetPosition(double & theX,double & theY,double & theZ) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetPosition,theX,theY,theZ) };
        void GetViewUp(double & theDx,double & theDy,double & theDz) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetViewUp,theDx,theDy,theDz) };
        void GetDirectionOfProjection(double & theDx,double & theDy,double & theDz) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetDirectionOfProjection,theDx,theDy,theDz) };
        void GetScale(double & theX,double & theY,double & theZ) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetScale,theX,theY,theZ) };
        double GetParallelScale() const  override { using return_type = double;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetParallelScale,) };
        double GetViewAngle() const  override { using return_type = double;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetViewAngle,) };
        void GetClippingRange(double & theZNear,double & theZFar) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetClippingRange,theZNear,theZFar) };
        double GetAspectRatio() const  override { using return_type = double;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetAspectRatio,) };
        void GetViewCenter(double & theX,double & theY) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetViewCenter,theX,theY) };
        void GetWindowSize(int & theX,int & theY) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetWindowSize,theX,theY) };
        bool DisplayToWorld( const gp_XY & theDisplayPnt,gp_XYZ & theWorldPnt) const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,DisplayToWorld,theDisplayPnt,theWorldPnt) };
        void GetCamera(Graphic3d_Mat4d & theProj,Graphic3d_Mat4d & theOrient,Standard_Boolean & theIsOrtho) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetCamera,theProj,theOrient,theIsOrtho) };
        void GetViewport(Standard_Real & theX,Standard_Real & theY,Standard_Real & theWidth,Standard_Real & theHeight) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IVtk_IView,GetViewport,theX,theY,theWidth,theHeight) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class IVtk_Interface from ./opencascade/IVtk_Interface.hxx
    klass = m.attr("IVtk_Interface");

    // default constructor
    register_default_constructor<IVtk_Interface ,opencascade::handle<IVtk_Interface>>(m,"IVtk_Interface");

    // nested enums

    static_cast<py::class_<IVtk_Interface ,opencascade::handle<IVtk_Interface>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtk_Interface::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtk_Interface::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtk_Interface::*)() const) static_cast< const handle<Standard_Type> & (IVtk_Interface::*)() const>(&IVtk_Interface::DynamicType),
             R"#()#"
             
         )
;

    // Class IVtk_IShape from ./opencascade/IVtk_IShape.hxx
    klass = m.attr("IVtk_IShape");


    // nested enums

    static_cast<py::class_<IVtk_IShape ,opencascade::handle<IVtk_IShape> ,Py_IVtk_IShape , IVtk_Interface >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GetId",
             (IVtk_IdType (IVtk_IShape::*)() const) static_cast<IVtk_IdType (IVtk_IShape::*)() const>(&IVtk_IShape::GetId),
             R"#()#" 
          )
        .def("SetId",
             (void (IVtk_IShape::*)(  const IVtk_IdType  ) ) static_cast<void (IVtk_IShape::*)(  const IVtk_IdType  ) >(&IVtk_IShape::SetId),
             R"#()#"  , py::arg("theId")
          )
        .def("GetSubIds",
             (IVtk_ShapeIdList (IVtk_IShape::*)(  const IVtk_IdType  ) const) static_cast<IVtk_ShapeIdList (IVtk_IShape::*)(  const IVtk_IdType  ) const>(&IVtk_IShape::GetSubIds),
             R"#(Get ids of sub-shapes composing a sub-shape with the given id)#"  , py::arg("theId")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtk_IShape::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtk_IShape::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtk_IShape::*)() const) static_cast< const handle<Standard_Type> & (IVtk_IShape::*)() const>(&IVtk_IShape::DynamicType),
             R"#()#"
             
         )
;

    // Class IVtk_IShapeData from ./opencascade/IVtk_IShapeData.hxx
    klass = m.attr("IVtk_IShapeData");


    // nested enums

    static_cast<py::class_<IVtk_IShapeData ,opencascade::handle<IVtk_IShapeData> ,Py_IVtk_IShapeData , IVtk_Interface >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("InsertPoint",
             (IVtk_PointId (IVtk_IShapeData::*)(  const gp_Pnt & ,   const NCollection_Vec3<float> &  ) ) static_cast<IVtk_PointId (IVtk_IShapeData::*)(  const gp_Pnt & ,   const NCollection_Vec3<float> &  ) >(&IVtk_IShapeData::InsertPoint),
             R"#(Insert a coordinate)#"  , py::arg("thePnt"),  py::arg("theNorm")
          )
        .def("InsertVertex",
             (void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointId ,   const IVtk_MeshType  ) ) static_cast<void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointId ,   const IVtk_MeshType  ) >(&IVtk_IShapeData::InsertVertex),
             R"#(Insert a vertex.)#"  , py::arg("theShapeID"),  py::arg("thePointId"),  py::arg("theMeshType")=static_cast< const IVtk_MeshType>(MT_Undefined)
          )
        .def("InsertLine",
             (void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointId ,   const IVtk_PointId ,   const IVtk_MeshType  ) ) static_cast<void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointId ,   const IVtk_PointId ,   const IVtk_MeshType  ) >(&IVtk_IShapeData::InsertLine),
             R"#(Insert a line.)#"  , py::arg("theShapeID"),  py::arg("thePointId1"),  py::arg("thePointId2"),  py::arg("theMeshType")=static_cast< const IVtk_MeshType>(MT_Undefined)
          )
        .def("InsertLine",
             (void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointIdList * ,   const IVtk_MeshType  ) ) static_cast<void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointIdList * ,   const IVtk_MeshType  ) >(&IVtk_IShapeData::InsertLine),
             R"#(Insert a poly-line.)#"  , py::arg("theShapeID"),  py::arg("thePointIds"),  py::arg("theMeshType")=static_cast< const IVtk_MeshType>(MT_Undefined)
          )
        .def("InsertTriangle",
             (void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointId ,   const IVtk_PointId ,   const IVtk_PointId ,   const IVtk_MeshType  ) ) static_cast<void (IVtk_IShapeData::*)(  const IVtk_IdType ,   const IVtk_PointId ,   const IVtk_PointId ,   const IVtk_PointId ,   const IVtk_MeshType  ) >(&IVtk_IShapeData::InsertTriangle),
             R"#(Insert a triangle)#"  , py::arg("theShapeID"),  py::arg("thePointId1"),  py::arg("thePointId2"),  py::arg("thePointId3"),  py::arg("theMeshType")=static_cast< const IVtk_MeshType>(MT_Undefined)
          )
        .def("InsertCoordinate",
             (IVtk_PointId (IVtk_IShapeData::*)( double ,  double ,  double  ) ) static_cast<IVtk_PointId (IVtk_IShapeData::*)( double ,  double ,  double  ) >(&IVtk_IShapeData::InsertCoordinate),
             R"#(Insert a coordinate)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("InsertCoordinate",
             (IVtk_PointId (IVtk_IShapeData::*)(  const gp_Pnt &  ) ) static_cast<IVtk_PointId (IVtk_IShapeData::*)(  const gp_Pnt &  ) >(&IVtk_IShapeData::InsertCoordinate),
             R"#(Insert a coordinate)#"  , py::arg("thePnt")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtk_IShapeData::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtk_IShapeData::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtk_IShapeData::*)() const) static_cast< const handle<Standard_Type> & (IVtk_IShapeData::*)() const>(&IVtk_IShapeData::DynamicType),
             R"#()#"
             
         )
;

    // Class IVtk_IShapeMesher from ./opencascade/IVtk_IShapeMesher.hxx
    klass = m.attr("IVtk_IShapeMesher");


    // nested enums

    static_cast<py::class_<IVtk_IShapeMesher ,opencascade::handle<IVtk_IShapeMesher> ,Py_IVtk_IShapeMesher , IVtk_Interface >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Build",
             (void (IVtk_IShapeMesher::*)(  const typename IVtk_IShape::Handle & ,   const typename IVtk_IShapeData::Handle &  ) ) static_cast<void (IVtk_IShapeMesher::*)(  const typename IVtk_IShape::Handle & ,   const typename IVtk_IShapeData::Handle &  ) >(&IVtk_IShapeMesher::Build),
             R"#(Main entry point for building shape representation)#"  , py::arg("theShape"),  py::arg("theData")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtk_IShapeMesher::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtk_IShapeMesher::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtk_IShapeMesher::*)() const) static_cast< const handle<Standard_Type> & (IVtk_IShapeMesher::*)() const>(&IVtk_IShapeMesher::DynamicType),
             R"#()#"
             
         )
;

    // Class IVtk_IView from ./opencascade/IVtk_IView.hxx
    klass = m.attr("IVtk_IView");


    // nested enums

    static_cast<py::class_<IVtk_IView ,opencascade::handle<IVtk_IView> ,Py_IVtk_IView , IVtk_Interface >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsPerspective",
             (bool (IVtk_IView::*)() const) static_cast<bool (IVtk_IView::*)() const>(&IVtk_IView::IsPerspective),
             R"#(Returns true if this is a perspective view, and false otherwise.)#" 
          )
        .def("GetDistance",
             (double (IVtk_IView::*)() const) static_cast<double (IVtk_IView::*)() const>(&IVtk_IView::GetDistance),
             R"#(Returns The focal distance of the view)#" 
          )
        .def("GetEyePosition",
             (void (IVtk_IView::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtk_IView::*)( double & ,  double & ,  double &  ) const>(&IVtk_IView::GetEyePosition),
             R"#(Returns The world coordinates of the camera position)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("GetPosition",
             (void (IVtk_IView::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtk_IView::*)( double & ,  double & ,  double &  ) const>(&IVtk_IView::GetPosition),
             R"#(Returns The world coordinates of the view position)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("GetViewUp",
             (void (IVtk_IView::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtk_IView::*)( double & ,  double & ,  double &  ) const>(&IVtk_IView::GetViewUp),
             R"#(Returns The "view up" direction of the view)#"  , py::arg("theDx"),  py::arg("theDy"),  py::arg("theDz")
          )
        .def("GetDirectionOfProjection",
             (void (IVtk_IView::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtk_IView::*)( double & ,  double & ,  double &  ) const>(&IVtk_IView::GetDirectionOfProjection),
             R"#(Returns The projection direction vector of this view)#"  , py::arg("theDx"),  py::arg("theDy"),  py::arg("theDz")
          )
        .def("GetScale",
             (void (IVtk_IView::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtk_IView::*)( double & ,  double & ,  double &  ) const>(&IVtk_IView::GetScale),
             R"#(Returns Three doubles containing scale components of the view transformation)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("GetParallelScale",
             (double (IVtk_IView::*)() const) static_cast<double (IVtk_IView::*)() const>(&IVtk_IView::GetParallelScale),
             R"#(Returns The current view's zoom factor (for parallel projection))#" 
          )
        .def("GetViewAngle",
             (double (IVtk_IView::*)() const) static_cast<double (IVtk_IView::*)() const>(&IVtk_IView::GetViewAngle),
             R"#(Returns The current view angle (for perspective projection))#" 
          )
        .def("GetClippingRange",
             (void (IVtk_IView::*)( double & ,  double &  ) const) static_cast<void (IVtk_IView::*)( double & ,  double &  ) const>(&IVtk_IView::GetClippingRange),
             R"#(Returns The location of the near and far clipping planes along the direction of projection)#"  , py::arg("theZNear"),  py::arg("theZFar")
          )
        .def("GetAspectRatio",
             (double (IVtk_IView::*)() const) static_cast<double (IVtk_IView::*)() const>(&IVtk_IView::GetAspectRatio),
             R"#(Returns The current view the aspect ratio)#" 
          )
        .def("GetViewCenter",
             (void (IVtk_IView::*)( double & ,  double &  ) const) static_cast<void (IVtk_IView::*)( double & ,  double &  ) const>(&IVtk_IView::GetViewCenter),
             R"#(Returns Two doubles containing the display coordinates of the view window center)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("GetWindowSize",
             (void (IVtk_IView::*)( int & ,  int &  ) const) static_cast<void (IVtk_IView::*)( int & ,  int &  ) const>(&IVtk_IView::GetWindowSize),
             R"#(Gets window size in screen coordinates in pixels)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("DisplayToWorld",
             (bool (IVtk_IView::*)(  const gp_XY & ,  gp_XYZ &  ) const) static_cast<bool (IVtk_IView::*)(  const gp_XY & ,  gp_XYZ &  ) const>(&IVtk_IView::DisplayToWorld),
             R"#(Converts 3D display coordinates into 3D world coordinates.)#"  , py::arg("theDisplayPnt"),  py::arg("theWorldPnt")
          )
    // methods using call by reference i.s.o. return
        .def("GetCamera",
             []( IVtk_IView &self , Graphic3d_Mat4d & theProj,Graphic3d_Mat4d & theOrient ){
                 Standard_Boolean  theIsOrtho;

                 self.GetCamera(theProj,theOrient,theIsOrtho);
                 
                 return std::make_tuple(theIsOrtho); },
             R"#(Gets camera projection and orientation matrices)#"  , py::arg("theProj"),  py::arg("theOrient")
          )
        .def("GetViewport",
             []( IVtk_IView &self   ){
                 Standard_Real  theX;
                Standard_Real  theY;
                Standard_Real  theWidth;
                Standard_Real  theHeight;

                 self.GetViewport(theX,theY,theWidth,theHeight);
                 
                 return std::make_tuple(theX,theY,theWidth,theHeight); },
             R"#(Gets viewport coordinates)#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtk_IView::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtk_IView::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtk_IView::*)() const) static_cast< const handle<Standard_Type> & (IVtk_IView::*)() const>(&IVtk_IView::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/IVtk_IShape.hxx
// ./opencascade/IVtk_IShapeData.hxx
// ./opencascade/IVtk_IShapeMesher.hxx
// ./opencascade/IVtk_IView.hxx
// ./opencascade/IVtk_Interface.hxx
// ./opencascade/IVtk_Types.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_List<IVtk_IShape::Handle>(m,"IVtk_ShapePtrList");
    register_template_NCollection_List<IVtk_IdType>(m,"IVtk_ShapeIdList");
    register_template_NCollection_DataMap<IVtk_IdType, IVtk_ShapeIdList>(m,"IVtk_SubShapeMap");
    register_template_NCollection_Map<IVtk_IdType>(m,"IVtk_IdTypeMap");
    register_template_NCollection_List<gp_XY>(m,"IVtk_Pnt2dList");
    register_template_NCollection_List<IVtk_SelectionMode>(m,"IVtk_SelectionModeList");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
