
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IVtkTools_ShapeDataSource.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtkTools.hxx>
#include <IVtkTools_DisplayModeFilter.hxx>
#include <IVtkTools_ShapeDataSource.hxx>
#include <IVtkTools_ShapeObject.hxx>
#include <IVtkTools_ShapePicker.hxx>
#include <IVtkTools_SubPolyDataFilter.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#undef Handle
#include <vtkRenderer.h>
#include <vtkActor.h>
#include <vtkInformationObjectBaseKey.h>

// Module definiiton
void register_IVtkTools_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IVtkTools", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<IVtkTools_ShapeDataSource , shared_ptr_nodelete<IVtkTools_ShapeDataSource>  >(m,"IVtkTools_ShapeDataSource",R"#(VTK data source for OCC shapes polygonal data.)#");
    py::class_<IVtkTools_ShapeObject , shared_ptr_nodelete<IVtkTools_ShapeObject>  >(m,"IVtkTools_ShapeObject",R"#(VTK holder class for OCC shapes to pass them through pipelines.)#");
    py::class_<IVtkTools_ShapePicker , shared_ptr_nodelete<IVtkTools_ShapePicker>  >(m,"IVtkTools_ShapePicker",R"#(VTK picker for OCC shapes with OCC selection algorithm.)#");
    py::class_<IVtkTools_SubPolyDataFilter , shared_ptr_nodelete<IVtkTools_SubPolyDataFilter>  >(m,"IVtkTools_SubPolyDataFilter",R"#(Cells filter according to the given set of cells ids.)#");
    py::class_<IVtkTools_DisplayModeFilter , shared_ptr_nodelete<IVtkTools_DisplayModeFilter>  , IVtkTools_SubPolyDataFilter >(m,"IVtkTools_DisplayModeFilter",R"#(Cells filter according to the selected display mode by mesh parts types. This filter is used to get parts of a shape according to different display modes.)#");

};

// user-defined post-inclusion per module

// user-defined post
