
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtkVTK_ShapeData.hxx>
#include <IVtkVTK_View.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <vtkRenderer.h>
#include "vtk_pybind.h" 

// Module definiiton
void register_IVtkVTK_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IVtkVTK", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<IVtkVTK_ShapeData ,opencascade::handle<IVtkVTK_ShapeData>  , IVtk_IShapeData >(m,"IVtkVTK_ShapeData",R"#(IShapeData implementation for VTK.IShapeData implementation for VTK.IShapeData implementation for VTK.)#");
    py::class_<IVtkVTK_View ,opencascade::handle<IVtkVTK_View>  , IVtk_IView >(m,"IVtkVTK_View",R"#(ICamera implementation for VTK.ICamera implementation for VTK.ICamera implementation for VTK.)#");

};

// user-defined post-inclusion per module

// user-defined post
