
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IntImp_ComputeTangence.hxx>
#include <IntImp_ConstIsoparametric.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IntImp_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IntImp", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<IntImp_ConstIsoparametric>(m, "IntImp_ConstIsoparametric",R"#()#")
        .value("IntImp_UIsoparametricOnCaro1",IntImp_ConstIsoparametric::IntImp_UIsoparametricOnCaro1)
        .value("IntImp_VIsoparametricOnCaro1",IntImp_ConstIsoparametric::IntImp_VIsoparametricOnCaro1)
        .value("IntImp_UIsoparametricOnCaro2",IntImp_ConstIsoparametric::IntImp_UIsoparametricOnCaro2)
        .value("IntImp_VIsoparametricOnCaro2",IntImp_ConstIsoparametric::IntImp_VIsoparametricOnCaro2).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)

};

// user-defined post-inclusion per module

// user-defined post
