
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_BasicAttribute.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_Attr.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_NodeList.hxx>
#include <LDOM_BasicAttribute.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_CharacterData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_BasicElement.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_DocumentType.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_BasicElement.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_BasicNode.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_BasicNode.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LDOM_Document.hxx>
#include <LDOM_Node.hxx>

// module includes
#include <LDOM_Attr.hxx>
#include <LDOM_BasicAttribute.hxx>
#include <LDOM_BasicElement.hxx>
#include <LDOM_BasicNode.hxx>
#include <LDOM_BasicText.hxx>
#include <LDOM_CDATASection.hxx>
#include <LDOM_CharacterData.hxx>
#include <LDOM_CharReference.hxx>
#include <LDOM_Comment.hxx>
#include <LDOM_DeclareSequence.hxx>
#include <LDOM_Document.hxx>
#include <LDOM_DocumentType.hxx>
#include <LDOM_Element.hxx>
#include <LDOM_LDOMImplementation.hxx>
#include <LDOM_MemManager.hxx>
#include <LDOM_Node.hxx>
#include <LDOM_NodeList.hxx>
#include <LDOM_OSStream.hxx>
#include <LDOM_Text.hxx>
#include <LDOM_XmlReader.hxx>
#include <LDOM_XmlWriter.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_LDOM(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("LDOM"));
py::object klass;

//Python trampoline classes

// classes

    // Class LDOM_BasicNode from ./opencascade/LDOM_BasicNode.hxx
    klass = m.attr("LDOM_BasicNode");


    // nested enums

    static_cast<py::class_<LDOM_BasicNode , shared_ptr<LDOM_BasicNode>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("isNull",
             (Standard_Boolean (LDOM_BasicNode::*)() const) static_cast<Standard_Boolean (LDOM_BasicNode::*)() const>(&LDOM_BasicNode::isNull),
             R"#()#" 
          )
        .def("getNodeType",
             (LDOM_Node::NodeType (LDOM_BasicNode::*)() const) static_cast<LDOM_Node::NodeType (LDOM_BasicNode::*)() const>(&LDOM_BasicNode::getNodeType),
             R"#()#" 
          )
        .def("GetSibling",
             ( const LDOM_BasicNode * (LDOM_BasicNode::*)() const) static_cast< const LDOM_BasicNode * (LDOM_BasicNode::*)() const>(&LDOM_BasicNode::GetSibling),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_CharReference from ./opencascade/LDOM_CharReference.hxx
    klass = m.attr("LDOM_CharReference");

    // default constructor
    register_default_constructor<LDOM_CharReference , shared_ptr<LDOM_CharReference>>(m,"LDOM_CharReference");

    // nested enums

    static_cast<py::class_<LDOM_CharReference , shared_ptr<LDOM_CharReference>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Decode_s",
                    (char * (*)( char * ,  Standard_Integer &  ) ) static_cast<char * (*)( char * ,  Standard_Integer &  ) >(&LDOM_CharReference::Decode),
                    R"#()#"  , py::arg("theSrc"),  py::arg("theLen")
          )
        .def_static("Encode_s",
                    (char * (*)(  const char * ,  Standard_Integer & ,   const Standard_Boolean  ) ) static_cast<char * (*)(  const char * ,  Standard_Integer & ,   const Standard_Boolean  ) >(&LDOM_CharReference::Encode),
                    R"#()#"  , py::arg("theSrc"),  py::arg("theLen"),  py::arg("isAttribute")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_Document from ./opencascade/LDOM_Document.hxx
    klass = m.attr("LDOM_Document");


    // nested enums

    static_cast<py::class_<LDOM_Document , shared_ptr<LDOM_Document>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_MemManager & >()  , py::arg("aMemManager") )
    // custom constructors
    // methods
        .def("createElement",
             (LDOM_Element (LDOM_Document::*)(  const LDOMString &  ) ) static_cast<LDOM_Element (LDOM_Document::*)(  const LDOMString &  ) >(&LDOM_Document::createElement),
             R"#()#"  , py::arg("theTagName")
          )
        .def("createCDATASection",
             (LDOM_CDATASection (LDOM_Document::*)(  const LDOMString &  ) ) static_cast<LDOM_CDATASection (LDOM_Document::*)(  const LDOMString &  ) >(&LDOM_Document::createCDATASection),
             R"#()#"  , py::arg("theData")
          )
        .def("createComment",
             (LDOM_Comment (LDOM_Document::*)(  const LDOMString &  ) ) static_cast<LDOM_Comment (LDOM_Document::*)(  const LDOMString &  ) >(&LDOM_Document::createComment),
             R"#()#"  , py::arg("theData")
          )
        .def("createTextNode",
             (LDOM_Text (LDOM_Document::*)(  const LDOMString &  ) ) static_cast<LDOM_Text (LDOM_Document::*)(  const LDOMString &  ) >(&LDOM_Document::createTextNode),
             R"#()#"  , py::arg("theData")
          )
        .def("getDocumentElement",
             (LDOM_Element (LDOM_Document::*)() const) static_cast<LDOM_Element (LDOM_Document::*)() const>(&LDOM_Document::getDocumentElement),
             R"#()#" 
          )
        .def("getElementsByTagName",
             (LDOM_NodeList (LDOM_Document::*)(  const LDOMString &  ) const) static_cast<LDOM_NodeList (LDOM_Document::*)(  const LDOMString &  ) const>(&LDOM_Document::getElementsByTagName),
             R"#()#"  , py::arg("theTagName")
          )
        .def("isNull",
             (Standard_Boolean (LDOM_Document::*)() const) static_cast<Standard_Boolean (LDOM_Document::*)() const>(&LDOM_Document::isNull),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("createDocument_s",
                    (LDOM_Document (*)(  const LDOMString &  ) ) static_cast<LDOM_Document (*)(  const LDOMString &  ) >(&LDOM_Document::createDocument),
                    R"#()#"  , py::arg("theQualifiedName")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_DocumentType from ./opencascade/LDOM_DocumentType.hxx
    klass = m.attr("LDOM_DocumentType");


    // nested enums

    static_cast<py::class_<LDOM_DocumentType , shared_ptr<LDOM_DocumentType>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_LDOMImplementation from ./opencascade/LDOM_LDOMImplementation.hxx
    klass = m.attr("LDOM_LDOMImplementation");

    // default constructor
    register_default_constructor<LDOM_LDOMImplementation , shared_ptr<LDOM_LDOMImplementation>>(m,"LDOM_LDOMImplementation");

    // nested enums

    static_cast<py::class_<LDOM_LDOMImplementation , shared_ptr<LDOM_LDOMImplementation>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("createDocument_s",
                    (LDOM_Document (*)(  const LDOMString & ,   const LDOMString & ,   const LDOM_DocumentType &  ) ) static_cast<LDOM_Document (*)(  const LDOMString & ,   const LDOMString & ,   const LDOM_DocumentType &  ) >(&LDOM_LDOMImplementation::createDocument),
                    R"#()#"  , py::arg("aNamespaceURI"),  py::arg("aQualifiedName"),  py::arg("aDocType")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_Node from ./opencascade/LDOM_Node.hxx
    klass = m.attr("LDOM_Node");


    // nested enums
        py::enum_<LDOM_Node::NodeType>(klass, "NodeType_e", R"#()#")
            .value("UNKNOWN", LDOM_Node::NodeType::UNKNOWN)
            .value("ELEMENT_NODE", LDOM_Node::NodeType::ELEMENT_NODE)
            .value("ATTRIBUTE_NODE", LDOM_Node::NodeType::ATTRIBUTE_NODE)
            .value("TEXT_NODE", LDOM_Node::NodeType::TEXT_NODE)
            .value("CDATA_SECTION_NODE", LDOM_Node::NodeType::CDATA_SECTION_NODE)
            .value("COMMENT_NODE", LDOM_Node::NodeType::COMMENT_NODE).export_values();

    static_cast<py::class_<LDOM_Node , shared_ptr<LDOM_Node>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_Node & >()  , py::arg("anOther") )
    // custom constructors
    // methods
        .def("isNull",
             (Standard_Boolean (LDOM_Node::*)() const) static_cast<Standard_Boolean (LDOM_Node::*)() const>(&LDOM_Node::isNull),
             R"#()#" 
          )
        .def("getNodeType",
             (LDOM_Node::NodeType (LDOM_Node::*)() const) static_cast<LDOM_Node::NodeType (LDOM_Node::*)() const>(&LDOM_Node::getNodeType),
             R"#()#" 
          )
        .def("getNodeName",
             (LDOMString (LDOM_Node::*)() const) static_cast<LDOMString (LDOM_Node::*)() const>(&LDOM_Node::getNodeName),
             R"#()#" 
          )
        .def("getNodeValue",
             (LDOMString (LDOM_Node::*)() const) static_cast<LDOMString (LDOM_Node::*)() const>(&LDOM_Node::getNodeValue),
             R"#()#" 
          )
        .def("getFirstChild",
             (LDOM_Node (LDOM_Node::*)() const) static_cast<LDOM_Node (LDOM_Node::*)() const>(&LDOM_Node::getFirstChild),
             R"#()#" 
          )
        .def("getLastChild",
             (LDOM_Node (LDOM_Node::*)() const) static_cast<LDOM_Node (LDOM_Node::*)() const>(&LDOM_Node::getLastChild),
             R"#()#" 
          )
        .def("getNextSibling",
             (LDOM_Node (LDOM_Node::*)() const) static_cast<LDOM_Node (LDOM_Node::*)() const>(&LDOM_Node::getNextSibling),
             R"#()#" 
          )
        .def("removeChild",
             (void (LDOM_Node::*)(  const LDOM_Node &  ) ) static_cast<void (LDOM_Node::*)(  const LDOM_Node &  ) >(&LDOM_Node::removeChild),
             R"#()#"  , py::arg("aChild")
          )
        .def("appendChild",
             (void (LDOM_Node::*)(  const LDOM_Node &  ) ) static_cast<void (LDOM_Node::*)(  const LDOM_Node &  ) >(&LDOM_Node::appendChild),
             R"#()#"  , py::arg("aChild")
          )
        .def("hasChildNodes",
             (Standard_Boolean (LDOM_Node::*)() const) static_cast<Standard_Boolean (LDOM_Node::*)() const>(&LDOM_Node::hasChildNodes),
             R"#()#" 
          )
        .def("SetValueClear",
             (void (LDOM_Node::*)() const) static_cast<void (LDOM_Node::*)() const>(&LDOM_Node::SetValueClear),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("getOwnerDocument",
             ( const LDOM_MemManager & (LDOM_Node::*)() const) static_cast< const LDOM_MemManager & (LDOM_Node::*)() const>(&LDOM_Node::getOwnerDocument),
             R"#()#"
             
         )
;

    // Class LDOM_NodeList from ./opencascade/LDOM_NodeList.hxx
    klass = m.attr("LDOM_NodeList");


    // nested enums

    static_cast<py::class_<LDOM_NodeList , shared_ptr<LDOM_NodeList>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_NodeList & >()  , py::arg("theOther") )
    // custom constructors
    // methods
        .def("item",
             (LDOM_Node (LDOM_NodeList::*)(  const Standard_Integer  ) const) static_cast<LDOM_Node (LDOM_NodeList::*)(  const Standard_Integer  ) const>(&LDOM_NodeList::item),
             R"#()#"  , py::arg("arg0")
          )
        .def("getLength",
             (Standard_Integer (LDOM_NodeList::*)() const) static_cast<Standard_Integer (LDOM_NodeList::*)() const>(&LDOM_NodeList::getLength),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_OSStream from ./opencascade/LDOM_OSStream.hxx
    klass = m.attr("LDOM_OSStream");


    // nested enums
        py::enum_<LDOM_OSStream::BOMType>(klass, "BOMType_e", R"#()#")
            .value("BOM_UNDEFINED", LDOM_OSStream::BOMType::BOM_UNDEFINED)
            .value("BOM_UTF8", LDOM_OSStream::BOMType::BOM_UTF8)
            .value("BOM_UTF16BE", LDOM_OSStream::BOMType::BOM_UTF16BE)
            .value("BOM_UTF16LE", LDOM_OSStream::BOMType::BOM_UTF16LE)
            .value("BOM_UTF32BE", LDOM_OSStream::BOMType::BOM_UTF32BE)
            .value("BOM_UTF32LE", LDOM_OSStream::BOMType::BOM_UTF32LE)
            .value("BOM_UTF7", LDOM_OSStream::BOMType::BOM_UTF7)
            .value("BOM_UTF1", LDOM_OSStream::BOMType::BOM_UTF1)
            .value("BOM_UTFEBCDIC", LDOM_OSStream::BOMType::BOM_UTFEBCDIC)
            .value("BOM_SCSU", LDOM_OSStream::BOMType::BOM_SCSU)
            .value("BOM_BOCU1", LDOM_OSStream::BOMType::BOM_BOCU1)
            .value("BOM_GB18030", LDOM_OSStream::BOMType::BOM_GB18030).export_values();

    static_cast<py::class_<LDOM_OSStream , shared_ptr<LDOM_OSStream>  >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer >()  , py::arg("theMaxBuf") )
    // custom constructors
    // methods
        .def("str",
             (Standard_CString (LDOM_OSStream::*)() const) static_cast<Standard_CString (LDOM_OSStream::*)() const>(&LDOM_OSStream::str),
             R"#()#" 
          )
        .def("Length",
             (Standard_Integer (LDOM_OSStream::*)() const) static_cast<Standard_Integer (LDOM_OSStream::*)() const>(&LDOM_OSStream::Length),
             R"#()#" 
          )
        .def("Clear",
             (void (LDOM_OSStream::*)() ) static_cast<void (LDOM_OSStream::*)() >(&LDOM_OSStream::Clear),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_SBuffer from ./opencascade/LDOM_OSStream.hxx
    klass = m.attr("LDOM_SBuffer");


    // nested enums

    static_cast<py::class_<LDOM_SBuffer , shared_ptr<LDOM_SBuffer>  >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer >()  , py::arg("theMaxBuf") )
    // custom constructors
    // methods
        .def("str",
             (Standard_CString (LDOM_SBuffer::*)() const) static_cast<Standard_CString (LDOM_SBuffer::*)() const>(&LDOM_SBuffer::str),
             R"#(Concatenates strings of all sequence elements into one string. Space for output string is allocated with operator new. Caller of this function is responsible for memory release after the string usage.)#" 
          )
        .def("Length",
             (Standard_Integer (LDOM_SBuffer::*)() const) static_cast<Standard_Integer (LDOM_SBuffer::*)() const>(&LDOM_SBuffer::Length),
             R"#(Returns full length of data contained)#" 
          )
        .def("Clear",
             (void (LDOM_SBuffer::*)() ) static_cast<void (LDOM_SBuffer::*)() >(&LDOM_SBuffer::Clear),
             R"#(Clears first element of sequence and removes all others)#" 
          )
        .def("overflow",
             (int (LDOM_SBuffer::*)( int  ) ) static_cast<int (LDOM_SBuffer::*)( int  ) >(&LDOM_SBuffer::overflow),
             R"#()#"  , py::arg("c")=static_cast<int>(EOF)
          )
        .def("underflow",
             (int (LDOM_SBuffer::*)() ) static_cast<int (LDOM_SBuffer::*)() >(&LDOM_SBuffer::underflow),
             R"#()#" 
          )
        .def("xsputn",
             (std::streamsize (LDOM_SBuffer::*)(  const char * ,  std::streamsize  ) ) static_cast<std::streamsize (LDOM_SBuffer::*)(  const char * ,  std::streamsize  ) >(&LDOM_SBuffer::xsputn),
             R"#()#"  , py::arg("s"),  py::arg("n")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_XmlReader from ./opencascade/LDOM_XmlReader.hxx
    klass = m.attr("LDOM_XmlReader");


    // nested enums
        py::enum_<LDOM_XmlReader::RecordType>(klass, "RecordType_e", R"#()#")
            .value("XML_UNKNOWN", LDOM_XmlReader::RecordType::XML_UNKNOWN)
            .value("XML_HEADER", LDOM_XmlReader::RecordType::XML_HEADER)
            .value("XML_DOCTYPE", LDOM_XmlReader::RecordType::XML_DOCTYPE)
            .value("XML_COMMENT", LDOM_XmlReader::RecordType::XML_COMMENT)
            .value("XML_START_ELEMENT", LDOM_XmlReader::RecordType::XML_START_ELEMENT)
            .value("XML_END_ELEMENT", LDOM_XmlReader::RecordType::XML_END_ELEMENT)
            .value("XML_FULL_ELEMENT", LDOM_XmlReader::RecordType::XML_FULL_ELEMENT)
            .value("XML_TEXT", LDOM_XmlReader::RecordType::XML_TEXT)
            .value("XML_CDATA", LDOM_XmlReader::RecordType::XML_CDATA)
            .value("XML_EOF", LDOM_XmlReader::RecordType::XML_EOF).export_values();

    static_cast<py::class_<LDOM_XmlReader , shared_ptr<LDOM_XmlReader>  >>(klass)
    // constructors
        .def(py::init<  const handle<LDOM_MemManager> &,TCollection_AsciiString &, const Standard_Boolean >()  , py::arg("aDocument"),  py::arg("anErrorString"),  py::arg("theTagPerStep")=static_cast< const Standard_Boolean>(Standard_False) )
    // custom constructors
    // methods
        .def("ReadRecord",
             (LDOM_XmlReader::RecordType (LDOM_XmlReader::*)( Standard_IStream & ,  LDOM_OSStream & ,  Standard_Boolean &  ) ) static_cast<LDOM_XmlReader::RecordType (LDOM_XmlReader::*)( Standard_IStream & ,  LDOM_OSStream & ,  Standard_Boolean &  ) >(&LDOM_XmlReader::ReadRecord),
             R"#()#"  , py::arg("theIStream"),  py::arg("theData"),  py::arg("theDocStart")
          )
        .def("CreateElement",
             (void (LDOM_XmlReader::*)(  const char * ,   const Standard_Integer  ) ) static_cast<void (LDOM_XmlReader::*)(  const char * ,   const Standard_Integer  ) >(&LDOM_XmlReader::CreateElement),
             R"#()#"  , py::arg("theName"),  py::arg("theLen")
          )
        .def("GetBOM",
             (LDOM_OSStream::BOMType (LDOM_XmlReader::*)() const) static_cast<LDOM_OSStream::BOMType (LDOM_XmlReader::*)() const>(&LDOM_XmlReader::GetBOM),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("getInteger_s",
                    (Standard_Boolean (*)( LDOMBasicString & ,   const char * ,   const char *  ) ) static_cast<Standard_Boolean (*)( LDOMBasicString & ,   const char * ,   const char *  ) >(&LDOM_XmlReader::getInteger),
                    R"#()#"  , py::arg("theValue"),  py::arg("theStart"),  py::arg("theEnd")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetElement",
             (LDOM_BasicElement & (LDOM_XmlReader::*)() const) static_cast<LDOM_BasicElement & (LDOM_XmlReader::*)() const>(&LDOM_XmlReader::GetElement),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class LDOM_XmlWriter from ./opencascade/LDOM_XmlWriter.hxx
    klass = m.attr("LDOM_XmlWriter");


    // nested enums

    static_cast<py::class_<LDOM_XmlWriter , shared_ptr<LDOM_XmlWriter>  >>(klass)
    // constructors
        .def(py::init<  const char * >()  , py::arg("theEncoding")=static_cast< const char *>(NULL) )
    // custom constructors
    // methods
        .def("SetIndentation",
             (void (LDOM_XmlWriter::*)(  const Standard_Integer  ) ) static_cast<void (LDOM_XmlWriter::*)(  const Standard_Integer  ) >(&LDOM_XmlWriter::SetIndentation),
             R"#()#"  , py::arg("theIndent")
          )
        .def("Write",
             (void (LDOM_XmlWriter::*)( Standard_OStream & ,   const LDOM_Document &  ) ) static_cast<void (LDOM_XmlWriter::*)( Standard_OStream & ,   const LDOM_Document &  ) >(&LDOM_XmlWriter::Write),
             R"#()#"  , py::arg("theOStream"),  py::arg("theDoc")
          )
        .def("Write",
             (void (LDOM_XmlWriter::*)( Standard_OStream & ,   const LDOM_Node &  ) ) static_cast<void (LDOM_XmlWriter::*)( Standard_OStream & ,   const LDOM_Node &  ) >(&LDOM_XmlWriter::Write),
             R"#()#"  , py::arg("theOStream"),  py::arg("theNode")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_Attr from ./opencascade/LDOM_Attr.hxx
    klass = m.attr("LDOM_Attr");


    // nested enums

    static_cast<py::class_<LDOM_Attr , shared_ptr<LDOM_Attr>  , LDOM_Node >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_Attr & >()  , py::arg("anOther") )
    // custom constructors
    // methods
        .def("getName",
             (LDOMString (LDOM_Attr::*)() const) static_cast<LDOMString (LDOM_Attr::*)() const>(&LDOM_Attr::getName),
             R"#()#" 
          )
        .def("getValue",
             (LDOMString (LDOM_Attr::*)() const) static_cast<LDOMString (LDOM_Attr::*)() const>(&LDOM_Attr::getValue),
             R"#()#" 
          )
        .def("setValue",
             (void (LDOM_Attr::*)(  const LDOMString &  ) ) static_cast<void (LDOM_Attr::*)(  const LDOMString &  ) >(&LDOM_Attr::setValue),
             R"#()#"  , py::arg("aValue")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_BasicAttribute from ./opencascade/LDOM_BasicAttribute.hxx
    klass = m.attr("LDOM_BasicAttribute");


    // nested enums

    static_cast<py::class_<LDOM_BasicAttribute , shared_ptr<LDOM_BasicAttribute>  , LDOM_BasicNode >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("GetName",
             ( const char * (LDOM_BasicAttribute::*)() const) static_cast< const char * (LDOM_BasicAttribute::*)() const>(&LDOM_BasicAttribute::GetName),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetValue",
             ( const LDOMBasicString & (LDOM_BasicAttribute::*)() const) static_cast< const LDOMBasicString & (LDOM_BasicAttribute::*)() const>(&LDOM_BasicAttribute::GetValue),
             R"#()#"
             
         )
;

    // Class LDOM_BasicElement from ./opencascade/LDOM_BasicElement.hxx
    klass = m.attr("LDOM_BasicElement");


    // nested enums

    static_cast<py::class_<LDOM_BasicElement , shared_ptr<LDOM_BasicElement>  , LDOM_BasicNode >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("GetTagName",
             ( const char * (LDOM_BasicElement::*)() const) static_cast< const char * (LDOM_BasicElement::*)() const>(&LDOM_BasicElement::GetTagName),
             R"#()#" 
          )
        .def("GetFirstChild",
             ( const LDOM_BasicNode * (LDOM_BasicElement::*)() const) static_cast< const LDOM_BasicNode * (LDOM_BasicElement::*)() const>(&LDOM_BasicElement::GetFirstChild),
             R"#()#" 
          )
        .def("GetLastChild",
             ( const LDOM_BasicNode * (LDOM_BasicElement::*)() const) static_cast< const LDOM_BasicNode * (LDOM_BasicElement::*)() const>(&LDOM_BasicElement::GetLastChild),
             R"#()#" 
          )
        .def("GetAttribute",
             ( const LDOM_BasicAttribute & (LDOM_BasicElement::*)(  const LDOMBasicString & ,   const LDOM_BasicNode *  ) const) static_cast< const LDOM_BasicAttribute & (LDOM_BasicElement::*)(  const LDOMBasicString & ,   const LDOM_BasicNode *  ) const>(&LDOM_BasicElement::GetAttribute),
             R"#()#"  , py::arg("aName"),  py::arg("aLastCh")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Create_s",
                    (LDOM_BasicElement & (*)(  const char * ,   const Standard_Integer ,   const handle<LDOM_MemManager> &  ) ) static_cast<LDOM_BasicElement & (*)(  const char * ,   const Standard_Integer ,   const handle<LDOM_MemManager> &  ) >(&LDOM_BasicElement::Create),
                    R"#()#"  , py::arg("aName"),  py::arg("aLength"),  py::arg("aDoc")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_CharacterData from ./opencascade/LDOM_CharacterData.hxx
    klass = m.attr("LDOM_CharacterData");


    // nested enums

    static_cast<py::class_<LDOM_CharacterData , shared_ptr<LDOM_CharacterData>  , LDOM_Node >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_CharacterData & >()  , py::arg("theOther") )
    // custom constructors
    // methods
        .def("getData",
             (LDOMString (LDOM_CharacterData::*)() const) static_cast<LDOMString (LDOM_CharacterData::*)() const>(&LDOM_CharacterData::getData),
             R"#()#" 
          )
        .def("setData",
             (void (LDOM_CharacterData::*)(  const LDOMString &  ) ) static_cast<void (LDOM_CharacterData::*)(  const LDOMString &  ) >(&LDOM_CharacterData::setData),
             R"#()#"  , py::arg("aValue")
          )
        .def("getLength",
             (Standard_Integer (LDOM_CharacterData::*)() const) static_cast<Standard_Integer (LDOM_CharacterData::*)() const>(&LDOM_CharacterData::getLength),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_Element from ./opencascade/LDOM_Element.hxx
    klass = m.attr("LDOM_Element");


    // nested enums

    static_cast<py::class_<LDOM_Element , shared_ptr<LDOM_Element>  , LDOM_Node >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_Element & >()  , py::arg("anOther") )
    // custom constructors
    // methods
        .def("getTagName",
             (LDOMString (LDOM_Element::*)() const) static_cast<LDOMString (LDOM_Element::*)() const>(&LDOM_Element::getTagName),
             R"#()#" 
          )
        .def("getAttribute",
             (LDOMString (LDOM_Element::*)(  const LDOMString &  ) const) static_cast<LDOMString (LDOM_Element::*)(  const LDOMString &  ) const>(&LDOM_Element::getAttribute),
             R"#()#"  , py::arg("aName")
          )
        .def("getAttributeNode",
             (LDOM_Attr (LDOM_Element::*)(  const LDOMString &  ) const) static_cast<LDOM_Attr (LDOM_Element::*)(  const LDOMString &  ) const>(&LDOM_Element::getAttributeNode),
             R"#()#"  , py::arg("aName")
          )
        .def("getElementsByTagName",
             (LDOM_NodeList (LDOM_Element::*)(  const LDOMString &  ) const) static_cast<LDOM_NodeList (LDOM_Element::*)(  const LDOMString &  ) const>(&LDOM_Element::getElementsByTagName),
             R"#()#"  , py::arg("aName")
          )
        .def("setAttribute",
             (void (LDOM_Element::*)(  const LDOMString & ,   const LDOMString &  ) ) static_cast<void (LDOM_Element::*)(  const LDOMString & ,   const LDOMString &  ) >(&LDOM_Element::setAttribute),
             R"#()#"  , py::arg("aName"),  py::arg("aValue")
          )
        .def("setAttributeNode",
             (void (LDOM_Element::*)(  const LDOM_Attr &  ) ) static_cast<void (LDOM_Element::*)(  const LDOM_Attr &  ) >(&LDOM_Element::setAttributeNode),
             R"#()#"  , py::arg("aNewAttr")
          )
        .def("removeAttribute",
             (void (LDOM_Element::*)(  const LDOMString &  ) ) static_cast<void (LDOM_Element::*)(  const LDOMString &  ) >(&LDOM_Element::removeAttribute),
             R"#()#"  , py::arg("aName")
          )
        .def("GetChildByTagName",
             (LDOM_Element (LDOM_Element::*)(  const LDOMString &  ) const) static_cast<LDOM_Element (LDOM_Element::*)(  const LDOMString &  ) const>(&LDOM_Element::GetChildByTagName),
             R"#()#"  , py::arg("aTagName")
          )
        .def("GetSiblingByTagName",
             (LDOM_Element (LDOM_Element::*)() const) static_cast<LDOM_Element (LDOM_Element::*)() const>(&LDOM_Element::GetSiblingByTagName),
             R"#()#" 
          )
        .def("ReplaceElement",
             (void (LDOM_Element::*)(  const LDOM_Element &  ) ) static_cast<void (LDOM_Element::*)(  const LDOM_Element &  ) >(&LDOM_Element::ReplaceElement),
             R"#()#"  , py::arg("anOther")
          )
        .def("GetAttributesList",
             (LDOM_NodeList (LDOM_Element::*)() const) static_cast<LDOM_NodeList (LDOM_Element::*)() const>(&LDOM_Element::GetAttributesList),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_Comment from ./opencascade/LDOM_Comment.hxx
    klass = m.attr("LDOM_Comment");


    // nested enums

    static_cast<py::class_<LDOM_Comment , shared_ptr<LDOM_Comment>  , LDOM_CharacterData >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_Comment & >()  , py::arg("theOther") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_Text from ./opencascade/LDOM_Text.hxx
    klass = m.attr("LDOM_Text");


    // nested enums

    static_cast<py::class_<LDOM_Text , shared_ptr<LDOM_Text>  , LDOM_CharacterData >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_Text & >()  , py::arg("anOther") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LDOM_CDATASection from ./opencascade/LDOM_CDATASection.hxx
    klass = m.attr("LDOM_CDATASection");


    // nested enums

    static_cast<py::class_<LDOM_CDATASection , shared_ptr<LDOM_CDATASection>  , LDOM_Text >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const LDOM_CDATASection & >()  , py::arg("theOther") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/LDOM_Attr.hxx
// ./opencascade/LDOM_BasicAttribute.hxx
// ./opencascade/LDOM_BasicElement.hxx
// ./opencascade/LDOM_BasicNode.hxx
// ./opencascade/LDOM_BasicText.hxx
// ./opencascade/LDOM_CDATASection.hxx
// ./opencascade/LDOM_CharReference.hxx
// ./opencascade/LDOM_CharacterData.hxx
// ./opencascade/LDOM_Comment.hxx
// ./opencascade/LDOM_DeclareSequence.hxx
// ./opencascade/LDOM_Document.hxx
// ./opencascade/LDOM_DocumentType.hxx
// ./opencascade/LDOM_Element.hxx
// ./opencascade/LDOM_LDOMImplementation.hxx
// ./opencascade/LDOM_MemManager.hxx
// ./opencascade/LDOM_Node.hxx
// ./opencascade/LDOM_NodeList.hxx
// ./opencascade/LDOM_OSStream.hxx
// ./opencascade/LDOM_Text.hxx
// ./opencascade/LDOM_XmlReader.hxx
// ./opencascade/LDOM_XmlWriter.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
