import OCP.BiTgte
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.gp
import OCP.Geom
import OCP.TopTools
import OCP.TColStd
import OCP.TopoDS
import OCP.Standard
import OCP.GeomAbs
import OCP.Geom2d
import OCP.Adaptor3d
__all__  = [
"BiTgte_Blend",
"BiTgte_ContactType",
"BiTgte_CurveOnEdge",
"BiTgte_CurveOnVertex",
"BiTgte_EdgeEdge",
"BiTgte_EdgeVertex",
"BiTgte_FaceEdge",
"BiTgte_FaceFace",
"BiTgte_FaceVertex",
"BiTgte_VertexVertex"
]
class BiTgte_Blend():
    """
    Root class
    """
    def CenterLines(self,LC : OCP.TopTools.TopTools_ListOfShape) -> None: 
        """
        set in <LC> all the center lines
        """
    def Clear(self) -> None: 
        """
        Clear all the Fields.
        """
    def ComputeCenters(self) -> None: 
        """
        Computes the center lines
        """
    def ContactType(self,Index : int) -> BiTgte_ContactType: 
        """
        returns the type of contact
        """
    def CurveOnShape1(self,Index : int) -> OCP.Geom.Geom_Curve: 
        """
        gives the 3d curve of SurfaceFillet(Index) on SupportShape1(Index)
        """
    def CurveOnShape2(self,Index : int) -> OCP.Geom.Geom_Curve: 
        """
        gives the 3d curve of SurfaceFillet(Index) on SupportShape2(Index)
        """
    @overload
    def Face(self,Index : int) -> OCP.TopoDS.TopoDS_Face: 
        """
        returns the surface of range Index

        returns the face generated by the centerline. <CenterLine> may be - an edge : generate a pipe. - a vertex : generate a sphere. Warning: returns a Null Shape if <CenterLine> generates no surface.
        """
    @overload
    def Face(self,CenterLine : OCP.TopoDS.TopoDS_Shape) -> OCP.TopoDS.TopoDS_Face: ...
    def IndicesOfBranche(self,Index : int) -> tuple[int, int]: 
        """
        Set in <From>,<To> the indices of the faces of the branche <Index>.
        """
    def Init(self,S : OCP.TopoDS.TopoDS_Shape,Radius : float,Tol : float,NUBS : bool) -> None: ...
    def IsDone(self) -> bool: ...
    def NbBranches(self) -> int: ...
    def NbSurfaces(self) -> int: 
        """
        returns the Number of generated surfaces.
        """
    def PCurve1OnFillet(self,Index : int) -> OCP.Geom2d.Geom2d_Curve: 
        """
        gives the PCurve associated to CurveOnShape1(Index) on the Fillet
        """
    def PCurve2OnFillet(self,Index : int) -> OCP.Geom2d.Geom2d_Curve: 
        """
        gives the PCurve associated to CurveOnShape2(Index) on the fillet
        """
    def PCurveOnFace1(self,Index : int) -> OCP.Geom2d.Geom2d_Curve: 
        """
        gives the PCurve associated to CurvOnShape1(Index) on the support face Warning: returns a Null Handle if SupportShape1 is not a Face
        """
    def PCurveOnFace2(self,Index : int) -> OCP.Geom2d.Geom2d_Curve: 
        """
        gives the PCurve associated to CurveOnShape2(Index) on the support face Warning: returns a Null Handle if SupportShape2 is not a Face
        """
    def Perform(self,BuildShape : bool=True) -> None: 
        """
        Compute the generated surfaces. If <BuildShape> is true, compute the resulting Shape. If false, only the blending surfaces are computed.
        """
    def SetEdge(self,Edge : OCP.TopoDS.TopoDS_Edge) -> None: 
        """
        Set an edge of <myShape> to be rounded.
        """
    def SetFaces(self,F1 : OCP.TopoDS.TopoDS_Face,F2 : OCP.TopoDS.TopoDS_Face) -> None: 
        """
        Set two faces of <myShape> on which the Sphere must roll.
        """
    def SetStoppingFace(self,Face : OCP.TopoDS.TopoDS_Face) -> None: 
        """
        Set a face on which the fillet must stop.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        returns the result
        """
    def SupportShape1(self,Index : int) -> OCP.TopoDS.TopoDS_Shape: 
        """
        gives the first support shape relative to SurfaceFillet(Index);
        """
    def SupportShape2(self,Index : int) -> OCP.TopoDS.TopoDS_Shape: 
        """
        gives the second support shape relative to SurfaceFillet(Index);
        """
    @overload
    def Surface(self,Index : int) -> OCP.Geom.Geom_Surface: 
        """
        returns the surface of range Index

        returns the surface generated by the centerline. <CenterLine> may be - an edge : generate a pipe. - a vertex : generate a sphere. Warning: returns a Null Handle if <CenterLine> generates no surface.
        """
    @overload
    def Surface(self,CenterLine : OCP.TopoDS.TopoDS_Shape) -> OCP.Geom.Geom_Surface: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,S : OCP.TopoDS.TopoDS_Shape,Radius : float,Tol : float,NUBS : bool) -> None: ...
    pass
class BiTgte_ContactType():
    """
    Members:

      BiTgte_FaceFace

      BiTgte_FaceEdge

      BiTgte_FaceVertex

      BiTgte_EdgeEdge

      BiTgte_EdgeVertex

      BiTgte_VertexVertex
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    BiTgte_EdgeEdge: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_EdgeEdge: 3>
    BiTgte_EdgeVertex: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_EdgeVertex: 4>
    BiTgte_FaceEdge: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_FaceEdge: 1>
    BiTgte_FaceFace: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_FaceFace: 0>
    BiTgte_FaceVertex: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_FaceVertex: 2>
    BiTgte_VertexVertex: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_VertexVertex: 5>
    __entries: dict # value = {'BiTgte_FaceFace': (<BiTgte_ContactType.BiTgte_FaceFace: 0>, None), 'BiTgte_FaceEdge': (<BiTgte_ContactType.BiTgte_FaceEdge: 1>, None), 'BiTgte_FaceVertex': (<BiTgte_ContactType.BiTgte_FaceVertex: 2>, None), 'BiTgte_EdgeEdge': (<BiTgte_ContactType.BiTgte_EdgeEdge: 3>, None), 'BiTgte_EdgeVertex': (<BiTgte_ContactType.BiTgte_EdgeVertex: 4>, None), 'BiTgte_VertexVertex': (<BiTgte_ContactType.BiTgte_VertexVertex: 5>, None)}
    __members__: dict # value = {'BiTgte_FaceFace': <BiTgte_ContactType.BiTgte_FaceFace: 0>, 'BiTgte_FaceEdge': <BiTgte_ContactType.BiTgte_FaceEdge: 1>, 'BiTgte_FaceVertex': <BiTgte_ContactType.BiTgte_FaceVertex: 2>, 'BiTgte_EdgeEdge': <BiTgte_ContactType.BiTgte_EdgeEdge: 3>, 'BiTgte_EdgeVertex': <BiTgte_ContactType.BiTgte_EdgeVertex: 4>, 'BiTgte_VertexVertex': <BiTgte_ContactType.BiTgte_VertexVertex: 5>}
    pass
class BiTgte_CurveOnEdge(OCP.Adaptor3d.Adaptor3d_Curve, OCP.Standard.Standard_Transient):
    """
    private class used to create a filler rolling on an edge.private class used to create a filler rolling on an edge.
    """
    def BSpline(self) -> OCP.Geom.Geom_BSplineCurve: ...
    def Bezier(self) -> OCP.Geom.Geom_BezierCurve: ...
    def Circle(self) -> OCP.gp.gp_Circ: ...
    def Continuity(self) -> OCP.GeomAbs.GeomAbs_Shape: ...
    def D0(self,U : float,P : OCP.gp.gp_Pnt) -> None: 
        """
        Computes the point of parameter U on the curve.
        """
    def D1(self,U : float,P : OCP.gp.gp_Pnt,V : OCP.gp.gp_Vec) -> None: 
        """
        Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.
        """
    def D2(self,U : float,P : OCP.gp.gp_Pnt,V1 : OCP.gp.gp_Vec,V2 : OCP.gp.gp_Vec) -> None: 
        """
        Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.
        """
    def D3(self,U : float,P : OCP.gp.gp_Pnt,V1 : OCP.gp.gp_Vec,V2 : OCP.gp.gp_Vec,V3 : OCP.gp.gp_Vec) -> None: 
        """
        Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.
        """
    def DN(self,U : float,N : int) -> OCP.gp.gp_Vec: 
        """
        The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Ellipse(self) -> OCP.gp.gp_Elips: ...
    def FirstParameter(self) -> float: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetType(self) -> OCP.GeomAbs.GeomAbs_CurveType: 
        """
        Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.
        """
    def Hyperbola(self) -> OCP.gp.gp_Hypr: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,EonF : OCP.TopoDS.TopoDS_Edge,Edge : OCP.TopoDS.TopoDS_Edge) -> None: ...
    def Intervals(self,T : OCP.TColStd.TColStd_Array1OfReal,S : OCP.GeomAbs.GeomAbs_Shape) -> None: 
        """
        Stores in <T> the parameters bounding the intervals of continuity <S>.
        """
    def IsClosed(self) -> bool: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsPeriodic(self) -> bool: ...
    def IsRational(self) -> bool: ...
    def LastParameter(self) -> float: ...
    def Line(self) -> OCP.gp.gp_Lin: ...
    def NbIntervals(self,S : OCP.GeomAbs.GeomAbs_Shape) -> int: 
        """
        Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>
        """
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def OffsetCurve(self) -> OCP.Geom.Geom_OffsetCurve: ...
    def Parabola(self) -> OCP.gp.gp_Parab: ...
    def Period(self) -> float: ...
    def Resolution(self,R3d : float) -> float: 
        """
        Returns the parametric resolution corresponding to the real space resolution <R3d>.
        """
    def ShallowCopy(self) -> OCP.Adaptor3d.Adaptor3d_Curve: 
        """
        Shallow copy of adaptor
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Trim(self,First : float,Last : float,Tol : float) -> OCP.Adaptor3d.Adaptor3d_Curve: 
        """
        Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>
        """
    def Value(self,U : float) -> OCP.gp.gp_Pnt: 
        """
        Computes the point of parameter U on the curve.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,EonF : OCP.TopoDS.TopoDS_Edge,Edge : OCP.TopoDS.TopoDS_Edge) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class BiTgte_CurveOnVertex(OCP.Adaptor3d.Adaptor3d_Curve, OCP.Standard.Standard_Transient):
    """
    private class used to create a filler rolling on an edge.private class used to create a filler rolling on an edge.
    """
    def BSpline(self) -> OCP.Geom.Geom_BSplineCurve: ...
    def Bezier(self) -> OCP.Geom.Geom_BezierCurve: ...
    def Circle(self) -> OCP.gp.gp_Circ: ...
    def Continuity(self) -> OCP.GeomAbs.GeomAbs_Shape: ...
    def D0(self,U : float,P : OCP.gp.gp_Pnt) -> None: 
        """
        Computes the point of parameter U on the curve.
        """
    def D1(self,U : float,P : OCP.gp.gp_Pnt,V : OCP.gp.gp_Vec) -> None: 
        """
        Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.
        """
    def D2(self,U : float,P : OCP.gp.gp_Pnt,V1 : OCP.gp.gp_Vec,V2 : OCP.gp.gp_Vec) -> None: 
        """
        Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.
        """
    def D3(self,U : float,P : OCP.gp.gp_Pnt,V1 : OCP.gp.gp_Vec,V2 : OCP.gp.gp_Vec,V3 : OCP.gp.gp_Vec) -> None: 
        """
        Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.
        """
    def DN(self,U : float,N : int) -> OCP.gp.gp_Vec: 
        """
        The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Ellipse(self) -> OCP.gp.gp_Elips: ...
    def FirstParameter(self) -> float: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetType(self) -> OCP.GeomAbs.GeomAbs_CurveType: 
        """
        Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.
        """
    def Hyperbola(self) -> OCP.gp.gp_Hypr: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,EonF : OCP.TopoDS.TopoDS_Edge,V : OCP.TopoDS.TopoDS_Vertex) -> None: ...
    def Intervals(self,T : OCP.TColStd.TColStd_Array1OfReal,S : OCP.GeomAbs.GeomAbs_Shape) -> None: 
        """
        Stores in <T> the parameters bounding the intervals of continuity <S>.
        """
    def IsClosed(self) -> bool: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def IsPeriodic(self) -> bool: ...
    def IsRational(self) -> bool: ...
    def LastParameter(self) -> float: ...
    def Line(self) -> OCP.gp.gp_Lin: ...
    def NbIntervals(self,S : OCP.GeomAbs.GeomAbs_Shape) -> int: 
        """
        Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>
        """
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def OffsetCurve(self) -> OCP.Geom.Geom_OffsetCurve: ...
    def Parabola(self) -> OCP.gp.gp_Parab: ...
    def Period(self) -> float: ...
    def Resolution(self,R3d : float) -> float: 
        """
        Returns the parametric resolution corresponding to the real space resolution <R3d>.
        """
    def ShallowCopy(self) -> OCP.Adaptor3d.Adaptor3d_Curve: 
        """
        Shallow copy of adaptor
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Trim(self,First : float,Last : float,Tol : float) -> OCP.Adaptor3d.Adaptor3d_Curve: 
        """
        Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>
        """
    def Value(self,U : float) -> OCP.gp.gp_Pnt: 
        """
        Computes the point of parameter U on the curve.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,EonF : OCP.TopoDS.TopoDS_Edge,V : OCP.TopoDS.TopoDS_Vertex) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
BiTgte_EdgeEdge: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_EdgeEdge: 3>
BiTgte_EdgeVertex: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_EdgeVertex: 4>
BiTgte_FaceEdge: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_FaceEdge: 1>
BiTgte_FaceFace: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_FaceFace: 0>
BiTgte_FaceVertex: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_FaceVertex: 2>
BiTgte_VertexVertex: OCP.BiTgte.BiTgte_ContactType # value = <BiTgte_ContactType.BiTgte_VertexVertex: 5>
