import OCP.LProp
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.GeomAbs
import OCP.NCollection
__all__  = [
"LProp_AnalyticCurInf",
"LProp_BadContinuity",
"LProp_CIType",
"LProp_CurAndInf",
"LProp_NotDefined",
"LProp_SequenceOfCIType",
"LProp_Status",
"LProp_Computed",
"LProp_Defined",
"LProp_Inflection",
"LProp_MaxCur",
"LProp_MinCur",
"LProp_Undecided",
"LProp_Undefined"
]
class LProp_AnalyticCurInf():
    """
    Computes the locals extremas of curvature of a gp curve Remark : a gp curve has not inflection.
    """
    def Perform(self,T : OCP.GeomAbs.GeomAbs_CurveType,UFirst : float,ULast : float,Result : LProp_CurAndInf) -> None: ...
    def __init__(self) -> None: ...
    pass
class LProp_BadContinuity(Exception, BaseException):
    class type():
        pass
    __cause__: getset_descriptor # value = <attribute '__cause__' of 'BaseException' objects>
    __context__: getset_descriptor # value = <attribute '__context__' of 'BaseException' objects>
    __dict__: mappingproxy # value = mappingproxy({'__module__': 'OCP.LProp', '__weakref__': <attribute '__weakref__' of 'LProp_BadContinuity' objects>, '__doc__': None})
    __suppress_context__: member_descriptor # value = <member '__suppress_context__' of 'BaseException' objects>
    __traceback__: getset_descriptor # value = <attribute '__traceback__' of 'BaseException' objects>
    __weakref__: getset_descriptor # value = <attribute '__weakref__' of 'LProp_BadContinuity' objects>
    args: getset_descriptor # value = <attribute 'args' of 'BaseException' objects>
    pass
class LProp_CIType():
    """
    Identifies the type of a particular point on a curve: - LProp_Inflection: a point of inflection - LProp_MinCur: a minimum of curvature - LProp_MaxCur: a maximum of curvature.

    Members:

      LProp_Inflection

      LProp_MinCur

      LProp_MaxCur
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    LProp_Inflection: OCP.LProp.LProp_CIType # value = <LProp_CIType.LProp_Inflection: 0>
    LProp_MaxCur: OCP.LProp.LProp_CIType # value = <LProp_CIType.LProp_MaxCur: 2>
    LProp_MinCur: OCP.LProp.LProp_CIType # value = <LProp_CIType.LProp_MinCur: 1>
    __entries: dict # value = {'LProp_Inflection': (<LProp_CIType.LProp_Inflection: 0>, None), 'LProp_MinCur': (<LProp_CIType.LProp_MinCur: 1>, None), 'LProp_MaxCur': (<LProp_CIType.LProp_MaxCur: 2>, None)}
    __members__: dict # value = {'LProp_Inflection': <LProp_CIType.LProp_Inflection: 0>, 'LProp_MinCur': <LProp_CIType.LProp_MinCur: 1>, 'LProp_MaxCur': <LProp_CIType.LProp_MaxCur: 2>}
    pass
class LProp_CurAndInf():
    """
    Stores the parameters of a curve 2d or 3d corresponding to the curvature's extremas and the Inflection's Points.
    """
    def AddExtCur(self,Param : float,IsMin : bool) -> None: ...
    def AddInflection(self,Param : float) -> None: ...
    def Clear(self) -> None: ...
    def IsEmpty(self) -> bool: ...
    def NbPoints(self) -> int: 
        """
        Returns the number of points. The Points are stored to increasing parameter.
        """
    def Parameter(self,N : int) -> float: 
        """
        Returns the parameter of the Nth point. raises if N not in the range [1,NbPoints()]
        """
    def Type(self,N : int) -> LProp_CIType: 
        """
        Returns - MinCur if the Nth parameter corresponds to a minimum of the radius of curvature. - MaxCur if the Nth parameter corresponds to a maximum of the radius of curvature. - Inflection if the parameter corresponds to a point of inflection. raises if N not in the range [1,NbPoints()]
        """
    def __init__(self) -> None: ...
    pass
class LProp_NotDefined(Exception, BaseException):
    class type():
        pass
    __cause__: getset_descriptor # value = <attribute '__cause__' of 'BaseException' objects>
    __context__: getset_descriptor # value = <attribute '__context__' of 'BaseException' objects>
    __dict__: mappingproxy # value = mappingproxy({'__module__': 'OCP.LProp', '__weakref__': <attribute '__weakref__' of 'LProp_NotDefined' objects>, '__doc__': None})
    __suppress_context__: member_descriptor # value = <member '__suppress_context__' of 'BaseException' objects>
    __traceback__: getset_descriptor # value = <attribute '__traceback__' of 'BaseException' objects>
    __weakref__: getset_descriptor # value = <attribute '__weakref__' of 'LProp_NotDefined' objects>
    args: getset_descriptor # value = <attribute 'args' of 'BaseException' objects>
    pass
class LProp_SequenceOfCIType(OCP.NCollection.NCollection_BaseSequence):
    """
    Purpose: Definition of a sequence of elements indexed by an Integer in range of 1..n
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : LProp_CIType) -> None: 
        """
        Append one item

        Append another sequence (making it empty)
        """
    @overload
    def Append(self,theSeq : LProp_SequenceOfCIType) -> None: ...
    def Assign(self,theOther : LProp_SequenceOfCIType) -> LProp_SequenceOfCIType: 
        """
        Replace this sequence by the items of theOther. This method does not change the internal allocator.
        """
    def ChangeFirst(self) -> LProp_CIType: 
        """
        First item access
        """
    def ChangeLast(self) -> LProp_CIType: 
        """
        Last item access
        """
    def ChangeValue(self,theIndex : int) -> LProp_CIType: 
        """
        Variable item access by theIndex
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear the items out, take a new allocator if non null
        """
    def Exchange(self,I : int,J : int) -> None: 
        """
        Exchange two members
        """
    def First(self) -> LProp_CIType: 
        """
        First item access
        """
    @overload
    def InsertAfter(self,theIndex : int,theSeq : LProp_SequenceOfCIType) -> None: 
        """
        InsertAfter theIndex another sequence (making it empty)

        InsertAfter theIndex theItem
        """
    @overload
    def InsertAfter(self,theIndex : int,theItem : LProp_CIType) -> None: ...
    @overload
    def InsertBefore(self,theIndex : int,theItem : LProp_CIType) -> None: 
        """
        InsertBefore theIndex theItem

        InsertBefore theIndex another sequence (making it empty)
        """
    @overload
    def InsertBefore(self,theIndex : int,theSeq : LProp_SequenceOfCIType) -> None: ...
    def IsEmpty(self) -> bool: 
        """
        Empty query
        """
    def Last(self) -> LProp_CIType: 
        """
        Last item access
        """
    def Length(self) -> int: 
        """
        Number of items
        """
    def Lower(self) -> int: 
        """
        Method for consistency with other collections.
        """
    @overload
    def Prepend(self,theItem : LProp_CIType) -> None: 
        """
        Prepend one item

        Prepend another sequence (making it empty)
        """
    @overload
    def Prepend(self,theSeq : LProp_SequenceOfCIType) -> None: ...
    @overload
    def Remove(self,theIndex : int) -> None: 
        """
        Remove one item

        Remove range of items
        """
    @overload
    def Remove(self,theFromIndex : int,theToIndex : int) -> None: ...
    def Reverse(self) -> None: 
        """
        Reverse sequence
        """
    def SetValue(self,theIndex : int,theItem : LProp_CIType) -> None: 
        """
        Set item value by theIndex
        """
    def Size(self) -> int: 
        """
        Number of items
        """
    def Split(self,theIndex : int,theSeq : LProp_SequenceOfCIType) -> None: 
        """
        Split in two sequences
        """
    def Upper(self) -> int: 
        """
        Method for consistency with other collections.
        """
    def Value(self,theIndex : int) -> LProp_CIType: 
        """
        Constant item access by theIndex
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> LProp_CIType: 
        """
        Constant operator()

        Variable operator()
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : LProp_SequenceOfCIType) -> None: ...
    def __iter__(self) -> Iterator[LProp_CIType]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def delNode_s(theNode : NCollection_SeqNode,theAl : OCP.NCollection.NCollection_BaseAllocator) -> None: 
        """
        Static deleter to be passed to BaseSequence
        """
    pass
class LProp_Status():
    """
    Members:

      LProp_Undecided

      LProp_Undefined

      LProp_Defined

      LProp_Computed
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    LProp_Computed: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Computed: 3>
    LProp_Defined: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Defined: 2>
    LProp_Undecided: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Undecided: 0>
    LProp_Undefined: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Undefined: 1>
    __entries: dict # value = {'LProp_Undecided': (<LProp_Status.LProp_Undecided: 0>, None), 'LProp_Undefined': (<LProp_Status.LProp_Undefined: 1>, None), 'LProp_Defined': (<LProp_Status.LProp_Defined: 2>, None), 'LProp_Computed': (<LProp_Status.LProp_Computed: 3>, None)}
    __members__: dict # value = {'LProp_Undecided': <LProp_Status.LProp_Undecided: 0>, 'LProp_Undefined': <LProp_Status.LProp_Undefined: 1>, 'LProp_Defined': <LProp_Status.LProp_Defined: 2>, 'LProp_Computed': <LProp_Status.LProp_Computed: 3>}
    pass
LProp_Computed: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Computed: 3>
LProp_Defined: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Defined: 2>
LProp_Inflection: OCP.LProp.LProp_CIType # value = <LProp_CIType.LProp_Inflection: 0>
LProp_MaxCur: OCP.LProp.LProp_CIType # value = <LProp_CIType.LProp_MaxCur: 2>
LProp_MinCur: OCP.LProp.LProp_CIType # value = <LProp_CIType.LProp_MinCur: 1>
LProp_Undecided: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Undecided: 0>
LProp_Undefined: OCP.LProp.LProp_Status # value = <LProp_Status.LProp_Undefined: 1>
