import OCP.StepGeom
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TCollection
import OCP.StepData
import OCP.TColStd
import OCP.Standard
import OCP.Interface
import OCP.StepRepr
import OCP.StepBasic
__all__  = [
"StepGeom_Array1OfBoundaryCurve",
"StepGeom_Array1OfCartesianPoint",
"StepGeom_Array1OfCompositeCurveSegment",
"StepGeom_Array1OfCurve",
"StepGeom_Array1OfPcurveOrSurface",
"StepGeom_Array1OfSurfaceBoundary",
"StepGeom_Array1OfTrimmingSelect",
"StepGeom_Array2OfCartesianPoint",
"StepGeom_Array2OfSurfacePatch",
"StepGeom_GeometricRepresentationItem",
"StepGeom_Axis2Placement",
"StepGeom_Placement",
"StepGeom_Axis2Placement3d",
"StepGeom_Curve",
"StepGeom_BSplineCurveForm",
"StepGeom_BoundedCurve",
"StepGeom_BSplineCurve",
"StepGeom_Surface",
"StepGeom_BSplineSurfaceForm",
"StepGeom_BoundedSurface",
"StepGeom_BSplineSurface",
"StepGeom_BezierCurve",
"StepGeom_BezierCurveAndRationalBSplineCurve",
"StepGeom_BezierSurface",
"StepGeom_BezierSurfaceAndRationalBSplineSurface",
"StepGeom_CompositeCurve",
"StepGeom_BSplineCurveWithKnots",
"StepGeom_BSplineSurfaceWithKnots",
"StepGeom_Point",
"StepGeom_CartesianTransformationOperator",
"StepGeom_CartesianTransformationOperator2d",
"StepGeom_CartesianTransformationOperator3d",
"StepGeom_Conic",
"StepGeom_CompositeCurveOnSurface",
"StepGeom_BoundaryCurve",
"StepGeom_CompositeCurveSegment",
"StepGeom_Circle",
"StepGeom_ElementarySurface",
"StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve",
"StepGeom_CurveBoundedSurface",
"StepGeom_CurveOnSurface",
"StepGeom_CurveReplica",
"StepGeom_CylindricalSurface",
"StepGeom_DegeneratePcurve",
"StepGeom_ToroidalSurface",
"StepGeom_Direction",
"StepGeom_ConicalSurface",
"StepGeom_Ellipse",
"StepGeom_EvaluatedDegeneratePcurve",
"StepGeom_GeomRepContextAndGlobUnitAssCtxAndGlobUncertaintyAssCtx",
"StepGeom_GeometricRepresentationContext",
"StepGeom_GeometricRepresentationContextAndGlobalUnitAssignedContext",
"StepGeom_GeometricRepresentationContextAndParametricRepresentationContext",
"StepGeom_Axis1Placement",
"StepGeom_HArray1OfBoundaryCurve",
"StepGeom_HArray1OfCartesianPoint",
"StepGeom_HArray1OfCompositeCurveSegment",
"StepGeom_HArray1OfCurve",
"StepGeom_HArray1OfPcurveOrSurface",
"StepGeom_HArray1OfSurfaceBoundary",
"StepGeom_HArray1OfTrimmingSelect",
"StepGeom_HArray2OfCartesianPoint",
"StepGeom_HArray2OfSurfacePatch",
"StepGeom_Hyperbola",
"StepGeom_SurfaceCurve",
"StepGeom_KnotType",
"StepGeom_Line",
"StepGeom_OffsetCurve3d",
"StepGeom_OffsetSurface",
"StepGeom_OrientedSurface",
"StepGeom_OuterBoundaryCurve",
"StepGeom_Parabola",
"StepGeom_Pcurve",
"StepGeom_PcurveOrSurface",
"StepGeom_Axis2Placement2d",
"StepGeom_Plane",
"StepGeom_CartesianPoint",
"StepGeom_PointOnCurve",
"StepGeom_PointOnSurface",
"StepGeom_PointReplica",
"StepGeom_Polyline",
"StepGeom_PreferredSurfaceCurveRepresentation",
"StepGeom_QuasiUniformCurve",
"StepGeom_QuasiUniformCurveAndRationalBSplineCurve",
"StepGeom_QuasiUniformSurface",
"StepGeom_QuasiUniformSurfaceAndRationalBSplineSurface",
"StepGeom_RationalBSplineCurve",
"StepGeom_RationalBSplineSurface",
"StepGeom_RectangularCompositeSurface",
"StepGeom_RectangularTrimmedSurface",
"StepGeom_ReparametrisedCompositeCurveSegment",
"StepGeom_SeamCurve",
"StepGeom_SphericalSurface",
"StepGeom_SuParameters",
"StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface",
"StepGeom_SurfaceBoundary",
"StepGeom_IntersectionCurve",
"StepGeom_SurfaceCurveAndBoundedCurve",
"StepGeom_SweptSurface",
"StepGeom_SurfaceOfRevolution",
"StepGeom_SurfacePatch",
"StepGeom_SurfaceReplica",
"StepGeom_SurfaceOfLinearExtrusion",
"StepGeom_DegenerateToroidalSurface",
"StepGeom_TransitionCode",
"StepGeom_TrimmedCurve",
"StepGeom_TrimmingMember",
"StepGeom_TrimmingPreference",
"StepGeom_TrimmingSelect",
"StepGeom_UniformCurve",
"StepGeom_UniformCurveAndRationalBSplineCurve",
"StepGeom_UniformSurface",
"StepGeom_UniformSurfaceAndRationalBSplineSurface",
"StepGeom_Vector",
"StepGeom_VectorOrDirection",
"StepGeom_bscfCircularArc",
"StepGeom_bscfEllipticArc",
"StepGeom_bscfHyperbolicArc",
"StepGeom_bscfParabolicArc",
"StepGeom_bscfPolylineForm",
"StepGeom_bscfUnspecified",
"StepGeom_bssfConicalSurf",
"StepGeom_bssfCylindricalSurf",
"StepGeom_bssfGeneralisedCone",
"StepGeom_bssfPlaneSurf",
"StepGeom_bssfQuadricSurf",
"StepGeom_bssfRuledSurf",
"StepGeom_bssfSphericalSurf",
"StepGeom_bssfSurfOfLinearExtrusion",
"StepGeom_bssfSurfOfRevolution",
"StepGeom_bssfToroidalSurf",
"StepGeom_bssfUnspecified",
"StepGeom_ktPiecewiseBezierKnots",
"StepGeom_ktQuasiUniformKnots",
"StepGeom_ktUniformKnots",
"StepGeom_ktUnspecified",
"StepGeom_pscrCurve3d",
"StepGeom_pscrPcurveS1",
"StepGeom_pscrPcurveS2",
"StepGeom_tcContSameGradient",
"StepGeom_tcContSameGradientSameCurvature",
"StepGeom_tcContinuous",
"StepGeom_tcDiscontinuous",
"StepGeom_tpCartesian",
"StepGeom_tpParameter",
"StepGeom_tpUnspecified"
]
class StepGeom_Array1OfBoundaryCurve():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepGeom_Array1OfBoundaryCurve) -> StepGeom_Array1OfBoundaryCurve: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> StepGeom_BoundaryCurve: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_BoundaryCurve: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_BoundaryCurve: 
        """
        Variable value access
        """
    def First(self) -> StepGeom_BoundaryCurve: 
        """
        Returns first element
        """
    def Init(self,theValue : StepGeom_BoundaryCurve) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> StepGeom_BoundaryCurve: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfBoundaryCurve) -> StepGeom_Array1OfBoundaryCurve: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_BoundaryCurve) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_BoundaryCurve: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_BoundaryCurve: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfBoundaryCurve) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_BoundaryCurve]: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array1OfCartesianPoint():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepGeom_Array1OfCartesianPoint) -> StepGeom_Array1OfCartesianPoint: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> StepGeom_CartesianPoint: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_CartesianPoint: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_CartesianPoint: 
        """
        Variable value access
        """
    def First(self) -> StepGeom_CartesianPoint: 
        """
        Returns first element
        """
    def Init(self,theValue : StepGeom_CartesianPoint) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> StepGeom_CartesianPoint: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfCartesianPoint) -> StepGeom_Array1OfCartesianPoint: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_CartesianPoint) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_CartesianPoint: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_CartesianPoint: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfCartesianPoint) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_CartesianPoint]: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array1OfCompositeCurveSegment():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepGeom_Array1OfCompositeCurveSegment) -> StepGeom_Array1OfCompositeCurveSegment: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_CompositeCurveSegment: 
        """
        Variable value access
        """
    def First(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns first element
        """
    def Init(self,theValue : StepGeom_CompositeCurveSegment) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfCompositeCurveSegment) -> StepGeom_Array1OfCompositeCurveSegment: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_CompositeCurveSegment) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_CompositeCurveSegment: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_CompositeCurveSegment: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfCompositeCurveSegment) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_CompositeCurveSegment]: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array1OfCurve():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepGeom_Array1OfCurve) -> StepGeom_Array1OfCurve: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> StepGeom_Curve: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_Curve: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_Curve: 
        """
        Variable value access
        """
    def First(self) -> StepGeom_Curve: 
        """
        Returns first element
        """
    def Init(self,theValue : StepGeom_Curve) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> StepGeom_Curve: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfCurve) -> StepGeom_Array1OfCurve: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_Curve) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_Curve: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_Curve: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfCurve) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_Curve]: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array1OfPcurveOrSurface():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepGeom_Array1OfPcurveOrSurface) -> StepGeom_Array1OfPcurveOrSurface: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_PcurveOrSurface: 
        """
        Variable value access
        """
    def First(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns first element
        """
    def Init(self,theValue : StepGeom_PcurveOrSurface) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfPcurveOrSurface) -> StepGeom_Array1OfPcurveOrSurface: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_PcurveOrSurface) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_PcurveOrSurface: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_PcurveOrSurface: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfPcurveOrSurface) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_PcurveOrSurface]: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array1OfSurfaceBoundary():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepGeom_Array1OfSurfaceBoundary) -> StepGeom_Array1OfSurfaceBoundary: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_SurfaceBoundary: 
        """
        Variable value access
        """
    def First(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns first element
        """
    def Init(self,theValue : StepGeom_SurfaceBoundary) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfSurfaceBoundary) -> StepGeom_Array1OfSurfaceBoundary: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_SurfaceBoundary) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_SurfaceBoundary: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_SurfaceBoundary: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfSurfaceBoundary) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_SurfaceBoundary]: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array1OfTrimmingSelect():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : StepGeom_Array1OfTrimmingSelect) -> StepGeom_Array1OfTrimmingSelect: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeFirst(self) -> StepGeom_TrimmingSelect: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_TrimmingSelect: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_TrimmingSelect: 
        """
        Variable value access
        """
    def First(self) -> StepGeom_TrimmingSelect: 
        """
        Returns first element
        """
    def Init(self,theValue : StepGeom_TrimmingSelect) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Last(self) -> StepGeom_TrimmingSelect: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfTrimmingSelect) -> StepGeom_Array1OfTrimmingSelect: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_TrimmingSelect) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_TrimmingSelect: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_TrimmingSelect: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfTrimmingSelect) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_TrimmingSelect]: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array2OfCartesianPoint():
    """
    Purpose: The class Array2 represents bi-dimensional arrays of fixed size known at run time. The ranges of indices are user defined.
    """
    def Assign(self,theOther : StepGeom_Array2OfCartesianPoint) -> StepGeom_Array2OfCartesianPoint: 
        """
        Assignment
        """
    @staticmethod
    def BeginPosition_s(theRowLower : int,arg1 : int,theColLower : int,theColUpper : int) -> int: ...
    def ChangeValue(self,theRow : int,theCol : int) -> StepGeom_CartesianPoint: 
        """
        Variable value access
        """
    def ColLength(self) -> int: 
        """
        Returns length of the column, i.e. number of rows
        """
    @staticmethod
    def LastPosition_s(theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> int: ...
    def Length(self) -> int: ...
    def LowerCol(self) -> int: 
        """
        LowerCol
        """
    def LowerRow(self) -> int: 
        """
        LowerRow
        """
    def Move(self,theOther : StepGeom_Array2OfCartesianPoint) -> StepGeom_Array2OfCartesianPoint: 
        """
        Move assignment. This array will borrow all the data from theOther. The moved object will be left uninitialized and should not be used anymore.
        """
    def NbColumns(self) -> int: 
        """
        Returns number of columns
        """
    def NbRows(self) -> int: 
        """
        Returns number of rows
        """
    def Resize(self,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def RowLength(self) -> int: 
        """
        Returns length of the row, i.e. number of columns
        """
    def SetValue(self,theRow : int,theCol : int,theItem : StepGeom_CartesianPoint) -> None: 
        """
        SetValue
        """
    def Size(self) -> int: ...
    def UpperCol(self) -> int: 
        """
        UpperCol
        """
    def UpperRow(self) -> int: 
        """
        UpperRow
        """
    def Value(self,theRow : int,theCol : int) -> StepGeom_CartesianPoint: 
        """
        Constant value access
        """
    def __call__(self,theRow : int,theCol : int) -> StepGeom_CartesianPoint: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array2OfCartesianPoint) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_CartesianPoint,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> None: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_Array2OfSurfacePatch():
    """
    Purpose: The class Array2 represents bi-dimensional arrays of fixed size known at run time. The ranges of indices are user defined.
    """
    def Assign(self,theOther : StepGeom_Array2OfSurfacePatch) -> StepGeom_Array2OfSurfacePatch: 
        """
        Assignment
        """
    @staticmethod
    def BeginPosition_s(theRowLower : int,arg1 : int,theColLower : int,theColUpper : int) -> int: ...
    def ChangeValue(self,theRow : int,theCol : int) -> StepGeom_SurfacePatch: 
        """
        Variable value access
        """
    def ColLength(self) -> int: 
        """
        Returns length of the column, i.e. number of rows
        """
    @staticmethod
    def LastPosition_s(theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> int: ...
    def Length(self) -> int: ...
    def LowerCol(self) -> int: 
        """
        LowerCol
        """
    def LowerRow(self) -> int: 
        """
        LowerRow
        """
    def Move(self,theOther : StepGeom_Array2OfSurfacePatch) -> StepGeom_Array2OfSurfacePatch: 
        """
        Move assignment. This array will borrow all the data from theOther. The moved object will be left uninitialized and should not be used anymore.
        """
    def NbColumns(self) -> int: 
        """
        Returns number of columns
        """
    def NbRows(self) -> int: 
        """
        Returns number of rows
        """
    def Resize(self,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def RowLength(self) -> int: 
        """
        Returns length of the row, i.e. number of columns
        """
    def SetValue(self,theRow : int,theCol : int,theItem : StepGeom_SurfacePatch) -> None: 
        """
        SetValue
        """
    def Size(self) -> int: ...
    def UpperCol(self) -> int: 
        """
        UpperCol
        """
    def UpperRow(self) -> int: 
        """
        UpperRow
        """
    def Value(self,theRow : int,theCol : int) -> StepGeom_SurfacePatch: 
        """
        Constant value access
        """
    def __call__(self,theRow : int,theCol : int) -> StepGeom_SurfacePatch: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> None: ...
    @overload
    def __init__(self,theAlloc : Any,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array2OfSurfacePatch) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_SurfacePatch,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> None: ...
    def __len__(self) -> int: ...
    pass
class StepGeom_GeometricRepresentationItem(OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Axis2Placement(OCP.StepData.StepData_SelectType):
    def Axis2Placement2d(self) -> StepGeom_Axis2Placement2d: 
        """
        returns Value as a Axis2Placement2d (Null if another type)
        """
    def Axis2Placement3d(self) -> StepGeom_Axis2Placement3d: 
        """
        returns Value as a Axis2Placement3d (Null if another type)
        """
    def Boolean(self) -> bool: ...
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a Axis2Placement Kind Entity that is : 1 -> Axis2Placement2d 2 -> Axis2Placement3d 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: ...
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def Real(self) -> float: ...
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: ...
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: ...
    def SetReal(self,val : float,name : str='') -> None: ...
    @overload
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.

        SetValue supporting python objects
        """
    @overload
    def SetValue(self,ent : object) -> None: ...
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepGeom_Placement(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aLocation : StepGeom_CartesianPoint) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Location(self) -> StepGeom_CartesianPoint: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetLocation(self,aLocation : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Axis2Placement3d(StepGeom_Placement, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def Axis(self) -> StepGeom_Direction: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasAxis(self) -> bool: ...
    def HasRefDirection(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aLocation : StepGeom_CartesianPoint,hasAaxis : bool,aAxis : StepGeom_Direction,hasArefDirection : bool,aRefDirection : StepGeom_Direction) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Location(self) -> StepGeom_CartesianPoint: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def RefDirection(self) -> StepGeom_Direction: ...
    def SetAxis(self,aAxis : StepGeom_Direction) -> None: ...
    def SetLocation(self,aLocation : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRefDirection(self,aRefDirection : StepGeom_Direction) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnSetAxis(self) -> None: ...
    def UnSetRefDirection(self) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Curve(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineCurveForm():
    """
    Members:

      StepGeom_bscfPolylineForm

      StepGeom_bscfCircularArc

      StepGeom_bscfEllipticArc

      StepGeom_bscfParabolicArc

      StepGeom_bscfHyperbolicArc

      StepGeom_bscfUnspecified
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    StepGeom_bscfCircularArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfCircularArc: 1>
    StepGeom_bscfEllipticArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfEllipticArc: 2>
    StepGeom_bscfHyperbolicArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfHyperbolicArc: 4>
    StepGeom_bscfParabolicArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfParabolicArc: 3>
    StepGeom_bscfPolylineForm: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfPolylineForm: 0>
    StepGeom_bscfUnspecified: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfUnspecified: 5>
    __entries: dict # value = {'StepGeom_bscfPolylineForm': (<StepGeom_BSplineCurveForm.StepGeom_bscfPolylineForm: 0>, None), 'StepGeom_bscfCircularArc': (<StepGeom_BSplineCurveForm.StepGeom_bscfCircularArc: 1>, None), 'StepGeom_bscfEllipticArc': (<StepGeom_BSplineCurveForm.StepGeom_bscfEllipticArc: 2>, None), 'StepGeom_bscfParabolicArc': (<StepGeom_BSplineCurveForm.StepGeom_bscfParabolicArc: 3>, None), 'StepGeom_bscfHyperbolicArc': (<StepGeom_BSplineCurveForm.StepGeom_bscfHyperbolicArc: 4>, None), 'StepGeom_bscfUnspecified': (<StepGeom_BSplineCurveForm.StepGeom_bscfUnspecified: 5>, None)}
    __members__: dict # value = {'StepGeom_bscfPolylineForm': <StepGeom_BSplineCurveForm.StepGeom_bscfPolylineForm: 0>, 'StepGeom_bscfCircularArc': <StepGeom_BSplineCurveForm.StepGeom_bscfCircularArc: 1>, 'StepGeom_bscfEllipticArc': <StepGeom_BSplineCurveForm.StepGeom_bscfEllipticArc: 2>, 'StepGeom_bscfParabolicArc': <StepGeom_BSplineCurveForm.StepGeom_bscfParabolicArc: 3>, 'StepGeom_bscfHyperbolicArc': <StepGeom_BSplineCurveForm.StepGeom_bscfHyperbolicArc: 4>, 'StepGeom_bscfUnspecified': <StepGeom_BSplineCurveForm.StepGeom_bscfUnspecified: 5>}
    pass
class StepGeom_BoundedCurve(StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineCurve(StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Surface(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineSurfaceForm():
    """
    Members:

      StepGeom_bssfPlaneSurf

      StepGeom_bssfCylindricalSurf

      StepGeom_bssfConicalSurf

      StepGeom_bssfSphericalSurf

      StepGeom_bssfToroidalSurf

      StepGeom_bssfSurfOfRevolution

      StepGeom_bssfRuledSurf

      StepGeom_bssfGeneralisedCone

      StepGeom_bssfQuadricSurf

      StepGeom_bssfSurfOfLinearExtrusion

      StepGeom_bssfUnspecified
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    StepGeom_bssfConicalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfConicalSurf: 2>
    StepGeom_bssfCylindricalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfCylindricalSurf: 1>
    StepGeom_bssfGeneralisedCone: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfGeneralisedCone: 7>
    StepGeom_bssfPlaneSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfPlaneSurf: 0>
    StepGeom_bssfQuadricSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfQuadricSurf: 8>
    StepGeom_bssfRuledSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfRuledSurf: 6>
    StepGeom_bssfSphericalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfSphericalSurf: 3>
    StepGeom_bssfSurfOfLinearExtrusion: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfLinearExtrusion: 9>
    StepGeom_bssfSurfOfRevolution: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfRevolution: 5>
    StepGeom_bssfToroidalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfToroidalSurf: 4>
    StepGeom_bssfUnspecified: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfUnspecified: 10>
    __entries: dict # value = {'StepGeom_bssfPlaneSurf': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfPlaneSurf: 0>, None), 'StepGeom_bssfCylindricalSurf': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfCylindricalSurf: 1>, None), 'StepGeom_bssfConicalSurf': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfConicalSurf: 2>, None), 'StepGeom_bssfSphericalSurf': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfSphericalSurf: 3>, None), 'StepGeom_bssfToroidalSurf': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfToroidalSurf: 4>, None), 'StepGeom_bssfSurfOfRevolution': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfRevolution: 5>, None), 'StepGeom_bssfRuledSurf': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfRuledSurf: 6>, None), 'StepGeom_bssfGeneralisedCone': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfGeneralisedCone: 7>, None), 'StepGeom_bssfQuadricSurf': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfQuadricSurf: 8>, None), 'StepGeom_bssfSurfOfLinearExtrusion': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfLinearExtrusion: 9>, None), 'StepGeom_bssfUnspecified': (<StepGeom_BSplineSurfaceForm.StepGeom_bssfUnspecified: 10>, None)}
    __members__: dict # value = {'StepGeom_bssfPlaneSurf': <StepGeom_BSplineSurfaceForm.StepGeom_bssfPlaneSurf: 0>, 'StepGeom_bssfCylindricalSurf': <StepGeom_BSplineSurfaceForm.StepGeom_bssfCylindricalSurf: 1>, 'StepGeom_bssfConicalSurf': <StepGeom_BSplineSurfaceForm.StepGeom_bssfConicalSurf: 2>, 'StepGeom_bssfSphericalSurf': <StepGeom_BSplineSurfaceForm.StepGeom_bssfSphericalSurf: 3>, 'StepGeom_bssfToroidalSurf': <StepGeom_BSplineSurfaceForm.StepGeom_bssfToroidalSurf: 4>, 'StepGeom_bssfSurfOfRevolution': <StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfRevolution: 5>, 'StepGeom_bssfRuledSurf': <StepGeom_BSplineSurfaceForm.StepGeom_bssfRuledSurf: 6>, 'StepGeom_bssfGeneralisedCone': <StepGeom_BSplineSurfaceForm.StepGeom_bssfGeneralisedCone: 7>, 'StepGeom_bssfQuadricSurf': <StepGeom_BSplineSurfaceForm.StepGeom_bssfQuadricSurf: 8>, 'StepGeom_bssfSurfOfLinearExtrusion': <StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfLinearExtrusion: 9>, 'StepGeom_bssfUnspecified': <StepGeom_BSplineSurfaceForm.StepGeom_bssfUnspecified: 10>}
    pass
class StepGeom_BoundedSurface(StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineSurface(StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BezierCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BezierCurveAndRationalBSplineCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BezierCurve(self) -> StepGeom_BezierCurve: ...
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aBezierCurve : StepGeom_BezierCurve,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def NbWeightsData(self) -> int: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetBezierCurve(self,aBezierCurve : StepGeom_BezierCurve) -> None: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRationalBSplineCurve(self,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def WeightsDataValue(self,num : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BezierSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BezierSurfaceAndRationalBSplineSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BezierSurface(self) -> StepGeom_BezierSurface: ...
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aBezierSurface : StepGeom_BezierSurface,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetBezierSurface(self,aBezierSurface : StepGeom_BezierSurface) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRationalBSplineSurface(self,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray2OfReal: ...
    def WeightsDataValue(self,num1 : int,num2 : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CompositeCurve(StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSegments : StepGeom_HArray1OfCompositeCurveSegment,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbSegments(self) -> int: ...
    def Segments(self) -> StepGeom_HArray1OfCompositeCurveSegment: ...
    def SegmentsValue(self,num : int) -> StepGeom_CompositeCurveSegment: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSegments(self,aSegments : StepGeom_HArray1OfCompositeCurveSegment) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineCurveWithKnots(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aKnotMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger,aKnots : OCP.TColStd.TColStd_HArray1OfReal,aKnotSpec : StepGeom_KnotType) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def KnotMultiplicities(self) -> OCP.TColStd.TColStd_HArray1OfInteger: ...
    def KnotMultiplicitiesValue(self,num : int) -> int: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def Knots(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def KnotsValue(self,num : int) -> float: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def NbKnotMultiplicities(self) -> int: ...
    def NbKnots(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetKnotMultiplicities(self,aKnotMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger) -> None: ...
    def SetKnotSpec(self,aKnotSpec : StepGeom_KnotType) -> None: ...
    def SetKnots(self,aKnots : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineSurfaceWithKnots(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aUMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger,aVMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger,aUKnots : OCP.TColStd.TColStd_HArray1OfReal,aVKnots : OCP.TColStd.TColStd_HArray1OfReal,aKnotSpec : StepGeom_KnotType) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def NbUKnots(self) -> int: ...
    def NbUMultiplicities(self) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVMultiplicities(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetKnotSpec(self,aKnotSpec : StepGeom_KnotType) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetUKnots(self,aUKnots : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetUMultiplicities(self,aUMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SetVKnots(self,aVKnots : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetVMultiplicities(self,aVMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def UKnots(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def UKnotsValue(self,num : int) -> float: ...
    def UMultiplicities(self) -> OCP.TColStd.TColStd_HArray1OfInteger: ...
    def UMultiplicitiesValue(self,num : int) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def VKnots(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def VKnotsValue(self,num : int) -> float: ...
    def VMultiplicities(self) -> OCP.TColStd.TColStd_HArray1OfInteger: ...
    def VMultiplicitiesValue(self,num : int) -> int: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Point(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CartesianTransformationOperator(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def Axis1(self) -> StepGeom_Direction: ...
    def Axis2(self) -> StepGeom_Direction: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasAxis1(self) -> bool: ...
    def HasAxis2(self) -> bool: ...
    def HasScale(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,hasAaxis1 : bool,aAxis1 : StepGeom_Direction,hasAaxis2 : bool,aAxis2 : StepGeom_Direction,aLocalOrigin : StepGeom_CartesianPoint,hasAscale : bool,aScale : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def LocalOrigin(self) -> StepGeom_CartesianPoint: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Scale(self) -> float: ...
    def SetAxis1(self,aAxis1 : StepGeom_Direction) -> None: ...
    def SetAxis2(self,aAxis2 : StepGeom_Direction) -> None: ...
    def SetLocalOrigin(self,aLocalOrigin : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetScale(self,aScale : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnSetAxis1(self) -> None: ...
    def UnSetAxis2(self) -> None: ...
    def UnSetScale(self) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CartesianTransformationOperator2d(StepGeom_CartesianTransformationOperator, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    """
    Added from StepGeom Rev2 to Rev4Added from StepGeom Rev2 to Rev4Added from StepGeom Rev2 to Rev4
    """
    def Axis1(self) -> StepGeom_Direction: ...
    def Axis2(self) -> StepGeom_Direction: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasAxis1(self) -> bool: ...
    def HasAxis2(self) -> bool: ...
    def HasScale(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,hasAaxis1 : bool,aAxis1 : StepGeom_Direction,hasAaxis2 : bool,aAxis2 : StepGeom_Direction,aLocalOrigin : StepGeom_CartesianPoint,hasAscale : bool,aScale : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def LocalOrigin(self) -> StepGeom_CartesianPoint: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Scale(self) -> float: ...
    def SetAxis1(self,aAxis1 : StepGeom_Direction) -> None: ...
    def SetAxis2(self,aAxis2 : StepGeom_Direction) -> None: ...
    def SetLocalOrigin(self,aLocalOrigin : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetScale(self,aScale : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnSetAxis1(self) -> None: ...
    def UnSetAxis2(self) -> None: ...
    def UnSetScale(self) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CartesianTransformationOperator3d(StepGeom_CartesianTransformationOperator, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def Axis1(self) -> StepGeom_Direction: ...
    def Axis2(self) -> StepGeom_Direction: ...
    def Axis3(self) -> StepGeom_Direction: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasAxis1(self) -> bool: ...
    def HasAxis2(self) -> bool: ...
    def HasAxis3(self) -> bool: ...
    def HasScale(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,hasAaxis1 : bool,aAxis1 : StepGeom_Direction,hasAaxis2 : bool,aAxis2 : StepGeom_Direction,aLocalOrigin : StepGeom_CartesianPoint,hasAscale : bool,aScale : float,hasAaxis3 : bool,aAxis3 : StepGeom_Direction) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def LocalOrigin(self) -> StepGeom_CartesianPoint: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Scale(self) -> float: ...
    def SetAxis1(self,aAxis1 : StepGeom_Direction) -> None: ...
    def SetAxis2(self,aAxis2 : StepGeom_Direction) -> None: ...
    def SetAxis3(self,aAxis3 : StepGeom_Direction) -> None: ...
    def SetLocalOrigin(self,aLocalOrigin : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetScale(self,aScale : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnSetAxis1(self) -> None: ...
    def UnSetAxis2(self) -> None: ...
    def UnSetAxis3(self) -> None: ...
    def UnSetScale(self) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Conic(StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CompositeCurveOnSurface(StepGeom_CompositeCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSegments : StepGeom_HArray1OfCompositeCurveSegment,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbSegments(self) -> int: ...
    def Segments(self) -> StepGeom_HArray1OfCompositeCurveSegment: ...
    def SegmentsValue(self,num : int) -> StepGeom_CompositeCurveSegment: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSegments(self,aSegments : StepGeom_HArray1OfCompositeCurveSegment) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BoundaryCurve(StepGeom_CompositeCurveOnSurface, StepGeom_CompositeCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSegments : StepGeom_HArray1OfCompositeCurveSegment,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbSegments(self) -> int: ...
    def Segments(self) -> StepGeom_HArray1OfCompositeCurveSegment: ...
    def SegmentsValue(self,num : int) -> StepGeom_CompositeCurveSegment: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSegments(self,aSegments : StepGeom_HArray1OfCompositeCurveSegment) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CompositeCurveSegment(OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aTransition : StepGeom_TransitionCode,aSameSense : bool,aParentCurve : StepGeom_Curve) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def ParentCurve(self) -> StepGeom_Curve: ...
    def SameSense(self) -> bool: ...
    def SetParentCurve(self,aParentCurve : StepGeom_Curve) -> None: ...
    def SetSameSense(self,aSameSense : bool) -> None: ...
    def SetTransition(self,aTransition : StepGeom_TransitionCode) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Transition(self) -> StepGeom_TransitionCode: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Circle(StepGeom_Conic, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement,aRadius : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement: ...
    def Radius(self) -> float: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement) -> None: ...
    def SetRadius(self,aRadius : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_ElementarySurface(StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BSplineCurveWithKnots(self) -> StepGeom_BSplineCurveWithKnots: ...
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aBSplineCurveWithKnots : StepGeom_BSplineCurveWithKnots,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aKnotMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger,aKnots : OCP.TColStd.TColStd_HArray1OfReal,aKnotSpec : StepGeom_KnotType,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def KnotMultiplicities(self) -> OCP.TColStd.TColStd_HArray1OfInteger: ...
    def KnotMultiplicitiesValue(self,num : int) -> int: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def Knots(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def KnotsValue(self,num : int) -> float: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def NbKnotMultiplicities(self) -> int: ...
    def NbKnots(self) -> int: ...
    def NbWeightsData(self) -> int: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetBSplineCurveWithKnots(self,aBSplineCurveWithKnots : StepGeom_BSplineCurveWithKnots) -> None: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetKnotMultiplicities(self,aKnotMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger) -> None: ...
    def SetKnotSpec(self,aKnotSpec : StepGeom_KnotType) -> None: ...
    def SetKnots(self,aKnots : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRationalBSplineCurve(self,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def WeightsDataValue(self,num : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CurveBoundedSurface(StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity CurveBoundedSurfaceRepresentation of STEP entity CurveBoundedSurfaceRepresentation of STEP entity CurveBoundedSurface
    """
    def BasisSurface(self) -> StepGeom_Surface: 
        """
        Returns field BasisSurface
        """
    def Boundaries(self) -> StepGeom_HArray1OfSurfaceBoundary: 
        """
        Returns field Boundaries
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def ImplicitOuter(self) -> bool: 
        """
        Returns field ImplicitOuter
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aRepresentationItem_Name : OCP.TCollection.TCollection_HAsciiString,aBasisSurface : StepGeom_Surface,aBoundaries : StepGeom_HArray1OfSurfaceBoundary,aImplicitOuter : bool) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetBasisSurface(self,BasisSurface : StepGeom_Surface) -> None: 
        """
        Set field BasisSurface
        """
    def SetBoundaries(self,Boundaries : StepGeom_HArray1OfSurfaceBoundary) -> None: 
        """
        Set field Boundaries
        """
    def SetImplicitOuter(self,ImplicitOuter : bool) -> None: 
        """
        Set field ImplicitOuter
        """
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CurveOnSurface(OCP.StepData.StepData_SelectType):
    def Boolean(self) -> bool: ...
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a CurveOnSurface Kind Entity that is : 1 -> Pcurve 2 -> SurfaceCurve 3 -> CompositeCurveOnSurface 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def CompositeCurveOnSurface(self) -> StepGeom_CompositeCurveOnSurface: 
        """
        returns Value as a CompositeCurveOnSurface (Null if another type)
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: ...
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def Pcurve(self) -> StepGeom_Pcurve: 
        """
        returns Value as a Pcurve (Null if another type)
        """
    def Real(self) -> float: ...
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: ...
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: ...
    def SetReal(self,val : float,name : str='') -> None: ...
    @overload
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.

        SetValue supporting python objects
        """
    @overload
    def SetValue(self,ent : object) -> None: ...
    def SurfaceCurve(self) -> StepGeom_SurfaceCurve: 
        """
        returns Value as a SurfaceCurve (Null if another type)
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepGeom_CurveReplica(StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aParentCurve : StepGeom_Curve,aTransformation : StepGeom_CartesianTransformationOperator) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ParentCurve(self) -> StepGeom_Curve: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetParentCurve(self,aParentCurve : StepGeom_Curve) -> None: ...
    def SetTransformation(self,aTransformation : StepGeom_CartesianTransformationOperator) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Transformation(self) -> StepGeom_CartesianTransformationOperator: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CylindricalSurface(StepGeom_ElementarySurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement3d,aRadius : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def Radius(self) -> float: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    def SetRadius(self,aRadius : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_DegeneratePcurve(StepGeom_Point, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisSurface(self) -> StepGeom_Surface: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisSurface : StepGeom_Surface,aReferenceToCurve : OCP.StepRepr.StepRepr_DefinitionalRepresentation) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ReferenceToCurve(self) -> OCP.StepRepr.StepRepr_DefinitionalRepresentation: ...
    def SetBasisSurface(self,aBasisSurface : StepGeom_Surface) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetReferenceToCurve(self,aReferenceToCurve : OCP.StepRepr.StepRepr_DefinitionalRepresentation) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_ToroidalSurface(StepGeom_ElementarySurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement3d,aMajorRadius : float,aMinorRadius : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def SetMajorRadius(self,aMajorRadius : float) -> None: ...
    def SetMinorRadius(self,aMinorRadius : float) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Direction(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DirectionRatios(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def DirectionRatiosValue(self,num : int) -> float: ...
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDirectionRatios : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbDirectionRatios(self) -> int: ...
    def SetDirectionRatios(self,aDirectionRatios : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_ConicalSurface(StepGeom_ElementarySurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement3d,aRadius : float,aSemiAngle : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def Radius(self) -> float: ...
    def SemiAngle(self) -> float: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    def SetRadius(self,aRadius : float) -> None: ...
    def SetSemiAngle(self,aSemiAngle : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Ellipse(StepGeom_Conic, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement,aSemiAxis1 : float,aSemiAxis2 : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement: ...
    def SemiAxis1(self) -> float: ...
    def SemiAxis2(self) -> float: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement) -> None: ...
    def SetSemiAxis1(self,aSemiAxis1 : float) -> None: ...
    def SetSemiAxis2(self,aSemiAxis2 : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_EvaluatedDegeneratePcurve(StepGeom_DegeneratePcurve, StepGeom_Point, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisSurface(self) -> StepGeom_Surface: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EquivalentPoint(self) -> StepGeom_CartesianPoint: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisSurface : StepGeom_Surface,aReferenceToCurve : OCP.StepRepr.StepRepr_DefinitionalRepresentation,aEquivalentPoint : StepGeom_CartesianPoint) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ReferenceToCurve(self) -> OCP.StepRepr.StepRepr_DefinitionalRepresentation: ...
    def SetBasisSurface(self,aBasisSurface : StepGeom_Surface) -> None: ...
    def SetEquivalentPoint(self,aEquivalentPoint : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetReferenceToCurve(self,aReferenceToCurve : OCP.StepRepr.StepRepr_DefinitionalRepresentation) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_GeomRepContextAndGlobUnitAssCtxAndGlobUncertaintyAssCtx(OCP.StepRepr.StepRepr_RepresentationContext, OCP.Standard.Standard_Transient):
    def ContextIdentifier(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ContextType(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GeometricRepresentationContext(self) -> StepGeom_GeometricRepresentationContext: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GlobalUncertaintyAssignedContext(self) -> OCP.StepRepr.StepRepr_GlobalUncertaintyAssignedContext: ...
    def GlobalUnitAssignedContext(self) -> OCP.StepRepr.StepRepr_GlobalUnitAssignedContext: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString,aContextType : OCP.TCollection.TCollection_HAsciiString,aGeometricRepresentationCtx : StepGeom_GeometricRepresentationContext,aGlobalUnitAssignedCtx : OCP.StepRepr.StepRepr_GlobalUnitAssignedContext,aGlobalUncertaintyAssignedCtx : OCP.StepRepr.StepRepr_GlobalUncertaintyAssignedContext) -> None: ...
    @overload
    def Init(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString,aContextType : OCP.TCollection.TCollection_HAsciiString,aCoordinateSpaceDimension : int,aUnits : OCP.StepBasic.StepBasic_HArray1OfNamedUnit,anUncertainty : OCP.StepBasic.StepBasic_HArray1OfUncertaintyMeasureWithUnit) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def NbUncertainty(self) -> int: ...
    def NbUnits(self) -> int: ...
    def SetContextIdentifier(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetContextType(self,aContextType : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetCoordinateSpaceDimension(self,aCoordinateSpaceDimension : int) -> None: ...
    def SetGeometricRepresentationContext(self,aGeometricRepresentationContext : StepGeom_GeometricRepresentationContext) -> None: ...
    def SetGlobalUncertaintyAssignedContext(self,aGlobalUncertaintyAssignedCtx : OCP.StepRepr.StepRepr_GlobalUncertaintyAssignedContext) -> None: ...
    def SetGlobalUnitAssignedContext(self,aGlobalUnitAssignedContext : OCP.StepRepr.StepRepr_GlobalUnitAssignedContext) -> None: ...
    def SetUncertainty(self,aUncertainty : OCP.StepBasic.StepBasic_HArray1OfUncertaintyMeasureWithUnit) -> None: ...
    def SetUnits(self,aUnits : OCP.StepBasic.StepBasic_HArray1OfNamedUnit) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Uncertainty(self) -> OCP.StepBasic.StepBasic_HArray1OfUncertaintyMeasureWithUnit: ...
    def UncertaintyValue(self,num : int) -> OCP.StepBasic.StepBasic_UncertaintyMeasureWithUnit: ...
    def Units(self) -> OCP.StepBasic.StepBasic_HArray1OfNamedUnit: ...
    def UnitsValue(self,num : int) -> OCP.StepBasic.StepBasic_NamedUnit: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_GeometricRepresentationContext(OCP.StepRepr.StepRepr_RepresentationContext, OCP.Standard.Standard_Transient):
    def ContextIdentifier(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ContextType(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString,aContextType : OCP.TCollection.TCollection_HAsciiString,aCoordinateSpaceDimension : int) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def SetContextIdentifier(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetContextType(self,aContextType : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetCoordinateSpaceDimension(self,aCoordinateSpaceDimension : int) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_GeometricRepresentationContextAndGlobalUnitAssignedContext(OCP.StepRepr.StepRepr_RepresentationContext, OCP.Standard.Standard_Transient):
    def ContextIdentifier(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ContextType(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GeometricRepresentationContext(self) -> StepGeom_GeometricRepresentationContext: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GlobalUnitAssignedContext(self) -> OCP.StepRepr.StepRepr_GlobalUnitAssignedContext: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString,aContextType : OCP.TCollection.TCollection_HAsciiString,aGeometricRepresentationContext : StepGeom_GeometricRepresentationContext,aGlobalUnitAssignedContext : OCP.StepRepr.StepRepr_GlobalUnitAssignedContext) -> None: ...
    @overload
    def Init(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString,aContextType : OCP.TCollection.TCollection_HAsciiString,aCoordinateSpaceDimension : int,aUnits : OCP.StepBasic.StepBasic_HArray1OfNamedUnit) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def NbUnits(self) -> int: ...
    def SetContextIdentifier(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetContextType(self,aContextType : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetCoordinateSpaceDimension(self,aCoordinateSpaceDimension : int) -> None: ...
    def SetGeometricRepresentationContext(self,aGeometricRepresentationContext : StepGeom_GeometricRepresentationContext) -> None: ...
    def SetGlobalUnitAssignedContext(self,aGlobalUnitAssignedContext : OCP.StepRepr.StepRepr_GlobalUnitAssignedContext) -> None: ...
    def SetUnits(self,aUnits : OCP.StepBasic.StepBasic_HArray1OfNamedUnit) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Units(self) -> OCP.StepBasic.StepBasic_HArray1OfNamedUnit: ...
    def UnitsValue(self,num : int) -> OCP.StepBasic.StepBasic_NamedUnit: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_GeometricRepresentationContextAndParametricRepresentationContext(OCP.StepRepr.StepRepr_RepresentationContext, OCP.Standard.Standard_Transient):
    def ContextIdentifier(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ContextType(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def CoordinateSpaceDimension(self) -> int: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GeometricRepresentationContext(self) -> StepGeom_GeometricRepresentationContext: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString,aContextType : OCP.TCollection.TCollection_HAsciiString,aGeometricRepresentationContext : StepGeom_GeometricRepresentationContext,aParametricRepresentationContext : OCP.StepRepr.StepRepr_ParametricRepresentationContext) -> None: ...
    @overload
    def Init(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString,aContextType : OCP.TCollection.TCollection_HAsciiString,aCoordinateSpaceDimension : int) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def ParametricRepresentationContext(self) -> OCP.StepRepr.StepRepr_ParametricRepresentationContext: ...
    def SetContextIdentifier(self,aContextIdentifier : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetContextType(self,aContextType : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetCoordinateSpaceDimension(self,aCoordinateSpaceDimension : int) -> None: ...
    def SetGeometricRepresentationContext(self,aGeometricRepresentationContext : StepGeom_GeometricRepresentationContext) -> None: ...
    def SetParametricRepresentationContext(self,aParametricRepresentationContext : OCP.StepRepr.StepRepr_ParametricRepresentationContext) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Axis1Placement(StepGeom_Placement, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def Axis(self) -> StepGeom_Direction: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasAxis(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aLocation : StepGeom_CartesianPoint,hasAaxis : bool,aAxis : StepGeom_Direction) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Location(self) -> StepGeom_CartesianPoint: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetAxis(self,aAxis : StepGeom_Direction) -> None: ...
    def SetLocation(self,aLocation : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnSetAxis(self) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray1OfBoundaryCurve(StepGeom_Array1OfBoundaryCurve, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepGeom_Array1OfBoundaryCurve: ...
    def Assign(self,theOther : StepGeom_Array1OfBoundaryCurve) -> StepGeom_Array1OfBoundaryCurve: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepGeom_Array1OfBoundaryCurve: ...
    def ChangeFirst(self) -> StepGeom_BoundaryCurve: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_BoundaryCurve: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_BoundaryCurve: 
        """
        Variable value access
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> StepGeom_BoundaryCurve: 
        """
        Returns first element
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepGeom_BoundaryCurve) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Last(self) -> StepGeom_BoundaryCurve: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfBoundaryCurve) -> StepGeom_Array1OfBoundaryCurve: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_BoundaryCurve) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_BoundaryCurve: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_BoundaryCurve: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepGeom_BoundaryCurve) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_BoundaryCurve,theLower : int,theUpper : int,arg3 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfBoundaryCurve) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_BoundaryCurve]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray1OfCartesianPoint(StepGeom_Array1OfCartesianPoint, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepGeom_Array1OfCartesianPoint: ...
    def Assign(self,theOther : StepGeom_Array1OfCartesianPoint) -> StepGeom_Array1OfCartesianPoint: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepGeom_Array1OfCartesianPoint: ...
    def ChangeFirst(self) -> StepGeom_CartesianPoint: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_CartesianPoint: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_CartesianPoint: 
        """
        Variable value access
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> StepGeom_CartesianPoint: 
        """
        Returns first element
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepGeom_CartesianPoint) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Last(self) -> StepGeom_CartesianPoint: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfCartesianPoint) -> StepGeom_Array1OfCartesianPoint: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_CartesianPoint) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_CartesianPoint: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_CartesianPoint: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepGeom_CartesianPoint) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_CartesianPoint,theLower : int,theUpper : int,arg3 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfCartesianPoint) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_CartesianPoint]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray1OfCompositeCurveSegment(StepGeom_Array1OfCompositeCurveSegment, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepGeom_Array1OfCompositeCurveSegment: ...
    def Assign(self,theOther : StepGeom_Array1OfCompositeCurveSegment) -> StepGeom_Array1OfCompositeCurveSegment: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepGeom_Array1OfCompositeCurveSegment: ...
    def ChangeFirst(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_CompositeCurveSegment: 
        """
        Variable value access
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns first element
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepGeom_CompositeCurveSegment) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Last(self) -> StepGeom_CompositeCurveSegment: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfCompositeCurveSegment) -> StepGeom_Array1OfCompositeCurveSegment: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_CompositeCurveSegment) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_CompositeCurveSegment: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_CompositeCurveSegment: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepGeom_CompositeCurveSegment) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_CompositeCurveSegment,theLower : int,theUpper : int,arg3 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfCompositeCurveSegment) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_CompositeCurveSegment]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray1OfCurve(StepGeom_Array1OfCurve, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepGeom_Array1OfCurve: ...
    def Assign(self,theOther : StepGeom_Array1OfCurve) -> StepGeom_Array1OfCurve: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepGeom_Array1OfCurve: ...
    def ChangeFirst(self) -> StepGeom_Curve: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_Curve: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_Curve: 
        """
        Variable value access
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> StepGeom_Curve: 
        """
        Returns first element
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepGeom_Curve) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Last(self) -> StepGeom_Curve: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfCurve) -> StepGeom_Array1OfCurve: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_Curve) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_Curve: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_Curve: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepGeom_Curve) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_Curve,theLower : int,theUpper : int,arg3 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfCurve) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_Curve]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray1OfPcurveOrSurface(StepGeom_Array1OfPcurveOrSurface, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepGeom_Array1OfPcurveOrSurface: ...
    def Assign(self,theOther : StepGeom_Array1OfPcurveOrSurface) -> StepGeom_Array1OfPcurveOrSurface: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepGeom_Array1OfPcurveOrSurface: ...
    def ChangeFirst(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_PcurveOrSurface: 
        """
        Variable value access
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns first element
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepGeom_PcurveOrSurface) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Last(self) -> StepGeom_PcurveOrSurface: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfPcurveOrSurface) -> StepGeom_Array1OfPcurveOrSurface: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_PcurveOrSurface) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_PcurveOrSurface: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_PcurveOrSurface: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepGeom_PcurveOrSurface) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_PcurveOrSurface,theLower : int,theUpper : int,arg3 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfPcurveOrSurface) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_PcurveOrSurface]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray1OfSurfaceBoundary(StepGeom_Array1OfSurfaceBoundary, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepGeom_Array1OfSurfaceBoundary: ...
    def Assign(self,theOther : StepGeom_Array1OfSurfaceBoundary) -> StepGeom_Array1OfSurfaceBoundary: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepGeom_Array1OfSurfaceBoundary: ...
    def ChangeFirst(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_SurfaceBoundary: 
        """
        Variable value access
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns first element
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepGeom_SurfaceBoundary) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Last(self) -> StepGeom_SurfaceBoundary: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfSurfaceBoundary) -> StepGeom_Array1OfSurfaceBoundary: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_SurfaceBoundary) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_SurfaceBoundary: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_SurfaceBoundary: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepGeom_SurfaceBoundary) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_SurfaceBoundary,theLower : int,theUpper : int,arg3 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfSurfaceBoundary) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_SurfaceBoundary]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray1OfTrimmingSelect(StepGeom_Array1OfTrimmingSelect, OCP.Standard.Standard_Transient):
    def Array1(self) -> StepGeom_Array1OfTrimmingSelect: ...
    def Assign(self,theOther : StepGeom_Array1OfTrimmingSelect) -> StepGeom_Array1OfTrimmingSelect: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def ChangeArray1(self) -> StepGeom_Array1OfTrimmingSelect: ...
    def ChangeFirst(self) -> StepGeom_TrimmingSelect: 
        """
        Returns first element
        """
    def ChangeLast(self) -> StepGeom_TrimmingSelect: 
        """
        Returns last element
        """
    def ChangeValue(self,theIndex : int) -> StepGeom_TrimmingSelect: 
        """
        Variable value access
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def First(self) -> StepGeom_TrimmingSelect: 
        """
        Returns first element
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theValue : StepGeom_TrimmingSelect) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: ...
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Last(self) -> StepGeom_TrimmingSelect: 
        """
        Returns last element
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : StepGeom_Array1OfTrimmingSelect) -> StepGeom_Array1OfTrimmingSelect: ...
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : StepGeom_TrimmingSelect) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def Value(self,theIndex : int) -> StepGeom_TrimmingSelect: 
        """
        Constant value access
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> StepGeom_TrimmingSelect: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int,theValue : StepGeom_TrimmingSelect) -> None: ...
    @overload
    def __init__(self,theBegin : StepGeom_TrimmingSelect,theLower : int,theUpper : int,arg3 : bool) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array1OfTrimmingSelect) -> None: ...
    def __iter__(self) -> Iterator[StepGeom_TrimmingSelect]: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray2OfCartesianPoint(StepGeom_Array2OfCartesianPoint, OCP.Standard.Standard_Transient):
    def Array2(self) -> StepGeom_Array2OfCartesianPoint: ...
    def Assign(self,theOther : StepGeom_Array2OfCartesianPoint) -> StepGeom_Array2OfCartesianPoint: 
        """
        Assignment
        """
    @staticmethod
    def BeginPosition_s(theRowLower : int,arg1 : int,theColLower : int,theColUpper : int) -> int: ...
    def ChangeArray2(self) -> StepGeom_Array2OfCartesianPoint: ...
    def ChangeValue(self,theRow : int,theCol : int) -> StepGeom_CartesianPoint: 
        """
        Variable value access
        """
    def ColLength(self) -> int: 
        """
        Returns length of the column, i.e. number of rows
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @staticmethod
    def LastPosition_s(theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> int: ...
    def Length(self) -> int: ...
    def LowerCol(self) -> int: 
        """
        LowerCol
        """
    def LowerRow(self) -> int: 
        """
        LowerRow
        """
    def Move(self,theOther : StepGeom_Array2OfCartesianPoint) -> StepGeom_Array2OfCartesianPoint: 
        """
        Move assignment. This array will borrow all the data from theOther. The moved object will be left uninitialized and should not be used anymore.
        """
    def NbColumns(self) -> int: 
        """
        Returns number of columns
        """
    def NbRows(self) -> int: 
        """
        Returns number of rows
        """
    def Resize(self,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def RowLength(self) -> int: 
        """
        Returns length of the row, i.e. number of columns
        """
    def SetValue(self,theRow : int,theCol : int,theItem : StepGeom_CartesianPoint) -> None: 
        """
        SetValue
        """
    def Size(self) -> int: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpperCol(self) -> int: 
        """
        UpperCol
        """
    def UpperRow(self) -> int: 
        """
        UpperRow
        """
    def Value(self,theRow : int,theCol : int) -> StepGeom_CartesianPoint: 
        """
        Constant value access
        """
    def __call__(self,theRow : int,theCol : int) -> StepGeom_CartesianPoint: ...
    @overload
    def __init__(self,theRowLow : int,theRowUpp : int,theColLow : int,theColUpp : int) -> None: ...
    @overload
    def __init__(self,theRowLow : int,theRowUpp : int,theColLow : int,theColUpp : int,theValue : StepGeom_CartesianPoint) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array2OfCartesianPoint) -> None: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_HArray2OfSurfacePatch(StepGeom_Array2OfSurfacePatch, OCP.Standard.Standard_Transient):
    def Array2(self) -> StepGeom_Array2OfSurfacePatch: ...
    def Assign(self,theOther : StepGeom_Array2OfSurfacePatch) -> StepGeom_Array2OfSurfacePatch: 
        """
        Assignment
        """
    @staticmethod
    def BeginPosition_s(theRowLower : int,arg1 : int,theColLower : int,theColUpper : int) -> int: ...
    def ChangeArray2(self) -> StepGeom_Array2OfSurfacePatch: ...
    def ChangeValue(self,theRow : int,theCol : int) -> StepGeom_SurfacePatch: 
        """
        Variable value access
        """
    def ColLength(self) -> int: 
        """
        Returns length of the column, i.e. number of rows
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @staticmethod
    def LastPosition_s(theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int) -> int: ...
    def Length(self) -> int: ...
    def LowerCol(self) -> int: 
        """
        LowerCol
        """
    def LowerRow(self) -> int: 
        """
        LowerRow
        """
    def Move(self,theOther : StepGeom_Array2OfSurfacePatch) -> StepGeom_Array2OfSurfacePatch: 
        """
        Move assignment. This array will borrow all the data from theOther. The moved object will be left uninitialized and should not be used anymore.
        """
    def NbColumns(self) -> int: 
        """
        Returns number of columns
        """
    def NbRows(self) -> int: 
        """
        Returns number of rows
        """
    def Resize(self,theRowLower : int,theRowUpper : int,theColLower : int,theColUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def RowLength(self) -> int: 
        """
        Returns length of the row, i.e. number of columns
        """
    def SetValue(self,theRow : int,theCol : int,theItem : StepGeom_SurfacePatch) -> None: 
        """
        SetValue
        """
    def Size(self) -> int: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UpperCol(self) -> int: 
        """
        UpperCol
        """
    def UpperRow(self) -> int: 
        """
        UpperRow
        """
    def Value(self,theRow : int,theCol : int) -> StepGeom_SurfacePatch: 
        """
        Constant value access
        """
    def __call__(self,theRow : int,theCol : int) -> StepGeom_SurfacePatch: ...
    @overload
    def __init__(self,theRowLow : int,theRowUpp : int,theColLow : int,theColUpp : int) -> None: ...
    @overload
    def __init__(self,theRowLow : int,theRowUpp : int,theColLow : int,theColUpp : int,theValue : StepGeom_SurfacePatch) -> None: ...
    @overload
    def __init__(self,theOther : StepGeom_Array2OfSurfacePatch) -> None: ...
    def __len__(self) -> int: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Hyperbola(StepGeom_Conic, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement,aSemiAxis : float,aSemiImagAxis : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement: ...
    def SemiAxis(self) -> float: ...
    def SemiImagAxis(self) -> float: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement) -> None: ...
    def SetSemiAxis(self,aSemiAxis : float) -> None: ...
    def SetSemiImagAxis(self,aSemiImagAxis : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SurfaceCurve(StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def AssociatedGeometry(self) -> StepGeom_HArray1OfPcurveOrSurface: ...
    def AssociatedGeometryValue(self,num : int) -> StepGeom_PcurveOrSurface: ...
    def Curve3d(self) -> StepGeom_Curve: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aCurve3d : StepGeom_Curve,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MasterRepresentation(self) -> StepGeom_PreferredSurfaceCurveRepresentation: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbAssociatedGeometry(self) -> int: ...
    def SetAssociatedGeometry(self,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface) -> None: ...
    def SetCurve3d(self,aCurve3d : StepGeom_Curve) -> None: ...
    def SetMasterRepresentation(self,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_KnotType():
    """
    Members:

      StepGeom_ktUniformKnots

      StepGeom_ktUnspecified

      StepGeom_ktQuasiUniformKnots

      StepGeom_ktPiecewiseBezierKnots
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    StepGeom_ktPiecewiseBezierKnots: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktPiecewiseBezierKnots: 3>
    StepGeom_ktQuasiUniformKnots: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktQuasiUniformKnots: 2>
    StepGeom_ktUniformKnots: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktUniformKnots: 0>
    StepGeom_ktUnspecified: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktUnspecified: 1>
    __entries: dict # value = {'StepGeom_ktUniformKnots': (<StepGeom_KnotType.StepGeom_ktUniformKnots: 0>, None), 'StepGeom_ktUnspecified': (<StepGeom_KnotType.StepGeom_ktUnspecified: 1>, None), 'StepGeom_ktQuasiUniformKnots': (<StepGeom_KnotType.StepGeom_ktQuasiUniformKnots: 2>, None), 'StepGeom_ktPiecewiseBezierKnots': (<StepGeom_KnotType.StepGeom_ktPiecewiseBezierKnots: 3>, None)}
    __members__: dict # value = {'StepGeom_ktUniformKnots': <StepGeom_KnotType.StepGeom_ktUniformKnots: 0>, 'StepGeom_ktUnspecified': <StepGeom_KnotType.StepGeom_ktUnspecified: 1>, 'StepGeom_ktQuasiUniformKnots': <StepGeom_KnotType.StepGeom_ktQuasiUniformKnots: 2>, 'StepGeom_ktPiecewiseBezierKnots': <StepGeom_KnotType.StepGeom_ktPiecewiseBezierKnots: 3>}
    pass
class StepGeom_Line(StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Dir(self) -> StepGeom_Vector: ...
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPnt : StepGeom_CartesianPoint,aDir : StepGeom_Vector) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Pnt(self) -> StepGeom_CartesianPoint: ...
    def SetDir(self,aDir : StepGeom_Vector) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPnt(self,aPnt : StepGeom_CartesianPoint) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_OffsetCurve3d(StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisCurve(self) -> StepGeom_Curve: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Distance(self) -> float: ...
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisCurve : StepGeom_Curve,aDistance : float,aSelfIntersect : OCP.StepData.StepData_Logical,aRefDirection : StepGeom_Direction) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def RefDirection(self) -> StepGeom_Direction: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetBasisCurve(self,aBasisCurve : StepGeom_Curve) -> None: ...
    def SetDistance(self,aDistance : float) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRefDirection(self,aRefDirection : StepGeom_Direction) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_OffsetSurface(StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisSurface(self) -> StepGeom_Surface: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Distance(self) -> float: ...
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisSurface : StepGeom_Surface,aDistance : float,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetBasisSurface(self,aBasisSurface : StepGeom_Surface) -> None: ...
    def SetDistance(self,aDistance : float) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_OrientedSurface(StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity OrientedSurfaceRepresentation of STEP entity OrientedSurfaceRepresentation of STEP entity OrientedSurface
    """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aRepresentationItem_Name : OCP.TCollection.TCollection_HAsciiString,aOrientation : bool) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Orientation(self) -> bool: 
        """
        Returns field Orientation
        """
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetOrientation(self,Orientation : bool) -> None: 
        """
        Set field Orientation
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_OuterBoundaryCurve(StepGeom_BoundaryCurve, StepGeom_CompositeCurveOnSurface, StepGeom_CompositeCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSegments : StepGeom_HArray1OfCompositeCurveSegment,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbSegments(self) -> int: ...
    def Segments(self) -> StepGeom_HArray1OfCompositeCurveSegment: ...
    def SegmentsValue(self,num : int) -> StepGeom_CompositeCurveSegment: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSegments(self,aSegments : StepGeom_HArray1OfCompositeCurveSegment) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Parabola(StepGeom_Conic, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FocalDist(self) -> float: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement,aFocalDist : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement: ...
    def SetFocalDist(self,aFocalDist : float) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Pcurve(StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisSurface(self) -> StepGeom_Surface: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisSurface : StepGeom_Surface,aReferenceToCurve : OCP.StepRepr.StepRepr_DefinitionalRepresentation) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ReferenceToCurve(self) -> OCP.StepRepr.StepRepr_DefinitionalRepresentation: ...
    def SetBasisSurface(self,aBasisSurface : StepGeom_Surface) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetReferenceToCurve(self,aReferenceToCurve : OCP.StepRepr.StepRepr_DefinitionalRepresentation) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_PcurveOrSurface(OCP.StepData.StepData_SelectType):
    def Boolean(self) -> bool: ...
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a PcurveOrSurface Kind Entity that is : 1 -> Pcurve 2 -> Surface 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: ...
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def Pcurve(self) -> StepGeom_Pcurve: 
        """
        returns Value as a Pcurve (Null if another type)
        """
    def Real(self) -> float: ...
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: ...
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: ...
    def SetReal(self,val : float,name : str='') -> None: ...
    @overload
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.

        SetValue supporting python objects
        """
    @overload
    def SetValue(self,ent : object) -> None: ...
    def Surface(self) -> StepGeom_Surface: 
        """
        returns Value as a Surface (Null if another type)
        """
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepGeom_Axis2Placement2d(StepGeom_Placement, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasRefDirection(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aLocation : StepGeom_CartesianPoint,hasArefDirection : bool,aRefDirection : StepGeom_Direction) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Location(self) -> StepGeom_CartesianPoint: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def RefDirection(self) -> StepGeom_Direction: ...
    def SetLocation(self,aLocation : StepGeom_CartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRefDirection(self,aRefDirection : StepGeom_Direction) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnSetRefDirection(self) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Plane(StepGeom_ElementarySurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_CartesianPoint(StepGeom_Point, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def Coordinates(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def CoordinatesValue(self,num : int) -> float: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aCoordinates : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def Init2D(self,aName : OCP.TCollection.TCollection_HAsciiString,X : float,Y : float) -> None: ...
    def Init3D(self,aName : OCP.TCollection.TCollection_HAsciiString,X : float,Y : float,Z : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbCoordinates(self) -> int: ...
    def SetCoordinates(self,aCoordinates : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_PointOnCurve(StepGeom_Point, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisCurve(self) -> StepGeom_Curve: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisCurve : StepGeom_Curve,aPointParameter : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def PointParameter(self) -> float: ...
    def SetBasisCurve(self,aBasisCurve : StepGeom_Curve) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPointParameter(self,aPointParameter : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_PointOnSurface(StepGeom_Point, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisSurface(self) -> StepGeom_Surface: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisSurface : StepGeom_Surface,aPointParameterU : float,aPointParameterV : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def PointParameterU(self) -> float: ...
    def PointParameterV(self) -> float: ...
    def SetBasisSurface(self,aBasisSurface : StepGeom_Surface) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPointParameterU(self,aPointParameterU : float) -> None: ...
    def SetPointParameterV(self,aPointParameterV : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_PointReplica(StepGeom_Point, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aParentPt : StepGeom_Point,aTransformation : StepGeom_CartesianTransformationOperator) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ParentPt(self) -> StepGeom_Point: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetParentPt(self,aParentPt : StepGeom_Point) -> None: ...
    def SetTransformation(self,aTransformation : StepGeom_CartesianTransformationOperator) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Transformation(self) -> StepGeom_CartesianTransformationOperator: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Polyline(StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPoints : StepGeom_HArray1OfCartesianPoint) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbPoints(self) -> int: ...
    def Points(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def PointsValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPoints(self,aPoints : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_PreferredSurfaceCurveRepresentation():
    """
    Members:

      StepGeom_pscrCurve3d

      StepGeom_pscrPcurveS1

      StepGeom_pscrPcurveS2
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    StepGeom_pscrCurve3d: OCP.StepGeom.StepGeom_PreferredSurfaceCurveRepresentation # value = <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrCurve3d: 0>
    StepGeom_pscrPcurveS1: OCP.StepGeom.StepGeom_PreferredSurfaceCurveRepresentation # value = <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS1: 1>
    StepGeom_pscrPcurveS2: OCP.StepGeom.StepGeom_PreferredSurfaceCurveRepresentation # value = <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS2: 2>
    __entries: dict # value = {'StepGeom_pscrCurve3d': (<StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrCurve3d: 0>, None), 'StepGeom_pscrPcurveS1': (<StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS1: 1>, None), 'StepGeom_pscrPcurveS2': (<StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS2: 2>, None)}
    __members__: dict # value = {'StepGeom_pscrCurve3d': <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrCurve3d: 0>, 'StepGeom_pscrPcurveS1': <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS1: 1>, 'StepGeom_pscrPcurveS2': <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS2: 2>}
    pass
class StepGeom_QuasiUniformCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_QuasiUniformCurveAndRationalBSplineCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aQuasiUniformCurve : StepGeom_QuasiUniformCurve,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def NbWeightsData(self) -> int: ...
    def QuasiUniformCurve(self) -> StepGeom_QuasiUniformCurve: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetQuasiUniformCurve(self,aQuasiUniformCurve : StepGeom_QuasiUniformCurve) -> None: ...
    def SetRationalBSplineCurve(self,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def WeightsDataValue(self,num : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_QuasiUniformSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_QuasiUniformSurfaceAndRationalBSplineSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aQuasiUniformSurface : StepGeom_QuasiUniformSurface,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def QuasiUniformSurface(self) -> StepGeom_QuasiUniformSurface: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetQuasiUniformSurface(self,aQuasiUniformSurface : StepGeom_QuasiUniformSurface) -> None: ...
    def SetRationalBSplineSurface(self,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray2OfReal: ...
    def WeightsDataValue(self,num1 : int,num2 : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_RationalBSplineCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def NbWeightsData(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def WeightsDataValue(self,num : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_RationalBSplineSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray2OfReal: ...
    def WeightsDataValue(self,num1 : int,num2 : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_RectangularCompositeSurface(StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSegments : StepGeom_HArray2OfSurfacePatch) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbSegmentsI(self) -> int: ...
    def NbSegmentsJ(self) -> int: ...
    def Segments(self) -> StepGeom_HArray2OfSurfacePatch: ...
    def SegmentsValue(self,num1 : int,num2 : int) -> StepGeom_SurfacePatch: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSegments(self,aSegments : StepGeom_HArray2OfSurfacePatch) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_RectangularTrimmedSurface(StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisSurface(self) -> StepGeom_Surface: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisSurface : StepGeom_Surface,aU1 : float,aU2 : float,aV1 : float,aV2 : float,aUsense : bool,aVsense : bool) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetBasisSurface(self,aBasisSurface : StepGeom_Surface) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetU1(self,aU1 : float) -> None: ...
    def SetU2(self,aU2 : float) -> None: ...
    def SetUsense(self,aUsense : bool) -> None: ...
    def SetV1(self,aV1 : float) -> None: ...
    def SetV2(self,aV2 : float) -> None: ...
    def SetVsense(self,aVsense : bool) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def U1(self) -> float: ...
    def U2(self) -> float: ...
    def Usense(self) -> bool: ...
    def V1(self) -> float: ...
    def V2(self) -> float: ...
    def Vsense(self) -> bool: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_ReparametrisedCompositeCurveSegment(StepGeom_CompositeCurveSegment, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aTransition : StepGeom_TransitionCode,aSameSense : bool,aParentCurve : StepGeom_Curve,aParamLength : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def ParamLength(self) -> float: ...
    def ParentCurve(self) -> StepGeom_Curve: ...
    def SameSense(self) -> bool: ...
    def SetParamLength(self,aParamLength : float) -> None: ...
    def SetParentCurve(self,aParentCurve : StepGeom_Curve) -> None: ...
    def SetSameSense(self,aSameSense : bool) -> None: ...
    def SetTransition(self,aTransition : StepGeom_TransitionCode) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Transition(self) -> StepGeom_TransitionCode: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SeamCurve(StepGeom_SurfaceCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def AssociatedGeometry(self) -> StepGeom_HArray1OfPcurveOrSurface: ...
    def AssociatedGeometryValue(self,num : int) -> StepGeom_PcurveOrSurface: ...
    def Curve3d(self) -> StepGeom_Curve: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aCurve3d : StepGeom_Curve,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MasterRepresentation(self) -> StepGeom_PreferredSurfaceCurveRepresentation: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbAssociatedGeometry(self) -> int: ...
    def SetAssociatedGeometry(self,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface) -> None: ...
    def SetCurve3d(self,aCurve3d : StepGeom_Curve) -> None: ...
    def SetMasterRepresentation(self,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SphericalSurface(StepGeom_ElementarySurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement3d,aRadius : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def Radius(self) -> float: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    def SetRadius(self,aRadius : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SuParameters(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    """
    Representation of STEP entity SuParametersRepresentation of STEP entity SuParameters
    """
    def A(self) -> float: 
        """
        Returns field A
        """
    def Alpha(self) -> float: 
        """
        Returns field Alpha
        """
    def B(self) -> float: 
        """
        Returns field B
        """
    def Beta(self) -> float: 
        """
        Returns field Beta
        """
    def C(self) -> float: 
        """
        Returns field C
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Gamma(self) -> float: 
        """
        Returns field Gamma
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,theRepresentationItem_Name : OCP.TCollection.TCollection_HAsciiString,theA : float,theAlpha : float,theB : float,theBeta : float,theC : float,theGamma : float) -> None: 
        """
        Initialize all fields (own and inherited)
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetA(self,theA : float) -> None: 
        """
        Sets field A
        """
    def SetAlpha(self,theAlpha : float) -> None: 
        """
        Sets field Alpha
        """
    def SetB(self,theB : float) -> None: 
        """
        Sets field B
        """
    def SetBeta(self,theBeta : float) -> None: 
        """
        Sets field Beta
        """
    def SetC(self,theC : float) -> None: 
        """
        Sets field C
        """
    def SetGamma(self,theGamma : float) -> None: 
        """
        Sets field Gamma
        """
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BSplineSurfaceWithKnots(self) -> StepGeom_BSplineSurfaceWithKnots: ...
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aBSplineSurfaceWithKnots : StepGeom_BSplineSurfaceWithKnots,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aUMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger,aVMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger,aUKnots : OCP.TColStd.TColStd_HArray1OfReal,aVKnots : OCP.TColStd.TColStd_HArray1OfReal,aKnotSpec : StepGeom_KnotType,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def KnotSpec(self) -> StepGeom_KnotType: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def NbUKnots(self) -> int: ...
    def NbUMultiplicities(self) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVMultiplicities(self) -> int: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetBSplineSurfaceWithKnots(self,aBSplineSurfaceWithKnots : StepGeom_BSplineSurfaceWithKnots) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetKnotSpec(self,aKnotSpec : StepGeom_KnotType) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRationalBSplineSurface(self,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetUKnots(self,aUKnots : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetUMultiplicities(self,aUMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SetVKnots(self,aVKnots : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def SetVMultiplicities(self,aVMultiplicities : OCP.TColStd.TColStd_HArray1OfInteger) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def UKnots(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def UKnotsValue(self,num : int) -> float: ...
    def UMultiplicities(self) -> OCP.TColStd.TColStd_HArray1OfInteger: ...
    def UMultiplicitiesValue(self,num : int) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def VKnots(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def VKnotsValue(self,num : int) -> float: ...
    def VMultiplicities(self) -> OCP.TColStd.TColStd_HArray1OfInteger: ...
    def VMultiplicitiesValue(self,num : int) -> int: ...
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray2OfReal: ...
    def WeightsDataValue(self,num1 : int,num2 : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SurfaceBoundary(OCP.StepData.StepData_SelectType):
    """
    Representation of STEP SELECT type SurfaceBoundary
    """
    def Boolean(self) -> bool: ...
    def BoundaryCurve(self) -> StepGeom_BoundaryCurve: 
        """
        Returns Value as BoundaryCurve (or Null if another type)
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a kind of SurfaceBoundary select type 1 -> BoundaryCurve from StepGeom 2 -> DegeneratePcurve from StepGeom 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def DegeneratePcurve(self) -> StepGeom_DegeneratePcurve: 
        """
        Returns Value as DegeneratePcurve (or Null if another type)
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: ...
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def Real(self) -> float: ...
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: ...
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: ...
    def SetReal(self,val : float,name : str='') -> None: ...
    @overload
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.

        SetValue supporting python objects
        """
    @overload
    def SetValue(self,ent : object) -> None: ...
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepGeom_IntersectionCurve(StepGeom_SurfaceCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def AssociatedGeometry(self) -> StepGeom_HArray1OfPcurveOrSurface: ...
    def AssociatedGeometryValue(self,num : int) -> StepGeom_PcurveOrSurface: ...
    def Curve3d(self) -> StepGeom_Curve: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aCurve3d : StepGeom_Curve,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MasterRepresentation(self) -> StepGeom_PreferredSurfaceCurveRepresentation: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbAssociatedGeometry(self) -> int: ...
    def SetAssociatedGeometry(self,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface) -> None: ...
    def SetCurve3d(self,aCurve3d : StepGeom_Curve) -> None: ...
    def SetMasterRepresentation(self,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SurfaceCurveAndBoundedCurve(StepGeom_SurfaceCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    """
    complex type: bounded_curve + surface_curve needed for curve_bounded_surfaces (S4132)complex type: bounded_curve + surface_curve needed for curve_bounded_surfaces (S4132)complex type: bounded_curve + surface_curve needed for curve_bounded_surfaces (S4132)
    """
    def AssociatedGeometry(self) -> StepGeom_HArray1OfPcurveOrSurface: ...
    def AssociatedGeometryValue(self,num : int) -> StepGeom_PcurveOrSurface: ...
    def BoundedCurve(self) -> StepGeom_BoundedCurve: 
        """
        returns field BoundedCurve
        """
    def Curve3d(self) -> StepGeom_Curve: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aCurve3d : StepGeom_Curve,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MasterRepresentation(self) -> StepGeom_PreferredSurfaceCurveRepresentation: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbAssociatedGeometry(self) -> int: ...
    def SetAssociatedGeometry(self,aAssociatedGeometry : StepGeom_HArray1OfPcurveOrSurface) -> None: ...
    def SetCurve3d(self,aCurve3d : StepGeom_Curve) -> None: ...
    def SetMasterRepresentation(self,aMasterRepresentation : StepGeom_PreferredSurfaceCurveRepresentation) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SweptSurface(StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSweptCurve : StepGeom_Curve) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSweptCurve(self,aSweptCurve : StepGeom_Curve) -> None: ...
    def SweptCurve(self) -> StepGeom_Curve: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SurfaceOfRevolution(StepGeom_SweptSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def AxisPosition(self) -> StepGeom_Axis1Placement: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSweptCurve : StepGeom_Curve,aAxisPosition : StepGeom_Axis1Placement) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetAxisPosition(self,aAxisPosition : StepGeom_Axis1Placement) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSweptCurve(self,aSweptCurve : StepGeom_Curve) -> None: ...
    def SweptCurve(self) -> StepGeom_Curve: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SurfacePatch(OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aParentSurface : StepGeom_BoundedSurface,aUTransition : StepGeom_TransitionCode,aVTransition : StepGeom_TransitionCode,aUSense : bool,aVSense : bool) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def ParentSurface(self) -> StepGeom_BoundedSurface: ...
    def SetParentSurface(self,aParentSurface : StepGeom_BoundedSurface) -> None: ...
    def SetUSense(self,aUSense : bool) -> None: ...
    def SetUTransition(self,aUTransition : StepGeom_TransitionCode) -> None: ...
    def SetVSense(self,aVSense : bool) -> None: ...
    def SetVTransition(self,aVTransition : StepGeom_TransitionCode) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def USense(self) -> bool: ...
    def UTransition(self) -> StepGeom_TransitionCode: ...
    def VSense(self) -> bool: ...
    def VTransition(self) -> StepGeom_TransitionCode: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SurfaceReplica(StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aParentSurface : StepGeom_Surface,aTransformation : StepGeom_CartesianTransformationOperator3d) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def ParentSurface(self) -> StepGeom_Surface: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetParentSurface(self,aParentSurface : StepGeom_Surface) -> None: ...
    def SetTransformation(self,aTransformation : StepGeom_CartesianTransformationOperator3d) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Transformation(self) -> StepGeom_CartesianTransformationOperator3d: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_SurfaceOfLinearExtrusion(StepGeom_SweptSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def ExtrusionAxis(self) -> StepGeom_Vector: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aSweptCurve : StepGeom_Curve,aExtrusionAxis : StepGeom_Vector) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def SetExtrusionAxis(self,aExtrusionAxis : StepGeom_Vector) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSweptCurve(self,aSweptCurve : StepGeom_Curve) -> None: ...
    def SweptCurve(self) -> StepGeom_Curve: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_DegenerateToroidalSurface(StepGeom_ToroidalSurface, StepGeom_ElementarySurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aPosition : StepGeom_Axis2Placement3d,aMajorRadius : float,aMinorRadius : float,aSelectOuter : bool) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def SelectOuter(self) -> bool: ...
    def SetMajorRadius(self,aMajorRadius : float) -> None: ...
    def SetMinorRadius(self,aMinorRadius : float) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetPosition(self,aPosition : StepGeom_Axis2Placement3d) -> None: ...
    def SetSelectOuter(self,aSelectOuter : bool) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_TransitionCode():
    """
    Members:

      StepGeom_tcDiscontinuous

      StepGeom_tcContinuous

      StepGeom_tcContSameGradient

      StepGeom_tcContSameGradientSameCurvature
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    StepGeom_tcContSameGradient: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcContSameGradient: 2>
    StepGeom_tcContSameGradientSameCurvature: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcContSameGradientSameCurvature: 3>
    StepGeom_tcContinuous: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcContinuous: 1>
    StepGeom_tcDiscontinuous: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcDiscontinuous: 0>
    __entries: dict # value = {'StepGeom_tcDiscontinuous': (<StepGeom_TransitionCode.StepGeom_tcDiscontinuous: 0>, None), 'StepGeom_tcContinuous': (<StepGeom_TransitionCode.StepGeom_tcContinuous: 1>, None), 'StepGeom_tcContSameGradient': (<StepGeom_TransitionCode.StepGeom_tcContSameGradient: 2>, None), 'StepGeom_tcContSameGradientSameCurvature': (<StepGeom_TransitionCode.StepGeom_tcContSameGradientSameCurvature: 3>, None)}
    __members__: dict # value = {'StepGeom_tcDiscontinuous': <StepGeom_TransitionCode.StepGeom_tcDiscontinuous: 0>, 'StepGeom_tcContinuous': <StepGeom_TransitionCode.StepGeom_tcContinuous: 1>, 'StepGeom_tcContSameGradient': <StepGeom_TransitionCode.StepGeom_tcContSameGradient: 2>, 'StepGeom_tcContSameGradientSameCurvature': <StepGeom_TransitionCode.StepGeom_tcContSameGradientSameCurvature: 3>}
    pass
class StepGeom_TrimmedCurve(StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def BasisCurve(self) -> StepGeom_Curve: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aBasisCurve : StepGeom_Curve,aTrim1 : StepGeom_HArray1OfTrimmingSelect,aTrim2 : StepGeom_HArray1OfTrimmingSelect,aSenseAgreement : bool,aMasterRepresentation : StepGeom_TrimmingPreference) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MasterRepresentation(self) -> StepGeom_TrimmingPreference: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbTrim1(self) -> int: ...
    def NbTrim2(self) -> int: ...
    def SenseAgreement(self) -> bool: ...
    def SetBasisCurve(self,aBasisCurve : StepGeom_Curve) -> None: ...
    def SetMasterRepresentation(self,aMasterRepresentation : StepGeom_TrimmingPreference) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSenseAgreement(self,aSenseAgreement : bool) -> None: ...
    def SetTrim1(self,aTrim1 : StepGeom_HArray1OfTrimmingSelect) -> None: ...
    def SetTrim2(self,aTrim2 : StepGeom_HArray1OfTrimmingSelect) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Trim1(self) -> StepGeom_HArray1OfTrimmingSelect: ...
    def Trim1Value(self,num : int) -> StepGeom_TrimmingSelect: ...
    def Trim2(self) -> StepGeom_HArray1OfTrimmingSelect: ...
    def Trim2Value(self,num : int) -> StepGeom_TrimmingSelect: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_TrimmingMember(OCP.StepData.StepData_SelectReal, OCP.StepData.StepData_SelectMember, OCP.Standard.Standard_Transient):
    """
    For immediate members of TrimmingSelect, i.e. : ParameterValue (a Real)For immediate members of TrimmingSelect, i.e. : ParameterValue (a Real)For immediate members of TrimmingSelect, i.e. : ParameterValue (a Real)
    """
    def Boolean(self) -> bool: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Enum(self) -> int: ...
    def EnumText(self) -> str: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasName(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Kind(self) -> int: ...
    def Logical(self) -> OCP.StepData.StepData_Logical: ...
    def Matches(self,name : str) -> bool: 
        """
        Tells if the name of a SelectMember matches a given one By default, compares the strings, can be redefined (optimised)
        """
    def Name(self) -> str: ...
    def ParamType(self) -> OCP.Interface.Interface_ParamType: 
        """
        Returns the Kind of the SelectMember, under the form of an enum ParamType
        """
    def Real(self) -> float: ...
    def SetBoolean(self,val : bool) -> None: ...
    def SetEnum(self,val : int,text : str='') -> None: ...
    def SetEnumText(self,val : int,text : str) -> None: ...
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it)
        """
    def SetInteger(self,val : int) -> None: ...
    def SetKind(self,kind : int) -> None: ...
    def SetLogical(self,val : OCP.StepData.StepData_Logical) -> None: ...
    def SetName(self,name : str) -> bool: ...
    def SetReal(self,val : float) -> None: ...
    def SetString(self,val : str) -> None: ...
    def String(self) -> str: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_TrimmingPreference():
    """
    Members:

      StepGeom_tpCartesian

      StepGeom_tpParameter

      StepGeom_tpUnspecified
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    StepGeom_tpCartesian: OCP.StepGeom.StepGeom_TrimmingPreference # value = <StepGeom_TrimmingPreference.StepGeom_tpCartesian: 0>
    StepGeom_tpParameter: OCP.StepGeom.StepGeom_TrimmingPreference # value = <StepGeom_TrimmingPreference.StepGeom_tpParameter: 1>
    StepGeom_tpUnspecified: OCP.StepGeom.StepGeom_TrimmingPreference # value = <StepGeom_TrimmingPreference.StepGeom_tpUnspecified: 2>
    __entries: dict # value = {'StepGeom_tpCartesian': (<StepGeom_TrimmingPreference.StepGeom_tpCartesian: 0>, None), 'StepGeom_tpParameter': (<StepGeom_TrimmingPreference.StepGeom_tpParameter: 1>, None), 'StepGeom_tpUnspecified': (<StepGeom_TrimmingPreference.StepGeom_tpUnspecified: 2>, None)}
    __members__: dict # value = {'StepGeom_tpCartesian': <StepGeom_TrimmingPreference.StepGeom_tpCartesian: 0>, 'StepGeom_tpParameter': <StepGeom_TrimmingPreference.StepGeom_tpParameter: 1>, 'StepGeom_tpUnspecified': <StepGeom_TrimmingPreference.StepGeom_tpUnspecified: 2>}
    pass
class StepGeom_TrimmingSelect(OCP.StepData.StepData_SelectType):
    def Boolean(self) -> bool: ...
    def CartesianPoint(self) -> StepGeom_CartesianPoint: 
        """
        returns Value as a CartesianPoint (Null if another type)
        """
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognizes a SelectMember as Real, named as PARAMETER_VALUE 1 -> ParameterValue i.e. Real 0 else (i.e. Entity)
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a TrimmingSelect Kind Entity that is : 1 -> CartesianPoint 0 else (i.e. Real)
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: ...
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a TrimmingMember (for PARAMETER_VALUE) as preferred
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def ParameterValue(self) -> float: 
        """
        returns Value as a Real (0.0 if not a Real)
        """
    def Real(self) -> float: ...
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: ...
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: ...
    def SetParameterValue(self,aParameterValue : float) -> None: 
        """
        sets the ParameterValue as Real
        """
    def SetReal(self,val : float,name : str='') -> None: ...
    @overload
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.

        SetValue supporting python objects
        """
    @overload
    def SetValue(self,ent : object) -> None: ...
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def __init__(self) -> None: ...
    pass
class StepGeom_UniformCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_UniformCurveAndRationalBSplineCurve(StepGeom_BSplineCurve, StepGeom_BoundedCurve, StepGeom_Curve, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ClosedCurve(self) -> OCP.StepData.StepData_Logical: ...
    def ControlPointsList(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def ControlPointsListValue(self,num : int) -> StepGeom_CartesianPoint: ...
    def CurveForm(self) -> StepGeom_BSplineCurveForm: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Degree(self) -> int: ...
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aUniformCurve : StepGeom_UniformCurve,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aDegree : int,aControlPointsList : StepGeom_HArray1OfCartesianPoint,aCurveForm : StepGeom_BSplineCurveForm,aClosedCurve : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsList(self) -> int: ...
    def NbWeightsData(self) -> int: ...
    def RationalBSplineCurve(self) -> StepGeom_RationalBSplineCurve: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetClosedCurve(self,aClosedCurve : OCP.StepData.StepData_Logical) -> None: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray1OfCartesianPoint) -> None: ...
    def SetCurveForm(self,aCurveForm : StepGeom_BSplineCurveForm) -> None: ...
    def SetDegree(self,aDegree : int) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRationalBSplineCurve(self,aRationalBSplineCurve : StepGeom_RationalBSplineCurve) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetUniformCurve(self,aUniformCurve : StepGeom_UniformCurve) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray1OfReal) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UniformCurve(self) -> StepGeom_UniformCurve: ...
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def WeightsDataValue(self,num : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_UniformSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_UniformSurfaceAndRationalBSplineSurface(StepGeom_BSplineSurface, StepGeom_BoundedSurface, StepGeom_Surface, StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def ControlPointsList(self) -> StepGeom_HArray2OfCartesianPoint: ...
    def ControlPointsListValue(self,num1 : int,num2 : int) -> StepGeom_CartesianPoint: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aUniformSurface : StepGeom_UniformSurface,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    @overload
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aUDegree : int,aVDegree : int,aControlPointsList : StepGeom_HArray2OfCartesianPoint,aSurfaceForm : StepGeom_BSplineSurfaceForm,aUClosed : OCP.StepData.StepData_Logical,aVClosed : OCP.StepData.StepData_Logical,aSelfIntersect : OCP.StepData.StepData_Logical,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbControlPointsListI(self) -> int: ...
    def NbControlPointsListJ(self) -> int: ...
    def NbWeightsDataI(self) -> int: ...
    def NbWeightsDataJ(self) -> int: ...
    def RationalBSplineSurface(self) -> StepGeom_RationalBSplineSurface: ...
    def SelfIntersect(self) -> OCP.StepData.StepData_Logical: ...
    def SetControlPointsList(self,aControlPointsList : StepGeom_HArray2OfCartesianPoint) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetRationalBSplineSurface(self,aRationalBSplineSurface : StepGeom_RationalBSplineSurface) -> None: ...
    def SetSelfIntersect(self,aSelfIntersect : OCP.StepData.StepData_Logical) -> None: ...
    def SetSurfaceForm(self,aSurfaceForm : StepGeom_BSplineSurfaceForm) -> None: ...
    def SetUClosed(self,aUClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetUDegree(self,aUDegree : int) -> None: ...
    def SetUniformSurface(self,aUniformSurface : StepGeom_UniformSurface) -> None: ...
    def SetVClosed(self,aVClosed : OCP.StepData.StepData_Logical) -> None: ...
    def SetVDegree(self,aVDegree : int) -> None: ...
    def SetWeightsData(self,aWeightsData : OCP.TColStd.TColStd_HArray2OfReal) -> None: ...
    def SurfaceForm(self) -> StepGeom_BSplineSurfaceForm: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UClosed(self) -> OCP.StepData.StepData_Logical: ...
    def UDegree(self) -> int: ...
    def UniformSurface(self) -> StepGeom_UniformSurface: ...
    def VClosed(self) -> OCP.StepData.StepData_Logical: ...
    def VDegree(self) -> int: ...
    def WeightsData(self) -> OCP.TColStd.TColStd_HArray2OfReal: ...
    def WeightsDataValue(self,num1 : int,num2 : int) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_Vector(StepGeom_GeometricRepresentationItem, OCP.StepRepr.StepRepr_RepresentationItem, OCP.Standard.Standard_Transient):
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self,aName : OCP.TCollection.TCollection_HAsciiString,aOrientation : StepGeom_Direction,aMagnitude : float) -> None: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Magnitude(self) -> float: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def Orientation(self) -> StepGeom_Direction: ...
    def SetMagnitude(self,aMagnitude : float) -> None: ...
    def SetName(self,aName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetOrientation(self,aOrientation : StepGeom_Direction) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class StepGeom_VectorOrDirection(OCP.StepData.StepData_SelectType):
    def Boolean(self) -> bool: ...
    def CaseMem(self,ent : OCP.StepData.StepData_SelectMember) -> int: 
        """
        Recognize a SelectMember (kind, name). Returns a positive value which identifies the case in the List of immediate cases (distinct from the List of Entity Types). Zero if not recognizes Default returns 0, saying that no immediate value is allowed
        """
    def CaseMember(self) -> int: 
        """
        Returns the Type of the stored SelectMember, or zero if it is Null or Entity. Calls the method CaseMem on Value
        """
    def CaseNum(self,ent : OCP.Standard.Standard_Transient) -> int: 
        """
        Recognizes a VectorOrDirection Kind Entity that is : 1 -> Vector 2 -> Direction 0 else
        """
    def CaseNumber(self) -> int: 
        """
        Recognizes the Type of the stored Entity, or zero if it is Null or SelectMember. Calls the first method CaseNum on Value
        """
    def Description(self) -> OCP.StepData.StepData_PDescr: 
        """
        Returns the Description which corresponds to <me> Null if no specific description to give. This description is used to control reading an check validity. Default returns a Null Handle, i.e. undefined description It can suffice if CaseNum and CaseMem give enough control
        """
    def Direction(self) -> StepGeom_Direction: 
        """
        returns Value as a Direction (Null if another type)
        """
    def Int(self) -> int: 
        """
        This internal method gives access to a value implemented by an Integer (to read it)
        """
    def Integer(self) -> int: 
        """
        Gets the value as an Integer
        """
    def IsNull(self) -> bool: 
        """
        Returns True if there is no Stored Entity (i.e. it is Null)
        """
    def Logical(self) -> OCP.StepData.StepData_Logical: ...
    def Matches(self,ent : OCP.Standard.Standard_Transient) -> bool: 
        """
        Returns True if the Type of an Entity complies with the definition list of the SelectType. Also checks for a SelectMember Default Implementation looks for CaseNum or CaseMem positive
        """
    def Member(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns Value as a SelectMember. Null if not a SelectMember
        """
    def NewMember(self) -> OCP.StepData.StepData_SelectMember: 
        """
        Returns a preferred SelectMember. Default returns a Null By default, a SelectMember can be set according to data type and Name : it is a SelectNamed if Name is defined
        """
    def Nullify(self) -> None: 
        """
        Nullifies the Stored Entity
        """
    def Real(self) -> float: ...
    def SelectName(self) -> str: 
        """
        Returns the type name of SelectMember. If no SelectMember or with no type name, returns an empty string To change it, pass through the SelectMember itself
        """
    def SetBoolean(self,val : bool,name : str='') -> None: ...
    def SetInt(self,val : int) -> None: 
        """
        This internal method gives access to a value implemented by an Integer (to set it) : a SelectMember MUST ALREADY BE THERE !
        """
    def SetInteger(self,val : int,name : str='') -> None: 
        """
        Sets a new Integer value, with an optional type name Warning : If a SelectMember is already set, works on it : value and name must then be accepted by this SelectMember
        """
    def SetLogical(self,val : OCP.StepData.StepData_Logical,name : str='') -> None: ...
    def SetReal(self,val : float,name : str='') -> None: ...
    @overload
    def SetValue(self,ent : OCP.Standard.Standard_Transient) -> None: 
        """
        Stores an Entity. This allows to define a specific SelectType class with one read method per member Type, which returns the Value casted with the good Type.

        SetValue supporting python objects
        """
    @overload
    def SetValue(self,ent : object) -> None: ...
    def Type(self) -> OCP.Standard.Standard_Type: 
        """
        Returns the Effective (Dynamic) Type of the Stored Entity If it is Null, returns TYPE(Transient)
        """
    def Value(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the Stored Entity. Can be used to define specific read methods (see above)
        """
    def Vector(self) -> StepGeom_Vector: 
        """
        returns Value as a Vector (Null if another type)
        """
    def __init__(self) -> None: ...
    pass
StepGeom_bscfCircularArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfCircularArc: 1>
StepGeom_bscfEllipticArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfEllipticArc: 2>
StepGeom_bscfHyperbolicArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfHyperbolicArc: 4>
StepGeom_bscfParabolicArc: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfParabolicArc: 3>
StepGeom_bscfPolylineForm: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfPolylineForm: 0>
StepGeom_bscfUnspecified: OCP.StepGeom.StepGeom_BSplineCurveForm # value = <StepGeom_BSplineCurveForm.StepGeom_bscfUnspecified: 5>
StepGeom_bssfConicalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfConicalSurf: 2>
StepGeom_bssfCylindricalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfCylindricalSurf: 1>
StepGeom_bssfGeneralisedCone: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfGeneralisedCone: 7>
StepGeom_bssfPlaneSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfPlaneSurf: 0>
StepGeom_bssfQuadricSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfQuadricSurf: 8>
StepGeom_bssfRuledSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfRuledSurf: 6>
StepGeom_bssfSphericalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfSphericalSurf: 3>
StepGeom_bssfSurfOfLinearExtrusion: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfLinearExtrusion: 9>
StepGeom_bssfSurfOfRevolution: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfSurfOfRevolution: 5>
StepGeom_bssfToroidalSurf: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfToroidalSurf: 4>
StepGeom_bssfUnspecified: OCP.StepGeom.StepGeom_BSplineSurfaceForm # value = <StepGeom_BSplineSurfaceForm.StepGeom_bssfUnspecified: 10>
StepGeom_ktPiecewiseBezierKnots: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktPiecewiseBezierKnots: 3>
StepGeom_ktQuasiUniformKnots: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktQuasiUniformKnots: 2>
StepGeom_ktUniformKnots: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktUniformKnots: 0>
StepGeom_ktUnspecified: OCP.StepGeom.StepGeom_KnotType # value = <StepGeom_KnotType.StepGeom_ktUnspecified: 1>
StepGeom_pscrCurve3d: OCP.StepGeom.StepGeom_PreferredSurfaceCurveRepresentation # value = <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrCurve3d: 0>
StepGeom_pscrPcurveS1: OCP.StepGeom.StepGeom_PreferredSurfaceCurveRepresentation # value = <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS1: 1>
StepGeom_pscrPcurveS2: OCP.StepGeom.StepGeom_PreferredSurfaceCurveRepresentation # value = <StepGeom_PreferredSurfaceCurveRepresentation.StepGeom_pscrPcurveS2: 2>
StepGeom_tcContSameGradient: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcContSameGradient: 2>
StepGeom_tcContSameGradientSameCurvature: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcContSameGradientSameCurvature: 3>
StepGeom_tcContinuous: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcContinuous: 1>
StepGeom_tcDiscontinuous: OCP.StepGeom.StepGeom_TransitionCode # value = <StepGeom_TransitionCode.StepGeom_tcDiscontinuous: 0>
StepGeom_tpCartesian: OCP.StepGeom.StepGeom_TrimmingPreference # value = <StepGeom_TrimmingPreference.StepGeom_tpCartesian: 0>
StepGeom_tpParameter: OCP.StepGeom.StepGeom_TrimmingPreference # value = <StepGeom_TrimmingPreference.StepGeom_tpParameter: 1>
StepGeom_tpUnspecified: OCP.StepGeom.StepGeom_TrimmingPreference # value = <StepGeom_TrimmingPreference.StepGeom_tpUnspecified: 2>
