import OCP.StepToGeom
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.Geom
import OCP.gp
import OCP.TColStd
import OCP.StepGeom
import OCP.StepRepr
import OCP.Geom2d
__all__  = [
"StepToGeom"
]
class StepToGeom():
    """
    This class provides static methods to convert STEP geometric entities to OCCT. The methods returning handles will return null handle in case of error. The methods returning boolean will return True if succeeded and False if error.
    """
    @staticmethod
    def MakeAxis1Placement_s(SA : OCP.StepGeom.StepGeom_Axis1Placement,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Axis1Placement: ...
    @staticmethod
    @overload
    def MakeAxis2Placement_s(SA : OCP.StepGeom.StepGeom_Axis2Placement3d,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Axis2Placement: ...
    @staticmethod
    @overload
    def MakeAxis2Placement_s(SP : OCP.StepGeom.StepGeom_SuParameters) -> OCP.Geom.Geom_Axis2Placement: ...
    @staticmethod
    def MakeAxisPlacement_s(SA : OCP.StepGeom.StepGeom_Axis2Placement2d,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_AxisPlacement: ...
    @staticmethod
    def MakeBSplineCurve2d_s(SC : OCP.StepGeom.StepGeom_BSplineCurve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_BSplineCurve: ...
    @staticmethod
    def MakeBSplineCurve_s(SC : OCP.StepGeom.StepGeom_BSplineCurve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_BSplineCurve: ...
    @staticmethod
    def MakeBSplineSurface_s(SS : OCP.StepGeom.StepGeom_BSplineSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_BSplineSurface: ...
    @staticmethod
    def MakeBoundedCurve2d_s(SC : OCP.StepGeom.StepGeom_BoundedCurve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_BoundedCurve: ...
    @staticmethod
    def MakeBoundedCurve_s(SC : OCP.StepGeom.StepGeom_BoundedCurve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_BoundedCurve: ...
    @staticmethod
    def MakeBoundedSurface_s(SS : OCP.StepGeom.StepGeom_BoundedSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_BoundedSurface: ...
    @staticmethod
    def MakeCartesianPoint2d_s(SP : OCP.StepGeom.StepGeom_CartesianPoint,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_CartesianPoint: ...
    @staticmethod
    def MakeCartesianPoint_s(SP : OCP.StepGeom.StepGeom_CartesianPoint,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_CartesianPoint: ...
    @staticmethod
    def MakeCircle2d_s(SC : OCP.StepGeom.StepGeom_Circle,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_Circle: ...
    @staticmethod
    def MakeCircle_s(SC : OCP.StepGeom.StepGeom_Circle,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Circle: ...
    @staticmethod
    def MakeConic2d_s(SC : OCP.StepGeom.StepGeom_Conic,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_Conic: ...
    @staticmethod
    def MakeConic_s(SC : OCP.StepGeom.StepGeom_Conic,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Conic: ...
    @staticmethod
    def MakeConicalSurface_s(SS : OCP.StepGeom.StepGeom_ConicalSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_ConicalSurface: ...
    @staticmethod
    def MakeCurve2d_s(SC : OCP.StepGeom.StepGeom_Curve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_Curve: ...
    @staticmethod
    def MakeCurve_s(SC : OCP.StepGeom.StepGeom_Curve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Curve: ...
    @staticmethod
    def MakeCylindricalSurface_s(SS : OCP.StepGeom.StepGeom_CylindricalSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_CylindricalSurface: ...
    @staticmethod
    def MakeDirection2d_s(SD : OCP.StepGeom.StepGeom_Direction) -> OCP.Geom2d.Geom2d_Direction: ...
    @staticmethod
    def MakeDirection_s(SD : OCP.StepGeom.StepGeom_Direction) -> OCP.Geom.Geom_Direction: ...
    @staticmethod
    def MakeElementarySurface_s(SS : OCP.StepGeom.StepGeom_ElementarySurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_ElementarySurface: ...
    @staticmethod
    def MakeEllipse2d_s(SC : OCP.StepGeom.StepGeom_Ellipse,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_Ellipse: ...
    @staticmethod
    def MakeEllipse_s(SC : OCP.StepGeom.StepGeom_Ellipse,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Ellipse: ...
    @staticmethod
    def MakeHyperbola2d_s(SC : OCP.StepGeom.StepGeom_Hyperbola,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_Hyperbola: ...
    @staticmethod
    def MakeHyperbola_s(SC : OCP.StepGeom.StepGeom_Hyperbola,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Hyperbola: ...
    @staticmethod
    def MakeLine2d_s(SC : OCP.StepGeom.StepGeom_Line,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_Line: ...
    @staticmethod
    def MakeLine_s(SC : OCP.StepGeom.StepGeom_Line,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Line: ...
    @staticmethod
    def MakeParabola2d_s(SC : OCP.StepGeom.StepGeom_Parabola,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_Parabola: ...
    @staticmethod
    def MakeParabola_s(SC : OCP.StepGeom.StepGeom_Parabola,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Parabola: ...
    @staticmethod
    def MakePlane_s(SP : OCP.StepGeom.StepGeom_Plane,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Plane: ...
    @staticmethod
    def MakePolyline2d_s(SPL : OCP.StepGeom.StepGeom_Polyline,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_BSplineCurve: ...
    @staticmethod
    def MakePolyline_s(SPL : OCP.StepGeom.StepGeom_Polyline,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_BSplineCurve: ...
    @staticmethod
    def MakeRectangularTrimmedSurface_s(SS : OCP.StepGeom.StepGeom_RectangularTrimmedSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_RectangularTrimmedSurface: ...
    @staticmethod
    def MakeSphericalSurface_s(SS : OCP.StepGeom.StepGeom_SphericalSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_SphericalSurface: ...
    @staticmethod
    def MakeSurfaceOfLinearExtrusion_s(SS : OCP.StepGeom.StepGeom_SurfaceOfLinearExtrusion,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_SurfaceOfLinearExtrusion: ...
    @staticmethod
    def MakeSurfaceOfRevolution_s(SS : OCP.StepGeom.StepGeom_SurfaceOfRevolution,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_SurfaceOfRevolution: ...
    @staticmethod
    def MakeSurface_s(SS : OCP.StepGeom.StepGeom_Surface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_Surface: ...
    @staticmethod
    def MakeSweptSurface_s(SS : OCP.StepGeom.StepGeom_SweptSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_SweptSurface: ...
    @staticmethod
    def MakeToroidalSurface_s(SS : OCP.StepGeom.StepGeom_ToroidalSurface,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_ToroidalSurface: ...
    @staticmethod
    def MakeTransformation2d_s(SCTO : OCP.StepGeom.StepGeom_CartesianTransformationOperator2d,CT : OCP.gp.gp_Trsf2d,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> bool: ...
    @staticmethod
    def MakeTransformation3d_s(SCTO : OCP.StepGeom.StepGeom_CartesianTransformationOperator3d,CT : OCP.gp.gp_Trsf,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> bool: ...
    @staticmethod
    def MakeTrimmedCurve2d_s(SC : OCP.StepGeom.StepGeom_TrimmedCurve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom2d.Geom2d_BSplineCurve: ...
    @staticmethod
    def MakeTrimmedCurve_s(SC : OCP.StepGeom.StepGeom_TrimmedCurve,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_TrimmedCurve: ...
    @staticmethod
    def MakeVectorWithMagnitude2d_s(SV : OCP.StepGeom.StepGeom_Vector) -> OCP.Geom2d.Geom2d_VectorWithMagnitude: ...
    @staticmethod
    def MakeVectorWithMagnitude_s(SV : OCP.StepGeom.StepGeom_Vector,theLocalFactors : OCP.StepData.StepData_Factors=OCP.StepData.StepData_Factors) -> OCP.Geom.Geom_VectorWithMagnitude: ...
    @staticmethod
    def MakeYprRotation_s(SR : StepKinematics_SpatialRotation,theCntxt : OCP.StepRepr.StepRepr_GlobalUnitAssignedContext) -> OCP.TColStd.TColStd_HArray1OfReal: ...
    def __init__(self) -> None: ...
    pass
