
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Axis1Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <Geom_BoundedCurve.hxx>
#include <Geom_BoundedSurface.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Geom_CartesianPoint.hxx>
#include <Geom_Circle.hxx>
#include <Geom_Conic.hxx>
#include <Geom_ConicalSurface.hxx>
#include <Geom_Curve.hxx>
#include <Geom_CylindricalSurface.hxx>
#include <Geom_Direction.hxx>
#include <Geom_ElementarySurface.hxx>
#include <Geom_Ellipse.hxx>
#include <Geom_Hyperbola.hxx>
#include <Geom_Line.hxx>
#include <Geom_Parabola.hxx>
#include <Geom_Plane.hxx>
#include <Geom_RectangularTrimmedSurface.hxx>
#include <Geom_SphericalSurface.hxx>
#include <Geom_Surface.hxx>
#include <Geom_SurfaceOfLinearExtrusion.hxx>
#include <Geom_SurfaceOfRevolution.hxx>
#include <Geom_SweptSurface.hxx>
#include <Geom_ToroidalSurface.hxx>
#include <Geom_TrimmedCurve.hxx>
#include <Geom_VectorWithMagnitude.hxx>
#include <Geom2d_AxisPlacement.hxx>
#include <Geom2d_BoundedCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Geom2d_CartesianPoint.hxx>
#include <Geom2d_Circle.hxx>
#include <Geom2d_Conic.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom2d_Direction.hxx>
#include <Geom2d_Ellipse.hxx>
#include <Geom2d_Hyperbola.hxx>
#include <Geom2d_Line.hxx>
#include <Geom2d_Parabola.hxx>
#include <Geom2d_VectorWithMagnitude.hxx>
#include <gp_Trsf.hxx>
#include <gp_Trsf2d.hxx>
#include <StepGeom_Axis1Placement.hxx>
#include <StepGeom_Axis2Placement2d.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <StepGeom_BoundedCurve.hxx>
#include <StepGeom_BoundedSurface.hxx>
#include <StepGeom_BSplineCurve.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepGeom_Direction.hxx>
#include <StepGeom_BSplineSurface.hxx>
#include <StepGeom_Circle.hxx>
#include <StepGeom_Conic.hxx>
#include <StepGeom_ConicalSurface.hxx>
#include <StepGeom_Curve.hxx>
#include <StepGeom_CylindricalSurface.hxx>
#include <StepGeom_ElementarySurface.hxx>
#include <StepGeom_Ellipse.hxx>
#include <StepGeom_Hyperbola.hxx>
#include <StepGeom_Line.hxx>
#include <StepGeom_Parabola.hxx>
#include <StepGeom_Plane.hxx>
#include <StepGeom_Polyline.hxx>
#include <StepGeom_RectangularTrimmedSurface.hxx>
#include <StepGeom_SphericalSurface.hxx>
#include <StepGeom_Surface.hxx>
#include <StepGeom_SurfaceOfLinearExtrusion.hxx>
#include <StepGeom_SurfaceOfRevolution.hxx>
#include <StepGeom_SweptSurface.hxx>
#include <StepGeom_ToroidalSurface.hxx>
#include <StepGeom_CartesianTransformationOperator2d.hxx>
#include <StepGeom_CartesianTransformationOperator3d.hxx>
#include <StepGeom_TrimmedCurve.hxx>
#include <StepGeom_Vector.hxx>
#include <StepGeom_SuParameters.hxx>
#include <StepRepr_GlobalUnitAssignedContext.hxx>
#include <TColStd_HArray1OfReal.hxx>

// module includes
#include <StepToGeom.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <StepKinematics_SpatialRotation.hxx>

// Module definiiton
void register_StepToGeom(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StepToGeom"));
py::object klass;

//Python trampoline classes

// classes

    // Class StepToGeom from ./opencascade/StepToGeom.hxx
    klass = m.attr("StepToGeom");

    // default constructor
    register_default_constructor<StepToGeom , shared_ptr<StepToGeom>>(m,"StepToGeom");

    // nested enums

    static_cast<py::class_<StepToGeom , shared_ptr<StepToGeom>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("MakeAxis1Placement_s",
                    (handle<Geom_Axis1Placement> (*)(  const handle<StepGeom_Axis1Placement> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Axis1Placement> (*)(  const handle<StepGeom_Axis1Placement> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeAxis1Placement),
                    R"#()#"  , py::arg("SA"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeAxis2Placement_s",
                    (handle<Geom_Axis2Placement> (*)(  const handle<StepGeom_Axis2Placement3d> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Axis2Placement> (*)(  const handle<StepGeom_Axis2Placement3d> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeAxis2Placement),
                    R"#()#"  , py::arg("SA"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeAxis2Placement_s",
                    (handle<Geom_Axis2Placement> (*)(  const handle<StepGeom_SuParameters> &  ) ) static_cast<handle<Geom_Axis2Placement> (*)(  const handle<StepGeom_SuParameters> &  ) >(&StepToGeom::MakeAxis2Placement),
                    R"#()#"  , py::arg("SP")
          )
        .def_static("MakeAxisPlacement_s",
                    (handle<Geom2d_AxisPlacement> (*)(  const handle<StepGeom_Axis2Placement2d> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_AxisPlacement> (*)(  const handle<StepGeom_Axis2Placement2d> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeAxisPlacement),
                    R"#()#"  , py::arg("SA"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeBoundedCurve_s",
                    (handle<Geom_BoundedCurve> (*)(  const handle<StepGeom_BoundedCurve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_BoundedCurve> (*)(  const handle<StepGeom_BoundedCurve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeBoundedCurve),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeBoundedCurve2d_s",
                    (handle<Geom2d_BoundedCurve> (*)(  const handle<StepGeom_BoundedCurve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_BoundedCurve> (*)(  const handle<StepGeom_BoundedCurve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeBoundedCurve2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeBoundedSurface_s",
                    (handle<Geom_BoundedSurface> (*)(  const handle<StepGeom_BoundedSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_BoundedSurface> (*)(  const handle<StepGeom_BoundedSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeBoundedSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeBSplineCurve_s",
                    (handle<Geom_BSplineCurve> (*)(  const handle<StepGeom_BSplineCurve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_BSplineCurve> (*)(  const handle<StepGeom_BSplineCurve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeBSplineCurve),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeBSplineCurve2d_s",
                    (handle<Geom2d_BSplineCurve> (*)(  const handle<StepGeom_BSplineCurve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_BSplineCurve> (*)(  const handle<StepGeom_BSplineCurve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeBSplineCurve2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeBSplineSurface_s",
                    (handle<Geom_BSplineSurface> (*)(  const handle<StepGeom_BSplineSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_BSplineSurface> (*)(  const handle<StepGeom_BSplineSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeBSplineSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeCartesianPoint_s",
                    (handle<Geom_CartesianPoint> (*)(  const handle<StepGeom_CartesianPoint> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_CartesianPoint> (*)(  const handle<StepGeom_CartesianPoint> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeCartesianPoint),
                    R"#()#"  , py::arg("SP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeCartesianPoint2d_s",
                    (handle<Geom2d_CartesianPoint> (*)(  const handle<StepGeom_CartesianPoint> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_CartesianPoint> (*)(  const handle<StepGeom_CartesianPoint> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeCartesianPoint2d),
                    R"#()#"  , py::arg("SP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeCircle_s",
                    (handle<Geom_Circle> (*)(  const handle<StepGeom_Circle> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Circle> (*)(  const handle<StepGeom_Circle> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeCircle),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeCircle2d_s",
                    (handle<Geom2d_Circle> (*)(  const handle<StepGeom_Circle> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_Circle> (*)(  const handle<StepGeom_Circle> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeCircle2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeConic_s",
                    (handle<Geom_Conic> (*)(  const handle<StepGeom_Conic> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Conic> (*)(  const handle<StepGeom_Conic> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeConic),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeConic2d_s",
                    (handle<Geom2d_Conic> (*)(  const handle<StepGeom_Conic> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_Conic> (*)(  const handle<StepGeom_Conic> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeConic2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeConicalSurface_s",
                    (handle<Geom_ConicalSurface> (*)(  const handle<StepGeom_ConicalSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_ConicalSurface> (*)(  const handle<StepGeom_ConicalSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeConicalSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeCurve_s",
                    (handle<Geom_Curve> (*)(  const handle<StepGeom_Curve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Curve> (*)(  const handle<StepGeom_Curve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeCurve),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeCurve2d_s",
                    (handle<Geom2d_Curve> (*)(  const handle<StepGeom_Curve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_Curve> (*)(  const handle<StepGeom_Curve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeCurve2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeCylindricalSurface_s",
                    (handle<Geom_CylindricalSurface> (*)(  const handle<StepGeom_CylindricalSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_CylindricalSurface> (*)(  const handle<StepGeom_CylindricalSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeCylindricalSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeDirection_s",
                    (handle<Geom_Direction> (*)(  const handle<StepGeom_Direction> &  ) ) static_cast<handle<Geom_Direction> (*)(  const handle<StepGeom_Direction> &  ) >(&StepToGeom::MakeDirection),
                    R"#()#"  , py::arg("SD")
          )
        .def_static("MakeDirection2d_s",
                    (handle<Geom2d_Direction> (*)(  const handle<StepGeom_Direction> &  ) ) static_cast<handle<Geom2d_Direction> (*)(  const handle<StepGeom_Direction> &  ) >(&StepToGeom::MakeDirection2d),
                    R"#()#"  , py::arg("SD")
          )
        .def_static("MakeElementarySurface_s",
                    (handle<Geom_ElementarySurface> (*)(  const handle<StepGeom_ElementarySurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_ElementarySurface> (*)(  const handle<StepGeom_ElementarySurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeElementarySurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeEllipse_s",
                    (handle<Geom_Ellipse> (*)(  const handle<StepGeom_Ellipse> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Ellipse> (*)(  const handle<StepGeom_Ellipse> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeEllipse),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeEllipse2d_s",
                    (handle<Geom2d_Ellipse> (*)(  const handle<StepGeom_Ellipse> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_Ellipse> (*)(  const handle<StepGeom_Ellipse> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeEllipse2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeHyperbola_s",
                    (handle<Geom_Hyperbola> (*)(  const handle<StepGeom_Hyperbola> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Hyperbola> (*)(  const handle<StepGeom_Hyperbola> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeHyperbola),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeHyperbola2d_s",
                    (handle<Geom2d_Hyperbola> (*)(  const handle<StepGeom_Hyperbola> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_Hyperbola> (*)(  const handle<StepGeom_Hyperbola> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeHyperbola2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeLine_s",
                    (handle<Geom_Line> (*)(  const handle<StepGeom_Line> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Line> (*)(  const handle<StepGeom_Line> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeLine),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeLine2d_s",
                    (handle<Geom2d_Line> (*)(  const handle<StepGeom_Line> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_Line> (*)(  const handle<StepGeom_Line> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeLine2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeParabola_s",
                    (handle<Geom_Parabola> (*)(  const handle<StepGeom_Parabola> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Parabola> (*)(  const handle<StepGeom_Parabola> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeParabola),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeParabola2d_s",
                    (handle<Geom2d_Parabola> (*)(  const handle<StepGeom_Parabola> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_Parabola> (*)(  const handle<StepGeom_Parabola> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeParabola2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakePlane_s",
                    (handle<Geom_Plane> (*)(  const handle<StepGeom_Plane> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Plane> (*)(  const handle<StepGeom_Plane> & ,   const StepData_Factors &  ) >(&StepToGeom::MakePlane),
                    R"#()#"  , py::arg("SP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakePolyline_s",
                    (handle<Geom_BSplineCurve> (*)(  const handle<StepGeom_Polyline> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_BSplineCurve> (*)(  const handle<StepGeom_Polyline> & ,   const StepData_Factors &  ) >(&StepToGeom::MakePolyline),
                    R"#()#"  , py::arg("SPL"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakePolyline2d_s",
                    (handle<Geom2d_BSplineCurve> (*)(  const handle<StepGeom_Polyline> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_BSplineCurve> (*)(  const handle<StepGeom_Polyline> & ,   const StepData_Factors &  ) >(&StepToGeom::MakePolyline2d),
                    R"#()#"  , py::arg("SPL"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeRectangularTrimmedSurface_s",
                    (handle<Geom_RectangularTrimmedSurface> (*)(  const handle<StepGeom_RectangularTrimmedSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_RectangularTrimmedSurface> (*)(  const handle<StepGeom_RectangularTrimmedSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeRectangularTrimmedSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeSphericalSurface_s",
                    (handle<Geom_SphericalSurface> (*)(  const handle<StepGeom_SphericalSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_SphericalSurface> (*)(  const handle<StepGeom_SphericalSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeSphericalSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeSurface_s",
                    (handle<Geom_Surface> (*)(  const handle<StepGeom_Surface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_Surface> (*)(  const handle<StepGeom_Surface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeSurfaceOfLinearExtrusion_s",
                    (handle<Geom_SurfaceOfLinearExtrusion> (*)(  const handle<StepGeom_SurfaceOfLinearExtrusion> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_SurfaceOfLinearExtrusion> (*)(  const handle<StepGeom_SurfaceOfLinearExtrusion> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeSurfaceOfLinearExtrusion),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeSurfaceOfRevolution_s",
                    (handle<Geom_SurfaceOfRevolution> (*)(  const handle<StepGeom_SurfaceOfRevolution> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_SurfaceOfRevolution> (*)(  const handle<StepGeom_SurfaceOfRevolution> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeSurfaceOfRevolution),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeSweptSurface_s",
                    (handle<Geom_SweptSurface> (*)(  const handle<StepGeom_SweptSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_SweptSurface> (*)(  const handle<StepGeom_SweptSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeSweptSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeToroidalSurface_s",
                    (handle<Geom_ToroidalSurface> (*)(  const handle<StepGeom_ToroidalSurface> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_ToroidalSurface> (*)(  const handle<StepGeom_ToroidalSurface> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeToroidalSurface),
                    R"#()#"  , py::arg("SS"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeTransformation2d_s",
                    (Standard_Boolean (*)(  const handle<StepGeom_CartesianTransformationOperator2d> & ,  gp_Trsf2d & ,   const StepData_Factors &  ) ) static_cast<Standard_Boolean (*)(  const handle<StepGeom_CartesianTransformationOperator2d> & ,  gp_Trsf2d & ,   const StepData_Factors &  ) >(&StepToGeom::MakeTransformation2d),
                    R"#()#"  , py::arg("SCTO"),  py::arg("CT"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeTransformation3d_s",
                    (Standard_Boolean (*)(  const handle<StepGeom_CartesianTransformationOperator3d> & ,  gp_Trsf & ,   const StepData_Factors &  ) ) static_cast<Standard_Boolean (*)(  const handle<StepGeom_CartesianTransformationOperator3d> & ,  gp_Trsf & ,   const StepData_Factors &  ) >(&StepToGeom::MakeTransformation3d),
                    R"#()#"  , py::arg("SCTO"),  py::arg("CT"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeTrimmedCurve_s",
                    (handle<Geom_TrimmedCurve> (*)(  const handle<StepGeom_TrimmedCurve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_TrimmedCurve> (*)(  const handle<StepGeom_TrimmedCurve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeTrimmedCurve),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeTrimmedCurve2d_s",
                    (handle<Geom2d_BSplineCurve> (*)(  const handle<StepGeom_TrimmedCurve> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom2d_BSplineCurve> (*)(  const handle<StepGeom_TrimmedCurve> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeTrimmedCurve2d),
                    R"#()#"  , py::arg("SC"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeVectorWithMagnitude_s",
                    (handle<Geom_VectorWithMagnitude> (*)(  const handle<StepGeom_Vector> & ,   const StepData_Factors &  ) ) static_cast<handle<Geom_VectorWithMagnitude> (*)(  const handle<StepGeom_Vector> & ,   const StepData_Factors &  ) >(&StepToGeom::MakeVectorWithMagnitude),
                    R"#()#"  , py::arg("SV"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def_static("MakeVectorWithMagnitude2d_s",
                    (handle<Geom2d_VectorWithMagnitude> (*)(  const handle<StepGeom_Vector> &  ) ) static_cast<handle<Geom2d_VectorWithMagnitude> (*)(  const handle<StepGeom_Vector> &  ) >(&StepToGeom::MakeVectorWithMagnitude2d),
                    R"#()#"  , py::arg("SV")
          )
        .def_static("MakeYprRotation_s",
                    (handle<TColStd_HArray1OfReal> (*)(  const StepKinematics_SpatialRotation & ,   const handle<StepRepr_GlobalUnitAssignedContext> &  ) ) static_cast<handle<TColStd_HArray1OfReal> (*)(  const StepKinematics_SpatialRotation & ,   const handle<StepRepr_GlobalUnitAssignedContext> &  ) >(&StepToGeom::MakeYprRotation),
                    R"#()#"  , py::arg("SR"),  py::arg("theCntxt")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/StepToGeom.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
