
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>

#include <StepData_Factors.hxx>

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_HAsciiString.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_ManifoldSolidBrep.hxx>
#include <Transfer_TransientProcess.hxx>
#include <StepShape_BrepWithVoids.hxx>
#include <StepShape_FacetedBrep.hxx>
#include <StepShape_FacetedBrepAndBrepWithVoids.hxx>
#include <StepShape_ShellBasedSurfaceModel.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <StepShape_GeometricSet.hxx>
#include <StepShape_EdgeBasedWireframeModel.hxx>
#include <StepShape_FaceBasedSurfaceModel.hxx>
#include <StepVisual_TessellatedFace.hxx>
#include <StepVisual_TessellatedShell.hxx>
#include <StepVisual_TessellatedSolid.hxx>
#include <StepVisual_TessellatedSurfaceSet.hxx>
#include <Transfer_ActorOfTransientProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepGeom_SurfaceCurve.hxx>
#include <StepGeom_Surface.hxx>
#include <StepGeom_Pcurve.hxx>
#include <StepShape_Edge.hxx>
#include <StepShape_EdgeLoop.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <StepGeom_CartesianTransformationOperator3d.hxx>
#include <TopoDS_Shape.hxx>
#include <StepRepr_MappedItem.hxx>
#include <Transfer_TransientProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Transfer_TransientProcess.hxx>
#include <Geom_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepGeom_CompositeCurve.hxx>
#include <Transfer_TransientProcess.hxx>
#include <StepGeom_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepGeom_CurveBoundedSurface.hxx>
#include <Transfer_TransientProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_Edge.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <StepGeom_Curve.hxx>
#include <StepShape_EdgeCurve.hxx>
#include <StepShape_Vertex.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <Geom2d_Curve.hxx>
#include <StepGeom_Pcurve.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_FaceBound.hxx>
#include <TopoDS_Face.hxx>
#include <Geom_Surface.hxx>
#include <StepGeom_Surface.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_Triangulation.hxx>
#include <StepShape_FaceSurface.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <StepVisual_ComplexTriangulatedFace.hxx>
#include <StepVisual_TessellatedFace.hxx>
#include <StepVisual_TessellatedItem.hxx>
#include <StepVisual_TessellatedSurfaceSet.hxx>
#include <StepVisual_TriangulatedFace.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_PolyLoop.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <Geom_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_ConnectedFaceSet.hxx>
#include <StepVisual_TessellatedShell.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_ConnectedFaceSet.hxx>
#include <StepVisual_TessellatedSolid.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <Transfer_TransientProcess.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_Vertex.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepShape_VertexLoop.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <StepToTopoDS.hxx>
#include <StepToTopoDS_Builder.hxx>
#include <StepToTopoDS_BuilderError.hxx>
#include <StepToTopoDS_DataMapIteratorOfDataMapOfRI.hxx>
#include <StepToTopoDS_DataMapIteratorOfDataMapOfRINames.hxx>
#include <StepToTopoDS_DataMapIteratorOfDataMapOfTRI.hxx>
#include <StepToTopoDS_DataMapIteratorOfPointEdgeMap.hxx>
#include <StepToTopoDS_DataMapIteratorOfPointVertexMap.hxx>
#include <StepToTopoDS_DataMapOfRI.hxx>
#include <StepToTopoDS_DataMapOfRINames.hxx>
#include <StepToTopoDS_DataMapOfTRI.hxx>
#include <StepToTopoDS_GeometricTool.hxx>
#include <StepToTopoDS_GeometricToolError.hxx>
#include <StepToTopoDS_MakeTransformed.hxx>
#include <StepToTopoDS_NMTool.hxx>
#include <StepToTopoDS_PointEdgeMap.hxx>
#include <StepToTopoDS_PointPair.hxx>
#include <StepToTopoDS_PointVertexMap.hxx>
#include <StepToTopoDS_Root.hxx>
#include <StepToTopoDS_Tool.hxx>
#include <StepToTopoDS_TranslateCompositeCurve.hxx>
#include <StepToTopoDS_TranslateCurveBoundedSurface.hxx>
#include <StepToTopoDS_TranslateEdge.hxx>
#include <StepToTopoDS_TranslateEdgeError.hxx>
#include <StepToTopoDS_TranslateEdgeLoop.hxx>
#include <StepToTopoDS_TranslateEdgeLoopError.hxx>
#include <StepToTopoDS_TranslateFace.hxx>
#include <StepToTopoDS_TranslateFaceError.hxx>
#include <StepToTopoDS_TranslatePolyLoop.hxx>
#include <StepToTopoDS_TranslatePolyLoopError.hxx>
#include <StepToTopoDS_TranslateShell.hxx>
#include <StepToTopoDS_TranslateShellError.hxx>
#include <StepToTopoDS_TranslateSolid.hxx>
#include <StepToTopoDS_TranslateSolidError.hxx>
#include <StepToTopoDS_TranslateVertex.hxx>
#include <StepToTopoDS_TranslateVertexError.hxx>
#include <StepToTopoDS_TranslateVertexLoop.hxx>
#include <StepToTopoDS_TranslateVertexLoopError.hxx>

// template related includes

// ./opencascade/StepToTopoDS_DataMapOfRI.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_DataMapOfRI.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_DataMapOfRINames.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_DataMapOfRINames.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_DataMapOfTRI.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_DataMapOfTRI.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_PointEdgeMap.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_PointEdgeMap.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_PointVertexMap.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/StepToTopoDS_PointVertexMap.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_StepToTopoDS(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StepToTopoDS"));
py::object klass;

//Python trampoline classes

// classes

    // Class StepToTopoDS from ./opencascade/StepToTopoDS.hxx
    klass = m.attr("StepToTopoDS");

    // default constructor
    register_default_constructor<StepToTopoDS , shared_ptr<StepToTopoDS>>(m,"StepToTopoDS");

    // nested enums

    static_cast<py::class_<StepToTopoDS , shared_ptr<StepToTopoDS>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DecodeBuilderError_s",
                    (handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_BuilderError  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_BuilderError  ) >(&StepToTopoDS::DecodeBuilderError),
                    R"#()#"  , py::arg("Error")
          )
        .def_static("DecodeShellError_s",
                    (handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateShellError  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateShellError  ) >(&StepToTopoDS::DecodeShellError),
                    R"#()#"  , py::arg("Error")
          )
        .def_static("DecodeFaceError_s",
                    (handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateFaceError  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateFaceError  ) >(&StepToTopoDS::DecodeFaceError),
                    R"#()#"  , py::arg("Error")
          )
        .def_static("DecodeEdgeError_s",
                    (handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateEdgeError  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateEdgeError  ) >(&StepToTopoDS::DecodeEdgeError),
                    R"#()#"  , py::arg("Error")
          )
        .def_static("DecodeVertexError_s",
                    (handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateVertexError  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateVertexError  ) >(&StepToTopoDS::DecodeVertexError),
                    R"#()#"  , py::arg("Error")
          )
        .def_static("DecodeVertexLoopError_s",
                    (handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateVertexLoopError  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslateVertexLoopError  ) >(&StepToTopoDS::DecodeVertexLoopError),
                    R"#()#"  , py::arg("Error")
          )
        .def_static("DecodePolyLoopError_s",
                    (handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslatePolyLoopError  ) ) static_cast<handle<TCollection_HAsciiString> (*)(  const StepToTopoDS_TranslatePolyLoopError  ) >(&StepToTopoDS::DecodePolyLoopError),
                    R"#()#"  , py::arg("Error")
          )
        .def_static("DecodeGeometricToolError_s",
                    (Standard_CString (*)(  const StepToTopoDS_GeometricToolError  ) ) static_cast<Standard_CString (*)(  const StepToTopoDS_GeometricToolError  ) >(&StepToTopoDS::DecodeGeometricToolError),
                    R"#()#"  , py::arg("Error")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StepToTopoDS_GeometricTool from ./opencascade/StepToTopoDS_GeometricTool.hxx
    klass = m.attr("StepToTopoDS_GeometricTool");

    // default constructor
    register_default_constructor<StepToTopoDS_GeometricTool , shared_ptr<StepToTopoDS_GeometricTool>>(m,"StepToTopoDS_GeometricTool");

    // nested enums

    static_cast<py::class_<StepToTopoDS_GeometricTool , shared_ptr<StepToTopoDS_GeometricTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("PCurve_s",
                    (Standard_Integer (*)(  const handle<StepGeom_SurfaceCurve> & ,   const handle<StepGeom_Surface> & ,  handle<StepGeom_Pcurve> & ,   const Standard_Integer  ) ) static_cast<Standard_Integer (*)(  const handle<StepGeom_SurfaceCurve> & ,   const handle<StepGeom_Surface> & ,  handle<StepGeom_Pcurve> & ,   const Standard_Integer  ) >(&StepToTopoDS_GeometricTool::PCurve),
                    R"#()#"  , py::arg("SC"),  py::arg("S"),  py::arg("PC"),  py::arg("last")=static_cast< const Standard_Integer>(0)
          )
        .def_static("IsSeamCurve_s",
                    (Standard_Boolean (*)(  const handle<StepGeom_SurfaceCurve> & ,   const handle<StepGeom_Surface> & ,   const handle<StepShape_Edge> & ,   const handle<StepShape_EdgeLoop> &  ) ) static_cast<Standard_Boolean (*)(  const handle<StepGeom_SurfaceCurve> & ,   const handle<StepGeom_Surface> & ,   const handle<StepShape_Edge> & ,   const handle<StepShape_EdgeLoop> &  ) >(&StepToTopoDS_GeometricTool::IsSeamCurve),
                    R"#()#"  , py::arg("SC"),  py::arg("S"),  py::arg("E"),  py::arg("EL")
          )
        .def_static("IsLikeSeam_s",
                    (Standard_Boolean (*)(  const handle<StepGeom_SurfaceCurve> & ,   const handle<StepGeom_Surface> & ,   const handle<StepShape_Edge> & ,   const handle<StepShape_EdgeLoop> &  ) ) static_cast<Standard_Boolean (*)(  const handle<StepGeom_SurfaceCurve> & ,   const handle<StepGeom_Surface> & ,   const handle<StepShape_Edge> & ,   const handle<StepShape_EdgeLoop> &  ) >(&StepToTopoDS_GeometricTool::IsLikeSeam),
                    R"#()#"  , py::arg("SC"),  py::arg("S"),  py::arg("E"),  py::arg("EL")
          )
        .def_static("UpdateParam3d_s",
                    (Standard_Boolean (*)(  const handle<Geom_Curve> & ,  Standard_Real & ,  Standard_Real & ,   const Standard_Real  ) ) static_cast<Standard_Boolean (*)(  const handle<Geom_Curve> & ,  Standard_Real & ,  Standard_Real & ,   const Standard_Real  ) >(&StepToTopoDS_GeometricTool::UpdateParam3d),
                    R"#()#"  , py::arg("C"),  py::arg("w1"),  py::arg("w2"),  py::arg("preci")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StepToTopoDS_NMTool from ./opencascade/StepToTopoDS_NMTool.hxx
    klass = m.attr("StepToTopoDS_NMTool");


    // nested enums

    static_cast<py::class_<StepToTopoDS_NMTool , shared_ptr<StepToTopoDS_NMTool>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const StepToTopoDS_DataMapOfRI &, const StepToTopoDS_DataMapOfRINames & >()  , py::arg("MapOfRI"),  py::arg("MapOfRINames") )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_NMTool::*)(  const StepToTopoDS_DataMapOfRI & ,   const StepToTopoDS_DataMapOfRINames &  ) ) static_cast<void (StepToTopoDS_NMTool::*)(  const StepToTopoDS_DataMapOfRI & ,   const StepToTopoDS_DataMapOfRINames &  ) >(&StepToTopoDS_NMTool::Init),
             R"#()#"  , py::arg("MapOfRI"),  py::arg("MapOfRINames")
          )
        .def("SetActive",
             (void (StepToTopoDS_NMTool::*)(  const Standard_Boolean  ) ) static_cast<void (StepToTopoDS_NMTool::*)(  const Standard_Boolean  ) >(&StepToTopoDS_NMTool::SetActive),
             R"#()#"  , py::arg("isActive")
          )
        .def("IsActive",
             (Standard_Boolean (StepToTopoDS_NMTool::*)() ) static_cast<Standard_Boolean (StepToTopoDS_NMTool::*)() >(&StepToTopoDS_NMTool::IsActive),
             R"#()#" 
          )
        .def("CleanUp",
             (void (StepToTopoDS_NMTool::*)() ) static_cast<void (StepToTopoDS_NMTool::*)() >(&StepToTopoDS_NMTool::CleanUp),
             R"#()#" 
          )
        .def("IsBound",
             (Standard_Boolean (StepToTopoDS_NMTool::*)(  const handle<StepRepr_RepresentationItem> &  ) ) static_cast<Standard_Boolean (StepToTopoDS_NMTool::*)(  const handle<StepRepr_RepresentationItem> &  ) >(&StepToTopoDS_NMTool::IsBound),
             R"#()#"  , py::arg("RI")
          )
        .def("IsBound",
             (Standard_Boolean (StepToTopoDS_NMTool::*)(  const TCollection_AsciiString &  ) ) static_cast<Standard_Boolean (StepToTopoDS_NMTool::*)(  const TCollection_AsciiString &  ) >(&StepToTopoDS_NMTool::IsBound),
             R"#()#"  , py::arg("RIName")
          )
        .def("Bind",
             (void (StepToTopoDS_NMTool::*)(  const handle<StepRepr_RepresentationItem> & ,   const TopoDS_Shape &  ) ) static_cast<void (StepToTopoDS_NMTool::*)(  const handle<StepRepr_RepresentationItem> & ,   const TopoDS_Shape &  ) >(&StepToTopoDS_NMTool::Bind),
             R"#()#"  , py::arg("RI"),  py::arg("S")
          )
        .def("Bind",
             (void (StepToTopoDS_NMTool::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape &  ) ) static_cast<void (StepToTopoDS_NMTool::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape &  ) >(&StepToTopoDS_NMTool::Bind),
             R"#()#"  , py::arg("RIName"),  py::arg("S")
          )
        .def("Find",
             ( const TopoDS_Shape & (StepToTopoDS_NMTool::*)(  const handle<StepRepr_RepresentationItem> &  ) ) static_cast< const TopoDS_Shape & (StepToTopoDS_NMTool::*)(  const handle<StepRepr_RepresentationItem> &  ) >(&StepToTopoDS_NMTool::Find),
             R"#()#"  , py::arg("RI")
          )
        .def("Find",
             ( const TopoDS_Shape & (StepToTopoDS_NMTool::*)(  const TCollection_AsciiString &  ) ) static_cast< const TopoDS_Shape & (StepToTopoDS_NMTool::*)(  const TCollection_AsciiString &  ) >(&StepToTopoDS_NMTool::Find),
             R"#()#"  , py::arg("RIName")
          )
        .def("RegisterNMEdge",
             (void (StepToTopoDS_NMTool::*)(  const TopoDS_Shape &  ) ) static_cast<void (StepToTopoDS_NMTool::*)(  const TopoDS_Shape &  ) >(&StepToTopoDS_NMTool::RegisterNMEdge),
             R"#()#"  , py::arg("Edge")
          )
        .def("IsSuspectedAsClosing",
             (Standard_Boolean (StepToTopoDS_NMTool::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (StepToTopoDS_NMTool::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&StepToTopoDS_NMTool::IsSuspectedAsClosing),
             R"#()#"  , py::arg("BaseShell"),  py::arg("SuspectedShell")
          )
        .def("IsPureNMShell",
             (Standard_Boolean (StepToTopoDS_NMTool::*)(  const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (StepToTopoDS_NMTool::*)(  const TopoDS_Shape &  ) >(&StepToTopoDS_NMTool::IsPureNMShell),
             R"#()#"  , py::arg("Shell")
          )
        .def("SetIDEASCase",
             (void (StepToTopoDS_NMTool::*)(  const Standard_Boolean  ) ) static_cast<void (StepToTopoDS_NMTool::*)(  const Standard_Boolean  ) >(&StepToTopoDS_NMTool::SetIDEASCase),
             R"#()#"  , py::arg("IDEASCase")
          )
        .def("IsIDEASCase",
             (Standard_Boolean (StepToTopoDS_NMTool::*)() ) static_cast<Standard_Boolean (StepToTopoDS_NMTool::*)() >(&StepToTopoDS_NMTool::IsIDEASCase),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StepToTopoDS_PointPair from ./opencascade/StepToTopoDS_PointPair.hxx
    klass = m.attr("StepToTopoDS_PointPair");


    // nested enums

    static_cast<py::class_<StepToTopoDS_PointPair , shared_ptr<StepToTopoDS_PointPair>  >>(klass)
    // constructors
        .def(py::init<  const handle<StepGeom_CartesianPoint> &, const handle<StepGeom_CartesianPoint> & >()  , py::arg("P1"),  py::arg("P2") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetPoint1",
             ( const handle<StepGeom_CartesianPoint> & (StepToTopoDS_PointPair::*)() const) static_cast< const handle<StepGeom_CartesianPoint> & (StepToTopoDS_PointPair::*)() const>(&StepToTopoDS_PointPair::GetPoint1),
             R"#()#"
             
         )
       .def("GetPoint2",
             ( const handle<StepGeom_CartesianPoint> & (StepToTopoDS_PointPair::*)() const) static_cast< const handle<StepGeom_CartesianPoint> & (StepToTopoDS_PointPair::*)() const>(&StepToTopoDS_PointPair::GetPoint2),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_Root from ./opencascade/StepToTopoDS_Root.hxx
    klass = m.attr("StepToTopoDS_Root");


    // nested enums

    static_cast<py::class_<StepToTopoDS_Root , shared_ptr<StepToTopoDS_Root>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsDone",
             (Standard_Boolean (StepToTopoDS_Root::*)() const) static_cast<Standard_Boolean (StepToTopoDS_Root::*)() const>(&StepToTopoDS_Root::IsDone),
             R"#()#" 
          )
        .def("Precision",
             (Standard_Real (StepToTopoDS_Root::*)() const) static_cast<Standard_Real (StepToTopoDS_Root::*)() const>(&StepToTopoDS_Root::Precision),
             R"#(Returns the value of "MyPrecision")#" 
          )
        .def("SetPrecision",
             (void (StepToTopoDS_Root::*)(  const Standard_Real  ) ) static_cast<void (StepToTopoDS_Root::*)(  const Standard_Real  ) >(&StepToTopoDS_Root::SetPrecision),
             R"#(Sets the value of "MyPrecision")#"  , py::arg("preci")
          )
        .def("MaxTol",
             (Standard_Real (StepToTopoDS_Root::*)() const) static_cast<Standard_Real (StepToTopoDS_Root::*)() const>(&StepToTopoDS_Root::MaxTol),
             R"#(Returns the value of "MaxTol")#" 
          )
        .def("SetMaxTol",
             (void (StepToTopoDS_Root::*)(  const Standard_Real  ) ) static_cast<void (StepToTopoDS_Root::*)(  const Standard_Real  ) >(&StepToTopoDS_Root::SetMaxTol),
             R"#(Sets the value of MaxTol)#"  , py::arg("maxpreci")
          )
        .def("IsDone",
             (Standard_Boolean (StepToTopoDS_Root::*)() const) static_cast<Standard_Boolean (StepToTopoDS_Root::*)() const>(&StepToTopoDS_Root::IsDone),
             R"#()#" 
          )
        .def("Precision",
             (Standard_Real (StepToTopoDS_Root::*)() const) static_cast<Standard_Real (StepToTopoDS_Root::*)() const>(&StepToTopoDS_Root::Precision),
             R"#(Returns the value of "MyPrecision")#" 
          )
        .def("SetPrecision",
             (void (StepToTopoDS_Root::*)(  const Standard_Real  ) ) static_cast<void (StepToTopoDS_Root::*)(  const Standard_Real  ) >(&StepToTopoDS_Root::SetPrecision),
             R"#(Sets the value of "MyPrecision")#"  , py::arg("preci")
          )
        .def("MaxTol",
             (Standard_Real (StepToTopoDS_Root::*)() const) static_cast<Standard_Real (StepToTopoDS_Root::*)() const>(&StepToTopoDS_Root::MaxTol),
             R"#(Returns the value of "MaxTol")#" 
          )
        .def("SetMaxTol",
             (void (StepToTopoDS_Root::*)(  const Standard_Real  ) ) static_cast<void (StepToTopoDS_Root::*)(  const Standard_Real  ) >(&StepToTopoDS_Root::SetMaxTol),
             R"#(Sets the value of MaxTol)#"  , py::arg("maxpreci")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StepToTopoDS_Tool from ./opencascade/StepToTopoDS_Tool.hxx
    klass = m.attr("StepToTopoDS_Tool");


    // nested enums

    static_cast<py::class_<StepToTopoDS_Tool , shared_ptr<StepToTopoDS_Tool>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const StepToTopoDS_DataMapOfTRI &, const handle<Transfer_TransientProcess> & >()  , py::arg("Map"),  py::arg("TP") )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_Tool::*)(  const StepToTopoDS_DataMapOfTRI & ,   const handle<Transfer_TransientProcess> &  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const StepToTopoDS_DataMapOfTRI & ,   const handle<Transfer_TransientProcess> &  ) >(&StepToTopoDS_Tool::Init),
             R"#()#"  , py::arg("Map"),  py::arg("TP")
          )
        .def("IsBound",
             (Standard_Boolean (StepToTopoDS_Tool::*)(  const handle<StepShape_TopologicalRepresentationItem> &  ) ) static_cast<Standard_Boolean (StepToTopoDS_Tool::*)(  const handle<StepShape_TopologicalRepresentationItem> &  ) >(&StepToTopoDS_Tool::IsBound),
             R"#()#"  , py::arg("TRI")
          )
        .def("Bind",
             (void (StepToTopoDS_Tool::*)(  const handle<StepShape_TopologicalRepresentationItem> & ,   const TopoDS_Shape &  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const handle<StepShape_TopologicalRepresentationItem> & ,   const TopoDS_Shape &  ) >(&StepToTopoDS_Tool::Bind),
             R"#()#"  , py::arg("TRI"),  py::arg("S")
          )
        .def("Find",
             ( const TopoDS_Shape & (StepToTopoDS_Tool::*)(  const handle<StepShape_TopologicalRepresentationItem> &  ) ) static_cast< const TopoDS_Shape & (StepToTopoDS_Tool::*)(  const handle<StepShape_TopologicalRepresentationItem> &  ) >(&StepToTopoDS_Tool::Find),
             R"#()#"  , py::arg("TRI")
          )
        .def("ClearEdgeMap",
             (void (StepToTopoDS_Tool::*)() ) static_cast<void (StepToTopoDS_Tool::*)() >(&StepToTopoDS_Tool::ClearEdgeMap),
             R"#()#" 
          )
        .def("IsEdgeBound",
             (Standard_Boolean (StepToTopoDS_Tool::*)(  const StepToTopoDS_PointPair &  ) ) static_cast<Standard_Boolean (StepToTopoDS_Tool::*)(  const StepToTopoDS_PointPair &  ) >(&StepToTopoDS_Tool::IsEdgeBound),
             R"#()#"  , py::arg("PP")
          )
        .def("BindEdge",
             (void (StepToTopoDS_Tool::*)(  const StepToTopoDS_PointPair & ,   const TopoDS_Edge &  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const StepToTopoDS_PointPair & ,   const TopoDS_Edge &  ) >(&StepToTopoDS_Tool::BindEdge),
             R"#()#"  , py::arg("PP"),  py::arg("E")
          )
        .def("FindEdge",
             ( const TopoDS_Edge & (StepToTopoDS_Tool::*)(  const StepToTopoDS_PointPair &  ) ) static_cast< const TopoDS_Edge & (StepToTopoDS_Tool::*)(  const StepToTopoDS_PointPair &  ) >(&StepToTopoDS_Tool::FindEdge),
             R"#()#"  , py::arg("PP")
          )
        .def("ClearVertexMap",
             (void (StepToTopoDS_Tool::*)() ) static_cast<void (StepToTopoDS_Tool::*)() >(&StepToTopoDS_Tool::ClearVertexMap),
             R"#()#" 
          )
        .def("IsVertexBound",
             (Standard_Boolean (StepToTopoDS_Tool::*)(  const handle<StepGeom_CartesianPoint> &  ) ) static_cast<Standard_Boolean (StepToTopoDS_Tool::*)(  const handle<StepGeom_CartesianPoint> &  ) >(&StepToTopoDS_Tool::IsVertexBound),
             R"#()#"  , py::arg("PG")
          )
        .def("BindVertex",
             (void (StepToTopoDS_Tool::*)(  const handle<StepGeom_CartesianPoint> & ,   const TopoDS_Vertex &  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const handle<StepGeom_CartesianPoint> & ,   const TopoDS_Vertex &  ) >(&StepToTopoDS_Tool::BindVertex),
             R"#()#"  , py::arg("P"),  py::arg("V")
          )
        .def("FindVertex",
             ( const TopoDS_Vertex & (StepToTopoDS_Tool::*)(  const handle<StepGeom_CartesianPoint> &  ) ) static_cast< const TopoDS_Vertex & (StepToTopoDS_Tool::*)(  const handle<StepGeom_CartesianPoint> &  ) >(&StepToTopoDS_Tool::FindVertex),
             R"#()#"  , py::arg("P")
          )
        .def("ComputePCurve",
             (void (StepToTopoDS_Tool::*)(  const Standard_Boolean  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const Standard_Boolean  ) >(&StepToTopoDS_Tool::ComputePCurve),
             R"#()#"  , py::arg("B")
          )
        .def("ComputePCurve",
             (Standard_Boolean (StepToTopoDS_Tool::*)() const) static_cast<Standard_Boolean (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::ComputePCurve),
             R"#()#" 
          )
        .def("TransientProcess",
             (handle<Transfer_TransientProcess> (StepToTopoDS_Tool::*)() const) static_cast<handle<Transfer_TransientProcess> (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::TransientProcess),
             R"#()#" 
          )
        .def("AddContinuity",
             (void (StepToTopoDS_Tool::*)(  const handle<Geom_Surface> &  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const handle<Geom_Surface> &  ) >(&StepToTopoDS_Tool::AddContinuity),
             R"#()#"  , py::arg("GeomSurf")
          )
        .def("AddContinuity",
             (void (StepToTopoDS_Tool::*)(  const handle<Geom_Curve> &  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const handle<Geom_Curve> &  ) >(&StepToTopoDS_Tool::AddContinuity),
             R"#()#"  , py::arg("GeomCurve")
          )
        .def("AddContinuity",
             (void (StepToTopoDS_Tool::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<void (StepToTopoDS_Tool::*)(  const handle<Geom2d_Curve> &  ) >(&StepToTopoDS_Tool::AddContinuity),
             R"#()#"  , py::arg("GeomCur2d")
          )
        .def("C0Surf",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C0Surf),
             R"#()#" 
          )
        .def("C1Surf",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C1Surf),
             R"#()#" 
          )
        .def("C2Surf",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C2Surf),
             R"#()#" 
          )
        .def("C0Cur2",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C0Cur2),
             R"#()#" 
          )
        .def("C1Cur2",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C1Cur2),
             R"#()#" 
          )
        .def("C2Cur2",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C2Cur2),
             R"#()#" 
          )
        .def("C0Cur3",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C0Cur3),
             R"#()#" 
          )
        .def("C1Cur3",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C1Cur3),
             R"#()#" 
          )
        .def("C2Cur3",
             (Standard_Integer (StepToTopoDS_Tool::*)() const) static_cast<Standard_Integer (StepToTopoDS_Tool::*)() const>(&StepToTopoDS_Tool::C2Cur3),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StepToTopoDS_Builder from ./opencascade/StepToTopoDS_Builder.hxx
    klass = m.attr("StepToTopoDS_Builder");


    // nested enums

    static_cast<py::class_<StepToTopoDS_Builder , shared_ptr<StepToTopoDS_Builder>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_ManifoldSolidBrep> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_ManifoldSolidBrep> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("theManifoldSolid"),  py::arg("theTP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_BrepWithVoids> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_BrepWithVoids> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("theBRepWithVoids"),  py::arg("theTP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_FacetedBrep> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_FacetedBrep> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("theFB"),  py::arg("theTP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_FacetedBrepAndBrepWithVoids> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_FacetedBrepAndBrepWithVoids> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("theFBABWV"),  py::arg("theTP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_ShellBasedSurfaceModel> & ,   const handle<Transfer_TransientProcess> & ,  StepToTopoDS_NMTool & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_ShellBasedSurfaceModel> & ,   const handle<Transfer_TransientProcess> & ,  StepToTopoDS_NMTool & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("S"),  py::arg("TP"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_EdgeBasedWireframeModel> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_EdgeBasedWireframeModel> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("S"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_FaceBasedSurfaceModel> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_FaceBasedSurfaceModel> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("S"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Init",
             (void (StepToTopoDS_Builder::*)(  const handle<StepShape_GeometricSet> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const handle<Transfer_ActorOfTransientProcess> & ,   const Standard_Boolean ,   const Message_ProgressRange &  ) ) static_cast<void (StepToTopoDS_Builder::*)(  const handle<StepShape_GeometricSet> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const handle<Transfer_ActorOfTransientProcess> & ,   const Standard_Boolean ,   const Message_ProgressRange &  ) >(&StepToTopoDS_Builder::Init),
             R"#()#"  , py::arg("S"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("RA")=static_cast< const handle<Transfer_ActorOfTransientProcess> &>(NULL),  py::arg("isManifold")=static_cast< const Standard_Boolean>(Standard_False),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Error",
             (StepToTopoDS_BuilderError (StepToTopoDS_Builder::*)() const) static_cast<StepToTopoDS_BuilderError (StepToTopoDS_Builder::*)() const>(&StepToTopoDS_Builder::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("Init",
             []( StepToTopoDS_Builder &self ,  const handle<StepVisual_TessellatedSolid> & theTSo, const handle<Transfer_TransientProcess> & theTP, const Standard_Boolean theReadTessellatedWhenNoBRepOnly, const StepData_Factors & theLocalFactors, const Message_ProgressRange & theProgress ){
                 Standard_Boolean  theHasGeom;

                 self.Init(theTSo,theTP,theReadTessellatedWhenNoBRepOnly,theHasGeom,theLocalFactors,theProgress);
                 
                 return std::make_tuple(theHasGeom); },
             R"#()#"  , py::arg("theTSo"),  py::arg("theTP"),  py::arg("theReadTessellatedWhenNoBRepOnly"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             []( StepToTopoDS_Builder &self ,  const handle<StepVisual_TessellatedShell> & theTSh, const handle<Transfer_TransientProcess> & theTP, const Standard_Boolean theReadTessellatedWhenNoBRepOnly, const StepData_Factors & theLocalFactors, const Message_ProgressRange & theProgress ){
                 Standard_Boolean  theHasGeom;

                 self.Init(theTSh,theTP,theReadTessellatedWhenNoBRepOnly,theHasGeom,theLocalFactors,theProgress);
                 
                 return std::make_tuple(theHasGeom); },
             R"#()#"  , py::arg("theTSh"),  py::arg("theTP"),  py::arg("theReadTessellatedWhenNoBRepOnly"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Init",
             []( StepToTopoDS_Builder &self ,  const handle<StepVisual_TessellatedFace> & theTF, const handle<Transfer_TransientProcess> & theTP, const Standard_Boolean theReadTessellatedWhenNoBRepOnly, const StepData_Factors & theLocalFactors ){
                 Standard_Boolean  theHasGeom;

                 self.Init(theTF,theTP,theReadTessellatedWhenNoBRepOnly,theHasGeom,theLocalFactors);
                 
                 return std::make_tuple(theHasGeom); },
             R"#()#"  , py::arg("theTF"),  py::arg("theTP"),  py::arg("theReadTessellatedWhenNoBRepOnly"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Init",
             []( StepToTopoDS_Builder &self ,  const handle<StepVisual_TessellatedSurfaceSet> & theTSS, const handle<Transfer_TransientProcess> & theTP, const StepData_Factors & theLocalFactors ){
                 Standard_Boolean  theHasGeom;

                 self.Init(theTSS,theTP,theHasGeom,theLocalFactors);
                 
                 return std::make_tuple(theHasGeom); },
             R"#()#"  , py::arg("theTSS"),  py::arg("theTP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_Builder::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_Builder::*)() const>(&StepToTopoDS_Builder::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_MakeTransformed from ./opencascade/StepToTopoDS_MakeTransformed.hxx
    klass = m.attr("StepToTopoDS_MakeTransformed");


    // nested enums

    static_cast<py::class_<StepToTopoDS_MakeTransformed , shared_ptr<StepToTopoDS_MakeTransformed>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Compute",
             (Standard_Boolean (StepToTopoDS_MakeTransformed::*)(  const handle<StepGeom_Axis2Placement3d> & ,   const handle<StepGeom_Axis2Placement3d> & ,   const StepData_Factors &  ) ) static_cast<Standard_Boolean (StepToTopoDS_MakeTransformed::*)(  const handle<StepGeom_Axis2Placement3d> & ,   const handle<StepGeom_Axis2Placement3d> & ,   const StepData_Factors &  ) >(&StepToTopoDS_MakeTransformed::Compute),
             R"#(Computes a transformation to pass from an Origin placement to a Target placement. Returns True when done If not done, the transformation will by Identity)#"  , py::arg("Origin"),  py::arg("Target"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Compute",
             (Standard_Boolean (StepToTopoDS_MakeTransformed::*)(  const handle<StepGeom_CartesianTransformationOperator3d> & ,   const StepData_Factors &  ) ) static_cast<Standard_Boolean (StepToTopoDS_MakeTransformed::*)(  const handle<StepGeom_CartesianTransformationOperator3d> & ,   const StepData_Factors &  ) >(&StepToTopoDS_MakeTransformed::Compute),
             R"#(Computes a transformation defined by an operator 3D)#"  , py::arg("Operator"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Transform",
             (Standard_Boolean (StepToTopoDS_MakeTransformed::*)( TopoDS_Shape &  ) const) static_cast<Standard_Boolean (StepToTopoDS_MakeTransformed::*)( TopoDS_Shape &  ) const>(&StepToTopoDS_MakeTransformed::Transform),
             R"#(Applies the computed transformation to a shape Returns False if the transformation is Identity)#"  , py::arg("shape")
          )
        .def("TranslateMappedItem",
             (TopoDS_Shape (StepToTopoDS_MakeTransformed::*)(  const handle<StepRepr_MappedItem> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) ) static_cast<TopoDS_Shape (StepToTopoDS_MakeTransformed::*)(  const handle<StepRepr_MappedItem> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) >(&StepToTopoDS_MakeTransformed::TranslateMappedItem),
             R"#(Translates a MappedItem. More precisely A MappedItem has a MappingSource and a MappingTarget MappingSource has a MappedRepresentation and a MappingOrigin MappedRepresentation is the basic item to be instanced MappingOrigin is the starting placement MappingTarget is the final placement)#"  , py::arg("mapit"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Transformation",
             ( const gp_Trsf & (StepToTopoDS_MakeTransformed::*)() const) static_cast< const gp_Trsf & (StepToTopoDS_MakeTransformed::*)() const>(&StepToTopoDS_MakeTransformed::Transformation),
             R"#(Returns the computed transformation (Identity if not yet or if failed))#"
             
         )
;

    // Class StepToTopoDS_TranslateCompositeCurve from ./opencascade/StepToTopoDS_TranslateCompositeCurve.hxx
    klass = m.attr("StepToTopoDS_TranslateCompositeCurve");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateCompositeCurve , shared_ptr<StepToTopoDS_TranslateCompositeCurve>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepGeom_CompositeCurve> &, const handle<Transfer_TransientProcess> &, const StepData_Factors & >()  , py::arg("CC"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
        .def(py::init<  const handle<StepGeom_CompositeCurve> &, const handle<Transfer_TransientProcess> &, const handle<StepGeom_Surface> &, const handle<Geom_Surface> &, const StepData_Factors & >()  , py::arg("CC"),  py::arg("TP"),  py::arg("S"),  py::arg("Surf"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)(  const handle<StepGeom_CompositeCurve> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) ) static_cast<Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)(  const handle<StepGeom_CompositeCurve> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateCompositeCurve::Init),
             R"#(Translates standalone composite_curve)#"  , py::arg("CC"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Init",
             (Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)(  const handle<StepGeom_CompositeCurve> & ,   const handle<Transfer_TransientProcess> & ,   const handle<StepGeom_Surface> & ,   const handle<Geom_Surface> & ,   const StepData_Factors &  ) ) static_cast<Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)(  const handle<StepGeom_CompositeCurve> & ,   const handle<Transfer_TransientProcess> & ,   const handle<StepGeom_Surface> & ,   const handle<Geom_Surface> & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateCompositeCurve::Init),
             R"#(Translates composite_curve lying on surface)#"  , py::arg("CC"),  py::arg("TP"),  py::arg("S"),  py::arg("Surf"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("IsInfiniteSegment",
             (Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)() const) static_cast<Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)() const>(&StepToTopoDS_TranslateCompositeCurve::IsInfiniteSegment),
             R"#(Returns True if composite_curve contains a segment with infinite parameters.)#" 
          )
        .def("IsInfiniteSegment",
             (Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)() const) static_cast<Standard_Boolean (StepToTopoDS_TranslateCompositeCurve::*)() const>(&StepToTopoDS_TranslateCompositeCurve::IsInfiniteSegment),
             R"#(Returns True if composite_curve contains a segment with infinite parameters.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Wire & (StepToTopoDS_TranslateCompositeCurve::*)() const) static_cast< const TopoDS_Wire & (StepToTopoDS_TranslateCompositeCurve::*)() const>(&StepToTopoDS_TranslateCompositeCurve::Value),
             R"#(Returns result of last translation or null wire if failed.)#"
             
         )
;

    // Class StepToTopoDS_TranslateCurveBoundedSurface from ./opencascade/StepToTopoDS_TranslateCurveBoundedSurface.hxx
    klass = m.attr("StepToTopoDS_TranslateCurveBoundedSurface");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateCurveBoundedSurface , shared_ptr<StepToTopoDS_TranslateCurveBoundedSurface>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepGeom_CurveBoundedSurface> &, const handle<Transfer_TransientProcess> &, const StepData_Factors & >()  , py::arg("CBS"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (Standard_Boolean (StepToTopoDS_TranslateCurveBoundedSurface::*)(  const handle<StepGeom_CurveBoundedSurface> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) ) static_cast<Standard_Boolean (StepToTopoDS_TranslateCurveBoundedSurface::*)(  const handle<StepGeom_CurveBoundedSurface> & ,   const handle<Transfer_TransientProcess> & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateCurveBoundedSurface::Init),
             R"#(Translate surface)#"  , py::arg("CBS"),  py::arg("TP"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Face & (StepToTopoDS_TranslateCurveBoundedSurface::*)() const) static_cast< const TopoDS_Face & (StepToTopoDS_TranslateCurveBoundedSurface::*)() const>(&StepToTopoDS_TranslateCurveBoundedSurface::Value),
             R"#(Returns result of last translation or null wire if failed.)#"
             
         )
;

    // Class StepToTopoDS_TranslateEdge from ./opencascade/StepToTopoDS_TranslateEdge.hxx
    klass = m.attr("StepToTopoDS_TranslateEdge");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateEdge , shared_ptr<StepToTopoDS_TranslateEdge>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepShape_Edge> &,StepToTopoDS_Tool &,StepToTopoDS_NMTool &, const StepData_Factors & >()  , py::arg("E"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_TranslateEdge::*)(  const handle<StepShape_Edge> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslateEdge::*)(  const handle<StepShape_Edge> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateEdge::Init),
             R"#()#"  , py::arg("E"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("MakeFromCurve3D",
             (void (StepToTopoDS_TranslateEdge::*)(  const handle<StepGeom_Curve> & ,   const handle<StepShape_EdgeCurve> & ,   const handle<StepShape_Vertex> & ,   const Standard_Real ,  TopoDS_Edge & ,  TopoDS_Vertex & ,  TopoDS_Vertex & ,  StepToTopoDS_Tool & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslateEdge::*)(  const handle<StepGeom_Curve> & ,   const handle<StepShape_EdgeCurve> & ,   const handle<StepShape_Vertex> & ,   const Standard_Real ,  TopoDS_Edge & ,  TopoDS_Vertex & ,  TopoDS_Vertex & ,  StepToTopoDS_Tool & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateEdge::MakeFromCurve3D),
             R"#(Warning! C3D is assumed to be a Curve 3D ... other cases to checked before calling this)#"  , py::arg("C3D"),  py::arg("EC"),  py::arg("Vend"),  py::arg("preci"),  py::arg("E"),  py::arg("V1"),  py::arg("V2"),  py::arg("T"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("MakePCurve",
             (handle<Geom2d_Curve> (StepToTopoDS_TranslateEdge::*)(  const handle<StepGeom_Pcurve> & ,   const handle<Geom_Surface> & ,   const StepData_Factors &  ) const) static_cast<handle<Geom2d_Curve> (StepToTopoDS_TranslateEdge::*)(  const handle<StepGeom_Pcurve> & ,   const handle<Geom_Surface> & ,   const StepData_Factors &  ) const>(&StepToTopoDS_TranslateEdge::MakePCurve),
             R"#()#"  , py::arg("PCU"),  py::arg("ConvSurf"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Error",
             (StepToTopoDS_TranslateEdgeError (StepToTopoDS_TranslateEdge::*)() const) static_cast<StepToTopoDS_TranslateEdgeError (StepToTopoDS_TranslateEdge::*)() const>(&StepToTopoDS_TranslateEdge::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslateEdge::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslateEdge::*)() const>(&StepToTopoDS_TranslateEdge::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_TranslateEdgeLoop from ./opencascade/StepToTopoDS_TranslateEdgeLoop.hxx
    klass = m.attr("StepToTopoDS_TranslateEdgeLoop");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateEdgeLoop , shared_ptr<StepToTopoDS_TranslateEdgeLoop>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepShape_FaceBound> &, const TopoDS_Face &, const handle<Geom_Surface> &, const handle<StepGeom_Surface> &, const Standard_Boolean,StepToTopoDS_Tool &,StepToTopoDS_NMTool &, const StepData_Factors & >()  , py::arg("FB"),  py::arg("F"),  py::arg("S"),  py::arg("SS"),  py::arg("ss"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_TranslateEdgeLoop::*)(  const handle<StepShape_FaceBound> & ,   const TopoDS_Face & ,   const handle<Geom_Surface> & ,   const handle<StepGeom_Surface> & ,   const Standard_Boolean ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslateEdgeLoop::*)(  const handle<StepShape_FaceBound> & ,   const TopoDS_Face & ,   const handle<Geom_Surface> & ,   const handle<StepGeom_Surface> & ,   const Standard_Boolean ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateEdgeLoop::Init),
             R"#()#"  , py::arg("FB"),  py::arg("F"),  py::arg("S"),  py::arg("SS"),  py::arg("ss"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Error",
             (StepToTopoDS_TranslateEdgeLoopError (StepToTopoDS_TranslateEdgeLoop::*)() const) static_cast<StepToTopoDS_TranslateEdgeLoopError (StepToTopoDS_TranslateEdgeLoop::*)() const>(&StepToTopoDS_TranslateEdgeLoop::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslateEdgeLoop::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslateEdgeLoop::*)() const>(&StepToTopoDS_TranslateEdgeLoop::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_TranslateFace from ./opencascade/StepToTopoDS_TranslateFace.hxx
    klass = m.attr("StepToTopoDS_TranslateFace");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateFace , shared_ptr<StepToTopoDS_TranslateFace>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepShape_FaceSurface> &,StepToTopoDS_Tool &,StepToTopoDS_NMTool &, const StepData_Factors & >()  , py::arg("FS"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
        .def(py::init<  const handle<StepVisual_TessellatedFace> &,StepToTopoDS_Tool &,StepToTopoDS_NMTool &, const Standard_Boolean,Standard_Boolean &, const StepData_Factors & >()  , py::arg("theTF"),  py::arg("theTool"),  py::arg("theNMTool"),  py::arg("theReadTessellatedWhenNoBRepOnly"),  py::arg("theHasGeom"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
        .def(py::init<  const handle<StepVisual_TessellatedSurfaceSet> &,StepToTopoDS_Tool &,StepToTopoDS_NMTool &, const StepData_Factors & >()  , py::arg("theTSS"),  py::arg("theTool"),  py::arg("theNMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_TranslateFace::*)(  const handle<StepShape_FaceSurface> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslateFace::*)(  const handle<StepShape_FaceSurface> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateFace::Init),
             R"#()#"  , py::arg("theFaceSurface"),  py::arg("theTopoDSTool"),  py::arg("theTopoDSToolNM"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Init",
             (void (StepToTopoDS_TranslateFace::*)(  const handle<StepVisual_TessellatedSurfaceSet> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslateFace::*)(  const handle<StepVisual_TessellatedSurfaceSet> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateFace::Init),
             R"#()#"  , py::arg("theTSS"),  py::arg("theTool"),  py::arg("theNMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Error",
             (StepToTopoDS_TranslateFaceError (StepToTopoDS_TranslateFace::*)() const) static_cast<StepToTopoDS_TranslateFaceError (StepToTopoDS_TranslateFace::*)() const>(&StepToTopoDS_TranslateFace::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("Init",
             []( StepToTopoDS_TranslateFace &self ,  const handle<StepVisual_TessellatedFace> & theTF,StepToTopoDS_Tool & theTool,StepToTopoDS_NMTool & theNMTool, const Standard_Boolean theReadTessellatedWhenNoBRepOnly, const StepData_Factors & theLocalFactors ){
                 Standard_Boolean  theHasGeom;

                 self.Init(theTF,theTool,theNMTool,theReadTessellatedWhenNoBRepOnly,theHasGeom,theLocalFactors);
                 
                 return std::make_tuple(theHasGeom); },
             R"#()#"  , py::arg("theTF"),  py::arg("theTool"),  py::arg("theNMTool"),  py::arg("theReadTessellatedWhenNoBRepOnly"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslateFace::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslateFace::*)() const>(&StepToTopoDS_TranslateFace::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_TranslatePolyLoop from ./opencascade/StepToTopoDS_TranslatePolyLoop.hxx
    klass = m.attr("StepToTopoDS_TranslatePolyLoop");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslatePolyLoop , shared_ptr<StepToTopoDS_TranslatePolyLoop>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepShape_PolyLoop> &,StepToTopoDS_Tool &, const handle<Geom_Surface> &, const TopoDS_Face &, const StepData_Factors & >()  , py::arg("PL"),  py::arg("T"),  py::arg("S"),  py::arg("F"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_TranslatePolyLoop::*)(  const handle<StepShape_PolyLoop> & ,  StepToTopoDS_Tool & ,   const handle<Geom_Surface> & ,   const TopoDS_Face & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslatePolyLoop::*)(  const handle<StepShape_PolyLoop> & ,  StepToTopoDS_Tool & ,   const handle<Geom_Surface> & ,   const TopoDS_Face & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslatePolyLoop::Init),
             R"#()#"  , py::arg("PL"),  py::arg("T"),  py::arg("S"),  py::arg("F"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Error",
             (StepToTopoDS_TranslatePolyLoopError (StepToTopoDS_TranslatePolyLoop::*)() const) static_cast<StepToTopoDS_TranslatePolyLoopError (StepToTopoDS_TranslatePolyLoop::*)() const>(&StepToTopoDS_TranslatePolyLoop::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslatePolyLoop::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslatePolyLoop::*)() const>(&StepToTopoDS_TranslatePolyLoop::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_TranslateShell from ./opencascade/StepToTopoDS_TranslateShell.hxx
    klass = m.attr("StepToTopoDS_TranslateShell");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateShell , shared_ptr<StepToTopoDS_TranslateShell>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_TranslateShell::*)(  const handle<StepShape_ConnectedFaceSet> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) ) static_cast<void (StepToTopoDS_TranslateShell::*)(  const handle<StepShape_ConnectedFaceSet> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors & ,   const Message_ProgressRange &  ) >(&StepToTopoDS_TranslateShell::Init),
             R"#()#"  , py::arg("CFS"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Error",
             (StepToTopoDS_TranslateShellError (StepToTopoDS_TranslateShell::*)() const) static_cast<StepToTopoDS_TranslateShellError (StepToTopoDS_TranslateShell::*)() const>(&StepToTopoDS_TranslateShell::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("Init",
             []( StepToTopoDS_TranslateShell &self ,  const handle<StepVisual_TessellatedShell> & theTSh,StepToTopoDS_Tool & theTool,StepToTopoDS_NMTool & theNMTool, const Standard_Boolean theReadTessellatedWhenNoBRepOnly, const StepData_Factors & theLocalFactors, const Message_ProgressRange & theProgress ){
                 Standard_Boolean  theHasGeom;

                 self.Init(theTSh,theTool,theNMTool,theReadTessellatedWhenNoBRepOnly,theHasGeom,theLocalFactors,theProgress);
                 
                 return std::make_tuple(theHasGeom); },
             R"#()#"  , py::arg("theTSh"),  py::arg("theTool"),  py::arg("theNMTool"),  py::arg("theReadTessellatedWhenNoBRepOnly"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslateShell::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslateShell::*)() const>(&StepToTopoDS_TranslateShell::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_TranslateSolid from ./opencascade/StepToTopoDS_TranslateSolid.hxx
    klass = m.attr("StepToTopoDS_TranslateSolid");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateSolid , shared_ptr<StepToTopoDS_TranslateSolid>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Error",
             (StepToTopoDS_TranslateSolidError (StepToTopoDS_TranslateSolid::*)() const) static_cast<StepToTopoDS_TranslateSolidError (StepToTopoDS_TranslateSolid::*)() const>(&StepToTopoDS_TranslateSolid::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("Init",
             []( StepToTopoDS_TranslateSolid &self ,  const handle<StepVisual_TessellatedSolid> & theTSo, const handle<Transfer_TransientProcess> & theTP,StepToTopoDS_Tool & theTool,StepToTopoDS_NMTool & theNMTool, const Standard_Boolean theReadTessellatedWhenNoBRepOnly, const StepData_Factors & theLocalFactors, const Message_ProgressRange & theProgress ){
                 Standard_Boolean  theHasGeom;

                 self.Init(theTSo,theTP,theTool,theNMTool,theReadTessellatedWhenNoBRepOnly,theHasGeom,theLocalFactors,theProgress);
                 
                 return std::make_tuple(theHasGeom); },
             R"#()#"  , py::arg("theTSo"),  py::arg("theTP"),  py::arg("theTool"),  py::arg("theNMTool"),  py::arg("theReadTessellatedWhenNoBRepOnly"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslateSolid::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslateSolid::*)() const>(&StepToTopoDS_TranslateSolid::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_TranslateVertex from ./opencascade/StepToTopoDS_TranslateVertex.hxx
    klass = m.attr("StepToTopoDS_TranslateVertex");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateVertex , shared_ptr<StepToTopoDS_TranslateVertex>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepShape_Vertex> &,StepToTopoDS_Tool &,StepToTopoDS_NMTool &, const StepData_Factors & >()  , py::arg("V"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_TranslateVertex::*)(  const handle<StepShape_Vertex> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslateVertex::*)(  const handle<StepShape_Vertex> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateVertex::Init),
             R"#()#"  , py::arg("V"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Error",
             (StepToTopoDS_TranslateVertexError (StepToTopoDS_TranslateVertex::*)() const) static_cast<StepToTopoDS_TranslateVertexError (StepToTopoDS_TranslateVertex::*)() const>(&StepToTopoDS_TranslateVertex::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslateVertex::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslateVertex::*)() const>(&StepToTopoDS_TranslateVertex::Value),
             R"#()#"
             
         )
;

    // Class StepToTopoDS_TranslateVertexLoop from ./opencascade/StepToTopoDS_TranslateVertexLoop.hxx
    klass = m.attr("StepToTopoDS_TranslateVertexLoop");


    // nested enums

    static_cast<py::class_<StepToTopoDS_TranslateVertexLoop , shared_ptr<StepToTopoDS_TranslateVertexLoop>  , StepToTopoDS_Root >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<StepShape_VertexLoop> &,StepToTopoDS_Tool &,StepToTopoDS_NMTool &, const StepData_Factors & >()  , py::arg("VL"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (StepToTopoDS_TranslateVertexLoop::*)(  const handle<StepShape_VertexLoop> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) ) static_cast<void (StepToTopoDS_TranslateVertexLoop::*)(  const handle<StepShape_VertexLoop> & ,  StepToTopoDS_Tool & ,  StepToTopoDS_NMTool & ,   const StepData_Factors &  ) >(&StepToTopoDS_TranslateVertexLoop::Init),
             R"#()#"  , py::arg("VL"),  py::arg("T"),  py::arg("NMTool"),  py::arg("theLocalFactors")=static_cast< const StepData_Factors &>(StepData_Factors ( ))
          )
        .def("Error",
             (StepToTopoDS_TranslateVertexLoopError (StepToTopoDS_TranslateVertexLoop::*)() const) static_cast<StepToTopoDS_TranslateVertexLoopError (StepToTopoDS_TranslateVertexLoop::*)() const>(&StepToTopoDS_TranslateVertexLoop::Error),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const TopoDS_Shape & (StepToTopoDS_TranslateVertexLoop::*)() const) static_cast< const TopoDS_Shape & (StepToTopoDS_TranslateVertexLoop::*)() const>(&StepToTopoDS_TranslateVertexLoop::Value),
             R"#()#"
             
         )
;

// functions

// ./opencascade/StepToTopoDS.hxx
// ./opencascade/StepToTopoDS_Builder.hxx
// ./opencascade/StepToTopoDS_BuilderError.hxx
// ./opencascade/StepToTopoDS_DataMapIteratorOfDataMapOfRI.hxx
// ./opencascade/StepToTopoDS_DataMapIteratorOfDataMapOfRINames.hxx
// ./opencascade/StepToTopoDS_DataMapIteratorOfDataMapOfTRI.hxx
// ./opencascade/StepToTopoDS_DataMapIteratorOfPointEdgeMap.hxx
// ./opencascade/StepToTopoDS_DataMapIteratorOfPointVertexMap.hxx
// ./opencascade/StepToTopoDS_DataMapOfRI.hxx
// ./opencascade/StepToTopoDS_DataMapOfRINames.hxx
// ./opencascade/StepToTopoDS_DataMapOfTRI.hxx
// ./opencascade/StepToTopoDS_GeometricTool.hxx
// ./opencascade/StepToTopoDS_GeometricToolError.hxx
// ./opencascade/StepToTopoDS_MakeTransformed.hxx
// ./opencascade/StepToTopoDS_NMTool.hxx
// ./opencascade/StepToTopoDS_PointEdgeMap.hxx
// ./opencascade/StepToTopoDS_PointPair.hxx
// ./opencascade/StepToTopoDS_PointVertexMap.hxx
// ./opencascade/StepToTopoDS_Root.hxx
// ./opencascade/StepToTopoDS_Tool.hxx
// ./opencascade/StepToTopoDS_TranslateCompositeCurve.hxx
// ./opencascade/StepToTopoDS_TranslateCurveBoundedSurface.hxx
// ./opencascade/StepToTopoDS_TranslateEdge.hxx
// ./opencascade/StepToTopoDS_TranslateEdgeError.hxx
// ./opencascade/StepToTopoDS_TranslateEdgeLoop.hxx
// ./opencascade/StepToTopoDS_TranslateEdgeLoopError.hxx
// ./opencascade/StepToTopoDS_TranslateFace.hxx
// ./opencascade/StepToTopoDS_TranslateFaceError.hxx
// ./opencascade/StepToTopoDS_TranslatePolyLoop.hxx
// ./opencascade/StepToTopoDS_TranslatePolyLoopError.hxx
// ./opencascade/StepToTopoDS_TranslateShell.hxx
// ./opencascade/StepToTopoDS_TranslateShellError.hxx
// ./opencascade/StepToTopoDS_TranslateSolid.hxx
// ./opencascade/StepToTopoDS_TranslateSolidError.hxx
// ./opencascade/StepToTopoDS_TranslateVertex.hxx
// ./opencascade/StepToTopoDS_TranslateVertexError.hxx
// ./opencascade/StepToTopoDS_TranslateVertexLoop.hxx
// ./opencascade/StepToTopoDS_TranslateVertexLoopError.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_DataMap<opencascade::handle<StepRepr_RepresentationItem>, TopoDS_Shape>(m,"StepToTopoDS_DataMapOfRI");
    register_template_NCollection_DataMap<TCollection_AsciiString, TopoDS_Shape>(m,"StepToTopoDS_DataMapOfRINames");
    register_template_NCollection_DataMap<opencascade::handle<StepShape_TopologicalRepresentationItem>, TopoDS_Shape>(m,"StepToTopoDS_DataMapOfTRI");
    register_template_NCollection_DataMap<StepToTopoDS_PointPair, TopoDS_Edge>(m,"StepToTopoDS_PointEdgeMap");
    register_template_NCollection_DataMap<opencascade::handle<StepGeom_CartesianPoint>, TopoDS_Vertex>(m,"StepToTopoDS_PointVertexMap");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
