
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <TopBas_ListIteratorOfListOfTestInterference.hxx>
#include <TopBas_ListOfTestInterference.hxx>
#include <TopBas_TestInterference.hxx>

// template related includes

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_TopBas_enums(py::module &main_module) {


py::module m = main_module.def_submodule("TopBas", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<TopBas_TestInterference , shared_ptr<TopBas_TestInterference>  >(m,"TopBas_TestInterference",R"#()#");
    preregister_template_NCollection_List<TopBas_TestInterference>(m,"TopBas_ListOfTestInterference");

};

// user-defined post-inclusion per module

// user-defined post
