
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <XmlMDF_ADriver.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>

// module includes
#include <XmlDrivers.hxx>
#include <XmlDrivers_DocumentRetrievalDriver.hxx>
#include <XmlDrivers_DocumentStorageDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <PCDM_ReaderFilter.hxx>

// Module definiiton
void register_XmlDrivers(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XmlDrivers"));
py::object klass;

//Python trampoline classes

// classes

    // Class XmlDrivers from ./opencascade/XmlDrivers.hxx
    klass = m.attr("XmlDrivers");

    // default constructor
    register_default_constructor<XmlDrivers , shared_ptr<XmlDrivers>>(m,"XmlDrivers");

    // nested enums

    static_cast<py::class_<XmlDrivers , shared_ptr<XmlDrivers>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Factory_s",
                    ( const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) ) static_cast< const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) >(&XmlDrivers::Factory),
                    R"#()#"  , py::arg("theGUID")
          )
        .def_static("DefineFormat_s",
                    (void (*)(  const handle<TDocStd_Application> &  ) ) static_cast<void (*)(  const handle<TDocStd_Application> &  ) >(&XmlDrivers::DefineFormat),
                    R"#(Defines format "XmlOcaf" and registers its read and write drivers in the specified application)#"  , py::arg("theApp")
          )
        .def_static("AttributeDrivers_s",
                    (handle<XmlMDF_ADriverTable> (*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<XmlMDF_ADriverTable> (*)(  const handle<Message_Messenger> &  ) >(&XmlDrivers::AttributeDrivers),
                    R"#()#"  , py::arg("theMsgDriver")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XmlDrivers_DocumentRetrievalDriver from ./opencascade/XmlDrivers_DocumentRetrievalDriver.hxx
    klass = m.attr("XmlDrivers_DocumentRetrievalDriver");


    // nested enums

    static_cast<py::class_<XmlDrivers_DocumentRetrievalDriver ,opencascade::handle<XmlDrivers_DocumentRetrievalDriver>  , XmlLDrivers_DocumentRetrievalDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<XmlMDF_ADriverTable> (XmlDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<XmlMDF_ADriverTable> (XmlDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) >(&XmlDrivers_DocumentRetrievalDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
        .def("ReadShapeSection",
             (handle<XmlMDF_ADriver> (XmlDrivers_DocumentRetrievalDriver::*)(  const XmlObjMgt_Element & ,   const handle<Message_Messenger> & ,   const Message_ProgressRange &  ) ) static_cast<handle<XmlMDF_ADriver> (XmlDrivers_DocumentRetrievalDriver::*)(  const XmlObjMgt_Element & ,   const handle<Message_Messenger> & ,   const Message_ProgressRange &  ) >(&XmlDrivers_DocumentRetrievalDriver::ReadShapeSection),
             R"#()#"  , py::arg("thePDoc"),  py::arg("theMsgDriver"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ShapeSetCleaning",
             (void (XmlDrivers_DocumentRetrievalDriver::*)(  const handle<XmlMDF_ADriver> &  ) ) static_cast<void (XmlDrivers_DocumentRetrievalDriver::*)(  const handle<XmlMDF_ADriver> &  ) >(&XmlDrivers_DocumentRetrievalDriver::ShapeSetCleaning),
             R"#()#"  , py::arg("theDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlDrivers_DocumentRetrievalDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlDrivers_DocumentRetrievalDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlDrivers_DocumentRetrievalDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlDrivers_DocumentRetrievalDriver::*)() const>(&XmlDrivers_DocumentRetrievalDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlDrivers_DocumentStorageDriver from ./opencascade/XmlDrivers_DocumentStorageDriver.hxx
    klass = m.attr("XmlDrivers_DocumentStorageDriver");


    // nested enums

    static_cast<py::class_<XmlDrivers_DocumentStorageDriver ,opencascade::handle<XmlDrivers_DocumentStorageDriver>  , XmlLDrivers_DocumentStorageDriver >>(klass)
    // constructors
        .def(py::init<  const TCollection_ExtendedString & >()  , py::arg("theCopyright") )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<XmlMDF_ADriverTable> (XmlDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<XmlMDF_ADriverTable> (XmlDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) >(&XmlDrivers_DocumentStorageDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
        .def("WriteShapeSection",
             (Standard_Boolean (XmlDrivers_DocumentStorageDriver::*)( XmlObjMgt_Element & ,   const TDocStd_FormatVersion ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (XmlDrivers_DocumentStorageDriver::*)( XmlObjMgt_Element & ,   const TDocStd_FormatVersion ,   const Message_ProgressRange &  ) >(&XmlDrivers_DocumentStorageDriver::WriteShapeSection),
             R"#()#"  , py::arg("thePDoc"),  py::arg("theStorageFormatVersion"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlDrivers_DocumentStorageDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlDrivers_DocumentStorageDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlDrivers_DocumentStorageDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlDrivers_DocumentStorageDriver::*)() const>(&XmlDrivers_DocumentStorageDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/XmlDrivers.hxx
// ./opencascade/XmlDrivers_DocumentRetrievalDriver.hxx
// ./opencascade/XmlDrivers_DocumentStorageDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
