
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>

// module includes
#include <XmlMFunction.hxx>
#include <XmlMFunction_FunctionDriver.hxx>
#include <XmlMFunction_GraphNodeDriver.hxx>
#include <XmlMFunction_ScopeDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XmlMFunction(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XmlMFunction"));
py::object klass;

//Python trampoline classes

// classes

    // Class XmlMFunction from ./opencascade/XmlMFunction.hxx
    klass = m.attr("XmlMFunction");

    // default constructor
    register_default_constructor<XmlMFunction , shared_ptr<XmlMFunction>>(m,"XmlMFunction");

    // nested enums

    static_cast<py::class_<XmlMFunction , shared_ptr<XmlMFunction>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&XmlMFunction::AddDrivers),
                    R"#(Adds the attribute storage drivers to <aDriverTable>.)#"  , py::arg("aDriverTable"),  py::arg("theMessageDriver")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XmlMFunction_FunctionDriver from ./opencascade/XmlMFunction_FunctionDriver.hxx
    klass = m.attr("XmlMFunction_FunctionDriver");


    // nested enums

    static_cast<py::class_<XmlMFunction_FunctionDriver ,opencascade::handle<XmlMFunction_FunctionDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMFunction_FunctionDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMFunction_FunctionDriver::*)() const>(&XmlMFunction_FunctionDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMFunction_FunctionDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMFunction_FunctionDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMFunction_FunctionDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMFunction_FunctionDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMFunction_FunctionDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMFunction_FunctionDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMFunction_FunctionDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMFunction_FunctionDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMFunction_FunctionDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMFunction_FunctionDriver::*)() const>(&XmlMFunction_FunctionDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMFunction_GraphNodeDriver from ./opencascade/XmlMFunction_GraphNodeDriver.hxx
    klass = m.attr("XmlMFunction_GraphNodeDriver");


    // nested enums

    static_cast<py::class_<XmlMFunction_GraphNodeDriver ,opencascade::handle<XmlMFunction_GraphNodeDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMFunction_GraphNodeDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMFunction_GraphNodeDriver::*)() const>(&XmlMFunction_GraphNodeDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMFunction_GraphNodeDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMFunction_GraphNodeDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMFunction_GraphNodeDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMFunction_GraphNodeDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMFunction_GraphNodeDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMFunction_GraphNodeDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMFunction_GraphNodeDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMFunction_GraphNodeDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMFunction_GraphNodeDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMFunction_GraphNodeDriver::*)() const>(&XmlMFunction_GraphNodeDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMFunction_ScopeDriver from ./opencascade/XmlMFunction_ScopeDriver.hxx
    klass = m.attr("XmlMFunction_ScopeDriver");


    // nested enums

    static_cast<py::class_<XmlMFunction_ScopeDriver ,opencascade::handle<XmlMFunction_ScopeDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMFunction_ScopeDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMFunction_ScopeDriver::*)() const>(&XmlMFunction_ScopeDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMFunction_ScopeDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMFunction_ScopeDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMFunction_ScopeDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMFunction_ScopeDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMFunction_ScopeDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMFunction_ScopeDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMFunction_ScopeDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMFunction_ScopeDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMFunction_ScopeDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMFunction_ScopeDriver::*)() const>(&XmlMFunction_ScopeDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/XmlMFunction.hxx
// ./opencascade/XmlMFunction_FunctionDriver.hxx
// ./opencascade/XmlMFunction_GraphNodeDriver.hxx
// ./opencascade/XmlMFunction_ScopeDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
