
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>

// module includes
#include <XmlMNaming.hxx>
#include <XmlMNaming_NamedShapeDriver.hxx>
#include <XmlMNaming_NamingDriver.hxx>
#include <XmlMNaming_Shape1.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XmlMNaming(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XmlMNaming"));
py::object klass;

//Python trampoline classes

// classes

    // Class XmlMNaming from ./opencascade/XmlMNaming.hxx
    klass = m.attr("XmlMNaming");

    // default constructor
    register_default_constructor<XmlMNaming , shared_ptr<XmlMNaming>>(m,"XmlMNaming");

    // nested enums

    static_cast<py::class_<XmlMNaming , shared_ptr<XmlMNaming>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&XmlMNaming::AddDrivers),
                    R"#(Adds the attribute drivers to <aDriverTable>.)#"  , py::arg("aDriverTable"),  py::arg("aMessageDriver")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XmlMNaming_NamedShapeDriver from ./opencascade/XmlMNaming_NamedShapeDriver.hxx
    klass = m.attr("XmlMNaming_NamedShapeDriver");


    // nested enums

    static_cast<py::class_<XmlMNaming_NamedShapeDriver ,opencascade::handle<XmlMNaming_NamedShapeDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("aMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMNaming_NamedShapeDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMNaming_NamedShapeDriver::*)() const>(&XmlMNaming_NamedShapeDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMNaming_NamedShapeDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMNaming_NamedShapeDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMNaming_NamedShapeDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
        .def("Paste",
             (void (XmlMNaming_NamedShapeDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMNaming_NamedShapeDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMNaming_NamedShapeDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
        .def("ReadShapeSection",
             (void (XmlMNaming_NamedShapeDriver::*)(  const XmlObjMgt_Element & ,   const Message_ProgressRange &  ) ) static_cast<void (XmlMNaming_NamedShapeDriver::*)(  const XmlObjMgt_Element & ,   const Message_ProgressRange &  ) >(&XmlMNaming_NamedShapeDriver::ReadShapeSection),
             R"#(Input the shapes from DOM element)#"  , py::arg("anElement"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("WriteShapeSection",
             (void (XmlMNaming_NamedShapeDriver::*)( XmlObjMgt_Element & ,  TDocStd_FormatVersion ,   const Message_ProgressRange &  ) ) static_cast<void (XmlMNaming_NamedShapeDriver::*)( XmlObjMgt_Element & ,  TDocStd_FormatVersion ,   const Message_ProgressRange &  ) >(&XmlMNaming_NamedShapeDriver::WriteShapeSection),
             R"#(Output the shapes into DOM element)#"  , py::arg("anElement"),  py::arg("theStorageFormatVersion"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Clear",
             (void (XmlMNaming_NamedShapeDriver::*)() ) static_cast<void (XmlMNaming_NamedShapeDriver::*)() >(&XmlMNaming_NamedShapeDriver::Clear),
             R"#(Clear myShapeSet)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMNaming_NamedShapeDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMNaming_NamedShapeDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetShapesLocations",
             (TopTools_LocationSet & (XmlMNaming_NamedShapeDriver::*)() ) static_cast<TopTools_LocationSet & (XmlMNaming_NamedShapeDriver::*)() >(&XmlMNaming_NamedShapeDriver::GetShapesLocations),
             R"#(get the format of topology)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMNaming_NamedShapeDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMNaming_NamedShapeDriver::*)() const>(&XmlMNaming_NamedShapeDriver::DynamicType),
             R"#()#"
             
         )
       .def("GetShapesLocations",
             (TopTools_LocationSet & (XmlMNaming_NamedShapeDriver::*)() ) static_cast<TopTools_LocationSet & (XmlMNaming_NamedShapeDriver::*)() >(&XmlMNaming_NamedShapeDriver::GetShapesLocations),
             R"#(get the format of topology)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class XmlMNaming_NamingDriver from ./opencascade/XmlMNaming_NamingDriver.hxx
    klass = m.attr("XmlMNaming_NamingDriver");


    // nested enums

    static_cast<py::class_<XmlMNaming_NamingDriver ,opencascade::handle<XmlMNaming_NamingDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("aMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMNaming_NamingDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMNaming_NamingDriver::*)() const>(&XmlMNaming_NamingDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMNaming_NamingDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMNaming_NamingDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMNaming_NamingDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
        .def("Paste",
             (void (XmlMNaming_NamingDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMNaming_NamingDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMNaming_NamingDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMNaming_NamingDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMNaming_NamingDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMNaming_NamingDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMNaming_NamingDriver::*)() const>(&XmlMNaming_NamingDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMNaming_Shape1 from ./opencascade/XmlMNaming_Shape1.hxx
    klass = m.attr("XmlMNaming_Shape1");


    // nested enums

    static_cast<py::class_<XmlMNaming_Shape1 , shared_ptr<XmlMNaming_Shape1>  >>(klass)
    // constructors
        .def(py::init< XmlObjMgt_Document & >()  , py::arg("Doc") )
        .def(py::init<  const XmlObjMgt_Element & >()  , py::arg("E") )
    // custom constructors
    // methods
        .def("TShapeId",
             (Standard_Integer (XmlMNaming_Shape1::*)() const) static_cast<Standard_Integer (XmlMNaming_Shape1::*)() const>(&XmlMNaming_Shape1::TShapeId),
             R"#()#" 
          )
        .def("LocId",
             (Standard_Integer (XmlMNaming_Shape1::*)() const) static_cast<Standard_Integer (XmlMNaming_Shape1::*)() const>(&XmlMNaming_Shape1::LocId),
             R"#()#" 
          )
        .def("Orientation",
             (TopAbs_Orientation (XmlMNaming_Shape1::*)() const) static_cast<TopAbs_Orientation (XmlMNaming_Shape1::*)() const>(&XmlMNaming_Shape1::Orientation),
             R"#()#" 
          )
        .def("SetShape",
             (void (XmlMNaming_Shape1::*)(  const Standard_Integer ,   const Standard_Integer ,   const TopAbs_Orientation  ) ) static_cast<void (XmlMNaming_Shape1::*)(  const Standard_Integer ,   const Standard_Integer ,   const TopAbs_Orientation  ) >(&XmlMNaming_Shape1::SetShape),
             R"#()#"  , py::arg("ID"),  py::arg("LocID"),  py::arg("Orient")
          )
        .def("SetVertex",
             (void (XmlMNaming_Shape1::*)(  const TopoDS_Shape &  ) ) static_cast<void (XmlMNaming_Shape1::*)(  const TopoDS_Shape &  ) >(&XmlMNaming_Shape1::SetVertex),
             R"#()#"  , py::arg("theVertex")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Element",
             ( const XmlObjMgt_Element & (XmlMNaming_Shape1::*)() const) static_cast< const XmlObjMgt_Element & (XmlMNaming_Shape1::*)() const>(&XmlMNaming_Shape1::Element),
             R"#(return myElement)#"
             
         )
       .def("Element",
             (XmlObjMgt_Element & (XmlMNaming_Shape1::*)() ) static_cast<XmlObjMgt_Element & (XmlMNaming_Shape1::*)() >(&XmlMNaming_Shape1::Element),
             R"#(return myElement)#"
             
             , py::return_value_policy::reference_internal
         )
;

// functions

// ./opencascade/XmlMNaming.hxx
// ./opencascade/XmlMNaming_NamedShapeDriver.hxx
// ./opencascade/XmlMNaming_NamingDriver.hxx
// ./opencascade/XmlMNaming_Shape1.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
