
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>

// module includes
#include <XmlXCAFDrivers.hxx>
#include <XmlXCAFDrivers_DocumentRetrievalDriver.hxx>
#include <XmlXCAFDrivers_DocumentStorageDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XmlXCAFDrivers(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XmlXCAFDrivers"));
py::object klass;

//Python trampoline classes

// classes

    // Class XmlXCAFDrivers from ./opencascade/XmlXCAFDrivers.hxx
    klass = m.attr("XmlXCAFDrivers");

    // default constructor
    register_default_constructor<XmlXCAFDrivers , shared_ptr<XmlXCAFDrivers>>(m,"XmlXCAFDrivers");

    // nested enums

    static_cast<py::class_<XmlXCAFDrivers , shared_ptr<XmlXCAFDrivers>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Factory_s",
                    ( const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) ) static_cast< const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) >(&XmlXCAFDrivers::Factory),
                    R"#(Depending from the ID, returns a list of storage or retrieval attribute drivers. Used for plugin.)#"  , py::arg("aGUID")
          )
        .def_static("DefineFormat_s",
                    (void (*)(  const handle<TDocStd_Application> &  ) ) static_cast<void (*)(  const handle<TDocStd_Application> &  ) >(&XmlXCAFDrivers::DefineFormat),
                    R"#(Defines format "XmlXCAF" and registers its read and write drivers in the specified application)#"  , py::arg("theApp")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XmlXCAFDrivers_DocumentRetrievalDriver from ./opencascade/XmlXCAFDrivers_DocumentRetrievalDriver.hxx
    klass = m.attr("XmlXCAFDrivers_DocumentRetrievalDriver");


    // nested enums

    static_cast<py::class_<XmlXCAFDrivers_DocumentRetrievalDriver ,opencascade::handle<XmlXCAFDrivers_DocumentRetrievalDriver>  , XmlDrivers_DocumentRetrievalDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<XmlMDF_ADriverTable> (XmlXCAFDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<XmlMDF_ADriverTable> (XmlXCAFDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) >(&XmlXCAFDrivers_DocumentRetrievalDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlXCAFDrivers_DocumentRetrievalDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlXCAFDrivers_DocumentRetrievalDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlXCAFDrivers_DocumentRetrievalDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlXCAFDrivers_DocumentRetrievalDriver::*)() const>(&XmlXCAFDrivers_DocumentRetrievalDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlXCAFDrivers_DocumentStorageDriver from ./opencascade/XmlXCAFDrivers_DocumentStorageDriver.hxx
    klass = m.attr("XmlXCAFDrivers_DocumentStorageDriver");


    // nested enums

    static_cast<py::class_<XmlXCAFDrivers_DocumentStorageDriver ,opencascade::handle<XmlXCAFDrivers_DocumentStorageDriver>  , XmlDrivers_DocumentStorageDriver >>(klass)
    // constructors
        .def(py::init<  const TCollection_ExtendedString & >()  , py::arg("theCopyright") )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<XmlMDF_ADriverTable> (XmlXCAFDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<XmlMDF_ADriverTable> (XmlXCAFDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) >(&XmlXCAFDrivers_DocumentStorageDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlXCAFDrivers_DocumentStorageDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlXCAFDrivers_DocumentStorageDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlXCAFDrivers_DocumentStorageDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlXCAFDrivers_DocumentStorageDriver::*)() const>(&XmlXCAFDrivers_DocumentStorageDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/XmlXCAFDrivers.hxx
// ./opencascade/XmlXCAFDrivers_DocumentRetrievalDriver.hxx
// ./opencascade/XmlXCAFDrivers_DocumentStorageDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
