
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>

// module includes
#include <XmlXCAFDrivers.hxx>
#include <XmlXCAFDrivers_DocumentRetrievalDriver.hxx>
#include <XmlXCAFDrivers_DocumentStorageDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XmlXCAFDrivers_enums(py::module &main_module) {


py::module m = main_module.def_submodule("XmlXCAFDrivers", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<XmlXCAFDrivers , shared_ptr<XmlXCAFDrivers>  >(m,"XmlXCAFDrivers",R"#()#");
    py::class_<XmlXCAFDrivers_DocumentRetrievalDriver ,opencascade::handle<XmlXCAFDrivers_DocumentRetrievalDriver>  , XmlDrivers_DocumentRetrievalDriver >(m,"XmlXCAFDrivers_DocumentRetrievalDriver",R"#(retrieval driver of a XS documentretrieval driver of a XS documentretrieval driver of a XS document)#");
    py::class_<XmlXCAFDrivers_DocumentStorageDriver ,opencascade::handle<XmlXCAFDrivers_DocumentStorageDriver>  , XmlDrivers_DocumentStorageDriver >(m,"XmlXCAFDrivers_DocumentStorageDriver",R"#(storage driver of a XS documentstorage driver of a XS documentstorage driver of a XS document)#");

};

// user-defined post-inclusion per module

// user-defined post
