<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Bundle\SecurityBundle\Tests\DependencyInjection;

use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\IgnoreDeprecations;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

#[IgnoreDeprecations]
#[Group('legacy')]
class XmlCompleteConfigurationTest extends CompleteConfigurationTestCase
{
    public function testFirewallPatterns()
    {
        $this->markTestSkipped('This features is not supported in XML.');
    }

    protected function getLoader(ContainerBuilder $container)
    {
        return new XmlFileLoader($container, new FileLocator(__DIR__.'/Fixtures/xml'));
    }

    protected function getFileExtension()
    {
        return 'xml';
    }
}
