package ONVIF::Device::Types::PTZPresetTourPresetDetailOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %PresetToken_of :ATTR(:get<PresetToken>);
my %Home_of :ATTR(:get<Home>);
my %PanTiltPositionSpace_of :ATTR(:get<PanTiltPositionSpace>);
my %ZoomPositionSpace_of :ATTR(:get<ZoomPositionSpace>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        PresetToken
        Home
        PanTiltPositionSpace
        ZoomPositionSpace
        Extension

    ) ],
    {
        'PresetToken' => \%PresetToken_of,
        'Home' => \%Home_of,
        'PanTiltPositionSpace' => \%PanTiltPositionSpace_of,
        'ZoomPositionSpace' => \%ZoomPositionSpace_of,
        'Extension' => \%Extension_of,
    },
    {
        'PresetToken' => 'ONVIF::Device::Types::ReferenceToken',
        'Home' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'PanTiltPositionSpace' => 'ONVIF::Device::Types::Space2DDescription',
        'ZoomPositionSpace' => 'ONVIF::Device::Types::Space1DDescription',
        'Extension' => 'ONVIF::Device::Types::PTZPresetTourPresetDetailOptionsExtension',
    },
    {

        'PresetToken' => 'PresetToken',
        'Home' => 'Home',
        'PanTiltPositionSpace' => 'PanTiltPositionSpace',
        'ZoomPositionSpace' => 'ZoomPositionSpace',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::PTZPresetTourPresetDetailOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PTZPresetTourPresetDetailOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PresetToken


=item * Home


=item * PanTiltPositionSpace


=item * ZoomPositionSpace


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::PTZPresetTourPresetDetailOptions
   PresetToken => $some_value, # ReferenceToken
   Home =>  $some_value, # boolean
   PanTiltPositionSpace =>  { # ONVIF::Device::Types::Space2DDescription
     URI =>  $some_value, # anyURI
     XRange =>  { # ONVIF::Device::Types::FloatRange
       Min =>  $some_value, # float
       Max =>  $some_value, # float
     },
     YRange =>  { # ONVIF::Device::Types::FloatRange
       Min =>  $some_value, # float
       Max =>  $some_value, # float
     },
   },
   ZoomPositionSpace =>  { # ONVIF::Device::Types::Space1DDescription
     URI =>  $some_value, # anyURI
     XRange =>  { # ONVIF::Device::Types::FloatRange
       Min =>  $some_value, # float
       Max =>  $some_value, # float
     },
   },
   Extension =>  { # ONVIF::Device::Types::PTZPresetTourPresetDetailOptionsExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

